!{\src2tex{textfont=tt}}
!!****f* ABINIT/ylmc
!! NAME
!! ylmc
!!
!! FUNCTION
!!  Calculate all (complex) spherical harmonics for il<=3
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2007 ABINIT group (FB, MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  il=angular quantum number
!!  im=magnetic quantum number
!!  kcart=vector in cartesian coordinates defining the value of \theta and \psi
!!   where calculate the spherical harmonic
!!
!! OUTPUT
!!  ylm= spherical harmonic
!!
!! SIDE EFFECTS
!!
!! NOTES
!!  Using double precision complex even thou it does not conform the ABINIT
!!  convention
!! PARENTS
!!
!!
!! CHILDREN
!!
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

 function ylmc(il,im,kcart)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: il,im
 complex(dpc) :: ylmc
!arrays
 real(dp),intent(in) :: kcart(3)

!Local variables-------------------------------
!scalars
 integer,parameter :: lx=3
 real(dp),parameter :: pad=tol8
 real(dp) :: cosphi,costh,costhreephi,costwophi,r,rxy,sinphi,sinth,sinthreephi
 real(dp) :: sintwophi
 character(len=500) :: message

! *************************************************************************

 if(il<0)then
  write(message,'(a,a,a,a,a,a,i6)') ch10,&
&  ' ylmc: ERROR -',ch10,&
&  '  The argument l should be positive,',ch10,&
&  '  however, l=',il
  call wrtout(std_out,message,'COLL')
  call leave_new('COLL')
 end if
 if(il>lx)then
  write(message,'(a,a,a,a,i6,a,a,i6)') ch10,&
&  ' ylmc: ERROR -',ch10,&
&  '  The maximum allowed value for l is,',lx,ch10,&
&  '  however, l=',il
  call wrtout(std_out,message,'COLL')
  call leave_new('COLL')
 end if
 if(abs(im)>abs(il))then
  write(message,'(4a,i6,2a,i6,a,i6)') ch10,&
&  ' ylmc: ERROR -',ch10,&
&  '  m is,',im,ch10,&
&  '  however it should be between ',-il,' and ',il
  call wrtout(std_out,message,'COLL')
  call leave_new('COLL')
 end if

 r=sqrt(kcart(1)**2+kcart(2)**2+kcart(3)**2)
 if(r<pad)r=r+pad
 rxy=sqrt(kcart(1)**2+kcart(2)**2)
 if(rxy<pad)rxy=r+pad

 !(th,phi) spherical coordinates
 costh= kcart(3)/r
 sinth= rxy/r
 cosphi= kcart(1)/rxy
 sinphi= kcart(2)/rxy
 costwophi= 2.d0*cosphi**2 - 1.d0
 sintwophi= 2.d0*sinphi*cosphi
 costhreephi=cosphi*costwophi-sinphi*sintwophi
 sinthreephi=cosphi*sintwophi+sinphi*costwophi

 if (il==0) then
  ylmc= 1.d0 / sqrt(4.d0*pi)
 else if (il==1) then
  if (abs(im)==0) then
   ylmc = sqrt(3.d0/(4.d0*pi))*costh
  else if (abs(im)==1) then
   ylmc = -sqrt(3.d0/(8.d0*pi))*sinth*cmplx(cosphi,sinphi)
  end if
 else if (il==2) then
  if (abs(im)==0) then
   ylmc = sqrt(5.d0/(16.d0*pi))*(3.d0*costh**2-1.d0)
  else if (abs(im)==1) then
   ylmc = -sqrt(15.d0/(8.d0*pi))*sinth*costh*cmplx(cosphi,sinphi)
  else if (abs(im)==2) then
   ylmc = sqrt(15.d0/(32.d0*pi))*(sinth)**2*cmplx(costwophi,sintwophi)
  end if
 else if (il==3) then
  if (abs(im)==0) then
   ylmc= sqrt(7.d0/(16.d0*pi))*(5.d0*costh**3 -3.d0*costh)
  else if (abs(im)==1) then
   ylmc= -sqrt(21.d0/(64.d0*pi))*sinth*(5.d0*costh**2-1)*cmplx(cosphi,sinphi)
  else if (abs(im)==2) then
   ylmc= sqrt(105.d0/(32.d0*pi))*sinth**2*costh*cmplx(costwophi,sintwophi)
  else if (abs(im)==3) then
   ylmc=-sqrt(35.d0/(64.d0*pi))*sinth**3*cmplx(costhreephi,sinthreephi)
  end if
 end if

 !treats the case im < 0
 if (im < 0) then
  ylmc=(-1.d0)**(im)*conjg(ylmc)
 end if

end function ylmc
!!***
