/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection;

import com.github.andrewoma.dexx.collection.Builder;
import com.github.andrewoma.dexx.collection.BuilderFactory;
import com.github.andrewoma.dexx.collection.Function;
import com.github.andrewoma.dexx.collection.KeyFunction;
import com.github.andrewoma.dexx.collection.Pair;
import com.github.andrewoma.dexx.collection.internal.base.AbstractMap;
import com.github.andrewoma.dexx.collection.internal.builder.AbstractSelfBuilder;
import com.github.andrewoma.dexx.collection.internal.hashmap.CompactHashMap;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HashMap<K, V>
extends AbstractMap<K, V> {
    private static final HashMap EMPTY = new HashMap();
    private static final KeyFunction keyFunction = new KeyFunction<Object, Pair>(){

        @Override
        @NotNull
        public Object key(@NotNull Pair value) {
            return value.component1();
        }
    };
    private final CompactHashMap<K, Pair<K, V>> compactHashMap;

    @NotNull
    public static <K, V> HashMap<K, V> empty() {
        return EMPTY;
    }

    @NotNull
    public static <K, V> BuilderFactory<Pair<K, V>, HashMap<K, V>> factory() {
        return new BuilderFactory<Pair<K, V>, HashMap<K, V>>(){

            @Override
            @NotNull
            public Builder<Pair<K, V>, HashMap<K, V>> newBuilder() {
                return new AbstractSelfBuilder<Pair<K, V>, HashMap<K, V>>(HashMap.empty()){

                    @Override
                    @NotNull
                    public Builder<Pair<K, V>, HashMap<K, V>> add(Pair<K, V> element) {
                        this.result = ((HashMap)this.result).put(element.component1(), element.component2());
                        return this;
                    }
                };
            }
        };
    }

    private KeyFunction<K, Pair<K, V>> keyFunction() {
        return keyFunction;
    }

    @Override
    public boolean containsKey(@NotNull K key) {
        return this.compactHashMap.get(key, this.keyFunction()) != null;
    }

    public HashMap() {
        this(CompactHashMap.empty());
    }

    private HashMap(CompactHashMap<K, Pair<K, V>> compactHashMap) {
        this.compactHashMap = compactHashMap;
    }

    @Override
    @NotNull
    public HashMap<K, V> put(@NotNull K key, V value) {
        return new HashMap<K, V>(this.compactHashMap.put(key, new Pair<K, V>(key, value), this.keyFunction()));
    }

    @Override
    @Nullable
    public V get(@NotNull K key) {
        Pair<K, V> pair = this.compactHashMap.get(key, this.keyFunction());
        return pair == null ? null : (V)pair.component2();
    }

    @Override
    @NotNull
    public HashMap<K, V> remove(@NotNull K key) {
        return new HashMap<K, V>(this.compactHashMap.remove(key, this.keyFunction()));
    }

    @Override
    public int size() {
        return this.compactHashMap.size();
    }

    @Override
    public <U> void forEach(final @NotNull Function<Pair<K, V>, U> f) {
        this.compactHashMap.forEach(new Function<Pair<K, Pair<K, V>>, Object>(){

            @Override
            public Object invoke(Pair<K, Pair<K, V>> pair) {
                f.invoke(pair.component2());
                return null;
            }
        }, this.keyFunction());
    }

    @Override
    @NotNull
    public Iterator<Pair<K, V>> iterator() {
        return new Itr<K, V>(this.compactHashMap.iterator(this.keyFunction()));
    }

    static class Itr<K, V>
    implements Iterator<Pair<K, V>> {
        final Iterator<Pair<K, Pair<K, V>>> iterator;

        public Itr(Iterator<Pair<K, Pair<K, V>>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Pair<K, V> next() {
            Pair<K, Pair<K, V>> next = this.iterator.next();
            return next.component2();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

