CREATE UNIQUE INDEX SESSION.FOO_IDX ON SESSION.FOO(column1)
COMPRESS YES
ALLOW REVERSE SCANS;

CREATE UNIQUE INDEX UNIQUE_NAME
ON PROJECT (PROJNAME);

CREATE INDEX JOB_BY_DPT
ON EMPLOYEE (WORKDEPT, JOB);

CREATE INDEX JOB_BY_DPT_NME
ON EMPLOYEE (WORKDEPT, JOB DESC, NAME RANDOM);

CREATE UNIQUE INDEX JOB_BY_DEPT
ON EMPLOYEE (WORKDEPT, JOB)
SPECIFICATION ONLY;

CREATE INDEX SPATIAL_INDEX ON CUSTOMER (LOCATION)
EXTEND USING (GRID_EXTENSION (x'000100100010001000400010'));

CREATE INDEX IDX1 ON TAB1 (COL1) COLLECT STATISTICS;

CREATE INDEX IDX2 ON TAB1 (COL2) COLLECT DETAILED STATISTICS;

CREATE INDEX IDX3 ON TAB1 (COL3) COLLECT SAMPLED DETAILED STATISTICS;

CREATE UNIQUE INDEX A_IDX ON MYNUMBERDATA (A) IN IDX_TBSP;

CREATE UNIQUE INDEX TIME_IDX
ON MYNUMBERDATA (A, BUSINESS_TIME WITHOUT OVERLAPS);

CREATE INDEX B_IDX ON MYNUMBERDATA (B)
NOT PARTITIONED IN IDX_TBSP;

CREATE INDEX EMPINDEX ON COMPANYINFO (COMPANYDOCS)
GENERATE KEY USING XMLPATTERN '/company/emp/@id'
AS SQL DOUBLE;

CREATE INDEX EMPINDEX ON COMPANYINFO (COMPANYDOCS)
GENERATE KEY USING XMLPATTERN '/child::company/child::emp/attribute::id'
AS SQL DOUBLE;

CREATE UNIQUE INDEX MYDOCSIDX ON MYDOCS (DOC)
GENERATE KEY USING XMLPATTERN '/book/title'
AS SQL VARCHAR(100);

CREATE INDEX MYDOCSIDX ON MYDOCS (DOC)
GENERATE KEY USING XMLPATTERN
'declare namespace b="http://www.example.com/book/";
     declare namespace c="http://acme.org/chapters";
       /b:book/c:chapter/@number'
AS SQL DOUBLE;

CREATE UNIQUE INDEX IDXPROJEST ON PROJECT (PROJNO) INCLUDE (PRSTAFF);

CREATE UNIQUE INDEX IDXUSERID ON CUSTOMER (USER_ID) EXCLUDE NULL KEYS;

CREATE INDEX EMP_UPPERNAME ON EMPLOYEE (UPPER(NAME), ID);

CREATE INDEX EMP_PCT ON EMPLOYEE (ID)
PCTFREE 10
LEVEL2 PCTFREE 20
PAGE SPLIT SYMMETRIC;

CREATE INDEX EMP_CLUSTER ON EMPLOYEE (ID) CLUSTER;
