#### **Did you find a bug in MRPT?**
  * **Ensure it is not already** reported by searching: 
    * The [issues list](https://github.com/MRPT/mrpt/issues), 
    * The [mailing list](https://groups.google.com/forum/#!forum/mrpt-users) and 
    * [Solved questions at stackoverflow.com](http://stackoverflow.com/search?q=mrpt)

#### **Do you want to contribute new code to MRPT?**

  * Please, **read carefully** the [C++ coding style for MRPT](https://github.com/MRPT/mrpt/blob/master/doc/MRPT_Coding_Style.md).
  * Make sure to be familiar with Git, branches, etc. A starting tutorial can be found [here](http://git-scm.com/docs/gittutorial)
  * Fork in GitHub.
  * Optionally, create a new branch with a descriptive name and work on it instead of the default `master` branch.
  * Send commits to your fork as needed:
    * Commit often. 
    * Small commits with a good log description are preferred.
  * **Verify that your code builds**, at least in one the major supported compilers: MSVC, GCC, CLANG.
  * Most changes are relevant enough to be shown in the [CHANGELOG](https://github.com/MRPT/mrpt/blob/master/doc/doxygen-pages/changeLog_doc.h). Modify it as well to reflect what is new.
  * Open a pull-request.

