#ifndef GUARD_PRECALC_XORWOW_SKIPAHEAD_MATRICES_KERNEL_H
#define GUARD_PRECALC_XORWOW_SKIPAHEAD_MATRICES_KERNEL_H

#define XORWOW_DIM 5
#define XORWOW_BITS 32
#define XORWOW_PRECALC_MATRICES_SZ (XORWOW_BITS * XORWOW_DIM * XORWOW_DIM)
#define XORWOW_PRECALC_MATRICES_NUM 64
#define XORWOW_JUMP_LOG2 1
#define XORWOW_JUMP_LOG2_MASK ((1 << XORWOW_JUMP_LOG2) - 1)
#define XORWOW_SEQUENCE_JUMP_LOG2 67

static __constant unsigned int
    precalc_xorwow_skipahead_matrices[XORWOW_PRECALC_MATRICES_NUM][XORWOW_PRECALC_MATRICES_SZ] = {
        {
            0,          0,          0,          0,          3,          0,          0,
            0,          0,          6,          0,          0,          0,          0,
            15,         0,          0,          0,          0,          30,         0,
            0,          0,          0,          60,         0,          0,          0,
            0,          120,        0,          0,          0,          0,          240,
            0,          0,          0,          0,          480,        0,          0,
            0,          0,          960,        0,          0,          0,          0,
            1920,       0,          0,          0,          0,          3840,       0,
            0,          0,          0,          7680,       0,          0,          0,
            0,          15360,      0,          0,          0,          0,          30720,
            0,          0,          0,          0,          61440,      0,          0,
            0,          0,          122880,     0,          0,          0,          0,
            245760,     0,          0,          0,          0,          491520,     0,
            0,          0,          0,          983040,     0,          0,          0,
            0,          1966080,    0,          0,          0,          0,          3932160,
            0,          0,          0,          0,          7864320,    0,          0,
            0,          0,          15728640,   0,          0,          0,          0,
            31457280,   0,          0,          0,          0,          62914560,   0,
            0,          0,          0,          125829120,  0,          0,          0,
            0,          251658240,  0,          0,          0,          0,          503316480,
            0,          0,          0,          0,          1006632960, 0,          0,
            0,          0,          2013265920, 0,          0,          0,          0,
            4026531840, 0,          0,          0,          0,          3758096384, 1,
            0,          0,          0,          0,          2,          0,          0,
            0,          0,          4,          0,          0,          0,          0,
            8,          0,          0,          0,          0,          16,         0,
            0,          0,          0,          32,         0,          0,          0,
            0,          64,         0,          0,          0,          0,          128,
            0,          0,          0,          0,          256,        0,          0,
            0,          0,          512,        0,          0,          0,          0,
            1024,       0,          0,          0,          0,          2048,       0,
            0,          0,          0,          4096,       0,          0,          0,
            0,          8192,       0,          0,          0,          0,          16384,
            0,          0,          0,          0,          32768,      0,          0,
            0,          0,          65536,      0,          0,          0,          0,
            131072,     0,          0,          0,          0,          262144,     0,
            0,          0,          0,          524288,     0,          0,          0,
            0,          1048576,    0,          0,          0,          0,          2097152,
            0,          0,          0,          0,          4194304,    0,          0,
            0,          0,          8388608,    0,          0,          0,          0,
            16777216,   0,          0,          0,          0,          33554432,   0,
            0,          0,          0,          67108864,   0,          0,          0,
            0,          134217728,  0,          0,          0,          0,          268435456,
            0,          0,          0,          0,          536870912,  0,          0,
            0,          0,          1073741824, 0,          0,          0,          0,
            2147483648, 0,          0,          0,          0,          0,          1,
            0,          0,          0,          0,          2,          0,          0,
            0,          0,          4,          0,          0,          0,          0,
            8,          0,          0,          0,          0,          16,         0,
            0,          0,          0,          32,         0,          0,          0,
            0,          64,         0,          0,          0,          0,          128,
            0,          0,          0,          0,          256,        0,          0,
            0,          0,          512,        0,          0,          0,          0,
            1024,       0,          0,          0,          0,          2048,       0,
            0,          0,          0,          4096,       0,          0,          0,
            0,          8192,       0,          0,          0,          0,          16384,
            0,          0,          0,          0,          32768,      0,          0,
            0,          0,          65536,      0,          0,          0,          0,
            131072,     0,          0,          0,          0,          262144,     0,
            0,          0,          0,          524288,     0,          0,          0,
            0,          1048576,    0,          0,          0,          0,          2097152,
            0,          0,          0,          0,          4194304,    0,          0,
            0,          0,          8388608,    0,          0,          0,          0,
            16777216,   0,          0,          0,          0,          33554432,   0,
            0,          0,          0,          67108864,   0,          0,          0,
            0,          134217728,  0,          0,          0,          0,          268435456,
            0,          0,          0,          0,          536870912,  0,          0,
            0,          0,          1073741824, 0,          0,          0,          0,
            2147483648, 0,          0,          0,          0,          0,          1,
            0,          0,          0,          0,          2,          0,          0,
            0,          0,          4,          0,          0,          0,          0,
            8,          0,          0,          0,          0,          16,         0,
            0,          0,          0,          32,         0,          0,          0,
            0,          64,         0,          0,          0,          0,          128,
            0,          0,          0,          0,          256,        0,          0,
            0,          0,          512,        0,          0,          0,          0,
            1024,       0,          0,          0,          0,          2048,       0,
            0,          0,          0,          4096,       0,          0,          0,
            0,          8192,       0,          0,          0,          0,          16384,
            0,          0,          0,          0,          32768,      0,          0,
            0,          0,          65536,      0,          0,          0,          0,
            131072,     0,          0,          0,          0,          262144,     0,
            0,          0,          0,          524288,     0,          0,          0,
            0,          1048576,    0,          0,          0,          0,          2097152,
            0,          0,          0,          0,          4194304,    0,          0,
            0,          0,          8388608,    0,          0,          0,          0,
            16777216,   0,          0,          0,          0,          33554432,   0,
            0,          0,          0,          67108864,   0,          0,          0,
            0,          134217728,  0,          0,          0,          0,          268435456,
            0,          0,          0,          0,          536870912,  0,          0,
            0,          0,          1073741824, 0,          0,          0,          0,
            2147483648, 0,          0,          0,          0,          0,          1,
            17,         0,          0,          0,          2,          34,         0,
            0,          0,          4,          68,         0,          0,          0,
            8,          136,        0,          0,          0,          16,         272,
            0,          0,          0,          32,         544,        0,          0,
            0,          64,         1088,       0,          0,          0,          128,
            2176,       0,          0,          0,          256,        4352,       0,
            0,          0,          512,        8704,       0,          0,          0,
            1024,       17408,      0,          0,          0,          2048,       34816,
            0,          0,          0,          4096,       69632,      0,          0,
            0,          8192,       139264,     0,          0,          0,          16384,
            278528,     0,          0,          0,          32768,      557056,     0,
            0,          0,          65536,      1114112,    0,          0,          0,
            131072,     2228224,    0,          0,          0,          262144,     4456448,
            0,          0,          0,          524288,     8912896,    0,          0,
            0,          1048576,    17825792,   0,          0,          0,          2097152,
            35651584,   0,          0,          0,          4194304,    71303168,   0,
            0,          0,          8388608,    142606336,  0,          0,          0,
            16777216,   285212672,  0,          0,          0,          33554432,   570425344,
            0,          0,          0,          67108864,   1140850688, 0,          0,
            0,          134217728,  2281701376, 0,          0,          0,          268435456,
            268435456,  0,          0,          0,          536870912,  536870912,  0,
            0,          0,          1073741824, 1073741824, 0,          0,          0,
            2147483648, 2147483648,
        },
        {
            0,          0,          0,          3,          51,         0,          0,
            0,          6,          102,        0,          0,          0,          15,
            255,        0,          0,          0,          30,         510,        0,
            0,          0,          60,         1020,       0,          0,          0,
            120,        2040,       0,          0,          0,          240,        4080,
            0,          0,          0,          480,        8160,       0,          0,
            0,          960,        16320,      0,          0,          0,          1920,
            32640,      0,          0,          0,          3840,       65280,      0,
            0,          0,          7680,       130560,     0,          0,          0,
            15360,      261120,     0,          0,          0,          30720,      522240,
            0,          0,          0,          61440,      1044480,    0,          0,
            0,          122880,     2088960,    0,          0,          0,          245760,
            4177920,    0,          0,          0,          491520,     8355840,    0,
            0,          0,          983040,     16711680,   0,          0,          0,
            1966080,    33423360,   0,          0,          0,          3932160,    66846720,
            0,          0,          0,          7864320,    133693440,  0,          0,
            0,          15728640,   267386880,  0,          0,          0,          31457280,
            534773760,  0,          0,          0,          62914560,   1069547520, 0,
            0,          0,          125829120,  2139095040, 0,          0,          0,
            251658240,  4278190080, 0,          0,          0,          503316480,  4261412864,
            0,          0,          0,          1006632960, 4227858432, 0,          0,
            0,          2013265920, 4160749568, 0,          0,          0,          4026531840,
            4026531840, 0,          0,          0,          3758096384, 3758096384, 0,
            0,          0,          0,          3,          0,          0,          0,
            0,          6,          0,          0,          0,          0,          15,
            0,          0,          0,          0,          30,         0,          0,
            0,          0,          60,         0,          0,          0,          0,
            120,        0,          0,          0,          0,          240,        0,
            0,          0,          0,          480,        0,          0,          0,
            0,          960,        0,          0,          0,          0,          1920,
            0,          0,          0,          0,          3840,       0,          0,
            0,          0,          7680,       0,          0,          0,          0,
            15360,      0,          0,          0,          0,          30720,      0,
            0,          0,          0,          61440,      0,          0,          0,
            0,          122880,     0,          0,          0,          0,          245760,
            0,          0,          0,          0,          491520,     0,          0,
            0,          0,          983040,     0,          0,          0,          0,
            1966080,    0,          0,          0,          0,          3932160,    0,
            0,          0,          0,          7864320,    0,          0,          0,
            0,          15728640,   0,          0,          0,          0,          31457280,
            0,          0,          0,          0,          62914560,   0,          0,
            0,          0,          125829120,  0,          0,          0,          0,
            251658240,  0,          0,          0,          0,          503316480,  0,
            0,          0,          0,          1006632960, 0,          0,          0,
            0,          2013265920, 0,          0,          0,          0,          4026531840,
            0,          0,          0,          0,          3758096384, 1,          0,
            0,          0,          0,          2,          0,          0,          0,
            0,          4,          0,          0,          0,          0,          8,
            0,          0,          0,          0,          16,         0,          0,
            0,          0,          32,         0,          0,          0,          0,
            64,         0,          0,          0,          0,          128,        0,
            0,          0,          0,          256,        0,          0,          0,
            0,          512,        0,          0,          0,          0,          1024,
            0,          0,          0,          0,          2048,       0,          0,
            0,          0,          4096,       0,          0,          0,          0,
            8192,       0,          0,          0,          0,          16384,      0,
            0,          0,          0,          32768,      0,          0,          0,
            0,          65536,      0,          0,          0,          0,          131072,
            0,          0,          0,          0,          262144,     0,          0,
            0,          0,          524288,     0,          0,          0,          0,
            1048576,    0,          0,          0,          0,          2097152,    0,
            0,          0,          0,          4194304,    0,          0,          0,
            0,          8388608,    0,          0,          0,          0,          16777216,
            0,          0,          0,          0,          33554432,   0,          0,
            0,          0,          67108864,   0,          0,          0,          0,
            134217728,  0,          0,          0,          0,          268435456,  0,
            0,          0,          0,          536870912,  0,          0,          0,
            0,          1073741824, 0,          0,          0,          0,          2147483648,
            0,          0,          0,          0,          0,          1,          0,
            0,          0,          0,          2,          0,          0,          0,
            0,          4,          0,          0,          0,          0,          8,
            0,          0,          0,          0,          16,         0,          0,
            0,          0,          32,         0,          0,          0,          0,
            64,         0,          0,          0,          0,          128,        0,
            0,          0,          0,          256,        0,          0,          0,
            0,          512,        0,          0,          0,          0,          1024,
            0,          0,          0,          0,          2048,       0,          0,
            0,          0,          4096,       0,          0,          0,          0,
            8192,       0,          0,          0,          0,          16384,      0,
            0,          0,          0,          32768,      0,          0,          0,
            0,          65536,      0,          0,          0,          0,          131072,
            0,          0,          0,          0,          262144,     0,          0,
            0,          0,          524288,     0,          0,          0,          0,
            1048576,    0,          0,          0,          0,          2097152,    0,
            0,          0,          0,          4194304,    0,          0,          0,
            0,          8388608,    0,          0,          0,          0,          16777216,
            0,          0,          0,          0,          33554432,   0,          0,
            0,          0,          67108864,   0,          0,          0,          0,
            134217728,  0,          0,          0,          0,          268435456,  0,
            0,          0,          0,          536870912,  0,          0,          0,
            0,          1073741824, 0,          0,          0,          0,          2147483648,
            0,          0,          0,          0,          0,          1,          17,
            257,        0,          0,          2,          34,         514,        0,
            0,          4,          68,         1028,       0,          0,          8,
            136,        2056,       0,          0,          16,         272,        4112,
            0,          0,          32,         544,        8224,       0,          0,
            64,         1088,       16448,      0,          0,          128,        2176,
            32896,      0,          0,          256,        4352,       65792,      0,
            0,          512,        8704,       131584,     0,          0,          1024,
            17408,      263168,     0,          0,          2048,       34816,      526336,
            0,          0,          4096,       69632,      1052672,    0,          0,
            8192,       139264,     2105344,    0,          0,          16384,      278528,
            4210688,    0,          0,          32768,      557056,     8421376,    0,
            0,          65536,      1114112,    16842752,   0,          0,          131072,
            2228224,    33685504,   0,          0,          262144,     4456448,    67371008,
            0,          0,          524288,     8912896,    134742016,  0,          0,
            1048576,    17825792,   269484032,  0,          0,          2097152,    35651584,
            538968064,  0,          0,          4194304,    71303168,   1077936128, 0,
            0,          8388608,    142606336,  2155872256, 0,          0,          16777216,
            285212672,  16777216,   0,          0,          33554432,   570425344,  33554432,
            0,          0,          67108864,   1140850688, 67108864,   0,          0,
            134217728,  2281701376, 134217728,  0,          0,          268435456,  268435456,
            268435456,  0,          0,          536870912,  536870912,  536870912,  0,
            0,          1073741824, 1073741824, 1073741824, 0,          0,          2147483648,
            2147483648, 2147483648,
        },
        {
            0,          3,          51,         771,        13107,      0,          6,
            102,        1542,       26214,      0,          15,         255,        3855,
            65535,      0,          30,         510,        7710,       131070,     0,
            60,         1020,       15420,      262140,     0,          120,        2040,
            30840,      524280,     0,          240,        4080,       61680,      1048560,
            0,          480,        8160,       123360,     2097120,    0,          960,
            16320,      246720,     4194240,    0,          1920,       32640,      493440,
            8388480,    0,          3840,       65280,      986880,     16776960,   0,
            7680,       130560,     1973760,    33553920,   0,          15360,      261120,
            3947520,    67107840,   0,          30720,      522240,     7895040,    134215680,
            0,          61440,      1044480,    15790080,   268431360,  0,          122880,
            2088960,    31580160,   536862720,  0,          245760,     4177920,    63160320,
            1073725440, 0,          491520,     8355840,    126320640,  2147450880, 0,
            983040,     16711680,   252641280,  4294901760, 0,          1966080,    33423360,
            505282560,  4294836224, 0,          3932160,    66846720,   1010565120, 4294705152,
            0,          7864320,    133693440,  2021130240, 4294443008, 0,          15728640,
            267386880,  4042260480, 4293918720, 0,          31457280,   534773760,  3789553664,
            4292870144, 0,          62914560,   1069547520, 3284140032, 4290772992, 0,
            125829120,  2139095040, 2273312768, 4286578688, 0,          251658240,  4278190080,
            251658240,  4278190080, 0,          503316480,  4261412864, 503316480,  4261412864,
            0,          1006632960, 4227858432, 1006632960, 4227858432, 0,          2013265920,
            4160749568, 2013265920, 4160749568, 0,          4026531840, 4026531840, 4026531840,
            4026531840, 0,          3758096384, 3758096384, 3758096384, 3758096384, 0,
            0,          3,          51,         771,        0,          0,          6,
            102,        1542,       0,          0,          15,         255,        3855,
            0,          0,          30,         510,        7710,       0,          0,
            60,         1020,       15420,      0,          0,          120,        2040,
            30840,      0,          0,          240,        4080,       61680,      0,
            0,          480,        8160,       123360,     0,          0,          960,
            16320,      246720,     0,          0,          1920,       32640,      493440,
            0,          0,          3840,       65280,      986880,     0,          0,
            7680,       130560,     1973760,    0,          0,          15360,      261120,
            3947520,    0,          0,          30720,      522240,     7895040,    0,
            0,          61440,      1044480,    15790080,   0,          0,          122880,
            2088960,    31580160,   0,          0,          245760,     4177920,    63160320,
            0,          0,          491520,     8355840,    126320640,  0,          0,
            983040,     16711680,   252641280,  0,          0,          1966080,    33423360,
            505282560,  0,          0,          3932160,    66846720,   1010565120, 0,
            0,          7864320,    133693440,  2021130240, 0,          0,          15728640,
            267386880,  4042260480, 0,          0,          31457280,   534773760,  3789553664,
            0,          0,          62914560,   1069547520, 3284140032, 0,          0,
            125829120,  2139095040, 2273312768, 0,          0,          251658240,  4278190080,
            251658240,  0,          0,          503316480,  4261412864, 503316480,  0,
            0,          1006632960, 4227858432, 1006632960, 0,          0,          2013265920,
            4160749568, 2013265920, 0,          0,          4026531840, 4026531840, 4026531840,
            0,          0,          3758096384, 3758096384, 3758096384, 0,          0,
            0,          3,          51,         0,          0,          0,          6,
            102,        0,          0,          0,          15,         255,        0,
            0,          0,          30,         510,        0,          0,          0,
            60,         1020,       0,          0,          0,          120,        2040,
            0,          0,          0,          240,        4080,       0,          0,
            0,          480,        8160,       0,          0,          0,          960,
            16320,      0,          0,          0,          1920,       32640,      0,
            0,          0,          3840,       65280,      0,          0,          0,
            7680,       130560,     0,          0,          0,          15360,      261120,
            0,          0,          0,          30720,      522240,     0,          0,
            0,          61440,      1044480,    0,          0,          0,          122880,
            2088960,    0,          0,          0,          245760,     4177920,    0,
            0,          0,          491520,     8355840,    0,          0,          0,
            983040,     16711680,   0,          0,          0,          1966080,    33423360,
            0,          0,          0,          3932160,    66846720,   0,          0,
            0,          7864320,    133693440,  0,          0,          0,          15728640,
            267386880,  0,          0,          0,          31457280,   534773760,  0,
            0,          0,          62914560,   1069547520, 0,          0,          0,
            125829120,  2139095040, 0,          0,          0,          251658240,  4278190080,
            0,          0,          0,          503316480,  4261412864, 0,          0,
            0,          1006632960, 4227858432, 0,          0,          0,          2013265920,
            4160749568, 0,          0,          0,          4026531840, 4026531840, 0,
            0,          0,          3758096384, 3758096384, 0,          0,          0,
            0,          3,          0,          0,          0,          0,          6,
            0,          0,          0,          0,          15,         0,          0,
            0,          0,          30,         0,          0,          0,          0,
            60,         0,          0,          0,          0,          120,        0,
            0,          0,          0,          240,        0,          0,          0,
            0,          480,        0,          0,          0,          0,          960,
            0,          0,          0,          0,          1920,       0,          0,
            0,          0,          3840,       0,          0,          0,          0,
            7680,       0,          0,          0,          0,          15360,      0,
            0,          0,          0,          30720,      0,          0,          0,
            0,          61440,      0,          0,          0,          0,          122880,
            0,          0,          0,          0,          245760,     0,          0,
            0,          0,          491520,     0,          0,          0,          0,
            983040,     0,          0,          0,          0,          1966080,    0,
            0,          0,          0,          3932160,    0,          0,          0,
            0,          7864320,    0,          0,          0,          0,          15728640,
            0,          0,          0,          0,          31457280,   0,          0,
            0,          0,          62914560,   0,          0,          0,          0,
            125829120,  0,          0,          0,          0,          251658240,  0,
            0,          0,          0,          503316480,  0,          0,          0,
            0,          1006632960, 0,          0,          0,          0,          2013265920,
            0,          0,          0,          0,          4026531840, 0,          0,
            0,          0,          3758096384, 1,          17,         257,        4369,
            65537,      2,          34,         514,        8738,       131074,     4,
            68,         1028,       17476,      262148,     8,          136,        2056,
            34952,      524296,     16,         272,        4112,       69904,      1048592,
            32,         544,        8224,       139808,     2097184,    64,         1088,
            16448,      279616,     4194368,    128,        2176,       32896,      559232,
            8388736,    256,        4352,       65792,      1118464,    16777472,   512,
            8704,       131584,     2236928,    33554944,   1024,       17408,      263168,
            4473856,    67109888,   2048,       34816,      526336,     8947712,    134219776,
            4096,       69632,      1052672,    17895424,   268439552,  8192,       139264,
            2105344,    35790848,   536879104,  16384,      278528,     4210688,    71581696,
            1073758208, 32768,      557056,     8421376,    143163392,  2147516416, 65536,
            1114112,    16842752,   286326784,  65536,      131072,     2228224,    33685504,
            572653568,  131072,     262144,     4456448,    67371008,   1145307136, 262144,
            524288,     8912896,    134742016,  2290614272, 524288,     1048576,    17825792,
            269484032,  286261248,  1048576,    2097152,    35651584,   538968064,  572522496,
            2097152,    4194304,    71303168,   1077936128, 1145044992, 4194304,    8388608,
            142606336,  2155872256, 2290089984, 8388608,    16777216,   285212672,  16777216,
            285212672,  16777216,   33554432,   570425344,  33554432,   570425344,  33554432,
            67108864,   1140850688, 67108864,   1140850688, 67108864,   134217728,  2281701376,
            134217728,  2281701376, 134217728,  268435456,  268435456,  268435456,  268435456,
            268435456,  536870912,  536870912,  536870912,  536870912,  536870912,  1073741824,
            1073741824, 1073741824, 1073741824, 1073741824, 2147483648, 2147483648, 2147483648,
            2147483648, 2147483648,
        },
        {
            13107,      196611,     3342390,    50529047,   858994210,  26214,      393222,
            6684783,    101058078,  1717989239, 65535,      983055,     16711915,   252645147,
            4294962175, 131070,     1966110,    33423829,   505290246,  4294956237, 262140,
            3932220,    66847657,   1010580540, 4294945449, 524280,     7864440,    133695314,
            2021161080, 4294923602, 1048560,    15728880,   267390628,  4042322160, 4294879908,
            2097120,    31457760,   534781256,  3789677024, 4294792520, 4194240,    62915520,
            1069562512, 3284386752, 4294617744, 8388480,    125831040,  2139125024, 2273806208,
            4294268192, 16776960,   251662080,  4278250048, 252645120,  4293569088, 33553920,
            503324160,  4261532800, 505290240,  4292170880, 67107840,   1006648320, 4228098304,
            1010580480, 4289374464, 134215680,  2013296640, 4161229312, 2021160960, 4283781632,
            268431360,  4026593280, 4027491328, 4042321920, 4272595968, 536862720,  3758219264,
            3760015360, 3789676544, 4250224640, 1073725440, 3221471232, 3225063424, 3284385792,
            4205481984, 2147450880, 2147975168, 2155159552, 2273804288, 4115996672, 4294901760,
            983040,     15351808,   252641280,  3937026048, 4294836224, 1966080,    30703616,
            505282560,  3579084800, 4294705152, 3932160,    61407232,   1010565120, 2863202304,
            4294443008, 7864320,    122814464,  2021130240, 1431437312, 4293918720, 15728640,
            245628928,  4042260480, 2862874624, 4292870144, 31457280,   491257856,  3789553664,
            2504523776, 4290772992, 62914560,   982515712,  3284140032, 3935305728, 4286578688,
            125829120,  1965031424, 2273312768, 354418688,  4278190080, 251658240,  3930062848,
            251658240,  3930062848, 4261412864, 503316480,  3565158400, 3724541952, 343932928,
            4227858432, 1006632960, 2835349504, 2080374784, 3909091328, 4160749568, 2013265920,
            1375731712, 939524096,  301989888,  4026531840, 4026531840, 2751463424, 2952790016,
            3825205248, 3758096384, 3758096384, 2281701376, 1610612736, 134217728,  771,
            13107,      196611,     3342390,    50529047,   1542,       26214,      393222,
            6684783,    101058078,  3855,       65535,      983055,     16711915,   252645147,
            7710,       131070,     1966110,    33423829,   505290246,  15420,      262140,
            3932220,    66847657,   1010580540, 30840,      524280,     7864440,    133695314,
            2021161080, 61680,      1048560,    15728880,   267390628,  4042322160, 123360,
            2097120,    31457760,   534781256,  3789677024, 246720,     4194240,    62915520,
            1069562512, 3284386752, 493440,     8388480,    125831040,  2139125024, 2273806208,
            986880,     16776960,   251662080,  4278250048, 252645120,  1973760,    33553920,
            503324160,  4261532800, 505290240,  3947520,    67107840,   1006648320, 4228098304,
            1010580480, 7895040,    134215680,  2013296640, 4161229312, 2021160960, 15790080,
            268431360,  4026593280, 4027491328, 4042321920, 31580160,   536862720,  3758219264,
            3760015360, 3789676544, 63160320,   1073725440, 3221471232, 3225063424, 3284385792,
            126320640,  2147450880, 2147975168, 2155159552, 2273804288, 252641280,  4294901760,
            983040,     15351808,   252641280,  505282560,  4294836224, 1966080,    30703616,
            505282560,  1010565120, 4294705152, 3932160,    61407232,   1010565120, 2021130240,
            4294443008, 7864320,    122814464,  2021130240, 4042260480, 4293918720, 15728640,
            245628928,  4042260480, 3789553664, 4292870144, 31457280,   491257856,  3789553664,
            3284140032, 4290772992, 62914560,   982515712,  3284140032, 2273312768, 4286578688,
            125829120,  1965031424, 2273312768, 251658240,  4278190080, 251658240,  3930062848,
            251658240,  503316480,  4261412864, 503316480,  3565158400, 3724541952, 1006632960,
            4227858432, 1006632960, 2835349504, 2080374784, 2013265920, 4160749568, 2013265920,
            1375731712, 939524096,  4026531840, 4026531840, 4026531840, 2751463424, 2952790016,
            3758096384, 3758096384, 3758096384, 2281701376, 1610612736, 51,         771,
            13107,      196611,     3342390,    102,        1542,       26214,      393222,
            6684783,    255,        3855,       65535,      983055,     16711915,   510,
            7710,       131070,     1966110,    33423829,   1020,       15420,      262140,
            3932220,    66847657,   2040,       30840,      524280,     7864440,    133695314,
            4080,       61680,      1048560,    15728880,   267390628,  8160,       123360,
            2097120,    31457760,   534781256,  16320,      246720,     4194240,    62915520,
            1069562512, 32640,      493440,     8388480,    125831040,  2139125024, 65280,
            986880,     16776960,   251662080,  4278250048, 130560,     1973760,    33553920,
            503324160,  4261532800, 261120,     3947520,    67107840,   1006648320, 4228098304,
            522240,     7895040,    134215680,  2013296640, 4161229312, 1044480,    15790080,
            268431360,  4026593280, 4027491328, 2088960,    31580160,   536862720,  3758219264,
            3760015360, 4177920,    63160320,   1073725440, 3221471232, 3225063424, 8355840,
            126320640,  2147450880, 2147975168, 2155159552, 16711680,   252641280,  4294901760,
            983040,     15351808,   33423360,   505282560,  4294836224, 1966080,    30703616,
            66846720,   1010565120, 4294705152, 3932160,    61407232,   133693440,  2021130240,
            4294443008, 7864320,    122814464,  267386880,  4042260480, 4293918720, 15728640,
            245628928,  534773760,  3789553664, 4292870144, 31457280,   491257856,  1069547520,
            3284140032, 4290772992, 62914560,   982515712,  2139095040, 2273312768, 4286578688,
            125829120,  1965031424, 4278190080, 251658240,  4278190080, 251658240,  3930062848,
            4261412864, 503316480,  4261412864, 503316480,  3565158400, 4227858432, 1006632960,
            4227858432, 1006632960, 2835349504, 4160749568, 2013265920, 4160749568, 2013265920,
            1375731712, 4026531840, 4026531840, 4026531840, 4026531840, 2751463424, 3758096384,
            3758096384, 3758096384, 3758096384, 2281701376, 3,          51,         771,
            13107,      196611,     6,          102,        1542,       26214,      393222,
            15,         255,        3855,       65535,      983055,     30,         510,
            7710,       131070,     1966110,    60,         1020,       15420,      262140,
            3932220,    120,        2040,       30840,      524280,     7864440,    240,
            4080,       61680,      1048560,    15728880,   480,        8160,       123360,
            2097120,    31457760,   960,        16320,      246720,     4194240,    62915520,
            1920,       32640,      493440,     8388480,    125831040,  3840,       65280,
            986880,     16776960,   251662080,  7680,       130560,     1973760,    33553920,
            503324160,  15360,      261120,     3947520,    67107840,   1006648320, 30720,
            522240,     7895040,    134215680,  2013296640, 61440,      1044480,    15790080,
            268431360,  4026593280, 122880,     2088960,    31580160,   536862720,  3758219264,
            245760,     4177920,    63160320,   1073725440, 3221471232, 491520,     8355840,
            126320640,  2147450880, 2147975168, 983040,     16711680,   252641280,  4294901760,
            983040,     1966080,    33423360,   505282560,  4294836224, 1966080,    3932160,
            66846720,   1010565120, 4294705152, 3932160,    7864320,    133693440,  2021130240,
            4294443008, 7864320,    15728640,   267386880,  4042260480, 4293918720, 15728640,
            31457280,   534773760,  3789553664, 4292870144, 31457280,   62914560,   1069547520,
            3284140032, 4290772992, 62914560,   125829120,  2139095040, 2273312768, 4286578688,
            125829120,  251658240,  4278190080, 251658240,  4278190080, 251658240,  503316480,
            4261412864, 503316480,  4261412864, 503316480,  1006632960, 4227858432, 1006632960,
            4227858432, 1006632960, 2013265920, 4160749568, 2013265920, 4160749568, 2013265920,
            4026531840, 4026531840, 4026531840, 4026531840, 4026531840, 3758096384, 3758096384,
            3758096384, 3758096384, 3758096384, 65537,      1114130,    16843021,   286331422,
            3073,       131074,     2228260,    33686042,   572662844,  6146,       262148,
            4456523,    67372036,   1145326411, 4,          524296,     8913046,    134744072,
            2290652822, 8,          1048592,    17826092,   269488144,  286338348,  16,
            2097184,    35652184,   538976288,  572676696,  32,         4194368,    71304368,
            1077952576, 1145353392, 64,         8388736,    142608736,  2155905152, 2290706784,
            128,        16777472,   285217472,  16843008,   286446272,  256,        33554944,
            570434944,  33686016,   572892544,  512,        67109888,   1140869888, 67372032,
            1145785088, 1024,       134219776,  2281739776, 134744064,  2291570176, 2048,
            268439552,  268512256,  269488128,  288173056,  4096,       536879104,  537024512,
            538976256,  576346112,  8192,       1073758208, 1074049024, 1077952512, 1152692224,
            16384,      2147516416, 2148098048, 2155905024, 2305384448, 32768,      65536,
            1228800,    16842752,   315801600,  65536,      131072,     2457600,    33685504,
            631603200,  131072,     262144,     4915200,    67371008,   1263206400, 262144,
            524288,     9830400,    134742016,  2526412800, 524288,     1048576,    19660800,
            269484032,  757858304,  3222274048, 2097152,    39321600,   538968064,  1515716608,
            2149580800, 4194304,    78643200,   1077936128, 3031433216, 4194304,    8388608,
            157286400,  2155872256, 1767899136, 8388608,    16777216,   314572800,  16777216,
            314572800,  16777216,   33554432,   629145600,  33554432,   629145600,  33554432,
            67108864,   1258291200, 67108864,   1258291200, 67108864,   134217728,  2516582400,
            134217728,  2516582400, 134217728,  268435456,  738197504,  3489660928, 3959422976,
            268435456,  536870912,  1476395008, 2684354560, 3623878656, 536870912,  1073741824,
            2952790016, 1073741824, 2952790016, 1073741824, 2147483648, 1610612736, 2147483648,
            1610612736, 2147483648,
        },
        {
            85009117,   335741939,  1412632518, 386859243,  1741437244, 152139416,  403047142,
            2556825231, 505087203,  4287193174, 335609039,  336528191,  1425998811, 456920088,
            2832198590, 724748988,  3625845630, 1509824181, 3330088197, 2710488401, 1431742057,
            1077674236, 1140592489, 2096905276, 3007294393, 2863484114, 1081606648, 1207443154,
            972585080,  2793363314, 1432000919, 1089470704, 1341132452, 3019109363, 2362285522,
            1790260014, 2178941408, 2682264904, 1743251430, 429603751,  359294556,  62915520,
            1069562512, 3486502860, 859207501,  3939814584, 125831040,  2139125024, 2678038424,
            1718415002, 363436400,  251662080,  4278250048, 1061109552, 3436830004, 3948098272,
            503324160,  4261532800, 2122219104, 2310257256, 380003776,  1006648320, 4228098304,
            4244438208, 3278337232, 3981233024, 2013296640, 4161229312, 4193909120, 2530142624,
            446273280,  4026593280, 4027491328, 871625472,  4254978880, 4113772032, 3758219264,
            3760015360, 2011686400, 3946555008, 711351296,  3221471232, 3225063424, 4291808256,
            108481792,  2496444416, 2147975168, 2155159552, 4020213760, 485399040,  3919147008,
            983040,     15351808,   255799296,  3923588096, 322101248,  1966080,    299139072,
            511598592,  3283773440, 3865427968, 3932160,    4087939072, 1023197184, 1467273216,
            214663168,  7864320,    4149346304, 2046394368, 3202981888, 3650551808, 3236954112,
            1050935296, 871563264,  2916302848, 1932394496, 2447376384, 1833435136, 2011561984,
            2342944768, 643563520,  868220928,  177209344,  4291559424, 122486784,  2360868864,
            2004877312, 85983232,   4019716096, 3734634496, 3647995904, 1056964608, 3661627392,
            254803968,  2905866240, 1658847232, 2113929216, 3028287488, 3730833408, 2322071552,
            3586129920, 4227858432, 1761607680, 2092957696, 80740352,   2071986176, 4160749568,
            3523215360, 964689920,  429916160,  3875536896, 4026531840, 2751463424, 1929379840,
            4081057792, 503316480,  3758096384, 2281701376, 4127195136, 3397386240, 1316635,
            85009117,   335741939,  1412632518, 386859243,  1580547,    152139416,  403047142,
            2556825231, 505087203,  1317672,    335609039,  336528191,  1425998811, 456920088,
            1574501,    724748988,  3625845630, 1509824181, 3330088197, 15612,      1431742057,
            1077674236, 1140592489, 2096905276, 31224,      2863484114, 1081606648, 1207443154,
            972585080,  62451,      1432000919, 1089470704, 1341132452, 3019109363, 124902,
            1790260014, 2178941408, 2682264904, 1743251430, 249804,     359294556,  62915520,
            1069562512, 3486502860, 499608,     3939814584, 125831040,  2139125024, 2678038424,
            999216,     363436400,  251662080,  4278250048, 1061109552, 3223223904, 3948098272,
            503324160,  4261532800, 2122219104, 1077738688, 380003776,  1006648320, 4228098304,
            4244438208, 1081735552, 3981233024, 2013296640, 4161229312, 4193909120, 1089729280,
            446273280,  4026593280, 4027491328, 871625472,  2179458560, 4113772032, 3758219264,
            3760015360, 2011686400, 63949824,   711351296,  3221471232, 3225063424, 4291808256,
            127899648,  2496444416, 2147975168, 2155159552, 4020213760, 255799296,  3919147008,
            983040,     15351808,   255799296,  3732824064, 322101248,  1966080,    299139072,
            511598592,  2096939008, 3865427968, 3932160,    4087939072, 1023197184, 972652544,
            214663168,  7864320,    4149346304, 2046394368, 3019046912, 3650551808, 3236954112,
            1050935296, 871563264,  1743126528, 1932394496, 2447376384, 1833435136, 2011561984,
            3486253056, 643563520,  868220928,  177209344,  4291559424, 2677538816, 2360868864,
            2004877312, 85983232,   4019716096, 1060110336, 3647995904, 1056964608, 3661627392,
            254803968,  3193962496, 1658847232, 2113929216, 3028287488, 3730833408, 3166699520,
            3586129920, 4227858432, 1761607680, 2092957696, 3112173568, 2071986176, 4160749568,
            3523215360, 964689920,  1929379840, 3875536896, 4026531840, 2751463424, 1929379840,
            4127195136, 503316480,  3758096384, 2281701376, 4127195136, 332854,     1316635,
            85009117,   335741939,  1412632518, 596079,     1580547,    152139416,  403047142,
            2556825231, 1316075,    1317672,    335609039,  336528191,  1425998811, 2824661,
            1574501,    724748988,  3625845630, 1509824181, 5571497,    15612,      1431742057,
            1077674236, 1140592489, 11142994,   31224,      2863484114, 1081606648, 1207443154,
            22285988,   62451,      1432000919, 1089470704, 1341132452, 44571976,   124902,
            1790260014, 2178941408, 2682264904, 89143952,   249804,     359294556,  62915520,
            1069562512, 178287904,  499608,     3939814584, 125831040,  2139125024, 356575808,
            999216,     363436400,  251662080,  4278250048, 713151616,  3223223904, 3948098272,
            503324160,  4261532800, 1426303232, 1077738688, 380003776,  1006648320, 4228098304,
            2852606464, 1081735552, 3981233024, 2013296640, 4161229312, 1410245632, 1089729280,
            446273280,  4026593280, 4027491328, 1746749440, 2179458560, 4113772032, 3758219264,
            3760015360, 272273408,  63949824,   711351296,  3221471232, 3225063424, 3765772288,
            127899648,  2496444416, 2147975168, 2155159552, 15351808,   255799296,  3919147008,
            983040,     15351808,   3251929088, 3732824064, 322101248,  1966080,    299139072,
            1135149056, 2096939008, 3865427968, 3932160,    4087939072, 1196556288, 972652544,
            214663168,  7864320,    4149346304, 1319370752, 3019046912, 3650551808, 3236954112,
            1050935296, 2638741504, 1743126528, 1932394496, 2447376384, 1833435136, 982515712,
            3486253056, 643563520,  868220928,  177209344,  1965031424, 2677538816, 2360868864,
            2004877312, 85983232,   3930062848, 1060110336, 3647995904, 1056964608, 3661627392,
            3565158400, 3193962496, 1658847232, 2113929216, 3028287488, 2835349504, 3166699520,
            3586129920, 4227858432, 1761607680, 1375731712, 3112173568, 2071986176, 4160749568,
            3523215360, 2751463424, 1929379840, 3875536896, 4026531840, 2751463424, 2281701376,
            4127195136, 503316480,  3758096384, 2281701376, 5123,       332854,     1316635,
            85009117,   335741939,  6150,       596079,     1580547,    152139416,  403047142,
            5135,       1316075,    1317672,    335609039,  336528191,  6174,       2824661,
            1574501,    724748988,  3625845630, 60,         5571497,    15612,      1431742057,
            1077674236, 120,        11142994,   31224,      2863484114, 1081606648, 240,
            22285988,   62451,      1432000919, 1089470704, 480,        44571976,   124902,
            1790260014, 2178941408, 960,        89143952,   249804,     359294556,  62915520,
            1920,       178287904,  499608,     3939814584, 125831040,  3840,       356575808,
            999216,     363436400,  251662080,  7680,       713151616,  3223223904, 3948098272,
            503324160,  15360,      1426303232, 1077738688, 380003776,  1006648320, 30720,
            2852606464, 1081735552, 3981233024, 2013296640, 61440,      1410245632, 1089729280,
            446273280,  4026593280, 122880,     1746749440, 2179458560, 4113772032, 3758219264,
            245760,     272273408,  63949824,   711351296,  3221471232, 491520,     3765772288,
            127899648,  2496444416, 2147975168, 983040,     15351808,   255799296,  3919147008,
            983040,     3223191552, 3251929088, 3732824064, 322101248,  1966080,    1077673984,
            1135149056, 2096939008, 3865427968, 3932160,    1081606144, 1196556288, 972652544,
            214663168,  7864320,    1089470464, 1319370752, 3019046912, 3650551808, 3236954112,
            2178940928, 2638741504, 1743126528, 1932394496, 2447376384, 62914560,   982515712,
            3486253056, 643563520,  868220928,  125829120,  1965031424, 2677538816, 2360868864,
            2004877312, 251658240,  3930062848, 1060110336, 3647995904, 1056964608, 503316480,
            3565158400, 3193962496, 1658847232, 2113929216, 1006632960, 2835349504, 3166699520,
            3586129920, 4227858432, 2013265920, 1375731712, 3112173568, 2071986176, 4160749568,
            4026531840, 2751463424, 1929379840, 3875536896, 4026531840, 3758096384, 2281701376,
            4127195136, 503316480,  3758096384, 201392209,  3423671362, 218366296,  3713336838,
            206572594,  402785186,  2552372100, 436928947,  3130605370, 463476848,  262468,
            4461835,    68158800,   1158700908, 20971524,   524680,     8919318,    136513955,
            2316537326, 25165852,   3222274064, 3239051564, 3494187077, 3558090985, 3221225500,
            2149580832, 2183135832, 2693406858, 2821214674, 2147483704, 4194368,    71304368,
            1091846420, 1347462055, 64,         8388736,    142608736,  2183692840, 2694924110,
            3221225600, 16777472,   285217472,  72418384,   1094880924, 1342177536, 33554944,
            570434944,  144836768,  2189761848, 2684355072, 67109888,   1140869888, 289673536,
            84556400,   1073742848, 134219776,  2281739776, 579347072,  169112800,  2147485696,
            268439552,  268512256,  1158694144, 69790144,   4096,       536879104,  537024512,
            2317388288, 3360805760, 8192,       1073758208, 1074049024, 339809280,  1352902400,
            16384,      2147516416, 2148098048, 3900844032, 1632062976, 32768,      65536,
            1228800,    17059840,   311335936,  65536,      131072,     2457600,    34119680,
            622671872,  131072,     262144,     4915200,    68239360,   1245343744, 262144,
            524288,     9830400,    136478720,  2490687488, 524288,     1048576,    288096256,
            272957440,  954843136,  3222274048, 2097152,    3797417984, 545914880,  2983428096,
            2149580800, 4194304,    78643200,   1091829760, 2745630720, 4194304,    3229614080,
            3378511872, 1109917696, 2270035968, 8388608,    1358954496, 1119879168, 1414529024,
            513540096,  16777216,   2717908992, 2239758336, 2829058048, 1027080192, 33554432,
            1140850688, 184549376,  1363148800, 2054160384, 3288334336, 2281701376, 369098752,
            2726297600, 4108320768, 2281701376, 268435456,  738197504,  2231369728, 968884224,
            3959422976, 536870912,  1476395008, 167772160,  3011510272, 3355443200, 1073741824,
            2952790016, 335544320,  1728053248, 2147483648, 2147483648, 1610612736, 3892314112,
            503316480,  0,
        },
        {
            1510305164, 655261148,  1460339370, 618532343,  1809740895, 3187730233, 974058153,
            2588874754, 1018434447, 3852989061, 202287839,  3942822044, 1543051976, 3885760695,
            2877984414, 1496668560, 1913808684, 1404442583, 1875182363, 4062390592, 2456788841,
            3158310656, 2143619669, 2164011248, 1278897845, 2648653522, 3900702208, 1871320234,
            2448974304, 1299504490, 815820242,  2968780364, 3220836331, 2085536323, 411144354,
            1784867755, 568521629,  1072242887, 4167601810, 2330857219, 4092061529, 3284199487,
            4291788447, 4028897075, 1110519921, 516935041,  2273435774, 4020096318, 2306350691,
            2123452659, 464297248,  251716863,  252624463,  2497125327, 2566108680, 509163891,
            503446014,  1260276894, 1767770011, 185883649,  967995861,  4228105212, 4013926716,
            3612098352, 3319498784, 2321867690, 3892807672, 2004832888, 307789408,  1584861248,
            30000980,   1007620080, 1056875760, 611384515,  1076764851, 714313384,  4246609888,
            2487044576, 3722574214, 3114025318, 1344740688, 3208396736, 3988427712, 2881745676,
            3019408076, 1498299040, 3950542720, 3736414080, 310896152,  2989557144, 2812048704,
            3220242176, 27938560,   202361904,  2560756528, 4080593536, 1059192320, 1872010752,
            1491048544, 142874208,  1248974080, 1803811840, 1994996736, 2759798976, 3519556800,
            3907234304, 1808267264, 2098362368, 4097728896, 1984977280, 3905377280, 3947884544,
            3940872192, 3904684800, 1163965184, 290367488,  111140864,  97116160,   1148814848,
            2680251904, 3797766144, 2554314752, 244563968,  2566065152, 58903552,   3296370688,
            478117888,  556236800,  1223038976, 2869270528, 3442819072, 2499739648, 1045364736,
            1422667776, 2047553536, 1252687872, 704512000,  698220544,  966287360,  805724160,
            2157248512, 2214330368, 708575232,  3476078592, 2296168448, 3991535616, 402128896,
            24641536,   1264680960, 1437171712, 4061396992, 3287285760, 1810890752, 2198011904,
            58916864,   4108845056, 3269459968, 48234496,   387317760,  722862080,  30746719,
            1510305164, 655261148,  1460339370, 618532343,  225143879,  3187730233, 974058153,
            2588874754, 1018434447, 384957497,  202287839,  3942822044, 1543051976, 3885760695,
            706212939,  1496668560, 1913808684, 1404442583, 1875182363, 1409532156, 2456788841,
            3158310656, 2143619669, 2164011248, 1409778168, 2648653522, 3900702208, 1871320234,
            2448974304, 2145851302, 815820242,  2968780364, 3220836331, 2085536323, 2415599500,
            1784867755, 568521629,  1072242887, 4167601810, 3217231832, 4092061529, 3284199487,
            4291788447, 4028897075, 713432960,  516935041,  2273435774, 4020096318, 2306350691,
            4279189284, 464297248,  251716863,  252624463,  2497125327, 1109294712, 509163891,
            503446014,  1260276894, 1767770011, 675085504,  967995861,  4228105212, 4013926716,
            3612098352, 746191232,  2321867690, 3892807672, 2004832888, 307789408,  418640640,
            30000980,   1007620080, 1056875760, 611384515,  1961354752, 714313384,  4246609888,
            2487044576, 3722574214, 2093992960, 1344740688, 3208396736, 3988427712, 2881745676,
            2896140288, 1498299040, 3950542720, 3736414080, 310896152,  4030672896, 2812048704,
            3220242176, 27938560,   202361904,  1551785984, 4080593536, 1059192320, 1872010752,
            1491048544, 352108544,  1248974080, 1803811840, 1994996736, 2759798976, 1442414592,
            3907234304, 1808267264, 2098362368, 4097728896, 3623026688, 3905377280, 3947884544,
            3940872192, 3904684800, 1877344256, 290367488,  111140864,  97116160,   1148814848,
            265027584,  3797766144, 2554314752, 244563968,  2566065152, 3818389504, 3296370688,
            478117888,  556236800,  1223038976, 724566016,  3442819072, 2499739648, 1045364736,
            1422667776, 1788870656, 1252687872, 704512000,  698220544,  966287360,  3162505216,
            2157248512, 2214330368, 708575232,  3476078592, 2042626048, 3991535616, 402128896,
            24641536,   1264680960, 1933574144, 4061396992, 3287285760, 1810890752, 2198011904,
            914358272,  4108845056, 3269459968, 48234496,   387317760,  24910371,   30746719,
            1510305164, 655261148,  1460339370, 27133769,   225143879,  3187730233, 974058153,
            2588874754, 18225083,   384957497,  202287839,  3942822044, 1543051976, 40574789,
            706212939,  1496668560, 1913808684, 1404442583, 24722364,   1409532156, 2456788841,
            3158310656, 2143619669, 49444728,   1409778168, 2648653522, 3900702208, 1871320234,
            269478901,  2145851302, 815820242,  2968780364, 3220836331, 3745436886, 2415599500,
            1784867755, 568521629,  1072242887, 1096592016, 3217231832, 4092061529, 3284199487,
            4291788447, 1857639715, 713432960,  516935041,  2273435774, 4020096318, 3779177024,
            4279189284, 464297248,  251716863,  252624463,  1803768963, 1109294712, 509163891,
            503446014,  1260276894, 1376168197, 675085504,  967995861,  4228105212, 4013926716,
            218976778,  746191232,  2321867690, 3892807672, 2004832888, 2400887828, 418640640,
            30000980,   1007620080, 1056875760, 3409266728, 1961354752, 714313384,  4246609888,
            2487044576, 1869254736, 2093992960, 1344740688, 3208396736, 3988427712, 466952352,
            2896140288, 1498299040, 3950542720, 3736414080, 246038848,  4030672896, 2812048704,
            3220242176, 27938560,   2639561344, 1551785984, 4080593536, 1059192320, 1872010752,
            3131639040, 352108544,  1248974080, 1803811840, 1994996736, 4115794432, 1442414592,
            3907234304, 1808267264, 2098362368, 2057573376, 3623026688, 3905377280, 3947884544,
            3940872192, 155723776,  1877344256, 290367488,  111140864,  97116160,   4002435072,
            265027584,  3797766144, 2554314752, 244563968,  555786240,  3818389504, 3296370688,
            478117888,  556236800,  2923511808, 724566016,  3442819072, 2499739648, 1045364736,
            1619165184, 1788870656, 1252687872, 704512000,  698220544,  4244963328, 3162505216,
            2157248512, 2214330368, 708575232,  973733888,  2042626048, 3991535616, 402128896,
            24641536,   4044619776, 1933574144, 4061396992, 3287285760, 1810890752, 3739746304,
            914358272,  4108845056, 3269459968, 48234496,   5057346,    24910371,   30746719,
            1510305164, 655261148,  8087156,    27133769,   225143879,  3187730233, 974058153,
            5891930,    18225083,   384957497,  202287839,  3942822044, 6815348,    40574789,
            706212939,  1496668560, 1913808684, 261180,     24722364,   1409532156, 2456788841,
            3158310656, 522360,     49444728,   1409778168, 2648653522, 3900702208, 1568996,
            269478901,  2145851302, 815820242,  2968780364, 1761784,    3745436886, 2415599500,
            1784867755, 568521629,  50112,      1096592016, 3217231832, 4092061529, 3284199487,
            3221325696, 1857639715, 713432960,  516935041,  2273435774, 1073745664, 3779177024,
            4279189284, 464297248,  251716863,  3154124288, 1803768963, 1109294712, 509163891,
            503446014,  2483043328, 1376168197, 675085504,  967995861,  4228105212, 3288365056,
            218976778,  746191232,  2321867690, 3892807672, 2550198272, 2400887828, 418640640,
            30000980,   1007620080, 1963057152, 3409266728, 1961354752, 714313384,  4246609888,
            2130952192, 1869254736, 2093992960, 1344740688, 3208396736, 2869395456, 466952352,
            2896140288, 1498299040, 3950542720, 4279173120, 246038848,  4030672896, 2812048704,
            3220242176, 2115895296, 2639561344, 1551785984, 4080593536, 1059192320, 2084306944,
            3131639040, 352108544,  1248974080, 1803811840, 2021130240, 4115794432, 1442414592,
            3907234304, 1808267264, 1894776832, 2057573376, 3623026688, 3905377280, 3947884544,
            3789553664, 155723776,  1877344256, 290367488,  111140864,  3284140032, 4002435072,
            265027584,  3797766144, 2554314752, 1199570944, 555786240,  3818389504, 3296370688,
            478117888,  1325400064, 2923511808, 724566016,  3442819072, 2499739648, 2717908992,
            1619165184, 1788870656, 1252687872, 704512000,  1744830464, 4244963328, 3162505216,
            2157248512, 2214330368, 738197504,  973733888,  2042626048, 3991535616, 402128896,
            2751463424, 4044619776, 1933574144, 4061396992, 3287285760, 1207959552, 3739746304,
            914358272,  4108845056, 3269459968, 151111280,  2573073650, 154343228,  2307664883,
            61655634,   772783020,  3461807704, 770513611,  3797049260, 1679564,    335628549,
            1410983514, 291047748,  133541161,  222304512,  3624764485, 1491861048, 3524985860,
            3349239784, 213914712,  2417037760, 2433937901, 2171212944, 3492121645, 200,
            3760333696, 3794133978, 3268684064, 1548425305, 1426063776, 1078020101, 1146550437,
            6117460,    112926454,  201330000,  2155971593, 2291918201, 1068345255, 2454985248,
            2348813648, 16784401,   285335233,  88889409,   1112150924, 1610616144, 33568802,
            570670466,  3399004289, 2492737323, 3489667488, 67125316,   1409567492, 2030129412,
            974880372,  2147484992, 134250632,  1745393160, 570597899,  1949760731, 2432,
            268501264,  1427188752, 4173677589, 3517839749, 3221229568, 3758228000, 2250397728,
            1955235882, 1515975434, 2147491840, 268698688,  3427053632, 3155497044, 2713183764,
            16384,      3691513984, 562651264,  338305192,  1785711656, 32768,      3507491072,
            4292002048, 22298960,   673159248,  3221291008, 2720014848, 4289036800, 44597920,
            1346318496, 2147614720, 1145062400, 4283106304, 89195840,   2692636992, 262144,
            2290124800, 4271245312, 178391680,  1090306688, 3221749760, 1371607040, 2448166912,
            1434719488, 3090777344, 2429550592, 4135723008, 3872923648, 4261947904, 2306017792,
            1956642816, 1141129216, 4105191424, 1427133440, 132518912,  1077936128, 134774784,
            1767931904, 371238912,  1942759424, 3225419776, 3155230720, 2126577664, 4181807104,
            1654149120, 2823815168, 1747058688, 3984719872, 578985984,  355508224,  2090860544,
            3225681920, 3674472448, 2231713792, 2942386176, 272629760,  2156396544, 1980235776,
            168460288,  2730655744, 478150656,  17825792,   1762656256, 2484404224, 680853504,
            2818572288, 3256877056, 3995074560, 3559522304, 2917793792, 1073741824, 1413480448,
            4030726144, 22282240,   1913913344, 2147483648, 1417674752, 478150656,  3261595648,
            4108845056, 0,
        },
        {
            1939838472, 1412147404, 166205219,  1757484276, 2905930693, 2345662040, 2845657161,
            253454719,  2661974169, 303781080,  4075331504, 31014156,   244538930,  3752264221,
            992575155,  219309525,  246620060,  215640989,  4125020723, 2016731730, 3236558869,
            297169276,  3293566751, 1867504216, 210423272,  2531663658, 499723753,  1730625896,
            189236880,  3388575408, 2433358422, 1368961148, 3134096848, 2827836415, 3888822753,
            4172043647, 3379360748, 2651760955, 1345081091, 627692776,  189423917,  1927379456,
            4004336944, 2995932065, 1882016234, 2551113616, 1576396048, 1299792730, 2151240795,
            2154814108, 4292139924, 3555849728, 943986992,  3169912733, 2631635779, 3478094562,
            1285558544, 3716074330, 2780749859, 3911106510, 4175656994, 1731832828, 1275401375,
            937322456,  3802094750, 1145506936, 1008905193, 1718801768, 645739137,  1356219146,
            827886816,  1722154800, 2242776733, 754630810,  772070504,  249481170,  2608123425,
            2087201889, 3200968096, 3292110026, 841433255,  477543427,  1878882709, 705347364,
            4003860146, 3194913138, 2616490007, 357561212,  2446098297, 2955680594, 2512991743,
            637464579,  1209132455, 1341312804, 612108672,  2455017713, 1749147666, 4020226825,
            2873924220, 499405095,  1837614076, 1227604028, 714577577,  165950208,  442290261,
            489077752,  216760440,  42151250,   426862080,  2810242474, 4112075489, 3514761468,
            4101921371, 982512636,  500792667,  4286077681, 198050301,  1858712743, 2913642493,
            3547545255, 3981929169, 2944140287, 2286578015, 3422343167, 1239123295, 2026367394,
            3269986302, 3028402878, 2709637886, 1096011710, 294584132,  3086749695, 3324400975,
            1164394495, 4290155855, 543687304,  4008517630, 836370334,  1876426750, 2362048414,
            3578325264, 3221487612, 2671154748, 3395518460, 2018383420, 2131029536, 2165829624,
            697661816,  1336049656, 3309365624, 4259639360, 3423548400, 2416417776, 1633698800,
            1630071792, 41950336,   3423478496, 2885608160, 3943744224, 677380832,  4179285363,
            1939838472, 1412147404, 166205219,  1757484276, 3838244595, 2345662040, 2845657161,
            253454719,  2661974169, 138737288,  4075331504, 31014156,   244538930,  3752264221,
            1503392345, 219309525,  246620060,  215640989,  4125020723, 1759481152, 3236558869,
            297169276,  3293566751, 1867504216, 3898070400, 2531663658, 499723753,  1730625896,
            189236880,  2610231010, 2433358422, 1368961148, 3134096848, 2827836415, 3903474593,
            4172043647, 3379360748, 2651760955, 1345081091, 1267864331, 189423917,  1927379456,
            4004336944, 2995932065, 3452816347, 2551113616, 1576396048, 1299792730, 2151240795,
            1222520631, 4292139924, 3555849728, 943986992,  3169912733, 3260130211, 3478094562,
            1285558544, 3716074330, 2780749859, 3039362306, 4175656994, 1731832828, 1275401375,
            937322456,  3236754932, 1145506936, 1008905193, 1718801768, 645739137,  1358079399,
            827886816,  1722154800, 2242776733, 754630810,  1748663943, 249481170,  2608123425,
            2087201889, 3200968096, 698076610,  841433255,  477543427,  1878882709, 705347364,
            3692794996, 3194913138, 2616490007, 357561212,  2446098297, 2771068186, 2512991743,
            637464579,  1209132455, 1341312804, 27937268,   2455017713, 1749147666, 4020226825,
            2873924220, 1673040956, 1837614076, 1227604028, 714577577,  165950208,  528340088,
            489077752,  216760440,  42151250,   426862080,  1646215396, 4112075489, 3514761468,
            4101921371, 982512636,  2095821304, 4286077681, 198050301,  1858712743, 2913642493,
            277300160,  3981929169, 2944140287, 2286578015, 3422343167, 1178044288, 2026367394,
            3269986302, 3028402878, 2709637886, 2234191616, 294584132,  3086749695, 3324400975,
            1164394495, 136978944,  543687304,  4008517630, 836370334,  1876426750, 3275253760,
            3578325264, 3221487612, 2671154748, 3395518460, 3942394880, 2131029536, 2165829624,
            697661816,  1336049656, 3265045504, 4259639360, 3423548400, 2416417776, 1633698800,
            3943712768, 41950336,   3423478496, 2885608160, 3943744224, 2293593009, 4179285363,
            1939838472, 1412147404, 166205219,  715714152,  3838244595, 2345662040, 2845657161,
            253454719,  3758048260, 138737288,  4075331504, 31014156,   244538930,  370671650,
            1503392345, 219309525,  246620060,  215640989,  2219162331, 1759481152, 3236558869,
            297169276,  3293566751, 135243402,  3898070400, 2531663658, 499723753,  1730625896,
            3142293713, 2610231010, 2433358422, 1368961148, 3134096848, 486949791,  3903474593,
            4172043647, 3379360748, 2651760955, 3172880550, 1267864331, 189423917,  1927379456,
            4004336944, 191463910,  3452816347, 2551113616, 1576396048, 1299792730, 4411574,
            1222520631, 4292139924, 3555849728, 943986992,  3073348038, 3260130211, 3478094562,
            1285558544, 3716074330, 3098363790, 3039362306, 4175656994, 1731832828, 1275401375,
            468159532,  3236754932, 1145506936, 1008905193, 1718801768, 1092964081, 1358079399,
            827886816,  1722154800, 2242776733, 53128947,   1748663943, 249481170,  2608123425,
            2087201889, 1960144614, 698076610,  841433255,  477543427,  1878882709, 1505419004,
            3692794996, 3194913138, 2616490007, 357561212,  2823143358, 2771068186, 2512991743,
            637464579,  1209132455, 1991737212, 27937268,   2455017713, 1749147666, 4020226825,
            2907896812, 1673040956, 1837614076, 1227604028, 714577577,  3633969112, 528340088,
            489077752,  216760440,  42151250,   2886728356, 1646215396, 4112075489, 3514761468,
            4101921371, 3507686008, 2095821304, 4286077681, 198050301,  1858712743, 1463806912,
            277300160,  3981929169, 2944140287, 2286578015, 4137888640, 1178044288, 2026367394,
            3269986302, 3028402878, 1276820224, 2234191616, 294584132,  3086749695, 3324400975,
            4274031104, 136978944,  543687304,  4008517630, 836370334,  2978609152, 3275253760,
            3578325264, 3221487612, 2671154748, 2296777728, 3942394880, 2131029536, 2165829624,
            697661816,  1086645248, 3265045504, 4259639360, 3423548400, 2416417776, 2295121920,
            3943712768, 41950336,   3423478496, 2885608160, 3290486993, 2293593009, 4179285363,
            1939838472, 1412147404, 3718742914, 715714152,  3838244595, 2345662040, 2845657161,
            3251034248, 3758048260, 138737288,  4075331504, 31014156,   2257801369, 370671650,
            1503392345, 219309525,  246620060,  1375177854, 2219162331, 1759481152, 3236558869,
            297169276,  2981812236, 135243402,  3898070400, 2531663658, 499723753,  1103465850,
            3142293713, 2610231010, 2433358422, 1368961148, 2570001060, 486949791,  3903474593,
            4172043647, 3379360748, 1922171925, 3172880550, 1267864331, 189423917,  1927379456,
            1359812359, 191463910,  3452816347, 2551113616, 1576396048, 2518549525, 4411574,
            1222520631, 4292139924, 3555849728, 949028615,  3073348038, 3260130211, 3478094562,
            1285558544, 4113039486, 3098363790, 3039362306, 4175656994, 1731832828, 1827471372,
            468159532,  3236754932, 1145506936, 1008905193, 1626341859, 1092964081, 1358079399,
            827886816,  1722154800, 1069547583, 53128947,   1748663943, 249481170,  2608123425,
            3162506114, 1960144614, 698076610,  841433255,  477543427,  3641706484, 1505419004,
            3692794996, 3194913138, 2616490007, 3623882586, 2823143358, 2771068186, 2512991743,
            637464579,  16785012,   1991737212, 27937268,   2455017713, 1749147666, 2348825660,
            2907896812, 1673040956, 1837614076, 1227604028, 2579527800, 3633969112, 528340088,
            489077752,  216760440,  3628134628, 2886728356, 1646215396, 4112075489, 3514761468,
            1602085368, 3507686008, 2095821304, 4286077681, 198050301,  2501362624, 1463806912,
            277300160,  3981929169, 2944140287, 4112467840, 4137888640, 1178044288, 2026367394,
            3269986302, 3356184320, 1276820224, 2234191616, 294584132,  3086749695, 366387712,
            4274031104, 136978944,  543687304,  4008517630, 1006135296, 2978609152, 3275253760,
            3578325264, 3221487612, 3104844800, 2296777728, 3942394880, 2131029536, 2165829624,
            1874371584, 1086645248, 3265045504, 4259639360, 3423548400, 2975352832, 2295121920,
            3943712768, 41950336,   3423478496, 989898496,  3410688577, 2331788830, 3546482013,
            813828841,  1865093068, 3265457506, 3795669738, 2119696024, 4285651426, 3333834629,
            3451487261, 2090324595, 1816963648, 932961512,  2470761029, 3401764108, 3421619354,
            4199624502, 589386372,  879396240,  3372470254, 2693109296, 2424215996, 38442268,
            1882087724, 171397600,  2024561281, 183095586,  3282207272, 3402177296, 1859195498,
            413109947,  2839537944, 1632143648, 3742715856, 388696500,  1748703733, 3563198567,
            3826785440, 2896086528, 3989037829, 1478787788, 1390277813, 2123320736, 3416516800,
            2056564203, 2584895011, 1605192736, 2475623616, 3856499712, 3439657984, 708088129,
            1501395566, 1302184960, 1360092352, 1645630430, 1425230387, 3369488824, 2979863936,
            869212432,  150548847,  1097557362, 655939640,  316553344,  3761918508, 3958338094,
            141744600,  1412214640, 1859689984, 3200680981, 3883058679, 999801880,  3946079738,
            1876072704, 194381849,  2177533995, 1584707624, 3053768410, 2593051904, 3458076673,
            4047442835, 3545972808, 3441793178, 194975744,  1731731470, 4168755162, 2628944732,
            2125675784, 3119906816, 960774145,  2646626078, 2152793157, 3049156634, 672464896,
            3046932493, 3700727536, 2152335477, 575986696,  671940608,  2208366608, 1454456125,
            937760016,  4103979069, 2737668096, 1179779104, 1030912634, 1041902112, 2032909434,
            2274230272, 2089025605, 3050632421, 2428784965, 140658149,  4254138368, 1745354889,
            711584249,  2746523017, 2551006457, 1100808192, 1494221073, 3422999489, 2696954129,
            976716737,  2653421568, 3806331426, 3690047362, 1481392674, 3817015170, 2353004544,
            286262340,  2300534532, 4206449732, 15339268,   2894069760, 488376456,  1489927688,
            1196583048, 652746248,  2214592512, 69904,      1006205200, 2322628880, 1229515024,
            2617245696, 3423527456, 1964953120, 4260938272, 386199072,  1744830464, 1342444608,
            1069330496, 2138592320, 3185897536, 1073741824, 1342493824, 3780942976, 1771066496,
            2189433984, 2147483648,
        },
        {
            1372090615, 2850022427, 1910698492, 3326408212, 161127500,  3943054779, 1501949895,
            3655175421, 4159011741, 2060729127, 788736763,  881395863,  4224072924, 2643635329,
            1615177193, 1144971561, 721851321,  33032802,   2572368252, 770433571,  72378656,
            2136696776, 4199623874, 1629438528, 2222327159, 2603112580, 1357009463, 3662063433,
            3088414467, 1278323531, 47666492,   4229931522, 1461982761, 3352815531, 3102603457,
            3835731482, 3286901809, 3243076461, 3041047527, 2777044700, 3518835084, 3477729402,
            3882808201, 2152787069, 3169401022, 1917648432, 1165412529, 220575248,  2321260826,
            3702383342, 3088349148, 3575339135, 2107780925, 674874978,  4051170823, 3206702740,
            103689934,  2225341853, 3688463401, 2451447114, 2881331566, 2374815856, 4234411228,
            1605721172, 2774741835, 1604938426, 1251703601, 857183361,  3234302552, 2264617566,
            3528437140, 979243971,  3290708828, 1010555324, 160110841,  1792069901, 899260099,
            659043789,  3214387264, 1310301157, 2085317681, 1533430479, 2139145743, 3050670286,
            652653939,  2590238164, 755723407,  4121893850, 3204760872, 772371720,  3728432018,
            518280252,  1949084656, 1164805884, 4284412878, 1273954612, 3763751272, 688278641,
            478170321,  3930712976, 3150634990, 2306994160, 4009824355, 2891494881, 2503375627,
            2951316440, 3835190961, 4036434474, 1775735538, 2002351641, 1514011104, 853000140,
            1918845341, 2580137839, 3167582265, 508259448,  3199810200, 3706874319, 3248319058,
            4225669655, 4211277282, 755302415,  3429238421, 2412911847, 1842875935, 3366546392,
            365822043,  1621090951, 1490653673, 4233289728, 415810674,  1909244915, 909187492,
            1782519771, 1230357142, 1458004480, 3471610854, 462686708,  4101808709, 2266927992,
            2709646730, 2756644047, 974965094,  1417285493, 3826984444, 2064524408, 3944372638,
            16880755,   17165456,   4286803266, 3184799352, 1744583740, 3432777816, 1150472619,
            3419866778, 1841881088, 3203149112, 2270699471, 2461491325, 2467158048, 3026870623,
            1372090615, 2850022427, 1910698492, 3326408212, 1098716114, 3943054779, 1501949895,
            3655175421, 4159011741, 451896970,  788736763,  881395863,  4224072924, 2643635329,
            3589864132, 1144971561, 721851321,  33032802,   2572368252, 2408638244, 72378656,
            2136696776, 4199623874, 1629438528, 633262112,  2603112580, 1357009463, 3662063433,
            3088414467, 27898002,   47666492,   4229931522, 1461982761, 3352815531, 4236533406,
            3835731482, 3286901809, 3243076461, 3041047527, 328116030,  3518835084, 3477729402,
            3882808201, 2152787069, 2377105829, 1917648432, 1165412529, 220575248,  2321260826,
            4103401897, 3088349148, 3575339135, 2107780925, 674874978,  2411757291, 3206702740,
            103689934,  2225341853, 3688463401, 11241412,   2881331566, 2374815856, 4234411228,
            1605721172, 888991575,  1604938426, 1251703601, 857183361,  3234302552, 1118767958,
            3528437140, 979243971,  3290708828, 1010555324, 103097468,  1792069901, 899260099,
            659043789,  3214387264, 2641936137, 2085317681, 1533430479, 2139145743, 3050670286,
            3868792959, 2590238164, 755723407,  4121893850, 3204760872, 2233377240, 3728432018,
            518280252,  1949084656, 1164805884, 3708138739, 1273954612, 3763751272, 688278641,
            478170321,  2312552519, 3150634990, 2306994160, 4009824355, 2891494881, 1735460705,
            2951316440, 3835190961, 4036434474, 1775735538, 1978992343, 1514011104, 853000140,
            1918845341, 2580137839, 3563678076, 508259448,  3199810200, 3706874319, 3248319058,
            147995338,  4211277282, 755302415,  3429238421, 2412911847, 524175596,  3366546392,
            365822043,  1621090951, 1490653673, 1712031267, 415810674,  1909244915, 909187492,
            1782519771, 371192035,  1458004480, 3471610854, 462686708,  4101808709, 2399104876,
            2709646730, 2756644047, 974965094,  1417285493, 1214237426, 2064524408, 3944372638,
            16880755,   17165456,   1473471385, 3184799352, 1744583740, 3432777816, 1150472619,
            506859830,  1841881088, 3203149112, 2270699471, 2461491325, 3053019104, 3026870623,
            1372090615, 2850022427, 1910698492, 1915402730, 1098716114, 3943054779, 1501949895,
            3655175421, 1584492380, 451896970,  788736763,  881395863,  4224072924, 2832338722,
            3589864132, 1144971561, 721851321,  33032802,   3715072487, 2408638244, 72378656,
            2136696776, 4199623874, 1475116178, 633262112,  2603112580, 1357009463, 3662063433,
            1294439437, 27898002,   47666492,   4229931522, 1461982761, 720746439,  4236533406,
            3835731482, 3286901809, 3243076461, 3231023695, 328116030,  3518835084, 3477729402,
            3882808201, 1008353965, 2377105829, 1917648432, 1165412529, 220575248,  1645474990,
            4103401897, 3088349148, 3575339135, 2107780925, 254010959,  2411757291, 3206702740,
            103689934,  2225341853, 689904693,  11241412,   2881331566, 2374815856, 4234411228,
            2558093395, 888991575,  1604938426, 1251703601, 857183361,  3090847530, 1118767958,
            3528437140, 979243971,  3290708828, 2238687836, 103097468,  1792069901, 899260099,
            659043789,  351634649,  2641936137, 2085317681, 1533430479, 2139145743, 217376525,
            3868792959, 2590238164, 755723407,  4121893850, 659688784,  2233377240, 3728432018,
            518280252,  1949084656, 2085421589, 3708138739, 1273954612, 3763751272, 688278641,
            3198124327, 2312552519, 3150634990, 2306994160, 4009824355, 1790913909, 1735460705,
            2951316440, 3835190961, 4036434474, 1370670104, 1978992343, 1514011104, 853000140,
            1918845341, 1479931676, 3563678076, 508259448,  3199810200, 3706874319, 1707283480,
            147995338,  4211277282, 755302415,  3429238421, 367850504,  524175596,  3366546392,
            365822043,  1621090951, 291368977,  1712031267, 415810674,  1909244915, 909187492,
            4057994790, 371192035,  1458004480, 3471610854, 462686708,  2648811073, 2399104876,
            2709646730, 2756644047, 974965094,  214272148,  1214237426, 2064524408, 3944372638,
            16880755,   867065067,  1473471385, 3184799352, 1744583740, 3432777816, 713337805,
            506859830,  1841881088, 3203149112, 2270699471, 4233379057, 3053019104, 3026870623,
            1372090615, 2850022427, 3328483922, 1915402730, 1098716114, 3943054779, 1501949895,
            1683877665, 1584492380, 451896970,  788736763,  881395863,  1832773579, 2832338722,
            3589864132, 1144971561, 721851321,  638588754,  3715072487, 2408638244, 72378656,
            2136696776, 1697883336, 1475116178, 633262112,  2603112580, 1357009463, 3788269982,
            1294439437, 27898002,   47666492,   4229931522, 3704567376, 720746439,  4236533406,
            3835731482, 3286901809, 1555667604, 3231023695, 328116030,  3518835084, 3477729402,
            3289454297, 1008353965, 2377105829, 1917648432, 1165412529, 1185922957, 1645474990,
            4103401897, 3088349148, 3575339135, 1289770817, 254010959,  2411757291, 3206702740,
            103689934,  2035108741, 689904693,  11241412,   2881331566, 2374815856, 1502332202,
            2558093395, 888991575,  1604938426, 1251703601, 950098641,  3090847530, 1118767958,
            3528437140, 979243971,  4177111261, 2238687836, 103097468,  1792069901, 899260099,
            1800721728, 351634649,  2641936137, 2085317681, 1533430479, 107693180,  217376525,
            3868792959, 2590238164, 755723407,  2851737605, 659688784,  2233377240, 3728432018,
            518280252,  2631582009, 2085421589, 3708138739, 1273954612, 3763751272, 1151511233,
            3198124327, 2312552519, 3150634990, 2306994160, 973571169,  1790913909, 1735460705,
            2951316440, 3835190961, 3820923737, 1370670104, 1978992343, 1514011104, 853000140,
            2891954267, 1479931676, 3563678076, 508259448,  3199810200, 3644938194, 1707283480,
            147995338,  4211277282, 755302415,  3549187717, 367850504,  524175596,  3366546392,
            365822043,  953752142,  291368977,  1712031267, 415810674,  1909244915, 303424882,
            4057994790, 371192035,  1458004480, 3471610854, 2463368851, 2648811073, 2399104876,
            2709646730, 2756644047, 4101489462, 214272148,  1214237426, 2064524408, 3944372638,
            1523859994, 867065067,  1473471385, 3184799352, 1744583740, 2534912987, 713337805,
            506859830,  1841881088, 3203149112, 3898884029, 3822823391, 1338468702, 2964059298,
            476460861,  1102830502, 2453231139, 2307104586, 3107023086, 1117510383, 406729825,
            1273289438, 2120672471, 3286586313, 3880027335, 2238241005, 3250591742, 632340034,
            2855955052, 2967646883, 4159415443, 434475361,  1258749091, 4245009256, 423348029,
            367407063,  1771073667, 1909449846, 279744442,  2185705190, 931594654,  1811108181,
            2808926612, 195231221,  1653837676, 697641176,  1285727902, 1517432554, 1592146406,
            3380251379, 3357418144, 2408377381, 965978351,  3765312885, 3000287937, 424016796,
            1337190503, 1155382252, 163832280,  1160892465, 3182967125, 2176324812, 2909248755,
            1810245541, 2609649353, 3120085014, 1009074099, 4161816978, 1933323535, 810691635,
            455824401,  1988806277, 3396539044, 2198337080, 3962511986, 2464613666, 930353446,
            3232865169, 1052692441, 928400428,  2058326548, 1322024081, 840256255,  1216235184,
            3667946991, 3376271588, 3407253614, 82582134,   4232865704, 3146209227, 351066385,
            2514929684, 1239376728, 3298129188, 1767666799, 4229484846, 1874649828, 3404970783,
            1447158095, 3843847503, 214086740,  3303252292, 952370969,  1083279051, 1012160128,
            4208126039, 1251287108, 4270152098, 756801902,  2155548436, 3932079173, 3368824725,
            271755637,  3514985850, 4242095552, 2513401782, 2847653622, 2049655343, 691958228,
            971970512,  1641743637, 3681921805, 4249559050, 2734590937, 3417774079, 748489002,
            3361569779, 245042239,  3868192590, 2873904878, 1714438417, 1717635015, 1214645320,
            2526121812, 894020620,  108219681,  3106918828, 878982298,  3208177116, 2880232796,
            1494222145, 2005683999, 708881668,  863266246,  55610572,   1218431618, 2666758352,
            1014860301, 1401474520, 1655900632, 3641708804, 1271142295, 3592794582, 1490738874,
            4183503664, 1825624584, 2561085758, 2489489834, 3695006552, 2805167904, 373641232,
            1284575754, 2134855393, 686566776,  2503475968, 3296309024, 1399725307, 2045425462,
            1742513664, 169100800,
        },
        {
            1804684571, 2106089606, 1533056158, 2870216110, 3618155659, 3789871366, 4246691682,
            3667072763, 1212241769, 3152390668, 2973497449, 2958641966, 2088805328, 717518631,
            2401090860, 3606967204, 952637656,  59827581,   1291486682, 1499453515, 2053994857,
            563998083,  4094000396, 1163546899, 1003843565, 654565639,  1070907026, 4217851863,
            426034251,  1721352737, 278404469,  3899800390, 1063362170, 1162348262, 3153545093,
            3249996223, 186674553,  2616406148, 3137968354, 1282784965, 1495068058, 3033760361,
            2278144523, 3192245769, 719586342,  2602548287, 3386583150, 355354345,  3252815848,
            2178056037, 2283016801, 3005955037, 3340254490, 802791670,  251122316,  3705188626,
            1252262272, 3989036796, 3527490452, 2047131255, 1447170583, 3373930285, 2895037457,
            209341805,  1820357643, 3712392731, 685796521,  1322920440, 814388470,  1357857147,
            434430265,  2650681935, 1371566728, 58783716,   2273435933, 3498513198, 792571900,
            1447808772, 3513385860, 99175889,   1105434360, 1484146625, 3327194068, 242672513,
            3552105593, 1425844616, 2871928454, 1124633561, 607610433,  2130018608, 1610235673,
            2844230432, 2748082340, 994392866,  450823250,  2912535126, 2574390988, 3974009252,
            78696582,   649682891,  3980917176, 3221419689, 960695436,  729221508,  358358845,
            3392407691, 472711005,  295914899,  3005191796, 3078521977, 3370011868, 509135340,
            1965939519, 2086465877, 2457949822, 1324152522, 762289386,  3618693997, 233730715,
            2873984650, 31168606,   3367142977, 2851851305, 3251660053, 4209768406, 3298190175,
            901235185,  1564391510, 2352686527, 1008150482, 578573310,  3462447127, 2482873876,
            1790221257, 2255375608, 2335345651, 1381450613, 2866805101, 1495073163, 519905259,
            3184556473, 1076378339, 2692926127, 970097715,  4013407916, 4014350363, 2476927059,
            1989070516, 2640060069, 1987784589, 1880989003, 3861138803, 451743296,  1987067871,
            1975657871, 3397816882, 2309900530, 4108425851, 4063867233, 3319482186, 2621772886,
            1804684571, 2106089606, 1533056158, 2870216110, 611557097,  3789871366, 4246691682,
            3667072763, 1212241769, 3389551988, 2973497449, 2958641966, 2088805328, 717518631,
            2460955430, 3606967204, 952637656,  59827581,   1291486682, 3531087304, 2053994857,
            563998083,  4094000396, 1163546899, 1242934125, 654565639,  1070907026, 4217851863,
            426034251,  3034416129, 278404469,  3899800390, 1063362170, 1162348262, 4258714417,
            3249996223, 186674553,  2616406148, 3137968354, 639885806,  1495068058, 3033760361,
            2278144523, 3192245769, 4159910300, 2602548287, 3386583150, 355354345,  3252815848,
            1555885880, 2283016801, 3005955037, 3340254490, 802791670,  2948774612, 3705188626,
            1252262272, 3989036796, 3527490452, 2107826711, 1447170583, 3373930285, 2895037457,
            209341805,  3763367196, 3712392731, 685796521,  1322920440, 814388470,  1986168339,
            434430265,  2650681935, 1371566728, 58783716,   1423189187, 3498513198, 792571900,
            1447808772, 3513385860, 315969823,  1105434360, 1484146625, 3327194068, 242672513,
            3336228275, 1425844616, 2871928454, 1124633561, 607610433,  1762052458, 1610235673,
            2844230432, 2748082340, 994392866,  3771702243, 2912535126, 2574390988, 3974009252,
            78696582,   1626628844, 3980917176, 3221419689, 960695436,  729221508,  382092233,
            3392407691, 472711005,  295914899,  3005191796, 514297204,  3370011868, 509135340,
            1965939519, 2086465877, 3975975091, 1324152522, 762289386,  3618693997, 233730715,
            455322516,  31168606,   3367142977, 2851851305, 3251660053, 3952189603, 3298190175,
            901235185,  1564391510, 2352686527, 826181452,  578573310,  3462447127, 2482873876,
            1790221257, 1529242773, 2335345651, 1381450613, 2866805101, 1495073163, 877718651,
            3184556473, 1076378339, 2692926127, 970097715,  299344245,  4014350363, 2476927059,
            1989070516, 2640060069, 3844531327, 1880989003, 3861138803, 451743296,  1987067871,
            3272848161, 3397816882, 2309900530, 4108425851, 4063867233, 834288064,  2621772886,
            1804684571, 2106089606, 1533056158, 304865970,  611557097,  3789871366, 4246691682,
            3667072763, 2728206193, 3389551988, 2973497449, 2958641966, 2088805328, 3895037582,
            2460955430, 3606967204, 952637656,  59827581,   2349212526, 3531087304, 2053994857,
            563998083,  4094000396, 4028900485, 1242934125, 654565639,  1070907026, 4217851863,
            1663452176, 3034416129, 278404469,  3899800390, 1063362170, 2721441405, 4258714417,
            3249996223, 186674553,  2616406148, 4228837490, 639885806,  1495068058, 3033760361,
            2278144523, 2820661772, 4159910300, 2602548287, 3386583150, 355354345,  1815256314,
            1555885880, 2283016801, 3005955037, 3340254490, 2166514144, 2948774612, 3705188626,
            1252262272, 3989036796, 751187322,  2107826711, 1447170583, 3373930285, 2895037457,
            2809311944, 3763367196, 3712392731, 685796521,  1322920440, 936300677,  1986168339,
            434430265,  2650681935, 1371566728, 1308015359, 1423189187, 3498513198, 792571900,
            1447808772, 3065349526, 315969823,  1105434360, 1484146625, 3327194068, 1038676789,
            3336228275, 1425844616, 2871928454, 1124633561, 2956422231, 1762052458, 1610235673,
            2844230432, 2748082340, 3603862093, 3771702243, 2912535126, 2574390988, 3974009252,
            1691332448, 1626628844, 3980917176, 3221419689, 960695436,  3120142427, 382092233,
            3392407691, 472711005,  295914899,  4101686983, 514297204,  3370011868, 509135340,
            1965939519, 3015736706, 3975975091, 1324152522, 762289386,  3618693997, 2395097989,
            455322516,  31168606,   3367142977, 2851851305, 30511955,   3952189603, 3298190175,
            901235185,  1564391510, 2606298633, 826181452,  578573310,  3462447127, 2482873876,
            4159642946, 1529242773, 2335345651, 1381450613, 2866805101, 1782913669, 877718651,
            3184556473, 1076378339, 2692926127, 1730328819, 299344245,  4014350363, 2476927059,
            1989070516, 1425685614, 3844531327, 1880989003, 3861138803, 451743296,  889237383,
            3272848161, 3397816882, 2309900530, 4108425851, 1155723231, 834288064,  2621772886,
            1804684571, 2106089606, 2387009004, 304865970,  611557097,  3789871366, 4246691682,
            1405709661, 2728206193, 3389551988, 2973497449, 2958641966, 3183906006, 3895037582,
            2460955430, 3606967204, 952637656,  1345432763, 2349212526, 3531087304, 2053994857,
            563998083,  3749011414, 4028900485, 1242934125, 654565639,  1070907026, 1072342672,
            1663452176, 3034416129, 278404469,  3899800390, 3566652188, 2721441405, 4258714417,
            3249996223, 186674553,  4001263143, 4228837490, 639885806,  1495068058, 3033760361,
            4278332644, 2820661772, 4159910300, 2602548287, 3386583150, 838831089,  1815256314,
            1555885880, 2283016801, 3005955037, 3377397178, 2166514144, 2948774612, 3705188626,
            1252262272, 2414422575, 751187322,  2107826711, 1447170583, 3373930285, 1253755033,
            2809311944, 3763367196, 3712392731, 685796521,  3238624475, 936300677,  1986168339,
            434430265,  2650681935, 1642290570, 1308015359, 1423189187, 3498513198, 792571900,
            173318140,  3065349526, 315969823,  1105434360, 1484146625, 4103797777, 1038676789,
            3336228275, 1425844616, 2871928454, 1797745765, 2956422231, 1762052458, 1610235673,
            2844230432, 2180656608, 3603862093, 3771702243, 2912535126, 2574390988, 1183098390,
            1691332448, 1626628844, 3980917176, 3221419689, 2645203959, 3120142427, 382092233,
            3392407691, 472711005,  1659659070, 4101686983, 514297204,  3370011868, 509135340,
            483888155,  3015736706, 3975975091, 1324152522, 762289386,  1259948064, 2395097989,
            455322516,  31168606,   3367142977, 339990414,  30511955,   3952189603, 3298190175,
            901235185,  3097920065, 2606298633, 826181452,  578573310,  3462447127, 1548039839,
            4159642946, 1529242773, 2335345651, 1381450613, 2173079994, 1782913669, 877718651,
            3184556473, 1076378339, 1570275057, 1730328819, 299344245,  4014350363, 2476927059,
            1845882881, 1425685614, 3844531327, 1880989003, 3861138803, 1322409081, 889237383,
            3272848161, 3397816882, 2309900530, 3505447982, 3430136873, 1319796589, 4202423979,
            3184732284, 2910356648, 2534615223, 3854465731, 768821792,  2205052576, 1348983754,
            1300250188, 2919181738, 2520178732, 3967243685, 2646012002, 1784678658, 741302051,
            3464753547, 194213376,  1482799064, 3009673860, 680824208,  741966796,  2381283369,
            3022877171, 1619439814, 3961433610, 1331297670, 1100110820, 1311672539, 1122110615,
            4056004850, 3413790176, 3148768822, 1242592694, 2925975727, 1879285134, 334328879,
            1318235222, 3140739559, 401691770,  3604288404, 3686496908, 770670945,  199139043,
            2092710473, 3914528993, 700991333,  2375775811, 858137308,  3490050165, 2389078291,
            1615607459, 3027969809, 820012549,  2085659484, 2654485136, 2630408646, 196481396,
            1119673274, 1026209692, 726501622,  2940737143, 3559571163, 2288027726, 1039212708,
            929664536,  1061981465, 186058675,  3537656152, 844176796,  2996217992, 1545798611,
            3031020656, 2248030435, 1665857580, 2905758082, 1269201312, 3031275084, 4034872841,
            983632400,  4188503190, 757119675,  2105920865, 4281032819, 2917801076, 3900010013,
            3910997169, 1729751422, 562313247,  3070846353, 2564238664, 4050540186, 4258833501,
            2270666053, 2207128401, 2990540001, 797768898,  2288390225, 3230323685, 1974727440,
            3327301426, 289857826,  3565889868, 2791014422, 2021097820, 3350378271, 3673707591,
            2610067927, 4255789547, 2682856590, 12563128,   1397542366, 237149400,  2233707508,
            3875573245, 2097374144, 175320773,  4103445984, 4089284323, 3610168130, 3084915964,
            680145366,  2571684685, 1132894909, 104640024,  193765521,  2338202907, 895271448,
            11499099,   1798066417, 1297412626, 2511347162, 3140535007, 2129963538, 700683199,
            2609700278, 2953463279, 2290844145, 1871316353, 3993801787, 2219413182, 2954453701,
            231283580,  1375331115, 207723994,  1799562537, 2056553564, 2513609799, 3542459627,
            3173012714, 3923404932, 217877755,  2095124912, 192024370,  1168134987, 1889598668,
            3014873069, 2033573343,
        },
        {
            3341331272, 4150920827, 1555861833, 354776666,  3431334710, 2896787107, 3412156640,
            4153740462, 11542833,   3538437597, 2351703306, 1092430978, 730789147,  792617243,
            3299087428, 2691812801, 1948706153, 382709817,  2723543054, 2346361925, 870451825,
            3969718884, 4146623236, 292148077,  2967763799, 3653285759, 265118748,  44901363,
            624892653,  3753284348, 3643589405, 2738110576, 3837462241, 382657583,  4243850680,
            1917072341, 1670333451, 2522045435, 140025017,  2517242778, 4214450152, 4151706845,
            2746050051, 1793654081, 2300017026, 3169892957, 688799975,  1642881129, 2470426890,
            1489449970, 2451257105, 3858963763, 1613779066, 2367759827, 3215065640, 237734114,
            3624767770, 3899807831, 1917879156, 1514494111, 522732261,  1716188050, 1070372852,
            4230165074, 870086507,  1020760430, 286466269,  966417806,  4229214188, 2679790351,
            3723736929, 814985465,  2766258013, 190767845,  4201992121, 1774374940, 1115221192,
            2208482343, 579690151,  2371776981, 2994710399, 2872777877, 2840417233, 837135102,
            2871979052, 43628969,   932835945,  1737729446, 763924757,  1604633511, 1774461575,
            2059047161, 2778815997, 3735007622, 252420269,  321371880,  1282005525, 3205062230,
            744305948,  2074664977, 1687649149, 1339615355, 1693422687, 3554425893, 353986699,
            1045538474, 2605268442, 3815442237, 410024670,  1290579576, 1178021485, 2149689342,
            1487963288, 3034751043, 2925590019, 4228192446, 2226432838, 4082415168, 3695255605,
            2656152669, 2999082000, 3741740670, 1599260175, 2707434201, 4150536174, 583723088,
            4147350042, 583343062,  3495793167, 2471689170, 469272624,  2648379250, 355338112,
            1567264256, 4264863022, 3184268846, 1335771409, 2544544769, 1912095726, 2528635402,
            3709599786, 1502695544, 2280890895, 3225675002, 4277117263, 177198909,  2731025504,
            1680758622, 3425077837, 1012035362, 4257138692, 980648310,  3124990719, 244225873,
            4068312826, 1250361020, 2977768259, 3438340846, 1802464745, 2237522475, 1628859130,
            3341331272, 4150920827, 1555861833, 354776666,  2479348666, 2896787107, 3412156640,
            4153740462, 11542833,   3326442628, 2351703306, 1092430978, 730789147,  792617243,
            3384827060, 2691812801, 1948706153, 382709817,  2723543054, 3180673912, 870451825,
            3969718884, 4146623236, 292148077,  2037730867, 3653285759, 265118748,  44901363,
            624892653,  1687558372, 3643589405, 2738110576, 3837462241, 382657583,  3345852907,
            1917072341, 1670333451, 2522045435, 140025017,  915207019,  4214450152, 4151706845,
            2746050051, 1793654081, 2326525173, 3169892957, 688799975,  1642881129, 2470426890,
            1285983073, 2451257105, 3858963763, 1613779066, 2367759827, 3378268641, 237734114,
            3624767770, 3899807831, 1917879156, 97104697,   522732261,  1716188050, 1070372852,
            4230165074, 2116656766, 1020760430, 286466269,  966417806,  4229214188, 4237951312,
            3723736929, 814985465,  2766258013, 190767845,  2832085197, 1774374940, 1115221192,
            2208482343, 579690151,  2851321229, 2994710399, 2872777877, 2840417233, 837135102,
            3031498471, 43628969,   932835945,  1737729446, 763924757,  3755037643, 1774461575,
            2059047161, 2778815997, 3735007622, 2816780745, 321371880,  1282005525, 3205062230,
            744305948,  1194455517, 1687649149, 1339615355, 1693422687, 3554425893, 1486976424,
            1045538474, 2605268442, 3815442237, 410024670,  1018522389, 1178021485, 2149689342,
            1487963288, 3034751043, 1691170592, 4228192446, 2226432838, 4082415168, 3695255605,
            858908187,  2999082000, 3741740670, 1599260175, 2707434201, 4245574627, 583723088,
            4147350042, 583343062,  3495793167, 635134280,  469272624,  2648379250, 355338112,
            1567264256, 1177839823, 3184268846, 1335771409, 2544544769, 1912095726, 314678889,
            3709599786, 1502695544, 2280890895, 3225675002, 3624512017, 177198909,  2731025504,
            1680758622, 3425077837, 267707681,  4257138692, 980648310,  3124990719, 244225873,
            969916658,  1250361020, 2977768259, 3438340846, 1802464745, 2869726718, 1628859130,
            3341331272, 4150920827, 1555861833, 1653571003, 2479348666, 2896787107, 3412156640,
            4153740462, 1985859392, 3326442628, 2351703306, 1092430978, 730789147,  1607839204,
            3384827060, 2691812801, 1948706153, 382709817,  1775111379, 3180673912, 870451825,
            3969718884, 4146623236, 95070237,   2037730867, 3653285759, 265118748,  44901363,
            1976520797, 1687558372, 3643589405, 2738110576, 3837462241, 2347648551, 3345852907,
            1917072341, 1670333451, 2522045435, 2381455730, 915207019,  4214450152, 4151706845,
            2746050051, 2237283262, 2326525173, 3169892957, 688799975,  1642881129, 1208997894,
            1285983073, 2451257105, 3858963763, 1613779066, 156698686,  3378268641, 237734114,
            3624767770, 3899807831, 3716347010, 97104697,   522732261,  1716188050, 1070372852,
            4135113421, 2116656766, 1020760430, 286466269,  966417806,  2159049141, 4237951312,
            3723736929, 814985465,  2766258013, 2706661311, 2832085197, 1774374940, 1115221192,
            2208482343, 3384422417, 2851321229, 2994710399, 2872777877, 2840417233, 337214315,
            3031498471, 43628969,   932835945,  1737729446, 3582404427, 3755037643, 1774461575,
            2059047161, 2778815997, 732562642,  2816780745, 321371880,  1282005525, 3205062230,
            2318697976, 1194455517, 1687649149, 1339615355, 1693422687, 2625161236, 1486976424,
            1045538474, 2605268442, 3815442237, 3828887307, 1018522389, 1178021485, 2149689342,
            1487963288, 185090492,  1691170592, 4228192446, 2226432838, 4082415168, 3422002391,
            858908187,  2999082000, 3741740670, 1599260175, 1560722617, 4245574627, 583723088,
            4147350042, 583343062,  189775701,  635134280,  469272624,  2648379250, 355338112,
            1874428996, 1177839823, 3184268846, 1335771409, 2544544769, 324174505,  314678889,
            3709599786, 1502695544, 2280890895, 1266294718, 3624512017, 177198909,  2731025504,
            1680758622, 210756002,  267707681,  4257138692, 980648310,  3124990719, 3765074203,
            969916658,  1250361020, 2977768259, 3438340846, 2431139943, 2869726718, 1628859130,
            3341331272, 4150920827, 1641342920, 1653571003, 2479348666, 2896787107, 3412156640,
            3987368467, 1985859392, 3326442628, 2351703306, 1092430978, 3576779861, 1607839204,
            3384827060, 2691812801, 1948706153, 1479133397, 1775111379, 3180673912, 870451825,
            3969718884, 2356255534, 95070237,   2037730867, 3653285759, 265118748,  621215910,
            1976520797, 1687558372, 3643589405, 2738110576, 1356007679, 2347648551, 3345852907,
            1917072341, 1670333451, 3564379549, 2381455730, 915207019,  4214450152, 4151706845,
            2469495944, 2237283262, 2326525173, 3169892957, 688799975,  1315410361, 1208997894,
            1285983073, 2451257105, 3858963763, 3213030684, 156698686,  3378268641, 237734114,
            3624767770, 282314152,  3716347010, 97104697,   522732261,  1716188050, 327932414,
            4135113421, 2116656766, 1020760430, 286466269,  2747950704, 2159049141, 4237951312,
            3723736929, 814985465,  1314579835, 2706661311, 2832085197, 1774374940, 1115221192,
            1940432911, 3384422417, 2851321229, 2994710399, 2872777877, 3549858875, 337214315,
            3031498471, 43628969,   932835945,  623356762,  3582404427, 3755037643, 1774461575,
            2059047161, 3659785620, 732562642,  2816780745, 321371880,  1282005525, 1531375088,
            2318697976, 1194455517, 1687649149, 1339615355, 1349759332, 2625161236, 1486976424,
            1045538474, 2605268442, 1577519613, 3828887307, 1018522389, 1178021485, 2149689342,
            276330877,  185090492,  1691170592, 4228192446, 2226432838, 645045747,  3422002391,
            858908187,  2999082000, 3741740670, 2982679930, 1560722617, 4245574627, 583723088,
            4147350042, 4043064408, 189775701,  635134280,  469272624,  2648379250, 3586147669,
            1874428996, 1177839823, 3184268846, 1335771409, 4257077796, 324174505,  314678889,
            3709599786, 1502695544, 2278977757, 1266294718, 3624512017, 177198909,  2731025504,
            3610596908, 210756002,  267707681,  4257138692, 980648310,  762244956,  3765074203,
            969916658,  1250361020, 2977768259, 3530078090, 2782103948, 2521680092, 3967677423,
            2287344457, 620933617,  4184807621, 2204679814, 553382105,  2543298993, 3999518993,
            251270251,  2212011959, 4061377796, 3816737953, 1477770216, 2043179065, 3116599542,
            4197556854, 2201180805, 3881008737, 2559757486, 455496137,  2734900206, 1495014483,
            3183038204, 411622392,  810849765,  465907659,  3336428903, 221491049,  4219421852,
            3079558711, 2638306479, 150767981,  4109229956, 2682148139, 2318562868, 3648206130,
            2501968399, 669547034,  3933901236, 95431007,   3388822988, 517225823,  692063786,
            762766848,  1390736413, 81282515,   3580466601, 3544968019, 960381686,  1314460284,
            1284576991, 1048386421, 1004569168, 2650957112, 2485971693, 1041630440, 1810144340,
            434566707,  1647876505, 4206989304, 739905403,  1745058953, 2533846178, 4207421859,
            3700901179, 1833003559, 447155351,  2752657436, 1063815308, 1315868610, 3774298811,
            695834858,  442503796,  58296299,   1667672036, 1540952158, 963490582,  1796057602,
            1165746915, 3541185466, 1529950487, 3336366019, 2118425855, 3492265557, 3489640802,
            1261565918, 1814573363, 951113440,  4055269115, 1375974441, 343741744,  808576116,
            1464037604, 3242950576, 2423359351, 192312148,  4054574739, 1574887662, 1607721288,
            567326496,  798126507,  1420173603, 2113253009, 197227612,  813611099,  629178180,
            1466182937, 3961586497, 1983049113, 2578445010, 1300812739, 570552913,  1277946560,
            2056322069, 1021533674, 3925486383, 2439202370, 1498147926, 4097299344, 1232287574,
            530787317,  3661697844, 642214825,  2814837779, 1298117303, 1286993143, 1251123989,
            3289704229, 195375168,  3901901316, 700321791,  3645195869, 650342312,  1299963971,
            2983477733, 2224846291, 1944322038, 2332992053, 1991473169, 1709308600, 1998611665,
            2856084731, 810056384,  3080587805, 4242806179, 619560882,  778201231,  1062048573,
            3900228881, 3841402035, 3942891922, 381487510,  3195587262, 2467702242, 1937530105,
            1253284875, 3498679,
        },
        {
            3465348660, 3623545008, 3505902593, 838034830,  1338018789, 2595329276, 3367746385,
            3197935201, 1439351946, 3585085571, 4165798087, 3634792639, 2359485974, 2772582925,
            1110186203, 3771562484, 1508694157, 1564641206, 2801985736, 2446107936, 3849126897,
            1842973671, 944408104,  2624631280, 2729080685, 3737368614, 858809173,  2289802345,
            2428186575, 3114742765, 716011303,  3443810690, 814132610,  517432787,  614445393,
            2930433345, 291178098,  2117644502, 2749446703, 311745701,  365684723,  1705418876,
            2213749318, 4011417220, 1842575651, 988348831,  94258998,   2771150272, 498058526,
            1344827813, 2961955291, 262703473,  1404034822, 1566595865, 2522381203, 1706522206,
            1203054806, 1273801539, 2070583465, 3913449936, 3231505231, 619636751,  3746997351,
            4103027837, 1205468203, 3355878253, 3433356888, 107785753,  2779092609, 1869691566,
            2555219983, 903319808,  3273374169, 2538926990, 979533870,  1356500860, 1661983738,
            1380761625, 2919458459, 1041142798, 1430817627, 517007606,  1421570516, 2371447300,
            2985632691, 3684889351, 3873926653, 788770697,  1854750277, 209332297,  1137299679,
            848527832,  3850486924, 4179307312, 2764470693, 1353191605, 4166891919, 2074703841,
            3373997532, 2013528640, 701389744,  841917592,  2065742268, 2721848192, 2566956680,
            3122896007, 1090761479, 921859028,  4086736376, 1837462309, 2579826431, 2436217134,
            839037727,  1072086642, 614518622,  3764758228, 1501128342, 3669108708, 1601407381,
            2899014005, 3268308948, 3337564231, 1986911578, 3379194930, 1950365753, 2098537451,
            51515980,   1176526086, 3213391582, 1059745735, 2273586703, 376085505,  1493749800,
            3970342143, 1620925244, 2165301314, 2332030190, 1864098798, 276747442,  2776569227,
            2992780663, 3027279789, 1074555384, 3481518659, 2499703783, 661805703,  3782305562,
            9186074,    2357407210, 2355922343, 2024733363, 485434612,  862379913,  1029706268,
            1512726310, 3834948354, 1435892840, 3297980694, 2831553800, 2111416471, 711321697,
            3465348660, 3623545008, 3505902593, 838034830,  1553436793, 2595329276, 3367746385,
            3197935201, 1439351946, 3198044157, 4165798087, 3634792639, 2359485974, 2772582925,
            836042976,  3771562484, 1508694157, 1564641206, 2801985736, 1190371491, 3849126897,
            1842973671, 944408104,  2624631280, 410746791,  3737368614, 858809173,  2289802345,
            2428186575, 1542325976, 716011303,  3443810690, 814132610,  517432787,  1649301063,
            2930433345, 291178098,  2117644502, 2749446703, 3955511579, 365684723,  1705418876,
            2213749318, 4011417220, 2753632862, 988348831,  94258998,   2771150272, 498058526,
            3314106168, 2961955291, 262703473,  1404034822, 1566595865, 3590367097, 1706522206,
            1203054806, 1273801539, 2070583465, 2340683261, 3231505231, 619636751,  3746997351,
            4103027837, 2785398766, 3355878253, 3433356888, 107785753,  2779092609, 1608451840,
            2555219983, 903319808,  3273374169, 2538926990, 645164419,  1356500860, 1661983738,
            1380761625, 2919458459, 2260224548, 1430817627, 517007606,  1421570516, 2371447300,
            1636004496, 3684889351, 3873926653, 788770697,  1854750277, 1345251011, 1137299679,
            848527832,  3850486924, 4179307312, 3576574608, 1353191605, 4166891919, 2074703841,
            3373997532, 183447754,  701389744,  841917592,  2065742268, 2721848192, 2109289891,
            3122896007, 1090761479, 921859028,  4086736376, 2212730874, 2579826431, 2436217134,
            839037727,  1072086642, 55934784,   3764758228, 1501128342, 3669108708, 1601407381,
            516550987,  3268308948, 3337564231, 1986911578, 3379194930, 3973484473, 2098537451,
            51515980,   1176526086, 3213391582, 4251661633, 2273586703, 376085505,  1493749800,
            3970342143, 3190791788, 2165301314, 2332030190, 1864098798, 276747442,  2991976613,
            2992780663, 3027279789, 1074555384, 3481518659, 1399789494, 661805703,  3782305562,
            9186074,    2357407210, 1942736967, 2024733363, 485434612,  862379913,  1029706268,
            4122704494, 3834948354, 1435892840, 3297980694, 2831553800, 1210092654, 711321697,
            3465348660, 3623545008, 3505902593, 3443231198, 1553436793, 2595329276, 3367746385,
            3197935201, 1304974987, 3198044157, 4165798087, 3634792639, 2359485974, 3518323362,
            836042976,  3771562484, 1508694157, 1564641206, 3577633375, 1190371491, 3849126897,
            1842973671, 944408104,  1854555112, 410746791,  3737368614, 858809173,  2289802345,
            3622671731, 1542325976, 716011303,  3443810690, 814132610,  296197011,  1649301063,
            2930433345, 291178098,  2117644502, 1056271538, 3955511579, 365684723,  1705418876,
            2213749318, 1258535671, 2753632862, 988348831,  94258998,   2771150272, 3669902097,
            3314106168, 2961955291, 262703473,  1404034822, 1654433938, 3590367097, 1706522206,
            1203054806, 1273801539, 2448138887, 2340683261, 3231505231, 619636751,  3746997351,
            1454088394, 2785398766, 3355878253, 3433356888, 107785753,  689323470,  1608451840,
            2555219983, 903319808,  3273374169, 1603842392, 645164419,  1356500860, 1661983738,
            1380761625, 2814639423, 2260224548, 1430817627, 517007606,  1421570516, 1938805701,
            1636004496, 3684889351, 3873926653, 788770697,  4238900666, 1345251011, 1137299679,
            848527832,  3850486924, 108793827,  3576574608, 1353191605, 4166891919, 2074703841,
            3780897861, 183447754,  701389744,  841917592,  2065742268, 3036602746, 2109289891,
            3122896007, 1090761479, 921859028,  3499985398, 2212730874, 2579826431, 2436217134,
            839037727,  3520354700, 55934784,   3764758228, 1501128342, 3669108708, 1601010847,
            516550987,  3268308948, 3337564231, 1986911578, 2704241781, 3973484473, 2098537451,
            51515980,   1176526086, 3602010532, 4251661633, 2273586703, 376085505,  1493749800,
            2922957328, 3190791788, 2165301314, 2332030190, 1864098798, 1649666443, 2991976613,
            2992780663, 3027279789, 1074555384, 2848531519, 1399789494, 661805703,  3782305562,
            9186074,    320781315,  1942736967, 2024733363, 485434612,  862379913,  3598892066,
            4122704494, 3834948354, 1435892840, 3297980694, 545184652,  1210092654, 711321697,
            3465348660, 3623545008, 1173753045, 3443231198, 1553436793, 2595329276, 3367746385,
            2444634476, 1304974987, 3198044157, 4165798087, 3634792639, 1837035806, 3518323362,
            836042976,  3771562484, 1508694157, 2899021294, 3577633375, 1190371491, 3849126897,
            1842973671, 1614215215, 1854555112, 410746791,  3737368614, 858809173,  525745365,
            3622671731, 1542325976, 716011303,  3443810690, 566299749,  296197011,  1649301063,
            2930433345, 291178098,  1987532525, 1056271538, 3955511579, 365684723,  1705418876,
            2321222760, 1258535671, 2753632862, 988348831,  94258998,   2986060366, 3669902097,
            3314106168, 2961955291, 262703473,  604452796,  1654433938, 3590367097, 1706522206,
            1203054806, 1894894069, 2448138887, 2340683261, 3231505231, 619636751,  6680729,
            1454088394, 2785398766, 3355878253, 3433356888, 2025591660, 689323470,  1608451840,
            2555219983, 903319808,  3430384385, 1603842392, 645164419,  1356500860, 1661983738,
            2108736152, 2814639423, 2260224548, 1430817627, 517007606,  2973658959, 1938805701,
            1636004496, 3684889351, 3873926653, 2283691941, 4238900666, 1345251011, 1137299679,
            848527832,  45551112,   108793827,  3576574608, 1353191605, 4166891919, 3776615962,
            3780897861, 183447754,  701389744,  841917592,  3830639316, 3036602746, 2109289891,
            3122896007, 1090761479, 1931255897, 3499985398, 2212730874, 2579826431, 2436217134,
            3272166055, 3520354700, 55934784,   3764758228, 1501128342, 1567864246, 1601010847,
            516550987,  3268308948, 3337564231, 3918802424, 2704241781, 3973484473, 2098537451,
            51515980,   3551394489, 3602010532, 4251661633, 2273586703, 376085505,  885459498,
            2922957328, 3190791788, 2165301314, 2332030190, 3197056515, 1649666443, 2991976613,
            2992780663, 3027279789, 2385348906, 2848531519, 1399789494, 661805703,  3782305562,
            2163075465, 320781315,  1942736967, 2024733363, 485434612,  2680597981, 3598892066,
            4122704494, 3834948354, 1435892840, 2499644163, 2704575422, 2579557838, 673530532,
            493730767,  1124557747, 1908629439, 2821949504, 1743112513, 2849457841, 2344409314,
            3479159262, 4260973770, 2991970754, 3812641863, 2229319917, 2466968521, 1766353737,
            3216591612, 2113272648, 364370737,  1893001758, 2608875275, 4224057183, 3546705413,
            1999778009, 348872225,  2470564216, 1417878284, 2709790112, 3579129936, 2137971615,
            4046639861, 2841156930, 391544737,  2056567354, 737657378,  3877904725, 578930752,
            1759172471, 3383278785, 1047197514, 649468151,  3452867243, 1792089520, 63936215,
            3909143729, 3753489875, 734314122,  2490530916, 3043874586, 1504812057, 59001199,
            2493748676, 2552438622, 1889694845, 3715397860, 2817245010, 3841049206, 816106718,
            2176130406, 640254735,  12376903,   3000264936, 3304116079, 1620334094, 2109391765,
            1348210951, 2237645681, 1207768272, 1562894669, 2156631655, 1387193235, 3154858817,
            633510901,  2312190757, 402878244,  2501565021, 2984409334, 4167491216, 3614267292,
            3078552271, 971722322,  3065543880, 2307584190, 491480322,  2068673112, 1929780632,
            178549964,  983979983,  2769314886, 4214442042, 2977609682, 25450683,   3075212658,
            1571149568, 3531670561, 42782504,   425601306,  428715214,  497250251,  693520802,
            166426814,  1786382125, 2712003995, 3610802197, 2076490757, 404822980,  3953184772,
            1655231947, 3594351577, 3068232274, 3771730346, 4110519574, 3534704897, 2375277865,
            3597780202, 3472676002, 1350276449, 3218248239, 3589255283, 3253132633, 1769885529,
            3792812294, 120332643,  1219374788, 3608889019, 2386099811, 858495304,  1284785543,
            331370962,  2259419662, 2519864134, 3194739432, 2669074511, 2565559140, 3378072004,
            2647801475, 265068954,  1464416963, 1232787612, 4160089759, 2510685972, 670300081,
            2509357766, 1981891975, 4161588397, 1371924626, 44760868,   634955171,  1187096933,
            3324788972, 3576888559, 2801347752, 3730298395, 1702170762, 4206083415, 741409141,
            3649731355, 1025429529,
        },
        {
            657091256,  893756463,  2415146749, 3110037329, 3790718660, 1786148625, 147058369,
            128749612,  147716311,  2165772880, 4235146232, 2168711116, 2623842010, 266073041,
            1502633520, 1253012183, 3012442899, 599009166,  3179556679, 3051625147, 3038841740,
            3980185845, 2678220015, 1911545549, 2566977831, 2886689433, 423809246,  4262908518,
            2334936128, 581391997,  2269636293, 1292271859, 1765983581, 3900710735, 654622348,
            776555223,  999381607,  950729085,  2767791427, 3755697316, 4234857572, 1441181340,
            76747701,   1279430226, 2539282939, 3729069821, 1232061428, 1611679432, 1150932552,
            2007389334, 3745689257, 1269039827, 706744525,  1828912104, 735120475,  697489993,
            3675403596, 954420936,  1595335821, 1789943817, 1542816355, 366438554,  2680202937,
            3573770984, 3138906300, 944178071,  3166866074, 2131003141, 1683068831, 2470281793,
            1452436775, 1914319088, 1488926187, 1369292198, 1348035788, 1588225236, 1669254471,
            3320766153, 1001444760, 3162264963, 3311009586, 3041442846, 1978083471, 4289114871,
            4077214169, 3742970096, 2773761099, 217887886,  70853265,   1972459292, 3320032471,
            407653666,  3891919299, 3035704715, 2873613941, 2253841007, 1793274053, 4147972646,
            2907566845, 3923946309, 1712605650, 2168888098, 2682501555, 2361333110, 1044241059,
            1036224264, 3456356017, 1717924221, 3298148687, 3783127893, 1839713344, 719224483,
            2443566136, 3495061975, 4029001228, 578542885,  3931481694, 2334054877, 630543322,
            2362928342, 1430990925, 425544448,  265445834,  3907616147, 2064434872, 1236482438,
            1277714831, 2590941286, 1515831519, 4029447931, 435380485,  3520765874, 1858179902,
            1967421051, 2365816463, 4172332542, 1800291700, 255232211,  421810353,  2500662772,
            256441181,  642616427,  952218873,  138814539,  599947212,  3634946435, 2526627116,
            1701896929, 2649293973, 3386327666, 2610466574, 1016341126, 4180947892, 1261837820,
            220001804,  1513357383, 1838525464, 1163681895, 2169997879, 3167549155, 2621031254,
            657091256,  893756463,  2415146749, 3110037329, 66857102,   1786148625, 147058369,
            128749612,  147716311,  3024312793, 4235146232, 2168711116, 2623842010, 266073041,
            2504851631, 1253012183, 3012442899, 599009166,  3179556679, 2389401927, 3038841740,
            3980185845, 2678220015, 1911545549, 197693833,  2886689433, 423809246,  4262908518,
            2334936128, 4261166100, 2269636293, 1292271859, 1765983581, 3900710735, 3671693041,
            776555223,  999381607,  950729085,  2767791427, 148479494,  4234857572, 1441181340,
            76747701,   1279430226, 568832418,  3729069821, 1232061428, 1611679432, 1150932552,
            2760485908, 3745689257, 1269039827, 706744525,  1828912104, 2600061349, 697489993,
            3675403596, 954420936,  1595335821, 293700879,  1542816355, 366438554,  2680202937,
            3573770984, 3192115229, 944178071,  3166866074, 2131003141, 1683068831, 3329141752,
            1452436775, 1914319088, 1488926187, 1369292198, 3701017099, 1588225236, 1669254471,
            3320766153, 1001444760, 2385838856, 3311009586, 3041442846, 1978083471, 4289114871,
            350117027,  3742970096, 2773761099, 217887886,  70853265,   4082098530, 3320032471,
            407653666,  3891919299, 3035704715, 2789221600, 2253841007, 1793274053, 4147972646,
            2907566845, 552309571,  1712605650, 2168888098, 2682501555, 2361333110, 797959303,
            1036224264, 3456356017, 1717924221, 3298148687, 3600130529, 1839713344, 719224483,
            2443566136, 3495061975, 2361550725, 578542885,  3931481694, 2334054877, 630543322,
            3317583198, 1430990925, 425544448,  265445834,  3907616147, 71963738,   1236482438,
            1277714831, 2590941286, 1515831519, 2057995312, 435380485,  3520765874, 1858179902,
            1967421051, 137349180,  4172332542, 1800291700, 255232211,  421810353,  2075236132,
            256441181,  642616427,  952218873,  138814539,  1642245851, 3634946435, 2526627116,
            1701896929, 2649293973, 2399610176, 2610466574, 1016341126, 4180947892, 1261837820,
            3548313423, 1513357383, 1838525464, 1163681895, 2169997879, 1404388591, 2621031254,
            657091256,  893756463,  2415146749, 3912032651, 66857102,   1786148625, 147058369,
            128749612,  1011084468, 3024312793, 4235146232, 2168711116, 2623842010, 2082986374,
            2504851631, 1253012183, 3012442899, 599009166,  265430285,  2389401927, 3038841740,
            3980185845, 2678220015, 2775103912, 197693833,  2886689433, 423809246,  4262908518,
            3283590605, 4261166100, 2269636293, 1292271859, 1765983581, 3270495159, 3671693041,
            776555223,  999381607,  950729085,  8420644,    148479494,  4234857572, 1441181340,
            76747701,   3603501056, 568832418,  3729069821, 1232061428, 1611679432, 1328263446,
            2760485908, 3745689257, 1269039827, 706744525,  2264859388, 2600061349, 697489993,
            3675403596, 954420936,  3171342182, 293700879,  1542816355, 366438554,  2680202937,
            1274445906, 3192115229, 944178071,  3166866074, 2131003141, 1738994140, 3329141752,
            1452436775, 1914319088, 1488926187, 2140002150, 3701017099, 1588225236, 1669254471,
            3320766153, 1522444191, 2385838856, 3311009586, 3041442846, 1978083471, 1463263982,
            350117027,  3742970096, 2773761099, 217887886,  480523637,  4082098530, 3320032471,
            407653666,  3891919299, 3548395636, 2789221600, 2253841007, 1793274053, 4147972646,
            1232965353, 552309571,  1712605650, 2168888098, 2682501555, 2597801703, 797959303,
            1036224264, 3456356017, 1717924221, 951380014,  3600130529, 1839713344, 719224483,
            2443566136, 3290959601, 2361550725, 578542885,  3931481694, 2334054877, 3354831596,
            3317583198, 1430990925, 425544448,  265445834,  3834700947, 71963738,   1236482438,
            1277714831, 2590941286, 1107935958, 2057995312, 435380485,  3520765874, 1858179902,
            2212387416, 137349180,  4172332542, 1800291700, 255232211,  1980351512, 2075236132,
            256441181,  642616427,  952218873,  3076238565, 1642245851, 3634946435, 2526627116,
            1701896929, 426157471,  2399610176, 2610466574, 1016341126, 4180947892, 1781981994,
            3548313423, 1513357383, 1838525464, 1163681895, 2223467186, 1404388591, 2621031254,
            657091256,  893756463,  1728867190, 3912032651, 66857102,   1786148625, 147058369,
            3396079767, 1011084468, 3024312793, 4235146232, 2168711116, 2043072694, 2082986374,
            2504851631, 1253012183, 3012442899, 2131619245, 265430285,  2389401927, 3038841740,
            3980185845, 3957274378, 2775103912, 197693833,  2886689433, 423809246,  1127205725,
            3283590605, 4261166100, 2269636293, 1292271859, 3088930439, 3270495159, 3671693041,
            776555223,  999381607,  3368303750, 8420644,    148479494,  4234857572, 1441181340,
            2002023663, 3603501056, 568832418,  3729069821, 1232061428, 2452623688, 1328263446,
            2760485908, 3745689257, 1269039827, 1044282319, 2264859388, 2600061349, 697489993,
            3675403596, 1540729003, 3171342182, 293700879,  1542816355, 366438554,  3364139025,
            1274445906, 3192115229, 944178071,  3166866074, 3422376609, 1738994140, 3329141752,
            1452436775, 1914319088, 1782907426, 2140002150, 3701017099, 1588225236, 1669254471,
            2773468121, 1522444191, 2385838856, 3311009586, 3041442846, 1159634153, 1463263982,
            350117027,  3742970096, 2773761099, 3988724582, 480523637,  4082098530, 3320032471,
            407653666,  3632631316, 3548395636, 2789221600, 2253841007, 1793274053, 128947494,
            1232965353, 552309571,  1712605650, 2168888098, 896362949,  2597801703, 797959303,
            1036224264, 3456356017, 235515060,  951380014,  3600130529, 1839713344, 719224483,
            1449815422, 3290959601, 2361550725, 578542885,  3931481694, 1728811768, 3354831596,
            3317583198, 1430990925, 425544448,  262862227,  3834700947, 71963738,   1236482438,
            1277714831, 2115276496, 1107935958, 2057995312, 435380485,  3520765874, 2503657393,
            2212387416, 137349180,  4172332542, 1800291700, 3983138125, 1980351512, 2075236132,
            256441181,  642616427,  2713331100, 3076238565, 1642245851, 3634946435, 2526627116,
            3386171149, 426157471,  2399610176, 2610466574, 1016341126, 1084700398, 1781981994,
            3548313423, 1513357383, 1838525464, 2620996897, 3058349677, 3966092731, 778444736,
            3411947059, 2843515150, 968786064,  1429906154, 3482835204, 1184011405, 2713679823,
            1041371324, 1576491581, 1317063508, 1204329634, 364459052,  763527323,  3950235325,
            4141962144, 1326225958, 2935284222, 161101625,  1580865837, 3255982923, 1308545444,
            4157502184, 2242429937, 2572243808, 3815979672, 3834537926, 1438742500, 1604757045,
            2805254320, 4112999438, 1740362664, 1107125249, 3134625696, 2296356274, 4081236817,
            1916670490, 3630381930, 1483868953, 306389793,  986546531,  3171655734, 2579072531,
            3113298233, 1911224433, 2884779975, 266509896,  1229462156, 992342856,  2951712938,
            366694755,  4150838356, 1127654694, 4041654693, 2705633298, 2939544476, 3942005956,
            1221922037, 1253135644, 542587972,  2074930481, 3083907884, 1467800517, 515031368,
            4227823124, 2052437874, 2000555981, 3764254860, 3689009908, 515730909,  1039219614,
            3490079714, 2381193036, 3613225803, 2491980331, 1817249041, 2155670973, 1504833858,
            3621830206, 1249531002, 2542394494, 2281474562, 2169154204, 2931504910, 1072238971,
            892123944,  147210518,  4030822617, 2734313205, 3844275643, 3143972187, 446924065,
            821456421,  1012416006, 608212273,  2995227768, 2534326070, 723422373,  3341045211,
            1405520652, 3576473934, 451316488,  1794048379, 3328541851, 505149168,  3807627982,
            3390582118, 3204721994, 1534887483, 2902993282, 1680153773, 3867636739, 3559644727,
            3415774019, 814169513,  2749354273, 1599397201, 3952432216, 3718203454, 2785128705,
            2849926036, 1296390966, 2582113317, 1118387340, 3546798265, 354967712,  4286340030,
            3933276101, 3468707735, 532190414,  4010124526, 4091958459, 1238966282, 1060610075,
            530221837,  3740324181, 1014696320, 1359056542, 3160953811, 3395393483, 2983198959,
            3197696946, 3571721530, 1969094822, 3255151683, 2749825688, 2068833051, 1520815746,
            2473660815, 2316809232, 84971856,   2659720798, 3822340000, 2742251854, 3376779876,
            440100139,  1074750828,
        },
        {
            91444490,   628576944,  4069219862, 2253058925, 492354082,  1191182242, 1565180119,
            2257613723, 456055162,  605712223,  953365104,  3104638527, 1133984729, 2662828416,
            2134948274, 1921384447, 843719355,  588432962,  1734575434, 2924140067, 483396548,
            3848838894, 3155476556, 1760928304, 4168059840, 3279827269, 2644461735, 4168565656,
            3951563569, 1276805504, 1708974143, 1878547888, 3465220024, 3062086782, 2801401651,
            1510428126, 716404149,  1646021208, 3534932385, 1186585561, 651997355,  282914223,
            352224857,  3764407517, 1059868753, 1971798134, 978904005,  976413661,  4039544152,
            498989693,  2565125471, 2782642813, 3537961025, 1194967362, 169217024,  3491609,
            1319592872, 1630206561, 2497130840, 1685008996, 2828944016, 3301346775, 2893072371,
            2606559798, 4026138031, 2664450619, 691091062,  1079640113, 1417637732, 4081852209,
            2197910648, 2310382370, 1000957047, 959936499,  2844551811, 2272766890, 31122394,
            2742925483, 1121884686, 57929089,   2468361281, 2982007782, 2371576893, 177782593,
            3603584577, 672057044,  2108452841, 1671338057, 3386908223, 1243029765, 805157552,
            1271858417, 1621249501, 1804851492, 1321010403, 751773221,  1517221627, 822709871,
            104533154,  3578182264, 640541709,  421086624,  4233576392, 3729339369, 197460644,
            773140636,  2158026018, 1756785611, 4011575991, 3569445500, 736117181,  2456162322,
            1168189787, 3651312675, 1070291988, 268231205,  541474497,  3316168972, 3546990856,
            830417208,  725960194,  2044207227, 3188997938, 2383298579, 3350316374, 3575011225,
            1553111865, 1285013027, 749371711,  766611716,  598195098,  2139882719, 2062405428,
            3634702446, 3015263295, 223311969,  2622859522, 3888492701, 2955257225, 582625650,
            3563756446, 2886083960, 1907546514, 454650902,  3287277541, 625828138,  2991888140,
            1935326370, 4031152256, 702881509,  1427632724, 1345475301, 2577560804, 2858595147,
            2533191188, 185662179,  536505093,  3747894147, 111551030,  370373207,  2293908590,
            91444490,   628576944,  4069219862, 2253058925, 1671484924, 1191182242, 1565180119,
            2257613723, 456055162,  3411094744, 953365104,  3104638527, 1133984729, 2662828416,
            2000630022, 1921384447, 843719355,  588432962,  1734575434, 3293926122, 483396548,
            3848838894, 3155476556, 1760928304, 146876953,  3279827269, 2644461735, 4168565656,
            3951563569, 3976156700, 1708974143, 1878547888, 3465220024, 3062086782, 1999154400,
            1510428126, 716404149,  1646021208, 3534932385, 2479551429, 651997355,  282914223,
            352224857,  3764407517, 1275979651, 1971798134, 978904005,  976413661,  4039544152,
            300654823,  2565125471, 2782642813, 3537961025, 1194967362, 3123973648, 3491609,
            1319592872, 1630206561, 2497130840, 1437913158, 2828944016, 3301346775, 2893072371,
            2606559798, 2153172585, 2664450619, 691091062,  1079640113, 1417637732, 17137237,
            2197910648, 2310382370, 1000957047, 959936499,  802137134,  2272766890, 31122394,
            2742925483, 1121884686, 3909775167, 2468361281, 2982007782, 2371576893, 177782593,
            3319492525, 672057044,  2108452841, 1671338057, 3386908223, 1878151473, 805157552,
            1271858417, 1621249501, 1804851492, 3215921223, 751773221,  1517221627, 822709871,
            104533154,  361845001,  640541709,  421086624,  4233576392, 3729339369, 2655936801,
            773140636,  2158026018, 1756785611, 4011575991, 587202971,  736117181,  2456162322,
            1168189787, 3651312675, 2517883370, 268231205,  541474497,  3316168972, 3546990856,
            2037251305, 725960194,  2044207227, 3188997938, 2383298579, 2665008587, 3575011225,
            1553111865, 1285013027, 749371711,  2163964019, 598195098,  2139882719, 2062405428,
            3634702446, 2788202059, 223311969,  2622859522, 3888492701, 2955257225, 740986174,
            3563756446, 2886083960, 1907546514, 454650902,  2426323587, 625828138,  2991888140,
            1935326370, 4031152256, 1831149435, 1427632724, 1345475301, 2577560804, 2858595147,
            3977153945, 185662179,  536505093,  3747894147, 111551030,  4131587422, 2293908590,
            91444490,   628576944,  4069219862, 2408189350, 1671484924, 1191182242, 1565180119,
            2257613723, 1338069254, 3411094744, 953365104,  3104638527, 1133984729, 631497759,
            2000630022, 1921384447, 843719355,  588432962,  3280318959, 3293926122, 483396548,
            3848838894, 3155476556, 1777918163, 146876953,  3279827269, 2644461735, 4168565656,
            2786264663, 3976156700, 1708974143, 1878547888, 3465220024, 2793923820, 1999154400,
            1510428126, 716404149,  1646021208, 3102243824, 2479551429, 651997355,  282914223,
            352224857,  3767702588, 1275979651, 1971798134, 978904005,  976413661,  1951622548,
            300654823,  2565125471, 2782642813, 3537961025, 2186817324, 3123973648, 3491609,
            1319592872, 1630206561, 1075424534, 1437913158, 2828944016, 3301346775, 2893072371,
            207992406,  2153172585, 2664450619, 691091062,  1079640113, 3114255216, 17137237,
            2197910648, 2310382370, 1000957047, 2548008553, 802137134,  2272766890, 31122394,
            2742925483, 4069482373, 3909775167, 2468361281, 2982007782, 2371576893, 2807823912,
            3319492525, 672057044,  2108452841, 1671338057, 12831353,   1878151473, 805157552,
            1271858417, 1621249501, 461887094,  3215921223, 751773221,  1517221627, 822709871,
            1317394918, 361845001,  640541709,  421086624,  4233576392, 3385587450, 2655936801,
            773140636,  2158026018, 1756785611, 1475601973, 587202971,  736117181,  2456162322,
            1168189787, 911455077,  2517883370, 268231205,  541474497,  3316168972, 1500275507,
            2037251305, 725960194,  2044207227, 3188997938, 2036633808, 2665008587, 3575011225,
            1553111865, 1285013027, 87868216,   2163964019, 598195098,  2139882719, 2062405428,
            517907301,  2788202059, 223311969,  2622859522, 3888492701, 3926046234, 740986174,
            3563756446, 2886083960, 1907546514, 1911066215, 2426323587, 625828138,  2991888140,
            1935326370, 2031853435, 1831149435, 1427632724, 1345475301, 2577560804, 3509674153,
            3977153945, 185662179,  536505093,  3747894147, 1711714600, 4131587422, 2293908590,
            91444490,   628576944,  3370678255, 2408189350, 1671484924, 1191182242, 1565180119,
            3786239592, 1338069254, 3411094744, 953365104,  3104638527, 3659647225, 631497759,
            2000630022, 1921384447, 843719355,  3364831282, 3280318959, 3293926122, 483396548,
            3848838894, 3131266478, 1777918163, 146876953,  3279827269, 2644461735, 4156372383,
            2786264663, 3976156700, 1708974143, 1878547888, 2168041590, 2793923820, 1999154400,
            1510428126, 716404149,  3392113666, 3102243824, 2479551429, 651997355,  282914223,
            2085613514, 3767702588, 1275979651, 1971798134, 978904005,  503506384,  1951622548,
            300654823,  2565125471, 2782642813, 1458431750, 2186817324, 3123973648, 3491609,
            1319592872, 452433679,  1075424534, 1437913158, 2828944016, 3301346775, 2333281307,
            207992406,  2153172585, 2664450619, 691091062,  3553502652, 3114255216, 17137237,
            2197910648, 2310382370, 3153689868, 2548008553, 802137134,  2272766890, 31122394,
            468580641,  4069482373, 3909775167, 2468361281, 2982007782, 1445286890, 2807823912,
            3319492525, 672057044,  2108452841, 1755577669, 12831353,   1878151473, 805157552,
            1271858417, 2623540912, 461887094,  3215921223, 751773221,  1517221627, 3922191946,
            1317394918, 361845001,  640541709,  421086624,  2173849516, 3385587450, 2655936801,
            773140636,  2158026018, 1085377158, 1475601973, 587202971,  736117181,  2456162322,
            2158960374, 911455077,  2517883370, 268231205,  541474497,  943191315,  1500275507,
            2037251305, 725960194,  2044207227, 2481150802, 2036633808, 2665008587, 3575011225,
            1553111865, 2301231777, 87868216,   2163964019, 598195098,  2139882719, 2007840238,
            517907301,  2788202059, 223311969,  2622859522, 151920263,  3926046234, 740986174,
            3563756446, 2886083960, 1338937928, 1911066215, 2426323587, 625828138,  2991888140,
            2652286195, 2031853435, 1831149435, 1427632724, 1345475301, 289801789,  3509674153,
            3977153945, 185662179,  536505093,  2727322952, 3980498348, 2529622213, 1903052964,
            3564714651, 2281240568, 533384122,  277613480,  1815540358, 282763841,  3669112623,
            2572859425, 195220178,  1210883545, 2359703600, 1187537824, 675732974,  325036095,
            708091465,  2556854604, 701006284,  2378459191, 1863513103, 2690918197, 4237307694,
            1356483501, 2160905652, 521809106,  974368613,  3136010957, 2722488678, 3711515637,
            2296341459, 4233729945, 1196247571, 3031398071, 515543502,  1314129776, 3235373306,
            1303165859, 1820568009, 559099351,  186876368,  1076102111, 1218809551, 1790301111,
            4130210229, 768125358,  1132864749, 4262563773, 2294411020, 4092943985, 2558108246,
            3737664949, 2219923393, 724326159,  4134105682, 4188752746, 3615233671, 1526018731,
            2281637916, 2459490295, 3637342666, 777862587,  39962002,   3772005832, 997473319,
            574843584,  3356551974, 1265234427, 1698059437, 534747571,  1465532164, 3263029035,
            534512444,  2343092827, 2375685652, 2497926141, 2377933621, 2212335180, 261114084,
            172755755,  2737085495, 2225257145, 148605658,  1353911796, 357753009,  1778732943,
            497635558,  4136467976, 2837964962, 4045039047, 2485296762, 1587587183, 4042904168,
            3184240963, 2393293696, 915444966,  2299938515, 3351580749, 506575598,  1541916825,
            3465300401, 525927458,  681152801,  331660975,  3624685846, 2994172100, 3274369082,
            3638287602, 815689760,  1710961092, 2775607076, 2175058103, 3252688367, 2936890483,
            2746319120, 2736754,    1646031035, 2448701214, 2886833213, 3689830606, 3292798106,
            300773646,  3125160783, 1247453205, 2746275624, 4011063775, 904135764,  876847374,
            366267234,  2541269205, 131376648,  1805948133, 3383589530, 2350119829, 2513170439,
            4096158499, 4229211520, 2992048272, 1338522080, 1187391335, 2898563453, 2163088451,
            1417971677, 2047421551, 902282791,  1143943232, 3568431811, 4059861993, 193362198,
            2509297125, 3968551582, 2175686117, 3568936881, 1853177468, 2134063169, 2919389416,
            1124914545, 1209806738,
        },
        {
            2203497141, 3570053631, 2039617957, 2736225367, 2230357572, 1196348017, 3156570768,
            2493532257, 33731229,   2052535529, 2978282654, 3094611919, 3249249329, 854694105,
            3656757887, 2016730287, 2119764464, 1869755485, 803057681,  145486172,  742246698,
            167823412,  202880081,  2176222713, 848337559,  1722321813, 704420735,  3072743525,
            979272437,  3672248061, 3854081261, 2031150219, 2800536517, 3569402998, 886907854,
            2385223929, 3963045084, 3723971673, 2749164948, 2184581670, 3594742233, 2963360693,
            3297632312, 4060825944, 3279619678, 683377891,  2545704480, 2276099316, 2371371401,
            4164818621, 873484456,  3560199742, 3121368036, 380304829,  162500145,  1221860569,
            2837694080, 2728430533, 2728757442, 251274609,  1073821078, 3251590143, 1150691297,
            833689548,  2259640383, 2099803462, 1118076355, 3095773252, 719338190,  2694699222,
            2807199228, 286538445,  3010859570, 3775023471, 1408798685, 3249821327, 980181433,
            762713904,  614466233,  352290341,  839009917,  202006940,  3118884715, 2518138473,
            3675817540, 1804397962, 489562937,  1921026947, 1013058442, 2111052972, 1302841914,
            1522107182, 1025132041, 2370129380, 4157384694, 2719955682, 2786467380, 3386079116,
            1772578557, 1952429932, 3018314359, 3875647555, 3432977222, 1779930734, 3446117602,
            4286637427, 3554844910, 2935452903, 1677365488, 2607580858, 3367919297, 1613790314,
            3512507766, 3519635954, 699297171,  843185173,  3114166637, 2624248568, 2835199869,
            3984696587, 1771932288, 3106828164, 2868678403, 557806543,  3565478594, 1495211309,
            33347753,   3830518191, 2261102647, 3501153526, 1890900204, 1938975178, 2025646105,
            2085462445, 600577907,  2275764586, 1976768868, 2023354429, 1097212131, 4153022631,
            3586057552, 911687730,  3296105103, 2029025516, 373039417,  1128542092, 1789472285,
            2358502513, 905173134,  2842366622, 53615315,   22219687,   346580540,  3718125257,
            1324900962, 2118996614, 159068394,  1953548423, 921821158,  3922040539, 235723732,
            2203497141, 3570053631, 2039617957, 2736225367, 968575152,  1196348017, 3156570768,
            2493532257, 33731229,   1450135229, 2978282654, 3094611919, 3249249329, 854694105,
            1578906377, 2016730287, 2119764464, 1869755485, 803057681,  3043138013, 742246698,
            167823412,  202880081,  2176222713, 4231836255, 1722321813, 704420735,  3072743525,
            979272437,  2057753866, 3854081261, 2031150219, 2800536517, 3569402998, 3310347405,
            2385223929, 3963045084, 3723971673, 2749164948, 3231380648, 3594742233, 2963360693,
            3297632312, 4060825944, 2142412261, 683377891,  2545704480, 2276099316, 2371371401,
            635559994,  873484456,  3560199742, 3121368036, 380304829,  1691267988, 1221860569,
            2837694080, 2728430533, 2728757442, 3059900737, 1073821078, 3251590143, 1150691297,
            833689548,  3594845045, 2099803462, 1118076355, 3095773252, 719338190,  3002581042,
            2807199228, 286538445,  3010859570, 3775023471, 3983462736, 3249821327, 980181433,
            762713904,  614466233,  3492087926, 839009917,  202006940,  3118884715, 2518138473,
            2829367127, 1804397962, 489562937,  1921026947, 1013058442, 3080972711, 1302841914,
            1522107182, 1025132041, 2370129380, 1684200806, 2719955682, 2786467380, 3386079116,
            1772578557, 3462456698, 3018314359, 3875647555, 3432977222, 1779930734, 2616107256,
            4286637427, 3554844910, 2935452903, 1677365488, 1337933465, 3367919297, 1613790314,
            3512507766, 3519635954, 2652624599, 843185173,  3114166637, 2624248568, 2835199869,
            1313896995, 1771932288, 3106828164, 2868678403, 557806543,  314538892,  1495211309,
            33347753,   3830518191, 2261102647, 2708333367, 1890900204, 1938975178, 2025646105,
            2085462445, 2141012623, 2275764586, 1976768868, 2023354429, 1097212131, 1280458134,
            3586057552, 911687730,  3296105103, 2029025516, 1417425642, 1128542092, 1789472285,
            2358502513, 905173134,  883476084,  53615315,   22219687,   346580540,  3718125257,
            3219176867, 2118996614, 159068394,  1953548423, 921821158,  4275446296, 235723732,
            2203497141, 3570053631, 2039617957, 2424141359, 968575152,  1196348017, 3156570768,
            2493532257, 1244375178, 1450135229, 2978282654, 3094611919, 3249249329, 1899377552,
            1578906377, 2016730287, 2119764464, 1869755485, 909649184,  3043138013, 742246698,
            167823412,  202880081,  1141469098, 4231836255, 1722321813, 704420735,  3072743525,
            164964222,  2057753866, 3854081261, 2031150219, 2800536517, 3015977379, 3310347405,
            2385223929, 3963045084, 3723971673, 580078463,  3231380648, 3594742233, 2963360693,
            3297632312, 3935488803, 2142412261, 683377891,  2545704480, 2276099316, 3383930054,
            635559994,  873484456,  3560199742, 3121368036, 509839601,  1691267988, 1221860569,
            2837694080, 2728430533, 271645475,  3059900737, 1073821078, 3251590143, 1150691297,
            186681426,  3594845045, 2099803462, 1118076355, 3095773252, 3851848329, 3002581042,
            2807199228, 286538445,  3010859570, 2447959212, 3983462736, 3249821327, 980181433,
            762713904,  3210445938, 3492087926, 839009917,  202006940,  3118884715, 676012051,
            2829367127, 1804397962, 489562937,  1921026947, 3874337827, 3080972711, 1302841914,
            1522107182, 1025132041, 285116121,  1684200806, 2719955682, 2786467380, 3386079116,
            3796293984, 3462456698, 3018314359, 3875647555, 3432977222, 404873649,  2616107256,
            4286637427, 3554844910, 2935452903, 3284487088, 1337933465, 3367919297, 1613790314,
            3512507766, 1099655164, 2652624599, 843185173,  3114166637, 2624248568, 3596701765,
            1313896995, 1771932288, 3106828164, 2868678403, 463082058,  314538892,  1495211309,
            33347753,   3830518191, 1651990554, 2708333367, 1890900204, 1938975178, 2025646105,
            3218410909, 2141012623, 2275764586, 1976768868, 2023354429, 2344052628, 1280458134,
            3586057552, 911687730,  3296105103, 3935418500, 1417425642, 1128542092, 1789472285,
            2358502513, 2878128451, 883476084,  53615315,   22219687,   346580540,  60583590,
            3219176867, 2118996614, 159068394,  1953548423, 1279337592, 4275446296, 235723732,
            2203497141, 3570053631, 2275930662, 2424141359, 968575152,  1196348017, 3156570768,
            1151477960, 1244375178, 1450135229, 2978282654, 3094611919, 2408284643, 1899377552,
            1578906377, 2016730287, 2119764464, 2979144316, 909649184,  3043138013, 742246698,
            167823412,  3423452295, 1141469098, 4231836255, 1722321813, 704420735,  4218585634,
            164964222,  2057753866, 3854081261, 2031150219, 2368038313, 3015977379, 3310347405,
            2385223929, 3963045084, 582587657,  580078463,  3231380648, 3594742233, 2963360693,
            3775761136, 3935488803, 2142412261, 683377891,  2545704480, 472112455,  3383930054,
            635559994,  873484456,  3560199742, 2696668585, 509839601,  1691267988, 1221860569,
            2837694080, 1819975394, 271645475,  3059900737, 1073821078, 3251590143, 1504818062,
            186681426,  3594845045, 2099803462, 1118076355, 1920947835, 3851848329, 3002581042,
            2807199228, 286538445,  3211776198, 2447959212, 3983462736, 3249821327, 980181433,
            632118670,  3210445938, 3492087926, 839009917,  202006940,  3125833095, 676012051,
            2829367127, 1804397962, 489562937,  2631854235, 3874337827, 3080972711, 1302841914,
            1522107182, 78668255,   285116121,  1684200806, 2719955682, 2786467380, 4100318230,
            3796293984, 3462456698, 3018314359, 3875647555, 4273709523, 404873649,  2616107256,
            4286637427, 3554844910, 1921460410, 3284487088, 1337933465, 3367919297, 1613790314,
            3131565481, 1099655164, 2652624599, 843185173,  3114166637, 1723647537, 3596701765,
            1313896995, 1771932288, 3106828164, 2333715351, 463082058,  314538892,  1495211309,
            33347753,   3624300308, 1651990554, 2708333367, 1890900204, 1938975178, 1071548614,
            3218410909, 2141012623, 2275764586, 1976768868, 1760597494, 2344052628, 1280458134,
            3586057552, 911687730,  4208143855, 3935418500, 1417425642, 1128542092, 1789472285,
            3432968478, 2878128451, 883476084,  53615315,   22219687,   1262888092, 60583590,
            3219176867, 2118996614, 159068394,  772646492,  2322344519, 1343195764, 320926492,
            1376317846, 4207351715, 4093522914, 4078499363, 2547023192, 2104867258, 1189242163,
            1734245251, 4045030590, 3985066417, 1509320948, 710726403,  3748134423, 1627168816,
            2961339786, 2517365148, 3894454371, 615875115,  1294181052, 3263082559, 2597779650,
            2392774247, 2426123246, 1567867851, 2917865107, 669360109,  1696478840, 3698300855,
            1257391026, 99999195,   3741158414, 2058398967, 3467472311, 2388846259, 1589467321,
            2142910581, 2097612852, 1605240247, 977242974,  1955955159, 3507929753, 3523795214,
            2313232271, 212100871,  3970302699, 2700001709, 1107502061, 2672358267, 899763043,
            1051774264, 304277569,  960013545,  4077626023, 361781895,  2938945589, 3148958674,
            1087626,    1191363990, 2385575457, 1941973655, 117849198,  3135523953, 1876407211,
            2679175177, 1693665189, 2999940391, 3244821969, 1666913502, 787506785,  411203025,
            27193108,   1787356135, 4177031377, 3732023590, 1548326718, 1269624277, 728286206,
            3640836244, 1267906039, 885465967,  2979092199, 2357349460, 4215784432, 755451097,
            2870233028, 3535064580, 3494662004, 2822633526, 2223362946, 3192844089, 464312418,
            757023728,  3076701531, 1867870024, 3595644004, 282972619,  3620167396, 768340241,
            2943393518, 3075748853, 2009602799, 3449152035, 4262176570, 783791178,  304899146,
            3330646714, 3836698585, 3394609047, 2372457756, 3896900961, 3432374517, 2664275828,
            3368637642, 3714489930, 1687406413, 3240277904, 241781731,  1627240095, 3594799201,
            1937505133, 3185280340, 3441812682, 3365794497, 2809491704, 724116355,  3098092723,
            1551755508, 2230845755, 714217188,  3966649173, 3487820619, 3970117143, 1411689852,
            669945808,  2549124296, 1614158230, 136854349,  1624813243, 3949971759, 2805855417,
            1921192425, 2392964508, 1953665139, 2665687287, 3399424541, 2312844689, 8619739,
            3424483269, 1737602694, 1396273394, 1342925345, 2270759853, 3424595761, 3481485719,
            1885600820, 237940402,
        },
        {
            1199972651, 1035834631, 3177798370, 860834162,  3741677748, 3780327829, 1693730265,
            1643429511, 559568669,  2758650294, 647308222,  3901603996, 1778653821, 3618523672,
            2154201067, 4261179460, 3285764480, 3334002738, 3215795953, 91368462,   1883994950,
            1506873376, 1527780962, 4046354597, 4081676034, 2389066602, 1574939945, 427845396,
            2714836263, 1259019491, 2493238133, 2584034689, 3151382431, 2171033919, 176883719,
            2031844862, 1272380790, 1298975901, 4087222847, 1524000054, 311436877,  3627785554,
            1889491722, 2938069193, 2771940687, 2756955968, 4289348777, 263514583,  887207028,
            3522902525, 2273246349, 835377715,  2897243319, 204645450,  1775911983, 639470242,
            2856296318, 3032942383, 2845501282, 1979082575, 202834023,  1876303820, 1434703409,
            4240524132, 848853780,  4188621628, 928095314,  876412914,  3446576392, 3235688990,
            4021419931, 2483628986, 3155781890, 399997246,  1642535200, 3872575068, 1577956550,
            3606228634, 609914462,  653194726,  4048067248, 2500767965, 1125167825, 3707628088,
            1819135158, 1875618971, 3865851141, 328215079,  1695889194, 2040280471, 3384684457,
            2540504961, 293050253,  525570078,  2655676443, 1392199429, 3370444585, 1937915855,
            2229636250, 247937142,  2534538765, 365841057,  2449431033, 2456532429, 101910696,
            1247069485, 1523958293, 2473285670, 473709728,  3026667113, 2071968844, 324025193,
            423064436,  3870800061, 3977393138, 3632553233, 352757977,  1584833348, 3173248650,
            1159857686, 1501841977, 1751860798, 617281070,  1958012761, 4031667102, 3232142321,
            3087428595, 2380824676, 1194087757, 1542961747, 4163350364, 1721646249, 1672791861,
            2900511710, 24973500,   1705444176, 713642505,  3017719513, 2090715200, 3521434070,
            37117223,   1948295454, 3055840561, 3476120789, 3994249388, 527899063,  4285770666,
            1075524023, 2594223535, 392943522,  171012646,  3515750082, 3414659054, 3501852926,
            1493283737, 2662104279, 2033464928, 90134967,   363058647,  3289266998, 2470752727,
            1199972651, 1035834631, 3177798370, 860834162,  1791097822, 3780327829, 1693730265,
            1643429511, 559568669,  3503319486, 647308222,  3901603996, 1778653821, 3618523672,
            4294594427, 4261179460, 3285764480, 3334002738, 3215795953, 212518363,  1883994950,
            1506873376, 1527780962, 4046354597, 2398655600, 2389066602, 1574939945, 427845396,
            2714836263, 2744363872, 2493238133, 2584034689, 3151382431, 2171033919, 2787053497,
            2031844862, 1272380790, 1298975901, 4087222847, 2342953154, 311436877,  3627785554,
            1889491722, 2938069193, 2026656505, 2756955968, 4289348777, 263514583,  887207028,
            2097276163, 2273246349, 835377715,  2897243319, 204645450,  4233399907, 639470242,
            2856296318, 3032942383, 2845501282, 28260330,   202834023,  1876303820, 1434703409,
            4240524132, 2455670466, 4188621628, 928095314,  876412914,  3446576392, 117581687,
            4021419931, 2483628986, 3155781890, 399997246,  4254101087, 3872575068, 1577956550,
            3606228634, 609914462,  4003279048, 4048067248, 2500767965, 1125167825, 3707628088,
            922020515,  1875618971, 3865851141, 328215079,  1695889194, 625773097,  3384684457,
            2540504961, 293050253,  525570078,  2592805114, 1392199429, 3370444585, 1937915855,
            2229636250, 3190958614, 2534538765, 365841057,  2449431033, 2456532429, 3778669305,
            1247069485, 1523958293, 2473285670, 473709728,  720895889,  2071968844, 324025193,
            423064436,  3870800061, 3535536111, 3632553233, 352757977,  1584833348, 3173248650,
            2649344603, 1501841977, 1751860798, 617281070,  1958012761, 778965559,  3232142321,
            3087428595, 2380824676, 1194087757, 3880222002, 4163350364, 1721646249, 1672791861,
            2900511710, 702936770,  1705444176, 713642505,  3017719513, 2090715200, 1477858694,
            37117223,   1948295454, 3055840561, 3476120789, 464173532,  527899063,  4285770666,
            1075524023, 2594223535, 2872629966, 171012646,  3515750082, 3414659054, 3501852926,
            1631555059, 2662104279, 2033464928, 90134967,   363058647,  4112991722, 2470752727,
            1199972651, 1035834631, 3177798370, 4152098951, 1791097822, 3780327829, 1693730265,
            1643429511, 153020604,  3503319486, 647308222,  3901603996, 1778653821, 221887019,
            4294594427, 4261179460, 3285764480, 3334002738, 3340918862, 212518363,  1883994950,
            1506873376, 1527780962, 430180116,  2398655600, 2389066602, 1574939945, 427845396,
            1683639957, 2744363872, 2493238133, 2584034689, 3151382431, 752704472,  2787053497,
            2031844862, 1272380790, 1298975901, 1528220628, 2342953154, 311436877,  3627785554,
            1889491722, 2576495467, 2026656505, 2756955968, 4289348777, 263514583,  3778019638,
            2097276163, 2273246349, 835377715,  2897243319, 1060067446, 4233399907, 639470242,
            2856296318, 3032942383, 2351047932, 28260330,   202834023,  1876303820, 1434703409,
            3094305336, 2455670466, 4188621628, 928095314,  876412914,  3785385583, 117581687,
            4021419931, 2483628986, 3155781890, 1867816730, 4254101087, 3872575068, 1577956550,
            3606228634, 3081878598, 4003279048, 4048067248, 2500767965, 1125167825, 928465955,
            922020515,  1875618971, 3865851141, 328215079,  173810260,  625773097,  3384684457,
            2540504961, 293050253,  2645143254, 2592805114, 1392199429, 3370444585, 1937915855,
            162781360,  3190958614, 2534538765, 365841057,  2449431033, 3105377832, 3778669305,
            1247069485, 1523958293, 2473285670, 800971948,  720895889,  2071968844, 324025193,
            423064436,  52577992,   3535536111, 3632553233, 352757977,  1584833348, 3305908059,
            2649344603, 1501841977, 1751860798, 617281070,  264880505,  778965559,  3232142321,
            3087428595, 2380824676, 1127761012, 3880222002, 4163350364, 1721646249, 1672791861,
            2368512339, 702936770,  1705444176, 713642505,  3017719513, 197200752,  1477858694,
            37117223,   1948295454, 3055840561, 1588372042, 464173532,  527899063,  4285770666,
            1075524023, 2124039914, 2872629966, 171012646,  3515750082, 3414659054, 818571456,
            1631555059, 2662104279, 2033464928, 90134967,   952712086,  4112991722, 2470752727,
            1199972651, 1035834631, 888975816,  4152098951, 1791097822, 3780327829, 1693730265,
            3406785510, 153020604,  3503319486, 647308222,  3901603996, 3753248472, 221887019,
            4294594427, 4261179460, 3285764480, 1861431346, 3340918862, 212518363,  1883994950,
            1506873376, 2695939612, 430180116,  2398655600, 2389066602, 1574939945, 2852159074,
            1683639957, 2744363872, 2493238133, 2584034689, 1952065633, 752704472,  2787053497,
            2031844862, 1272380790, 3530505866, 1528220628, 2342953154, 311436877,  3627785554,
            3410473245, 2576495467, 2026656505, 2756955968, 4289348777, 2856163034, 3778019638,
            2097276163, 2273246349, 835377715,  3127280755, 1060067446, 4233399907, 639470242,
            2856296318, 2615775011, 2351047932, 28260330,   202834023,  1876303820, 619308202,
            3094305336, 2455670466, 4188621628, 928095314,  3764894047, 3785385583, 117581687,
            4021419931, 2483628986, 3759839215, 1867816730, 4254101087, 3872575068, 1577956550,
            1687107439, 3081878598, 4003279048, 4048067248, 2500767965, 2804044146, 928465955,
            922020515,  1875618971, 3865851141, 2359176389, 173810260,  625773097,  3384684457,
            2540504961, 3665420733, 2645143254, 2592805114, 1392199429, 3370444585, 1604709429,
            162781360,  3190958614, 2534538765, 365841057,  3843585067, 3105377832, 3778669305,
            1247069485, 1523958293, 293374051,  800971948,  720895889,  2071968844, 324025193,
            3342361801, 52577992,   3535536111, 3632553233, 352757977,  1386594581, 3305908059,
            2649344603, 1501841977, 1751860798, 3160423601, 264880505,  778965559,  3232142321,
            3087428595, 3814775120, 1127761012, 3880222002, 4163350364, 1721646249, 3640773034,
            2368512339, 702936770,  1705444176, 713642505,  1717761787, 197200752,  1477858694,
            37117223,   1948295454, 896215772,  1588372042, 464173532,  527899063,  4285770666,
            3441409029, 2124039914, 2872629966, 171012646,  3515750082, 2216687886, 818571456,
            1631555059, 2662104279, 2033464928, 369438400,  329003658,  1503365029, 4215790910,
            3264377550, 733526983,  2935318632, 1792331479, 608347530,  392723097,  1330445854,
            3473004271, 1267636682, 2150566972, 2664910943, 2591861637, 409769584,  2943326880,
            3746302819, 3162268832, 1028663260, 3206607045, 832105292,  2119405275, 538318455,
            2981192295, 861775416,  609718403,  3531204230, 1904759571, 1262633751, 2375133081,
            460454984,  946700253,  3763898311, 1571175213, 3124410107, 2413420216, 2664177543,
            3241803820, 3968067371, 1234860999, 1130471500, 772727786,  247203117,  576455235,
            246297007,  2027348597, 764933887,  3812479771, 1825807084, 4072281412, 2156865781,
            1286484847, 1966749063, 2479269303, 423506843,  3070938758, 653091413,  2267423132,
            2004263526, 1374490719, 3871990628, 841138314,  1260317857, 3887432433, 4025147569,
            764233331,  1794763428, 3005903468, 877926770,  2466593927, 2971729561, 3203070565,
            4198500026, 815665759,  2434508139, 1840456368, 2279000427, 17077200,   3178380570,
            990304199,  3578008580, 1965763660, 1640352477, 750159594,  2047409402, 3576308245,
            544920564,  1730124869, 1194761386, 3280315505, 147334027,  2870674244, 2076860776,
            1100947675, 2482772161, 401966468,  1610650855, 193868446,  3808157106, 1509130117,
            1324484736, 3852893217, 1059179497, 4053543778, 2557844172, 3282312002, 682550058,
            4281899173, 137171998,  3239159214, 2258610918, 426724741,  3502660993, 135977383,
            429929363,  3984458137, 964026748,  2182019070, 3836562946, 515026869,  359030455,
            1301694917, 2300414803, 2364654981, 3804876710, 171119249,  2646785698, 4283509387,
            3628087763, 1748227044, 3037141234, 3000413256, 23007314,   3598880509, 4160517314,
            112205578,  1677675411, 734881643,  2830770338, 3470317145, 3306806569, 2635040943,
            2671367560, 3528996498, 3878886478, 3114253828, 2721384408, 3175226991, 1393767271,
            2651623266, 3767978376, 1269699398, 1100964192, 4169085845, 2086718107, 1286251099,
            764751784,  3006878591,
        },
        {
            2893855407, 3672831545, 4175338961, 139160562,  2208156313, 1942679270, 3229486170,
            3644614988, 1428607246, 1774399332, 1094578641, 3650114048, 1748259022, 936188696,
            3398730278, 623547049,  1390937383, 613931869,  564726986,  2087327984, 1186155695,
            2258810393, 1261696485, 2658950424, 650578282,  3863679919, 2620039454, 3914809820,
            10926219,   170139906,  4064047111, 806704438,  3533175081, 2161377512, 3783164862,
            3666665613, 632399064,  1332109152, 532226047,  3815707700, 124462147,  736298500,
            3033651612, 406968073,  1371474516, 2418125585, 3243070435, 4119882541, 3808821432,
            3049706562, 3275129807, 2057748812, 3382404123, 2011039444, 3430236256, 1915360039,
            2521456689, 1670292016, 2180944295, 3406925268, 1535382497, 188633982,  2345586589,
            3492758479, 2950204781, 200740467,  730233954,  187916330,  2074265818, 250079823,
            2306415484, 523110696,  1275490885, 1682984523, 4111432958, 2792756022, 1418501664,
            3727912467, 3865825506, 2017480042, 2386866411, 1421061973, 75953898,   2859830984,
            3410518657, 1393024129, 2177843987, 2130139566, 1632793203, 1581377288, 394239662,
            3925371,    3933456749, 4282697650, 3538042077, 3827074442, 177499146,  4208708295,
            2216175995, 3196377215, 592605347,  4047753296, 3029912328, 872875160,  2964646211,
            3454409065, 1795830937, 1037849604, 1875060397, 1075768721, 446626067,  3742176367,
            4259895141, 438646908,  937636241,  1892448624, 4052502213, 1194009950, 3224850096,
            207085006,  554901425,  2338213893, 2601973634, 955015051,  1779618627, 1357780747,
            1185745232, 687283987,  1647936116, 309882134,  734457531,  3155786053, 2253374011,
            270907144,  3734911296, 1435193916, 2811253712, 1956419466, 933458970,  4141609775,
            1412516617, 1282325166, 1688204976, 3477921380, 3246052366, 3644490622, 3787486000,
            3751200652, 3752879128, 3222272330, 1128703970, 3067280043, 1191955024, 2297112531,
            2232082178, 1784253851, 2805280758, 3526078160, 1350756598, 3591854496, 69903006,
            2893855407, 3672831545, 4175338961, 139160562,  772156935,  1942679270, 3229486170,
            3644614988, 1428607246, 1724560674, 1094578641, 3650114048, 1748259022, 936188696,
            829137005,  623547049,  1390937383, 613931869,  564726986,  1004351629, 1186155695,
            2258810393, 1261696485, 2658950424, 3431376569, 3863679919, 2620039454, 3914809820,
            10926219,   800370536,  4064047111, 806704438,  3533175081, 2161377512, 3466312926,
            3666665613, 632399064,  1332109152, 532226047,  1350643555, 124462147,  736298500,
            3033651612, 406968073,  679453255,  2418125585, 3243070435, 4119882541, 3808821432,
            2600938970, 3275129807, 2057748812, 3382404123, 2011039444, 1006807041, 1915360039,
            2521456689, 1670292016, 2180944295, 603908877,  1535382497, 188633982,  2345586589,
            3492758479, 1366896316, 200740467,  730233954,  187916330,  2074265818, 1519533398,
            2306415484, 523110696,  1275490885, 1682984523, 1175326176, 2792756022, 1418501664,
            3727912467, 3865825506, 1473686265, 2386866411, 1421061973, 75953898,   2859830984,
            510685854,  1393024129, 2177843987, 2130139566, 1632793203, 1601726033, 394239662,
            3925371,    3933456749, 4282697650, 559775013,  3827074442, 177499146,  4208708295,
            2216175995, 2600392286, 592605347,  4047753296, 3029912328, 872875160,  1485078394,
            3454409065, 1795830937, 1037849604, 1875060397, 2932055369, 446626067,  3742176367,
            4259895141, 438646908,  1364888200, 1892448624, 4052502213, 1194009950, 3224850096,
            1558089695, 554901425,  2338213893, 2601973634, 955015051,  1056295602, 1357780747,
            1185745232, 687283987,  1647936116, 2625651871, 734457531,  3155786053, 2253374011,
            270907144,  3103500393, 1435193916, 2811253712, 1956419466, 933458970,  2339654023,
            1412516617, 1282325166, 1688204976, 3477921380, 1334459122, 3644490622, 3787486000,
            3751200652, 3752879128, 1728969804, 1128703970, 3067280043, 1191955024, 2297112531,
            2920445928, 1784253851, 2805280758, 3526078160, 1350756598, 4010811070, 69903006,
            2893855407, 3672831545, 4175338961, 3294416999, 772156935,  1942679270, 3229486170,
            3644614988, 1555733480, 1724560674, 1094578641, 3650114048, 1748259022, 4204324814,
            829137005,  623547049,  1390937383, 613931869,  673588406,  1004351629, 1186155695,
            2258810393, 1261696485, 4019857905, 3431376569, 3863679919, 2620039454, 3914809820,
            558201075,  800370536,  4064047111, 806704438,  3533175081, 2099374190, 3466312926,
            3666665613, 632399064,  1332109152, 2158975939, 1350643555, 124462147,  736298500,
            3033651612, 4220848726, 679453255,  2418125585, 3243070435, 4119882541, 465482308,
            2600938970, 3275129807, 2057748812, 3382404123, 2462577499, 1006807041, 1915360039,
            2521456689, 1670292016, 1320097485, 603908877,  1535382497, 188633982,  2345586589,
            2561748330, 1366896316, 200740467,  730233954,  187916330,  1254046114, 1519533398,
            2306415484, 523110696,  1275490885, 1585772390, 1175326176, 2792756022, 1418501664,
            3727912467, 1309251480, 1473686265, 2386866411, 1421061973, 75953898,   1079634550,
            510685854,  1393024129, 2177843987, 2130139566, 1924003153, 1601726033, 394239662,
            3925371,    3933456749, 2485276933, 559775013,  3827074442, 177499146,  4208708295,
            2671675584, 2600392286, 592605347,  4047753296, 3029912328, 1647842438, 1485078394,
            3454409065, 1795830937, 1037849604, 332177657,  2932055369, 446626067,  3742176367,
            4259895141, 2403864989, 1364888200, 1892448624, 4052502213, 1194009950, 222058886,
            1558089695, 554901425,  2338213893, 2601973634, 1457370715, 1056295602, 1357780747,
            1185745232, 687283987,  1106355371, 2625651871, 734457531,  3155786053, 2253374011,
            3413242901, 3103500393, 1435193916, 2811253712, 1956419466, 1296673701, 2339654023,
            1412516617, 1282325166, 1688204976, 1184774384, 1334459122, 3644490622, 3787486000,
            3751200652, 1997122731, 1728969804, 1128703970, 3067280043, 1191955024, 3007238781,
            2920445928, 1784253851, 2805280758, 3526078160, 2945605664, 4010811070, 69903006,
            2893855407, 3672831545, 142481896,  3294416999, 772156935,  1942679270, 3229486170,
            528536733,  1555733480, 1724560674, 1094578641, 3650114048, 970848941,  4204324814,
            829137005,  623547049,  1390937383, 2112703866, 673588406,  1004351629, 1186155695,
            2258810393, 3183617714, 4019857905, 3431376569, 3863679919, 2620039454, 1304568388,
            558201075,  800370536,  4064047111, 806704438,  365503711,  2099374190, 3466312926,
            3666665613, 632399064,  424983456,  2158975939, 1350643555, 124462147,  736298500,
            3578999261, 4220848726, 679453255,  2418125585, 3243070435, 3331713550, 465482308,
            2600938970, 3275129807, 2057748812, 2793524236, 2462577499, 1006807041, 1915360039,
            2521456689, 336546814,  1320097485, 603908877,  1535382497, 188633982,  2690145866,
            2561748330, 1366896316, 200740467,  730233954,  3014428387, 1254046114, 1519533398,
            2306415484, 523110696,  1424493889, 1585772390, 1175326176, 2792756022, 1418501664,
            3342289361, 1309251480, 1473686265, 2386866411, 1421061973, 2164607900, 1079634550,
            510685854,  1393024129, 2177843987, 2263359784, 1924003153, 1601726033, 394239662,
            3925371,    4120845084, 2485276933, 559775013,  3827074442, 177499146,  4088500640,
            2671675584, 2600392286, 592605347,  4047753296, 1313071305, 1647842438, 1485078394,
            3454409065, 1795830937, 1477837752, 332177657,  2932055369, 446626067,  3742176367,
            2065221790, 2403864989, 1364888200, 1892448624, 4052502213, 2088377252, 222058886,
            1558089695, 554901425,  2338213893, 55758251,   1457370715, 1056295602, 1357780747,
            1185745232, 2343205858, 1106355371, 2625651871, 734457531,  3155786053, 2013719608,
            3413242901, 3103500393, 1435193916, 2811253712, 2227679709, 1296673701, 2339654023,
            1412516617, 1282325166, 406804293,  1184774384, 1334459122, 3644490622, 3787486000,
            1874671668, 1997122731, 1728969804, 1128703970, 3067280043, 43839063,   3007238781,
            2920445928, 1784253851, 2805280758, 399684783,  619329287,  2746455341, 307148108,
            444735609,  3443016342, 3694439126, 2885222111, 2446557141, 694681468,  222711500,
            84460442,   4275974097, 4161818801, 1843321273, 238873333,  2514620037, 3243794235,
            2971211790, 3463458837, 2628445064, 1749662868, 3050799871, 2763009946, 1151523621,
            426963368,  3012592750, 338538253,  3414060623, 1419447759, 399399371,  2808903587,
            1610926658, 3572725977, 373665297,  2718113501, 2921510512, 1093330776, 1514388146,
            2738844847, 2299400806, 4122483421, 716873192,  2795616272, 1042935,    387994484,
            1210516114, 332752891,  2041475119, 4108889000, 4250930220, 3861759250, 2604867059,
            814393039,  1644815597, 434670706,  2452207942, 3589464372, 602943120,  2311226774,
            1709355803, 1605229814, 3701082779, 2714072484, 3603636853, 2320785467, 2691133247,
            1107604883, 493318294,  3103728024, 3721929520, 1724934821, 818845414,  2444607981,
            477142773,  759232824,  3575425833, 3389024165, 3625498657, 718653667,  775955475,
            3449340064, 1587647538, 747258928,  3793900617, 2322288974, 2060646342, 236645305,
            2926534525, 1563946429, 145018742,  480364001,  4226378333, 79447140,   3889535612,
            2897502032, 1100495850, 1410781796, 1421566964, 2481019274, 619687266,  3710960394,
            637369083,  1089249426, 417766652,  1908206868, 881980937,  3188049498, 2690608705,
            2879592420, 2465016767, 2514836205, 2687322216, 4095099062, 1660176198, 414416806,
            2175580299, 569429173,  591839220,  3156880678, 175046600,  1743991089, 4293856311,
            2069384397, 156685790,  191822804,  3903595733, 1189009249, 3323617484, 1733242922,
            1595831018, 637842044,  4210595223, 2357001955, 716424191,  3792113587, 789865891,
            1408039369, 4020300706, 277771380,  300406109,  2501928064, 3630812965, 1394443938,
            120376747,  3767538346, 4172236271, 3190914335, 4055582701, 679593107,  4071668596,
            2634908480, 3926142955, 2366231463, 3461313605, 3038086696, 3079235711, 79149570,
            2862992874, 3237757041,
        },
        {
            2565473087, 1149521056, 3529037691, 630435548,  73598765,   1467331930, 3988027050,
            2771962200, 91261543,   980989218,  2227515435, 236831608,  2872772569, 2330469327,
            1654035853, 2883791516, 4170143763, 126418114,  127789935,  2114249438, 2933346767,
            639483386,  1532399845, 2182422151, 741069317,  2376371063, 3398508789, 3828295651,
            3963199356, 4156483769, 4206759111, 1266176088, 3210273687, 432131993,  667709537,
            874477513,  2304714957, 629309008,  116453438,  3051811727, 3490241985, 3355968243,
            2304043871, 2724990029, 1095724699, 2408437363, 1433161037, 3245468546, 2494529842,
            4204170637, 1966342448, 3092333073, 1861880941, 3990012367, 3710334908, 2526395471,
            1884691351, 2145882162, 2561288457, 2253122309, 1154858044, 1643256991, 3172857504,
            1096492713, 2848827103, 799826424,  3094672168, 3535834360, 4213256737, 1131757994,
            520495112,  575315345,  3823364867, 2424349582, 3604795017, 310789314,  4207205257,
            553462404,  2918228443, 2568360580, 3863565851, 874197736,  3329267685, 1186352580,
            3928193054, 1780200631, 4088289456, 3323217870, 2758854947, 3111637417, 990374143,
            2080149357, 4047813631, 2019887940, 578660736,  2145680301, 2328411541, 1572704242,
            405739686,  1869350271, 2046317220, 4021497634, 1385163990, 1935250885, 1132987169,
            581690993,  3172043012, 628071512,  2851125739, 2735324847, 2847267504, 3408334906,
            3352976111, 706277272,  2971786942, 2811957324, 3578703606, 1126685543, 2671169997,
            31952251,   2802110464, 2391618856, 3031260674, 1165714541, 2411388800, 2825634835,
            101928462,  477629709,  4257022506, 3281706767, 2576087732, 736533968,  2543083137,
            3430523686, 3272172013, 3056925798, 341993500,  406782950,  1770032304, 125786076,
            1321359723, 2901696227, 1890958265, 3610842776, 1772227311, 1564088598, 914173231,
            3734092059, 1652333721, 2386645282, 329706426,  1022239203, 1832393502, 4064995802,
            3497852986, 1046436763, 366391010,  2237068647, 2887356463, 304718827,  3969799795,
            2565473087, 1149521056, 3529037691, 630435548,  3758124054, 1467331930, 3988027050,
            2771962200, 91261543,   836545831,  2227515435, 236831608,  2872772569, 2330469327,
            3439193753, 2883791516, 4170143763, 126418114,  127789935,  1648940583, 2933346767,
            639483386,  1532399845, 2182422151, 2470139222, 2376371063, 3398508789, 3828295651,
            3963199356, 2997263135, 4206759111, 1266176088, 3210273687, 432131993,  2416600665,
            874477513,  2304714957, 629309008,  116453438,  2586542760, 3490241985, 3355968243,
            2304043871, 2724990029, 452934545,  2408437363, 1433161037, 3245468546, 2494529842,
            2244403710, 1966342448, 3092333073, 1861880941, 3990012367, 2774994234, 2526395471,
            1884691351, 2145882162, 2561288457, 2303702146, 1154858044, 1643256991, 3172857504,
            1096492713, 130979316,  799826424,  3094672168, 3535834360, 4213256737, 935499492,
            520495112,  575315345,  3823364867, 2424349582, 2272973265, 310789314,  4207205257,
            553462404,  2918228443, 2613016888, 3863565851, 874197736,  3329267685, 1186352580,
            4106984978, 1780200631, 4088289456, 3323217870, 2758854947, 1559861146, 990374143,
            2080149357, 4047813631, 2019887940, 1133329900, 2145680301, 2328411541, 1572704242,
            405739686,  63633520,   2046317220, 4021497634, 1385163990, 1935250885, 1762959503,
            581690993,  3172043012, 628071512,  2851125739, 3726073981, 2847267504, 3408334906,
            3352976111, 706277272,  3817450114, 2811957324, 3578703606, 1126685543, 2671169997,
            2749086326, 2802110464, 2391618856, 3031260674, 1165714541, 2210258428, 2825634835,
            101928462,  477629709,  4257022506, 2679409844, 2576087732, 736533968,  2543083137,
            3430523686, 1122549807, 3056925798, 341993500,  406782950,  1770032304, 2617760292,
            1321359723, 2901696227, 1890958265, 3610842776, 2666109620, 1564088598, 914173231,
            3734092059, 1652333721, 3456779008, 329706426,  1022239203, 1832393502, 4064995802,
            4006865520, 1046436763, 366391010,  2237068647, 2887356463, 1479646555, 3969799795,
            2565473087, 1149521056, 3529037691, 2379195579, 3758124054, 1467331930, 3988027050,
            2771962200, 1796797949, 836545831,  2227515435, 236831608,  2872772569, 544017308,
            3439193753, 2883791516, 4170143763, 126418114,  3811390247, 1648940583, 2933346767,
            639483386,  1532399845, 4165970043, 2470139222, 2376371063, 3398508789, 3828295651,
            4066952157, 2997263135, 4206759111, 1266176088, 3210273687, 560560354,  2416600665,
            874477513,  2304714957, 629309008,  2010844440, 2586542760, 3490241985, 3355968243,
            2304043871, 855615381,  452934545,  2408437363, 1433161037, 3245468546, 3813880871,
            2244403710, 1966342448, 3092333073, 1861880941, 3334256651, 2774994234, 2526395471,
            1884691351, 2145882162, 3500193798, 2303702146, 1154858044, 1643256991, 3172857504,
            3480843206, 130979316,  799826424,  3094672168, 3535834360, 915442396,  935499492,
            520495112,  575315345,  3823364867, 2876158574, 2272973265, 310789314,  4207205257,
            553462404,  2184663001, 2613016888, 3863565851, 874197736,  3329267685, 3447734684,
            4106984978, 1780200631, 4088289456, 3323217870, 2748493470, 1559861146, 990374143,
            2080149357, 4047813631, 2728282767, 1133329900, 2145680301, 2328411541, 1572704242,
            3396987326, 63633520,   2046317220, 4021497634, 1385163990, 1582181054, 1762959503,
            581690993,  3172043012, 628071512,  2790170929, 3726073981, 2847267504, 3408334906,
            3352976111, 1211075015, 3817450114, 2811957324, 3578703606, 1126685543, 1946225412,
            2749086326, 2802110464, 2391618856, 3031260674, 453222948,  2210258428, 2825634835,
            101928462,  477629709,  410621659,  2679409844, 2576087732, 736533968,  2543083137,
            1101977922, 1122549807, 3056925798, 341993500,  406782950,  3057489804, 2617760292,
            1321359723, 2901696227, 1890958265, 4035843698, 2666109620, 1564088598, 914173231,
            3734092059, 908525903,  3456779008, 329706426,  1022239203, 1832393502, 4024857205,
            4006865520, 1046436763, 366391010,  2237068647, 1564059380, 1479646555, 3969799795,
            2565473087, 1149521056, 2808155917, 2379195579, 3758124054, 1467331930, 3988027050,
            810008243,  1796797949, 836545831,  2227515435, 236831608,  608273331,  544017308,
            3439193753, 2883791516, 4170143763, 3309288977, 3811390247, 1648940583, 2933346767,
            639483386,  1685761277, 4165970043, 2470139222, 2376371063, 3398508789, 4275493636,
            4066952157, 2997263135, 4206759111, 1266176088, 333592630,  560560354,  2416600665,
            874477513,  2304714957, 1438974661, 2010844440, 2586542760, 3490241985, 3355968243,
            2556368068, 855615381,  452934545,  2408437363, 1433161037, 4061232080, 3813880871,
            2244403710, 1966342448, 3092333073, 3412770364, 3334256651, 2774994234, 2526395471,
            1884691351, 1414627588, 3500193798, 2303702146, 1154858044, 1643256991, 2245958719,
            3480843206, 130979316,  799826424,  3094672168, 2214560871, 915442396,  935499492,
            520495112,  575315345,  3894763683, 2876158574, 2272973265, 310789314,  4207205257,
            3203740771, 2184663001, 2613016888, 3863565851, 874197736,  3371653768, 3447734684,
            4106984978, 1780200631, 4088289456, 378312754,  2748493470, 1559861146, 990374143,
            2080149357, 554816113,  2728282767, 1133329900, 2145680301, 2328411541, 4249979994,
            3396987326, 63633520,   2046317220, 4021497634, 4185731269, 1582181054, 1762959503,
            581690993,  3172043012, 3142596028, 2790170929, 3726073981, 2847267504, 3408334906,
            2556911142, 1211075015, 3817450114, 2811957324, 3578703606, 1480672978, 1946225412,
            2749086326, 2802110464, 2391618856, 3986823297, 453222948,  2210258428, 2825634835,
            101928462,  26373721,   410621659,  2679409844, 2576087732, 736533968,  888001208,
            1101977922, 1122549807, 3056925798, 341993500,  3243663736, 3057489804, 2617760292,
            1321359723, 2901696227, 1652018736, 4035843698, 2666109620, 1564088598, 914173231,
            1857869366, 908525903,  3456779008, 329706426,  1022239203, 2622178179, 4024857205,
            4006865520, 1046436763, 366391010,  3722250905, 2880126367, 4102186560, 1642831571,
            2222486636, 2572764729, 2046028516, 3507603612, 1703451134, 89818497,   1961701523,
            3704300476, 3563143931, 1609575644, 1599081111, 1047838539, 2779312926, 2065354728,
            956677756,  2073145924, 726634994,  119064196,  2046275296, 2105141632, 1023267361,
            1204528080, 623740611,  1419328884, 933734693,  2030900835, 2556538268, 1672647866,
            3125658368, 2221217376, 1097330641, 3214790630, 4276041578, 2397216525, 3916900004,
            330223096,  3915966823, 2646760259, 1724289351, 4015221358, 2338587000, 110922222,
            2314933196, 4026908935, 3272487985, 2685115305, 84271650,   731354215,  2358136447,
            1069348214, 2676811333, 1386266810, 1364512901, 4154449904, 3469122709, 54276972,
            560967905,  2363475740, 331250049,  3024074455, 186605617,  389582566,  1258386782,
            703909543,  3968367083, 1553533794, 3699576213, 1145761343, 921983735,  3573813763,
            1280477631, 3365842435, 1618458494, 2621328991, 1534006198, 2307669227, 4192335609,
            1338050203, 785284052,  4227164890, 2874735332, 3655821191, 2911684671, 3266454200,
            2679968625, 1191162601, 456550349,  1143881236, 3560103440, 2253437876, 3683014001,
            1087142366, 1462192975, 1076595768, 3227872159, 1842092988, 148227073,  3812110998,
            1317300278, 3068446245, 3376284001, 3164402992, 2730404635, 2848239579, 3008959791,
            2901849226, 1234485739, 869158554,  245101118,  1724974650, 3851803199, 922411232,
            3046280696, 3284392523, 3528264590, 2802364078, 381450957,  1741009694, 4222244451,
            102929888,  1668474417, 3881791214, 1429483134, 1938365051, 1023690708, 3333855520,
            3238705869, 2602245525, 3059586169, 720438965,  2120786297, 453980990,  1048501876,
            4060576583, 3537810796, 3892882814, 691572481,  3899584121, 1582529013, 3260326865,
            2358704826, 1607030801, 1035900449, 3442507859, 1406737127, 249758705,  1535363329,
            893329207,  51912312,   3440532856, 3736385218, 295452658,  2379709553, 1647382020,
            2363679860, 2998779887,
        },
        {
            584992706,  1845306784, 2469422923, 3976125854, 1564257968, 574162881,  2948747359,
            1246917536, 3658489516, 3809617789, 4055090993, 2496113310, 2728616354, 1114028061,
            659846138,  250113388,  2359328429, 4094482486, 2191541402, 1414276571, 3425984193,
            347926320,  1860926138, 1361091734, 3623816223, 879211029,  3983871590, 2797101988,
            4092357018, 707755989,  4109621879, 3131099095, 2236425645, 2428791476, 3701116665,
            855942450,  873219132,  2964060216, 2762200073, 1113732276, 2086434529, 2680006555,
            4270771253, 3606369251, 2041797866, 2474090008, 711137809,  4114462693, 2291072098,
            3946661167, 4032112869, 2061244498, 2856602910, 585330224,  2891778367, 1699047040,
            1974470006, 2811131748, 2015423743, 3919668339, 2377065433, 328913035,  2537834245,
            885703468,  372565239,  2035080996, 736367353,  3989519258, 2018774437, 1196473724,
            1840131439, 3732845654, 1828861153, 780227006,  3945501192, 3702352846, 193369736,
            882611183,  2256053391, 2514679284, 2884779162, 1571452133, 1615279208, 171875645,
            4059087001, 3851390472, 3438650153, 3986374834, 3101700268, 539187685,  1033472121,
            3177070529, 3454837734, 2787168792, 1813475456, 2420238351, 153890757,  2240608860,
            1741310724, 18393368,   216346508,  2938699098, 3342719194, 4115775118, 1667311975,
            3334278814, 4080013619, 3815853623, 1064074836, 3360193003, 3318257346, 36631608,
            3999364535, 2400856948, 1976755277, 172689334,  290870181,  2047225762, 1315170259,
            2311775846, 758055045,  2768917767, 2193076760, 2956169934, 1106672549, 595233139,
            4035380387, 2015840614, 2947682516, 39851556,   3377237384, 639551455,  347738005,
            2960433982, 1161437472, 3464276996, 620719443,  3032905920, 2564259711, 2715136994,
            697192156,  3659402962, 3314732286, 2469300389, 3021792062, 1054460487, 444209633,
            206495493,  1165046949, 2545884409, 3160377637, 331806945,  1006683732, 1962246484,
            1474775364, 1621369930, 776810425,  3130507356, 4127739095, 381374732,  582437730,
            584992706,  1845306784, 2469422923, 3976125854, 1825423705, 574162881,  2948747359,
            1246917536, 3658489516, 4271098660, 4055090993, 2496113310, 2728616354, 1114028061,
            1159716940, 250113388,  2359328429, 4094482486, 2191541402, 2769182585, 3425984193,
            347926320,  1860926138, 1361091734, 1319712635, 879211029,  3983871590, 2797101988,
            4092357018, 4294271587, 4109621879, 3131099095, 2236425645, 2428791476, 2062516252,
            855942450,  873219132,  2964060216, 2762200073, 1431492934, 2086434529, 2680006555,
            4270771253, 3606369251, 1271232284, 2474090008, 711137809,  4114462693, 2291072098,
            2141166254, 4032112869, 2061244498, 2856602910, 585330224,  3241607749, 1699047040,
            1974470006, 2811131748, 2015423743, 3801400308, 2377065433, 328913035,  2537834245,
            885703468,  1962729977, 2035080996, 736367353,  3989519258, 2018774437, 3501957181,
            1840131439, 3732845654, 1828861153, 780227006,  626627486,  3702352846, 193369736,
            882611183,  2256053391, 4115580965, 2884779162, 1571452133, 1615279208, 171875645,
            238229676,  3851390472, 3438650153, 3986374834, 3101700268, 2039174154, 1033472121,
            3177070529, 3454837734, 2787168792, 3353021807, 2420238351, 153890757,  2240608860,
            1741310724, 2563916806, 216346508,  2938699098, 3342719194, 4115775118, 8460356,
            3334278814, 4080013619, 3815853623, 1064074836, 119424582,  3318257346, 36631608,
            3999364535, 2400856948, 3589371395, 172689334,  290870181,  2047225762, 1315170259,
            2366658251, 758055045,  2768917767, 2193076760, 2956169934, 1024722752, 595233139,
            4035380387, 2015840614, 2947682516, 2371229149, 3377237384, 639551455,  347738005,
            2960433982, 3169404700, 3464276996, 620719443,  3032905920, 2564259711, 3282163147,
            697192156,  3659402962, 3314732286, 2469300389, 1707455151, 1054460487, 444209633,
            206495493,  1165046949, 3808928704, 3160377637, 331806945,  1006683732, 1962246484,
            1718684852, 1621369930, 776810425,  3130507356, 4127739095, 4210673705, 582437730,
            584992706,  1845306784, 2469422923, 3662614191, 1825423705, 574162881,  2948747359,
            1246917536, 1391176593, 4271098660, 4055090993, 2496113310, 2728616354, 399872261,
            1159716940, 250113388,  2359328429, 4094482486, 1500926127, 2769182585, 3425984193,
            347926320,  1860926138, 3708633122, 1319712635, 879211029,  3983871590, 2797101988,
            868695123,  4294271587, 4109621879, 3131099095, 2236425645, 141635289,  2062516252,
            855942450,  873219132,  2964060216, 1430063613, 1431492934, 2086434529, 2680006555,
            4270771253, 3518317476, 1271232284, 2474090008, 711137809,  4114462693, 478221469,
            2141166254, 4032112869, 2061244498, 2856602910, 2108442891, 3241607749, 1699047040,
            1974470006, 2811131748, 1538070086, 3801400308, 2377065433, 328913035,  2537834245,
            4182375313, 1962729977, 2035080996, 736367353,  3989519258, 2806829649, 3501957181,
            1840131439, 3732845654, 1828861153, 2345138495, 626627486,  3702352846, 193369736,
            882611183,  3802996163, 4115580965, 2884779162, 1571452133, 1615279208, 1667385122,
            238229676,  3851390472, 3438650153, 3986374834, 3154288119, 2039174154, 1033472121,
            3177070529, 3454837734, 3093349215, 3353021807, 2420238351, 153890757,  2240608860,
            4282419056, 2563916806, 216346508,  2938699098, 3342719194, 1274613140, 8460356,
            3334278814, 4080013619, 3815853623, 2833461438, 119424582,  3318257346, 36631608,
            3999364535, 1771825932, 3589371395, 172689334,  290870181,  2047225762, 170026647,
            2366658251, 758055045,  2768917767, 2193076760, 1011634445, 1024722752, 595233139,
            4035380387, 2015840614, 2217630241, 2371229149, 3377237384, 639551455,  347738005,
            713951044,  3169404700, 3464276996, 620719443,  3032905920, 74107787,   3282163147,
            697192156,  3659402962, 3314732286, 1671951424, 1707455151, 1054460487, 444209633,
            206495493,  2894757461, 3808928704, 3160377637, 331806945,  1006683732, 2209482398,
            1718684852, 1621369930, 776810425,  3130507356, 3583074228, 4210673705, 582437730,
            584992706,  1845306784, 3336207697, 3662614191, 1825423705, 574162881,  2948747359,
            3982327354, 1391176593, 4271098660, 4055090993, 2496113310, 1926385716, 399872261,
            1159716940, 250113388,  2359328429, 368423416,  1500926127, 2769182585, 3425984193,
            347926320,  1871752679, 3708633122, 1319712635, 879211029,  3983871590, 1763261432,
            868695123,  4294271587, 4109621879, 3131099095, 1447943631, 141635289,  2062516252,
            855942450,  873219132,  2715021986, 1430063613, 1431492934, 2086434529, 2680006555,
            3962482608, 3518317476, 1271232284, 2474090008, 711137809,  4010426320, 478221469,
            2141166254, 4032112869, 2061244498, 2886829016, 2108442891, 3241607749, 1699047040,
            1974470006, 1989015330, 1538070086, 3801400308, 2377065433, 328913035,  3974277185,
            4182375313, 1962729977, 2035080996, 736367353,  1017403121, 2806829649, 3501957181,
            1840131439, 3732845654, 2833888996, 2345138495, 626627486,  3702352846, 193369736,
            1319002870, 3802996163, 4115580965, 2884779162, 1571452133, 1209417524, 1667385122,
            238229676,  3851390472, 3438650153, 2084510094, 3154288119, 2039174154, 1033472121,
            3177070529, 137047123,  3093349215, 3353021807, 2420238351, 153890757,  2717158613,
            4282419056, 2563916806, 216346508,  2938699098, 419416463,  1274613140, 8460356,
            3334278814, 4080013619, 1374040750, 2833461438, 119424582,  3318257346, 36631608,
            582758820,  1771825932, 3589371395, 172689334,  290870181,  604691409,  170026647,
            2366658251, 758055045,  2768917767, 2868064534, 1011634445, 1024722752, 595233139,
            4035380387, 1050644295, 2217630241, 2371229149, 3377237384, 639551455,  2432980267,
            713951044,  3169404700, 3464276996, 620719443,  3139227984, 74107787,   3282163147,
            697192156,  3659402962, 1939247984, 1671951424, 1707455151, 1054460487, 444209633,
            232832899,  2894757461, 3808928704, 3160377637, 331806945,  3937190678, 2209482398,
            1718684852, 1621369930, 776810425,  3560940143, 3455486855, 2891346365, 3799103461,
            1371935203, 3116533711, 1590095052, 1084795939, 3209501013, 2710187525, 369153936,
            345284460,  2595795599, 1549745704, 207860987,  4013578414, 621255045,  874567436,
            641196898,  4166884416, 3428349532, 2606314003, 1821412666, 2439635396, 1389159564,
            568202834,  3290517056, 2468901935, 1023291537, 263641675,  4022941382, 3704063602,
            947144579,  2710523362, 1719518130, 3102707999, 116580236,  1460196386, 3498185294,
            1952770338, 1123349943, 2931814278, 1492595591, 261184393,  966794157,  2322593269,
            2315549261, 3783226309, 120543439,  1826758300, 1511492428, 3614768546, 1712220162,
            855725095,  2704372078, 3897594716, 1502291319, 4251272816, 2548194910, 3376302580,
            1301866643, 2742408700, 37007688,   1248671429, 4083565605, 3963953160, 3134081580,
            2912246806, 4172994635, 492759625,  1651067198, 2918940989, 714122891,  1650789804,
            3162354707, 499791347,  3644992012, 2880445035, 999911722,  2425963179, 2556480077,
            4209799922, 2865579129, 883183929,  3338528002, 3127493221, 3994217899, 567502244,
            2628316454, 2281049719, 4080443122, 539489767,  2555251482, 3015087312, 2528172277,
            1818339611, 4181051736, 3044079839, 2007849039, 769357225,  739433033,  2995530568,
            1797774693, 1504413857, 4043124135, 476909818,  2896416557, 3007877166, 4275137881,
            243372893,  2939056795, 74146570,   1383320512, 413123676,  2254371651, 2642365456,
            4096127704, 84323839,   3392652777, 1292972210, 1063943636, 652964189,  2858291650,
            2780007050, 3384840775, 2821789272, 1410486935, 1293477171, 921563290,  917756335,
            4204995391, 4277901428, 1307724250, 1527359965, 3941560911, 1273401196, 2562241579,
            448798229,  2372793069, 237304249,  1032574808, 2258044424, 2197671299, 1096554568,
            1758615188, 1456502233, 625403561,  1189155561, 589602886,  503147009,  986133516,
            925338511,  2611869146, 2024429082, 3304447807, 1113222764, 2834738554, 725920740,
            1295361872, 764511002,
        },
        {
            4209102573, 2387104994, 1221484586, 1726143957, 3263877318, 3362559187, 282442925,
            2418524976, 3196072648, 3174695999, 2072047145, 2985823503, 2132951745, 2298545297,
            2495977670, 1397656146, 2086257884, 3834366725, 3862532368, 3583329522, 1543996818,
            2192688115, 3081427696, 2656520743, 8772004,    2476324234, 3600148050, 1168683794,
            3219143568, 108768238,  1339513738, 447593731,  2742877256, 2488536667, 4189834432,
            808657962,  2422880287, 390864786,  3381554683, 760628048,  353395922,  3577556262,
            2482413928, 507756643,  839344953,  3505184848, 3945044582, 2414915836, 2313624497,
            1832728088, 2036999647, 1369090013, 3264575895, 1096327239, 3483440128, 3999302048,
            2761563885, 2882627112, 3126073009, 1749658776, 3152482044, 3040022505, 3249451214,
            2933713956, 2861715096, 1314806730, 932941454,  4276317539, 343449784,  1913556027,
            1493892363, 2539517630, 2046391233, 3046108187, 28742917,   4009448584, 530945117,
            3165875131, 1018448712, 110256395,  3550192264, 1279873435, 2276349621, 517650895,
            1957973772, 619869608,  4260458157, 2281748739, 2489253174, 2220997989, 3787481606,
            508630251,  3761850170, 3992979014, 2298047038, 3506428315, 1279341556, 3293496518,
            1313470495, 1021100687, 3113171268, 798494760,  2981622008, 4152623583, 576409629,
            2312811213, 992326282,  261645450,  1818084365, 3357150904, 144093,     1937589359,
            2016990596, 4273422066, 588267732,  3592151118, 3846596932, 1198111464, 944363907,
            1288613766, 1707163456, 4020906747, 1161127694, 2303844076, 2632591611, 3877442490,
            2453788473, 1725876694, 1193989740, 2650581453, 1937459187, 361099994,  3566745727,
            3658112707, 3612317412, 2684702277, 2880928862, 2044313931, 1866044828, 3528429465,
            130421713,  2658878825, 1566180833, 1572228417, 531947625,  3774861000, 1894712110,
            1319199233, 865634052,  2602102379, 3389730171, 3878969250, 107983959,  1601930856,
            2511728925, 2146946013, 497511195,  720616881,  699892123,  2404505137, 2656498433,
            4209102573, 2387104994, 1221484586, 1726143957, 1267363185, 3362559187, 282442925,
            2418524976, 3196072648, 2942944206, 2072047145, 2985823503, 2132951745, 2298545297,
            4079341490, 1397656146, 2086257884, 3834366725, 3862532368, 3991197972, 1543996818,
            2192688115, 3081427696, 2656520743, 825853576,  2476324234, 3600148050, 1168683794,
            3219143568, 528751585,  1339513738, 447593731,  2742877256, 2488536667, 4025362081,
            808657962,  2422880287, 390864786,  3381554683, 2682225618, 353395922,  3577556262,
            2482413928, 507756643,  3979211244, 3505184848, 3945044582, 2414915836, 2313624497,
            1841224078, 2036999647, 1369090013, 3264575895, 1096327239, 607843308,  3999302048,
            2761563885, 2882627112, 3126073009, 1241524975, 3152482044, 3040022505, 3249451214,
            2933713956, 420486142,  1314806730, 932941454,  4276317539, 343449784,  2231505736,
            1493892363, 2539517630, 2046391233, 3046108187, 2351652097, 4009448584, 530945117,
            3165875131, 1018448712, 1683392491, 3550192264, 1279873435, 2276349621, 517650895,
            4036312766, 619869608,  4260458157, 2281748739, 2489253174, 1686790154, 3787481606,
            508630251,  3761850170, 3992979014, 1745325013, 3506428315, 1279341556, 3293496518,
            1313470495, 3066312306, 3113171268, 798494760,  2981622008, 4152623583, 3871822467,
            2312811213, 992326282,  261645450,  1818084365, 3681154045, 144093,     1937589359,
            2016990596, 4273422066, 2361898985, 3592151118, 3846596932, 1198111464, 944363907,
            2866279694, 1707163456, 4020906747, 1161127694, 2303844076, 3044280908, 3877442490,
            2453788473, 1725876694, 1193989740, 2049617934, 1937459187, 361099994,  3566745727,
            3658112707, 934740227,  2684702277, 2880928862, 2044313931, 1866044828, 1814569183,
            130421713,  2658878825, 1566180833, 1572228417, 1784679035, 3774861000, 1894712110,
            1319199233, 865634052,  283642947,  3389730171, 3878969250, 107983959,  1601930856,
            3698217362, 2146946013, 497511195,  720616881,  699892123,  2117385156, 2656498433,
            4209102573, 2387104994, 1221484586, 3495886368, 1267363185, 3362559187, 282442925,
            2418524976, 3489510655, 2942944206, 2072047145, 2985823503, 2132951745, 885541635,
            4079341490, 1397656146, 2086257884, 3834366725, 1049969755, 3991197972, 1543996818,
            2192688115, 3081427696, 2141948440, 825853576,  2476324234, 3600148050, 1168683794,
            5160254,    528751585,  1339513738, 447593731,  2742877256, 3033397497, 4025362081,
            808657962,  2422880287, 390864786,  3191593886, 2682225618, 353395922,  3577556262,
            2482413928, 1185107868, 3979211244, 3505184848, 3945044582, 2414915836, 3030493909,
            1841224078, 2036999647, 1369090013, 3264575895, 3054343366, 607843308,  3999302048,
            2761563885, 2882627112, 3912854189, 1241524975, 3152482044, 3040022505, 3249451214,
            55140065,   420486142,  1314806730, 932941454,  4276317539, 1055315026, 2231505736,
            1493892363, 2539517630, 2046391233, 4174985470, 2351652097, 4009448584, 530945117,
            3165875131, 2168411768, 1683392491, 3550192264, 1279873435, 2276349621, 1875092822,
            4036312766, 619869608,  4260458157, 2281748739, 98823023,   1686790154, 3787481606,
            508630251,  3761850170, 2636025017, 1745325013, 3506428315, 1279341556, 3293496518,
            978338993,  3066312306, 3113171268, 798494760,  2981622008, 2712384846, 3871822467,
            2312811213, 992326282,  261645450,  66982935,   3681154045, 144093,     1937589359,
            2016990596, 3390191329, 2361898985, 3592151118, 3846596932, 1198111464, 1857959320,
            2866279694, 1707163456, 4020906747, 1161127694, 913091437,  3044280908, 3877442490,
            2453788473, 1725876694, 4254455215, 2049617934, 1937459187, 361099994,  3566745727,
            2914687409, 934740227,  2684702277, 2880928862, 2044313931, 1515195925, 1814569183,
            130421713,  2658878825, 1566180833, 2753417020, 1784679035, 3774861000, 1894712110,
            1319199233, 287161774,  283642947,  3389730171, 3878969250, 107983959,  3057929912,
            3698217362, 2146946013, 497511195,  720616881,  3570251850, 2117385156, 2656498433,
            4209102573, 2387104994, 2940868252, 3495886368, 1267363185, 3362559187, 282442925,
            2510419746, 3489510655, 2942944206, 2072047145, 2985823503, 978430777,  885541635,
            4079341490, 1397656146, 2086257884, 134380865,  1049969755, 3991197972, 1543996818,
            2192688115, 1205081471, 2141948440, 825853576,  2476324234, 3600148050, 228461601,
            5160254,    528751585,  1339513738, 447593731,  2852356745, 3033397497, 4025362081,
            808657962,  2422880287, 3287655095, 3191593886, 2682225618, 353395922,  3577556262,
            2542841784, 1185107868, 3979211244, 3505184848, 3945044582, 2905156498, 3030493909,
            1841224078, 2036999647, 1369090013, 4246605417, 3054343366, 607843308,  3999302048,
            2761563885, 3611911899, 3912854189, 1241524975, 3152482044, 3040022505, 3215633820,
            55140065,   420486142,  1314806730, 932941454,  2708752494, 1055315026, 2231505736,
            1493892363, 2539517630, 962728637,  4174985470, 2351652097, 4009448584, 530945117,
            3370859357, 2168411768, 1683392491, 3550192264, 1279873435, 3028448904, 1875092822,
            4036312766, 619869608,  4260458157, 199178828,  98823023,   1686790154, 3787481606,
            508630251,  4205010983, 2636025017, 1745325013, 3506428315, 1279341556, 683127445,
            978338993,  3066312306, 3113171268, 798494760,  2823693013, 2712384846, 3871822467,
            2312811213, 992326282,  3701928286, 66982935,   3681154045, 144093,     1937589359,
            1117717039, 3390191329, 2361898985, 3592151118, 3846596932, 1072660054, 1857959320,
            2866279694, 1707163456, 4020906747, 2503116219, 913091437,  3044280908, 3877442490,
            2453788473, 1815274499, 4254455215, 2049617934, 1937459187, 361099994,  3771108073,
            2914687409, 934740227,  2684702277, 2880928862, 3591322975, 1515195925, 1814569183,
            130421713,  2658878825, 354587729,  2753417020, 1784679035, 3774861000, 1894712110,
            1799044969, 287161774,  283642947,  3389730171, 3878969250, 1229815186, 3057929912,
            3698217362, 2146946013, 497511195,  3121882901, 426537369,  3852284416, 4050544256,
            3148944089, 878474231,  1369575859, 2206199765, 870626886,  494668165,  613011290,
            3246772867, 1040178461, 2396959353, 2105449571, 456758967,  4134137960, 3525051481,
            3633445497, 2895048060, 2008411846, 2194012253, 2326112129, 2956901044, 2297039362,
            3400824024, 42139718,   4212208866, 3874761488, 2361955811, 1890446075, 864533345,
            474524842,  2283847731, 283971243,  3607219686, 280870706,  4188549522, 659660119,
            2460943922, 4252134362, 922033031,  3615474721, 1691563300, 3002653770, 2414043617,
            2251931324, 752654714,  4188343161, 305594960,  1320443323, 797027061,  2347530104,
            3608843538, 2717312892, 1841295453, 1574467161, 823626340,  2244853583, 2648217758,
            141742826,  1605436472, 745763543,  3275460028, 3166960370, 2655678693, 3964037210,
            945054703,  998173049,  1014527437, 3424443612, 281835352,  826817508,  260462513,
            2849967970, 3447294061, 3670173947, 2430650055, 4134905457, 3798172627, 2156572681,
            2600148034, 2773013892, 3290397106, 1740507705, 3450254627, 3613087060, 440045928,
            1230555006, 980805434,  2107958250, 526555374,  3150741277, 4283672024, 193019043,
            786035243,  3002832578, 3938336183, 4209865002, 1005950967, 3533346582, 3196886974,
            83962845,   1882902787, 3595687446, 2927597311, 2728550762, 2750900392, 1474254316,
            1509832112, 1763262792, 2706181276, 538294991,  353565565,  18133995,   1719731406,
            3311085516, 2018821960, 300367686,  2628312935, 1151449661, 2178805970, 3288321196,
            535051857,  1623270973, 2761151808, 2701048972, 317681607,  2281427601, 719748170,
            351452298,  2191958596, 4000232015, 335837771,  4158081521, 3779404077, 1998444133,
            3849605095, 1532231791, 2930266419, 4203951289, 748423654,  1993082867, 451159852,
            488781053,  2438982775, 2222815270, 543209242,  1241562465, 2868868009, 4201052877,
            2438841764, 2151708682, 2426958921, 1520654642, 1990098337, 1070792755, 2308394635,
            1442389785, 705615044,
        },
        {
            3906116196, 2705963211, 420617434,  2618232926, 298138886,  2361838026, 41732011,
            32266184,   1860940954, 538194857,  1992752176, 388101945,  362102341,  3423997259,
            1900881449, 2863537773, 796199074,  2431599156, 3356558794, 2995903029, 2141639449,
            2727382075, 2693500147, 2493795590, 1877335526, 1393962329, 303548974,  3200604673,
            2015839663, 2581555774, 3518768508, 1908545180, 2885662361, 2421471669, 288822823,
            2018741324, 2830373402, 4190727311, 3725025783, 2249978308, 4174280329, 1814154110,
            1631414955, 194341274,  2924767772, 3652880218, 2144107701, 2426769943, 1464302462,
            35687584,   3588181451, 1649589195, 612880002,  100493240,  3092988261, 2028054292,
            2799720813, 3299399449, 1782816667, 3376504641, 171307690,  2498227953, 195939870,
            2774224874, 651936862,  3406157426, 182449347,  4019142596, 2970141321, 2660012480,
            3646363673, 4168533902, 4264923141, 784687628,  671592087,  1712615077, 3573351860,
            1588321748, 1656081619, 1104033868, 278457743,  3724483027, 3216131922, 2264003571,
            410720743,  1958540865, 3941186614, 2008593984, 3759148454, 2181194727, 4077141176,
            1515705567, 563695725,  26462071,   3473856821, 3934485711, 4192051625, 2524075424,
            4083581081, 4170077845, 3922220992, 817500334,  2816407629, 1949718168, 1628801078,
            2798254443, 4097182240, 249420958,  2557792542, 1806052304, 1905839733, 3373728008,
            3820903359, 573365340,  3707870291, 1643877356, 147799489,  2306148179, 1448388287,
            2087873698, 3765386635, 2444112286, 2612326077, 1180090547, 856730604,  3021007017,
            3579406549, 2327813499, 2808851727, 4294191170, 3257880043, 2378641021, 3917205604,
            1089380328, 964177978,  3418541711, 2302389080, 1750044106, 1755309212, 460114528,
            3677142508, 3161903638, 3823114904, 3276223050, 495657280,  2611778587, 605943110,
            2303161459, 1513939195, 2748643456, 435694499,  1027980644, 1564439718, 198391656,
            3724342869, 2789016793, 3633111539, 414273836,  2330783215, 3679188821, 4201914250,
            3906116196, 2705963211, 420617434,  2618232926, 3003343553, 2361838026, 41732011,
            32266184,   1860940954, 589369613,  1992752176, 388101945,  362102341,  3423997259,
            1197080209, 2863537773, 796199074,  2431599156, 3356558794, 1945908053, 2141639449,
            2727382075, 2693500147, 2493795590, 3880789427, 1393962329, 303548974,  3200604673,
            2015839663, 1699396760, 3518768508, 1908545180, 2885662361, 2421471669, 1970823764,
            2018741324, 2830373402, 4190727311, 3725025783, 3309171927, 4174280329, 1814154110,
            1631414955, 194341274,  3583338103, 3652880218, 2144107701, 2426769943, 1464302462,
            2176828835, 3588181451, 1649589195, 612880002,  100493240,  41161682,   2028054292,
            2799720813, 3299399449, 1782816667, 2548677647, 171307690,  2498227953, 195939870,
            2774224874, 290656825,  3406157426, 182449347,  4019142596, 2970141321, 1264247563,
            3646363673, 4168533902, 4264923141, 784687628,  3400615633, 1712615077, 3573351860,
            1588321748, 1656081619, 1084605413, 278457743,  3724483027, 3216131922, 2264003571,
            737335987,  1958540865, 3941186614, 2008593984, 3759148454, 1535172824, 4077141176,
            1515705567, 563695725,  26462071,   3697687440, 3934485711, 4192051625, 2524075424,
            4083581081, 4054348104, 3922220992, 817500334,  2816407629, 1949718168, 624669725,
            2798254443, 4097182240, 249420958,  2557792542, 1548527876, 1905839733, 3373728008,
            3820903359, 573365340,  924627894,  1643877356, 147799489,  2306148179, 1448388287,
            215121966,  3765386635, 2444112286, 2612326077, 1180090547, 3515073417, 3021007017,
            3579406549, 2327813499, 2808851727, 3907949991, 3257880043, 2378641021, 3917205604,
            1089380328, 1207586490, 3418541711, 2302389080, 1750044106, 1755309212, 2273893255,
            3677142508, 3161903638, 3823114904, 3276223050, 941309387,  2611778587, 605943110,
            2303161459, 1513939195, 764440867,  435694499,  1027980644, 1564439718, 198391656,
            1143756370, 2789016793, 3633111539, 414273836,  2330783215, 3273877168, 4201914250,
            3906116196, 2705963211, 420617434,  3929195608, 3003343553, 2361838026, 41732011,
            32266184,   2868078839, 589369613,  1992752176, 388101945,  362102341,  4053684104,
            1197080209, 2863537773, 796199074,  2431599156, 275302486,  1945908053, 2141639449,
            2727382075, 2693500147, 504841335,  3880789427, 1393962329, 303548974,  3200604673,
            2846248464, 1699396760, 3518768508, 1908545180, 2885662361, 3103064991, 1970823764,
            2018741324, 2830373402, 4190727311, 3961705369, 3309171927, 4174280329, 1814154110,
            1631414955, 2624869177, 3583338103, 3652880218, 2144107701, 2426769943, 3771618706,
            2176828835, 3588181451, 1649589195, 612880002,  1339550733, 41161682,   2028054292,
            2799720813, 3299399449, 3274538992, 2548677647, 171307690,  2498227953, 195939870,
            2104492233, 290656825,  3406157426, 182449347,  4019142596, 3635796025, 1264247563,
            3646363673, 4168533902, 4264923141, 2541815140, 3400615633, 1712615077, 3573351860,
            1588321748, 2552797491, 1084605413, 278457743,  3724483027, 3216131922, 1233193090,
            737335987,  1958540865, 3941186614, 2008593984, 3747476397, 1535172824, 4077141176,
            1515705567, 563695725,  3443568313, 3697687440, 3934485711, 4192051625, 2524075424,
            3086845948, 4054348104, 3922220992, 817500334,  2816407629, 3988560512, 624669725,
            2798254443, 4097182240, 249420958,  2333549374, 1548527876, 1905839733, 3373728008,
            3820903359, 4190071237, 924627894,  1643877356, 147799489,  2306148179, 679148637,
            215121966,  3765386635, 2444112286, 2612326077, 1691386416, 3515073417, 3021007017,
            3579406549, 2327813499, 294015919,  3907949991, 3257880043, 2378641021, 3917205604,
            2844137192, 1207586490, 3418541711, 2302389080, 1750044106, 3299999501, 2273893255,
            3677142508, 3161903638, 3823114904, 4254897269, 941309387,  2611778587, 605943110,
            2303161459, 1704091831, 764440867,  435694499,  1027980644, 1564439718, 173230081,
            1143756370, 2789016793, 3633111539, 414273836,  3056807091, 3273877168, 4201914250,
            3906116196, 2705963211, 445664107,  3929195608, 3003343553, 2361838026, 41732011,
            639557167,  2868078839, 589369613,  1992752176, 388101945,  4190856727, 4053684104,
            1197080209, 2863537773, 796199074,  3530271711, 275302486,  1945908053, 2141639449,
            2727382075, 1669650513, 504841335,  3880789427, 1393962329, 303548974,  2604333315,
            2846248464, 1699396760, 3518768508, 1908545180, 2461700419, 3103064991, 1970823764,
            2018741324, 2830373402, 2644088809, 3961705369, 3309171927, 4174280329, 1814154110,
            232960141,  2624869177, 3583338103, 3652880218, 2144107701, 3883379782, 3771618706,
            2176828835, 3588181451, 1649589195, 3383704037, 1339550733, 41161682,   2028054292,
            2799720813, 2509221614, 3274538992, 2548677647, 171307690,  2498227953, 4192338545,
            2104492233, 290656825,  3406157426, 182449347,  2860245579, 3635796025, 1264247563,
            3646363673, 4168533902, 2583874944, 2541815140, 3400615633, 1712615077, 3573351860,
            3121632371, 2552797491, 1084605413, 278457743,  3724483027, 3634247063, 1233193090,
            737335987,  1958540865, 3941186614, 2448141362, 3747476397, 1535172824, 4077141176,
            1515705567, 1102858348, 3443568313, 3697687440, 3934485711, 4192051625, 1873352705,
            3086845948, 4054348104, 3922220992, 817500334,  3107202338, 3988560512, 624669725,
            2798254443, 4097182240, 3096693540, 2333549374, 1548527876, 1905839733, 3373728008,
            3378545357, 4190071237, 924627894,  1643877356, 147799489,  3225877761, 679148637,
            215121966,  3765386635, 2444112286, 131709405,  1691386416, 3515073417, 3021007017,
            3579406549, 1963247353, 294015919,  3907949991, 3257880043, 2378641021, 3949117784,
            2844137192, 1207586490, 3418541711, 2302389080, 2689038621, 3299999501, 2273893255,
            3677142508, 3161903638, 2234554006, 4254897269, 941309387,  2611778587, 605943110,
            3168112946, 1704091831, 764440867,  435694499,  1027980644, 4191729531, 173230081,
            1143756370, 2789016793, 3633111539, 2323401612, 2389168936, 1180244673, 4268955403,
            722364024,  724955975,  2541080562, 3663071903, 4021692941, 1370672665, 692663532,
            2526648378, 3032333829, 3483507108, 2164018152, 2669771550, 2585705125, 3835994896,
            2938765963, 575038068,  2989011991, 186494809,  1113461312, 1034939159, 3901371642,
            2798680030, 2802909493, 2263040595, 851586526,  2069476993, 2580443897, 2295811784,
            1480505004, 966307452,  2110309312, 4243892140, 2401523261, 215441162,  667057810,
            3257418121, 1801367697, 1496020303, 202230274,  2860715252, 2312399021, 1648733882,
            1071974161, 1399933502, 445494790,  908074053,  2317600050, 2035267188, 82617416,
            2515290304, 1837635669, 3781845202, 990251688,  1584219084, 2646192983, 3463092291,
            2951500343, 3104074964, 1672688161, 3684242128, 1677485169, 1346509094, 4041219606,
            2624166479, 4111936793, 2461071321, 337370880,  2641184686, 280963371,  767237470,
            1127113241, 331568031,  717006185,  3248546633, 724732928,  723047543,  2204602381,
            429531397,  801348862,  2991621131, 655909423,  1497367873, 301565072,  2016257391,
            2896301234, 3978766562, 588085989,  1432860348, 1985927038, 3082970974, 4189560670,
            2742893430, 2090681156, 539175320,  1715353298, 1545915212, 552461691,  2926650568,
            3711359760, 2245004203, 1220257585, 2418521158, 542452093,  4286411630, 892981777,
            3920313893, 3884015723, 4234449519, 2585547000, 3178349752, 3179040219, 2656841822,
            2449392741, 2591761626, 3499721041, 2809629588, 3778402738, 3300554788, 2840502771,
            614726490,  3262891985, 155629593,  848609427,  4018083170, 2052789599, 3002532745,
            2742434080, 3983532457, 2065775940, 1905608470, 2087752747, 3334633206, 4063922554,
            2113803837, 370514217,  3052060762, 3855178903, 1166943626, 2168445575, 112656640,
            3717971180, 1007403351, 3107674049, 1151845300, 2092760703, 3876612708, 991764080,
            2278068034, 3797610485, 3486162646, 3593647477, 3751427796, 641894831,  739361198,
            1748867068, 3456144165,
        },
        {
            973368008,  1221885324, 2086331970, 2323744198, 280145759,  1795442656, 2984366093,
            3532172763, 323888669,  851950179,  4198638255, 899943985,  4087912561, 2935341503,
            1443752852, 3991058999, 3547259355, 35779889,   1076308344, 4075444807, 186174448,
            3542284780, 660388677,  2777400132, 1092226205, 2418702276, 1307933032, 1940510003,
            1932005362, 4016036211, 387339882,  2969593895, 3453134349, 1382709098, 1795814140,
            1588159469, 1216733801, 2227378121, 2063027627, 582454582,  3364657275, 3466973302,
            484564303,  1489261596, 2270291560, 2008178784, 2284268924, 2229317366, 644797709,
            1213921542, 99331403,   3027640949, 1137722852, 2991506109, 1432805987, 931795812,
            1075567424, 28963219,   1462245461, 3781444706, 521233400,  1891915904, 3774338085,
            1635359313, 2356111795, 4121073768, 1045110727, 2822507066, 1087914587, 3744509525,
            911370656,  181884066,  1944539735, 290356444,  3598887471, 4236934380, 3224468239,
            457546246,  4119337570, 37700432,   655783844,  1423101410, 1693002969, 3287768267,
            928748421,  4074128009, 3081088543, 2882833790, 3180154875, 1094657682, 2388253717,
            4173455215, 794709427,  3363292346, 67786868,   3786597763, 380587236,  2345941620,
            560232318,  2137123833, 619747082,  1050293267, 2537845069, 1407302835, 433399526,
            1083185007, 1893842085, 3711748584, 4225838280, 3863317129, 2043467942, 2799650657,
            3590486611, 1231938950, 215905995,  155811669,  806806587,  2732631168, 1621659281,
            632403616,  401165422,  2661074778, 4156963191, 3691812937, 3767271627, 2834948318,
            2877210497, 2420260153, 733172233,  1771708940, 3102718549, 2468707423, 1857088312,
            3176535032, 1908570295, 3966666208, 605079895,  2982506620, 3721694730, 1640691570,
            3764975545, 3257514114, 1826578604, 1358557411, 4049610348, 615820785,  3355718142,
            1734641780, 2958744617, 274522187,  3198436002, 4077346785, 2890101344, 4012464346,
            1288365365, 96583076,   2656389382, 1858181040, 2717010340, 2032153178, 349324012,
            973368008,  1221885324, 2086331970, 2323744198, 253685576,  1795442656, 2984366093,
            3532172763, 323888669,  248935329,  4198638255, 899943985,  4087912561, 2935341503,
            3213394756, 3991058999, 3547259355, 35779889,   1076308344, 1987715385, 186174448,
            3542284780, 660388677,  2777400132, 2071022105, 2418702276, 1307933032, 1940510003,
            1932005362, 144370664,  387339882,  2969593895, 3453134349, 1382709098, 2394736611,
            1588159469, 1216733801, 2227378121, 2063027627, 4064263898, 3364657275, 3466973302,
            484564303,  1489261596, 3405101812, 2008178784, 2284268924, 2229317366, 644797709,
            2560273821, 99331403,   3027640949, 1137722852, 2991506109, 1446442417, 931795812,
            1075567424, 28963219,   1462245461, 1201513613, 521233400,  1891915904, 3774338085,
            1635359313, 2815447944, 4121073768, 1045110727, 2822507066, 1087914587, 2485035329,
            911370656,  181884066,  1944539735, 290356444,  2078819341, 4236934380, 3224468239,
            457546246,  4119337570, 2666895496, 655783844,  1423101410, 1693002969, 3287768267,
            3595439673, 4074128009, 3081088543, 2882833790, 3180154875, 872453917,  2388253717,
            4173455215, 794709427,  3363292346, 4188764388, 3786597763, 380587236,  2345941620,
            560232318,  625538006,  619747082,  1050293267, 2537845069, 1407302835, 2128289331,
            1083185007, 1893842085, 3711748584, 4225838280, 2486133065, 2043467942, 2799650657,
            3590486611, 1231938950, 928582681,  155811669,  806806587,  2732631168, 1621659281,
            1163969880, 401165422,  2661074778, 4156963191, 3691812937, 2322579561, 2834948318,
            2877210497, 2420260153, 733172233,  170239236,  3102718549, 2468707423, 1857088312,
            3176535032, 3868693408, 3966666208, 605079895,  2982506620, 3721694730, 2066859537,
            3764975545, 3257514114, 1826578604, 1358557411, 2964604045, 615820785,  3355718142,
            1734641780, 2958744617, 4091225681, 3198436002, 4077346785, 2890101344, 4012464346,
            2612861218, 96583076,   2656389382, 1858181040, 2717010340, 3639170895, 349324012,
            973368008,  1221885324, 2086331970, 2258432445, 253685576,  1795442656, 2984366093,
            3532172763, 3831166882, 248935329,  4198638255, 899943985,  4087912561, 715173523,
            3213394756, 3991058999, 3547259355, 35779889,   2393072396, 1987715385, 186174448,
            3542284780, 660388677,  3731857267, 2071022105, 2418702276, 1307933032, 1940510003,
            4262274779, 144370664,  387339882,  2969593895, 3453134349, 1923698215, 2394736611,
            1588159469, 1216733801, 2227378121, 2907069566, 4064263898, 3364657275, 3466973302,
            484564303,  2234542580, 3405101812, 2008178784, 2284268924, 2229317366, 1349323372,
            2560273821, 99331403,   3027640949, 1137722852, 4200786664, 1446442417, 931795812,
            1075567424, 28963219,   1659632304, 1201513613, 521233400,  1891915904, 3774338085,
            763590809,  2815447944, 4121073768, 1045110727, 2822507066, 4131040734, 2485035329,
            911370656,  181884066,  1944539735, 4104473807, 2078819341, 4236934380, 3224468239,
            457546246,  1241850776, 2666895496, 655783844,  1423101410, 1693002969, 2025898966,
            3595439673, 4074128009, 3081088543, 2882833790, 218474476,  872453917,  2388253717,
            4173455215, 794709427,  250328312,  4188764388, 3786597763, 380587236,  2345941620,
            1937652040, 625538006,  619747082,  1050293267, 2537845069, 1140055765, 2128289331,
            1083185007, 1893842085, 3711748584, 2298055548, 2486133065, 2043467942, 2799650657,
            3590486611, 1235949580, 928582681,  155811669,  806806587,  2732631168, 4046198728,
            1163969880, 401165422,  2661074778, 4156963191, 2003518762, 2322579561, 2834948318,
            2877210497, 2420260153, 326741418,  170239236,  3102718549, 2468707423, 1857088312,
            3936056808, 3868693408, 3966666208, 605079895,  2982506620, 2354705582, 2066859537,
            3764975545, 3257514114, 1826578604, 3017501686, 2964604045, 615820785,  3355718142,
            1734641780, 1681548103, 4091225681, 3198436002, 4077346785, 2890101344, 416470693,
            2612861218, 96583076,   2656389382, 1858181040, 3104217288, 3639170895, 349324012,
            973368008,  1221885324, 601524567,  2258432445, 253685576,  1795442656, 2984366093,
            1875491903, 3831166882, 248935329,  4198638255, 899943985,  2182697927, 715173523,
            3213394756, 3991058999, 3547259355, 1472237612, 2393072396, 1987715385, 186174448,
            3542284780, 2160848139, 3731857267, 2071022105, 2418702276, 1307933032, 3815354311,
            4262274779, 144370664,  387339882,  2969593895, 4240850623, 1923698215, 2394736611,
            1588159469, 1216733801, 322523795,  2907069566, 4064263898, 3364657275, 3466973302,
            2920715858, 2234542580, 3405101812, 2008178784, 2284268924, 1936025139, 1349323372,
            2560273821, 99331403,   3027640949, 859541953,  4200786664, 1446442417, 931795812,
            1075567424, 1876635772, 1659632304, 1201513613, 521233400,  1891915904, 3949233865,
            763590809,  2815447944, 4121073768, 1045110727, 2522258582, 4131040734, 2485035329,
            911370656,  181884066,  2467886009, 4104473807, 2078819341, 4236934380, 3224468239,
            603014155,  1241850776, 2666895496, 655783844,  1423101410, 673119756,  2025898966,
            3595439673, 4074128009, 3081088543, 4100445818, 218474476,  872453917,  2388253717,
            4173455215, 2395519424, 250328312,  4188764388, 3786597763, 380587236,  4292608797,
            1937652040, 625538006,  619747082,  1050293267, 2989616803, 1140055765, 2128289331,
            1083185007, 1893842085, 3313934002, 2298055548, 2486133065, 2043467942, 2799650657,
            1804808801, 1235949580, 928582681,  155811669,  806806587,  2864892828, 4046198728,
            1163969880, 401165422,  2661074778, 2946769376, 2003518762, 2322579561, 2834948318,
            2877210497, 2647485275, 326741418,  170239236,  3102718549, 2468707423, 2520336801,
            3936056808, 3868693408, 3966666208, 605079895,  2949706551, 2354705582, 2066859537,
            3764975545, 3257514114, 495003693,  3017501686, 2964604045, 615820785,  3355718142,
            3799230297, 1681548103, 4091225681, 3198436002, 4077346785, 258363842,  416470693,
            2612861218, 96583076,   2656389382, 2198085634, 1607235362, 694172175,  4194347563,
            2665732891, 3419430286, 597070176,  2749480905, 3937535348, 3639873850, 2050067843,
            4045290683, 2964298196, 3631595287, 1409808193, 121765438,  2129412744, 2497437101,
            2664102876, 1773441464, 1708052456, 2923764322, 3350385352, 1592204280, 1118221370,
            3416016313, 116121364,  1179473397, 1497519022, 902569114,  3840281863, 2783662797,
            1712084322, 1982884601, 3625797892, 4222938993, 3231134134, 3046745397, 446484563,
            1133869192, 2622178726, 3881085862, 4012894217, 391734322,  2089696890, 1304197030,
            2663978386, 1685998658, 4238620912, 448351665,  2724524045, 1038754164, 413586547,
            3107681687, 1454664365, 3353731192, 128440996,  565817989,  127978294,  1043863326,
            1747369107, 2772246481, 172569313,  2740699699, 3417082503, 2103702630, 2139566116,
            1378864710, 2444170529, 3234220221, 3974870858, 1965162347, 956763257,  3932467825,
            1077337271, 4084837149, 3699147465, 1882164226, 236113740,  3116302858, 2730529598,
            3449804672, 4002370655, 2011573068, 1551746089, 3917496971, 2852603,    1682999535,
            2764817908, 2489487254, 261936311,  3122421452, 1199382345, 2617247590, 1909026938,
            3156073069, 1492533764, 97847107,   1260892586, 187242945,  1286471861, 1763024967,
            127723419,  210606273,  228546401,  3249879676, 482069954,  383075106,  3263105259,
            2242748676, 1105681409, 4033144425, 4017983282, 1670425353, 4040882785, 1780687273,
            1405678015, 3076115981, 2713472488, 286336494,  3664225263, 502759060,  777620620,
            635590826,  132236203,  1866406173, 1235046453, 2859554298, 121814656,  944976320,
            1946494170, 2548097575, 415384946,  3934685646, 1507032178, 1383654007, 2906269630,
            566005756,  3118733139, 2969075870, 1834096359, 3263358416, 1322979710, 904583023,
            3582075094, 2298898632, 2491891941, 660351763,  2548592542, 3009200751, 2116595110,
            2623212287, 4167133624, 196759529,  3038645579, 1769704552, 1713233322, 2127497999,
            3849458221, 3769872265,
        },
        {
            1738197964, 2248880283, 3452882945, 611809845,  2458165484, 3336427688, 1447649407,
            2526566411, 1294126862, 1135842974, 3298415027, 2892199506, 4277174128, 2631786145,
            2784619422, 3568558672, 335139867,  4096170528, 2078829583, 3783829159, 2804811816,
            64881380,   3198872092, 3733329057, 1022680471, 3727391096, 2423881234, 2824732830,
            3948473685, 2197398340, 4146973324, 3389278918, 4187770709, 2091293704, 4029904646,
            1870591442, 3406120312, 1662475117, 2562317284, 1274193503, 864890588,  4235551652,
            2852091042, 738997084,  894174629,  4146208654, 2069939548, 740639214,  3581321826,
            1340310694, 3649866082, 629795252,  3898343738, 3752394326, 3175806495, 2505413901,
            2142205253, 4228254352, 337421351,  1463604448, 3235164288, 3743724555, 3347996201,
            3528334105, 1234107361, 2648171461, 333828963,  3226415421, 212103061,  3545935669,
            1758594508, 1876268128, 1136811626, 3435332066, 1827254659, 829729465,  3447023457,
            3090490054, 162786719,  3638816179, 1925800010, 2677577478, 78783460,   2392704250,
            2551665882, 2873128287, 2824333343, 3713598515, 1165502743, 1523064200, 3527353749,
            3317299654, 2516273806, 3276857032, 1561684417, 3172601594, 4242338475, 486891816,
            1307702170, 2147252211, 3817813868, 3612077980, 1129094464, 2095071058, 3017260840,
            2047360334, 2880347317, 3914355943, 3994763736, 351533729,  1339034852, 545571915,
            1431609371, 307511666,  1277925242, 2245007068, 975688669,  26065728,   909588863,
            1858634144, 1811406134, 2239462111, 856163563,  4119458043, 2792152084, 1058390855,
            2004743985, 2887895,    1428471988, 2314007563, 2792524627, 4228287249, 1003252450,
            2867762157, 1968338909, 2150403515, 2996014377, 247880134,  2879832172, 3667645949,
            2187917808, 3045874085, 1711222137, 3384185588, 1798421380, 2478394675, 2582260444,
            731173559,  1095374993, 3103660020, 3653498067, 743476206,  190560973,  40032316,
            3081314240, 2186716729, 3072630072, 4032724449, 1955244620, 3539374320, 2355459577,
            1738197964, 2248880283, 3452882945, 611809845,  1555701525, 3336427688, 1447649407,
            2526566411, 1294126862, 2411268305, 3298415027, 2892199506, 4277174128, 2631786145,
            451201802,  3568558672, 335139867,  4096170528, 2078829583, 3409890690, 2804811816,
            64881380,   3198872092, 3733329057, 2417882163, 3727391096, 2423881234, 2824732830,
            3948473685, 4245692104, 4146973324, 3389278918, 4187770709, 2091293704, 4111348257,
            1870591442, 3406120312, 1662475117, 2562317284, 1599340870, 864890588,  4235551652,
            2852091042, 738997084,  2621702223, 4146208654, 2069939548, 740639214,  3581321826,
            2687466105, 3649866082, 629795252,  3898343738, 3752394326, 3441324763, 2505413901,
            2142205253, 4228254352, 337421351,  3152450997, 3235164288, 3743724555, 3347996201,
            3528334105, 3280648469, 2648171461, 333828963,  3226415421, 212103061,  804566988,
            1758594508, 1876268128, 1136811626, 3435332066, 887289285,  829729465,  3447023457,
            3090490054, 162786719,  1144850602, 1925800010, 2677577478, 78783460,   2392704250,
            893511121,  2873128287, 2824333343, 3713598515, 1165502743, 3023400441, 3527353749,
            3317299654, 2516273806, 3276857032, 1230534393, 3172601594, 4242338475, 486891816,
            1307702170, 3424011207, 3817813868, 3612077980, 1129094464, 2095071058, 197470278,
            2047360334, 2880347317, 3914355943, 3994763736, 558327477,  1339034852, 545571915,
            1431609371, 307511666,  302336209,  2245007068, 975688669,  26065728,   909588863,
            3420356241, 1811406134, 2239462111, 856163563,  4119458043, 1657794286, 1058390855,
            2004743985, 2887895,    1428471988, 647427200,  2792524627, 4228287249, 1003252450,
            2867762157, 1381587187, 2150403515, 2996014377, 247880134,  2879832172, 330825024,
            2187917808, 3045874085, 1711222137, 3384185588, 2241252931, 2478394675, 2582260444,
            731173559,  1095374993, 2810012997, 3653498067, 743476206,  190560973,  40032316,
            2224525754, 2186716729, 3072630072, 4032724449, 1955244620, 3663385264, 2355459577,
            1738197964, 2248880283, 3452882945, 3195485673, 1555701525, 3336427688, 1447649407,
            2526566411, 2938988633, 2411268305, 3298415027, 2892199506, 4277174128, 1353804164,
            451201802,  3568558672, 335139867,  4096170528, 2905772406, 3409890690, 2804811816,
            64881380,   3198872092, 2608667316, 2417882163, 3727391096, 2423881234, 2824732830,
            165498467,  4245692104, 4146973324, 3389278918, 4187770709, 1391728582, 4111348257,
            1870591442, 3406120312, 1662475117, 3355232520, 1599340870, 864890588,  4235551652,
            2852091042, 3735587194, 2621702223, 4146208654, 2069939548, 740639214,  1924957445,
            2687466105, 3649866082, 629795252,  3898343738, 534668401,  3441324763, 2505413901,
            2142205253, 4228254352, 3823494271, 3152450997, 3235164288, 3743724555, 3347996201,
            2683659231, 3280648469, 2648171461, 333828963,  3226415421, 1920776522, 804566988,
            1758594508, 1876268128, 1136811626, 345385964,  887289285,  829729465,  3447023457,
            3090490054, 1436311304, 1144850602, 1925800010, 2677577478, 78783460,   4195727344,
            893511121,  2873128287, 2824333343, 3713598515, 3396254423, 3023400441, 3527353749,
            3317299654, 2516273806, 1712875122, 1230534393, 3172601594, 4242338475, 486891816,
            119161511,  3424011207, 3817813868, 3612077980, 1129094464, 2814916859, 197470278,
            2047360334, 2880347317, 3914355943, 3249347014, 558327477,  1339034852, 545571915,
            1431609371, 498329617,  302336209,  2245007068, 975688669,  26065728,   1118442197,
            3420356241, 1811406134, 2239462111, 856163563,  1036663403, 1657794286, 1058390855,
            2004743985, 2887895,    474989179,  647427200,  2792524627, 4228287249, 1003252450,
            4183206151, 1381587187, 2150403515, 2996014377, 247880134,  2381165916, 330825024,
            2187917808, 3045874085, 1711222137, 2490086338, 2241252931, 2478394675, 2582260444,
            731173559,  1979828249, 2810012997, 3653498067, 743476206,  190560973,  1723772022,
            2224525754, 2186716729, 3072630072, 4032724449, 3527598290, 3663385264, 2355459577,
            1738197964, 2248880283, 2956018789, 3195485673, 1555701525, 3336427688, 1447649407,
            2770974311, 2938988633, 2411268305, 3298415027, 2892199506, 1607291188, 1353804164,
            451201802,  3568558672, 335139867,  1712302197, 2905772406, 3409890690, 2804811816,
            64881380,   3723150458, 2608667316, 2417882163, 3727391096, 2423881234, 2809104107,
            165498467,  4245692104, 4146973324, 3389278918, 177931971,  1391728582, 4111348257,
            1870591442, 3406120312, 2812489474, 3355232520, 1599340870, 864890588,  4235551652,
            2163805223, 3735587194, 2621702223, 4146208654, 2069939548, 1767993911, 1924957445,
            2687466105, 3649866082, 629795252,  3963301372, 534668401,  3441324763, 2505413901,
            2142205253, 1266633560, 3823494271, 3152450997, 3235164288, 3743724555, 1226271159,
            2683659231, 3280648469, 2648171461, 333828963,  2511209810, 1920776522, 804566988,
            1758594508, 1876268128, 2120750193, 345385964,  887289285,  829729465,  3447023457,
            726519704,  1436311304, 1144850602, 1925800010, 2677577478, 2364179909, 4195727344,
            893511121,  2873128287, 2824333343, 124726965,  3396254423, 3023400441, 3527353749,
            3317299654, 3490583531, 1712875122, 1230534393, 3172601594, 4242338475, 2155215045,
            119161511,  3424011207, 3817813868, 3612077980, 1181273496, 2814916859, 197470278,
            2047360334, 2880347317, 596646357,  3249347014, 558327477,  1339034852, 545571915,
            1817953225, 498329617,  302336209,  2245007068, 975688669,  2157638192, 1118442197,
            3420356241, 1811406134, 2239462111, 3433959357, 1036663403, 1657794286, 1058390855,
            2004743985, 3470062462, 474989179,  647427200,  2792524627, 4228287249, 1769628910,
            4183206151, 1381587187, 2150403515, 2996014377, 1618072058, 2381165916, 330825024,
            2187917808, 3045874085, 3495751860, 2490086338, 2241252931, 2478394675, 2582260444,
            2174267134, 1979828249, 2810012997, 3653498067, 743476206,  381599379,  1723772022,
            2224525754, 2186716729, 3072630072, 2956643858, 1842889371, 3498850272, 1800456023,
            602638069,  909246089,  2685833882, 4110110165, 4191446971, 463578008,  1618517750,
            915327633,  3118039771, 3127374117, 2056564576, 1242617919, 95446496,   24323663,
            2367339095, 2792961554, 262171739,  1729013707, 934905166,  790727278,  485480817,
            638986358,  3936019110, 1368733051, 614997131,  2694175362, 4091535872, 544874515,
            2349300527, 74092534,   2374126479, 275639531,  1416768043, 2525845266, 4291849749,
            2648147819, 245457893,  4253398003, 3550921378, 2497731383, 3657108515, 291901098,
            544394601,  3844136387, 1511440241, 3918540943, 1959412984, 2778731871, 1971186193,
            2126843637, 1129897398, 1317322755, 2416667391, 2622688038, 226041004,  719752123,
            1418198804, 3923753049, 403871955,  2123790792, 1960766640, 2985152484, 469408208,
            594699005,  1151635568, 3710081708, 3087737744, 2724297291, 2878840477, 3826342433,
            2852998302, 850691840,  327550376,  1546937681, 2999583258, 917102320,  4129754133,
            304661749,  3714217134, 3399230968, 1344306808, 3808444291, 2810026226, 2757512088,
            72362265,   1735114116, 2412010633, 2072665500, 1618113392, 651039603,  1964728348,
            1599772377, 1529105173, 3659305614, 3038213715, 3854721825, 3477211000, 2597777235,
            1405311484, 3899997130, 3245089206, 3365348020, 4180960410, 2504886096, 3363561922,
            2997641466, 4079038368, 3516306491, 4069068282, 2179618554, 1615865083, 3564162599,
            3877683177, 643011108,  3989773192, 2037290250, 3588296942, 3457152008, 2006983153,
            3398839568, 3292430102, 2009828278, 3417430833, 1458786004, 14662774,   2394926398,
            19374670,   3803348999, 1378106805, 2926214885, 1975330595, 1594601991, 3703621084,
            3650732413, 292657246,  2407237007, 2608076502, 4211459884, 1994945136, 1700761392,
            3879171776, 1892966202, 2693312398, 887299148,  2977288719, 583835452,  759288119,
            2899935177, 3671635920, 2108019349, 2758157894, 3937473333, 4228885926, 2595291600,
            505843818,  2624599635,
        },
        {
            51082211,   3347503176, 3221768777, 2986163981, 3937460013, 1716372908, 4132024211,
            3035957293, 1791036224, 4214815056, 1645540011, 2629793790, 3185505897, 1855718954,
            495459467,  1728339314, 2318396341, 3396602050, 3273624616, 2625973148, 1762905939,
            1706358553, 1088424264, 2764318930, 1026127380, 1128004134, 2724553694, 41981087,
            2304966004, 1342745986, 3425554050, 3537673465, 752263676,  280905885,  929399589,
            4090689526, 2141254732, 1469491656, 2593100469, 1096008340, 3316809312, 1698245188,
            1656427920, 3081873338, 1750515301, 3850483440, 4081834419, 1225164947, 1244139942,
            1972663124, 116832506,  3097397897, 961156503,  1899056660, 1659173175, 1890464921,
            1891872926, 191259956,  1735304734, 4246751855, 4285601625, 1495519933, 3398829761,
            997567482,  2277782972, 1286922996, 3120709698, 15569196,   191501283,  3916619528,
            1552075789, 4259725643, 2837166910, 2231584792, 1912204495, 2597304083, 4147585653,
            1021482843, 2003417305, 186794491,  3608172979, 1991038123, 97515853,   34341352,
            4163491231, 1046079304, 4105813389, 3589099183, 3970004064, 3899560802, 4148331147,
            2267137817, 85024486,   3019925981, 3069231953, 1563669137, 314080592,  2943111861,
            2838243982, 726216848,  2621853102, 2355885175, 3359668856, 1111296541, 2330283124,
            3626558972, 4290084148, 1632078,    1047440803, 1350377197, 2490578842, 2366345698,
            1628128899, 860259543,  1937956234, 2833820527, 329818923,  648489148,  1791961202,
            1652322723, 1513419073, 149629345,  2468961221, 3711837973, 2377333831, 1434755773,
            3808719305, 2513270108, 2701064683, 3097011724, 303393137,  1346302239, 1852307302,
            850106025,  2473124483, 2853497268, 3786573704, 2604101162, 1446573486, 506925220,
            3138967488, 2973528682, 2752811123, 2890321579, 1037196362, 1335670403, 1560253777,
            1437495434, 2700525242, 4259933972, 3870707795, 4141538580, 3375331039, 3081538601,
            3129978494, 3689191993, 1933431212, 2196145886, 87814045,   878611347,  812542698,
            51082211,   3347503176, 3221768777, 2986163981, 277257023,  1716372908, 4132024211,
            3035957293, 1791036224, 2713916211, 1645540011, 2629793790, 3185505897, 1855718954,
            3800150234, 1728339314, 2318396341, 3396602050, 3273624616, 2530282967, 1762905939,
            1706358553, 1088424264, 2764318930, 4224669506, 1128004134, 2724553694, 41981087,
            2304966004, 484289311,  3425554050, 3537673465, 752263676,  280905885,  657028134,
            4090689526, 2141254732, 1469491656, 2593100469, 2089385540, 3316809312, 1698245188,
            1656427920, 3081873338, 2750354264, 3850483440, 4081834419, 1225164947, 1244139942,
            3432605739, 116832506,  3097397897, 961156503,  1899056660, 2234120716, 1890464921,
            1891872926, 191259956,  1735304734, 125359575,  4285601625, 1495519933, 3398829761,
            997567482,  4034254942, 1286922996, 3120709698, 15569196,   191501283,  2090684174,
            1552075789, 4259725643, 2837166910, 2231584792, 3412758413, 2597304083, 4147585653,
            1021482843, 2003417305, 2464533361, 3608172979, 1991038123, 97515853,   34341352,
            2634732952, 1046079304, 4105813389, 3589099183, 3970004064, 4263828421, 4148331147,
            2267137817, 85024486,   3019925981, 3229477751, 1563669137, 314080592,  2943111861,
            2838243982, 1274664774, 2621853102, 2355885175, 3359668856, 1111296541, 1615234696,
            3626558972, 4290084148, 1632078,    1047440803, 623898652,  2490578842, 2366345698,
            1628128899, 860259543,  2097114662, 2833820527, 329818923,  648489148,  1791961202,
            1730000077, 1513419073, 149629345,  2468961221, 3711837973, 3255238414, 1434755773,
            3808719305, 2513270108, 2701064683, 1635042488, 303393137,  1346302239, 1852307302,
            850106025,  3523245944, 2853497268, 3786573704, 2604101162, 1446573486, 1011238489,
            3138967488, 2973528682, 2752811123, 2890321579, 1044586909, 1335670403, 1560253777,
            1437495434, 2700525242, 608940900,  3870707795, 4141538580, 3375331039, 3081538601,
            728626935,  3689191993, 1933431212, 2196145886, 87814045,   646732047,  812542698,
            51082211,   3347503176, 3221768777, 1783601443, 277257023,  1716372908, 4132024211,
            3035957293, 3363442238, 2713916211, 1645540011, 2629793790, 3185505897, 2066587565,
            3800150234, 1728339314, 2318396341, 3396602050, 2279941522, 2530282967, 1762905939,
            1706358553, 1088424264, 2989326347, 4224669506, 1128004134, 2724553694, 41981087,
            2348931916, 484289311,  3425554050, 3537673465, 752263676,  3169550883, 657028134,
            4090689526, 2141254732, 1469491656, 1152943917, 2089385540, 3316809312, 1698245188,
            1656427920, 1808689833, 2750354264, 3850483440, 4081834419, 1225164947, 2422106046,
            3432605739, 116832506,  3097397897, 961156503,  1581804167, 2234120716, 1890464921,
            1891872926, 191259956,  4113708001, 125359575,  4285601625, 1495519933, 3398829761,
            3473435310, 4034254942, 1286922996, 3120709698, 15569196,   3122200488, 2090684174,
            1552075789, 4259725643, 2837166910, 2838170407, 3412758413, 2597304083, 4147585653,
            1021482843, 954000150,  2464533361, 3608172979, 1991038123, 97515853,   3832321348,
            2634732952, 1046079304, 4105813389, 3589099183, 1288675572, 4263828421, 4148331147,
            2267137817, 85024486,   1080403742, 3229477751, 1563669137, 314080592,  2943111861,
            3357655593, 1274664774, 2621853102, 2355885175, 3359668856, 3722440291, 1615234696,
            3626558972, 4290084148, 1632078,    4263556325, 623898652,  2490578842, 2366345698,
            1628128899, 3623136669, 2097114662, 2833820527, 329818923,  648489148,  592747007,
            1730000077, 1513419073, 149629345,  2468961221, 3766709284, 3255238414, 1434755773,
            3808719305, 2513270108, 1958651003, 1635042488, 303393137,  1346302239, 1852307302,
            579487408,  3523245944, 2853497268, 3786573704, 2604101162, 4183724981, 1011238489,
            3138967488, 2973528682, 2752811123, 3074709397, 1044586909, 1335670403, 1560253777,
            1437495434, 1237099522, 608940900,  3870707795, 4141538580, 3375331039, 2032507604,
            728626935,  3689191993, 1933431212, 2196145886, 4008131891, 646732047,  812542698,
            51082211,   3347503176, 3622107037, 1783601443, 277257023,  1716372908, 4132024211,
            1264285659, 3363442238, 2713916211, 1645540011, 2629793790, 2179309595, 2066587565,
            3800150234, 1728339314, 2318396341, 580990822,  2279941522, 2530282967, 1762905939,
            1706358553, 2826056883, 2989326347, 4224669506, 1128004134, 2724553694, 1486392636,
            2348931916, 484289311,  3425554050, 3537673465, 2497657189, 3169550883, 657028134,
            4090689526, 2141254732, 1019244016, 1152943917, 2089385540, 3316809312, 1698245188,
            2921739456, 1808689833, 2750354264, 3850483440, 4081834419, 108425527,  2422106046,
            3432605739, 116832506,  3097397897, 3902994002, 1581804167, 2234120716, 1890464921,
            1891872926, 3428861050, 4113708001, 125359575,  4285601625, 1495519933, 3350053832,
            3473435310, 4034254942, 1286922996, 3120709698, 2906201347, 3122200488, 2090684174,
            1552075789, 4259725643, 1965598685, 2838170407, 3412758413, 2597304083, 4147585653,
            3335631208, 954000150,  2464533361, 3608172979, 1991038123, 3788034599, 3832321348,
            2634732952, 1046079304, 4105813389, 2362460804, 1288675572, 4263828421, 4148331147,
            2267137817, 2767331798, 1080403742, 3229477751, 1563669137, 314080592,  1737897403,
            3357655593, 1274664774, 2621853102, 2355885175, 57997639,   3722440291, 1615234696,
            3626558972, 4290084148, 3703113369, 4263556325, 623898652,  2490578842, 2366345698,
            73788443,   3623136669, 2097114662, 2833820527, 329818923,  253042650,  592747007,
            1730000077, 1513419073, 149629345,  4248302934, 3766709284, 3255238414, 1434755773,
            3808719305, 3698431827, 1958651003, 1635042488, 303393137,  1346302239, 3872433842,
            579487408,  3523245944, 2853497268, 3786573704, 3459185849, 4183724981, 1011238489,
            3138967488, 2973528682, 2605373899, 3074709397, 1044586909, 1335670403, 1560253777,
            4069724875, 1237099522, 608940900,  3870707795, 4141538580, 2550307954, 2032507604,
            728626935,  3689191993, 1933431212, 1177640824, 4168589688, 1361487780, 2649612520,
            2181448948, 2176288560, 947907377,  3772487849, 2002599877, 3353450532, 2013145251,
            2357912348, 2316997609, 2355480213, 255142205,  751273749,  4049362748, 1434168014,
            2069693747, 6910933,    1352778547, 2413649875, 4238683558, 484497407,  522555106,
            1848417180, 3001805499, 2264939603, 3606143565, 1782482647, 2955918436, 3471474379,
            2814133839, 3779337475, 3522102195, 1551792178, 3742001759, 3433504551, 472918932,
            3835854229, 4259163014, 4103952359, 1989474190, 1792448078, 1517735224, 1958036884,
            2277922531, 2856192348, 4294188732, 2674247971, 643649427,  3847742408, 1512435795,
            4236693554, 1749045838, 397093640,  2940663643, 4156440725, 188785143,  3894740830,
            897618321,  3333498692, 1623924612, 4111607062, 2242558573, 1565861815, 1177957654,
            4129621176, 2232443247, 3216995984, 3313294700, 791442469,  1782204490, 2452634246,
            1288014576, 1347365377, 112254281,  2044140398, 2479591984, 3293701920, 1062335151,
            1397230369, 2460086085, 2412349474, 1252633202, 3704541545, 2132499200, 2202058121,
            1981543691, 2683673516, 1198109770, 4279157703, 2224504258, 2188868731, 769314834,
            601313429,  3595357440, 561383123,  3444949507, 2127327734, 2865252582, 4181002098,
            2408426518, 309361635,  2377703815, 1109219406, 406287309,  1750179098, 3619129839,
            937928728,  884423945,  928407281,  4173634172, 1492070114, 2706943441, 1365883971,
            3076484301, 744370087,  4004118884, 2199449568, 879458863,  3197725005, 3590586547,
            59693002,   3614114662, 1499386564, 2914582708, 3751842429, 947438603,  1986129491,
            3747112289, 833777768,  2231649410, 1841607849, 3526253103, 3797105813, 1291185911,
            3188408549, 3311027691, 3983681758, 2246511800, 1271525377, 2996265908, 2396071405,
            902427181,  164636454,  2459631341, 635349368,  463309029,  1409367654, 849052250,
            3221786769, 2310288531, 2919204855, 1263130532, 1215722704, 3497322658, 2840687222,
            2185004161, 1507335864,
        },
        {
            2231436206, 3015763713, 1047777742, 3759678213, 528843123,  724532559,  494878538,
            25867668,   3203558061, 823360917,  3998574251, 681678873,  2956359603, 937868730,
            1115919999, 569508190,  4019953160, 2605075418, 3562955670, 3702703500, 283389202,
            4227010510, 1043171259, 2325115988, 3887315730, 2379978085, 2973897811, 1028743970,
            72057440,   1539415177, 110883024,  3617309702, 120311608,  717630364,  938491879,
            1766910752, 2772822662, 3781100888, 1172267068, 1171516531, 1696542827, 721046938,
            3798841253, 16827987,   348390488,  3741394289, 391141166,  4259633236, 1197203723,
            4122480941, 1386669316, 3893717681, 3722065965, 158018522,  2226145499, 145941847,
            3111791190, 1058162433, 2372231986, 1329335286, 412539014,  938884073,  3564600602,
            3293517005, 494686201,  1278908758, 485047390,  2965529165, 3618898392, 3811229081,
            358751666,  267397396,  2672637054, 3713445406, 1629453366, 2810918811, 938599066,
            2466179100, 852699466,  1910613698, 1107044334, 3679133421, 886015125,  1239292491,
            4205383162, 2925597341, 3394288240, 887942553,  1333021624, 2592809376, 1894891980,
            1748153082, 2368175493, 3862859563, 3355248635, 775503086,  3324298871, 1198284042,
            1797194914, 865072694,  684499759,  2673116388, 1840071847, 3024149666, 90288837,
            577088382,  2292213449, 2744493957, 11048171,   509485930,  3757251642, 2163830548,
            630952872,  2428412492, 2077451552, 2483382112, 312954786,  3131613839, 3073618165,
            2386803599, 66571807,   3930081418, 4161855372, 2246534869, 1702511887, 2742820796,
            2937218734, 1917663370, 2564871011, 1636064454, 106879313,  184619169,  3984426189,
            332387718,  3296283735, 1510161632, 1977395174, 3713728553, 961129740,  1565779203,
            1146541236, 1619283512, 2448498299, 127525814,  3116874913, 4074544507, 645821722,
            2626653733, 3587156031, 3060828935, 179492099,  961155402,  741275497,  1129297821,
            3004776557, 2509126361, 2355622592, 3753661922, 486396618,  3150801633, 1153723176,
            2231436206, 3015763713, 1047777742, 3759678213, 3861980085, 724532559,  494878538,
            25867668,   3203558061, 121094102,  3998574251, 681678873,  2956359603, 937868730,
            4200724242, 569508190,  4019953160, 2605075418, 3562955670, 1448389975, 283389202,
            4227010510, 1043171259, 2325115988, 3341282438, 2379978085, 2973897811, 1028743970,
            72057440,   1942178081, 110883024,  3617309702, 120311608,  717630364,  4142741329,
            1766910752, 2772822662, 3781100888, 1172267068, 3479207307, 1696542827, 721046938,
            3798841253, 16827987,   2613433661, 3741394289, 391141166,  4259633236, 1197203723,
            3340725785, 1386669316, 3893717681, 3722065965, 158018522,  3275164592, 145941847,
            3111791190, 1058162433, 2372231986, 1869082906, 412539014,  938884073,  3564600602,
            3293517005, 4221752780, 1278908758, 485047390,  2965529165, 3618898392, 739825823,
            358751666,  267397396,  2672637054, 3713445406, 3802833226, 2810918811, 938599066,
            2466179100, 852699466,  490546995,  1107044334, 3679133421, 886015125,  1239292491,
            3568866805, 2925597341, 3394288240, 887942553,  1333021624, 4269337983, 1894891980,
            1748153082, 2368175493, 3862859563, 2256565541, 775503086,  3324298871, 1198284042,
            1797194914, 1138970574, 684499759,  2673116388, 1840071847, 3024149666, 266198822,
            577088382,  2292213449, 2744493957, 11048171,   1286111535, 3757251642, 2163830548,
            630952872,  2428412492, 4164158253, 2483382112, 312954786,  3131613839, 3073618165,
            3145268050, 66571807,   3930081418, 4161855372, 2246534869, 3907041596, 2742820796,
            2937218734, 1917663370, 2564871011, 2265409241, 106879313,  184619169,  3984426189,
            332387718,  1080429307, 1510161632, 1977395174, 3713728553, 961129740,  1466322907,
            1146541236, 1619283512, 2448498299, 127525814,  291890741,  4074544507, 645821722,
            2626653733, 3587156031, 2597367423, 179492099,  961155402,  741275497,  1129297821,
            746975329,  2509126361, 2355622592, 3753661922, 486396618,  331539124,  1153723176,
            2231436206, 3015763713, 1047777742, 2109813177, 3861980085, 724532559,  494878538,
            25867668,   1696887788, 121094102,  3998574251, 681678873,  2956359603, 2346493392,
            4200724242, 569508190,  4019953160, 2605075418, 1031719569, 1448389975, 283389202,
            4227010510, 1043171259, 2236635367, 3341282438, 2379978085, 2973897811, 1028743970,
            4144762544, 1942178081, 110883024,  3617309702, 120311608,  3205840975, 4142741329,
            1766910752, 2772822662, 3781100888, 1457206397, 3479207307, 1696542827, 721046938,
            3798841253, 702051950,  2613433661, 3741394289, 391141166,  4259633236, 3396032846,
            3340725785, 1386669316, 3893717681, 3722065965, 4271127764, 3275164592, 145941847,
            3111791190, 1058162433, 1034870747, 1869082906, 412539014,  938884073,  3564600602,
            765875971,  4221752780, 1278908758, 485047390,  2965529165, 3171301888, 739825823,
            358751666,  267397396,  2672637054, 1647465789, 3802833226, 2810918811, 938599066,
            2466179100, 366191714,  490546995,  1107044334, 3679133421, 886015125,  3663401254,
            3568866805, 2925597341, 3394288240, 887942553,  1974985181, 4269337983, 1894891980,
            1748153082, 2368175493, 4106040735, 2256565541, 775503086,  3324298871, 1198284042,
            3448389187, 1138970574, 684499759,  2673116388, 1840071847, 1836952968, 266198822,
            577088382,  2292213449, 2744493957, 2235215280, 1286111535, 3757251642, 2163830548,
            630952872,  2106952530, 4164158253, 2483382112, 312954786,  3131613839, 1158846777,
            3145268050, 66571807,   3930081418, 4161855372, 1371216121, 3907041596, 2742820796,
            2937218734, 1917663370, 522088286,  2265409241, 106879313,  184619169,  3984426189,
            3643492540, 1080429307, 1510161632, 1977395174, 3713728553, 2887829468, 1466322907,
            1146541236, 1619283512, 2448498299, 1725933997, 291890741,  4074544507, 645821722,
            2626653733, 2047138586, 2597367423, 179492099,  961155402,  741275497,  3751474591,
            746975329,  2509126361, 2355622592, 3753661922, 1938384017, 331539124,  1153723176,
            2231436206, 3015763713, 2661819016, 2109813177, 3861980085, 724532559,  494878538,
            3254459719, 1696887788, 121094102,  3998574251, 681678873,  1674998002, 2346493392,
            4200724242, 569508190,  4019953160, 3978129513, 1031719569, 1448389975, 283389202,
            4227010510, 2685720627, 2236635367, 3341282438, 2379978085, 2973897811, 3046963447,
            4144762544, 1942178081, 110883024,  3617309702, 3224383778, 3205840975, 4142741329,
            1766910752, 2772822662, 685298798,  1457206397, 3479207307, 1696542827, 721046938,
            2719341677, 702051950,  2613433661, 3741394289, 391141166,  3164637701, 3396032846,
            3340725785, 1386669316, 3893717681, 206764430,  4271127764, 3275164592, 145941847,
            3111791190, 2742951979, 1034870747, 1869082906, 412539014,  938884073,  726010814,
            765875971,  4221752780, 1278908758, 485047390,  3792778872, 3171301888, 739825823,
            358751666,  267397396,  2460398205, 1647465789, 3802833226, 2810918811, 938599066,
            953828170,  366191714,  490546995,  1107044334, 3679133421, 951966163,  3663401254,
            3568866805, 2925597341, 3394288240, 3839695300, 1974985181, 4269337983, 1894891980,
            1748153082, 2169905974, 4106040735, 2256565541, 775503086,  3324298871, 3470342142,
            3448389187, 1138970574, 684499759,  2673116388, 3018556869, 1836952968, 266198822,
            577088382,  2292213449, 2017670895, 2235215280, 1286111535, 3757251642, 2163830548,
            2870110409, 2106952530, 4164158253, 2483382112, 312954786,  3177812264, 1158846777,
            3145268050, 66571807,   3930081418, 485234224,  1371216121, 3907041596, 2742820796,
            2937218734, 4055287023, 522088286,  2265409241, 106879313,  184619169,  2399520465,
            3643492540, 1080429307, 1510161632, 1977395174, 1186939137, 2887829468, 1466322907,
            1146541236, 1619283512, 2428687044, 1725933997, 291890741,  4074544507, 645821722,
            1727807998, 2047138586, 2597367423, 179492099,  961155402,  2783261720, 3751474591,
            746975329,  2509126361, 2355622592, 724738830,  3031655040, 951246557,  2809967876,
            456151133,  2566013967, 2327884622, 3635084760, 3103339639, 271451089,  2240641861,
            2336884442, 1717081973, 2313832930, 1378304304, 518784093,  84910247,   2980448714,
            3572260590, 1304666672, 3959989535, 2680381161, 3674865905, 961406711,  1657273990,
            2358957513, 799768367,  2254629402, 2214087401, 3704388942, 3476840664, 2285298243,
            3901055297, 899182201,  3890734501, 2016793608, 1064635581, 2670436406, 3101556096,
            408466134,  2664860575, 2042074249, 3021163345, 1265513827, 2928898886, 52785877,
            748277202,  3267185781, 3538920130, 2369872254, 4069948012, 2545913266, 2933802521,
            3571743500, 2901415780, 2272323991, 525069508,  3508234983, 3386221686, 2324112632,
            3485059960, 2608851877, 807207865,  2162325070, 141034098,  2376688490, 3355244489,
            2341944202, 2159011533, 3346149998, 3649666523, 4077556453, 3173339916, 716343660,
            1967141352, 2489973981, 818199287,  3690579233, 1272997337, 4210889152, 4156031222,
            2529966023, 3751314669, 2417798330, 3046037027, 1628675869, 1640864576, 4036626571,
            199708149,  2559530606, 3365067078, 4079614953, 3146711807, 1250993462, 1808683107,
            906753111,  2299472619, 1924334002, 378946434,  1270119076, 1504605307, 1552357192,
            1387859812, 1684954487, 3713826176, 946068878,  1259111149, 801493131,  1024002310,
            3378271742, 3748019051, 1024530635, 258427574,  1370436761, 3675063795, 1045626250,
            251731654,  3802478357, 1931150792, 838367217,  3421525197, 3283363439, 1966349789,
            2449376216, 2598201163, 3229932198, 162856942,  487655083,  3593533318, 1206404638,
            2587104591, 3075276749, 308346624,  1431383376, 166326007,  2587986821, 2419171969,
            1770664432, 3605402969, 1600845706, 3039683466, 4086473355, 1605526871, 148122252,
            1283653176, 3587978104, 1159651772, 599869457,  849653284,  3229102943, 3704499821,
            3123867539, 3224810633, 1525029622, 1347735541, 2239098837, 546364365,  4278857298,
            3549421107, 1174529258,
        },
        {
            2052557448, 2879065999, 22933757,   2160014758, 3736092460, 3556641619, 1350613766,
            2107757927, 309323868,  3452852627, 3424626316, 545651740,  1935764720, 2349926457,
            3546577033, 862046434,  167198649,  338290297,  1145807303, 1571276102, 883549156,
            907871968,  638566313,  678764227,  3795356864, 3306095271, 1452688488, 621126888,
            1838613968, 2054107827, 1785040579, 454879400,  1952849106, 1907701866, 1639495252,
            1623968604, 2997422000, 2633878652, 1036670775, 2191465943, 3053533585, 1654709920,
            1950620393, 4177745509, 1742007818, 2888573892, 2825965566, 1399790365, 1307674482,
            310692416,  384880529,  3497622676, 1024664651, 1541456182, 1904670217, 1008618602,
            2816673160, 684112698,  3332034744, 3646613828, 962627614,  3072103948, 3713153075,
            476323310,  3243124597, 126319837,  2155412848, 228580793,  2142696490, 3442722759,
            2689599232, 426191419,  3157759186, 100239709,  494534049,  1259677734, 2889209278,
            1754641396, 1057778427, 2133253617, 1298500018, 3340348062, 3967049659, 2927469144,
            1503854147, 2271956463, 3004309866, 260248338,  2570702480, 2067671015, 3168497089,
            361311552,  2123195373, 2825457193, 2599488181, 507483626,  1201669979, 910763802,
            4158584821, 3116016424, 3375736126, 2857697336, 3112473104, 2683465481, 1495348009,
            681020485,  4044713962, 2443109893, 129994063,  1710251126, 820410567,  601527649,
            1007603132, 2096580480, 1942768885, 1984297765, 1888157243, 960265104,  527990410,
            1572910026, 1106822080, 1472807331, 2465011897, 3139401215, 3705452371, 393081842,
            3826516196, 2576499701, 4130037087, 4155028170, 2188282304, 2949056849, 1138928618,
            858751984,  3735375571, 496972334,  830265621,  1355757111, 909444416,  1337622259,
            2616327935, 2337227347, 2139876075, 4269663356, 796316592,  1893005585, 3958551664,
            1746456069, 2430709714, 4025417573, 3333292799, 1833607331, 3864559081, 3415700826,
            3291421244, 1987321873, 1792851165, 505718946,  3755903648, 3351468604, 4035552813,
            2052557448, 2879065999, 22933757,   2160014758, 2321387515, 3556641619, 1350613766,
            2107757927, 309323868,  1850700415, 3424626316, 545651740,  1935764720, 2349926457,
            979047283,  862046434,  167198649,  338290297,  1145807303, 4201635137, 883549156,
            907871968,  638566313,  678764227,  2637527083, 3306095271, 1452688488, 621126888,
            1838613968, 117966344,  1785040579, 454879400,  1952849106, 1907701866, 733998186,
            1623968604, 2997422000, 2633878652, 1036670775, 3360491537, 3053533585, 1654709920,
            1950620393, 4177745509, 1716078578, 2888573892, 2825965566, 1399790365, 1307674482,
            2776111761, 384880529,  3497622676, 1024664651, 1541456182, 618916624,  1008618602,
            2816673160, 684112698,  3332034744, 3340690804, 962627614,  3072103948, 3713153075,
            476323310,  902990902,  126319837,  2155412848, 228580793,  2142696490, 4254301999,
            2689599232, 426191419,  3157759186, 100239709,  3216403640, 1259677734, 2889209278,
            1754641396, 1057778427, 3221479262, 1298500018, 3340348062, 3967049659, 2927469144,
            3926654939, 2271956463, 3004309866, 260248338,  2570702480, 1879451653, 3168497089,
            361311552,  2123195373, 2825457193, 341920668,  507483626,  1201669979, 910763802,
            4158584821, 3748705813, 3375736126, 2857697336, 3112473104, 2683465481, 3336305747,
            681020485,  4044713962, 2443109893, 129994063,  2578353596, 820410567,  601527649,
            1007603132, 2096580480, 3155251071, 1984297765, 1888157243, 960265104,  527990410,
            2548692624, 1106822080, 1472807331, 2465011897, 3139401215, 736629379,  393081842,
            3826516196, 2576499701, 4130037087, 2440227627, 2188282304, 2949056849, 1138928618,
            858751984,  191805249,  496972334,  830265621,  1355757111, 909444416,  396738554,
            2616327935, 2337227347, 2139876075, 4269663356, 3932761947, 1893005585, 3958551664,
            1746456069, 2430709714, 3171160829, 3333292799, 1833607331, 3864559081, 3415700826,
            1332800826, 1987321873, 1792851165, 505718946,  3755903648, 1770588062, 4035552813,
            2052557448, 2879065999, 22933757,   3159941473, 2321387515, 3556641619, 1350613766,
            2107757927, 2669366188, 1850700415, 3424626316, 545651740,  1935764720, 3252475208,
            979047283,  862046434,  167198649,  338290297,  771814471,  4201635137, 883549156,
            907871968,  638566313,  184144160,  2637527083, 3306095271, 1452688488, 621126888,
            4275587594, 117966344,  1785040579, 454879400,  1952849106, 3806424990, 733998186,
            1623968604, 2997422000, 2633878652, 2670843077, 3360491537, 3053533585, 1654709920,
            1950620393, 3541927406, 1716078578, 2888573892, 2825965566, 1399790365, 3184295779,
            2776111761, 384880529,  3497622676, 1024664651, 723804135,  618916624,  1008618602,
            2816673160, 684112698,  3275521308, 3340690804, 962627614,  3072103948, 3713153075,
            2023106558, 902990902,  126319837,  2155412848, 228580793,  3978575748, 4254301999,
            2689599232, 426191419,  3157759186, 2446138116, 3216403640, 1259677734, 2889209278,
            1754641396, 1706032491, 3221479262, 1298500018, 3340348062, 3967049659, 3805001240,
            3926654939, 2271956463, 3004309866, 260248338,  294480880,  1879451653, 3168497089,
            361311552,  2123195373, 2080604411, 341920668,  507483626,  1201669979, 910763802,
            2012149356, 3748705813, 3375736126, 2857697336, 3112473104, 2935748807, 3336305747,
            681020485,  4044713962, 2443109893, 2862982895, 2578353596, 820410567,  601527649,
            1007603132, 1890290066, 3155251071, 1984297765, 1888157243, 960265104,  41870487,
            2548692624, 1106822080, 1472807331, 2465011897, 2382974023, 736629379,  393081842,
            3826516196, 2576499701, 4219335149, 2440227627, 2188282304, 2949056849, 1138928618,
            3785297102, 191805249,  496972334,  830265621,  1355757111, 3962907313, 396738554,
            2616327935, 2337227347, 2139876075, 552154011,  3932761947, 1893005585, 3958551664,
            1746456069, 895507243,  3171160829, 3333292799, 1833607331, 3864559081, 3564325554,
            1332800826, 1987321873, 1792851165, 505718946,  3245448088, 1770588062, 4035552813,
            2052557448, 2879065999, 3602157977, 3159941473, 2321387515, 3556641619, 1350613766,
            4101259055, 2669366188, 1850700415, 3424626316, 545651740,  2873707882, 3252475208,
            979047283,  862046434,  167198649,  654196140,  771814471,  4201635137, 883549156,
            907871968,  191965184,  184144160,  2637527083, 3306095271, 1452688488, 1562736568,
            4275587594, 117966344,  1785040579, 454879400,  3484019450, 3806424990, 733998186,
            1623968604, 2997422000, 273316614,  2670843077, 3360491537, 3053533585, 1654709920,
            591311873,  3541927406, 1716078578, 2888573892, 2825965566, 2277117038, 3184295779,
            2776111761, 384880529,  3497622676, 1086566797, 723804135,  618916624,  1008618602,
            2816673160, 3344392942, 3275521308, 3340690804, 962627614,  3072103948, 2910444460,
            2023106558, 902990902,  126319837,  2155412848, 337119596,  3978575748, 4254301999,
            2689599232, 426191419,  3471778695, 2446138116, 3216403640, 1259677734, 2889209278,
            4102983766, 1706032491, 3221479262, 1298500018, 3340348062, 2940293024, 3805001240,
            3926654939, 2271956463, 3004309866, 3634668003, 294480880,  1879451653, 3168497089,
            361311552,  3417679321, 2080604411, 341920668,  507483626,  1201669979, 3174274528,
            2012149356, 3748705813, 3375736126, 2857697336, 3929686609, 2935748807, 3336305747,
            681020485,  4044713962, 405011299,  2862982895, 2578353596, 820410567,  601527649,
            4281957726, 1890290066, 3155251071, 1984297765, 1888157243, 1978308818, 41870487,
            2548692624, 1106822080, 1472807331, 3701147046, 2382974023, 736629379,  393081842,
            3826516196, 3225163595, 4219335149, 2440227627, 2188282304, 2949056849, 3894577191,
            3785297102, 191805249,  496972334,  830265621,  4293577013, 3962907313, 396738554,
            2616327935, 2337227347, 3701032380, 552154011,  3932761947, 1893005585, 3958551664,
            4148575672, 895507243,  3171160829, 3333292799, 1833607331, 1596419195, 3564325554,
            1332800826, 1987321873, 1792851165, 3663406943, 3892533309, 247565591,  953356243,
            4103354183, 1908418768, 3915294912, 2390669489, 3865260287, 1818313429, 557880278,
            2499771815, 2618380525, 732785004,  1414011135, 2858311749, 3871596970, 2428464498,
            645476041,  683035653,  4079609082, 2404111028, 3332056297, 3054547484, 3616426087,
            1311379849, 3682136336, 3795847093, 1509718393, 541389178,  1103876446, 2549442278,
            3656600574, 3019560735, 523610761,  3889482885, 3080739216, 2359120072, 1034857006,
            63567637,   1520176098, 1741685274, 2330217396, 1429674399, 517809884,  2653145241,
            868296581,  646514407,  3166145188, 3023629813, 2333851648, 2967365394, 1828821737,
            3333092181, 445460259,  2682093551, 3655100102, 2592872076, 1588368999, 3964958220,
            755397374,  1912970603, 396253754,  4260038354, 1530898510, 2396805917, 3327501452,
            4235709361, 2762163349, 553869167,  3162483580, 1611891352, 248738605,  3403092967,
            2194464420, 113420452,  1752444845, 3770903547, 2397481985, 2866414964, 2555678075,
            2796010061, 762034588,  2679383682, 1848516655, 3857720381, 1119111363, 1829110546,
            2183620391, 1743838702, 3363053704, 2212810289, 966205413,  3897281091, 2148139678,
            2690229390, 427450194,  3516115778, 1864991059, 134448489,  3397232480, 3999530682,
            1927036992, 3170864927, 3879295489, 134554462,  3447324105, 86678510,   1656551206,
            2844494044, 2469678938, 2885597732, 2715483555, 3566904604, 462585182,  1922457093,
            3035264235, 2866504077, 2031456720, 1598555964, 2569915450, 3947972758, 290683210,
            2465427488, 3504862176, 793156806,  1722326752, 2706215067, 3818976191, 2007064241,
            552144413,  2692866408, 3975075075, 4293828741, 1123460373, 960845744,  1855626484,
            1876934434, 1343778249, 912185207,  127278206,  4168930635, 340393978,  65814528,
            2552086271, 2507474816, 1240220220, 1761964455, 2204917500, 4088965101, 1079310398,
            3071460742, 2188549805, 1064733776, 4191719087, 3221046115, 3772395288, 883516842,
            2077853840, 229484673,
        },
        {
            907417779,  1464804076, 439811298,  3869148141, 934141572,  273754023,  2528958210,
            828170781,  2878245386, 1353777835, 2190706147, 1886440928, 1409271766, 891243461,
            2152771416, 4113511164, 1417371384, 3810659963, 2443414486, 2849832820, 2998449437,
            700771108,  3970314532, 2303200158, 2815624489, 1511045500, 804671260,  3746762411,
            3164916013, 1550895097, 2321263263, 4131729747, 892821009,  2781050438, 2997407782,
            2861473637, 1212429435, 1633875769, 3857955995, 272093216,  2905745998, 2734336103,
            2969133559, 334252402,  1075790080, 1108567878, 1019007306, 387327300,  1792982413,
            2238534391, 1041747527, 896354099,  3156033092, 4245974976, 463993779,  2402634517,
            4140167347, 2838088928, 2291418392, 1425927436, 54992088,   2236701784, 3822552534,
            3472231475, 1149471125, 1717466487, 2627591727, 257211492,  1375532410, 3671453923,
            2323050106, 1350202383, 3865207854, 480556215,  3066705168, 3606658478, 1324655971,
            4042191341, 3972824351, 1252000892, 2968577042, 3485030696, 1293029121, 760773011,
            2562202015, 1745656518, 3629617104, 4225510284, 298092470,  1298135694, 1798228917,
            3606594022, 549995161,  3984484844, 2886210903, 2973136437, 645938349,  1976033129,
            778578607,  99127870,   3778070943, 2481345092, 1290396230, 1733824294, 2863092682,
            3307797796, 759060998,  810154113,  3516221,    650437814,  4020326327, 3588180317,
            3557828286, 2901725747, 1347034572, 90322010,   475567698,  2990080917, 2583133862,
            2854351345, 2174492604, 1882889034, 3922415374, 1459476592, 1072740755, 1245108611,
            3834252213, 3023724109, 219476120,  174457070,  111652961,  192610362,  873282496,
            831477969,  3064051576, 2308283871, 2241077449, 4235107446, 2304978178, 2575793,
            3701827217, 630991076,  4126114024, 1581844906, 1013910551, 4269166941, 3056782987,
            477700345,  2253349672, 2277702849, 3482255954, 3989531670, 3567334681, 3101848504,
            663845002,  2432629364, 2794726732, 864917689,  470447744,  3888399940, 3116832953,
            907417779,  1464804076, 439811298,  3869148141, 842892902,  273754023,  2528958210,
            828170781,  2878245386, 1334560310, 2190706147, 1886440928, 1409271766, 891243461,
            3573402162, 4113511164, 1417371384, 3810659963, 2443414486, 1959215707, 2998449437,
            700771108,  3970314532, 2303200158, 3536193946, 1511045500, 804671260,  3746762411,
            3164916013, 4176884394, 2321263263, 4131729747, 892821009,  2781050438, 3028857035,
            2861473637, 1212429435, 1633875769, 3857955995, 3823673944, 2905745998, 2734336103,
            2969133559, 334252402,  848503928,  1108567878, 1019007306, 387327300,  1792982413,
            3686542571, 1041747527, 896354099,  3156033092, 4245974976, 4040198671, 2402634517,
            4140167347, 2838088928, 2291418392, 693786519,  54992088,   2236701784, 3822552534,
            3472231475, 2770013510, 1717466487, 2627591727, 257211492,  1375532410, 3866907377,
            2323050106, 1350202383, 3865207854, 480556215,  757981291,  3606658478, 1324655971,
            4042191341, 3972824351, 3863931920, 2968577042, 3485030696, 1293029121, 760773011,
            4289147296, 1745656518, 3629617104, 4225510284, 298092470,  1751836638, 1798228917,
            3606594022, 549995161,  3984484844, 2617349350, 2973136437, 645938349,  1976033129,
            778578607,  3116074159, 3778070943, 2481345092, 1290396230, 1733824294, 3604116235,
            3307797796, 759060998,  810154113,  3516221,    3633172561, 4020326327, 3588180317,
            3557828286, 2901725747, 2060824795, 90322010,   475567698,  2990080917, 2583133862,
            3460280788, 2174492604, 1882889034, 3922415374, 1459476592, 1529067799, 1245108611,
            3834252213, 3023724109, 219476120,  1861495622, 111652961,  192610362,  873282496,
            831477969,  3290742676, 2308283871, 2241077449, 4235107446, 2304978178, 1690123254,
            3701827217, 630991076,  4126114024, 1581844906, 3854087814, 4269166941, 3056782987,
            477700345,  2253349672, 3236959527, 3482255954, 3989531670, 3567334681, 3101848504,
            3733361509, 2432629364, 2794726732, 864917689,  470447744,  1000914734, 3116832953,
            907417779,  1464804076, 439811298,  1651493425, 842892902,  273754023,  2528958210,
            828170781,  4119871723, 1334560310, 2190706147, 1886440928, 1409271766, 4286638070,
            3573402162, 4113511164, 1417371384, 3810659963, 2073829304, 1959215707, 2998449437,
            700771108,  3970314532, 2761679848, 3536193946, 1511045500, 804671260,  3746762411,
            1416034660, 4176884394, 2321263263, 4131729747, 892821009,  2810712871, 3028857035,
            2861473637, 1212429435, 1633875769, 2060291817, 3823673944, 2905745998, 2734336103,
            2969133559, 3387017721, 848503928,  1108567878, 1019007306, 387327300,  1714974874,
            3686542571, 1041747527, 896354099,  3156033092, 1920926240, 4040198671, 2402634517,
            4140167347, 2838088928, 217432918,  693786519,  54992088,   2236701784, 3822552534,
            2021734152, 2770013510, 1717466487, 2627591727, 257211492,  2743047404, 3866907377,
            2323050106, 1350202383, 3865207854, 218493618,  757981291,  3606658478, 1324655971,
            4042191341, 3206415053, 3863931920, 2968577042, 3485030696, 1293029121, 1036513351,
            4289147296, 1745656518, 3629617104, 4225510284, 1435325571, 1751836638, 1798228917,
            3606594022, 549995161,  3472010178, 2617349350, 2973136437, 645938349,  1976033129,
            1328478549, 3116074159, 3778070943, 2481345092, 1290396230, 371958906,  3604116235,
            3307797796, 759060998,  810154113,  330430236,  3633172561, 4020326327, 3588180317,
            3557828286, 106784126,  2060824795, 90322010,   475567698,  2990080917, 3563575133,
            3460280788, 2174492604, 1882889034, 3922415374, 2337428137, 1529067799, 1245108611,
            3834252213, 3023724109, 4232015526, 1861495622, 111652961,  192610362,  873282496,
            1915338074, 3290742676, 2308283871, 2241077449, 4235107446, 1136961688, 1690123254,
            3701827217, 630991076,  4126114024, 4141240371, 3854087814, 4269166941, 3056782987,
            477700345,  453821043,  3236959527, 3482255954, 3989531670, 3567334681, 3260906617,
            3733361509, 2432629364, 2794726732, 864917689,  3746702903, 1000914734, 3116832953,
            907417779,  1464804076, 2630941713, 1651493425, 842892902,  273754023,  2528958210,
            3590393832, 4119871723, 1334560310, 2190706147, 1886440928, 1078587051, 4286638070,
            3573402162, 4113511164, 1417371384, 4119165354, 2073829304, 1959215707, 2998449437,
            700771108,  72739470,   2761679848, 3536193946, 1511045500, 804671260,  2105601394,
            1416034660, 4176884394, 2321263263, 4131729747, 2052019751, 2810712871, 3028857035,
            2861473637, 1212429435, 3698942506, 2060291817, 3823673944, 2905745998, 2734336103,
            1290030263, 3387017721, 848503928,  1108567878, 1019007306, 1575309979, 1714974874,
            3686542571, 1041747527, 896354099,  343044478,  1920926240, 4040198671, 2402634517,
            4140167347, 342619746,  217432918,  693786519,  54992088,   2236701784, 4106442017,
            2021734152, 2770013510, 1717466487, 2627591727, 3208920998, 2743047404, 3866907377,
            2323050106, 1350202383, 1057803554, 218493618,  757981291,  3606658478, 1324655971,
            3960590214, 3206415053, 3863931920, 2968577042, 3485030696, 2098477423, 1036513351,
            4289147296, 1745656518, 3629617104, 2696725905, 1435325571, 1751836638, 1798228917,
            3606594022, 307657050,  3472010178, 2617349350, 2973136437, 645938349,  2162290738,
            1328478549, 3116074159, 3778070943, 2481345092, 2638112689, 371958906,  3604116235,
            3307797796, 759060998,  4134815723, 330430236,  3633172561, 4020326327, 3588180317,
            3776954289, 106784126,  2060824795, 90322010,   475567698,  2711628517, 3563575133,
            3460280788, 2174492604, 1882889034, 178662943,  2337428137, 1529067799, 1245108611,
            3834252213, 2895847480, 4232015526, 1861495622, 111652961,  192610362,  3575673646,
            1915338074, 3290742676, 2308283871, 2241077449, 2893276410, 1136961688, 1690123254,
            3701827217, 630991076,  1406611917, 4141240371, 3854087814, 4269166941, 3056782987,
            2208522193, 453821043,  3236959527, 3482255954, 3989531670, 1164825577, 3260906617,
            3733361509, 2432629364, 2794726732, 3143842609, 4216960303, 2339731075, 494655658,
            530204831,  3962313181, 3782166989, 1844180334, 718669358,  509533690,  2056310495,
            3493047248, 3328540516, 2053571717, 2033207091, 1571758547, 2583335140, 367310668,
            3449451865, 469181731,  2674436137, 1266973826, 801748624,  888637574,  271037723,
            2442374145, 4008408722, 1962964262, 618265715,  171452508,  2091018983, 3821442143,
            4085890519, 2177156693, 1328134504, 2216451996, 1939783774, 209913895,  591553158,
            876885537,  560573697,  533845418,  1878621261, 2523433088, 3798482161, 2066559005,
            1064362076, 2199879887, 1961979219, 1382876127, 3806598090, 1143591148, 2327529768,
            1152832930, 2688661297, 2379074021, 3633699678, 2605308522, 3179858882, 3811217126,
            3804306049, 182789902,  444159637,  3643973183, 4281150900, 146382070,  1972283754,
            3313355236, 1687095754, 3024513172, 4213739965, 2829773150, 363966561,  3672157396,
            1603341675, 1093297093, 832766740,  3591478183, 3516337713, 934204023,  4233087981,
            476689101,  3927023421, 626569043,  420504443,  2314494141, 3362936710, 82431336,
            3063354409, 3343080242, 3972417349, 509922771,  690835012,  252137413,  3880615113,
            1334160883, 3937888769, 715879933,  817947112,  3350761295, 204977830,  1231433533,
            688381054,  2360879162, 458958242,  1016204884, 4049365673, 1306126561, 433640925,
            1358542150, 1377718023, 1657067284, 1312876127, 2204432569, 3661100746, 3076832936,
            250524734,  2255094003, 1179523218, 3114632140, 3316672937, 793709078,  470053099,
            1993589767, 924509557,  1357906764, 2863539762, 2194886199, 2349440447, 1988007973,
            3333349368, 1060488791, 363450039,  3069329860, 3171565751, 1486206247, 2396639667,
            3136399546, 4203327236, 700848532,  1264535898, 3878464928, 2766669112, 3226812110,
            485513311,  4042787681, 2737781420, 1442409119, 2957106201, 1312263492, 1426078103,
            3601032774, 3450840117, 224375058,  3268457280, 57415610,   1174520915, 2220668970,
            1524247375, 3391410491,
        },
        {
            448889887,  3508620909, 4164289950, 155254859,  298319697,  980080883,  3500794888,
            3974907245, 682778656,  382798811,  1500342771, 3942535492, 1039809505, 2126581011,
            561192171,  4046277638, 840733718,  1694555864, 241216466,  4182349979, 2525929010,
            386794637,  349755829,  2959959729, 686974318,  3243688353, 3911051908, 3917458620,
            441833800,  3164548257, 584185450,  450132281,  3528356519, 4275666503, 1317069624,
            817077137,  2945430988, 1532878265, 2542155552, 3348614029, 1419611574, 1245233100,
            1981161828, 1161647342, 2781439556, 3896025436, 2349200248, 1213899699, 860301545,
            1590934964, 3371591516, 2850926464, 2774569126, 907316453,  3541736952, 3572719697,
            278602945,  4257620354, 3396349537, 3144949411, 191271983,  2974056951, 2743594803,
            1119054633, 815666748,  920991498,  187861899,  2008325469, 1548504646, 3749744762,
            993523345,  1171349070, 4105576982, 1559471848, 2656434170, 2795453957, 3357293755,
            4260164297, 2211998873, 1783238785, 2831224398, 1704939914, 2626903427, 1148581053,
            849777796,  4219173763, 694869701,  1297370017, 3573985711, 1739242781, 3680794431,
            400850360,  909653264,  1496585542, 460982606,  828640603,  3993062500, 2145047281,
            1587836828, 912583500,  1234319994, 4276951314, 485282908,  1903750880, 1667769214,
            3950976882, 3711912938, 3626058764, 627857875,  436470402,  1753727232, 50241405,
            206782941,  612110492,  954016857,  2567547031, 3360482779, 820704062,  412722485,
            2044763466, 1915626743, 2703000434, 2755090057, 53587450,   2457122208, 1397065983,
            2822294224, 3024827428, 2201149820, 699377793,  157099022,  2792298089, 3927835437,
            1095494739, 1230723791, 2740420278, 2518077381, 3674832547, 2375246835, 923451748,
            3665432731, 1577970518, 2643388181, 4050379756, 1145072065, 1632232822, 2365350332,
            1126185680, 930842061,  3816331201, 1624573114, 3809118349, 1187817320, 945407897,
            63630679,   1852369563, 971772965,  2229069035, 2320405193, 3474864049, 1666937976,
            448889887,  3508620909, 4164289950, 155254859,  3157319819, 980080883,  3500794888,
            3974907245, 682778656,  3201604042, 1500342771, 3942535492, 1039809505, 2126581011,
            3235144326, 4046277638, 840733718,  1694555864, 241216466,  2728337326, 2525929010,
            386794637,  349755829,  2959959729, 20820947,   3243688353, 3911051908, 3917458620,
            441833800,  4143649787, 584185450,  450132281,  3528356519, 4275666503, 3541347868,
            817077137,  2945430988, 1532878265, 2542155552, 3199458552, 1419611574, 1245233100,
            1981161828, 1161647342, 958085276,  3896025436, 2349200248, 1213899699, 860301545,
            1701089635, 3371591516, 2850926464, 2774569126, 907316453,  1529987826, 3572719697,
            278602945,  4257620354, 3396349537, 4120000342, 191271983,  2974056951, 2743594803,
            1119054633, 4255116655, 920991498,  187861899,  2008325469, 1548504646, 100038488,
            993523345,  1171349070, 4105576982, 1559471848, 2523523381, 2795453957, 3357293755,
            4260164297, 2211998873, 3644225670, 2831224398, 1704939914, 2626903427, 1148581053,
            1292003378, 4219173763, 694869701,  1297370017, 3573985711, 2510138592, 3680794431,
            400850360,  909653264,  1496585542, 1738256576, 828640603,  3993062500, 2145047281,
            1587836828, 3478998519, 1234319994, 4276951314, 485282908,  1903750880, 746205619,
            3950976882, 3711912938, 3626058764, 627857875,  954627753,  1753727232, 50241405,
            206782941,  612110492,  2251018875, 2567547031, 3360482779, 820704062,  412722485,
            2120077037, 1915626743, 2703000434, 2755090057, 53587450,   2696843657, 1397065983,
            2822294224, 3024827428, 2201149820, 3308142895, 157099022,  2792298089, 3927835437,
            1095494739, 730099534,  2740420278, 2518077381, 3674832547, 2375246835, 2126745526,
            3665432731, 1577970518, 2643388181, 4050379756, 2987545029, 1632232822, 2365350332,
            1126185680, 930842061,  3140947362, 1624573114, 3809118349, 1187817320, 945407897,
            1282799903, 1852369563, 971772965,  2229069035, 2320405193, 670134249,  1666937976,
            448889887,  3508620909, 4164289950, 127045110,  3157319819, 980080883,  3500794888,
            3974907245, 2740953010, 3201604042, 1500342771, 3942535492, 1039809505, 306788856,
            3235144326, 4046277638, 840733718,  1694555864, 2260304655, 2728337326, 2525929010,
            386794637,  349755829,  3842816805, 20820947,   3243688353, 3911051908, 3917458620,
            3398227861, 4143649787, 584185450,  450132281,  3528356519, 550401017,  3541347868,
            817077137,  2945430988, 1532878265, 1045681234, 3199458552, 1419611574, 1245233100,
            1981161828, 1153297031, 958085276,  3896025436, 2349200248, 1213899699, 1451842347,
            1701089635, 3371591516, 2850926464, 2774569126, 1269128107, 1529987826, 3572719697,
            278602945,  4257620354, 2479560493, 4120000342, 191271983,  2974056951, 2743594803,
            4081110580, 4255116655, 920991498,  187861899,  2008325469, 1300371976, 100038488,
            993523345,  1171349070, 4105576982, 3010753279, 2523523381, 2795453957, 3357293755,
            4260164297, 207153762,  3644225670, 2831224398, 1704939914, 2626903427, 916783095,
            1292003378, 4219173763, 694869701,  1297370017, 3388725608, 2510138592, 3680794431,
            400850360,  909653264,  2421730678, 1738256576, 828640603,  3993062500, 2145047281,
            2123619770, 3478998519, 1234319994, 4276951314, 485282908,  4002661777, 746205619,
            3950976882, 3711912938, 3626058764, 1230937254, 954627753,  1753727232, 50241405,
            206782941,  460314337,  2251018875, 2567547031, 3360482779, 820704062,  1339598718,
            2120077037, 1915626743, 2703000434, 2755090057, 660730207,  2696843657, 1397065983,
            2822294224, 3024827428, 126840648,  3308142895, 157099022,  2792298089, 3927835437,
            2192535935, 730099534,  2740420278, 2518077381, 3674832547, 1879512787, 2126745526,
            3665432731, 1577970518, 2643388181, 832572764,  2987545029, 1632232822, 2365350332,
            1126185680, 3248646182, 3140947362, 1624573114, 3809118349, 1187817320, 4270855000,
            1282799903, 1852369563, 971772965,  2229069035, 3735782785, 670134249,  1666937976,
            448889887,  3508620909, 3681408470, 127045110,  3157319819, 980080883,  3500794888,
            3967872553, 2740953010, 3201604042, 1500342771, 3942535492, 613854690,  306788856,
            3235144326, 4046277638, 840733718,  3957877023, 2260304655, 2728337326, 2525929010,
            386794637,  1779451936, 3842816805, 20820947,   3243688353, 3911051908, 688470429,
            3398227861, 4143649787, 584185450,  450132281,  3381050556, 550401017,  3541347868,
            817077137,  2945430988, 1859551669, 1045681234, 3199458552, 1419611574, 1245233100,
            53681099,   1153297031, 958085276,  3896025436, 2349200248, 1796144514, 1451842347,
            1701089635, 3371591516, 2850926464, 1337394836, 1269128107, 1529987826, 3572719697,
            278602945,  46913829,   2479560493, 4120000342, 191271983,  2974056951, 1361976701,
            4081110580, 4255116655, 920991498,  187861899,  1237191391, 1300371976, 100038488,
            993523345,  1171349070, 3168325479, 3010753279, 2523523381, 2795453957, 3357293755,
            2142853843, 207153762,  3644225670, 2831224398, 1704939914, 2369686128, 916783095,
            1292003378, 4219173763, 694869701,  4150182218, 3388725608, 2510138592, 3680794431,
            400850360,  654034492,  2421730678, 1738256576, 828640603,  3993062500, 84735560,
            2123619770, 3478998519, 1234319994, 4276951314, 2545204994, 4002661777, 746205619,
            3950976882, 3711912938, 426068544,  1230937254, 954627753,  1753727232, 50241405,
            589286339,  460314337,  2251018875, 2567547031, 3360482779, 3279873953, 1339598718,
            2120077037, 1915626743, 2703000434, 2720159887, 660730207,  2696843657, 1397065983,
            2822294224, 3536645029, 126840648,  3308142895, 157099022,  2792298089, 485214530,
            2192535935, 730099534,  2740420278, 2518077381, 418832171,  1879512787, 2126745526,
            3665432731, 1577970518, 721018,     832572764,  2987545029, 1632232822, 2365350332,
            1769688764, 3248646182, 3140947362, 1624573114, 3809118349, 3561012744, 4270855000,
            1282799903, 1852369563, 971772965,  2160782957, 105464019,  2131462864, 335205049,
            3271229551, 1374396416, 4269753677, 1984596635, 37563880,   3956352262, 2168603656,
            311623712,  1593371323, 351020595,  3439337532, 3130874657, 3613343327, 695789539,
            609797513,  53642143,   1479027519, 1588831722, 262810641,  3418379977, 530167431,
            1962487963, 2410103328, 3360114680, 3548827677, 2735238248, 2136058369, 4013192489,
            4106245442, 2155966460, 3653971354, 1230293148, 3966689348, 3455336684, 3594979856,
            3178937309, 3983796170, 3617590004, 1727358326, 1121418876, 1022562029, 2437823131,
            2733424381, 452731958,  2983755220, 1674750403, 3110921909, 3514365950, 2193238341,
            2073801740, 669573402,  1824298084, 22336337,   3366446304, 1536043612, 2502297553,
            1409641611, 2399583184, 2593245170, 716832039,  4286149460, 814849965,  4239224908,
            2453627262, 976385355,  1846129423, 52096201,   88835472,   2621770794, 2491757130,
            1849417480, 576668065,  2186701850, 3357019214, 442191324,  3662645846, 3653766782,
            2254203663, 1169821059, 3735427676, 2246044748, 2635264668, 2647842566, 1435695450,
            1658777934, 2927080369, 1341088646, 3565982642, 221661496,  3246988243, 2718455491,
            483517148,  4181332651, 1143646375, 1720449423, 331164544,  539836322,  3485371630,
            1110077273, 4088985694, 145720169,  2382276586, 4276410795, 2051956774, 936524156,
            15415192,   1815949694, 272696290,  1495465483, 3102030383, 3546078241, 3272619595,
            759699322,  1161486824, 1146281812, 4194130649, 3936306436, 4077338125, 2127551216,
            2995077453, 209698652,  3836657987, 1782152220, 1642490089, 3695579542, 537862234,
            1696168156, 4022607,    3642864269, 54404878,   2925910542, 3444042482, 1931288691,
            2269375687, 614870298,  1139082272, 3672546472, 3255845763, 2987873616, 3436501734,
            380553853,  750118352,  750708138,  488564982,  2936846643, 3460652101, 3085496886,
            3734224010, 523359404,  2751912206, 3302219188, 2729509827, 1995554251, 2288103059,
            3289667468, 2860301591,
        },
        {
            1814867666, 231795260,  120548436,  3419165176, 340936087,  3420132091, 1337977898,
            1604654700, 3320854900, 184174680,  3914987262, 233498287,  79089542,   3663610349,
            252339224,  3743041539, 1186376704, 312877698,  4245403079, 2999351260, 1163738297,
            3590749286, 1592751118, 2405924475, 1625508732, 2780176572, 3318821250, 2496631650,
            2005153843, 1047274702, 2211920818, 2673176767, 3162113273, 275307580,  335732375,
            3622468908, 530735979,  661937262,  2870043864, 2915533690, 269567796,  2377862825,
            2226756493, 1947592226, 612532609,  272779247,  1424073050, 4070655393, 964108986,
            3481852641, 4251997958, 2950990450, 2888388747, 2813820949, 295480329,  296598804,
            1785255134, 636716928,  2743071289, 466825247,  1702717423, 343829748,  1860379870,
            3403319429, 544826718,  3230848212, 2782097327, 3880139339, 4049323878, 4004773597,
            2367355254, 515544012,  1063736650, 2732059524, 3006328080, 3500809354, 443576163,
            1046770440, 2438051467, 446348561,  3337315116, 2711244563, 3076004482, 575967478,
            3401731829, 1228436859, 2397161804, 2068553972, 2541832547, 3283990698, 202313489,
            204715000,  2585522256, 1495658019, 968183482,  1222768408, 3522372830, 3506049945,
            1845914776, 3756208108, 983667422,  752197537,  882999747,  374056678,  1739968722,
            4255288834, 1844669888, 2268185731, 4215655514, 2234988291, 1637660557, 1633496383,
            4005478037, 1380901890, 1098666113, 2282096093, 1692581905, 4083069908, 3702076001,
            640646670,  259747352,  2889136661, 1390126471, 2652520052, 2762666830, 3594139643,
            265242694,  3595485345, 201191860,  4199766783, 2874345804, 4050208733, 1849026058,
            1286837413, 3008366638, 229993023,  2751265191, 1364375530, 946844756,  2277261140,
            33809274,   180953024,  254208726,  1375416716, 1872364017, 4141825419, 544789571,
            1979727696, 2612178978, 2080126093, 3017229864, 2782298003, 1845369355, 2470813017,
            3358582097, 1687319855, 2716016377, 3698347766, 1477648822, 443814754,  3876321412,
            1814867666, 231795260,  120548436,  3419165176, 2791342725, 3420132091, 1337977898,
            1604654700, 3320854900, 638928681,  3914987262, 233498287,  79089542,   3663610349,
            2722284769, 3743041539, 1186376704, 312877698,  4245403079, 3337332622, 1163738297,
            3590749286, 1592751118, 2405924475, 3643668323, 2780176572, 3318821250, 2496631650,
            2005153843, 3441142347, 2211920818, 2673176767, 3162113273, 275307580,  1895856152,
            3622468908, 530735979,  661937262,  2870043864, 3231658155, 269567796,  2377862825,
            2226756493, 1947592226, 3871935966, 272779247,  1424073050, 4070655393, 964108986,
            1358068304, 4251997958, 2950990450, 2888388747, 2813820949, 1649967293, 296598804,
            1785255134, 636716928,  2743071289, 4255024030, 1702717423, 343829748,  1860379870,
            3403319429, 130221150,  3230848212, 2782097327, 3880139339, 4049323878, 275543973,
            2367355254, 515544012,  1063736650, 2732059524, 2733840594, 3500809354, 443576163,
            1046770440, 2438051467, 1351683115, 3337315116, 2711244563, 3076004482, 575967478,
            483597241,  1228436859, 2397161804, 2068553972, 2541832547, 1103639251, 202313489,
            204715000,  2585522256, 1495658019, 1062494682, 1222768408, 3522372830, 3506049945,
            1845914776, 251869605,  983667422,  752197537,  882999747,  374056678,  2658869996,
            4255288834, 1844669888, 2268185731, 4215655514, 3684921470, 1637660557, 1633496383,
            4005478037, 1380901890, 358238993,  2282096093, 1692581905, 4083069908, 3702076001,
            2456543672, 259747352,  2889136661, 1390126471, 2652520052, 936978017,  3594139643,
            265242694,  3595485345, 201191860,  3673462689, 2874345804, 4050208733, 1849026058,
            1286837413, 333468074,  229993023,  2751265191, 1364375530, 946844756,  420301532,
            33809274,   180953024,  254208726,  1375416716, 4096340475, 4141825419, 544789571,
            1979727696, 2612178978, 784257184,  3017229864, 2782298003, 1845369355, 2470813017,
            2565919631, 1687319855, 2716016377, 3698347766, 1477648822, 3141289519, 3876321412,
            1814867666, 231795260,  120548436,  715762783,  2791342725, 3420132091, 1337977898,
            1604654700, 1764762827, 638928681,  3914987262, 233498287,  79089542,   2587313193,
            2722284769, 3743041539, 1186376704, 312877698,  293013398,  3337332622, 1163738297,
            3590749286, 1592751118, 3074553484, 3643668323, 2780176572, 3318821250, 2496631650,
            770399171,  3441142347, 2211920818, 2673176767, 3162113273, 2347115159, 1895856152,
            3622468908, 530735979,  661937262,  3101307118, 3231658155, 269567796,  2377862825,
            2226756493, 2157449419, 3871935966, 272779247,  1424073050, 4070655393, 2671009762,
            1358068304, 4251997958, 2950990450, 2888388747, 2475686419, 1649967293, 296598804,
            1785255134, 636716928,  885765003,  4255024030, 1702717423, 343829748,  1860379870,
            722575523,  130221150,  3230848212, 2782097327, 3880139339, 3775116514, 275543973,
            2367355254, 515544012,  1063736650, 4185057620, 2733840594, 3500809354, 443576163,
            1046770440, 1286548239, 1351683115, 3337315116, 2711244563, 3076004482, 4117986574,
            483597241,  1228436859, 2397161804, 2068553972, 727028289,  1103639251, 202313489,
            204715000,  2585522256, 3205063846, 1062494682, 1222768408, 3522372830, 3506049945,
            747456316,  251869605,  983667422,  752197537,  882999747,  3370136441, 2658869996,
            4255288834, 1844669888, 2268185731, 4049524891, 3684921470, 1637660557, 1633496383,
            4005478037, 3354792003, 358238993,  2282096093, 1692581905, 4083069908, 2163068414,
            2456543672, 259747352,  2889136661, 1390126471, 1973580803, 936978017,  3594139643,
            265242694,  3595485345, 2567612411, 3673462689, 2874345804, 4050208733, 1849026058,
            591230626,  333468074,  229993023,  2751265191, 1364375530, 2061035538, 420301532,
            33809274,   180953024,  254208726,  2940267890, 4096340475, 4141825419, 544789571,
            1979727696, 426594023,  784257184,  3017229864, 2782298003, 1845369355, 844025045,
            2565919631, 1687319855, 2716016377, 3698347766, 2540955104, 3141289519, 3876321412,
            1814867666, 231795260,  1269830525, 715762783,  2791342725, 3420132091, 1337977898,
            2540869779, 1764762827, 638928681,  3914987262, 233498287,  3719837592, 2587313193,
            2722284769, 3743041539, 1186376704, 1254642079, 293013398,  3337332622, 1163738297,
            3590749286, 89176149,   3074553484, 3643668323, 2780176572, 3318821250, 2548030952,
            770399171,  3441142347, 2211920818, 2673176767, 1418512918, 2347115159, 1895856152,
            3622468908, 530735979,  2495431792, 3101307118, 3231658155, 269567796,  2377862825,
            1251142238, 2157449419, 3871935966, 272779247,  1424073050, 2301685612, 2671009762,
            1358068304, 4251997958, 2950990450, 1248331895, 2475686419, 1649967293, 296598804,
            1785255134, 3693162872, 885765003,  4255024030, 1702717423, 343829748,  3296645466,
            722575523,  130221150,  3230848212, 2782097327, 2655220989, 3775116514, 275543973,
            2367355254, 515544012,  2884821409, 4185057620, 2733840594, 3500809354, 443576163,
            69762227,   1286548239, 1351683115, 3337315116, 2711244563, 193864671,  4117986574,
            483597241,  1228436859, 2397161804, 1007532725, 727028289,  1103639251, 202313489,
            204715000,  3302918990, 3205063846, 1062494682, 1222768408, 3522372830, 2528568690,
            747456316,  251869605,  983667422,  752197537,  3659886846, 3370136441, 2658869996,
            4255288834, 1844669888, 1832976327, 4049524891, 3684921470, 1637660557, 1633496383,
            1599716924, 3354792003, 358238993,  2282096093, 1692581905, 3699161959, 2163068414,
            2456543672, 259747352,  2889136661, 440662734,  1973580803, 936978017,  3594139643,
            265242694,  1621074737, 2567612411, 3673462689, 2874345804, 4050208733, 2620013788,
            591230626,  333468074,  229993023,  2751265191, 3048945047, 2061035538, 420301532,
            33809274,   180953024,  1064351531, 2940267890, 4096340475, 4141825419, 544789571,
            1768032736, 426594023,  784257184,  3017229864, 2782298003, 729935556,  844025045,
            2565919631, 1687319855, 2716016377, 2217893472, 3694112591, 2905385771, 3227389102,
            3521166614, 2313335900, 3674260251, 1726020307, 3557574969, 436088411,  3328006262,
            2225460599, 2735784871, 3740664161, 3084294476, 3328660709, 2268886693, 2994918322,
            3316523246, 4118065754, 3480097999, 3393143371, 2323209985, 2106728298, 4237844820,
            424830010,  2538182039, 344732015,  103380377,  754131527,  3582596498, 1317351963,
            1542686191, 2155441875, 1759338706, 2632127960, 2945048894, 3580770237, 4022393527,
            167644100,  1335428891, 1362172636, 822142949,  3294052999, 442424098,  2336967160,
            881087092,  3414733717, 2406250338, 736629422,  215022177,  949873719,  378618231,
            1802712499, 867880069,  1743142640, 4043437076, 1269732626, 836021343,  1278127833,
            2316655031, 3639332311, 902337993,  3457736337, 3436656622, 4116574674, 2140467498,
            2720909609, 3032883747, 281683760,  3179149626, 2973299362, 756027028,  2780409392,
            2221215529, 3700408979, 690002709,  404929008,  1817690002, 715319962,  2397021464,
            3655920533, 105826502,  1739755152, 549257850,  1320669602, 4138244256, 287895380,
            1688129991, 4050553413, 2449899365, 2099988692, 2563102465, 2898679919, 4002277568,
            1583200295, 3362835377, 3599113904, 2522827138, 2359988378, 1394553406, 2466842716,
            829246077,  2179264454, 1576189009, 3012651741, 317917946,  1768236330, 3704106745,
            2133263170, 3542125828, 3468365204, 1976286653, 1313128382, 1063591484, 1391720664,
            2717888935, 2139961064, 1377054208, 3238352652, 1453383440, 2397635869, 3213532190,
            3870802249, 999774562,  2068254937, 3010862249, 735455551,  1582146489, 1042024798,
            1893433175, 1244555442, 3761009277, 280827407,  3207937072, 2891315011, 428119820,
            952325113,  454524113,  3194403811, 70607210,   2978895101, 3411459311, 3529242163,
            3495433545, 3530749630, 3976348053, 1111665895, 3060505884, 1085579415, 1516942548,
            856210740,  711324627,  81470323,   3071042907, 704339091,  41595479,   808746626,
            2831461645, 3428243490,
        },
        {
            3481653941, 2111903071, 3569014882, 1149634763, 4206972571, 2948781360, 2576820949,
            2587099571, 3987042644, 4255777336, 2829594348, 3832744490, 3554499754, 787920018,
            695635693,  2746034685, 2078139227, 1144320548, 4020978225, 449503505,  3004993826,
            2045843139, 1604631401, 148449881,  457819243,  4089112489, 1713441237, 1790909556,
            3334464951, 3070008305, 811825474,  4089105370, 708239097,  1494832299, 2074902973,
            468898217,  1722559700, 2499754488, 2267939270, 650114709,  549502184,  4040463514,
            4228169080, 4094284819, 1599334548, 2992525399, 2107053637, 197348940,  1669884894,
            3982326753, 4259099320, 1862793542, 1751219817, 2701271514, 2507353222, 1488339939,
            4246544316, 3978321870, 132720476,  3020305599, 154822619,  2595474066, 1654579304,
            1997335204, 891320674,  3153502700, 601607977,  2695457160, 4137981809, 37584248,
            1674050253, 1805619463, 676369068,  2294902904, 658143166,  141452045,  2383327493,
            1222336195, 2628962123, 2378299402, 2724274090, 1783957650, 453206569,  3190116972,
            1480368955, 1145768764, 3628222572, 3108689607, 182547022,  360165920,  3378423016,
            1443723222, 2843274258, 1597581683, 664283285,  258077235,  3071875976, 240688930,
            988895736,  2965351284, 91332032,   941306162,  2464278288, 3493666272, 2437043750,
            2356658919, 24726067,   3025656863, 1343636659, 2408295270, 3097408183, 461428710,
            2449005423, 3220070834, 1418517867, 907095008,  428073188,  1938061314, 2094361729,
            2570445990, 346999411,  990247709,  1630488660, 2574142591, 1466590284, 1906935236,
            1592544037, 4168163186, 2773942807, 939392801,  1610069434, 1935303983, 2962954128,
            2490925509, 4103025390, 3614258069, 174125899,  4113855120, 2449365101, 3384244363,
            4115219971, 3187664453, 4021992190, 2959372973, 2946571025, 2144945539, 388172915,
            1125615727, 881693338,  3313110562, 859388069,  177786360,  4134747901, 616417204,
            2104495620, 783302897,  512784708,  1295821322, 3810209448, 2966899912, 2390608767,
            3481653941, 2111903071, 3569014882, 1149634763, 1385372463, 2948781360, 2576820949,
            2587099571, 3987042644, 2251144849, 2829594348, 3832744490, 3554499754, 787920018,
            73007125,   2746034685, 2078139227, 1144320548, 4020978225, 2729117517, 3004993826,
            2045843139, 1604631401, 148449881,  3343221736, 4089112489, 1713441237, 1790909556,
            3334464951, 1920962856, 811825474,  4089105370, 708239097,  1494832299, 2485576001,
            468898217,  1722559700, 2499754488, 2267939270, 2271486862, 549502184,  4040463514,
            4228169080, 4094284819, 3177940420, 2992525399, 2107053637, 197348940,  1669884894,
            3596140613, 4259099320, 1862793542, 1751219817, 2701271514, 1357847339, 1488339939,
            4246544316, 3978321870, 132720476,  344033794,  154822619,  2595474066, 1654579304,
            1997335204, 1849659590, 3153502700, 601607977,  2695457160, 4137981809, 3559496104,
            1674050253, 1805619463, 676369068,  2294902904, 1583197657, 141452045,  2383327493,
            1222336195, 2628962123, 3486106126, 2724274090, 1783957650, 453206569,  3190116972,
            1939413704, 1145768764, 3628222572, 3108689607, 182547022,  2911760834, 3378423016,
            1443723222, 2843274258, 1597581683, 3599911248, 258077235,  3071875976, 240688930,
            988895736,  4263328855, 91332032,   941306162,  2464278288, 3493666272, 1561559932,
            2356658919, 24726067,   3025656863, 1343636659, 257301433,  3097408183, 461428710,
            2449005423, 3220070834, 3544357262, 907095008,  428073188,  1938061314, 2094361729,
            4112109825, 346999411,  990247709,  1630488660, 2574142591, 1466763688, 1906935236,
            1592544037, 4168163186, 2773942807, 3608227467, 1610069434, 1935303983, 2962954128,
            2490925509, 825197245,  3614258069, 174125899,  4113855120, 2449365101, 167881680,
            4115219971, 3187664453, 4021992190, 2959372973, 1971633162, 2144945539, 388172915,
            1125615727, 881693338,  223946687,  859388069,  177786360,  4134747901, 616417204,
            722598357,  783302897,  512784708,  1295821322, 3810209448, 1589703161, 2390608767,
            3481653941, 2111903071, 3569014882, 2520719089, 1385372463, 2948781360, 2576820949,
            2587099571, 1427210741, 2251144849, 2829594348, 3832744490, 3554499754, 1257461820,
            73007125,   2746034685, 2078139227, 1144320548, 3065859797, 2729117517, 3004993826,
            2045843139, 1604631401, 36092756,   3343221736, 4089112489, 1713441237, 1790909556,
            1504385586, 1920962856, 811825474,  4089105370, 708239097,  4135459720, 2485576001,
            468898217,  1722559700, 2499754488, 1392696606, 2271486862, 549502184,  4040463514,
            4228169080, 2521060775, 3177940420, 2992525399, 2107053637, 197348940,  4225425195,
            3596140613, 4259099320, 1862793542, 1751219817, 3752827533, 1357847339, 1488339939,
            4246544316, 3978321870, 270743120,  344033794,  154822619,  2595474066, 1654579304,
            986127123,  1849659590, 3153502700, 601607977,  2695457160, 437034992,  3559496104,
            1674050253, 1805619463, 676369068,  956939381,  1583197657, 141452045,  2383327493,
            1222336195, 3287498300, 3486106126, 2724274090, 1783957650, 453206569,  3610364652,
            1939413704, 1145768764, 3628222572, 3108689607, 708259891,  2911760834, 3378423016,
            1443723222, 2843274258, 1498209005, 3599911248, 258077235,  3071875976, 240688930,
            3815218922, 4263328855, 91332032,   941306162,  2464278288, 3018835600, 1561559932,
            2356658919, 24726067,   3025656863, 368313673,  257301433,  3097408183, 461428710,
            2449005423, 3690066046, 3544357262, 907095008,  428073188,  1938061314, 2274317748,
            4112109825, 346999411,  990247709,  1630488660, 1584471638, 1466763688, 1906935236,
            1592544037, 4168163186, 473837206,  3608227467, 1610069434, 1935303983, 2962954128,
            391171548,  825197245,  3614258069, 174125899,  4113855120, 2095676907, 167881680,
            4115219971, 3187664453, 4021992190, 4246237180, 1971633162, 2144945539, 388172915,
            1125615727, 3158677395, 223946687,  859388069,  177786360,  4134747901, 4017781965,
            722598357,  783302897,  512784708,  1295821322, 3908594844, 1589703161, 2390608767,
            3481653941, 2111903071, 2713757719, 2520719089, 1385372463, 2948781360, 2576820949,
            638075690,  1427210741, 2251144849, 2829594348, 3832744490, 2871270139, 1257461820,
            73007125,   2746034685, 2078139227, 1974062189, 3065859797, 2729117517, 3004993826,
            2045843139, 772058252,  36092756,   3343221736, 4089112489, 1713441237, 2172680702,
            1504385586, 1920962856, 811825474,  4089105370, 1822881146, 4135459720, 2485576001,
            468898217,  1722559700, 3429640856, 1392696606, 2271486862, 549502184,  4040463514,
            3072935276, 2521060775, 3177940420, 2992525399, 2107053637, 1114377646, 4225425195,
            3596140613, 4259099320, 1862793542, 1439724658, 3752827533, 1357847339, 1488339939,
            4246544316, 1051119047, 270743120,  344033794,  154822619,  2595474066, 3143800435,
            986127123,  1849659590, 3153502700, 601607977,  2334441739, 437034992,  3559496104,
            1674050253, 1805619463, 455274178,  956939381,  1583197657, 141452045,  2383327493,
            1520979444, 3287498300, 3486106126, 2724274090, 1783957650, 2212706740, 3610364652,
            1939413704, 1145768764, 3628222572, 2719501850, 708259891,  2911760834, 3378423016,
            1443723222, 2678486648, 1498209005, 3599911248, 258077235,  3071875976, 513762712,
            3815218922, 4263328855, 91332032,   941306162,  3000922309, 3018835600, 1561559932,
            2356658919, 24726067,   3626352172, 368313673,  257301433,  3097408183, 461428710,
            2370224855, 3690066046, 3544357262, 907095008,  428073188,  2279237523, 2274317748,
            4112109825, 346999411,  990247709,  896290404,  1584471638, 1466763688, 1906935236,
            1592544037, 2387522308, 473837206,  3608227467, 1610069434, 1935303983, 4120978868,
            391171548,  825197245,  3614258069, 174125899,  2940674123, 2095676907, 167881680,
            4115219971, 3187664453, 456143482,  4246237180, 1971633162, 2144945539, 388172915,
            4041481385, 3158677395, 223946687,  859388069,  177786360,  3094936989, 4017781965,
            722598357,  783302897,  512784708,  4078350595, 2002159085, 3374931831, 1327513052,
            4231642441, 2398594140, 2750176655, 2377078716, 3051451207, 2923556938, 392203913,
            970480700,  1611278056, 1212903807, 85815670,   2398261756, 1052760308, 175807153,
            2617028873, 1862087601, 1824020594, 3770624867, 141863380,  2090619424, 3994019338,
            2363183556, 3095139522, 1792884692, 3026343485, 2320955816, 145789343,  214170401,
            2926373126, 3858640613, 2188241463, 459887603,  2117474937, 2514234285, 1454156613,
            1675396814, 4188979068, 1584843874, 3594779833, 563029256,  28681425,   446949770,
            3498545218, 435874305,  3448653884, 863509898,  2247299904, 4211345429, 971855563,
            1475394960, 3401692834, 167361776,  496249436,  1465278889, 780336162,  2108770597,
            1806981510, 3677875653, 1890122303, 16399665,   2747394159, 2098019492, 1597583332,
            1763649529, 1286079969, 1846278877, 1016796923, 959676917,  3091540766, 1626192266,
            780987350,  1102963422, 2507002232, 691766944,  193328868,  981596600,  2384820612,
            3149668778, 1691569420, 2852237957, 893819979,  2572584243, 216077070,  1267249886,
            2572508880, 1706489454, 2391561733, 2608477467, 209783612,  765896849,  3617020328,
            3488800100, 2237655981, 2095308189, 963275857,  3563488318, 1865487834, 480006810,
            18562439,   1025913188, 3368592397, 374648713,  2421713724, 2705651398, 3098059650,
            1109934605, 3085839620, 3184266772, 2359972463, 862934481,  3624479194, 3574284465,
            2700143837, 2468083868, 3798800988, 4116964911, 1832002264, 4276154871, 3256889524,
            4036954281, 697729046,  886223984,  2196986730, 1157617208, 1995907944, 398452318,
            3523714364, 613570866,  2962430983, 1408814780, 892117129,  4173164219, 3894076479,
            2721348430, 555734931,  1869034419, 336114876,  3142554871, 3349604636, 3450290892,
            955122895,  2202902910, 2558366468, 1701182712, 283197682,  1865942385, 2027648778,
            2285857699, 880475184,  958651279,  169534250,  3842420528, 1568559789, 2986618464,
            2568345525, 3081082692,
        },
        {
            1051073388, 1151349403, 2145378500, 2613821393, 3985140699, 846475323,  3355767118,
            3729689247, 946717060,  2250136456, 3440432805, 1813081720, 3274558762, 3807349737,
            2126760608, 3550377068, 3349632041, 1044867179, 3619829336, 2705714056, 1944745139,
            1564770590, 1392552921, 2182042639, 336564549,  1642969832, 2472473442, 175172389,
            4238888518, 4209093185, 1634025008, 1683494128, 577633438,  1681389426, 4238149258,
            2987769733, 2258811008, 1623756293, 2913647508, 1657038168, 1374677443, 2939592135,
            1726059455, 238404847,  4248912483, 1793744429, 385988605,  1718116059, 2125514094,
            2220711137, 1116693005, 9204954,    2262864793, 3904186366, 2212738442, 857221041,
            547441376,  1126246758, 3262671714, 1820719026, 3896015688, 3116682222, 4218400026,
            2726211261, 4074579134, 2271689554, 1653414521, 1834615774, 1964270574, 515636892,
            2951168752, 372091575,  1012392048, 1206620752, 2195481952, 3937080964, 1892372450,
            1441462280, 2863026032, 2071488798, 2609277202, 1257648988, 863660951,  1247066837,
            1161879784, 866433120,  1349694719, 95737764,   2235114772, 4091335185, 1654262973,
            2317398479, 1802126478, 1785530379, 2348217530, 4191359747, 2199600166, 2424453568,
            3997571976, 2653545147, 3765076443, 4200914493, 3562535546, 942591701,  2127076988,
            4205865078, 3511800058, 729035742,  81585972,   1544048851, 708625626,  2924865712,
            1036971348, 399672950,  37819866,   2644811000, 1742681389, 214287546,  1689263611,
            3807475184, 2725262970, 746949896,  2885694640, 1195637113, 92959524,   289555983,
            579883432,  2430443579, 1151920126, 1167369721, 3920340803, 2446341134, 3443038943,
            4232177535, 3901223451, 3880419276, 4038494214, 3902751166, 776974333,  253334884,
            580717855,  4069932504, 1483133069, 490827092,  3275314747, 3376019012, 3614456165,
            2757942873, 3875973969, 2705353930, 2967092160, 978537244,  177515172,  941615295,
            1106205439, 3770593339, 3759095868, 3079698503, 3509552730, 2936989086, 2652905272,
            1051073388, 1151349403, 2145378500, 2613821393, 323529477,  846475323,  3355767118,
            3729689247, 946717060,  3191638163, 3440432805, 1813081720, 3274558762, 3807349737,
            3410987669, 3550377068, 3349632041, 1044867179, 3619829336, 3172388679, 1944745139,
            1564770590, 1392552921, 2182042639, 1347472612, 1642969832, 2472473442, 175172389,
            4238888518, 1592830047, 1634025008, 1683494128, 577633438,  1681389426, 3282664954,
            2987769733, 2258811008, 1623756293, 2913647508, 3223301359, 1374677443, 2939592135,
            1726059455, 238404847,  206328187,  1793744429, 385988605,  1718116059, 2125514094,
            2147711503, 1116693005, 9204954,    2262864793, 3904186366, 1626179519, 857221041,
            547441376,  1126246758, 3262671714, 3908665195, 3896015688, 3116682222, 4218400026,
            2726211261, 316715533,  2271689554, 1653414521, 1834615774, 1964270574, 1952641727,
            2951168752, 372091575,  1012392048, 1206620752, 555860194,  3937080964, 1892372450,
            1441462280, 2863026032, 2017181110, 2609277202, 1257648988, 863660951,  1247066837,
            440539907,  866433120,  1349694719, 95737764,   2235114772, 828470886,  1654262973,
            2317398479, 1802126478, 1785530379, 2773592596, 4191359747, 2199600166, 2424453568,
            3997571976, 2595038137, 3765076443, 4200914493, 3562535546, 942591701,  255350299,
            4205865078, 3511800058, 729035742,  81585972,   750292911,  708625626,  2924865712,
            1036971348, 399672950,  1358925534, 2644811000, 1742681389, 214287546,  1689263611,
            3681652892, 2725262970, 746949896,  2885694640, 1195637113, 4173231844, 289555983,
            579883432,  2430443579, 1151920126, 2500493808, 3920340803, 2446341134, 3443038943,
            4232177535, 2585565779, 3880419276, 4038494214, 3902751166, 776974333,  131191172,
            580717855,  4069932504, 1483133069, 490827092,  3677345889, 3376019012, 3614456165,
            2757942873, 3875973969, 2326689258, 2967092160, 978537244,  177515172,  941615295,
            799067727,  3770593339, 3759095868, 3079698503, 3509552730, 170748867,  2652905272,
            1051073388, 1151349403, 2145378500, 30126817,   323529477,  846475323,  3355767118,
            3729689247, 227668011,  3191638163, 3440432805, 1813081720, 3274558762, 98079572,
            3410987669, 3550377068, 3349632041, 1044867179, 2161050024, 3172388679, 1944745139,
            1564770590, 1392552921, 1063784126, 1347472612, 1642969832, 2472473442, 175172389,
            718235642,  1592830047, 1634025008, 1683494128, 577633438,  1439887513, 3282664954,
            2987769733, 2258811008, 1623756293, 3459679530, 3223301359, 1374677443, 2939592135,
            1726059455, 579921923,  206328187,  1793744429, 385988605,  1718116059, 3438675419,
            2147711503, 1116693005, 9204954,    2262864793, 1917992165, 1626179519, 857221041,
            547441376,  1126246758, 1216834353, 3908665195, 3896015688, 3116682222, 4218400026,
            2621979199, 316715533,  2271689554, 1653414521, 1834615774, 3144145535, 1952641727,
            2951168752, 372091575,  1012392048, 2139012575, 555860194,  3937080964, 1892372450,
            1441462280, 933221159,  2017181110, 2609277202, 1257648988, 863660951,  1593810879,
            440539907,  866433120,  1349694719, 95737764,   3186044969, 828470886,  1654262973,
            2317398479, 1802126478, 3897482592, 2773592596, 4191359747, 2199600166, 2424453568,
            2035782660, 2595038137, 3765076443, 4200914493, 3562535546, 1820817746, 255350299,
            4205865078, 3511800058, 729035742,  1122714855, 750292911,  708625626,  2924865712,
            1036971348, 2954844236, 1358925534, 2644811000, 1742681389, 214287546,  513408262,
            3681652892, 2725262970, 746949896,  2885694640, 1598618857, 4173231844, 289555983,
            579883432,  2430443579, 2178531391, 2500493808, 3920340803, 2446341134, 3443038943,
            4226094804, 2585565779, 3880419276, 4038494214, 3902751166, 1412742150, 131191172,
            580717855,  4069932504, 1483133069, 63573152,   3677345889, 3376019012, 3614456165,
            2757942873, 2701166174, 2326689258, 2967092160, 978537244,  177515172,  3296031971,
            799067727,  3770593339, 3759095868, 3079698503, 3930395182, 170748867,  2652905272,
            1051073388, 1151349403, 2765036940, 30126817,   323529477,  846475323,  3355767118,
            779628632,  227668011,  3191638163, 3440432805, 1813081720, 2878769240, 98079572,
            3410987669, 3550377068, 3349632041, 1583554894, 2161050024, 3172388679, 1944745139,
            1564770590, 2063543886, 1063784126, 1347472612, 1642969832, 2472473442, 19212514,
            718235642,  1592830047, 1634025008, 1683494128, 1660992342, 1439887513, 3282664954,
            2987769733, 2258811008, 3725705631, 3459679530, 3223301359, 1374677443, 2939592135,
            3425146813, 579921923,  206328187,  1793744429, 385988605,  1657937451, 3438675419,
            2147711503, 1116693005, 9204954,    3768911357, 1917992165, 1626179519, 857221041,
            547441376,  1562091535, 1216834353, 3908665195, 3896015688, 3116682222, 3610373745,
            2621979199, 316715533,  2271689554, 1653414521, 892004059,  3144145535, 1952641727,
            2951168752, 372091575,  526013357,  2139012575, 555860194,  3937080964, 1892372450,
            1534841035, 933221159,  2017181110, 2609277202, 1257648988, 4075021131, 1593810879,
            440539907,  866433120,  1349694719, 844485516,  3186044969, 828470886,  1654262973,
            2317398479, 3570597373, 3897482592, 2773592596, 4191359747, 2199600166, 1612905969,
            2035782660, 2595038137, 3765076443, 4200914493, 2215869135, 1820817746, 255350299,
            4205865078, 3511800058, 3898001487, 1122714855, 750292911,  708625626,  2924865712,
            237797019,  2954844236, 1358925534, 2644811000, 1742681389, 4190483850, 513408262,
            3681652892, 2725262970, 746949896,  1840023358, 1598618857, 4173231844, 289555983,
            579883432,  4286088409, 2178531391, 2500493808, 3920340803, 2446341134, 229266336,
            4226094804, 2585565779, 3880419276, 4038494214, 1733876163, 1412742150, 131191172,
            580717855,  4069932504, 3488864634, 63573152,   3677345889, 3376019012, 3614456165,
            1762934751, 2701166174, 2326689258, 2967092160, 978537244,  4051230430, 3296031971,
            799067727,  3770593339, 3759095868, 1946987026, 1106454655, 4148678274, 2869797513,
            3776985668, 816617609,  1043122363, 1821143379, 1183172946, 2269006582, 4171786695,
            3764535844, 1424077015, 3231421146, 603909537,  3491312932, 1552969674, 767919343,
            1406153633, 3588413607, 3753545795, 3164179774, 3261756211, 1955300257, 3987937121,
            2857323966, 1399524105, 960566020,  4090475423, 4268269011, 917642171,  3104965336,
            709274270,  779463134,  410591410,  656396982,  1955428465, 3042590171, 1437376362,
            3047905006, 1027619891, 4265410469, 200753109,  3939688563, 3196693499, 2212194553,
            1430394547, 2598268031, 1816827044, 4105342241, 2391093633, 3113996220, 1522772767,
            1466546012, 2934552623, 814879121,  2483402035, 593485643,  1376941569, 2944384077,
            493683209,  1006454106, 557478729,  95724107,   295466806,  448719351,  3977024207,
            4208503200, 4061284264, 3110056612, 1439490070, 799957368,  2376689228, 3138350462,
            427520009,  1144168799, 3305658013, 295710453,  3463835133, 2457940015, 2072766300,
            1379949858, 3430395497, 4228951605, 2388229907, 545494345,  2342256976, 438983685,
            3425357406, 3544564903, 1330145205, 425778507,  1120205197, 227762055,  1079689746,
            2657133679, 2882979255, 4277404650, 3059731286, 2811909642, 1924164277, 2846367852,
            1214037482, 3922704436, 14344689,   1509717842, 3477717738, 3426912600, 751547033,
            499871394,  1685940594, 3863155951, 2117521516, 794005800,  1780617735, 3781467173,
            3177978685, 3992609448, 3893792351, 817351450,  3141187368, 2560821634, 993928807,
            159373342,  1173246213, 312921975,  1871459040, 4021382618, 3417355341, 3714221392,
            1785247186, 3667820644, 2111688427, 1867335669, 2345835954, 1378154883, 3767083481,
            1427333673, 1158011325, 132467193,  3663465248, 3171209955, 3912265445, 4007772001,
            3430724222, 277248681,  3749028819, 3703549811, 126908178,  3467215190, 1334751599,
            647663280,  2275018990, 221543684,  3186509508, 3204942842, 1316967716, 2315919815,
            2779443080, 1158963123,
        },
        {
            575494427,  2773243709, 4009191487, 3877909663, 2252044261, 1328043370, 1407136778,
            3204434425, 3881653592, 1481049819, 2939203697, 889352935,  628666312,  165199023,
            2949092155, 1116804589, 998930334,  4144153491, 4191022348, 9022505,    4033326555,
            2329569601, 824756145,  3501916851, 1481410328, 1970954319, 4022176157, 2356841052,
            3783173734, 3649102345, 3205430658, 1460938436, 280282398,  3262135457, 4055383786,
            28522973,   1100901182, 4048609665, 994490185,  2888527367, 3591919750, 65093467,
            399797207,  3377740861, 3103183487, 3696509979, 866353724,  3847992271, 2821933890,
            1491144079, 1702442928, 1271285504, 636444475,  2465430290, 2440306765, 2651443172,
            2895101023, 43843628,   518479547,  3708355608, 2313400729, 3786408564, 2823763904,
            3267560272, 524168411,  2580824843, 2687886610, 785942949,  2624395631, 3713348903,
            4104123478, 2234056629, 2683158959, 1805382347, 1645702909, 382688861,  2843792951,
            39122499,   2765954033, 3033237617, 784228054,  1680611136, 2306036746, 892707919,
            3825738103, 1289362844, 3462989616, 484526950,  178560970,  1863413515, 71290794,
            1716785670, 3881310302, 2826977504, 2312744076, 1000001815, 1580868938, 3808984884,
            2521899773, 738699928,  2244576791, 1833964269, 1361345793, 2934763305, 2944705940,
            2334116476, 674208214,  587191877,  271361277,  1639419136, 2742744205, 2556530506,
            3764115510, 861410771,  3473658359, 2879790483, 1497452846, 1101855458, 2268199923,
            1766359872, 480532790,  2926891626, 1366888524, 2262816900, 620045088,  2279182738,
            2479688463, 427385986,  271096497,  1999040724, 1980388138, 3104550456, 2496325717,
            2941450111, 1784373495, 4020221165, 2567325850, 2636190539, 2764516078, 2285887821,
            2395930109, 1867061176, 665795763,  3869868300, 4033135159, 2589983679, 682593183,
            1254600537, 1701095863, 3738080583, 369734429,  2231641462, 1866531599, 1317004965,
            466053171,  2320346625, 485850108,  1279183025, 423884362,  1878291714, 228799661,
            575494427,  2773243709, 4009191487, 3877909663, 1392246100, 1328043370, 1407136778,
            3204434425, 3881653592, 303018213,  2939203697, 889352935,  628666312,  165199023,
            691563049,  1116804589, 998930334,  4144153491, 4191022348, 2882458100, 4033326555,
            2329569601, 824756145,  3501916851, 3512382126, 1970954319, 4022176157, 2356841052,
            3783173734, 3277915742, 3205430658, 1460938436, 280282398,  3262135457, 416160861,
            28522973,   1100901182, 4048609665, 994490185,  2206150488, 3591919750, 65093467,
            399797207,  3377740861, 3954301001, 3696509979, 866353724,  3847992271, 2821933890,
            482325742,  1702442928, 1271285504, 636444475,  2465430290, 476965483,  2651443172,
            2895101023, 43843628,   518479547,  2354104222, 2313400729, 3786408564, 2823763904,
            3267560272, 1682576095, 2580824843, 2687886610, 785942949,  2624395631, 3219885224,
            4104123478, 2234056629, 2683158959, 1805382347, 4143809855, 382688861,  2843792951,
            39122499,   2765954033, 2870716981, 784228054,  1680611136, 2306036746, 892707919,
            2648492467, 1289362844, 3462989616, 484526950,  178560970,  3047404165, 71290794,
            1716785670, 3881310302, 2826977504, 2439325884, 1000001815, 1580868938, 3808984884,
            2521899773, 2222792732, 2244576791, 1833964269, 1361345793, 2934763305, 655108124,
            2334116476, 674208214,  587191877,  271361277,  1403491312, 2742744205, 2556530506,
            3764115510, 861410771,  2748819627, 2879790483, 1497452846, 1101855458, 2268199923,
            2646753562, 480532790,  2926891626, 1366888524, 2262816900, 691077353,  2279182738,
            2479688463, 427385986,  271096497,  357444234,  1980388138, 3104550456, 2496325717,
            2941450111, 717953620,  4020221165, 2567325850, 2636190539, 2764516078, 588189150,
            2395930109, 1867061176, 665795763,  3869868300, 2245339306, 2589983679, 682593183,
            1254600537, 1701095863, 3193417815, 369734429,  2231641462, 1866531599, 1317004965,
            1295326133, 2320346625, 485850108,  1279183025, 423884362,  1310342080, 228799661,
            575494427,  2773243709, 4009191487, 3178129190, 1392246100, 1328043370, 1407136778,
            3204434425, 558594993,  303018213,  2939203697, 889352935,  628666312,  3995857198,
            691563049,  1116804589, 998930334,  4144153491, 2375099047, 2882458100, 4033326555,
            2329569601, 824756145,  3031828205, 3512382126, 1970954319, 4022176157, 2356841052,
            1599294097, 3277915742, 3205430658, 1460938436, 280282398,  2438973535, 416160861,
            28522973,   1100901182, 4048609665, 2989609671, 2206150488, 3591919750, 65093467,
            399797207,  183644195,  3954301001, 3696509979, 866353724,  3847992271, 1244421011,
            482325742,  1702442928, 1271285504, 636444475,  3659422961, 476965483,  2651443172,
            2895101023, 43843628,   2230230933, 2354104222, 2313400729, 3786408564, 2823763904,
            4146329709, 1682576095, 2580824843, 2687886610, 785942949,  126345381,  3219885224,
            4104123478, 2234056629, 2683158959, 1734650983, 4143809855, 382688861,  2843792951,
            39122499,   3527484969, 2870716981, 784228054,  1680611136, 2306036746, 1606477743,
            2648492467, 1289362844, 3462989616, 484526950,  3730796296, 3047404165, 71290794,
            1716785670, 3881310302, 4233965062, 2439325884, 1000001815, 1580868938, 3808984884,
            1228341642, 2222792732, 2244576791, 1833964269, 1361345793, 3313812192, 655108124,
            2334116476, 674208214,  587191877,  1531247446, 1403491312, 2742744205, 2556530506,
            3764115510, 2419989900, 2748819627, 2879790483, 1497452846, 1101855458, 1430402656,
            2646753562, 480532790,  2926891626, 1366888524, 1848714433, 691077353,  2279182738,
            2479688463, 427385986,  3906690631, 357444234,  1980388138, 3104550456, 2496325717,
            2272350403, 717953620,  4020221165, 2567325850, 2636190539, 1950604113, 588189150,
            2395930109, 1867061176, 665795763,  1735147895, 2245339306, 2589983679, 682593183,
            1254600537, 1518037357, 3193417815, 369734429,  2231641462, 1866531599, 1751783137,
            1295326133, 2320346625, 485850108,  1279183025, 149835864,  1310342080, 228799661,
            575494427,  2773243709, 1505829825, 3178129190, 1392246100, 1328043370, 1407136778,
            856233019,  558594993,  303018213,  2939203697, 889352935,  625515593,  3995857198,
            691563049,  1116804589, 998930334,  3264640128, 2375099047, 2882458100, 4033326555,
            2329569601, 1824812377, 3031828205, 3512382126, 1970954319, 4022176157, 3682468973,
            1599294097, 3277915742, 3205430658, 1460938436, 2034940270, 2438973535, 416160861,
            28522973,   1100901182, 3534874298, 2989609671, 2206150488, 3591919750, 65093467,
            2231373121, 183644195,  3954301001, 3696509979, 866353724,  1479968372, 1244421011,
            482325742,  1702442928, 1271285504, 3834022401, 3659422961, 476965483,  2651443172,
            2895101023, 1042443120, 2230230933, 2354104222, 2313400729, 3786408564, 2940290545,
            4146329709, 1682576095, 2580824843, 2687886610, 895602439,  126345381,  3219885224,
            4104123478, 2234056629, 3633565082, 1734650983, 4143809855, 382688861,  2843792951,
            3076342354, 3527484969, 2870716981, 784228054,  1680611136, 3667923304, 1606477743,
            2648492467, 1289362844, 3462989616, 1338592032, 3730796296, 3047404165, 71290794,
            1716785670, 995728648,  4233965062, 2439325884, 1000001815, 1580868938, 1245957136,
            1228341642, 2222792732, 2244576791, 1833964269, 2899552190, 3313812192, 655108124,
            2334116476, 674208214,  1154789946, 1531247446, 1403491312, 2742744205, 2556530506,
            1668620496, 2419989900, 2748819627, 2879790483, 1497452846, 177853954,  1430402656,
            2646753562, 480532790,  2926891626, 3179057526, 1848714433, 691077353,  2279182738,
            2479688463, 1988854710, 3906690631, 357444234,  1980388138, 3104550456, 1772857305,
            2272350403, 717953620,  4020221165, 2567325850, 3129906484, 1950604113, 588189150,
            2395930109, 1867061176, 2248975336, 1735147895, 2245339306, 2589983679, 682593183,
            3087155398, 1518037357, 3193417815, 369734429,  2231641462, 1858424931, 1751783137,
            1295326133, 2320346625, 485850108,  2471611230, 107369761,  2623559579, 4256589070,
            2365810185, 907910243,  3901832478, 2068079364, 2072842987, 401440347,  1707255913,
            1450112231, 2618898012, 600446000,  788321632,  4119629235, 2648781584, 1927659116,
            171372782,  1789511950, 2648296999, 3558619514, 1819608632, 1392007708, 2918513974,
            2270003900, 784021820,  1379044539, 591935962,  1638390839, 10832053,   3946625290,
            2916913801, 2718331169, 1595482738, 1294279402, 19889234,   1374364843, 571354125,
            3357938719, 2337506269, 905453029,  2504232400, 258673393,  2590342355, 3308443353,
            3359617898, 2686453711, 932545954,  509832408,  820508114,  431186194,  3434866166,
            1108455121, 2802986572, 893446102,  3248197798, 1797985531, 3952804303, 558601278,
            1813674114, 311050994,  425175161,  1125527204, 1597986581, 2282580210, 1659733126,
            2080660004, 4121079137, 3373787661, 1902252724, 2669993847, 2450915273, 2155525933,
            2139535914, 274595185,  1890506924, 2631794527, 1423530517, 4027031002, 1085427968,
            2402514206, 3591455043, 2513094696, 2338347202, 1168222597, 3922339535, 3991725466,
            2774598759, 3478721168, 3676766916, 179748891,  2911159372, 191101265,  3389843262,
            3093358663, 2333576084, 1056514165, 2987497874, 2502331872, 2027710028, 2338525812,
            3904906078, 806669884,  596300960,  1993055778, 1541809402, 3578865742, 652348267,
            3332532764, 2656602623, 2037214047, 323260312,  3310408133, 4037617529, 137297627,
            1236501991, 495817051,  481150309,  3067841968, 3120347176, 714354848,  1554632062,
            2522324107, 4274051212, 2180914534, 1261686356, 3569290041, 1801431819, 4286755560,
            2749452442, 829235089,  2243153325, 2525168177, 1486881882, 585653228,  3288336688,
            2734161045, 30430534,   714492313,  2582732426, 595577790,  1463554287, 1949506865,
            4210942156, 2008105540, 4055753132, 2530320603, 319064177,  2305067982, 3825716413,
            1543867515, 108979478,  3089716545, 2921391708, 2403595525, 3783697766, 2313991047,
            3302598706, 1318323763,
        },
        {
            2555691373, 2580587911, 1891682880, 4262413155, 3369246487, 731015048,  1194693249,
            3815169866, 2248423825, 2925784033, 3237183825, 2344496216, 2528089920, 1876327038,
            2241073795, 2161606855, 4260641513, 2088654583, 1001188788, 3083551478, 2867398338,
            2245574199, 4251540694, 95136115,   2976631131, 2915520979, 4105314978, 2941074736,
            1660722396, 2003628896, 2935797971, 3910112607, 1633197992, 1373320841, 3153210444,
            1468916186, 2255631323, 1778137431, 3896487180, 1556999846, 973536158,  3840770807,
            4220926741, 4148439049, 3510831777, 3374433587, 2091529194, 3206364568, 447721213,
            3557939180, 1148837152, 4095266728, 3767727776, 694789681,  3468259825, 1520666562,
            2050244231, 4039742940, 29749364,   1692251088, 733598751,  1278794601, 1391093704,
            2819285248, 1139737151, 2070997130, 2787586135, 2015912206, 3907679418, 2893324310,
            1714711828, 237275356,  1502707195, 981500406,  4190275047, 2294812381, 1072291748,
            1262645592, 1736430940, 1703206040, 4180002891, 3676758400, 3185677899, 2459090929,
            320579247,  3390227786, 1466992553, 3308365287, 920305873,  98672859,   3227664730,
            1825327987, 3541685028, 2024570092, 2731973599, 4233260386, 1228552634, 2253344992,
            3982432330, 3421150518, 1412127655, 2933511849, 4158368428, 131064813,  2781137619,
            1491672342, 3240432761, 32796214,   1804944094, 742249246,  1567485648, 2063786039,
            824322687,  3861551544, 853667805,  2383142263, 555705496,  506343382,  4074250973,
            1500216315, 335194865,  2684916830, 3742840842, 3313007986, 2950451307, 1221987725,
            2513637509, 2991626162, 1860201499, 3176471062, 3866016843, 4095595431, 263551313,
            3628052025, 803288938,  3048673317, 530585272,  3505765105, 3934610142, 4166600078,
            1423652033, 637785640,  1160876260, 3010063938, 1283691196, 2477426925, 2168549059,
            84336539,   1585809620, 154989586,  3888034052, 2587023718, 474719317,  2790689245,
            2532919385, 766029687,  1096577196, 179867290,  3432413893, 1664070070, 2548074447,
            2555691373, 2580587911, 1891682880, 4262413155, 894421973,  731015048,  1194693249,
            3815169866, 2248423825, 3262927196, 3237183825, 2344496216, 2528089920, 1876327038,
            3679077170, 2161606855, 4260641513, 2088654583, 1001188788, 1210178549, 2867398338,
            2245574199, 4251540694, 95136115,   311656890,  2915520979, 4105314978, 2941074736,
            1660722396, 2395461692, 2935797971, 3910112607, 1633197992, 1373320841, 389365383,
            1468916186, 2255631323, 1778137431, 3896487180, 1045877983, 973536158,  3840770807,
            4220926741, 4148439049, 699003340,  3374433587, 2091529194, 3206364568, 447721213,
            647894591,  1148837152, 4095266728, 3767727776, 694789681,  3962660122, 1520666562,
            2050244231, 4039742940, 29749364,   3781235729, 733598751,  1278794601, 1391093704,
            2819285248, 1387871226, 2070997130, 2787586135, 2015912206, 3907679418, 766336652,
            1714711828, 237275356,  1502707195, 981500406,  630917530,  2294812381, 1072291748,
            1262645592, 1736430940, 3039526242, 4180002891, 3676758400, 3185677899, 2459090929,
            995872967,  3390227786, 1466992553, 3308365287, 920305873,  4081420011, 3227664730,
            1825327987, 3541685028, 2024570092, 1097160133, 4233260386, 1228552634, 2253344992,
            3982432330, 1561764936, 1412127655, 2933511849, 4158368428, 131064813,  2286232362,
            1491672342, 3240432761, 32796214,   1804944094, 3179163516, 1567485648, 2063786039,
            824322687,  3861551544, 1691971650, 2383142263, 555705496,  506343382,  4074250973,
            282347500,  335194865,  2684916830, 3742840842, 3313007986, 280943497,  1221987725,
            2513637509, 2991626162, 1860201499, 3917681406, 3866016843, 4095595431, 263551313,
            3628052025, 3093405205, 3048673317, 530585272,  3505765105, 3934610142, 2669021943,
            1423652033, 637785640,  1160876260, 3010063938, 3149119319, 2477426925, 2168549059,
            84336539,   1585809620, 1012337061, 3888034052, 2587023718, 474719317,  2790689245,
            677215617,  766029687,  1096577196, 179867290,  3432413893, 2875666219, 2548074447,
            2555691373, 2580587911, 1891682880, 1051633630, 894421973,  731015048,  1194693249,
            3815169866, 1805251976, 3262927196, 3237183825, 2344496216, 2528089920, 1718685675,
            3679077170, 2161606855, 4260641513, 2088654583, 493412265,  1210178549, 2867398338,
            2245574199, 4251540694, 332721018,  311656890,  2915520979, 4105314978, 2941074736,
            442607436,  2395461692, 2935797971, 3910112607, 1633197992, 3301755934, 389365383,
            1468916186, 2255631323, 1778137431, 3161686447, 1045877983, 973536158,  3840770807,
            4220926741, 1021746729, 699003340,  3374433587, 2091529194, 3206364568, 2579702259,
            647894591,  1148837152, 4095266728, 3767727776, 2302415647, 3962660122, 1520666562,
            2050244231, 4039742940, 2522331189, 3781235729, 733598751,  1278794601, 1391093704,
            3249117786, 1387871226, 2070997130, 2787586135, 2015912206, 2335277347, 766336652,
            1714711828, 237275356,  1502707195, 1825016933, 630917530,  2294812381, 1072291748,
            1262645592, 2351784952, 3039526242, 4180002891, 3676758400, 3185677899, 3010719144,
            995872967,  3390227786, 1466992553, 3308365287, 2709915957, 4081420011, 3227664730,
            1825327987, 3541685028, 72286930,   1097160133, 4233260386, 1228552634, 2253344992,
            1669628211, 1561764936, 1412127655, 2933511849, 4158368428, 3914267551, 2286232362,
            1491672342, 3240432761, 32796214,   1454687012, 3179163516, 1567485648, 2063786039,
            824322687,  79917854,   1691971650, 2383142263, 555705496,  506343382,  2268789855,
            282347500,  335194865,  2684916830, 3742840842, 2316540409, 280943497,  1221987725,
            2513637509, 2991626162, 3495703178, 3917681406, 3866016843, 4095595431, 263551313,
            380904465,  3093405205, 3048673317, 530585272,  3505765105, 2083772887, 2669021943,
            1423652033, 637785640,  1160876260, 125519940,  3149119319, 2477426925, 2168549059,
            84336539,   584523680,  1012337061, 3888034052, 2587023718, 474719317,  3816989627,
            677215617,  766029687,  1096577196, 179867290,  626946340,  2875666219, 2548074447,
            2555691373, 2580587911, 1542990091, 1051633630, 894421973,  731015048,  1194693249,
            2983783946, 1805251976, 3262927196, 3237183825, 2344496216, 996186210,  1718685675,
            3679077170, 2161606855, 4260641513, 3602383014, 493412265,  1210178549, 2867398338,
            2245574199, 3227260632, 332721018,  311656890,  2915520979, 4105314978, 181510756,
            442607436,  2395461692, 2935797971, 3910112607, 1618637125, 3301755934, 389365383,
            1468916186, 2255631323, 1062072818, 3161686447, 1045877983, 973536158,  3840770807,
            111493208,  1021746729, 699003340,  3374433587, 2091529194, 1006829258, 2579702259,
            647894591,  1148837152, 4095266728, 524615348,  2302415647, 3962660122, 1520666562,
            2050244231, 2432120025, 2522331189, 3781235729, 733598751,  1278794601, 1984260486,
            3249117786, 1387871226, 2070997130, 2787586135, 1888056603, 2335277347, 766336652,
            1714711828, 237275356,  2906822160, 1825016933, 630917530,  2294812381, 1072291748,
            2518621643, 2351784952, 3039526242, 4180002891, 3676758400, 2211078050, 3010719144,
            995872967,  3390227786, 1466992553, 3958628942, 2709915957, 4081420011, 3227664730,
            1825327987, 988928071,  72286930,   1097160133, 4233260386, 1228552634, 3164760169,
            1669628211, 1561764936, 1412127655, 2933511849, 2494216763, 3914267551, 2286232362,
            1491672342, 3240432761, 1207656671, 1454687012, 3179163516, 1567485648, 2063786039,
            3519982434, 79917854,   1691971650, 2383142263, 555705496,  571354224,  2268789855,
            282347500,  335194865,  2684916830, 3978796465, 2316540409, 280943497,  1221987725,
            2513637509, 3089494871, 3495703178, 3917681406, 3866016843, 4095595431, 378941702,
            380904465,  3093405205, 3048673317, 530585272,  3449651973, 2083772887, 2669021943,
            1423652033, 637785640,  2790879007, 125519940,  3149119319, 2477426925, 2168549059,
            442163563,  584523680,  1012337061, 3888034052, 2587023718, 4159139906, 3816989627,
            677215617,  766029687,  1096577196, 3924724945, 1393846165, 1102507676, 3281653765,
            2852884760, 1883122006, 601140693,  3216616959, 189304594,  758311973,  923515863,
            3232920223, 968725614,  2771084531, 116702058,  627388936,  652029855,  2825170291,
            3899517287, 1279877099, 2678364768, 3116738082, 365721942,  4056236144, 1305920552,
            135441800,  2730731508, 2176772408, 233309375,  541701588,  1180772162, 2459308921,
            1592435137, 1663852232, 2880333214, 953714165,  3905457415, 2604861222, 619918923,
            1294288839, 4040768740, 2975924445, 2888360659, 385516186,  2422356415, 1787632804,
            816424374,  2663738429, 2154225848, 3994252508, 3727070815, 3592230388, 3003197237,
            1719567237, 2883747593, 2959767991, 3074901567, 2827292650, 1046188118, 253076019,
            2130038219, 2704958369, 2223289494, 3164487867, 3086978400, 1552021834, 2458539938,
            923434313,  2807320919, 233804477,  876182881,  4242477874, 4091654799, 2313494956,
            1892576096, 409583932,  2533251786, 2062547622, 1810740647, 805254617,  1329109683,
            3018419970, 3648774204, 551033284,  2417610402, 3092170606, 1680453809, 3269924836,
            3519753056, 2755433135, 3094289224, 2215583902, 1470746031, 2669619160, 1234917527,
            601165286,  2161519625, 882460315,  3436875427, 3800977825, 1791944826, 3871337670,
            1284015258, 1239686957, 1067569025, 1605183613, 364727037,  678947907,  3219487877,
            2925409926, 3616790936, 1914758148, 1005808796, 384187925,  1340384429, 2582837672,
            2952816704, 3106315773, 3523654240, 482340875,  819162325,  3384011119, 1484406783,
            577669899,  3292715029, 3736787131, 3565444385, 534229996,  1230133013, 4228700863,
            3796393283, 526863292,  2422963701, 74413160,   2748439269, 4164696714, 233146019,
            268001247,  1085447964, 712158318,  3681462730, 385034959,  1791030040, 4124506607,
            2702036270, 3877181483, 1094743860, 1178287984, 4253581351, 1847724234, 1158342056,
            1599079619, 2106006371, 1104155334, 2792268738, 3813641519, 346619245,  4146749142,
            3749126999, 4074736672,
        },
        {
            1470380360, 3057428612, 2756676297, 1633786556, 4246459918, 2557524017, 1857180133,
            618903690,  2475611092, 2621430634, 2084292404, 1698607774, 1788956972, 3375072220,
            1499167056, 1218814632, 3699503479, 588281768,  3603925285, 1187721841, 1307962320,
            2562217840, 3882506958, 2387033730, 2097027049, 1593669125, 1899433035, 4039983902,
            1546854551, 1073191673, 3368453769, 3074694838, 534637095,  1860006723, 3416402670,
            802354899,  3998709605, 3944315555, 3454226397, 1648185195, 488532673,  3063734121,
            1318974867, 187087202,  200160693,  4170479404, 782764886,  4007973657, 1651636372,
            3084151528, 2085263921, 2424937940, 230704223,  3342587983, 1093085714, 683877298,
            3635026316, 3839461209, 2977567556, 3947448199, 3767172681, 1350679624, 3541409523,
            3975162472, 2459379316, 3287828387, 1565768431, 3149625429, 1328627497, 2156355750,
            112739894,  4052025045, 1396839113, 212349044,  110706825,  2185320852, 2540909191,
            2129623107, 3515174750, 2669147508, 1243549180, 3996575850, 149304348,  2755670869,
            930137412,  350687475,  1512442864, 3764389325, 3489308665, 276147411,  2268414314,
            30674096,   3202650841, 3446821592, 3341145621, 3749209259, 674361204,  1384681012,
            2716655878, 454169262,  289282175,  966029495,  3052791893, 3111969089, 1151599976,
            3620936019, 1877909034, 1953262994, 4240669039, 1857402256, 3337397349, 2392730459,
            1158928694, 1757447952, 2682284750, 2796982914, 1203210173, 797579212,  1645601877,
            3579805998, 797556690,  4106236617, 1379943929, 129105346,  3950170317, 723231430,
            88997404,   2591283275, 359831168,  306903531,  1987846974, 2654779951, 3724360049,
            1693615498, 1095306415, 3586751806, 2045807380, 2779363615, 2912940562, 1557518560,
            3620536996, 1723152132, 4087191232, 1042907094, 3210303305, 1536493323, 4094765090,
            575328723,  359319532,  2458971265, 3159207510, 387883436,  2521400838, 2359639886,
            261289463,  2094643916, 2269112547, 2387198764, 3619233779, 3019052785, 2910774311,
            1470380360, 3057428612, 2756676297, 1633786556, 386502519,  2557524017, 1857180133,
            618903690,  2475611092, 30080431,   2084292404, 1698607774, 1788956972, 3375072220,
            1158684464, 1218814632, 3699503479, 588281768,  3603925285, 238328161,  1307962320,
            2562217840, 3882506958, 2387033730, 3010587639, 1593669125, 1899433035, 4039983902,
            1546854551, 4192218972, 3368453769, 3074694838, 534637095,  1860006723, 652336168,
            802354899,  3998709605, 3944315555, 3454226397, 1926499185, 488532673,  3063734121,
            1318974867, 187087202,  1106075322, 4170479404, 782764886,  4007973657, 1651636372,
            2404132022, 2085263921, 2424937940, 230704223,  3342587983, 918664020,  683877298,
            3635026316, 3839461209, 2977567556, 1943458501, 3767172681, 1350679624, 3541409523,
            3975162472, 276593262,  3287828387, 1565768431, 3149625429, 1328627497, 1428675465,
            112739894,  4052025045, 1396839113, 212349044,  4056830215, 2185320852, 2540909191,
            2129623107, 3515174750, 1542171596, 1243549180, 3996575850, 149304348,  2755670869,
            3578672658, 350687475,  1512442864, 3764389325, 3489308665, 1546094236, 2268414314,
            30674096,   3202650841, 3446821592, 2954172575, 3749209259, 674361204,  1384681012,
            2716655878, 3784818668, 289282175,  966029495,  3052791893, 3111969089, 4157356036,
            3620936019, 1877909034, 1953262994, 4240669039, 558548232,  3337397349, 2392730459,
            1158928694, 1757447952, 2764253876, 2796982914, 1203210173, 797579212,  1645601877,
            1754284241, 797556690,  4106236617, 1379943929, 129105346,  1072954804, 723231430,
            88997404,   2591283275, 359831168,  3790749526, 1987846974, 2654779951, 3724360049,
            1693615498, 529478744,  3586751806, 2045807380, 2779363615, 2912940562, 3883779003,
            3620536996, 1723152132, 4087191232, 1042907094, 2510614710, 1536493323, 4094765090,
            575328723,  359319532,  4185709932, 3159207510, 387883436,  2521400838, 2359639886,
            143795416,  2094643916, 2269112547, 2387198764, 3619233779, 2856133500, 2910774311,
            1470380360, 3057428612, 2756676297, 1184346658, 386502519,  2557524017, 1857180133,
            618903690,  113530176,  30080431,   2084292404, 1698607774, 1788956972, 1446640841,
            1158684464, 1218814632, 3699503479, 588281768,  145530757,  238328161,  1307962320,
            2562217840, 3882506958, 2145494995, 3010587639, 1593669125, 1899433035, 4039983902,
            1668183055, 4192218972, 3368453769, 3074694838, 534637095,  1759744354, 652336168,
            802354899,  3998709605, 3944315555, 3058692249, 1926499185, 488532673,  3063734121,
            1318974867, 728549366,  1106075322, 4170479404, 782764886,  4007973657, 3270440405,
            2404132022, 2085263921, 2424937940, 230704223,  3329510499, 918664020,  683877298,
            3635026316, 3839461209, 79335966,   1943458501, 3767172681, 1350679624, 3541409523,
            925084463,  276593262,  3287828387, 1565768431, 3149625429, 3775346659, 1428675465,
            112739894,  4052025045, 1396839113, 865124022,  4056830215, 2185320852, 2540909191,
            2129623107, 408329043,  1542171596, 1243549180, 3996575850, 149304348,  3549625626,
            3578672658, 350687475,  1512442864, 3764389325, 2745315161, 1546094236, 2268414314,
            30674096,   3202650841, 1591955495, 2954172575, 3749209259, 674361204,  1384681012,
            4064148122, 3784818668, 289282175,  966029495,  3052791893, 1370867977, 4157356036,
            3620936019, 1877909034, 1953262994, 4021792514, 558548232,  3337397349, 2392730459,
            1158928694, 3155295174, 2764253876, 2796982914, 1203210173, 797579212,  3928348491,
            1754284241, 797556690,  4106236617, 1379943929, 535801204,  1072954804, 723231430,
            88997404,   2591283275, 3834650337, 3790749526, 1987846974, 2654779951, 3724360049,
            1042046499, 529478744,  3586751806, 2045807380, 2779363615, 1125934487, 3883779003,
            3620536996, 1723152132, 4087191232, 234512721,  2510614710, 1536493323, 4094765090,
            575328723,  3997395999, 4185709932, 3159207510, 387883436,  2521400838, 3125399953,
            143795416,  2094643916, 2269112547, 2387198764, 652167990,  2856133500, 2910774311,
            1470380360, 3057428612, 2132157457, 1184346658, 386502519,  2557524017, 1857180133,
            4131611047, 113530176,  30080431,   2084292404, 1698607774, 391246724,  1446640841,
            1158684464, 1218814632, 3699503479, 2411874184, 145530757,  238328161,  1307962320,
            2562217840, 2812151676, 2145494995, 3010587639, 1593669125, 1899433035, 2422208371,
            1668183055, 4192218972, 3368453769, 3074694838, 2148785858, 1759744354, 652336168,
            802354899,  3998709605, 1781938823, 3058692249, 1926499185, 488532673,  3063734121,
            3539633540, 728549366,  1106075322, 4170479404, 782764886,  2780824417, 3270440405,
            2404132022, 2085263921, 2424937940, 1908513596, 3329510499, 918664020,  683877298,
            3635026316, 2918953355, 79335966,   1943458501, 3767172681, 1350679624, 341369607,
            925084463,  276593262,  3287828387, 1565768431, 1957429498, 3775346659, 1428675465,
            112739894,  4052025045, 1847440090, 865124022,  4056830215, 2185320852, 2540909191,
            3477402775, 408329043,  1542171596, 1243549180, 3996575850, 179432054,  3549625626,
            3578672658, 350687475,  1512442864, 2118138924, 2745315161, 1546094236, 2268414314,
            30674096,   2317064191, 1591955495, 2954172575, 3749209259, 674361204,  3286542168,
            4064148122, 3784818668, 289282175,  966029495,  1327408800, 1370867977, 4157356036,
            3620936019, 1877909034, 405707683,  4021792514, 558548232,  3337397349, 2392730459,
            3244675609, 3155295174, 2764253876, 2796982914, 1203210173, 2274948223, 3928348491,
            1754284241, 797556690,  4106236617, 2665938417, 535801204,  1072954804, 723231430,
            88997404,   3006584290, 3834650337, 3790749526, 1987846974, 2654779951, 4271242910,
            1042046499, 529478744,  3586751806, 2045807380, 2283867237, 1125934487, 3883779003,
            3620536996, 1723152132, 1761178713, 234512721,  2510614710, 1536493323, 4094765090,
            2361030279, 3997395999, 4185709932, 3159207510, 387883436,  3979684113, 3125399953,
            143795416,  2094643916, 2269112547, 1499026790, 2673871071, 3817604600, 2996498142,
            1211396713, 4016438754, 992969238,  2196610884, 1333868752, 2722471337, 2178395143,
            533478044,  291720336,  3552502714, 1060260388, 1389737501, 3508724089, 3106493936,
            2013154532, 3169850047, 3773175439, 3604033115, 4234678017, 2903156223, 3832188501,
            2874956773, 4283805552, 3664062691, 1974738248, 925764827,  1750660924, 141239116,
            3273085573, 2427940522, 1962727892, 2493949152, 1043482688, 2345076260, 2209086707,
            3642865193, 3119873884, 571850463,  1599484831, 76923002,   3077572436, 4086821865,
            1523654720, 480304732,  476538774,  2169116383, 4033618691, 2819753414, 2856326003,
            747450871,  1851448547, 713503330,  3709263622, 781002495,  1968749577, 2933719965,
            4057398020, 3406593497, 689436820,  2935729647, 2030357428, 2075940397, 1830631914,
            1093330800, 1706624613, 1805612947, 4257097124, 3233604448, 159450674,  1050507045,
            566046625,  2253420120, 904902042,  1830037922, 4081490982, 1427186514, 2535536470,
            3869316947, 4097476542, 930420754,  2519255367, 49908928,   454325685,  888118139,
            3453892181, 1263601461, 1236190782, 674943665,  1648077470, 429399730,  2904879506,
            3718410520, 1802183310, 1872553091, 605480672,  774749173,  3200570514, 181210046,
            2560898144, 3947027625, 1535243167, 324801283,  4234744788, 746560316,  2456297875,
            3925756080, 533997731,  3919796086, 662975152,  864661066,  1070894403, 1020445801,
            1511298602, 4221508348, 3577952702, 4122306502, 2012051572, 1616168260, 2456901413,
            2717726537, 840264605,  2687215223, 2174960097, 1239122603, 2890231920, 3365350767,
            3998868598, 563137220,  893868530,  3400632172, 1538627830, 2812510298, 496662288,
            2317289974, 2252393722, 1221289032, 2418100559, 402670890,  1528570045, 3160531718,
            1806492066, 3211663975, 3617025598, 3664580463, 1338638297, 341637330,  2097019728,
            4031221207, 503636424,  3883416740, 1530237682, 1152125396, 2845384901, 332460372,
            457364876,  1738239808,
        },
        {
            3433397401, 3976673102, 3691522739, 1227093107, 762957774,  4086318816, 3834041114,
            2492127162, 3072736899, 773320917,  2254201538, 285195583,  3376614599, 911293448,
            3306516765, 3129245111, 3545136148, 1719781794, 3240626385, 758950643,  4050893306,
            1593902981, 2441131570, 3735445799, 5315723,    3471467548, 3272829390, 494131548,
            1002565,    3322186428, 3569452566, 3140603948, 2455110553, 3600720367, 3135748682,
            3648318018, 1180609498, 3406916390, 2638331009, 1369368625, 2197458475, 1727555926,
            1553864256, 2132071262, 1361179311, 2022378978, 2359524432, 156900063,  3230489867,
            912624298,  1228398315, 1472718426, 1330681578, 3899303695, 3192208807, 1385396548,
            312218186,  726916901,  58282118,   1764848645, 2341127947, 384446588,  4199708949,
            4076132786, 51884942,   3770317722, 3989982361, 73544798,   1883334443, 2811252334,
            540996900,  4201534770, 2279943861, 3762353033, 3892872677, 921289059,  1279431804,
            971742325,  3702586731, 2984952873, 116295830,  3092793381, 925195517,  1532786382,
            3126311045, 1727176377, 3389479429, 2146886998, 569788679,  153418133,  2452717599,
            3986780487, 4003029142, 1978711517, 2235305521, 1902045260, 2244872314, 511411729,
            1901094530, 2749060758, 791215438,  2861513457, 809816281,  3000558981, 3662665197,
            1491423798, 1566910418, 799204384,  97341020,   3612968250, 3360299540, 3476689506,
            1735703974, 992373109,  192265540,  4063996544, 1154580429, 863192570,  3656848102,
            538678309,  3059700291, 4203763671, 884958204,  372254037,  1568202716, 1809323503,
            1966520228, 1771789609, 2960284664, 1747256653, 2158800547, 648418114,  599691159,
            3779475444, 4094586399, 3334786489, 3309819546, 3722275470, 133475296,  2259497681,
            4020673166, 4224146498, 3015268376, 2323085675, 2619507085, 2685591626, 4085723415,
            3692382538, 2996767663, 3190957795, 2477461655, 34352270,   2572519647, 3756180566,
            981551707,  2915676725, 3097758460, 2886022933, 3943911799, 2975580690, 2387546211,
            3433397401, 3976673102, 3691522739, 1227093107, 1270973058, 4086318816, 3834041114,
            2492127162, 3072736899, 2767271619, 2254201538, 285195583,  3376614599, 911293448,
            1151682776, 3129245111, 3545136148, 1719781794, 3240626385, 3670073914, 4050893306,
            1593902981, 2441131570, 3735445799, 2608280275, 3471467548, 3272829390, 494131548,
            1002565,    60031939,   3569452566, 3140603948, 2455110553, 3600720367, 3325063040,
            3648318018, 1180609498, 3406916390, 2638331009, 2440387238, 2197458475, 1727555926,
            1553864256, 2132071262, 2282802854, 2022378978, 2359524432, 156900063,  3230489867,
            1509706506, 1228398315, 1472718426, 1330681578, 3899303695, 4143363627, 1385396548,
            312218186,  726916901,  58282118,   2447567471, 2341127947, 384446588,  4199708949,
            4076132786, 2488732604, 3770317722, 3989982361, 73544798,   1883334443, 90453946,
            540996900,  4201534770, 2279943861, 3762353033, 2104040920, 921289059,  1279431804,
            971742325,  3702586731, 4031807006, 116295830,  3092793381, 925195517,  1532786382,
            3683549106, 1727176377, 3389479429, 2146886998, 569788679,  2074665658, 2452717599,
            3986780487, 4003029142, 1978711517, 2610706831, 1902045260, 2244872314, 511411729,
            1901094530, 818316917,  791215438,  2861513457, 809816281,  3000558981, 2924824701,
            1491423798, 1566910418, 799204384,  97341020,   1743349529, 3360299540, 3476689506,
            1735703974, 992373109,  678382292,  4063996544, 1154580429, 863192570,  3656848102,
            533416083,  3059700291, 4203763671, 884958204,  372254037,  2440226492, 1809323503,
            1966520228, 1771789609, 2960284664, 3424563681, 2158800547, 648418114,  599691159,
            3779475444, 2282586739, 3334786489, 3309819546, 3722275470, 133475296,  3207273832,
            4020673166, 4224146498, 3015268376, 2323085675, 442263738,  2685591626, 4085723415,
            3692382538, 2996767663, 3338949193, 2477461655, 34352270,   2572519647, 3756180566,
            2266016150, 2915676725, 3097758460, 2886022933, 3943911799, 4038442048, 2387546211,
            3433397401, 3976673102, 3691522739, 3780506310, 1270973058, 4086318816, 3834041114,
            2492127162, 763485371,  2767271619, 2254201538, 285195583,  3376614599, 1361420651,
            1151682776, 3129245111, 3545136148, 1719781794, 4048102723, 3670073914, 4050893306,
            1593902981, 2441131570, 2656410054, 2608280275, 3471467548, 3272829390, 494131548,
            706712104,  60031939,   3569452566, 3140603948, 2455110553, 1318787633, 3325063040,
            3648318018, 1180609498, 3406916390, 2278693213, 2440387238, 2197458475, 1727555926,
            1553864256, 982396239,  2282802854, 2022378978, 2359524432, 156900063,  1047682473,
            1509706506, 1228398315, 1472718426, 1330681578, 2750510827, 4143363627, 1385396548,
            312218186,  726916901,  3066828251, 2447567471, 2341127947, 384446588,  4199708949,
            348963523,  2488732604, 3770317722, 3989982361, 73544798,   170137552,  90453946,
            540996900,  4201534770, 2279943861, 555253090,  2104040920, 921289059,  1279431804,
            971742325,  3301986174, 4031807006, 116295830,  3092793381, 925195517,  3016875814,
            3683549106, 1727176377, 3389479429, 2146886998, 666608971,  2074665658, 2452717599,
            3986780487, 4003029142, 2896647678, 2610706831, 1902045260, 2244872314, 511411729,
            1687522042, 818316917,  791215438,  2861513457, 809816281,  1504324847, 2924824701,
            1491423798, 1566910418, 799204384,  3530294462, 1743349529, 3360299540, 3476689506,
            1735703974, 2428500463, 678382292,  4063996544, 1154580429, 863192570,  740355116,
            533416083,  3059700291, 4203763671, 884958204,  4291104716, 2440226492, 1809323503,
            1966520228, 1771789609, 1185306004, 3424563681, 2158800547, 648418114,  599691159,
            3471738568, 2282586739, 3334786489, 3309819546, 3722275470, 27339499,   3207273832,
            4020673166, 4224146498, 3015268376, 2074276265, 442263738,  2685591626, 4085723415,
            3692382538, 1485067705, 3338949193, 2477461655, 34352270,   2572519647, 1680917106,
            2266016150, 2915676725, 3097758460, 2886022933, 2163201014, 4038442048, 2387546211,
            3433397401, 3976673102, 320422911,  3780506310, 1270973058, 4086318816, 3834041114,
            2546893215, 763485371,  2767271619, 2254201538, 285195583,  1723166786, 1361420651,
            1151682776, 3129245111, 3545136148, 301182030,  4048102723, 3670073914, 4050893306,
            1593902981, 1223787890, 2656410054, 2608280275, 3471467548, 3272829390, 1836357052,
            706712104,  60031939,   3569452566, 3140603948, 1255573871, 1318787633, 3325063040,
            3648318018, 1180609498, 4034939671, 2278693213, 2440387238, 2197458475, 1727555926,
            4222490798, 982396239,  2282802854, 2022378978, 2359524432, 701755584,  1047682473,
            1509706506, 1228398315, 1472718426, 3221522171, 2750510827, 4143363627, 1385396548,
            312218186,  1744058246, 3066828251, 2447567471, 2341127947, 384446588,  3670229233,
            348963523,  2488732604, 3770317722, 3989982361, 1585763150, 170137552,  90453946,
            540996900,  4201534770, 1939451641, 555253090,  2104040920, 921289059,  1279431804,
            129580341,  3301986174, 4031807006, 116295830,  3092793381, 257322667,  3016875814,
            3683549106, 1727176377, 3389479429, 2481087974, 666608971,  2074665658, 2452717599,
            3986780487, 1460614603, 2896647678, 2610706831, 1902045260, 2244872314, 350211872,
            1687522042, 818316917,  791215438,  2861513457, 2959680242, 1504324847, 2924824701,
            1491423798, 1566910418, 4098403407, 3530294462, 1743349529, 3360299540, 3476689506,
            3726048539, 2428500463, 678382292,  4063996544, 1154580429, 684891915,  740355116,
            533416083,  3059700291, 4203763671, 929343030,  4291104716, 2440226492, 1809323503,
            1966520228, 780804028,  1185306004, 3424563681, 2158800547, 648418114,  908629722,
            3471738568, 2282586739, 3334786489, 3309819546, 2415434168, 27339499,   3207273832,
            4020673166, 4224146498, 249988790,  2074276265, 442263738,  2685591626, 4085723415,
            3097590489, 1485067705, 3338949193, 2477461655, 34352270,   2733031814, 1680917106,
            2266016150, 2915676725, 3097758460, 2003073211, 1130238685, 1601665317, 2033591482,
            613197687,  2590199797, 2673227886, 374639958,  1414523764, 3741184152, 2128977135,
            199028692,  2708648917, 2052594593, 1074394357, 2199721630, 513264032,  3724573614,
            2452923762, 3328658753, 3033905552, 3969701816, 2819509756, 2434793300, 436923265,
            371995748,  1750550526, 165340320,  2032295180, 3461709442, 3807900324, 2268037306,
            2145099447, 3155004822, 3011902995, 4215254908, 2444366693, 143758852,  4007105924,
            1364483407, 1236976230, 3051077383, 3822145682, 2053549359, 1435420553, 915076840,
            4292360856, 3952053119, 2040350610, 313379433,  145549218,  3538652197, 3225555170,
            3679057299, 3987743499, 542848374,  3619200848, 544631808,  1727472265, 487305935,
            216086134,  3520657096, 146974491,  2903696525, 3530065607, 855430366,  786013352,
            436339275,  331055129,  3943106358, 4086602567, 752599406,  1123528315, 2144209011,
            2471343156, 937897181,  1413449147, 2960652450, 695200002,  3136370375, 3134060344,
            1876313096, 875735545,  4109411649, 537514033,  3336964231, 538401824,  2649655790,
            403111093,  526785986,  2177599847, 1678276805, 945656242,  3434957155, 2670186696,
            272697247,  3310354555, 3832614008, 2776047270, 2909982770, 3533868549, 2671026831,
            814903974,  3524787686, 71750703,   3920050700, 237505256,  1583745769, 1636990926,
            629545423,  1981912132, 2079214652, 2403875435, 3249215924, 4246192261, 2183017007,
            2374392317, 3667536721, 2036016856, 1846591954, 1498014634, 3409140435, 3527608629,
            4185511047, 3304853133, 1474695702, 165948654,  2443263322, 485569591,  1901569715,
            4186403895, 650801897,  688538822,  4109812517, 2730232269, 3515782857, 3349384003,
            2343454557, 3849342346, 1115136257, 3131582066, 894484426,  888247585,  2346354761,
            1685852871, 1768331470, 1736449656, 472051665,  108955499,  2792122145, 4056357218,
            1231446971, 300037634,  3605423179, 1162704092, 537234256,  2195933910, 3872622756,
            1640177970, 3423245063,
        },
        {
            1118787884, 1884590246, 1007052798, 3717680750, 1609263052, 2486654530, 2761168910,
            163554565,  3928803020, 2632714628, 1386788970, 2621928183, 2855206157, 2989018213,
            1836814260, 4197635108, 1030118238, 2789863793, 2063944689, 1647608366, 255485979,
            3657534664, 1317185871, 2410074449, 3971156607, 907575923,  4132859581, 416269582,
            877554291,  633895348,  2236014545, 992386759,  3971362318, 2173597771, 1673339632,
            1371742490, 2033574313, 3809530180, 319182848,  1562235776, 463522324,  1482338913,
            1816432405, 3278626272, 1335179249, 171265751,  2249118654, 1153849045, 3013179633,
            1450352108, 1267908572, 1138658121, 623675874,  3608469129, 978093004,  1283228910,
            1810859539, 1179125634, 2939039286, 3862213960, 1168357273, 376788629,  314507445,
            219039712,  463080619,  2994990779, 1035692306, 2228303916, 1280244913, 1965417315,
            1815095408, 939691799,  3080056566, 3741305118, 1495905100, 65327713,   3884301346,
            2536445014, 1503280354, 3398924419, 3678532805, 2616964783, 3168581019, 3553322118,
            3023259169, 480342712,  451634742,  3562778450, 1943708078, 660077747,  434714388,
            2369278293, 2894425895, 1919542250, 2469130567, 551196237,  4193980239, 2952382875,
            3311173667, 2856797012, 2845888917, 1669184098, 3928626091, 2491577076, 3719464032,
            2151963814, 3474431449, 3971510537, 3695841119, 2215238146, 3668152847, 1974578319,
            2328185090, 2096356935, 3973692455, 3954842437, 422675402,  477894725,  3398641827,
            1366451030, 1354642198, 3029840461, 35700837,   2937170986, 1336296570, 3508313874,
            587724229,  2051237478, 3539754304, 1946154432, 2463932452, 144772179,  353408424,
            3493806256, 3782958493, 1957797444, 228084488,  192277278,  3612092522, 2235069734,
            467407503,  3391861572, 847810786,  1838763654, 2272109211, 3018265496, 4249218445,
            1722760791, 3484353162, 3906437663, 4208966227, 2352549740, 714311566,  1346246305,
            2865157059, 2989587005, 3946819548, 3109244860, 3885124598, 3314346978, 952826829,
            1118787884, 1884590246, 1007052798, 3717680750, 1521451317, 2486654530, 2761168910,
            163554565,  3928803020, 2299046195, 1386788970, 2621928183, 2855206157, 2989018213,
            3048269905, 4197635108, 1030118238, 2789863793, 2063944689, 1814057352, 255485979,
            3657534664, 1317185871, 2410074449, 4041610788, 907575923,  4132859581, 416269582,
            877554291,  2338964683, 2236014545, 992386759,  3971362318, 2173597771, 579340117,
            1371742490, 2033574313, 3809530180, 319182848,  3090313228, 463522324,  1482338913,
            1816432405, 3278626272, 2418220643, 171265751,  2249118654, 1153849045, 3013179633,
            2738647190, 1267908572, 1138658121, 623675874,  3608469129, 3096087202, 1283228910,
            1810859539, 1179125634, 2939039286, 2601862091, 1168357273, 376788629,  314507445,
            219039712,  1174181426, 2994990779, 1035692306, 2228303916, 1280244913, 752017703,
            1815095408, 939691799,  3080056566, 3741305118, 126135654,  65327713,   3884301346,
            2536445014, 1503280354, 955981361,  3678532805, 2616964783, 3168581019, 3553322118,
            3772187171, 480342712,  451634742,  3562778450, 1943708078, 1466950454, 434714388,
            2369278293, 2894425895, 1919542250, 317862862,  551196237,  4193980239, 2952382875,
            3311173667, 12728591,   2845888917, 1669184098, 3928626091, 2491577076, 2742989641,
            2151963814, 3474431449, 3971510537, 3695841119, 1005662613, 3668152847, 1974578319,
            2328185090, 2096356935, 3629684995, 3954842437, 422675402,  477894725,  3398641827,
            209352768,  1354642198, 3029840461, 35700837,   2937170986, 1660777984, 3508313874,
            587724229,  2051237478, 3539754304, 3631430985, 2463932452, 144772179,  353408424,
            3493806256, 3616422021, 1957797444, 228084488,  192277278,  3612092522, 3638977910,
            467407503,  3391861572, 847810786,  1838763654, 2427237699, 3018265496, 4249218445,
            1722760791, 3484353162, 2322365400, 4208966227, 2352549740, 714311566,  1346246305,
            954101391,  2989587005, 3946819548, 3109244860, 3885124598, 420941376,  952826829,
            1118787884, 1884590246, 1007052798, 539759724,  1521451317, 2486654530, 2761168910,
            163554565,  1954997983, 2299046195, 1386788970, 2621928183, 2855206157, 3104695189,
            3048269905, 4197635108, 1030118238, 2789863793, 3556473570, 1814057352, 255485979,
            3657534664, 1317185871, 3004205219, 4041610788, 907575923,  4132859581, 416269582,
            2980178044, 2338964683, 2236014545, 992386759,  3971362318, 2573125018, 579340117,
            1371742490, 2033574313, 3809530180, 766585731,  3090313228, 463522324,  1482338913,
            1816432405, 3101578277, 2418220643, 171265751,  2249118654, 1153849045, 2143267892,
            2738647190, 1267908572, 1138658121, 623675874,  2944231951, 3096087202, 1283228910,
            1810859539, 1179125634, 374714364,  2601862091, 1168357273, 376788629,  314507445,
            1710922505, 1174181426, 2994990779, 1035692306, 2228303916, 3222680885, 752017703,
            1815095408, 939691799,  3080056566, 1985366287, 126135654,  65327713,   3884301346,
            2536445014, 3002467868, 955981361,  3678532805, 2616964783, 3168581019, 2173417616,
            3772187171, 480342712,  451634742,  3562778450, 236095606,  1466950454, 434714388,
            2369278293, 2894425895, 1766257461, 317862862,  551196237,  4193980239, 2952382875,
            2416349742, 12728591,   2845888917, 1669184098, 3928626091, 2346338391, 2742989641,
            2151963814, 3474431449, 3971510537, 942354812,  1005662613, 3668152847, 1974578319,
            2328185090, 3234982376, 3629684995, 3954842437, 422675402,  477894725,  2931444539,
            209352768,  1354642198, 3029840461, 35700837,   3388567298, 1660777984, 3508313874,
            587724229,  2051237478, 1770178720, 3631430985, 2463932452, 144772179,  353408424,
            3783114255, 3616422021, 1957797444, 228084488,  192277278,  611095909,  3638977910,
            467407503,  3391861572, 847810786,  1413548572, 2427237699, 3018265496, 4249218445,
            1722760791, 1487262638, 2322365400, 4208966227, 2352549740, 714311566,  1378213368,
            954101391,  2989587005, 3946819548, 3109244860, 4183748384, 420941376,  952826829,
            1118787884, 1884590246, 2199811809, 539759724,  1521451317, 2486654530, 2761168910,
            1100080647, 1954997983, 2299046195, 1386788970, 2621928183, 916352763,  3104695189,
            3048269905, 4197635108, 1030118238, 369866139,  3556473570, 1814057352, 255485979,
            3657534664, 2916985473, 3004205219, 4041610788, 907575923,  4132859581, 3856599532,
            2980178044, 2338964683, 2236014545, 992386759,  3393662326, 2573125018, 579340117,
            1371742490, 2033574313, 1938766053, 766585731,  3090313228, 463522324,  1482338913,
            2122086302, 3101578277, 2418220643, 171265751,  2249118654, 952602228,  2143267892,
            2738647190, 1267908572, 1138658121, 1808026803, 2944231951, 3096087202, 1283228910,
            1810859539, 3881666794, 374714364,  2601862091, 1168357273, 376788629,  728738466,
            1710922505, 1174181426, 2994990779, 1035692306, 74930675,   3222680885, 752017703,
            1815095408, 939691799,  3404352271, 1985366287, 126135654,  65327713,   3884301346,
            1822629733, 3002467868, 955981361,  3678532805, 2616964783, 3865359567, 2173417616,
            3772187171, 480342712,  451634742,  1099609112, 236095606,  1466950454, 434714388,
            2369278293, 2671873359, 1766257461, 317862862,  551196237,  4193980239, 2006763654,
            2416349742, 12728591,   2845888917, 1669184098, 2492983893, 2346338391, 2742989641,
            2151963814, 3474431449, 2095232649, 942354812,  1005662613, 3668152847, 1974578319,
            1748794756, 3234982376, 3629684995, 3954842437, 422675402,  2291986911, 2931444539,
            209352768,  1354642198, 3029840461, 3772709822, 3388567298, 1660777984, 3508313874,
            587724229,  2759789003, 1770178720, 3631430985, 2463932452, 144772179,  1572181309,
            3783114255, 3616422021, 1957797444, 228084488,  4106643586, 611095909,  3638977910,
            467407503,  3391861572, 927151111,  1413548572, 2427237699, 3018265496, 4249218445,
            692575565,  1487262638, 2322365400, 4208966227, 2352549740, 1281886506, 1378213368,
            954101391,  2989587005, 3946819548, 1861811740, 1484768905, 359662140,  4058479705,
            1306547382, 514617018,  1685692791, 3370601554, 2920029077, 447798803,  3124262580,
            1841693810, 583764638,  853545489,  2614348705, 1445696741, 4226719361, 1299450005,
            7404137,    3158806368, 3487160245, 1410910965, 3697116584, 4272452035, 832215403,
            4190877996, 2360539465, 1011144434, 546018244,  613443074,  2523894977, 998991923,
            2569220540, 4221264346, 2627827148, 2606458015, 261584257,  4172552877, 1174774061,
            1040006970, 2378868955, 1539192255, 1322624483, 3221782707, 3352886416, 3634686692,
            65447704,   3962131218, 839088053,  4154193716, 1211888926, 319402483,  3922826413,
            3799829447, 623726612,  1586183272, 1853729462, 2621029589, 708558605,  1618007233,
            2784732545, 953859039,  921654620,  477148727,  3592256598, 2772318818, 1460772911,
            1309227716, 3484274262, 3425161241, 1677052569, 2238155114, 2828087292, 2361598991,
            4283732706, 1530059373, 1564048492, 243829114,  104328994,  3080249237, 2054985396,
            408961407,  2978652320, 2412674552, 3794618070, 3644862703, 2095186402, 3294126752,
            2970218740, 1800713612, 3806665216, 3990918051, 142666452,  531078813,  1079142774,
            3437358350, 635943961,  255576894,  2991317718, 1208676456, 247449774,  454879171,
            113230697,  3064123371, 336269028,  1137083842, 959568850,  2508623991, 3338418112,
            2660268938, 1318010299, 3950178561, 1078499199, 1176289535, 3875152821, 1984420952,
            1134199826, 2944539174, 3667625203, 2034152216, 1648355307, 2376447620, 2967418253,
            185143450,  889002925,  3999315013, 661455858,  4026799358, 3626504428, 3544795311,
            3642718771, 2467387138, 1034249749, 2051371333, 4251353248, 1575036366, 751400924,
            2906720214, 1210002606, 916508568,  1728487600, 2478884914, 3081526615, 1867135009,
            1955998382, 701713417,  512784398,  1255240210, 3665676113, 1771754697, 4000392442,
            3342268855, 2677221913, 369054145,  4011912082, 748537647,  1626721797, 852497405,
            168721778,  3091138383,
        },
        {
            4264607538, 3490412730, 4157576013, 4268415120, 2541471921, 4270995004, 2571336152,
            2577408911, 2189711087, 866094996,  494656850,  3804917593, 1177000980, 1631556794,
            3730915267, 568810600,  1646585533, 1775719319, 541675466,  4022387103, 864995655,
            1730051604, 4217371277, 883146457,  2093040750, 158942433,  4067664799, 1908973552,
            87752185,   1159041264, 614629420,  1699445756, 3267480665, 1426137732, 4098001422,
            3889550188, 1416183302, 1689288710, 2326422784, 1999632935, 3187413485, 444515029,
            1682066742, 2689143312, 2345191238, 184168372,  620095235,  1463454954, 2451596229,
            1937924233, 3688573089, 997823323,  2464437599, 3496901150, 3409321583, 3937144879,
            1990503302, 2900182857, 2426247573, 1735150821, 3084064273, 2555207320, 3687457217,
            521831245,  2138580931, 3483275814, 271883166,  2166999256, 1344549110, 2883789295,
            1196053376, 1366674978, 974208923,  524327504,  40290236,   634381301,  3862610321,
            42457748,   1216632731, 2324951831, 3951592443, 3362604988, 324666248,  23642342,
            282113078,  176711594,  835982400,  2156059602, 3650419719, 1863484057, 1993398790,
            3699816621, 3550930076, 2207813576, 3339519522, 4038135517, 1048150514, 2269630336,
            888008991,  2590555584, 1610693721, 274205516,  2029074154, 3158820685, 4247908939,
            82655885,   3268553119, 3071568170, 3191355137, 1531541234, 1634929144, 4012518925,
            3259363646, 4175498420, 2853988131, 1309270769, 1278456387, 3270872358, 1965014441,
            532972694,  4218431489, 3738606028, 2867167081, 2244866886, 3113313134, 3137150683,
            96142354,   1112676664, 1589243536, 1338241699, 3913805727, 1353972239, 1242351219,
            3082715230, 1629537127, 3841283448, 2953730829, 2511767804, 3234554452, 3392347698,
            2944670604, 2056080841, 4063789431, 534471299,  3105197360, 2313541918, 3560191805,
            4093138046, 3640024837, 2788882995, 3388643356, 1763559857, 3054556362, 267443721,
            722044613,  1401910515, 596767906,  702797371,  226186082,  3718405370, 1645243417,
            4264607538, 3490412730, 4157576013, 4268415120, 2700578507, 4270995004, 2571336152,
            2577408911, 2189711087, 3055268716, 494656850,  3804917593, 1177000980, 1631556794,
            2661537859, 568810600,  1646585533, 1775719319, 541675466,  3446410929, 864995655,
            1730051604, 4217371277, 883146457,  234851641,  158942433,  4067664799, 1908973552,
            87752185,   2352960775, 614629420,  1699445756, 3267480665, 1426137732, 1031865371,
            3889550188, 1416183302, 1689288710, 2326422784, 3512326807, 3187413485, 444515029,
            1682066742, 2689143312, 1417469328, 184168372,  620095235,  1463454954, 2451596229,
            153235622,  3688573089, 997823323,  2464437599, 3496901150, 2283784576, 3937144879,
            1990503302, 2900182857, 2426247573, 1781835357, 3084064273, 2555207320, 3687457217,
            521831245,  2315467539, 3483275814, 271883166,  2166999256, 1344549110, 1249622480,
            1196053376, 1366674978, 974208923,  524327504,  888338106,  634381301,  3862610321,
            42457748,   1216632731, 40903146,   3951592443, 3362604988, 324666248,  23642342,
            3506887965, 176711594,  835982400,  2156059602, 3650419719, 4013573074, 1993398790,
            3699816621, 3550930076, 2207813576, 2151168635, 4038135517, 1048150514, 2269630336,
            888008991,  1704875458, 1610693721, 274205516,  2029074154, 3158820685, 3458722347,
            82655885,   3268553119, 3071568170, 3191355137, 2420714225, 1634929144, 4012518925,
            3259363646, 4175498420, 3736305361, 1309270769, 1278456387, 3270872358, 1965014441,
            718136672,  4218431489, 3738606028, 2867167081, 2244866886, 1202734059, 3137150683,
            96142354,   1112676664, 1589243536, 2051185516, 3913805727, 1353972239, 1242351219,
            3082715230, 3461456087, 3841283448, 2953730829, 2511767804, 3234554452, 4095760212,
            2944670604, 2056080841, 4063789431, 534471299,  2356767101, 2313541918, 3560191805,
            4093138046, 3640024837, 2451906618, 3388643356, 1763559857, 3054556362, 267443721,
            3464840927, 1401910515, 596767906,  702797371,  226186082,  3916422556, 1645243417,
            4264607538, 3490412730, 4157576013, 2860344213, 2700578507, 4270995004, 2571336152,
            2577408911, 820443421,  3055268716, 494656850,  3804917593, 1177000980, 2519565283,
            2661537859, 568810600,  1646585533, 1775719319, 563643696,  3446410929, 864995655,
            1730051604, 4217371277, 753792684,  234851641,  158942433,  4067664799, 1908973552,
            3096452764, 2352960775, 614629420,  1699445756, 3267480665, 2965493378, 1031865371,
            3889550188, 1416183302, 1689288710, 1719377149, 3512326807, 3187413485, 444515029,
            1682066742, 1911237124, 1417469328, 184168372,  620095235,  1463454954, 3814868876,
            153235622,  3688573089, 997823323,  2464437599, 2355749295, 2283784576, 3937144879,
            1990503302, 2900182857, 539461743,  1781835357, 3084064273, 2555207320, 3687457217,
            2561052488, 2315467539, 3483275814, 271883166,  2166999256, 1701299572, 1249622480,
            1196053376, 1366674978, 974208923,  722567940,  888338106,  634381301,  3862610321,
            42457748,   462719927,  40903146,   3951592443, 3362604988, 324666248,  1059141699,
            3506887965, 176711594,  835982400,  2156059602, 3785784847, 4013573074, 1993398790,
            3699816621, 3550930076, 1466455953, 2151168635, 4038135517, 1048150514, 2269630336,
            4172325476, 1704875458, 1610693721, 274205516,  2029074154, 539821364,  3458722347,
            82655885,   3268553119, 3071568170, 3297490898, 2420714225, 1634929144, 4012518925,
            3259363646, 1824402299, 3736305361, 1309270769, 1278456387, 3270872358, 2856591854,
            718136672,  4218431489, 3738606028, 2867167081, 3747721247, 1202734059, 3137150683,
            96142354,   1112676664, 4136114524, 2051185516, 3913805727, 1353972239, 1242351219,
            3356432970, 3461456087, 3841283448, 2953730829, 2511767804, 2641923994, 4095760212,
            2944670604, 2056080841, 4063789431, 262053025,  2356767101, 2313541918, 3560191805,
            4093138046, 2474268628, 2451906618, 3388643356, 1763559857, 3054556362, 3095154220,
            3464840927, 1401910515, 596767906,  702797371,  467199579,  3916422556, 1645243417,
            4264607538, 3490412730, 1774412891, 2860344213, 2700578507, 4270995004, 2571336152,
            1614021366, 820443421,  3055268716, 494656850,  3804917593, 3548973127, 2519565283,
            2661537859, 568810600,  1646585533, 2246370758, 563643696,  3446410929, 864995655,
            1730051604, 2959518011, 753792684,  234851641,  158942433,  4067664799, 1095081942,
            3096452764, 2352960775, 614629420,  1699445756, 3895785429, 2965493378, 1031865371,
            3889550188, 1416183302, 1600836798, 1719377149, 3512326807, 3187413485, 444515029,
            275410374,  1911237124, 1417469328, 184168372,  620095235,  3301949146, 3814868876,
            153235622,  3688573089, 997823323,  1931939716, 2355749295, 2283784576, 3937144879,
            1990503302, 2613178822, 539461743,  1781835357, 3084064273, 2555207320, 2814605437,
            2561052488, 2315467539, 3483275814, 271883166,  4025270585, 1701299572, 1249622480,
            1196053376, 1366674978, 1678508438, 722567940,  888338106,  634381301,  3862610321,
            4142342693, 462719927,  40903146,   3951592443, 3362604988, 3060313586, 1059141699,
            3506887965, 176711594,  835982400,  1460103244, 3785784847, 4013573074, 1993398790,
            3699816621, 4152530343, 1466455953, 2151168635, 4038135517, 1048150514, 3823152168,
            4172325476, 1704875458, 1610693721, 274205516,  4112184745, 539821364,  3458722347,
            82655885,   3268553119, 2433058945, 3297490898, 2420714225, 1634929144, 4012518925,
            4196660284, 1824402299, 3736305361, 1309270769, 1278456387, 2700406140, 2856591854,
            718136672,  4218431489, 3738606028, 3312204461, 3747721247, 1202734059, 3137150683,
            96142354,   208013818,  4136114524, 2051185516, 3913805727, 1353972239, 442248166,
            3356432970, 3461456087, 3841283448, 2953730829, 3581886434, 2641923994, 4095760212,
            2944670604, 2056080841, 3845603220, 262053025,  2356767101, 2313541918, 3560191805,
            933678667,  2474268628, 2451906618, 3388643356, 1763559857, 3638809414, 3095154220,
            3464840927, 1401910515, 596767906,  2693382768, 2604036031, 3332313631, 593934185,
            3482403182, 1887615690, 1828322546, 955632271,  3021832152, 1838396365, 3921789714,
            4116307837, 3128007776, 2273505356, 615451084,  3674264817, 1152503844, 623169610,
            3466069822, 2427471510, 543640468,  3032916028, 2280245615, 315050293,  2967714158,
            1975001699, 4268840424, 740244380,  656210473,  4120803712, 2091654809, 2144254464,
            2347294528, 3193316562, 3706202083, 1278741650, 4156064653, 1964969783, 2144280000,
            1600236938, 289738350,  314043491,  1480756971, 2443852060, 296108903,  1001381552,
            4270037208, 117197964,  3690710856, 317605010,  1109867343, 1287027676, 3112283797,
            1176273693, 255864461,  1404336330, 845568568,  928061164,  3346752294, 1126823548,
            1553479347, 747568757,  414281056,  1039166358, 1059463866, 3578145710, 2308243024,
            2306561620, 3287264366, 1440601351, 3395223113, 374706885,  4139719982, 2458354993,
            948462895,  318057846,  2304683387, 2016787530, 1862174069, 2379245390, 3956750592,
            337124218,  1333108907, 3037028157, 3068999705, 4212239747, 2554931020, 3231170857,
            1504504655, 1842423841, 870821301,  2240629407, 776151503,  3980768158, 3500695231,
            4289167771, 3665465909, 574214021,  3336634830, 31727372,   153616479,  1090072678,
            4160806524, 3898664159, 3587825644, 3576702781, 1744821798, 1212020603, 1056285892,
            2730024309, 3782053734, 1248335199, 742183299,  1262303015, 2535561269, 3529475593,
            2938833441, 1692464176, 934547487,  1626002229, 2855377937, 1078545534, 1979608929,
            1572341610, 1348728148, 1205144754, 267332713,  3102718356, 2560639804, 3386609113,
            973083320,  2732552974, 4148743253, 3178211050, 4134049948, 2270656532, 2809517418,
            2380765950, 425140699,  1774594446, 1250704659, 2683503345, 42700139,   4138457663,
            1496302003, 2371230326, 1751197154, 1744812355, 3951480894, 1650657568, 2495178828,
            2736760327, 811987411,  2722157033, 1807370741, 981370520,  3801961950, 1524702194,
            2489605421, 3354077662,
        },
        {
            3781228998, 1787582256, 838267218,  2710632450, 690892139,  2484870604, 4151302318,
            1844787776, 727768263,  1075391038, 1842903369, 2927332301, 3246688068, 1234715005,
            2906526190, 3369636401, 3091858538, 3320767682, 920496809,  1406803705, 3163880457,
            1540551653, 2733620168, 2588558057, 147277542,  803170440,  821275940,  3897549272,
            151390608,  951639139,  904639695,  1106545578, 1514893712, 998760135,  2557458623,
            4109877399, 578824730,  2174064027, 3352513900, 3206168298, 911932439,  2030004973,
            3283902592, 3755877921, 250434692,  352122318,  977153640,  642640734,  2555395772,
            2307695537, 2593565626, 3738143618, 734614254,  3276420511, 2636087597, 4157371578,
            1082026387, 429736987,  3755125580, 1935957937, 3300547146, 3089498232, 4167244256,
            1619189426, 1094447351, 1061842570, 3666470174, 810916769,  2263633079, 3863543843,
            1804937521, 2774236887, 2858593613, 961498236,  1515309045, 1564424234, 2276602447,
            2540994858, 78621171,   3575132456, 2958793283, 387554009,  688827573,  3833764146,
            2611524056, 2296780370, 2411775612, 3790615886, 3399757437, 1385198595, 1005364336,
            2093159919, 2091827252, 1461775197, 4225171212, 1185831033, 12264437,   1313835999,
            556653278,  917105970,  1471530347, 2010243509, 3097827138, 1399987735, 273352191,
            2505795417, 1336824946, 3358720963, 2874295267, 2282349617, 3478581038, 4027859424,
            713597958,  4059691816, 2812811116, 2291324146, 932688463,  3001334051, 2028368589,
            830582457,  3964293916, 4276849132, 1828058403, 1351688755, 2113265048, 42517349,
            3100438883, 1137792178, 1479076106, 463377892,  3964913740, 2422362185, 436113863,
            2044139049, 4197323265, 3275185975, 2655265571, 1674107588, 1496360114, 3642050139,
            1739051417, 2393774399, 250035802,  10186306,   263338568,  3899157617, 3679157076,
            2258085991, 1407319575, 899008067,  3679828833, 711086272,  2952963707, 3373894808,
            445540851,  3405637490, 1343291195, 730888681,  507768703,  3473963321, 1779803564,
            3781228998, 1787582256, 838267218,  2710632450, 2431224659, 2484870604, 4151302318,
            1844787776, 727768263,  4012573268, 1842903369, 2927332301, 3246688068, 1234715005,
            3405161215, 3369636401, 3091858538, 3320767682, 920496809,  400609988,  3163880457,
            1540551653, 2733620168, 2588558057, 2137935937, 803170440,  821275940,  3897549272,
            151390608,  194431797,  904639695,  1106545578, 1514893712, 998760135,  62528087,
            4109877399, 578824730,  2174064027, 3352513900, 3495516649, 911932439,  2030004973,
            3283902592, 3755877921, 1774462108, 352122318,  977153640,  642640734,  2555395772,
            756528792,  2593565626, 3738143618, 734614254,  3276420511, 4086313763, 4157371578,
            1082026387, 429736987,  3755125580, 526056489,  3300547146, 3089498232, 4167244256,
            1619189426, 82235109,   1061842570, 3666470174, 810916769,  2263633079, 1110270726,
            1804937521, 2774236887, 2858593613, 961498236,  1840197918, 1564424234, 2276602447,
            2540994858, 78621171,   3690913528, 2958793283, 387554009,  688827573,  3833764146,
            3626285597, 2296780370, 2411775612, 3790615886, 3399757437, 1561545830, 1005364336,
            2093159919, 2091827252, 1461775197, 63358970,   1185831033, 12264437,   1313835999,
            556653278,  3918754976, 1471530347, 2010243509, 3097827138, 1399987735, 2767111911,
            2505795417, 1336824946, 3358720963, 2874295267, 902314853,  3478581038, 4027859424,
            713597958,  4059691816, 1462989647, 2291324146, 932688463,  3001334051, 2028368589,
            3594712587, 3964293916, 4276849132, 1828058403, 1351688755, 2571513800, 42517349,
            3100438883, 1137792178, 1479076106, 140519541,  3964913740, 2422362185, 436113863,
            2044139049, 226785542,  3275185975, 2655265571, 1674107588, 1496360114, 46428973,
            1739051417, 2393774399, 250035802,  10186306,   4118320101, 3899157617, 3679157076,
            2258085991, 1407319575, 4267866849, 3679828833, 711086272,  2952963707, 3373894808,
            3662249794, 3405637490, 1343291195, 730888681,  507768703,  2930510271, 1779803564,
            3781228998, 1787582256, 838267218,  1817693489, 2431224659, 2484870604, 4151302318,
            1844787776, 1788220652, 4012573268, 1842903369, 2927332301, 3246688068, 2050648011,
            3405161215, 3369636401, 3091858538, 3320767682, 241001958,  400609988,  3163880457,
            1540551653, 2733620168, 3857223520, 2137935937, 803170440,  821275940,  3897549272,
            1451986523, 194431797,  904639695,  1106545578, 1514893712, 4147878244, 62528087,
            4109877399, 578824730,  2174064027, 461571251,  3495516649, 911932439,  2030004973,
            3283902592, 1580354765, 1774462108, 352122318,  977153640,  642640734,  1019387737,
            756528792,  2593565626, 3738143618, 734614254,  999431451,  4086313763, 4157371578,
            1082026387, 429736987,  140091634,  526056489,  3300547146, 3089498232, 4167244256,
            3202763095, 82235109,   1061842570, 3666470174, 810916769,  3663992550, 1110270726,
            1804937521, 2774236887, 2858593613, 2203639366, 1840197918, 1564424234, 2276602447,
            2540994858, 978199281,  3690913528, 2958793283, 387554009,  688827573,  375113876,
            3626285597, 2296780370, 2411775612, 3790615886, 1277897939, 1561545830, 1005364336,
            2093159919, 2091827252, 1631078873, 63358970,   1185831033, 12264437,   1313835999,
            3872277948, 3918754976, 1471530347, 2010243509, 3097827138, 1291836608, 2767111911,
            2505795417, 1336824946, 3358720963, 3954754615, 902314853,  3478581038, 4027859424,
            713597958,  2198246306, 1462989647, 2291324146, 932688463,  3001334051, 2374736511,
            3594712587, 3964293916, 4276849132, 1828058403, 3619038368, 2571513800, 42517349,
            3100438883, 1137792178, 1146435746, 140519541,  3964913740, 2422362185, 436113863,
            3460540392, 226785542,  3275185975, 2655265571, 1674107588, 1288223861, 46428973,
            1739051417, 2393774399, 250035802,  1986226858, 4118320101, 3899157617, 3679157076,
            2258085991, 551117761,  4267866849, 3679828833, 711086272,  2952963707, 1667866621,
            3662249794, 3405637490, 1343291195, 730888681,  2381246695, 2930510271, 1779803564,
            3781228998, 1787582256, 1236367773, 1817693489, 2431224659, 2484870604, 4151302318,
            2902321811, 1788220652, 4012573268, 1842903369, 2927332301, 1185539274, 2050648011,
            3405161215, 3369636401, 3091858538, 4240555382, 241001958,  400609988,  3163880457,
            1540551653, 2539098607, 3857223520, 2137935937, 803170440,  821275940,  3485313735,
            1451986523, 194431797,  904639695,  1106545578, 1633417190, 4147878244, 62528087,
            4109877399, 578824730,  3671726812, 461571251,  3495516649, 911932439,  2030004973,
            2002341352, 1580354765, 1774462108, 352122318,  977153640,  170033402,  1019387737,
            756528792,  2593565626, 3738143618, 4160516213, 999431451,  4086313763, 4157371578,
            1082026387, 1423352480, 140091634,  526056489,  3300547146, 3089498232, 4266971502,
            3202763095, 82235109,   1061842570, 3666470174, 945994616,  3663992550, 1110270726,
            1804937521, 2774236887, 3776581315, 2203639366, 1840197918, 1564424234, 2276602447,
            928117829,  978199281,  3690913528, 2958793283, 387554009,  2817496615, 375113876,
            3626285597, 2296780370, 2411775612, 1346030561, 1277897939, 1561545830, 1005364336,
            2093159919, 821902776,  1631078873, 63358970,   1185831033, 12264437,   3192617499,
            3872277948, 3918754976, 1471530347, 2010243509, 4011062105, 1291836608, 2767111911,
            2505795417, 1336824946, 1593119272, 3954754615, 902314853,  3478581038, 4027859424,
            1163079365, 2198246306, 1462989647, 2291324146, 932688463,  4018333691, 2374736511,
            3594712587, 3964293916, 4276849132, 3902062310, 3619038368, 2571513800, 42517349,
            3100438883, 1645455709, 1146435746, 140519541,  3964913740, 2422362185, 3338363150,
            3460540392, 226785542,  3275185975, 2655265571, 3789582441, 1288223861, 46428973,
            1739051417, 2393774399, 2257001236, 1986226858, 4118320101, 3899157617, 3679157076,
            3707520907, 551117761,  4267866849, 3679828833, 711086272,  570153549,  1667866621,
            3662249794, 3405637490, 1343291195, 112368058,  2615115584, 2865130041, 357584504,
            528807633,  1816055434, 2854850066, 190222907,  1014915859, 3472967123, 2605782564,
            3353130066, 540430076,  2087143725, 1571283916, 1604766425, 934199876,  3359569795,
            4168578472, 1745876717, 277026333,  2679446726, 3582165485, 3954458991, 2615245404,
            2410035461, 3442004248, 2814474875, 1734556428, 2653422310, 4033890533, 2373774914,
            3011118469, 1276695464, 2995405818, 782363735,  2242531852, 4206829780, 1486885236,
            3764707851, 1945614253, 1147926733, 701960774,  3435251514, 3626050187, 3587799538,
            2399216643, 3217822006, 3600044386, 648239752,  2997947488, 1754097052, 4109638936,
            3413714077, 1038375790, 3394259389, 2284776380, 2711956471, 1278424040, 1272230764,
            3980809660, 1983901240, 894405781,  582621606,  1274260631, 763432985,  1862236664,
            10249416,   3838574116, 1912270458, 3491686662, 2696669149, 312119069,  1812714569,
            2729307370, 3045249652, 303684944,  503720764,  4029412414, 4101616421, 3484358948,
            1261027935, 145713434,  2918444923, 2099546237, 3173693583, 3498398823, 3769717769,
            2860220116, 2919562911, 1221047715, 1749384742, 1018968146, 2771587474, 2746107326,
            1182859751, 2403805226, 2206395932, 1500348209, 1762634532, 3017223998, 2043185588,
            2124568729, 1619852613, 3248258238, 3393223375, 644860154,  2465108160, 2358875673,
            3643741304, 1891106916, 416443047,  3298583974, 1030877276, 2839390034, 4181398645,
            1845333999, 3643365079, 1993116780, 1763857175, 1951718545, 3785659537, 4156412284,
            4138026128, 3480291142, 54280556,   4169041146, 3130638398, 3236816184, 3559898998,
            916420843,  938920758,  3425021599, 1528477728, 3597939783, 3516249439, 936528538,
            4174817780, 2541489033, 3962368135, 2054336507, 2610093970, 3613025255, 3583905994,
            2990129491, 332823408,  2505138276, 3811707598, 373987627,  4263703898, 1668946560,
            3213253899, 2673819338, 1631405099, 3127443274, 549232331,  21447814,   1647238011,
            3093799993, 1922712395,
        },
        {
            2122413555, 1501935702, 1050523791, 3196182564, 764084507,  3198945969, 2157564969,
            138530628,  701759884,  613973673,  2511935260, 1545537227, 2585754014, 1300072673,
            4102735291, 2132538468, 9227136,    2487526897, 2178001572, 138139583,  188855484,
            2363895412, 1957244206, 721664407,  1660933059, 42186377,   2696805582, 697893772,
            760308854,  4248323596, 122312032,  2306006976, 1347594617, 2037176430, 3009032423,
            4099269616, 2288745829, 2983332961, 3793361700, 2106932482, 924207181,  3855521674,
            608900096,  1266576336, 3593451464, 1044062745, 2709063592, 1196371785, 179434282,
            2758946444, 2945544664, 3921058768, 2930666545, 3256480848, 3302488733, 926789334,
            1909499783, 3317159216, 59127738,   1142437216, 402550124,  1646913186, 2243598838,
            19269310,   3619540646, 1792156421, 3796292713, 328027309,  328812623,  1192570653,
            2048121868, 1294330109, 2797137556, 580471777,  1348561528, 3475200915, 1260721827,
            1333676448, 3878926812, 3221064158, 162630917,  3468107267, 3246619217, 2522878033,
            2824757598, 656369950,  2544776243, 2776887137, 928258686,  3522900271, 2866344719,
            1238398788, 1966469089, 770354368,  1672680295, 614485563,  3212198982, 4285763016,
            2763633599, 750199782,  3839060097, 399146410,  1096543682, 2261236339, 35538088,
            3446264,    2328542864, 3415054520, 207512933,  663718812,  777575426,  2229525819,
            2351176626, 585383896,  458505995,  466011010,  1701952407, 747373527,  1529069737,
            4032717844, 2328899586, 268296156,  3227196131, 1951691915, 760470830,  1061475417,
            2588402598, 605333678,  1938868876, 2527921930, 312390696,  1715141104, 2352815776,
            4076939068, 174665551,  1650387629, 738539848,  2126695911, 582127653,  2646961820,
            3330091773, 614531272,  2436130975, 3288770323, 2912644413, 3945151215, 71275219,
            3888511042, 3922064101, 2275590272, 2402725064, 4289926373, 128273593,  1521219295,
            1502438728, 3484868692, 3668863226, 1725792509, 3332573985, 3673471467, 559605521,
            2122413555, 1501935702, 1050523791, 3196182564, 1789908860, 3198945969, 2157564969,
            138530628,  701759884,  3803670279, 2511935260, 1545537227, 2585754014, 1300072673,
            1775878750, 2132538468, 9227136,    2487526897, 2178001572, 2318472218, 188855484,
            2363895412, 1957244206, 721664407,  64860359,   42186377,   2696805582, 697893772,
            760308854,  988657619,  122312032,  2306006976, 1347594617, 2037176430, 3140358103,
            4099269616, 2288745829, 2983332961, 3793361700, 504830303,  924207181,  3855521674,
            608900096,  1266576336, 61045757,   1044062745, 2709063592, 1196371785, 179434282,
            465631388,  2945544664, 3921058768, 2930666545, 3256480848, 572776210,  926789334,
            1909499783, 3317159216, 59127738,   2599282549, 402550124,  1646913186, 2243598838,
            19269310,   3824490674, 1792156421, 3796292713, 328027309,  328812623,  954424825,
            2048121868, 1294330109, 2797137556, 580471777,  518598503,  3475200915, 1260721827,
            1333676448, 3878926812, 965274001,  162630917,  3468107267, 3246619217, 2522878033,
            2809876595, 656369950,  2544776243, 2776887137, 928258686,  1793841329, 2866344719,
            1238398788, 1966469089, 770354368,  2561007916, 614485563,  3212198982, 4285763016,
            2763633599, 2249734430, 3839060097, 399146410,  1096543682, 2261236339, 2228980435,
            3446264,    2328542864, 3415054520, 207512933,  3257366164, 777575426,  2229525819,
            2351176626, 585383896,  173400758,  466011010,  1701952407, 747373527,  1529069737,
            3311807081, 2328899586, 268296156,  3227196131, 1951691915, 2417340669, 1061475417,
            2588402598, 605333678,  1938868876, 1407076161, 312390696,  1715141104, 2352815776,
            4076939068, 2775458681, 1650387629, 738539848,  2126695911, 582127653,  527507805,
            3330091773, 614531272,  2436130975, 3288770323, 2370203625, 3945151215, 71275219,
            3888511042, 3922064101, 2033783217, 2402725064, 4289926373, 128273593,  1521219295,
            3894987922, 3484868692, 3668863226, 1725792509, 3332573985, 3768297054, 559605521,
            2122413555, 1501935702, 1050523791, 2964067018, 1789908860, 3198945969, 2157564969,
            138530628,  614839611,  3803670279, 2511935260, 1545537227, 2585754014, 4087503273,
            1775878750, 2132538468, 9227136,    2487526897, 3287088492, 2318472218, 188855484,
            2363895412, 1957244206, 1862963527, 64860359,   42186377,   2696805582, 697893772,
            482573617,  988657619,  122312032,  2306006976, 1347594617, 934612028,  3140358103,
            4099269616, 2288745829, 2983332961, 3523420735, 504830303,  924207181,  3855521674,
            608900096,  335197460,  61045757,   1044062745, 2709063592, 1196371785, 2822704089,
            465631388,  2945544664, 3921058768, 2930666545, 2747918855, 572776210,  926789334,
            1909499783, 3317159216, 2437152736, 2599282549, 402550124,  1646913186, 2243598838,
            3752524583, 3824490674, 1792156421, 3796292713, 328027309,  1219953987, 954424825,
            2048121868, 1294330109, 2797137556, 4148841232, 518598503,  3475200915, 1260721827,
            1333676448, 929679552,  965274001,  162630917,  3468107267, 3246619217, 2653684049,
            2809876595, 656369950,  2544776243, 2776887137, 123072294,  1793841329, 2866344719,
            1238398788, 1966469089, 2062253604, 2561007916, 614485563,  3212198982, 4285763016,
            2496966131, 2249734430, 3839060097, 399146410,  1096543682, 4004344227, 2228980435,
            3446264,    2328542864, 3415054520, 3814061831, 3257366164, 777575426,  2229525819,
            2351176626, 3151040925, 173400758,  466011010,  1701952407, 747373527,  3208944032,
            3311807081, 2328899586, 268296156,  3227196131, 3271260621, 2417340669, 1061475417,
            2588402598, 605333678,  1982819216, 1407076161, 312390696,  1715141104, 2352815776,
            1930034904, 2775458681, 1650387629, 738539848,  2126695911, 4251988410, 527507805,
            3330091773, 614531272,  2436130975, 667181774,  2370203625, 3945151215, 71275219,
            3888511042, 466082071,  2033783217, 2402725064, 4289926373, 128273593,  2625449989,
            3894987922, 3484868692, 3668863226, 1725792509, 2298400582, 3768297054, 559605521,
            2122413555, 1501935702, 1721393014, 2964067018, 1789908860, 3198945969, 2157564969,
            3471484796, 614839611,  3803670279, 2511935260, 1545537227, 1878824921, 4087503273,
            1775878750, 2132538468, 9227136,    3677322439, 3287088492, 2318472218, 188855484,
            2363895412, 1740167346, 1862963527, 64860359,   42186377,   2696805582, 4214672198,
            482573617,  988657619,  122312032,  2306006976, 2000126554, 934612028,  3140358103,
            4099269616, 2288745829, 2748335917, 3523420735, 504830303,  924207181,  3855521674,
            2357029657, 335197460,  61045757,   1044062745, 2709063592, 1558860518, 2822704089,
            465631388,  2945544664, 3921058768, 2038063566, 2747918855, 572776210,  926789334,
            1909499783, 1454324773, 2437152736, 2599282549, 402550124,  1646913186, 1511747162,
            3752524583, 3824490674, 1792156421, 3796292713, 330014534,  1219953987, 954424825,
            2048121868, 1294330109, 3176315924, 4148841232, 518598503,  3475200915, 1260721827,
            1338988109, 929679552,  965274001,  162630917,  3468107267, 4190661863, 2653684049,
            2809876595, 656369950,  2544776243, 3014845308, 123072294,  1793841329, 2866344719,
            1238398788, 3182664776, 2062253604, 2561007916, 614485563,  3212198982, 3535626698,
            2496966131, 2249734430, 3839060097, 399146410,  2245022026, 4004344227, 2228980435,
            3446264,    2328542864, 836659526,  3814061831, 3257366164, 777575426,  2229525819,
            139355839,  3151040925, 173400758,  466011010,  1701952407, 3652771771, 3208944032,
            3311807081, 2328899586, 268296156,  187635125,  3271260621, 2417340669, 1061475417,
            2588402598, 1622504810, 1982819216, 1407076161, 312390696,  1715141104, 2811645137,
            1930034904, 2775458681, 1650387629, 738539848,  1147514971, 4251988410, 527507805,
            3330091773, 614531272,  3006420812, 667181774,  2370203625, 3945151215, 71275219,
            3447875589, 466082071,  2033783217, 2402725064, 4289926373, 3267614542, 2625449989,
            3894987922, 3484868692, 3668863226, 3153741038, 3563913741, 4005591601, 3992372564,
            2184210423, 3800038584, 3941644930, 1346476565, 3229467727, 3563589325, 1659250833,
            3803280838, 2039847833, 3840260838, 176063187,  1736218124, 1177793751, 2322199388,
            1038384710, 830046863,  3882453413, 3661028962, 577525876,  289920848,  3314465113,
            1846876492, 169685597,  4203972902, 2864300083, 2839100483, 1321073195, 3212925796,
            2143766136, 2065837865, 1964493860, 1320400130, 1073225250, 3730067268, 1938163885,
            2498770913, 3866110720, 1001814906, 3105528638, 3750288053, 3084486576, 61928355,
            2676238908, 1408760274, 16993017,   2912868831, 168454665,  3699728429, 1040768642,
            159364717,  1060737123, 108800378,  3591986522, 385632318,  321117372,  541715379,
            2115376983, 1353695867, 2022004948, 1598494024, 4167208650, 273265286,  3750323962,
            1364707542, 2460397887, 2104609669, 2321897666, 1253225846, 750227571,  2581026774,
            62295165,   2837386734, 1663893347, 670845840,  72849881,   2104195547, 2014767369,
            3110692175, 3174017769, 2967205614, 1186315652, 2514205222, 1366578443, 537157979,
            2231720383, 162926160,  3548148466, 783425606,  2374212188, 3765569447, 2403941435,
            2002867865, 3013279715, 1027800366, 3055532945, 410778284,  2393954827, 858720102,
            880588182,  4292855407, 265892766,  1030194122, 4015797505, 41576599,   2880192241,
            3711511746, 1316794824, 2758038844, 119162186,  3320039571, 2510685734, 2034775346,
            4097015017, 335062931,  2328104710, 2265115591, 1864547495, 2475106051, 1304120039,
            349543792,  494694865,  1475078017, 59452469,   755883189,  1990297547, 253417464,
            3687222706, 1076619121, 14613325,   2115834551, 950475157,  2234855268, 1545259751,
            2473151011, 369108803,  3161542501, 622689311,  1635306564, 2617835006, 2205801635,
            1157953118, 1599069697, 3967650125, 3417959299, 1191150698, 2916728453, 4216856489,
            920287148,  756919995,  1411694346, 3675395010, 2126096722, 3162144284, 537349657,
            3358556811, 127492831,
        },
        {
            4224788259, 3569487556, 1080137041, 2788623569, 856160888,  2195536417, 3030463035,
            2906439247, 896055051,  1967105456, 2093562169, 2919742950, 546374698,  1372591815,
            3773616637, 349073007,  1331102855, 3035367896, 1222622311, 2266618592, 74466398,
            1140488004, 855606859,  3803728487, 3589743162, 2748402856, 1044387368, 1494850922,
            2242660891, 3111566003, 2013737074, 163276737,  1526772858, 3047139947, 3150695453,
            2583795468, 3628272447, 305282258,  2151108134, 2905708853, 1052800761, 3354632338,
            1017036861, 2453680791, 2673902555, 1622154585, 2893733051, 3888482522, 306284440,
            3245137245, 3480776670, 2865396581, 3571456526, 3284891766, 1393584874, 1057867320,
            2888126310, 3302325443, 4135187530, 1770789166, 1615533805, 1438727397, 2921922012,
            3156703516, 435047591,  2999350446, 575044884,  1001339111, 625824120,  2489346227,
            2104489492, 2494528446, 1141458836, 4048430074, 2599022749, 2438694106, 1443850072,
            3321658999, 87870515,   958195816,  380666771,  3062272732, 4178548642, 4274603044,
            888566831,  3386636024, 1636806704, 2400069397, 3003029365, 1953620944, 3278772216,
            1562778171, 2767090642, 14436957,   913966574,  1724553886, 2015261135, 4191296122,
            1688939147, 110865735,  2913800286, 4131469475, 315962755,  1531174227, 1226678476,
            3446400266, 3896297836, 539834883,  2871306264, 3333932675, 2229436010, 1928458456,
            464682640,  1786180352, 162599143,  817038005,  3146256537, 1676400403, 2484731087,
            702610427,  4005124049, 1691076958, 1268494739, 4093608833, 3757213737, 2627839929,
            2884764386, 1548110665, 3361745333, 3955318088, 3264527857, 3969225726, 968269281,
            2630991382, 2716444139, 1071781623, 3704437685, 1511193802, 843840414,  1277966236,
            4141095880, 715016637,  1255888181, 1321941951, 1180174408, 1021629824, 3395369301,
            3912221525, 2611782663, 4038117717, 2253029302, 974431991,  347200257,  886823557,
            2275848777, 3732452739, 3708953729, 2688020866, 4185175489, 99605353,   2387945286,
            4224788259, 3569487556, 1080137041, 2788623569, 238715294,  2195536417, 3030463035,
            2906439247, 896055051,  3061240402, 2093562169, 2919742950, 546374698,  1372591815,
            851057115,  349073007,  1331102855, 3035367896, 1222622311, 3305595574, 74466398,
            1140488004, 855606859,  3803728487, 3838112757, 2748402856, 1044387368, 1494850922,
            2242660891, 1038286760, 2013737074, 163276737,  1526772858, 3047139947, 3518918891,
            2583795468, 3628272447, 305282258,  2151108134, 3555155951, 1052800761, 3354632338,
            1017036861, 2453680791, 2394691836, 1622154585, 2893733051, 3888482522, 306284440,
            2055552069, 3480776670, 2865396581, 3571456526, 3284891766, 1179339312, 1057867320,
            2888126310, 3302325443, 4135187530, 683364318,  1615533805, 1438727397, 2921922012,
            3156703516, 1333086260, 2999350446, 575044884,  1001339111, 625824120,  576119652,
            2104489492, 2494528446, 1141458836, 4048430074, 786660788,  2438694106, 1443850072,
            3321658999, 87870515,   457955380,  380666771,  3062272732, 4178548642, 4274603044,
            2256710588, 3386636024, 1636806704, 2400069397, 3003029365, 3733049985, 3278772216,
            1562778171, 2767090642, 14436957,   530062778,  1724553886, 2015261135, 4191296122,
            1688939147, 2981240708, 2913800286, 4131469475, 315962755,  1531174227, 2433363617,
            3446400266, 3896297836, 539834883,  2871306264, 2597546929, 2229436010, 1928458456,
            464682640,  1786180352, 1165821797, 817038005,  3146256537, 1676400403, 2484731087,
            3239493343, 4005124049, 1691076958, 1268494739, 4093608833, 2088690204, 2627839929,
            2884764386, 1548110665, 3361745333, 1075350364, 3264527857, 3969225726, 968269281,
            2630991382, 4103280359, 1071781623, 3704437685, 1511193802, 843840414,  1340474980,
            4141095880, 715016637,  1255888181, 1321941951, 2512565938, 1021629824, 3395369301,
            3912221525, 2611782663, 2287272047, 2253029302, 974431991,  347200257,  886823557,
            3775715445, 3732452739, 3708953729, 2688020866, 4185175489, 2151114047, 2387945286,
            4224788259, 3569487556, 1080137041, 879682447,  238715294,  2195536417, 3030463035,
            2906439247, 3975397430, 3061240402, 2093562169, 2919742950, 546374698,  1928060945,
            851057115,  349073007,  1331102855, 3035367896, 1148668613, 3305595574, 74466398,
            1140488004, 855606859,  917923571,  3838112757, 2748402856, 1044387368, 1494850922,
            995791756,  1038286760, 2013737074, 163276737,  1526772858, 1944370085, 3518918891,
            2583795468, 3628272447, 305282258,  685261037,  3555155951, 1052800761, 3354632338,
            1017036861, 1620076466, 2394691836, 1622154585, 2893733051, 3888482522, 4119309151,
            2055552069, 3480776670, 2865396581, 3571456526, 4008552940, 1179339312, 1057867320,
            2888126310, 3302325443, 2359989247, 683364318,  1615533805, 1438727397, 2921922012,
            2092991022, 1333086260, 2999350446, 575044884,  1001339111, 2406217399, 576119652,
            2104489492, 2494528446, 1141458836, 1856565466, 786660788,  2438694106, 1443850072,
            3321658999, 2752588925, 457955380,  380666771,  3062272732, 4178548642, 1354877973,
            2256710588, 3386636024, 1636806704, 2400069397, 2275777233, 3733049985, 3278772216,
            1562778171, 2767090642, 3438624166, 530062778,  1724553886, 2015261135, 4191296122,
            3842215040, 2981240708, 2913800286, 4131469475, 315962755,  2891870900, 2433363617,
            3446400266, 3896297836, 539834883,  1390877376, 2597546929, 2229436010, 1928458456,
            464682640,  1405678725, 1165821797, 817038005,  3146256537, 1676400403, 9522151,
            3239493343, 4005124049, 1691076958, 1268494739, 4076978821, 2088690204, 2627839929,
            2884764386, 1548110665, 3713129550, 1075350364, 3264527857, 3969225726, 968269281,
            2669129178, 4103280359, 1071781623, 3704437685, 1511193802, 2032747975, 1340474980,
            4141095880, 715016637,  1255888181, 1290704077, 2512565938, 1021629824, 3395369301,
            3912221525, 767420943,  2287272047, 2253029302, 974431991,  347200257,  940587649,
            3775715445, 3732452739, 3708953729, 2688020866, 1603856534, 2151114047, 2387945286,
            4224788259, 3569487556, 4060395365, 879682447,  238715294,  2195536417, 3030463035,
            774839173,  3975397430, 3061240402, 2093562169, 2919742950, 77503099,   1928060945,
            851057115,  349073007,  1331102855, 4216140027, 1148668613, 3305595574, 74466398,
            1140488004, 1728766104, 917923571,  3838112757, 2748402856, 1044387368, 1408900577,
            995791756,  1038286760, 2013737074, 163276737,  936142172,  1944370085, 3518918891,
            2583795468, 3628272447, 1701372078, 685261037,  3555155951, 1052800761, 3354632338,
            2951922777, 1620076466, 2394691836, 1622154585, 2893733051, 2494523614, 4119309151,
            2055552069, 3480776670, 2865396581, 3031455484, 4008552940, 1179339312, 1057867320,
            2888126310, 2970791558, 2359989247, 683364318,  1615533805, 1438727397, 3697460033,
            2092991022, 1333086260, 2999350446, 575044884,  2712063736, 2406217399, 576119652,
            2104489492, 2494528446, 1096189230, 1856565466, 786660788,  2438694106, 1443850072,
            3615481975, 2752588925, 457955380,  380666771,  3062272732, 2387056252, 1354877973,
            2256710588, 3386636024, 1636806704, 517188972,  2275777233, 3733049985, 3278772216,
            1562778171, 3436331606, 3438624166, 530062778,  1724553886, 2015261135, 1711407722,
            3842215040, 2981240708, 2913800286, 4131469475, 878455086,  2891870900, 2433363617,
            3446400266, 3896297836, 4251949215, 1390877376, 2597546929, 2229436010, 1928458456,
            719826541,  1405678725, 1165821797, 817038005,  3146256537, 3883590627, 9522151,
            3239493343, 4005124049, 1691076958, 893183073,  4076978821, 2088690204, 2627839929,
            2884764386, 3312769297, 3713129550, 1075350364, 3264527857, 3969225726, 4161107579,
            2669129178, 4103280359, 1071781623, 3704437685, 1400940789, 2032747975, 1340474980,
            4141095880, 715016637,  1705234794, 1290704077, 2512565938, 1021629824, 3395369301,
            2934074199, 767420943,  2287272047, 2253029302, 974431991,  3060035390, 940587649,
            3775715445, 3732452739, 3708953729, 3489160434, 3200799223, 340420813,  2539294182,
            2619616318, 456806966,  4272538790, 2994564124, 2757588894, 3493053179, 2946195469,
            1402305257, 2266356503, 3512914478, 273195440,  3579761455, 862317458,  1894959361,
            42596779,   376641729,  782820755,  716528645,  222675565,  4038035195, 311038326,
            395780597,  2025474869, 404396572,  4138962756, 2441107014, 3525378401, 947085768,
            3758218091, 3185789607, 638283508,  3802505926, 830259842,  1086400881, 3444485,
            142418107,  4283468141, 1669846189, 955065888,  3864384467, 73139517,   136809048,
            1444329434, 174974637,  3303183786, 282216656,  3114827080, 3811060015, 1610640996,
            3824096289, 1123437514, 3826582808, 39407702,   2437666463, 2454206642, 830758422,
            4190092654, 1941090912, 224373276,  3704201239, 3284012568, 4056152539, 1022047941,
            1077111803, 3028336675, 3207391465, 3459202233, 1991240724, 4184491520, 1851863093,
            1038639595, 1392247730, 2113875749, 1162388509, 2629935260, 3545260772, 991928712,
            4064775043, 4180493781, 2134685922, 642853690,  290065503,  1629968,    3150373868,
            3110755428, 2254306163, 421928533,  11426979,   3042809169, 786868170,  1287942583,
            1851107769, 1444903906, 4150950197, 3737798306, 2848738554, 505924220,  2944131627,
            2639930627, 1339887691, 2382166850, 2668971315, 3944739049, 2217612340, 4142682607,
            997824216,  123465626,  844518179,  1161486362, 2706162053, 2966530827, 4103639053,
            1837121393, 909648429,  298619078,  2057042454, 3613272637, 3609349032, 1664428748,
            1871510359, 58508710,   1079418100, 3278870121, 3821562746, 16654909,   2530580589,
            3361874982, 629910009,  2124761646, 2508133604, 1954315500, 3019833617, 141617625,
            1653192078, 1541695589, 1223978475, 3875963510, 3028691587, 3450826564, 2185849120,
            1956475624, 3053842172, 3550887830, 2672339803, 176823785,  913229929,  681399502,
            2256486297, 2881672598, 597153273,  2782767695, 1133158067, 4126077325, 3456027404,
            754062201,  4069172986,
        },
        {
            2566203297, 2937505590, 2000252378, 449347686,  140254824,  2102978518, 1316675243,
            3362716297, 1756094023, 1713907509, 4205784705, 131558140,  4261242680, 1877446032,
            1392754886, 2906420324, 1553488742, 1119223375, 3706668271, 1475167658, 2723094053,
            1174184750, 4096788627, 3116732456, 4167780994, 2426547343, 3672103725, 130666720,
            2334194901, 1923332861, 3817985643, 1011407365, 3341470703, 1249610232, 3457137041,
            43329326,   1132491441, 184660457,  451230244,  2093302321, 2774161545, 3764338209,
            2208753900, 1302510297, 2091887259, 3079702881, 4188184716, 4241066649, 3115371445,
            2347030401, 383918884,  1855913368, 4073305816, 2816324235, 1586282220, 476273748,
            3178758271, 3844191861, 2665723266, 519574908,  4036399335, 309884960,  442803422,
            2227257071, 2904677088, 1996497647, 1075562816, 4126338487, 922525457,  376262841,
            1164091982, 2635886285, 2240076656, 2157078748, 3312434287, 400631517,  2687340025,
            4214702692, 1474606348, 2408230133, 1919555964, 570496447,  288768730,  2960784327,
            182402586,  3411290746, 3923558314, 1450018140, 650657583,  117586302,  2475608376,
            3545846161, 2275959213, 3696777093, 2141253388, 1609947205, 2158870352, 2205033491,
            510060695,  2573779438, 3784534156, 1280398564, 597518565,  2101084042, 4116707152,
            3522477106, 3109825553, 3512223611, 880848769,  1206987311, 4187187090, 2708558099,
            2319145807, 763193369,  1459380001, 851562650,  1330810313, 379414737,  1201711693,
            2821308311, 210263641,  2994615537, 2605458985, 1813179178, 3288033074, 3157497639,
            2411886437, 976346804,  3316878968, 3347676379, 1719563154, 2965908376, 3751587384,
            2386401861, 3706213180, 396871296,  3196547983, 855907618,  3227129493, 3592896983,
            2967211613, 3195532484, 4019823338, 2871614475, 1419892487, 467166844,  422143799,
            2642634372, 3277531433, 701640948,  1442090382, 2424046544, 1959815742, 4148380588,
            2412084790, 3275617784, 3405869919, 1583279699, 2876854951, 697329784,  3141191240,
            2566203297, 2937505590, 2000252378, 449347686,  1699005848, 2102978518, 1316675243,
            3362716297, 1756094023, 1419991703, 4205784705, 131558140,  4261242680, 1877446032,
            4232224233, 2906420324, 1553488742, 1119223375, 3706668271, 1547843975, 2723094053,
            1174184750, 4096788627, 3116732456, 4172258954, 2426547343, 3672103725, 130666720,
            2334194901, 412923769,  3817985643, 1011407365, 3341470703, 1249610232, 2681770646,
            43329326,   1132491441, 184660457,  451230244,  2267576050, 2774161545, 3764338209,
            2208753900, 1302510297, 3047194032, 3079702881, 4188184716, 4241066649, 3115371445,
            2851609329, 383918884,  1855913368, 4073305816, 2816324235, 3803411720, 476273748,
            3178758271, 3844191861, 2665723266, 689178555,  4036399335, 309884960,  442803422,
            2227257071, 4224087946, 1996497647, 1075562816, 4126338487, 922525457,  909702590,
            1164091982, 2635886285, 2240076656, 2157078748, 2102331065, 400631517,  2687340025,
            4214702692, 1474606348, 1991865827, 1919555964, 570496447,  288768730,  2960784327,
            4199791795, 3411290746, 3923558314, 1450018140, 650657583,  3840894521, 2475608376,
            3545846161, 2275959213, 3696777093, 3867181049, 1609947205, 2158870352, 2205033491,
            510060695,  949102151,  3784534156, 1280398564, 597518565,  2101084042, 3733707895,
            3522477106, 3109825553, 3512223611, 880848769,  3059453471, 4187187090, 2708558099,
            2319145807, 763193369,  2784942418, 851562650,  1330810313, 379414737,  1201711693,
            3808266357, 210263641,  2994615537, 2605458985, 1813179178, 4120383275, 3157497639,
            2411886437, 976346804,  3316878968, 1945798022, 1719563154, 2965908376, 3751587384,
            2386401861, 3238627341, 396871296,  3196547983, 855907618,  3227129493, 4201580357,
            2967211613, 3195532484, 4019823338, 2871614475, 1569431196, 467166844,  422143799,
            2642634372, 3277531433, 3387634029, 1442090382, 2424046544, 1959815742, 4148380588,
            378115374,  3275617784, 3405869919, 1583279699, 2876854951, 136894864,  3141191240,
            2566203297, 2937505590, 2000252378, 455947869,  1699005848, 2102978518, 1316675243,
            3362716297, 922404533,  1419991703, 4205784705, 131558140,  4261242680, 1892616255,
            4232224233, 2906420324, 1553488742, 1119223375, 3359896478, 1547843975, 2723094053,
            1174184750, 4096788627, 1076186435, 4172258954, 2426547343, 3672103725, 130666720,
            2290683982, 412923769,  3817985643, 1011407365, 3341470703, 2138528348, 2681770646,
            43329326,   1132491441, 184660457,  1126054633, 2267576050, 2774161545, 3764338209,
            2208753900, 1619035664, 3047194032, 3079702881, 4188184716, 4241066649, 3965864510,
            2851609329, 383918884,  1855913368, 4073305816, 527182308,  3803411720, 476273748,
            3178758271, 3844191861, 326870105,  689178555,  4036399335, 309884960,  442803422,
            1877352296, 4224087946, 1996497647, 1075562816, 4126338487, 4136789295, 909702590,
            1164091982, 2635886285, 2240076656, 145820703,  2102331065, 400631517,  2687340025,
            4214702692, 3195577635, 1991865827, 1919555964, 570496447,  288768730,  3263765995,
            4199791795, 3411290746, 3923558314, 1450018140, 3585952223, 3840894521, 2475608376,
            3545846161, 2275959213, 2022153328, 3867181049, 1609947205, 2158870352, 2205033491,
            3827723281, 949102151,  3784534156, 1280398564, 597518565,  2364934392, 3733707895,
            3522477106, 3109825553, 3512223611, 3485388503, 3059453471, 4187187090, 2708558099,
            2319145807, 3753129808, 2784942418, 851562650,  1330810313, 379414737,  4274335425,
            3808266357, 210263641,  2994615537, 2605458985, 4127766703, 4120383275, 3157497639,
            2411886437, 976346804,  3044579190, 1945798022, 1719563154, 2965908376, 3751587384,
            2563006299, 3238627341, 396871296,  3196547983, 855907618,  1991546214, 4201580357,
            2967211613, 3195532484, 4019823338, 2823297974, 1569431196, 467166844,  422143799,
            2642634372, 1374727538, 3387634029, 1442090382, 2424046544, 1959815742, 211749424,
            378115374,  3275617784, 3405869919, 1583279699, 520161797,  136894864,  3141191240,
            2566203297, 2937505590, 705932813,  455947869,  1699005848, 2102978518, 1316675243,
            1681577167, 922404533,  1419991703, 4205784705, 131558140,  2538252038, 1892616255,
            4232224233, 2906420324, 1553488742, 2228095580, 3359896478, 1547843975, 2723094053,
            1174184750, 640543753,  1076186435, 4172258954, 2426547343, 3672103725, 287173138,
            2290683982, 412923769,  3817985643, 1011407365, 637722677,  2138528348, 2681770646,
            43329326,   1132491441, 3838518537, 1126054633, 2267576050, 2774161545, 3764338209,
            2723512771, 1619035664, 3047194032, 3079702881, 4188184716, 636266410,  3965864510,
            2851609329, 383918884,  1855913368, 1647912685, 527182308,  3803411720, 476273748,
            3178758271, 502545271,  326870105,  689178555,  4036399335, 309884960,  1883009905,
            1877352296, 4224087946, 1996497647, 1075562816, 1405416886, 4136789295, 909702590,
            1164091982, 2635886285, 4123875740, 145820703,  2102331065, 400631517,  2687340025,
            226668438,  3195577635, 1991865827, 1919555964, 570496447,  3572301885, 3263765995,
            4199791795, 3411290746, 3923558314, 709877968,  3585952223, 3840894521, 2475608376,
            3545846161, 111160916,  2022153328, 3867181049, 1609947205, 2158870352, 3029588019,
            3827723281, 949102151,  3784534156, 1280398564, 1171136071, 2364934392, 3733707895,
            3522477106, 3109825553, 272364591,  3485388503, 3059453471, 4187187090, 2708558099,
            2061767583, 3753129808, 2784942418, 851562650,  1330810313, 3361304416, 4274335425,
            3808266357, 210263641,  2994615537, 902000332,  4127766703, 4120383275, 3157497639,
            2411886437, 732224725,  3044579190, 1945798022, 1719563154, 2965908376, 689330953,
            2563006299, 3238627341, 396871296,  3196547983, 1911813346, 1991546214, 4201580357,
            2967211613, 3195532484, 3267005697, 2823297974, 1569431196, 467166844,  422143799,
            1303796450, 1374727538, 3387634029, 1442090382, 2424046544, 441666287,  211749424,
            378115374,  3275617784, 3405869919, 582327678,  1145977759, 3076538599, 137498423,
            2619056845, 2376292936, 863458885,  2913517697, 7213407,    3537823998, 3285812451,
            4212763852, 3305316038, 1715877482, 1885855486, 1796745513, 1910351406, 2955678512,
            1025108164, 294680328,  2046471396, 4211516136, 73959832,   215779931,  277210501,
            2496111104, 2247270553, 3363968070, 2951224951, 2429076517, 1559952608, 148927679,
            4159074875, 3968779797, 349875057,  2374969345, 2973678881, 1903650333, 2176183208,
            3623702083, 103941200,  925751534,  1425422916, 3189142011, 3845059353, 924380816,
            223738268,  2680526011, 2944595677, 71911165,   1158111821, 2005866186, 66323287,
            465943311,  2913905021, 447968533,  3208544608, 1863982883, 1423803077, 3479285890,
            3587504567, 549836867,  1841839437, 4267891307, 3128131709, 2551748303, 4061195063,
            2246516694, 475740481,  4065701888, 392483629,  2551799715, 2982781609, 2693345622,
            1220519210, 3350516376, 3477649319, 3648317678, 2279566867, 1866723503, 3907328643,
            1584808279, 3133071517, 3028798193, 2493659038, 439619209,  403827593,  1652183325,
            2567875502, 2808290500, 3703142712, 3745683493, 662201921,  2907977266, 555750471,
            4247862435, 512578390,  602177604,  4286429281, 1324920139, 3138516034, 1521485033,
            2021678991, 1380967443, 524716090,  3603490109, 3101861759, 19351040,   4114193680,
            3123078295, 699662797,  763869115,  1858287178, 536537933,  4259413115, 3843834273,
            1173245794, 974735324,  4000370031, 698417021,  1429350552, 3323344759, 308125147,
            2895774885, 105335986,  736386053,  892594567,  714409831,  2666218933, 1052049911,
            336085593,  2365214502, 3345109784, 461959332,  453874785,  3658882396, 2688761838,
            1905742817, 4111590024, 2981136450, 1534947471, 713983085,  1547309323, 2790594126,
            378083347,  722787150,  3920516687, 1105612281, 476959589,  129348889,  3008811434,
            4276128584, 2937071162, 1727731543, 856660697,  1396931003, 1225798484, 1167014244,
            1392946250, 2419808690,
        },
        {
            2441935114, 3465447683, 2897229686, 3845380309, 1199633364, 495424232,  2490548037,
            581670528,  2467171733, 2200094863, 2163927790, 3895792830, 2097210789, 1606544633,
            1305562517, 4072525389, 3256142090, 349440478,  3920932491, 2462464051, 1075951496,
            2835763703, 1593198055, 2380945625, 543531323,  3182766507, 2927484354, 2877470578,
            4153923603, 2443156156, 1168544900, 888955615,  3605412824, 1336677864, 3256116974,
            2884036014, 4070749843, 2989661773, 1095584023, 1370834065, 3534389580, 312378113,
            3190819203, 1247574926, 2046019470, 3536918510, 1479030180, 847820646,  3992973956,
            3827223401, 4113429617, 3504933502, 295000614,  2238923504, 3485717254, 290246351,
            1064210816, 2848539559, 2617134888, 422213010,  2796674561, 3568250500, 2736237915,
            3950756060, 1527249993, 3603540278, 4115393386, 2851621193, 4230341156, 905168850,
            3916344126, 1496013046, 206343742,  2894205125, 1082918859, 2746480417, 3077328661,
            1209440053, 3258293856, 1032236533, 3043332566, 446879604,  587022214,  1614371566,
            3040899994, 3686422145, 937325128,  1968833679, 169086151,  4075432555, 1196046411,
            3101745581, 4228079966, 2942213563, 1195005323, 1673491641, 1762746534, 3641827252,
            694590905,  1828365460, 513716230,  3106485486, 2441593994, 4044462965, 3628121101,
            3957990629, 179764922,  579361186,  3474393871, 2474241006, 4031850878, 3120409532,
            4011587898, 3682942579, 3257272830, 3097029759, 2652540191, 1128762588, 1040256382,
            2743736716, 334893087,  1892049031, 2603159239, 3712772023, 2126593224, 3465793906,
            3180780589, 725740783,  3728108967, 573931936,  137996587,  110756053,  3984787930,
            3773232816, 3406981985, 1783088630, 2080089781, 195827466,  1409073281, 867635355,
            3049533211, 486687054,  2570137956, 527522011,  1084454084, 1019222771, 1415565066,
            650794786,  629618803,  1237709131, 1241899078, 2751644247, 2792313337, 649402117,
            275078659,  752459111,  2173220853, 3207031798, 821073585,  3005400729, 1085152012,
            2441935114, 3465447683, 2897229686, 3845380309, 3573898488, 495424232,  2490548037,
            581670528,  2467171733, 1208279791, 2163927790, 3895792830, 2097210789, 1606544633,
            2148733343, 4072525389, 3256142090, 349440478,  3920932491, 657289255,  1075951496,
            2835763703, 1593198055, 2380945625, 149487931,  3182766507, 2927484354, 2877470578,
            4153923603, 606130344,  1168544900, 888955615,  3605412824, 1336677864, 53448770,
            2884036014, 4070749843, 2989661773, 1095584023, 2766144383, 3534389580, 312378113,
            3190819203, 1247574926, 1530609481, 3536918510, 1479030180, 847820646,  3992973956,
            154171325,  4113429617, 3504933502, 295000614,  2238923504, 282708664,  290246351,
            1064210816, 2848539559, 2617134888, 36906646,   2796674561, 3568250500, 2736237915,
            3950756060, 3416260072, 3603540278, 4115393386, 2851621193, 4230341156, 448215287,
            3916344126, 1496013046, 206343742,  2894205125, 2420861244, 2746480417, 3077328661,
            1209440053, 3258293856, 2545287695, 3043332566, 446879604,  587022214,  1614371566,
            958587333,  3686422145, 937325128,  1968833679, 169086151,  154576725,  1196046411,
            3101745581, 4228079966, 2942213563, 2487464668, 1673491641, 1762746534, 3641827252,
            694590905,  3754606623, 513716230,  3106485486, 2441593994, 4044462965, 3064108377,
            3957990629, 179764922,  579361186,  3474393871, 2138270428, 4031850878, 3120409532,
            4011587898, 3682942579, 4015980199, 3097029759, 2652540191, 1128762588, 1040256382,
            3908621649, 334893087,  1892049031, 2603159239, 3712772023, 3291038350, 3465793906,
            3180780589, 725740783,  3728108967, 436976908,  137996587,  110756053,  3984787930,
            3773232816, 1000054791, 1783088630, 2080089781, 195827466,  1409073281, 3036813614,
            3049533211, 486687054,  2570137956, 527522011,  3669951690, 1019222771, 1415565066,
            650794786,  629618803,  4140569538, 1241899078, 2751644247, 2792313337, 649402117,
            2946582304, 752459111,  2173220853, 3207031798, 821073585,  1738142977, 1085152012,
            2441935114, 3465447683, 2897229686, 2707197334, 3573898488, 495424232,  2490548037,
            581670528,  2365865647, 1208279791, 2163927790, 3895792830, 2097210789, 3219551420,
            2148733343, 4072525389, 3256142090, 349440478,  3706519197, 657289255,  1075951496,
            2835763703, 1593198055, 2200084531, 149487931,  3182766507, 2927484354, 2877470578,
            2394288661, 606130344,  1168544900, 888955615,  3605412824, 1503975597, 53448770,
            2884036014, 4070749843, 2989661773, 243605110,  2766144383, 3534389580, 312378113,
            3190819203, 2398088088, 1530609481, 3536918510, 1479030180, 847820646,  2940281320,
            154171325,  4113429617, 3504933502, 295000614,  3078701806, 282708664,  290246351,
            1064210816, 2848539559, 3960345380, 36906646,   2796674561, 3568250500, 2736237915,
            2657034787, 3416260072, 3603540278, 4115393386, 2851621193, 3847740427, 448215287,
            3916344126, 1496013046, 206343742,  3419083433, 2420861244, 2746480417, 3077328661,
            1209440053, 3824237152, 2545287695, 3043332566, 446879604,  587022214,  506352928,
            958587333,  3686422145, 937325128,  1968833679, 1808935939, 154576725,  1196046411,
            3101745581, 4228079966, 709576348,  2487464668, 1673491641, 1762746534, 3641827252,
            3968332142, 3754606623, 513716230,  3106485486, 2441593994, 1453443785, 3064108377,
            3957990629, 179764922,  579361186,  1454621561, 2138270428, 4031850878, 3120409532,
            4011587898, 898119245,  4015980199, 3097029759, 2652540191, 1128762588, 1131456853,
            3908621649, 334893087,  1892049031, 2603159239, 4280222837, 3291038350, 3465793906,
            3180780589, 725740783,  1515867399, 436976908,  137996587,  110756053,  3984787930,
            1295994548, 1000054791, 1783088630, 2080089781, 195827466,  252558267,  3036813614,
            3049533211, 486687054,  2570137956, 786434419,  3669951690, 1019222771, 1415565066,
            650794786,  1316734597, 4140569538, 1241899078, 2751644247, 2792313337, 4014748337,
            2946582304, 752459111,  2173220853, 3207031798, 2903407363, 1738142977, 1085152012,
            2441935114, 3465447683, 1082984764, 2707197334, 3573898488, 495424232,  2490548037,
            240094068,  2365865647, 1208279791, 2163927790, 3895792830, 1107651215, 3219551420,
            2148733343, 4072525389, 3256142090, 681942656,  3706519197, 657289255,  1075951496,
            2835763703, 2172774506, 2200084531, 149487931,  3182766507, 2927484354, 3069592433,
            2394288661, 606130344,  1168544900, 888955615,  757163746,  1503975597, 53448770,
            2884036014, 4070749843, 1705538727, 243605110,  2766144383, 3534389580, 312378113,
            2256467250, 2398088088, 1530609481, 3536918510, 1479030180, 1360826079, 2940281320,
            154171325,  4113429617, 3504933502, 714934244,  3078701806, 282708664,  290246351,
            1064210816, 3694453051, 3960345380, 36906646,   2796674561, 3568250500, 3400481963,
            2657034787, 3416260072, 3603540278, 4115393386, 1466632735, 3847740427, 448215287,
            3916344126, 1496013046, 2893537514, 3419083433, 2420861244, 2746480417, 3077328661,
            2815979224, 3824237152, 2545287695, 3043332566, 446879604,  3719452721, 506352928,
            958587333,  3686422145, 937325128,  2653904510, 1808935939, 154576725,  1196046411,
            3101745581, 425411544,  709576348,  2487464668, 1673491641, 1762746534, 1960605594,
            3968332142, 3754606623, 513716230,  3106485486, 2881551071, 1453443785, 3064108377,
            3957990629, 179764922,  1408218536, 1454621561, 2138270428, 4031850878, 3120409532,
            3700386494, 898119245,  4015980199, 3097029759, 2652540191, 2181464767, 1131456853,
            3908621649, 334893087,  1892049031, 4220220071, 4280222837, 3291038350, 3465793906,
            3180780589, 1737123182, 1515867399, 436976908,  137996587,  110756053,  1360813614,
            1295994548, 1000054791, 1783088630, 2080089781, 1019367341, 252558267,  3036813614,
            3049533211, 486687054,  387915679,  786434419,  3669951690, 1019222771, 1415565066,
            4267042909, 1316734597, 4140569538, 1241899078, 2751644247, 3622120385, 4014748337,
            2946582304, 752459111,  2173220853, 1128460687, 2268047031, 239933818,  4141570430,
            1318816940, 2378987660, 731877825,  3950952879, 2975574698, 2938375136, 431933385,
            154404673,  2020658234, 846815781,  822137193,  1057315444, 3632584082, 3263363094,
            942201956,  2704683551, 1768107067, 4009446092, 3090701064, 701246680,  3548419575,
            3873366129, 1639833080, 2401253373, 66597794,   2515774132, 516246524,  4232115668,
            34426096,   2206423458, 3628832867, 2776950121, 2782943544, 2058958317, 1805852726,
            2151415233, 2940074103, 2318397273, 3067676663, 3127709351, 71509976,   115529187,
            1841252918, 2217805156, 733917373,  2432474677, 1416887641, 1895320369, 2779694586,
            510547269,  2614743018, 759552691,  2264773752, 305497497,  1082013785, 1681067734,
            1085957001, 846460632,  2824079919, 1820633139, 3686495295, 3978521319, 1734452426,
            4105472656, 1771256166, 1578071897, 1972844727, 2048372515, 3002132226, 1889169118,
            2932142799, 2166712623, 592016143,  1116895096, 889321536,  375621825,  2935845994,
            1982459859, 3336799370, 294519309,  2661638345, 1089335942, 227150969,  1454919198,
            3780503305, 1862290968, 1491836299, 766546986,  3638407467, 925906735,  208891816,
            236714698,  2853181150, 3889751556, 2161215392, 853579433,  2131555681, 1396396345,
            1088128136, 978252562,  2134024308, 2429920974, 1159468871, 2395949266, 1441791888,
            916521377,  3950270431, 2663319810, 3873120593, 2080989388, 2896532502, 3176181708,
            1736685126, 4081767288, 3515770288, 1371473598, 1491850178, 4284949727, 2774513541,
            1541596000, 3948112869, 2114538326, 2641532252, 1837244955, 2292505300, 3179787565,
            639953781,  785902378,  3852544833, 553508260,  23014564,   106722100,  2705412979,
            3449440367, 950636401,  870804158,  629831074,  424163855,  373653940,  2739378330,
            377730945,  418426029,  267367218,  554678849,  4222664331, 3346048120, 1870226737,
            2435616108, 3747040233, 698046507,  1671346285, 4127293033, 568612264,  3467142937,
            1627988025, 1305525598,
        },
        {
            898719058,  2811876829, 1999601908, 1320942380, 212807712,  1099229426, 1854524064,
            3078480380, 3207682961, 251487914,  2992570967, 1865813877, 3146364013, 532408631,
            824040842,  3705935851, 1669209985, 1740573991, 3371466293, 633183282,  2623815036,
            3089860951, 3809524904, 2483048460, 3393930240, 799688500,  3658784141, 1068463111,
            2928694600, 3311603151, 875936481,  3086676972, 3777936467, 337985377,  2821341178,
            1241095475, 1100733456, 589756766,  2798690446, 3571791137, 3240510534, 999638196,
            4105883418, 1083898453, 3024517521, 3475840464, 2175109146, 2573164177, 1807229814,
            1643016377, 4146282039, 3410635429, 3599510558, 1398980149, 132701905,  3085153375,
            2224747341, 525083234,  3503385249, 832272433,  929479066,  3563249441, 730938978,
            1109414015, 605067437,  3785757465, 2836772875, 2788510361, 3541091226, 2870746862,
            26790808,   3579638045, 2123684715, 8293600,    1870277664, 3788409374, 3467241386,
            694418289,  3222713475, 252790506,  2043848407, 3307995498, 1694643231, 22070346,
            2563281471, 2039997647, 139271207,  2493686251, 413519305,  3140125637, 198610458,
            4045421068, 2942444624, 397993198,  3275170439, 1288504086, 1174110217, 2002394249,
            674965193,  3824280387, 2881279015, 1726196816, 1863475895, 1414971466, 3295687112,
            123370137,  683242065,  344184636,  4126620874, 4041432136, 3471883897, 205806303,
            473949650,  720914171,  1867092416, 10012962,   166261979,  1938396569, 3229206332,
            1244417441, 2061211616, 2246061605, 4125342100, 3168195049, 789191744,  2045187744,
            269048137,  2538243310, 3589419995, 729545488,  249407155,  2416596529, 1068756146,
            3280924409, 2445440972, 326340747,  51860777,   711396990,  1836633601, 284052876,
            1405907345, 3503111389, 3190940018, 865226662,  2437063731, 4267209357, 113275350,
            956028637,  4094000422, 308619977,  3727550087, 2817026788, 1743080484, 2410397223,
            353016473,  435940705,  391811384,  4235792828, 4142634597, 26219570,   2033039621,
            898719058,  2811876829, 1999601908, 1320942380, 4265160734, 1099229426, 1854524064,
            3078480380, 3207682961, 2527100361, 2992570967, 1865813877, 3146364013, 532408631,
            725090062,  3705935851, 1669209985, 1740573991, 3371466293, 137883728,  2623815036,
            3089860951, 3809524904, 2483048460, 2876349646, 799688500,  3658784141, 1068463111,
            2928694600, 2285561953, 875936481,  3086676972, 3777936467, 337985377,  3289463377,
            1241095475, 1100733456, 589756766,  2798690446, 1170125296, 3240510534, 999638196,
            4105883418, 1083898453, 3211374715, 3475840464, 2175109146, 2573164177, 1807229814,
            3883969423, 4146282039, 3410635429, 3599510558, 1398980149, 1235437056, 3085153375,
            2224747341, 525083234,  3503385249, 806812647,  929479066,  3563249441, 730938978,
            1109414015, 4183104240, 3785757465, 2836772875, 2788510361, 3541091226, 3762927530,
            26790808,   3579638045, 2123684715, 8293600,    1370886803, 3788409374, 3467241386,
            694418289,  3222713475, 2945870697, 2043848407, 3307995498, 1694643231, 22070346,
            3550959727, 2039997647, 139271207,  2493686251, 413519305,  2080330579, 198610458,
            4045421068, 2942444624, 397993198,  4189708487, 1288504086, 1174110217, 2002394249,
            674965193,  1515383117, 2881279015, 1726196816, 1863475895, 1414971466, 4108614322,
            123370137,  683242065,  344184636,  4126620874, 2280202337, 3471883897, 205806303,
            473949650,  720914171,  2942339676, 10012962,   166261979,  1938396569, 3229206332,
            994087955,  2061211616, 2246061605, 4125342100, 3168195049, 3012017185, 2045187744,
            269048137,  2538243310, 3589419995, 757798787,  249407155,  2416596529, 1068756146,
            3280924409, 2013993123, 326340747,  51860777,   711396990,  1836633601, 1843046121,
            1405907345, 3503111389, 3190940018, 865226662,  2978926417, 4267209357, 113275350,
            956028637,  4094000422, 715247159,  3727550087, 2817026788, 1743080484, 2410397223,
            1817477937, 435940705,  391811384,  4235792828, 4142634597, 4175631882, 2033039621,
            898719058,  2811876829, 1999601908, 4005684707, 4265160734, 1099229426, 1854524064,
            3078480380, 165726034,  2527100361, 2992570967, 1865813877, 3146364013, 1524553138,
            725090062,  3705935851, 1669209985, 1740573991, 831683919,  137883728,  2623815036,
            3089860951, 3809524904, 3775286289, 2876349646, 799688500,  3658784141, 1068463111,
            2183830322, 2285561953, 875936481,  3086676972, 3777936467, 1899562304, 3289463377,
            1241095475, 1100733456, 589756766,  2293213649, 1170125296, 3240510534, 999638196,
            4105883418, 3826072718, 3211374715, 3475840464, 2175109146, 2573164177, 1229563745,
            3883969423, 4146282039, 3410635429, 3599510558, 3734076286, 1235437056, 3085153375,
            2224747341, 525083234,  2502644515, 806812647,  929479066,  3563249441, 730938978,
            239129918,  4183104240, 3785757465, 2836772875, 2788510361, 2759710091, 3762927530,
            26790808,   3579638045, 2123684715, 4003340365, 1370886803, 3788409374, 3467241386,
            694418289,  3666637699, 2945870697, 2043848407, 3307995498, 1694643231, 2603553959,
            3550959727, 2039997647, 139271207,  2493686251, 934935671,  2080330579, 198610458,
            4045421068, 2942444624, 3539975743, 4189708487, 1288504086, 1174110217, 2002394249,
            1384249654, 1515383117, 2881279015, 1726196816, 1863475895, 2036375575, 4108614322,
            123370137,  683242065,  344184636,  2401273862, 2280202337, 3471883897, 205806303,
            473949650,  2914361020, 2942339676, 10012962,   166261979,  1938396569, 3261262454,
            994087955,  2061211616, 2246061605, 4125342100, 401831363,  3012017185, 2045187744,
            269048137,  2538243310, 40329441,   757798787,  249407155,  2416596529, 1068756146,
            1278128443, 2013993123, 326340747,  51860777,   711396990,  3806098906, 1843046121,
            1405907345, 3503111389, 3190940018, 844388321,  2978926417, 4267209357, 113275350,
            956028637,  1745561172, 715247159,  3727550087, 2817026788, 1743080484, 1355675244,
            1817477937, 435940705,  391811384,  4235792828, 3045537043, 4175631882, 2033039621,
            898719058,  2811876829, 364196805,  4005684707, 4265160734, 1099229426, 1854524064,
            463622197,  165726034,  2527100361, 2992570967, 1865813877, 3637845527, 1524553138,
            725090062,  3705935851, 1669209985, 2476258129, 831683919,  137883728,  2623815036,
            3089860951, 809602104,  3775286289, 2876349646, 799688500,  3658784141, 521289966,
            2183830322, 2285561953, 875936481,  3086676972, 559225501,  1899562304, 3289463377,
            1241095475, 1100733456, 3894476872, 2293213649, 1170125296, 3240510534, 999638196,
            3442151092, 3826072718, 3211374715, 3475840464, 2175109146, 3048241889, 1229563745,
            3883969423, 4146282039, 3410635429, 1478525883, 3734076286, 1235437056, 3085153375,
            2224747341, 1975828843, 2502644515, 806812647,  929479066,  3563249441, 2727073816,
            239129918,  4183104240, 3785757465, 2836772875, 2281862269, 2759710091, 3762927530,
            26790808,   3579638045, 94731636,   4003340365, 1370886803, 3788409374, 3467241386,
            2367507907, 3666637699, 2945870697, 2043848407, 3307995498, 3329744367, 2603553959,
            3550959727, 2039997647, 139271207,  4204339909, 934935671,  2080330579, 198610458,
            4045421068, 3824547434, 3539975743, 4189708487, 1288504086, 1174110217, 3830604059,
            1384249654, 1515383117, 2881279015, 1726196816, 1898927478, 2036375575, 4108614322,
            123370137,  683242065,  1522220579, 2401273862, 2280202337, 3471883897, 205806303,
            1337451378, 2914361020, 2942339676, 10012962,   166261979,  492158028,  3261262454,
            994087955,  2061211616, 2246061605, 2828520049, 401831363,  3012017185, 2045187744,
            269048137,  2079734078, 40329441,   757798787,  249407155,  2416596529, 3328548708,
            1278128443, 2013993123, 326340747,  51860777,   724477508,  3806098906, 1843046121,
            1405907345, 3503111389, 4072332875, 844388321,  2978926417, 4267209357, 113275350,
            3142714880, 1745561172, 715247159,  3727550087, 2817026788, 2731235535, 1355675244,
            1817477937, 435940705,  391811384,  1020533906, 3117360615, 617983808,  2925669895,
            556866794,  2605566287, 3470828819, 1785615468, 2731351591, 2926719168, 4123263983,
            2040349935, 3579777021, 2888857741, 3178711960, 1030478151, 3040571510, 2220826086,
            2441254183, 2980914654, 815533158,  1710857389, 4086970434, 3133304767, 3769317287,
            1075339161, 1246696604, 916093525,  1295762965, 1325992836, 2549815093, 2770504768,
            4023323321, 2736271682, 3785208777, 1350940454, 1807398946, 1055553487, 4241205010,
            805253979,  3338478490, 2817644960, 1097836461, 3322766692, 4149600934, 974571325,
            2647859928, 3503300750, 764971685,  3668376908, 768334747,  3368492491, 3303920538,
            1991260266, 2016393332, 443159961,  610912941,  103869068,  2597128570, 1938130577,
            2301491826, 1848760284, 3269227321, 4034839428, 1460523856, 1794042705, 2836283096,
            1109465680, 940796473,  1988085708, 1354546353, 1164142896, 1440563327, 4189896233,
            578476642,  1713593487, 4240989023, 3579749878, 1588280244, 2580753244, 2463689925,
            969340870,  45370202,   2417338702, 1494509331, 1634405777, 3849318838, 2204592793,
            2949299948, 1578513988, 2648547836, 3032743108, 1277708796, 3663638483, 1061544858,
            2672720548, 3339247332, 3661860049, 649501430,  3546795678, 637753024,  3791572767,
            1027049853, 2966644874, 2396588102, 1114841544, 4247228296, 4278881306, 2286644327,
            1652304760, 3548872701, 3478276431, 3985225084, 4006462035, 3397474601, 3149091370,
            3484740618, 88930016,   3105642366, 3122742782, 598735044,  2387132244, 3619031226,
            2511779051, 4227313056, 3464231734, 2068685701, 2208668367, 3983359366, 4165730079,
            1181616273, 2918937653, 2225952590, 3938198787, 2381981769, 1001413970, 1733133398,
            321924034,  61201314,   337387739,  2964519900, 2610716056, 2034247746, 345673387,
            1196883770, 497128130,  4011543689, 3712949096, 1824642105, 2459543220, 2422424986,
            724648858,  1127900622, 1771809785, 3082177918, 2593670752, 944971439,  1755244739,
            80374770,   489784979,
        },
        {
            2246605826, 215030128,  871645668,  3402612852, 423273439,  316965236,  47416561,
            1470716454, 2288582385, 2021890755, 2148091363, 167227868,  3085506034, 3365950545,
            1170282137, 1345986409, 197195155,  2644113318, 2491271090, 2597072003, 170335901,
            2540851884, 2584420407, 3609142920, 3052130502, 4018095157, 2850805299, 2777821400,
            110647395,  3262987676, 1447103309, 3632575579, 3243210595, 1892770504, 4214485953,
            38676169,   2431628817, 2836918800, 272023527,  2825888902, 2794421955, 2354379386,
            452404203,  584718212,  1915053836, 1455821656, 4264066935, 1150980581, 3792433350,
            3104909316, 441521402,  3807587668, 275969953,  3970844623, 3323695518, 3909107329,
            290225599,  957520066,  4048181850, 2623778463, 1957371891, 540091753,  3072448879,
            2386916346, 392549194,  1261391184, 4137605148, 314807135,  2916930821, 3168561018,
            2332027308, 1967082817, 1849256214, 1141134412, 1206824012, 2088102210, 4170914605,
            3399892824, 59190648,   1657183299, 1314626253, 500606287,  413229420,  1245395908,
            664681,     2726979120, 3408998445, 2318397638, 1882820077, 2073055266, 4262833629,
            1348801932, 229857331,  3086071450, 1327801028, 812015573,  2214355282, 2232635690,
            3162540418, 2049877621, 470752564,  2527480795, 1285499716, 220173566,  4239277569,
            788168494,  3748855859, 1360707769, 449512212,  1238219398, 2880205975, 2755133627,
            372409230,  411800575,  2455333195, 4080817864, 3556684908, 2857940866, 1969081563,
            2526852668, 1026062474, 1849785784, 3552290093, 4214448,    460332681,  30890894,
            1108618048, 272438799,  3339891045, 1512685591, 1310038443, 2431938882, 1478442144,
            2804640700, 3426381347, 861206186,  290322827,  2736623609, 327318125,  1922859957,
            1939922519, 3539608908, 3442377433, 3868710131, 2244493875, 47774461,   3858864626,
            3294523981, 1798515481, 565017248,  2633378137, 811307482,  1743357106, 419676111,
            1688841846, 1799884674, 1720546272, 3900863156, 3506303345, 1719438472, 576775454,
            2246605826, 215030128,  871645668,  3402612852, 619000856,  316965236,  47416561,
            1470716454, 2288582385, 3464704266, 2148091363, 167227868,  3085506034, 3365950545,
            901169164,  1345986409, 197195155,  2644113318, 2491271090, 3243741640, 170335901,
            2540851884, 2584420407, 3609142920, 2051834116, 4018095157, 2850805299, 2777821400,
            110647395,  2822981113, 1447103309, 3632575579, 3243210595, 1892770504, 1947501555,
            38676169,   2431628817, 2836918800, 272023527,  4010280501, 2794421955, 2354379386,
            452404203,  584718212,  3991257933, 1455821656, 4264066935, 1150980581, 3792433350,
            2151631692, 441521402,  3807587668, 275969953,  3970844623, 3965914153, 3909107329,
            290225599,  957520066,  4048181850, 4011285909, 1957371891, 540091753,  3072448879,
            2386916346, 1347453316, 1261391184, 4137605148, 314807135,  2916930821, 840822698,
            2332027308, 1967082817, 1849256214, 1141134412, 960593185,  2088102210, 4170914605,
            3399892824, 59190648,   2261593014, 1314626253, 500606287,  413229420,  1245395908,
            3401527918, 2726979120, 3408998445, 2318397638, 1882820077, 1683077666, 4262833629,
            1348801932, 229857331,  3086071450, 3363644507, 812015573,  2214355282, 2232635690,
            3162540418, 3579858747, 470752564,  2527480795, 1285499716, 220173566,  2294101261,
            788168494,  3748855859, 1360707769, 449512212,  28595866,   2880205975, 2755133627,
            372409230,  411800575,  1905311140, 4080817864, 3556684908, 2857940866, 1969081563,
            148561593,  1026062474, 1849785784, 3552290093, 4214448,    2237247821, 30890894,
            1108618048, 272438799,  3339891045, 169576507,  1310038443, 2431938882, 1478442144,
            2804640700, 4119485855, 861206186,  290322827,  2736623609, 327318125,  3408620608,
            1939922519, 3539608908, 3442377433, 3868710131, 1188056275, 47774461,   3858864626,
            3294523981, 1798515481, 1228896851, 2633378137, 811307482,  1743357106, 419676111,
            3111013241, 1799884674, 1720546272, 3900863156, 3506303345, 1474164586, 576775454,
            2246605826, 215030128,  871645668,  2968519387, 619000856,  316965236,  47416561,
            1470716454, 9648980,    3464704266, 2148091363, 167227868,  3085506034, 1505294373,
            901169164,  1345986409, 197195155,  2644113318, 1227359150, 3243741640, 170335901,
            2540851884, 2584420407, 1205921163, 2051834116, 4018095157, 2850805299, 2777821400,
            2967529310, 2822981113, 1447103309, 3632575579, 3243210595, 532996977,  1947501555,
            38676169,   2431628817, 2836918800, 1761031313, 4010280501, 2794421955, 2354379386,
            452404203,  1222630846, 3991257933, 1455821656, 4264066935, 1150980581, 2344548386,
            2151631692, 441521402,  3807587668, 275969953,  963889269,  3965914153, 3909107329,
            290225599,  957520066,  4176220201, 4011285909, 1957371891, 540091753,  3072448879,
            1810164615, 1347453316, 1261391184, 4137605148, 314807135,  2672526663, 840822698,
            2332027308, 1967082817, 1849256214, 734862208,  960593185,  2088102210, 4170914605,
            3399892824, 2471507530, 2261593014, 1314626253, 500606287,  413229420,  970185057,
            3401527918, 2726979120, 3408998445, 2318397638, 708987193,  1683077666, 4262833629,
            1348801932, 229857331,  749849397,  3363644507, 812015573,  2214355282, 2232635690,
            2901095495, 3579858747, 470752564,  2527480795, 1285499716, 941862108,  2294101261,
            788168494,  3748855859, 1360707769, 3818227212, 28595866,   2880205975, 2755133627,
            372409230,  570110534,  1905311140, 4080817864, 3556684908, 2857940866, 2253777974,
            148561593,  1026062474, 1849785784, 3552290093, 1525559608, 2237247821, 30890894,
            1108618048, 272438799,  3996203631, 169576507,  1310038443, 2431938882, 1478442144,
            2857841871, 4119485855, 861206186,  290322827,  2736623609, 1184217272, 3408620608,
            1939922519, 3539608908, 3442377433, 1263700272, 1188056275, 47774461,   3858864626,
            3294523981, 2611619,    1228896851, 2633378137, 811307482,  1743357106, 1930089302,
            3111013241, 1799884674, 1720546272, 3900863156, 2370003471, 1474164586, 576775454,
            2246605826, 215030128,  540197019,  2968519387, 619000856,  316965236,  47416561,
            3585128733, 9648980,    3464704266, 2148091363, 167227868,  509283324,  1505294373,
            901169164,  1345986409, 197195155,  3983525470, 1227359150, 3243741640, 170335901,
            2540851884, 2812935262, 1205921163, 2051834116, 4018095157, 2850805299, 2798430304,
            2967529310, 2822981113, 1447103309, 3632575579, 389184524,  532996977,  1947501555,
            38676169,   2431628817, 1055068556, 1761031313, 4010280501, 2794421955, 2354379386,
            965687576,  1222630846, 3991257933, 1455821656, 4264066935, 1551000086, 2344548386,
            2151631692, 441521402,  3807587668, 3701529910, 963889269,  3965914153, 3909107329,
            290225599,  1771599976, 4176220201, 4011285909, 1957371891, 540091753,  1670159873,
            1810164615, 1347453316, 1261391184, 4137605148, 4191698993, 2672526663, 840822698,
            2332027308, 1967082817, 3098515331, 734862208,  960593185,  2088102210, 4170914605,
            2470055060, 2471507530, 2261593014, 1314626253, 500606287,  1100764382, 970185057,
            3401527918, 2726979120, 3408998445, 4100198161, 708987193,  1683077666, 4262833629,
            1348801932, 3744209503, 749849397,  3363644507, 812015573,  2214355282, 3217409412,
            2901095495, 3579858747, 470752564,  2527480795, 552979949,  941862108,  2294101261,
            788168494,  3748855859, 2355231228, 3818227212, 28595866,   2880205975, 2755133627,
            833553378,  570110534,  1905311140, 4080817864, 3556684908, 4124102038, 2253777974,
            148561593,  1026062474, 1849785784, 656329297,  1525559608, 2237247821, 30890894,
            1108618048, 1464443032, 3996203631, 169576507,  1310038443, 2431938882, 2100788071,
            2857841871, 4119485855, 861206186,  290322827,  3653047356, 1184217272, 3408620608,
            1939922519, 3539608908, 4267170500, 1263700272, 1188056275, 47774461,   3858864626,
            1046565728, 2611619,    1228896851, 2633378137, 811307482,  1312393456, 1930089302,
            3111013241, 1799884674, 1720546272, 1199041144, 2406753856, 2108495166, 2126345981,
            1524975128, 1269232392, 3162531748, 3076707658, 1736955170, 1036221745, 1232435193,
            3945348482, 1057631163, 520376289,  4154435769, 1280565077, 1865705876, 1030078366,
            1140849319, 1769263412, 1161866807, 2768552980, 561022685,  2712685799, 1501252058,
            3608433719, 3138564149, 4093654128, 1218455911, 892700607,  2012017510, 3568315757,
            4002239824, 1754440379, 2641708101, 1027390781, 199831087,  1261208885, 2058433786,
            2101649235, 220966013,  3445375335, 1100438514, 4075559840, 4244062658, 3417249884,
            150102478,  3337395219, 2464869101, 3720375949, 93353579,   2329780067, 777826834,
            2745626035, 2984812746, 568848158,  1593919595, 1166619196, 96177504,   305329591,
            4271176854, 3829149188, 1551058535, 2828280993, 1367551996, 4208083082, 2260803683,
            3118708147, 434935608,  702805370,  3544156958, 792712531,  231019757,  136272259,
            4049968615, 2722527811, 603697698,  2891035509, 4270409302, 1220615076, 1932569338,
            1084454986, 468729683,  2377913518, 2068946556, 530579176,  1422294615, 4032799503,
            2065706770, 604700228,  98049660,   3182511353, 935830212,  1938107848, 1266035034,
            957505506,  2758220503, 1805223938, 3393041584, 3958541336, 2695487012, 3355668819,
            276889675,  3098939423, 415941187,  180737121,  2638873657, 1103150707, 4255168358,
            2736183195, 1275942292, 2687807236, 538129710,  3337005391, 3941968393, 1113153386,
            3813628384, 1775835369, 296314749,  1697642748, 3614403315, 1953056095, 2102878063,
            3161706344, 2207159580, 3078233525, 3836286614, 886914072,  1884037075, 4135819784,
            1616380780, 1672616998, 3879848699, 2277472209, 3933249848, 2428044648, 2876076879,
            165724720,  2277165385, 1984963196, 1456923194, 2406217222, 3388886718, 47522558,
            1903557801, 1959641458, 2325355446, 3251147398, 2266553941, 2243962024, 1420017618,
            1791159474, 1793406225, 601509698,  3207357979, 1189285184, 148538800,  2077251302,
            3267239327, 2851475997,
        },
        {
            2297601569, 1568158352, 966495205,  2519289185, 2806505562, 1288246406, 3165941625,
            995297492,  144754895,  1311490149, 2955889545, 58288130,   3718936493, 2418815383,
            305606425,  1941239460, 1248237999, 4104814215, 2241849108, 2079735833, 3311430084,
            2994452103, 954458312,  1508032702, 4201056959, 1610886381, 226126582,  4031235524,
            824513899,  3414830026, 3910561340, 3657878379, 2297604754, 4149910038, 2160029095,
            1118866929, 2129125953, 3949252726, 2775620551, 1153211624, 4292816867, 1654756104,
            3379190300, 3793148160, 3704080171, 3900299755, 514302088,  2373418072, 275167268,
            258673003,  1975286035, 2594711032, 2871207425, 2433890412, 1891656257, 1231956734,
            1095967101, 2763479526, 523553952,  2308038100, 3791399162, 1101312966, 2744751327,
            1279599020, 805653336,  2219240055, 2568580584, 4183751468, 745987186,  2696045801,
            4247153406, 2529534225, 1482918323, 2323193252, 2651269132, 1201209101, 1645909871,
            4096211619, 2162997395, 1091870591, 1021965405, 98759240,   1798599460, 1413400118,
            867779500,  1216778737, 1491641950, 3252261582, 1511566064, 892157219,  2791493080,
            3345913827, 2435004752, 1982900361, 2043070333, 3713190508, 3433312334, 267676462,
            3429491119, 3923459451, 2488648740, 3066620257, 3748176652, 3276620179, 2704363841,
            109022020,  3928341572, 76645373,   2523616735, 682613726,  462062522,  2651746423,
            2140612348, 3932979570, 54367802,   3442104668, 501411927,  3214448696, 726616487,
            73010376,   4087639850, 1127110134, 1513234185, 1656107449, 701399987,  801947128,
            301840727,  1951982149, 1780987024, 3593404905, 3713021414, 4155770891, 1276056628,
            3509462957, 1357616090, 226497177,  2841235447, 2806185675, 3425394432, 1685758741,
            2494460981, 95052345,   2713083754, 4290302970, 3354897956, 1317771372, 3760451569,
            2465046270, 1416869490, 3265402738, 2021954669, 1892646114, 910599682,  695327876,
            1007518124, 3382161774, 1408735780, 1371949200, 3000797699, 1060693411, 1055749150,
            2297601569, 1568158352, 966495205,  2519289185, 1348756845, 1288246406, 3165941625,
            995297492,  144754895,  2868205431, 2955889545, 58288130,   3718936493, 2418815383,
            2973614748, 1941239460, 1248237999, 4104814215, 2241849108, 280349772,  3311430084,
            2994452103, 954458312,  1508032702, 1257130662, 1610886381, 226126582,  4031235524,
            824513899,  28295923,   3910561340, 3657878379, 2297604754, 4149910038, 3171126212,
            1118866929, 2129125953, 3949252726, 2775620551, 146458654,  4292816867, 1654756104,
            3379190300, 3793148160, 3330457262, 3900299755, 514302088,  2373418072, 275167268,
            1077973065, 1975286035, 2594711032, 2871207425, 2433890412, 3855851888, 1231956734,
            1095967101, 2763479526, 523553952,  1968711280, 3791399162, 1101312966, 2744751327,
            1279599020, 4172659595, 2219240055, 2568580584, 4183751468, 745987186,  3202494176,
            4247153406, 2529534225, 1482918323, 2323193252, 1363226170, 1201209101, 1645909871,
            4096211619, 2162997395, 445086994,  1021965405, 98759240,   1798599460, 1413400118,
            1374599617, 1216778737, 1491641950, 3252261582, 1511566064, 3816171749, 2791493080,
            3345913827, 2435004752, 1982900361, 1300562608, 3713190508, 3433312334, 267676462,
            3429491119, 4057990887, 2488648740, 3066620257, 3748176652, 3276620179, 1608060377,
            109022020,  3928341572, 76645373,   2523616735, 928985887,  462062522,  2651746423,
            2140612348, 3932979570, 2702772420, 3442104668, 501411927,  3214448696, 726616487,
            715205741,  4087639850, 1127110134, 1513234185, 1656107449, 136803910,  801947128,
            301840727,  1951982149, 1780987024, 1810125284, 3713021414, 4155770891, 1276056628,
            3509462957, 3788923708, 226497177,  2841235447, 2806185675, 3425394432, 2560111240,
            2494460981, 95052345,   2713083754, 4290302970, 1495150976, 1317771372, 3760451569,
            2465046270, 1416869490, 1742074080, 2021954669, 1892646114, 910599682,  695327876,
            3006246592, 3382161774, 1408735780, 1371949200, 3000797699, 402137178,  1055749150,
            2297601569, 1568158352, 966495205,  1687747166, 1348756845, 1288246406, 3165941625,
            995297492,  1758824914, 2868205431, 2955889545, 58288130,   3718936493, 3737239422,
            2973614748, 1941239460, 1248237999, 4104814215, 1222477079, 280349772,  3311430084,
            2994452103, 954458312,  1453509073, 1257130662, 1610886381, 226126582,  4031235524,
            2360041295, 28295923,   3910561340, 3657878379, 2297604754, 1180632332, 3171126212,
            1118866929, 2129125953, 3949252726, 1995801029, 146458654,  4292816867, 1654756104,
            3379190300, 887409733,  3330457262, 3900299755, 514302088,  2373418072, 1610708956,
            1077973065, 1975286035, 2594711032, 2871207425, 1078111618, 3855851888, 1231956734,
            1095967101, 2763479526, 1526970878, 1968711280, 3791399162, 1101312966, 2744751327,
            4289242615, 4172659595, 2219240055, 2568580584, 4183751468, 4028105755, 3202494176,
            4247153406, 2529534225, 1482918323, 394966357,  1363226170, 1201209101, 1645909871,
            4096211619, 1661336999, 445086994,  1021965405, 98759240,   1798599460, 1693801207,
            1374599617, 1216778737, 1491641950, 3252261582, 2401937862, 3816171749, 2791493080,
            3345913827, 2435004752, 274643379,  1300562608, 3713190508, 3433312334, 267676462,
            2273597499, 4057990887, 2488648740, 3066620257, 3748176652, 1592243672, 1608060377,
            109022020,  3928341572, 76645373,   798974007,  928985887,  462062522,  2651746423,
            2140612348, 789069422,  2702772420, 3442104668, 501411927,  3214448696, 1843774677,
            715205741,  4087639850, 1127110134, 1513234185, 4097895254, 136803910,  801947128,
            301840727,  1951982149, 977263046,  1810125284, 3713021414, 4155770891, 1276056628,
            150823902,  3788923708, 226497177,  2841235447, 2806185675, 4230854677, 2560111240,
            2494460981, 95052345,   2713083754, 2253874223, 1495150976, 1317771372, 3760451569,
            2465046270, 560937085,  1742074080, 2021954669, 1892646114, 910599682,  1143119553,
            3006246592, 3382161774, 1408735780, 1371949200, 1917625923, 402137178,  1055749150,
            2297601569, 1568158352, 4208325411, 1687747166, 1348756845, 1288246406, 3165941625,
            2258241710, 1758824914, 2868205431, 2955889545, 58288130,   181831946,  3737239422,
            2973614748, 1941239460, 1248237999, 3065149422, 1222477079, 280349772,  3311430084,
            2994452103, 3536270093, 1453509073, 1257130662, 1610886381, 226126582,  2369372755,
            2360041295, 28295923,   3910561340, 3657878379, 554746545,  1180632332, 3171126212,
            1118866929, 2129125953, 2856198309, 1995801029, 146458654,  4292816867, 1654756104,
            3967310485, 887409733,  3330457262, 3900299755, 514302088,  1839139257, 1610708956,
            1077973065, 1975286035, 2594711032, 2358759777, 1078111618, 3855851888, 1231956734,
            1095967101, 2324590009, 1526970878, 1968711280, 3791399162, 1101312966, 2354667568,
            4289242615, 4172659595, 2219240055, 2568580584, 3002068082, 4028105755, 3202494176,
            4247153406, 2529534225, 3186646714, 394966357,  1363226170, 1201209101, 1645909871,
            3655290746, 1661336999, 445086994,  1021965405, 98759240,   249468351,  1693801207,
            1374599617, 1216778737, 1491641950, 434441387,  2401937862, 3816171749, 2791493080,
            3345913827, 111610026,  274643379,  1300562608, 3713190508, 3433312334, 3475913353,
            2273597499, 4057990887, 2488648740, 3066620257, 4209123603, 1592243672, 1608060377,
            109022020,  3928341572, 3424818654, 798974007,  928985887,  462062522,  2651746423,
            4022587588, 789069422,  2702772420, 3442104668, 501411927,  3525362577, 1843774677,
            715205741,  4087639850, 1127110134, 3984043597, 4097895254, 136803910,  801947128,
            301840727,  1427245563, 977263046,  1810125284, 3713021414, 4155770891, 2704344314,
            150823902,  3788923708, 226497177,  2841235447, 1152911444, 4230854677, 2560111240,
            2494460981, 95052345,   640025796,  2253874223, 1495150976, 1317771372, 3760451569,
            4163020032, 560937085,  1742074080, 2021954669, 1892646114, 3694490480, 1143119553,
            3006246592, 3382161774, 1408735780, 925494475,  995317742,  1056450928, 727622301,
            3778277665, 1783750235, 46717963,   2832294929, 2350465735, 3445120544, 3605377314,
            966513887,  2691804382, 3258090146, 2177002236, 2296703920, 3718916247, 2792673320,
            2000834017, 948023497,  2117475686, 307453636,  726401011,  1117769117, 23304331,
            2454516083, 3464577604, 1957446587, 227018849,  4169103150, 1776577875, 4047499731,
            3367401739, 4091519959, 985309308,  1603815981, 2770290625, 1611358037, 1014434700,
            1025238747, 3671536716, 1908745248, 2036465186, 2258386130, 110006390,  2383052858,
            3968845870, 868876668,  2515751842, 1374506855, 367156947,  3038959511, 986060847,
            544435607,  3842725538, 3684159325, 2202738072, 3783253789, 1138516134, 2010867227,
            19673289,   2119261127, 4148628206, 2144174919, 1055891337, 2398950017, 3953198359,
            1622928496, 744998190,  4142610084, 3445588221, 4024809572, 1526064625, 2965652006,
            4222751857, 3561685924, 578187015,  1198530251, 2104044611, 192087379,  4126344887,
            3524651223, 4258443225, 2698916916, 2901675611, 3909449638, 1957842064, 3026817749,
            1590303229, 7142859,    2421544171, 1158175118, 1423149367, 3058711721, 805062471,
            1271738905, 1921827993, 1800936626, 830658077,  4139812744, 4265189658, 1287830185,
            1200350975, 818138674,  2469551830, 2473176713, 2754512050, 3142398697, 371226055,
            736822335,  3434643918, 2666625407, 32873851,   1070511670, 3832218080, 1072102954,
            160063896,  392153119,  437296121,  1273940847, 2111119674, 2362246253, 2259168810,
            933516480,  3342163941, 3450145576, 1099170691, 4071901943, 1001716412, 2353115337,
            2657840495, 2962981939, 157554770,  3224319084, 3624242352, 3652145014, 836605929,
            2891340578, 2631141834, 4079977543, 590931654,  1736502930, 2611828359, 53830671,
            2543521850, 1633068774, 1198563874, 3240609293, 2553935757, 3602018273, 2078466215,
            2210416039, 2729410010, 3313143098, 3187546455, 1229184101, 2507583253, 3511955924,
            1652268820, 2884382330,
        },
        {
            2628162153, 3861478870, 2769884494, 3423483820, 1118276924, 536776894,  3742490940,
            550084334,  2441329856, 2604618499, 2308745810, 1178166365, 1345165241, 4039508109,
            1246601384, 3843182157, 2200144237, 91750284,   4290064840, 3363597477, 3243492274,
            4271100308, 4186328336, 2291901989, 1834723222, 372220743,  2190417067, 2624886324,
            3567647862, 1591175369, 2278087682, 2461678432, 232820452,  2714694382, 3070258434,
            2412655444, 2667664607, 249083056,  4166379751, 1360927521, 2247816079, 3253689753,
            1563674427, 1914999382, 2101454952, 1067816947, 1098201917, 4054175236, 1805828534,
            1815913104, 738357340,  2597170030, 1689737432, 2004663483, 1160995461, 1008175050,
            2004702919, 4258654415, 938972594,  2121583885, 2208729114, 276726877,  3973538591,
            2991069145, 2345655326, 2980162173, 1915611444, 2332104940, 2382102873, 2324437093,
            2640563452, 2680619359, 3413490949, 2140843463, 2424016743, 3735508133, 3421831326,
            4037977349, 3721506282, 510431975,  1014707294, 1378686477, 1939678832, 2223101760,
            2067687989, 309274614,  276596103,  3757624719, 1212251468, 2649271847, 4140361758,
            2634738350, 2029358730, 3205861896, 3090549771, 3775019657, 2018542036, 3675805680,
            3946144023, 331655838,  326568491,  1867863527, 1550945400, 3087000670, 2342003578,
            3949479453, 586483056,  147951307,  503062740,  3823927166, 2789767841, 3121654578,
            634238762,  4084629478, 3878778788, 435990088,  1724770389, 1403031256, 1334135626,
            1096780503, 3288769545, 2793293893, 80675548,   1637232257, 1856565474, 2675485635,
            1961165681, 1647512786, 4190102851, 4081320784, 2853183400, 3812341867, 278236392,
            1700614299, 2765246084, 3846866009, 1220806787, 3655684157, 1133921183, 2779125219,
            523552281,  703813725,  3110126767, 823843890,  290243102,  821297176,  364959993,
            3381862130, 2305271841, 356059263,  2558018765, 3235968999, 1070598970, 2444411636,
            3636221117, 4275517214, 4035198865, 3339014315, 2911872812, 4049586122, 4211583637,
            2628162153, 3861478870, 2769884494, 3423483820, 3254616321, 536776894,  3742490940,
            550084334,  2441329856, 1909596092, 2308745810, 1178166365, 1345165241, 4039508109,
            1349347043, 3843182157, 2200144237, 91750284,   4290064840, 803098068,  3243492274,
            4271100308, 4186328336, 2291901989, 2575673198, 372220743,  2190417067, 2624886324,
            3567647862, 132569424,  2278087682, 2461678432, 232820452,  2714694382, 3490648253,
            2412655444, 2667664607, 249083056,  4166379751, 3503294711, 2247816079, 3253689753,
            1563674427, 1914999382, 3121933565, 1067816947, 1098201917, 4054175236, 1805828534,
            816420552,  738357340,  2597170030, 1689737432, 2004663483, 397934907,  1008175050,
            2004702919, 4258654415, 938972594,  156733019,  2208729114, 276726877,  3973538591,
            2991069145, 2470446383, 2980162173, 1915611444, 2332104940, 2382102873, 3265195583,
            2640563452, 2680619359, 3413490949, 2140843463, 142464483,  3735508133, 3421831326,
            4037977349, 3721506282, 1898668265, 1014707294, 1378686477, 1939678832, 2223101760,
            4085776926, 309274614,  276596103,  3757624719, 1212251468, 1116423339, 4140361758,
            2634738350, 2029358730, 3205861896, 880658361,  3775019657, 2018542036, 3675805680,
            3946144023, 839516623,  326568491,  1867863527, 1550945400, 3087000670, 420309880,
            3949479453, 586483056,  147951307,  503062740,  416618471,  2789767841, 3121654578,
            634238762,  4084629478, 1120413065, 435990088,  1724770389, 1403031256, 1334135626,
            240966420,  3288769545, 2793293893, 80675548,   1637232257, 1785064235, 2675485635,
            1961165681, 1647512786, 4190102851, 2775407492, 2853183400, 3812341867, 278236392,
            1700614299, 2439624528, 3846866009, 1220806787, 3655684157, 1133921183, 366933679,
            523552281,  703813725,  3110126767, 823843890,  132468066,  821297176,  364959993,
            3381862130, 2305271841, 1048450041, 2558018765, 3235968999, 1070598970, 2444411636,
            1699430013, 4275517214, 4035198865, 3339014315, 2911872812, 324524850,  4211583637,
            2628162153, 3861478870, 2769884494, 1995585079, 3254616321, 536776894,  3742490940,
            550084334,  2121458511, 1909596092, 2308745810, 1178166365, 1345165241, 3067877274,
            1349347043, 3843182157, 2200144237, 91750284,   1246148630, 803098068,  3243492274,
            4271100308, 4186328336, 2932236493, 2575673198, 372220743,  2190417067, 2624886324,
            3945294599, 132569424,  2278087682, 2461678432, 232820452,  3341915918, 3490648253,
            2412655444, 2667664607, 249083056,  2307336284, 3503294711, 2247816079, 3253689753,
            1563674427, 1717494311, 3121933565, 1067816947, 1098201917, 4054175236, 971917867,
            816420552,  738357340,  2597170030, 1689737432, 243915062,  397934907,  1008175050,
            2004702919, 4258654415, 1807067458, 156733019,  2208729114, 276726877,  3973538591,
            1909483753, 2470446383, 2980162173, 1915611444, 2332104940, 3454651559, 3265195583,
            2640563452, 2680619359, 3413490949, 462852932,  142464483,  3735508133, 3421831326,
            4037977349, 1372088341, 1898668265, 1014707294, 1378686477, 1939678832, 752503486,
            4085776926, 309274614,  276596103,  3757624719, 4193030119, 1116423339, 4140361758,
            2634738350, 2029358730, 1725105892, 880658361,  3775019657, 2018542036, 3675805680,
            3496508290, 839516623,  326568491,  1867863527, 1550945400, 2685835387, 420309880,
            3949479453, 586483056,  147951307,  1639139280, 416618471,  2789767841, 3121654578,
            634238762,  3622035469, 1120413065, 435990088,  1724770389, 1403031256, 3548817929,
            240966420,  3288769545, 2793293893, 80675548,   3119506726, 1785064235, 2675485635,
            1961165681, 1647512786, 4019542081, 2775407492, 2853183400, 3812341867, 278236392,
            3487875111, 2439624528, 3846866009, 1220806787, 3655684157, 3303554633, 366933679,
            523552281,  703813725,  3110126767, 2477354049, 132468066,  821297176,  364959993,
            3381862130, 4065162466, 1048450041, 2558018765, 3235968999, 1070598970, 191819556,
            1699430013, 4275517214, 4035198865, 3339014315, 3588518026, 324524850,  4211583637,
            2628162153, 3861478870, 3361198093, 1995585079, 3254616321, 536776894,  3742490940,
            3912424229, 2121458511, 1909596092, 2308745810, 1178166365, 1882174246, 3067877274,
            1349347043, 3843182157, 2200144237, 1210030640, 1246148630, 803098068,  3243492274,
            4271100308, 402141998,  2932236493, 2575673198, 372220743,  2190417067, 1883679642,
            3945294599, 132569424,  2278087682, 2461678432, 708189294,  3341915918, 3490648253,
            2412655444, 2667664607, 2871800434, 2307336284, 3503294711, 2247816079, 3253689753,
            2113837945, 1717494311, 3121933565, 1067816947, 1098201917, 1041869160, 971917867,
            816420552,  738357340,  2597170030, 2306273930, 243915062,  397934907,  1008175050,
            2004702919, 2345434637, 1807067458, 156733019,  2208729114, 276726877,  2452083872,
            1909483753, 2470446383, 2980162173, 1915611444, 2043489400, 3454651559, 3265195583,
            2640563452, 2680619359, 2845757473, 462852932,  142464483,  3735508133, 3421831326,
            25103542,   1372088341, 1898668265, 1014707294, 1378686477, 2680788341, 752503486,
            4085776926, 309274614,  276596103,  3663266970, 4193030119, 1116423339, 4140361758,
            2634738350, 453005903,  1725105892, 880658361,  3775019657, 2018542036, 2601909713,
            3496508290, 839516623,  326568491,  1867863527, 3474340574, 2685835387, 420309880,
            3949479453, 586483056,  297934218,  1639139280, 416618471,  2789767841, 3121654578,
            958889718,  3622035469, 1120413065, 435990088,  1724770389, 2589603756, 3548817929,
            240966420,  3288769545, 2793293893, 972899860,  3119506726, 1785064235, 2675485635,
            1961165681, 2576799764, 4019542081, 2775407492, 2853183400, 3812341867, 159345352,
            3487875111, 2439624528, 3846866009, 1220806787, 3367080935, 3303554633, 366933679,
            523552281,  703813725,  1717395617, 2477354049, 132468066,  821297176,  364959993,
            1088290332, 4065162466, 1048450041, 2558018765, 3235968999, 285340039,  191819556,
            1699430013, 4275517214, 4035198865, 3544133220, 285121978,  1175302919, 4101282768,
            513236580,  890655666,  3051849972, 2315486379, 3067287276, 3134806925, 3926373006,
            2502825498, 461387883,  770459119,  3121636621, 1243065093, 1612354797, 659033930,
            621176955,  214256518,  371573588,  1168438671, 1233027650, 1984255965, 659404177,
            1218841419, 1226193512, 4247589702, 334814687,  980422670,  2518384561, 4041002302,
            1203659320, 509643440,  2528499450, 1512213710, 4052651069, 1378025938, 3436277168,
            2797728577, 463383787,  1184681947, 283482187,  2421891582, 3200080903, 373817869,
            452807139,  2002545143, 1068199574, 3390998240, 377559317,  1548403713, 1580741080,
            253591624,  759280679,  2174360733, 1687952097, 1325235423, 3856575909, 652218568,
            4130230594, 3757998028, 1349431618, 2870775414, 229741978,  1900794007, 201310771,
            4075023260, 3390078853, 3572716207, 1959949436, 1000128498, 1636575064, 241058867,
            2075461870, 1819342070, 619233032,  3164328001, 4280892071, 4219074185, 2719764611,
            3827656652, 4062556527, 621515766,  2542375627, 3901998596, 2295087430, 2880672054,
            2940372823, 2318642706, 914614262,  2549699597, 2907475284, 3901259809, 2663167002,
            3775306719, 2212887565, 1271873285, 3673659531, 3856609875, 1195785209, 1204338358,
            2785362544, 2398696803, 3038377816, 4288025143, 262511310,  4151907455, 924716723,
            3298769960, 2065938273, 3277412030, 122636766,  2164055077, 1000638739, 2044933533,
            2935604716, 2772787255, 3727331409, 1315627932, 2610657438, 832931652,  452359900,
            681035792,  3312648046, 1059435047, 1489639114, 3647631796, 417952902,  731020350,
            2847472725, 2779076784, 2674295324, 487600023,  2925909449, 3997011591, 3697231318,
            967300591,  2310856069, 684710043,  811911286,  4174732177, 1010656728, 702780279,
            920081774,  1578296057, 944734808,  2884038169, 2885919611, 2633474915, 2508946673,
            3579216621, 656143887,  426108406,  2166202683, 991797657,  706498590,  561168186,
            1144619335, 3136206425,
        },
        {
            1397151780, 2811819629, 136093242,  1706471396, 2926168579, 3354692495, 1411897605,
            1260408318, 3062667173, 1963784290, 2025490253, 400727334,  181720900,  2158797740,
            1900973623, 1349047184, 611140291,  1413630134, 4215612132, 467998374,  255704929,
            2990618572, 3713409801, 4029347055, 1706034648, 3469237414, 2989580475, 44167122,
            2979807958, 2607980434, 3613885343, 2361849475, 2760821126, 1420569826, 53776292,
            2929657218, 1109680396, 1122045276, 1206792123, 2463966159, 2287419570, 213964081,
            1459889708, 2466208368, 2804980561, 439492851,  3075747052, 1801726494, 2936406751,
            4133328505, 423493678,  3969882089, 2101229890, 1520711135, 2894543378, 2569498187,
            2559481737, 3200551699, 3153345135, 2650598367, 1404192030, 3513165680, 4177718526,
            4204616477, 1716773614, 2195948515, 3961190999, 37751002,   1764263534, 1709112108,
            2991429803, 3265393251, 3042733773, 3539067551, 4221382507, 4291947186, 206064044,
            2361634327, 3549827717, 3622070291, 1261872896, 2852286531, 2593476766, 2119432988,
            4254464659, 3019014369, 2742754198, 1767655896, 447403966,  1094264816, 3270325810,
            1905649260, 2294451932, 1136994399, 2256290263, 169622663,  829134840,  3984045317,
            1346115000, 3126945768, 4210941019, 3646740831, 3812965325, 903696731,  2248863624,
            2484992914, 1426951889, 1373407567, 2850334431, 2004411658, 2460862562, 3361983442,
            1668305489, 1829163662, 1091288294, 1206898328, 4233393051, 2721504138, 581300614,
            1044741221, 619233324,  2946924660, 3370450185, 144315441,  2323130411, 1135978460,
            3250160825, 135806112,  1716468701, 1391463446, 3822415061, 2648888161, 2918768265,
            93583777,   1897013725, 927912931,  2966891421, 2503779655, 3065135276, 2078063702,
            3638851311, 568500672,  519625519,  3906853085, 1676342227, 3313591458, 3674982138,
            2269622961, 3410238652, 428758688,  777088239,  2624373482, 432245311,  761217304,
            3481574710, 2771580350, 859623808,  1663008209, 2438002235, 3181773384, 2786510670,
            1397151780, 2811819629, 136093242,  1706471396, 2029607438, 3354692495, 1411897605,
            1260408318, 3062667173, 1194115678, 2025490253, 400727334,  181720900,  2158797740,
            1015897703, 1349047184, 611140291,  1413630134, 4215612132, 2752961998, 255704929,
            2990618572, 3713409801, 4029347055, 3637701296, 3469237414, 2989580475, 44167122,
            2979807958, 3315709570, 3613885343, 2361849475, 2760821126, 1420569826, 3025737573,
            2929657218, 1109680396, 1122045276, 1206792123, 3354230092, 2287419570, 213964081,
            1459889708, 2466208368, 2034714263, 439492851,  3075747052, 1801726494, 2936406751,
            981483126,  423493678,  3969882089, 2101229890, 1520711135, 2700667135, 2569498187,
            2559481737, 3200551699, 3153345135, 379671339,  1404192030, 3513165680, 4177718526,
            4204616477, 1850001229, 2195948515, 3961190999, 37751002,   1764263534, 3460421221,
            2991429803, 3265393251, 3042733773, 3539067551, 3691882408, 4291947186, 206064044,
            2361634327, 3549827717, 675731886,  1261872896, 2852286531, 2593476766, 2119432988,
            2349988023, 3019014369, 2742754198, 1767655896, 447403966,  2318258208, 3270325810,
            1905649260, 2294451932, 1136994399, 2261076543, 169622663,  829134840,  3984045317,
            1346115000, 1208082814, 4210941019, 3646740831, 3812965325, 903696731,  4288991619,
            2484992914, 1426951889, 1373407567, 2850334431, 2310210250, 2460862562, 3361983442,
            1668305489, 1829163662, 394831358,  1206898328, 4233393051, 2721504138, 581300614,
            3419257848, 619233324,  2946924660, 3370450185, 144315441,  1070200843, 1135978460,
            3250160825, 135806112,  1716468701, 477613434,  3822415061, 2648888161, 2918768265,
            93583777,   2980911085, 927912931,  2966891421, 2503779655, 3065135276, 3459065949,
            3638851311, 568500672,  519625519,  3906853085, 3836608367, 3313591458, 3674982138,
            2269622961, 3410238652, 388954653,  777088239,  2624373482, 432245311,  761217304,
            3749048577, 2771580350, 859623808,  1663008209, 2438002235, 2239689352, 2786510670,
            1397151780, 2811819629, 136093242,  927639841,  2029607438, 3354692495, 1411897605,
            1260408318, 3609565664, 1194115678, 2025490253, 400727334,  181720900,  1273462567,
            1015897703, 1349047184, 611140291,  1413630134, 1181624552, 2752961998, 255704929,
            2990618572, 3713409801, 2698264549, 3637701296, 3469237414, 2989580475, 44167122,
            1963257648, 3315709570, 3613885343, 2361849475, 2760821126, 513942555,  3025737573,
            2929657218, 1109680396, 1122045276, 1891196218, 3354230092, 2287419570, 213964081,
            1459889708, 669386419,  2034714263, 439492851,  3075747052, 1801726494, 2413780873,
            981483126,  423493678,  3969882089, 2101229890, 1246127696, 2700667135, 2569498187,
            2559481737, 3200551699, 1804345345, 379671339,  1404192030, 3513165680, 4177718526,
            924843685,  1850001229, 2195948515, 3961190999, 37751002,   350322584,  3460421221,
            2991429803, 3265393251, 3042733773, 2803737522, 3691882408, 4291947186, 206064044,
            2361634327, 918629144,  675731886,  1261872896, 2852286531, 2593476766, 2193516413,
            2349988023, 3019014369, 2742754198, 1767655896, 826865918,  2318258208, 3270325810,
            1905649260, 2294451932, 759185481,  2261076543, 169622663,  829134840,  3984045317,
            2177606909, 1208082814, 4210941019, 3646740831, 3812965325, 2210368469, 4288991619,
            2484992914, 1426951889, 1373407567, 3742661713, 2310210250, 2460862562, 3361983442,
            1668305489, 2129530159, 394831358,  1206898328, 4233393051, 2721504138, 938112480,
            3419257848, 619233324,  2946924660, 3370450185, 1217803913, 1070200843, 1135978460,
            3250160825, 135806112,  3900898186, 477613434,  3822415061, 2648888161, 2918768265,
            643175924,  2980911085, 927912931,  2966891421, 2503779655, 3335733453, 3459065949,
            3638851311, 568500672,  519625519,  320034467,  3836608367, 3313591458, 3674982138,
            2269622961, 3039409422, 388954653,  777088239,  2624373482, 432245311,  1416980551,
            3749048577, 2771580350, 859623808,  1663008209, 2549663844, 2239689352, 2786510670,
            1397151780, 2811819629, 977796276,  927639841,  2029607438, 3354692495, 1411897605,
            3879441202, 3609565664, 1194115678, 2025490253, 400727334,  3681819395, 1273462567,
            1015897703, 1349047184, 611140291,  872620028,  1181624552, 2752961998, 255704929,
            2990618572, 1805342265, 2698264549, 3637701296, 3469237414, 2989580475, 2200498499,
            1963257648, 3315709570, 3613885343, 2361849475, 409407594,  513942555,  3025737573,
            2929657218, 1109680396, 1755270345, 1891196218, 3354230092, 2287419570, 213964081,
            2037578125, 669386419,  2034714263, 439492851,  3075747052, 966809995,  2413780873,
            981483126,  423493678,  3969882089, 2068688903, 1246127696, 2700667135, 2569498187,
            2559481737, 295519543,  1804345345, 379671339,  1404192030, 3513165680, 3507918710,
            924843685,  1850001229, 2195948515, 3961190999, 4142369629, 350322584,  3460421221,
            2991429803, 3265393251, 805577694,  2803737522, 3691882408, 4291947186, 206064044,
            2786414518, 918629144,  675731886,  1261872896, 2852286531, 2302484151, 2193516413,
            2349988023, 3019014369, 2742754198, 2147921472, 826865918,  2318258208, 3270325810,
            1905649260, 2652527651, 759185481,  2261076543, 169622663,  829134840,  3077160370,
            2177606909, 1208082814, 4210941019, 3646740831, 1019882807, 2210368469, 4288991619,
            2484992914, 1426951889, 3503378305, 3742661713, 2310210250, 2460862562, 3361983442,
            1837340134, 2129530159, 394831358,  1206898328, 4233393051, 1865250012, 938112480,
            3419257848, 619233324,  2946924660, 2497671686, 1217803913, 1070200843, 1135978460,
            3250160825, 2229005791, 3900898186, 477613434,  3822415061, 2648888161, 3546227719,
            643175924,  2980911085, 927912931,  2966891421, 3582780548, 3335733453, 3459065949,
            3638851311, 568500672,  2232770273, 320034467,  3836608367, 3313591458, 3674982138,
            843952572,  3039409422, 388954653,  777088239,  2624373482, 3883614988, 1416980551,
            3749048577, 2771580350, 859623808,  2973356430, 2759268225, 3689442682, 3724494342,
            971849909,  379660259,  2892728763, 3193881246, 1939246085, 3114375409, 1116143334,
            3880502341, 148002107,  110785639,  2256018695, 4076639661, 3850603835, 3989330291,
            3653054547, 3358507942, 2192969323, 4209084531, 2684480562, 3075792535, 2664698634,
            2156745452, 629137924,  3039892629, 230924155,  4213564472, 1123461521, 951847070,
            1231348482, 4166577709, 2248838839, 3423273877, 1135389551, 150484807,  1106976869,
            4098206185, 1280612836, 479087785,  3007573867, 649949948,  3106705791, 3463046865,
            815450484,  1612734814, 942548965,  3785173442, 4183969868, 81527980,   1956494253,
            2838881029, 447945196,  2545989776, 1442232371, 4250533959, 455183374,  124041740,
            944085380,  3748986616, 1377034459, 398893873,  2144010854, 2273433128, 2002562713,
            558432300,  3280023252, 2828144995, 3290303851, 4288602248, 3878184670, 2864249543,
            249644488,  3111891108, 3807043108, 1183016118, 2237814857, 949259413,  4138476107,
            3874176546, 1400115393, 1002431561, 1999339839, 567013319,  1628065808, 2358045109,
            3924868180, 2409171073, 3446105790, 207092174,  2211531388, 370419620,  866073776,
            1804946782, 57940256,   535599959,  1109868142, 1013933419, 3058848735, 2203977211,
            1082993958, 128107126,  2243108056, 3388776800, 1865998040, 3916279126, 3583718452,
            539013084,  1094070576, 3201190732, 535346680,  3882233126, 1243999327, 4143646813,
            836289086,  3675188998, 1951688578, 1678631763, 2187717526, 1108904992, 254676526,
            2028733173, 774266279,  2584629903, 99285083,   3276949729, 1638293626, 1535371353,
            791229949,  2117241573, 1899860500, 1072564507, 2578565542, 2862636933, 2486706199,
            3100781946, 1471564361, 3779336309, 2941260650, 2061301742, 3155146531, 1914871678,
            2865162641, 188471506,  2385413683, 2638074000, 2039492607, 3155250013, 3586151111,
            3884835707, 1386501749, 1166716008, 1809563783, 3989265301, 180099225,  1590259934,
            2176614879, 613315681,
        },
        {
            3600072515, 651444872,  2348224675, 1684848433, 1913333701, 3413467790, 1567802204,
            2125206188, 2463158656, 2251055204, 4132590383, 3192977084, 3718261822, 3431519430,
            3506690867, 1313208797, 637811069,  12802085,   3456408080, 166617386,  1764224523,
            4016338923, 2225367442, 2461647273, 3137989854, 373730087,  3013524828, 242949418,
            3443491410, 3671816408, 2391000148, 3964107377, 716535366,  1884597979, 3917515811,
            3441985401, 2472173593, 4034695117, 2486526143, 1658764329, 1873516415, 884116165,
            814992460,  1069506245, 3797556389, 838088473,  2279863068, 1002637017, 4174541774,
            644478743,  4138151954, 4030442072, 297710349,  3507828614, 1403493362, 3132267322,
            227377796,  388148240,  2760904473, 352998924,  1603734504, 1528807885, 2283620218,
            737730350,  2761342715, 809367801,  1667936422, 1510238771, 3762862328, 1171532060,
            647580587,  1460988169, 3944640945, 2331043627, 1965076564, 2913596196, 2960957119,
            1316491503, 3086954934, 3471945989, 2485431762, 692294537,  3148362914, 3371415765,
            2990795967, 706771848,  3734467362, 2768750385, 2061275631, 3935582473, 1449841372,
            1239527551, 592595530,  1685341001, 3352323357, 4147988039, 4003871917, 4035869533,
            3022833195, 1266052547, 1429645393, 565106475,  327014810,  348739711,  3262918351,
            915509292,  397356303,  3248246752, 1122821778, 2373765260, 1795464380, 3485315196,
            1731529670, 86888382,   2789587372, 850847993,  1794523220, 577288126,  1996569530,
            909222664,  2601642298, 1469035973, 2727135938, 3467853736, 633292505,  756260381,
            41782389,   226724724,  3633968708, 1695315503, 1846857904, 3185630605, 823108172,
            3609336496, 3422558797, 2865413534, 564221408,  591845835,  2498463433, 3573926554,
            1336639597, 4180084026, 3195588503, 2822864841, 1916459886, 2073158796, 56968669,
            1234765864, 2456093821, 3500058416, 3146725645, 3295822468, 4135196531, 628000231,
            745509757,  4143543278, 1941480444, 3607603517, 2288239329, 1991437813, 4081693775,
            3600072515, 651444872,  2348224675, 1684848433, 3748890341, 3413467790, 1567802204,
            2125206188, 2463158656, 1516568259, 4132590383, 3192977084, 3718261822, 3431519430,
            461466951,  1313208797, 637811069,  12802085,   3456408080, 3444149988, 1764224523,
            4016338923, 2225367442, 2461647273, 2594402002, 373730087,  3013524828, 242949418,
            3443491410, 2740782133, 2391000148, 3964107377, 716535366,  1884597979, 3161911677,
            3441985401, 2472173593, 4034695117, 2486526143, 3623045141, 1873516415, 884116165,
            814992460,  1069506245, 1053106195, 838088473,  2279863068, 1002637017, 4174541774,
            1806935386, 4138151954, 4030442072, 297710349,  3507828614, 2328331779, 3132267322,
            227377796,  388148240,  2760904473, 3654577129, 1603734504, 1528807885, 2283620218,
            737730350,  2134741424, 809367801,  1667936422, 1510238771, 3762862328, 4084104273,
            647580587,  1460988169, 3944640945, 2331043627, 3458437694, 2913596196, 2960957119,
            1316491503, 3086954934, 2404530503, 2485431762, 692294537,  3148362914, 3371415765,
            3697728317, 706771848,  3734467362, 2768750385, 2061275631, 1337146928, 1449841372,
            1239527551, 592595530,  1685341001, 3121493408, 4147988039, 4003871917, 4035869533,
            3022833195, 2709537023, 1429645393, 565106475,  327014810,  348739711,  1278935671,
            915509292,  397356303,  3248246752, 1122821778, 1086107506, 1795464380, 3485315196,
            1731529670, 86888382,   3645735256, 850847993,  1794523220, 577288126,  1996569530,
            1126950,    2601642298, 1469035973, 2727135938, 3467853736, 3668777652, 756260381,
            41782389,   226724724,  3633968708, 738274780,  1846857904, 3185630605, 823108172,
            3609336496, 3371270228, 2865413534, 564221408,  591845835,  2498463433, 4157618574,
            1336639597, 4180084026, 3195588503, 2822864841, 3844986377, 2073158796, 56968669,
            1234765864, 2456093821, 1001761927, 3146725645, 3295822468, 4135196531, 628000231,
            541676954,  4143543278, 1941480444, 3607603517, 2288239329, 1068806322, 4081693775,
            3600072515, 651444872,  2348224675, 47991343,   3748890341, 3413467790, 1567802204,
            2125206188, 2662653600, 1516568259, 4132590383, 3192977084, 3718261822, 2554440323,
            461466951,  1313208797, 637811069,  12802085,   982676468,  3444149988, 1764224523,
            4016338923, 2225367442, 451503008,  2594402002, 373730087,  3013524828, 242949418,
            1086137206, 2740782133, 2391000148, 3964107377, 716535366,  731470002,  3161911677,
            3441985401, 2472173593, 4034695117, 44456710,   3623045141, 1873516415, 884116165,
            814992460,  4004771121, 1053106195, 838088473,  2279863068, 1002637017, 1587145121,
            1806935386, 4138151954, 4030442072, 297710349,  2570695340, 2328331779, 3132267322,
            227377796,  388148240,  3570998746, 3654577129, 1603734504, 1528807885, 2283620218,
            188017185,  2134741424, 809367801,  1667936422, 1510238771, 1503613101, 4084104273,
            647580587,  1460988169, 3944640945, 3301866374, 3458437694, 2913596196, 2960957119,
            1316491503, 2674694926, 2404530503, 2485431762, 692294537,  3148362914, 1645995464,
            3697728317, 706771848,  3734467362, 2768750385, 670964862,  1337146928, 1449841372,
            1239527551, 592595530,  4204421245, 3121493408, 4147988039, 4003871917, 4035869533,
            3652555523, 2709537023, 1429645393, 565106475,  327014810,  2716443687, 1278935671,
            915509292,  397356303,  3248246752, 204830047,  1086107506, 1795464380, 3485315196,
            1731529670, 662578255,  3645735256, 850847993,  1794523220, 577288126,  4237140216,
            1126950,    2601642298, 1469035973, 2727135938, 92392213,   3668777652, 756260381,
            41782389,   226724724,  1123105466, 738274780,  1846857904, 3185630605, 823108172,
            2880110296, 3371270228, 2865413534, 564221408,  591845835,  2356214088, 4157618574,
            1336639597, 4180084026, 3195588503, 4266261353, 3844986377, 2073158796, 56968669,
            1234765864, 3166457679, 1001761927, 3146725645, 3295822468, 4135196531, 496099322,
            541676954,  4143543278, 1941480444, 3607603517, 2578543796, 1068806322, 4081693775,
            3600072515, 651444872,  1131603264, 47991343,   3748890341, 3413467790, 1567802204,
            2823058381, 2662653600, 1516568259, 4132590383, 3192977084, 4247798474, 2554440323,
            461466951,  1313208797, 637811069,  2744898822, 982676468,  3444149988, 1764224523,
            4016338923, 2845667517, 451503008,  2594402002, 373730087,  3013524828, 3442521115,
            1086137206, 2740782133, 2391000148, 3964107377, 4060067791, 731470002,  3161911677,
            3441985401, 2472173593, 4227407417, 44456710,   3623045141, 1873516415, 884116165,
            2550700713, 4004771121, 1053106195, 838088473,  2279863068, 1296332348, 1587145121,
            1806935386, 4138151954, 4030442072, 2552496880, 2570695340, 2328331779, 3132267322,
            227377796,  3887816270, 3570998746, 3654577129, 1603734504, 1528807885, 3365552060,
            188017185,  2134741424, 809367801,  1667936422, 1358744245, 1503613101, 4084104273,
            647580587,  1460988169, 2318828416, 3301866374, 3458437694, 2913596196, 2960957119,
            49464436,   2674694926, 2404530503, 2485431762, 692294537,  1803418945, 1645995464,
            3697728317, 706771848,  3734467362, 2407932841, 670964862,  1337146928, 1449841372,
            1239527551, 1124552917, 4204421245, 3121493408, 4147988039, 4003871917, 3542256025,
            3652555523, 2709537023, 1429645393, 565106475,  2063548817, 2716443687, 1278935671,
            915509292,  397356303,  1049916999, 204830047,  1086107506, 1795464380, 3485315196,
            2183256184, 662578255,  3645735256, 850847993,  1794523220, 2943700388, 4237140216,
            1126950,    2601642298, 1469035973, 535075238,  92392213,   3668777652, 756260381,
            41782389,   1043025574, 1123105466, 738274780,  1846857904, 3185630605, 3324487649,
            2880110296, 3371270228, 2865413534, 564221408,  2528599862, 2356214088, 4157618574,
            1336639597, 4180084026, 592094844,  4266261353, 3844986377, 2073158796, 56968669,
            629503707,  3166457679, 1001761927, 3146725645, 3295822468, 2725304934, 496099322,
            541676954,  4143543278, 1941480444, 3557859116, 31832949,   3805791401, 4056283801,
            242812250,  4072988068, 2316479446, 2260433816, 2211372380, 2039672698, 2947948280,
            4106140026, 342600216,  98745656,   2541799209, 926067404,  2733213159, 3163537903,
            2800370126, 2099121446, 1279545581, 3699822446, 3764095615, 690503808,  3799637505,
            1000641330, 242588257,  3657834529, 824791208,  2529299371, 4081898575, 2120338882,
            1273883107, 1680877886, 1253060582, 1760259553, 2250763915, 31780198,   2511451445,
            3102141340, 861489797,  105854693,  70927387,   2725671050, 688282241,  2622257646,
            3466254816, 1905008219, 2980966436, 2154356718, 1075686806, 1966147415, 2357249256,
            2684600972, 400926709,  523449509,  2891602783, 673425710,  3766475216, 2319843954,
            3471794777, 13838840,   1908374660, 3839606132, 3829795513, 3403561639, 1369780874,
            4276407916, 3217619,    1284482371, 2020138237, 2804427294, 1194369854, 1094800747,
            2119081501, 726494474,  490750173,  1117517565, 3498786968, 2163060528, 696718831,
            2780121254, 1286646297, 1594539045, 411215116,  1407268753, 2759136967, 2179483407,
            2088977769, 2737453188, 2411478102, 3112688013, 4112484868, 429293789,  426390687,
            3158027863, 2601897382, 1546855515, 4258208908, 3691263847, 2394986813, 1986623921,
            2632462203, 3551311099, 3309482741, 2632571927, 1200010240, 554555739,  4119397989,
            622818813,  3116222066, 1801867255, 2738500841, 1452697246, 733457482,  1680421668,
            1035766144, 468847991,  3606474156, 2612692123, 730556693,  859096521,  4005878655,
            1138273887, 2182363629, 2710579590, 3345140092, 2562710857, 3859276724, 2318176233,
            3964665794, 3295219265, 3037789445, 371545704,  3434130670, 3686032092, 19964088,
            340386179,  2147090894, 1446742483, 3083526520, 561888846,  2903328518, 1524465288,
            360120037,  2031515996, 1516035872, 2752848969, 1094251072, 984159948,  369999653,
            864602622,  2402584241, 3028363830, 252580667,  480470405,  3201548259, 2739036185,
            2198549891, 1978812013,
        },
        {
            1771626587, 1995114906, 2979882718, 1173787846, 712398037,  2354900474, 3891222483,
            157113232,  4043170817, 1238035896, 3965643869, 3081758913, 112956918,  319437186,
            3091696106, 2581758800, 1801916375, 3025319378, 2210033145, 1672789838, 1239470104,
            3647435758, 3916970057, 1571878767, 1150547225, 1802751615, 1519163575, 2232775727,
            3597847565, 655291229,  3377406498, 3700466740, 1984908854, 810505854,  1843070418,
            3436400904, 3066705784, 3372326667, 985874871,  1273348739, 2975409312, 390383825,
            2830871303, 3657621744, 4072213720, 3560256550, 2169150098, 3107449158, 1727233766,
            2418068709, 2933503369, 423994869,  2690292552, 67752398,   4154068883, 3082158987,
            3812365282, 2265436517, 469908660,  1640119835, 3449559311, 463550333,  4247693347,
            2367938947, 3966834868, 2894467597, 1736109486, 929335401,  408315099,  639807782,
            3996280854, 448743368,  3762383148, 4214267236, 2316514953, 2070230973, 2940922936,
            727196895,  2878291986, 2986999584, 4136816919, 3861446282, 66717257,   1670613911,
            3161003924, 3716370078, 3211910335, 726991673,  436588642,  3529361773, 419207398,
            241152969,  2392054316, 2423109892, 733817356,  3497235308, 776741078,  2625458932,
            3300116651, 1092149319, 2911601235, 3005245441, 3962474337, 1510861271, 630003348,
            1911605091, 409742152,  4156672561, 1875934477, 1383072073, 1746494486, 3679220904,
            2690181722, 851273533,  2064185250, 991893127,  2730391633, 4173529240, 3550093683,
            2243451886, 1199217320, 2224011496, 1015123007, 2627385341, 3340665011, 2218035933,
            2159012714, 4104972337, 2198809953, 4119117079, 127209767,  3272196160, 3981210032,
            2284259638, 2849180340, 178885288,  2367082698, 1564105523, 2705128744, 1616962768,
            2308624507, 2909308236, 2304894666, 80195292,   441200082,  3764035210, 4110155431,
            1170025579, 2966671698, 1220886043, 595997503,  1145662963, 925314024,  2433420442,
            1506985736, 2864893278, 2001744905, 2299370223, 3899113760, 513314351,  3654524139,
            1771626587, 1995114906, 2979882718, 1173787846, 3172927187, 2354900474, 3891222483,
            157113232,  4043170817, 2703051423, 3965643869, 3081758913, 112956918,  319437186,
            1590900401, 2581758800, 1801916375, 3025319378, 2210033145, 2552031741, 1239470104,
            3647435758, 3916970057, 1571878767, 2767419221, 1802751615, 1519163575, 2232775727,
            3597847565, 4122208687, 3377406498, 3700466740, 1984908854, 810505854,  2428630373,
            3436400904, 3066705784, 3372326667, 985874871,  2896548895, 2975409312, 390383825,
            2830871303, 3657621744, 1817167230, 3560256550, 2169150098, 3107449158, 1727233766,
            3199087324, 2933503369, 423994869,  2690292552, 67752398,   1994875012, 3082158987,
            3812365282, 2265436517, 469908660,  1917441435, 3449559311, 463550333,  4247693347,
            2367938947, 3099719011, 2894467597, 1736109486, 929335401,  408315099,  2552120803,
            3996280854, 448743368,  3762383148, 4214267236, 3017308146, 2070230973, 2940922936,
            727196895,  2878291986, 1311944939, 4136816919, 3861446282, 66717257,   1670613911,
            3758356270, 3716370078, 3211910335, 726991673,  436588642,  3126940725, 419207398,
            241152969,  2392054316, 2423109892, 2638079941, 3497235308, 776741078,  2625458932,
            3300116651, 2439925057, 2911601235, 3005245441, 3962474337, 1510861271, 1428731407,
            1911605091, 409742152,  4156672561, 1875934477, 3889450414, 1746494486, 3679220904,
            2690181722, 851273533,  3791662921, 991893127,  2730391633, 4173529240, 3550093683,
            2816627549, 1199217320, 2224011496, 1015123007, 2627385341, 4252346408, 2218035933,
            2159012714, 4104972337, 2198809953, 2127533336, 127209767,  3272196160, 3981210032,
            2284259638, 2493997429, 178885288,  2367082698, 1564105523, 2705128744, 1042711709,
            2308624507, 2909308236, 2304894666, 80195292,   1138823814, 3764035210, 4110155431,
            1170025579, 2966671698, 1607728754, 595997503,  1145662963, 925314024,  2433420442,
            3939345403, 2864893278, 2001744905, 2299370223, 3899113760, 2247056863, 3654524139,
            1771626587, 1995114906, 2979882718, 802841766,  3172927187, 2354900474, 3891222483,
            157113232,  3999285594, 2703051423, 3965643869, 3081758913, 112956918,  665557601,
            1590900401, 2581758800, 1801916375, 3025319378, 418969789,  2552031741, 1239470104,
            3647435758, 3916970057, 3443541927, 2767419221, 1802751615, 1519163575, 2232775727,
            407073823,  4122208687, 3377406498, 3700466740, 1984908854, 731990021,  2428630373,
            3436400904, 3066705784, 3372326667, 2322035812, 2896548895, 2975409312, 390383825,
            2830871303, 907193258,  1817167230, 3560256550, 2169150098, 3107449158, 2138343426,
            3199087324, 2933503369, 423994869,  2690292552, 2266199142, 1994875012, 3082158987,
            3812365282, 2265436517, 2116591296, 1917441435, 3449559311, 463550333,  4247693347,
            4122488141, 3099719011, 2894467597, 1736109486, 929335401,  149170272,  2552120803,
            3996280854, 448743368,  3762383148, 378975625,  3017308146, 2070230973, 2940922936,
            727196895,  4150298269, 1311944939, 4136816919, 3861446282, 66717257,   1700075979,
            3758356270, 3716370078, 3211910335, 726991673,  1110586293, 3126940725, 419207398,
            241152969,  2392054316, 1856054673, 2638079941, 3497235308, 776741078,  2625458932,
            3922433320, 2439925057, 2911601235, 3005245441, 3962474337, 1341811077, 1428731407,
            1911605091, 409742152,  4156672561, 2754446897, 3889450414, 1746494486, 3679220904,
            2690181722, 2109048395, 3791662921, 991893127,  2730391633, 4173529240, 3758166823,
            2816627549, 1199217320, 2224011496, 1015123007, 283364949,  4252346408, 2218035933,
            2159012714, 4104972337, 3209277954, 2127533336, 127209767,  3272196160, 3981210032,
            501693470,  2493997429, 178885288,  2367082698, 1564105523, 3343285437, 1042711709,
            2308624507, 2909308236, 2304894666, 2068137811, 1138823814, 3764035210, 4110155431,
            1170025579, 1519515096, 1607728754, 595997503,  1145662963, 925314024,  1086253380,
            3939345403, 2864893278, 2001744905, 2299370223, 2030233679, 2247056863, 3654524139,
            1771626587, 1995114906, 2790725054, 802841766,  3172927187, 2354900474, 3891222483,
            2665601358, 3999285594, 2703051423, 3965643869, 3081758913, 741408188,  665557601,
            1590900401, 2581758800, 1801916375, 2105130033, 418969789,  2552031741, 1239470104,
            3647435758, 3908246453, 3443541927, 2767419221, 1802751615, 1519163575, 3882429490,
            407073823,  4122208687, 3377406498, 3700466740, 3245982785, 731990021,  2428630373,
            3436400904, 3066705784, 1377060951, 2322035812, 2896548895, 2975409312, 390383825,
            3495621775, 907193258,  1817167230, 3560256550, 2169150098, 472966883,  2138343426,
            3199087324, 2933503369, 423994869,  1037968206, 2266199142, 1994875012, 3082158987,
            3812365282, 985997213,  2116591296, 1917441435, 3449559311, 463550333,  462207972,
            4122488141, 3099719011, 2894467597, 1736109486, 4093132367, 149170272,  2552120803,
            3996280854, 448743368,  638584603,  378975625,  3017308146, 2070230973, 2940922936,
            1681549953, 4150298269, 1311944939, 4136816919, 3861446282, 3877683991, 1700075979,
            3758356270, 3716370078, 3211910335, 692214339,  1110586293, 3126940725, 419207398,
            241152969,  4057525912, 1856054673, 2638079941, 3497235308, 776741078,  792034751,
            3922433320, 2439925057, 2911601235, 3005245441, 741250796,  1341811077, 1428731407,
            1911605091, 409742152,  2646675416, 2754446897, 3889450414, 1746494486, 3679220904,
            650623545,  2109048395, 3791662921, 991893127,  2730391633, 1078168334, 3758166823,
            2816627549, 1199217320, 2224011496, 3995307892, 283364949,  4252346408, 2218035933,
            2159012714, 140460991,  3209277954, 2127533336, 127209767,  3272196160, 3425934278,
            501693470,  2493997429, 178885288,  2367082698, 2368989437, 3343285437, 1042711709,
            2308624507, 2909308236, 2286336495, 2068137811, 1138823814, 3764035210, 4110155431,
            393558347,  1519515096, 1607728754, 595997503,  1145662963, 1634610754, 1086253380,
            3939345403, 2864893278, 2001744905, 3724132139, 2781482841, 923172347,  1231276176,
            2993411839, 2870130353, 341272967,  1928390973, 1662360645, 2877007789, 1291706722,
            487207447,  2181893436, 719286781,  2411981337, 2377711673, 2855059775, 3572605048,
            3102649538, 3543627231, 20011069,   388181885,  2813733248, 2458975796, 1876825929,
            420661896,  1232987164, 2902094763, 1144182290, 3526295588, 3474328123, 1902607985,
            164574814,  1229092793, 2882986527, 195378362,  1500969766, 852245003,  4063976013,
            2875822718, 1802226545, 2825780800, 2906275401, 3031316837, 654382376,  3097244961,
            684183568,  1278989036, 4251850825, 1501958793, 1494767736, 1626029104, 3040782408,
            735819652,  1686772763, 2477392861, 1075546408, 1345754403, 2508298555, 461866020,
            2433908070, 2402333805, 3039941427, 586549485,  4119253158, 1073811902, 1391372630,
            3709472731, 1893547750, 2733046457, 633569963,  2862685306, 541797648,  3783794198,
            2147923695, 4000295355, 2537449581, 3008392348, 967843476,  2189808860, 619173526,
            1143601566, 3851292229, 451723588,  2620857180, 157483788,  2051836864, 352765022,
            2126370386, 3105273933, 2090508446, 2181961994, 1507686117, 2411512047, 1862373179,
            1598146253, 855159160,  959972858,  3226533365, 4178273671, 83117449,   1455911238,
            2974842858, 1883835151, 1396387359, 2484030427, 169825877,  2344150306, 438837377,
            861281342,  3621184471, 2581683290, 1811997247, 4165064498, 1518557618, 2623641901,
            1700892947, 1683300298, 3911715614, 1732813092, 2097564016, 240950148,  1349990820,
            2398725955, 2395567308, 2990443362, 3462257394, 3300422572, 1485765596, 4263003103,
            3556159573, 1372338260, 1939175587, 3403410070, 1427899118, 3754406407, 2088831122,
            1870478237, 3045047485, 465464251,  857299450,  3190468871, 2037173690, 1196050727,
            3469777244, 2453724900, 436627211,  1631789144, 581055198,  3271076948, 2321927102,
            2635133685, 3347121965, 2555574623, 3151284832, 1869947219, 236654353,  1319495253,
            2758297006, 246057200,
        },
        {
            2546657140, 2771792972, 3371698159, 1137313111, 2399264952, 1204642544, 2090179262,
            2948712987, 2908027331, 498636511,  2292804841, 1480836858, 2826016727, 196495965,
            2168559184, 3910150715, 320076735,  3144753899, 3199094529, 1165806050, 728308199,
            2322528104, 2891334400, 561853019,  4161870615, 1348321971, 2461357166, 1216229488,
            1392766290, 3060494848, 3282469664, 1866493654, 2351421557, 4195620347, 1512242723,
            478174598,  1087303780, 471631659,  2599553643, 791527994,  563537164,  1238109907,
            3218421602, 133222502,  4182363220, 305688802,  2666439314, 2408520958, 787389550,
            4226450542, 4107143646, 4103547035, 1840887424, 2686247491, 334267386,  3772035402,
            3436827662, 1411515743, 2193739735, 1892746640, 4163192062, 2921191805, 1011310614,
            2178118214, 33647321,   1121452997, 507942677,  2542792587, 351339975,  1586639416,
            1918003826, 2513357034, 2747854573, 606238275,  1132105249, 574593993,  2655425816,
            1680556547, 1831942411, 2587194016, 90710116,   4291431098, 1899367028, 3251152898,
            3297078396, 2712235924, 1546135008, 897753268,  1619454780, 938130143,  1828916640,
            3620488958, 1822437033, 172584228,  1853048226, 3659288522, 3623450763, 1893292786,
            851522142,  3411705687, 4106341088, 4109830348, 1193339049, 878885723,  2964062476,
            2320209608, 1777678953, 2886897705, 3856938396, 252913914,  3648685154, 544382669,
            2631141468, 1524405364, 1848509666, 580646927,  2451560151, 181916967,  1426301928,
            1652422182, 2625099169, 176664750,  1582626255, 1675120608, 2571617898, 2096572277,
            2471745846, 419906507,  886861124,  1974832558, 3157060904, 216000225,  746978071,
            1424984058, 1457979883, 809822177,  3833178010, 3926414726, 1423462846, 3024443248,
            4067020014, 2881559869, 1376840097, 548130303,  1118013762, 1309103114, 2227304261,
            4205319357, 228947246,  2167410411, 620496852,  2724112116, 705259153,  3499686911,
            3085999115, 2447267299, 4190122199, 1091465954, 1233728238, 39711865,   1076751044,
            2546657140, 2771792972, 3371698159, 1137313111, 3857150586, 1204642544, 2090179262,
            2948712987, 2908027331, 368199414,  2292804841, 1480836858, 2826016727, 196495965,
            3235583934, 3910150715, 320076735,  3144753899, 3199094529, 1374597050, 728308199,
            2322528104, 2891334400, 561853019,  1515915224, 1348321971, 2461357166, 1216229488,
            1392766290, 15252704,   3282469664, 1866493654, 2351421557, 4195620347, 192355609,
            478174598,  1087303780, 471631659,  2599553643, 1725604263, 563537164,  1238109907,
            3218421602, 133222502,  305098282,  305688802,  2666439314, 2408520958, 787389550,
            3195522899, 4107143646, 4103547035, 1840887424, 2686247491, 1565529892, 3772035402,
            3436827662, 1411515743, 2193739735, 1848198417, 4163192062, 2921191805, 1011310614,
            2178118214, 3474206203, 1121452997, 507942677,  2542792587, 351339975,  3599278861,
            1918003826, 2513357034, 2747854573, 606238275,  446979745,  574593993,  2655425816,
            1680556547, 1831942411, 3338512802, 90710116,   4291431098, 1899367028, 3251152898,
            1006512939, 2712235924, 1546135008, 897753268,  1619454780, 1429190743, 1828916640,
            3620488958, 1822437033, 172584228,  2529855020, 3659288522, 3623450763, 1893292786,
            851522142,  1417935793, 4106341088, 4109830348, 1193339049, 878885723,  1886400637,
            2320209608, 1777678953, 2886897705, 3856938396, 1813134786, 3648685154, 544382669,
            2631141468, 1524405364, 687661410,  580646927,  2451560151, 181916967,  1426301928,
            1463347373, 2625099169, 176664750,  1582626255, 1675120608, 3387060344, 2096572277,
            2471745846, 419906507,  886861124,  4209699955, 3157060904, 216000225,  746978071,
            1424984058, 3063941448, 809822177,  3833178010, 3926414726, 1423462846, 750559587,
            4067020014, 2881559869, 1376840097, 548130303,  4056763004, 1309103114, 2227304261,
            4205319357, 228947246,  774411056,  620496852,  2724112116, 705259153,  3499686911,
            2486247387, 2447267299, 4190122199, 1091465954, 1233728238, 54639263,   1076751044,
            2546657140, 2771792972, 3371698159, 1152150303, 3857150586, 1204642544, 2090179262,
            2948712987, 452427847,  368199414,  2292804841, 1480836858, 2826016727, 1929008184,
            3235583934, 3910150715, 320076735,  3144753899, 895636897,  1374597050, 728308199,
            2322528104, 2891334400, 1871824871, 1515915224, 1348321971, 2461357166, 1216229488,
            3170568098, 15252704,   3282469664, 1866493654, 2351421557, 4253216490, 192355609,
            478174598,  1087303780, 471631659,  4230260400, 1725604263, 563537164,  1238109907,
            3218421602, 960481514,  305098282,  305688802,  2666439314, 2408520958, 242741163,
            3195522899, 4107143646, 4103547035, 1840887424, 2768321503, 1565529892, 3772035402,
            3436827662, 1411515743, 545362965,  1848198417, 4163192062, 2921191805, 1011310614,
            1196775493, 3474206203, 1121452997, 507942677,  2542792587, 1948892535, 3599278861,
            1918003826, 2513357034, 2747854573, 4172793632, 446979745,  574593993,  2655425816,
            1680556547, 2986869736, 3338512802, 90710116,   4291431098, 1899367028, 3376952160,
            1006512939, 2712235924, 1546135008, 897753268,  2061577225, 1429190743, 1828916640,
            3620488958, 1822437033, 4221327184, 2529855020, 3659288522, 3623450763, 1893292786,
            16446898,   1417935793, 4106341088, 4109830348, 1193339049, 2895194326, 1886400637,
            2320209608, 1777678953, 2886897705, 117861450,  1813134786, 3648685154, 544382669,
            2631141468, 1105253905, 687661410,  580646927,  2451560151, 181916967,  1605087684,
            1463347373, 2625099169, 176664750,  1582626255, 1993431057, 3387060344, 2096572277,
            2471745846, 419906507,  3219719670, 4209699955, 3157060904, 216000225,  746978071,
            3304126047, 3063941448, 809822177,  3833178010, 3926414726, 4061584738, 750559587,
            4067020014, 2881559869, 1376840097, 973425409,  4056763004, 1309103114, 2227304261,
            4205319357, 939664759,  774411056,  620496852,  2724112116, 705259153,  176172666,
            2486247387, 2447267299, 4190122199, 1091465954, 300145620,  54639263,   1076751044,
            2546657140, 2771792972, 188149161,  1152150303, 3857150586, 1204642544, 2090179262,
            626100323,  452427847,  368199414,  2292804841, 1480836858, 2700509669, 1929008184,
            3235583934, 3910150715, 320076735,  1715326239, 895636897,  1374597050, 728308199,
            2322528104, 2356051490, 1871824871, 1515915224, 1348321971, 2461357166, 243332180,
            3170568098, 15252704,   3282469664, 1866493654, 4079212881, 4253216490, 192355609,
            478174598,  1087303780, 3787911270, 4230260400, 1725604263, 563537164,  1238109907,
            1147223471, 960481514,  305098282,  305688802,  2666439314, 1503870433, 242741163,
            3195522899, 4107143646, 4103547035, 4041516761, 2768321503, 1565529892, 3772035402,
            3436827662, 3952861918, 545362965,  1848198417, 4163192062, 2921191805, 793561655,
            1196775493, 3474206203, 1121452997, 507942677,  3788690254, 1948892535, 3599278861,
            1918003826, 2513357034, 3301940062, 4172793632, 446979745,  574593993,  2655425816,
            667233719,  2986869736, 3338512802, 90710116,   4291431098, 2027122085, 3376952160,
            1006512939, 2712235924, 1546135008, 2609276017, 2061577225, 1429190743, 1828916640,
            3620488958, 1603195641, 4221327184, 2529855020, 3659288522, 3623450763, 2313432963,
            16446898,   1417935793, 4106341088, 4109830348, 4106013120, 2895194326, 1886400637,
            2320209608, 1777678953, 1952597964, 117861450,  1813134786, 3648685154, 544382669,
            3108229631, 1105253905, 687661410,  580646927,  2451560151, 1160575897, 1605087684,
            1463347373, 2625099169, 176664750,  1998534134, 1993431057, 3387060344, 2096572277,
            2471745846, 2246406696, 3219719670, 4209699955, 3157060904, 216000225,  902956869,
            3304126047, 3063941448, 809822177,  3833178010, 815366736,  4061584738, 750559587,
            4067020014, 2881559869, 350775477,  973425409,  4056763004, 1309103114, 2227304261,
            2047915817, 939664759,  774411056,  620496852,  2724112116, 3593903529, 176172666,
            2486247387, 2447267299, 4190122199, 1450746791, 1521739409, 272699299,  4113952664,
            1408743622, 4082014187, 2454446462, 1401621236, 2050232096, 4204834821, 2413497685,
            1032465253, 4276089655, 1737267711, 3335718398, 1924071395, 1560525661, 3064183869,
            1775038231, 89761304,   489201378,  1236489133, 2774076159, 822652970,  1583752702,
            1781766972, 2238480533, 3428349870, 3344555477, 2251934941, 2533404243, 3651295253,
            2359372862, 704049384,  3238382362, 2405156187, 2572833624, 531907732,  2240111412,
            4102445586, 849739856,  3649572083, 3317634415, 1141345331, 1118528358, 1664181643,
            648360156,  1364897187, 289264571,  1625825195, 1075970578, 3925373833, 2780782646,
            727038162,  2824687935, 3844230994, 2070739238, 2437298873, 1837327520, 4248571219,
            183041221,  3759390508, 3881974011, 658115161,  560642175,  32860408,   1321227669,
            1380454450, 1676524786, 476585241,  4034481274, 1110506516, 815601591,  2009522227,
            2168306897, 1856639149, 1328281664, 2710915389, 1886116025, 2074502324, 23109943,
            670045122,  2926671795, 4269143768, 2688621201, 1618605914, 1541217762, 4273045819,
            1029546542, 3663663567, 1402692384, 109336276,  2446546057, 2225682064, 3535545430,
            3847123891, 369718877,  3411726117, 703735748,  3139527634, 22388546,   998860697,
            2532911305, 1532808237, 4170332196, 1131906845, 1814343609, 4161931326, 1185668213,
            1903273604, 3466154373, 3988139604, 1079368270, 991305574,  898158502,  2898908951,
            651161128,  1952607949, 1221528540, 29979722,   3006846808, 2911550178, 2569412437,
            1460616937, 2127921978, 3689931108, 950505297,  3469337654, 3180457017, 2316433735,
            1464678429, 2867173456, 391248106,  3622065314, 2143251073, 860219584,  323835636,
            340886643,  1805485977, 109344001,  1537119779, 1795626099, 2568079633, 3048040562,
            1204069532, 2488753091, 2160014198, 3132782711, 1266102795, 91252225,   2018366053,
            39675212,   979320891,  343397131,  814470367,  366655857,  3287033048, 3379301026,
            1566381433, 3431153818,
        },
        {
            2140097344, 2534341523, 413767653,  2748728589, 863424611,  2982815922, 488251462,
            408373264,  1510643875, 1608447326, 2573232248, 3049164876, 857991162,  93340887,
            2217441666, 2078780887, 3558037358, 3290391311, 5214906,    2686787348, 1905487472,
            2131529193, 3524139158, 4231643040, 4005586579, 1635399441, 105900158,  3395900558,
            2084191313, 2356615362, 735225228,  4216307064, 3727744134, 2760343135, 2940053719,
            1712243027, 333383977,  1033103785, 2786649799, 2410527179, 1588830829, 2381682101,
            2353244880, 2095075128, 2825923530, 2684622385, 3673656560, 2063799478, 1059465838,
            213914213,  3626045355, 23164914,   739607662,  2368844039, 3448088063, 1622028163,
            1836826142, 326653179,  836126896,  140115482,  3252467862, 4079229804, 938966502,
            1099649284, 4014519097, 3004487814, 3890530519, 155202876,  864255208,  345401395,
            502653178,  531332145,  3518404238, 2747006502, 2887327559, 187780710,  2681002406,
            2388129918, 2691140314, 3578168202, 4028126763, 1263776149, 3806284973, 2798592754,
            741394557,  1043273240, 2847630794, 2831159037, 2654874093, 3867615152, 1900371169,
            1971768599, 3178405487, 1202605968, 2315555760, 2398544048, 770017687,  3417169749,
            3460290220, 463945360,  2916336207, 1591423346, 1655648606, 1419021134, 1339927964,
            493094464,  2331303884, 539691381,  3252671791, 2397035798, 1863263573, 422329646,
            3378293804, 1141958824, 653384457,  2701231568, 2880839566, 328672878,  740799511,
            568420514,  3876376258, 521868584,  421489535,  2109234486, 959969018,  661221615,
            3517856965, 345058219,  2363193924, 2465519866, 924538017,  3109611097, 231986016,
            721670298,  2364661786, 4200517407, 3390935119, 4112875163, 351243052,  2981285835,
            1560360297, 711528092,  3136811069, 4159305179, 4265899678, 1929830658, 3269201006,
            3345099078, 3140904240, 182949248,  1776571890, 3693359241, 151978660,  3565622806,
            2371397288, 114174603,  3468078118, 208053176,  1348291144, 3780814816, 2049988317,
            2140097344, 2534341523, 413767653,  2748728589, 2968485321, 2982815922, 488251462,
            408373264,  1510643875, 2470717052, 2573232248, 3049164876, 857991162,  93340887,
            2091339362, 2078780887, 3558037358, 3290391311, 5214906,    1501462206, 1905487472,
            2131529193, 3524139158, 4231643040, 3632562347, 1635399441, 105900158,  3395900558,
            2084191313, 842448522,  735225228,  4216307064, 3727744134, 2760343135, 893855504,
            1712243027, 333383977,  1033103785, 2786649799, 3348500109, 1588830829, 2381682101,
            2353244880, 2095075128, 1442620129, 2684622385, 3673656560, 2063799478, 1059465838,
            2806566815, 3626045355, 23164914,   739607662,  2368844039, 3593308461, 1622028163,
            1836826142, 326653179,  836126896,  3178354723, 3252467862, 4079229804, 938966502,
            1099649284, 3289931358, 3004487814, 3890530519, 155202876,  864255208,  376386150,
            502653178,  531332145,  3518404238, 2747006502, 654973674,  187780710,  2681002406,
            2388129918, 2691140314, 1315154222, 4028126763, 1263776149, 3806284973, 2798592754,
            2708332643, 1043273240, 2847630794, 2831159037, 2654874093, 1902293205, 1900371169,
            1971768599, 3178405487, 1202605968, 399953168,  2398544048, 770017687,  3417169749,
            3460290220, 1046921613, 2916336207, 1591423346, 1655648606, 1419021134, 1042532268,
            493094464,  2331303884, 539691381,  3252671791, 3561535820, 1863263573, 422329646,
            3378293804, 1141958824, 2649709654, 2701231568, 2880839566, 328672878,  740799511,
            1856861487, 3876376258, 521868584,  421489535,  2109234486, 2490158626, 661221615,
            3517856965, 345058219,  2363193924, 3258392789, 924538017,  3109611097, 231986016,
            721670298,  1266924878, 4200517407, 3390935119, 4112875163, 351243052,  3906493718,
            1560360297, 711528092,  3136811069, 4159305179, 32027157,   1929830658, 3269201006,
            3345099078, 3140904240, 3233261303, 1776571890, 3693359241, 151978660,  3565622806,
            1884879178, 114174603,  3468078118, 208053176,  1348291144, 366445856,  2049988317,
            2140097344, 2534341523, 413767653,  1462517569, 2968485321, 2982815922, 488251462,
            408373264,  55611491,   2470717052, 2573232248, 3049164876, 857991162,  2837992873,
            2091339362, 2078780887, 3558037358, 3290391311, 77062807,   1501462206, 1905487472,
            2131529193, 3524139158, 211495611,  3632562347, 1635399441, 105900158,  3395900558,
            1819599340, 842448522,  735225228,  4216307064, 3727744134, 853151607,  893855504,
            1712243027, 333383977,  1033103785, 3670450101, 3348500109, 1588830829, 2381682101,
            2353244880, 1128065312, 1442620129, 2684622385, 3673656560, 2063799478, 3863310854,
            2806566815, 3626045355, 23164914,   739607662,  254650228,  3593308461, 1622028163,
            1836826142, 326653179,  112056423,  3178354723, 3252467862, 4079229804, 938966502,
            2070310234, 3289931358, 3004487814, 3890530519, 155202876,  3773125984, 376386150,
            502653178,  531332145,  3518404238, 1381045914, 654973674,  187780710,  2681002406,
            2388129918, 743408465,  1315154222, 4028126763, 1263776149, 3806284973, 3091505066,
            2708332643, 1043273240, 2847630794, 2831159037, 3499041796, 1902293205, 1900371169,
            1971768599, 3178405487, 1996768556, 399953168,  2398544048, 770017687,  3417169749,
            164286741,  1046921613, 2916336207, 1591423346, 1655648606, 2170904914, 1042532268,
            493094464,  2331303884, 539691381,  181273242,  3561535820, 1863263573, 422329646,
            3378293804, 50210105,   2649709654, 2701231568, 2880839566, 328672878,  1136699923,
            1856861487, 3876376258, 521868584,  421489535,  2510310340, 2490158626, 661221615,
            3517856965, 345058219,  2344008775, 3258392789, 924538017,  3109611097, 231986016,
            1913216206, 1266924878, 4200517407, 3390935119, 4112875163, 2176056642, 3906493718,
            1560360297, 711528092,  3136811069, 131820738,  32027157,   1929830658, 3269201006,
            3345099078, 915061618,  3233261303, 1776571890, 3693359241, 151978660,  1835679296,
            1884879178, 114174603,  3468078118, 208053176,  1144327938, 366445856,  2049988317,
            2140097344, 2534341523, 2519631170, 1462517569, 2968485321, 2982815922, 488251462,
            1545957954, 55611491,   2470717052, 2573232248, 3049164876, 4092342988, 2837992873,
            2091339362, 2078780887, 3558037358, 976550020,  77062807,   1501462206, 1905487472,
            2131529193, 3037378752, 211495611,  3632562347, 1635399441, 105900158,  1778598536,
            1819599340, 842448522,  735225228,  4216307064, 3240301760, 853151607,  893855504,
            1712243027, 333383977,  1562226710, 3670450101, 3348500109, 1588830829, 2381682101,
            78627415,   1128065312, 1442620129, 2684622385, 3673656560, 3733009936, 3863310854,
            2806566815, 3626045355, 23164914,   3052194812, 254650228,  3593308461, 1622028163,
            1836826142, 2383219960, 112056423,  3178354723, 3252467862, 4079229804, 1793074699,
            2070310234, 3289931358, 3004487814, 3890530519, 371095854,  3773125984, 376386150,
            502653178,  531332145,  1231582325, 1381045914, 654973674,  187780710,  2681002406,
            166232863,  743408465,  1315154222, 4028126763, 1263776149, 2714321422, 3091505066,
            2708332643, 1043273240, 2847630794, 1791361439, 3499041796, 1902293205, 1900371169,
            1971768599, 322940632,  1996768556, 399953168,  2398544048, 770017687,  2513347589,
            164286741,  1046921613, 2916336207, 1591423346, 3478658630, 2170904914, 1042532268,
            493094464,  2331303884, 853081831,  181273242,  3561535820, 1863263573, 422329646,
            23475199,   50210105,   2649709654, 2701231568, 2880839566, 2396682993, 1136699923,
            1856861487, 3876376258, 521868584,  2433337122, 2510310340, 2490158626, 661221615,
            3517856965, 425104684,  2344008775, 3258392789, 924538017,  3109611097, 1848257871,
            1913216206, 1266924878, 4200517407, 3390935119, 402341299,  2176056642, 3906493718,
            1560360297, 711528092,  534583455,  131820738,  32027157,   1929830658, 3269201006,
            3259676790, 915061618,  3233261303, 1776571890, 3693359241, 524791671,  1835679296,
            1884879178, 114174603,  3468078118, 4000224145, 630769696,  3807052245, 2146402480,
            1535192534, 2036361218, 1026645957, 1094534360, 1285116115, 4281291061, 1685735492,
            627447765,  456645755,  323462541,  4225177129, 1187652507, 250374090,  3178356129,
            2753170540, 1487740354, 2411943091, 3533982933, 3878999992, 1541531174, 1359183724,
            3531584133, 723526748,  3175836098, 41691476,   1185391888, 490286547,  1023499213,
            2603900810, 1911610332, 2405604387, 3150608029, 448131010,  1707909039, 2270215289,
            2806740681, 1733550306, 822573562,  3853209376, 2071066426, 2607806856, 1280650777,
            2599446309, 1739833405, 631356245,  1192581906, 1245394070, 3393316267, 3639753436,
            3577799283, 603968673,  1616678303, 1302560538, 3621455046, 1175784419, 3626064119,
            189344014,  241871215,  1498199703, 3199053023, 3095602267, 3523906411, 3196014136,
            401529225,  3266377334, 1247974257, 1593567021, 4109806961, 2868516656, 782121337,
            3611440951, 2551396729, 2505432232, 1206093320, 4271537303, 1739768422, 2335083673,
            1368115103, 1519436395, 3354538002, 1639709451, 110486360,  3539466987, 289829281,
            1002880385, 1783989524, 3155374962, 3203002145, 2450201647, 3827953332, 2957454443,
            1143902628, 2162641978, 2658394229, 2451173527, 651749039,  3545090073, 659850917,
            3540081495, 1448189234, 2864935396, 1974164413, 2079659232, 2347576387, 1874603661,
            95590424,   1748819404, 4235056906, 121651790,  623615550,  3301706581, 3623252806,
            1771104611, 465362418,  976746120,  3204758832, 1641540281, 4255059175, 3140880360,
            1363226265, 3662668051, 3238416667, 1904040433, 3664954722, 2003480789, 1755302330,
            2794058785, 4058224606, 4129514812, 2397614142, 3283662783, 3204491738, 1892815272,
            3160700716, 607309416,  2111962167, 311598255,  90808604,   2228903006, 1812070728,
            822293537,  561172424,  1051711319, 963951509,  949750144,  1268443266, 1312618195,
            2356563621, 3137140183, 2051756832, 330237650,  2717422909, 3200203338, 3553952778,
            2743991616, 2772686795,
        },
        {
            2234324389, 1682296894, 3526681456, 3988544681, 1315506584, 1754723911, 3607564438,
            3764062195, 3408328234, 2385116969, 3827569659, 4104590721, 2612634189, 1762747544,
            1676800931, 1814546108, 2684685172, 1659194343, 3381624140, 2286640580, 688245437,
            2593335056, 1657668516, 1161309746, 3390664973, 2460564382, 2811435329, 2169200311,
            2768093584, 4288309691, 1341061221, 1361417084, 3060155336, 2526021346, 1037055386,
            890124736,  2185462193, 765141735,  1841745804, 3562499272, 1437907207, 2127475991,
            2845453063, 4007976206, 4160093314, 2717704308, 4193767498, 1667876711, 3477753188,
            3150367681, 3224086539, 231347764,  2737121599, 1230656103, 4168131490, 1463860373,
            2760968409, 2579133178, 2309591728, 2958907244, 1041094855, 685134804,  3861095208,
            1088109135, 815655228,  2618003265, 3454840568, 1668276240, 1668403077, 663034899,
            4020374281, 1896863688, 677285319,  4047674693, 4098535894, 2038783953, 236635760,
            3641273565, 3568356824, 3405704765, 186484522,  3626346451, 3653227559, 281949942,
            1847600066, 4168753288, 1723123703, 3600798445, 4267802363, 2947454105, 468768748,
            2745777741, 26635454,   837186232,  206931043,  2601865569, 2021732453, 3171165636,
            786833002,  116631308,  1604778670, 437644814,  2437761489, 3573139998, 2637030522,
            972076738,  4075927397, 1427554739, 597414077,  559325169,  1774857312, 224593737,
            3697511293, 3905126277, 2446278950, 1847061846, 333176687,  2988562696, 3623938567,
            2389910304, 4273100167, 1673622334, 2163644598, 3666601063, 3971760462, 4176957983,
            565952761,  566996714,  103136762,  3648349163, 115456167,  3265051494, 2826313040,
            1898888678, 3921049266, 1276809956, 4051866478, 959265349,  851980436,  3105565302,
            2905096898, 342438530,  3428101638, 912389587,  2306839396, 3613297213, 200159550,
            3406974927, 832121231,  2998593393, 1242069873, 1464281204, 1828082526, 2620095350,
            3727900009, 986958825,  3332332947, 1610600284, 3193282615, 1873987353, 537698841,
            2234324389, 1682296894, 3526681456, 3988544681, 1112334635, 1754723911, 3607564438,
            3764062195, 3408328234, 2702680798, 3827569659, 4104590721, 2612634189, 1762747544,
            1596420149, 1814546108, 2684685172, 1659194343, 3381624140, 2424233156, 688245437,
            2593335056, 1657668516, 1161309746, 260803614,  2460564382, 2811435329, 2169200311,
            2768093584, 1426048416, 1341061221, 1361417084, 3060155336, 2526021346, 688976997,
            890124736,  2185462193, 765141735,  1841745804, 1113361455, 1437907207, 2127475991,
            2845453063, 4007976206, 1719248425, 2717704308, 4193767498, 1667876711, 3477753188,
            449353539,  3224086539, 231347764,  2737121599, 1230656103, 2122699205, 1463860373,
            2760968409, 2579133178, 2309591728, 4017154219, 1041094855, 685134804,  3861095208,
            1088109135, 3954527144, 2618003265, 3454840568, 1668276240, 1668403077, 3235241899,
            4020374281, 1896863688, 677285319,  4047674693, 4043186819, 2038783953, 236635760,
            3641273565, 3568356824, 3946220303, 186484522,  3626346451, 3653227559, 281949942,
            1896524045, 4168753288, 1723123703, 3600798445, 4267802363, 412498526,  468768748,
            2745777741, 26635454,   837186232,  1473941762, 2601865569, 2021732453, 3171165636,
            786833002,  3461566768, 1604778670, 437644814,  2437761489, 3573139998, 306196591,
            972076738,  4075927397, 1427554739, 597414077,  2401305323, 1774857312, 224593737,
            3697511293, 3905126277, 1527832817, 1847061846, 333176687,  2988562696, 3623938567,
            2731158470, 4273100167, 1673622334, 2163644598, 3666601063, 1991088422, 4176957983,
            565952761,  566996714,  103136762,  1639884175, 115456167,  3265051494, 2826313040,
            1898888678, 2976556877, 1276809956, 4051866478, 959265349,  851980436,  2482970929,
            2905096898, 342438530,  3428101638, 912389587,  2716490551, 3613297213, 200159550,
            3406974927, 832121231,  2865829307, 1242069873, 1464281204, 1828082526, 2620095350,
            3671861666, 986958825,  3332332947, 1610600284, 3193282615, 164496953,  537698841,
            2234324389, 1682296894, 3526681456, 486931321,  1112334635, 1754723911, 3607564438,
            3764062195, 898439171,  2702680798, 3827569659, 4104590721, 2612634189, 1703436382,
            1596420149, 1814546108, 2684685172, 1659194343, 3421607784, 2424233156, 688245437,
            2593335056, 1657668516, 362342820,  260803614,  2460564382, 2811435329, 2169200311,
            4248717010, 1426048416, 1341061221, 1361417084, 3060155336, 2693026827, 688976997,
            890124736,  2185462193, 765141735,  2445632748, 1113361455, 1437907207, 2127475991,
            2845453063, 1830953748, 1719248425, 2717704308, 4193767498, 1667876711, 2469362144,
            449353539,  3224086539, 231347764,  2737121599, 2917779591, 2122699205, 1463860373,
            2760968409, 2579133178, 2600345316, 4017154219, 1041094855, 685134804,  3861095208,
            3682591427, 3954527144, 2618003265, 3454840568, 1668276240, 988400088,  3235241899,
            4020374281, 1896863688, 677285319,  2749516227, 4043186819, 2038783953, 236635760,
            3641273565, 4073317913, 3946220303, 186484522,  3626346451, 3653227559, 872336642,
            1896524045, 4168753288, 1723123703, 3600798445, 524095357,  412498526,  468768748,
            2745777741, 26635454,   840544541,  1473941762, 2601865569, 2021732453, 3171165636,
            1058640324, 3461566768, 1604778670, 437644814,  2437761489, 3615438045, 306196591,
            972076738,  4075927397, 1427554739, 2369367008, 2401305323, 1774857312, 224593737,
            3697511293, 4186564433, 1527832817, 1847061846, 333176687,  2988562696, 4039340326,
            2731158470, 4273100167, 1673622334, 2163644598, 307949376,  1991088422, 4176957983,
            565952761,  566996714,  4159448552, 1639884175, 115456167,  3265051494, 2826313040,
            2698725478, 2976556877, 1276809956, 4051866478, 959265349,  293029699,  2482970929,
            2905096898, 342438530,  3428101638, 4172766741, 2716490551, 3613297213, 200159550,
            3406974927, 3723281866, 2865829307, 1242069873, 1464281204, 1828082526, 3304191156,
            3671861666, 986958825,  3332332947, 1610600284, 2370407607, 164496953,  537698841,
            2234324389, 1682296894, 826891606,  486931321,  1112334635, 1754723911, 3607564438,
            3598993552, 898439171,  2702680798, 3827569659, 4104590721, 1421852097, 1703436382,
            1596420149, 1814546108, 2684685172, 4090587429, 3421607784, 2424233156, 688245437,
            2593335056, 4151905751, 362342820,  260803614,  2460564382, 2811435329, 2402832015,
            4248717010, 1426048416, 1341061221, 1361417084, 1629089021, 2693026827, 688976997,
            890124736,  2185462193, 303105066,  2445632748, 1113361455, 1437907207, 2127475991,
            62024604,   1830953748, 1719248425, 2717704308, 4193767498, 667433630,  2469362144,
            449353539,  3224086539, 231347764,  3918249451, 2917779591, 2122699205, 1463860373,
            2760968409, 4274016442, 2600345316, 4017154219, 1041094855, 685134804,  643006688,
            3682591427, 3954527144, 2618003265, 3454840568, 4180665518, 988400088,  3235241899,
            4020374281, 1896863688, 3678687414, 2749516227, 4043186819, 2038783953, 236635760,
            2880089648, 4073317913, 3946220303, 186484522,  3626346451, 2454620114, 872336642,
            1896524045, 4168753288, 1723123703, 2692406059, 524095357,  412498526,  468768748,
            2745777741, 918726515,  840544541,  1473941762, 2601865569, 2021732453, 3534238020,
            1058640324, 3461566768, 1604778670, 437644814,  2894699005, 3615438045, 306196591,
            972076738,  4075927397, 3468671461, 2369367008, 2401305323, 1774857312, 224593737,
            2734827022, 4186564433, 1527832817, 1847061846, 333176687,  2437714719, 4039340326,
            2731158470, 4273100167, 1673622334, 196072958,  307949376,  1991088422, 4176957983,
            565952761,  847200194,  4159448552, 1639884175, 115456167,  3265051494, 2503079777,
            2698725478, 2976556877, 1276809956, 4051866478, 2731665893, 293029699,  2482970929,
            2905096898, 342438530,  581060953,  4172766741, 2716490551, 3613297213, 200159550,
            4222335623, 3723281866, 2865829307, 1242069873, 1464281204, 1080647953, 3304191156,
            3671861666, 986958825,  3332332947, 920422540,  3656094274, 4036161427, 2157099981,
            1855437762, 1385781426, 199192882,  489599802,  3472601685, 717544078,  2241742884,
            3951326913, 3590866192, 1087524220, 3517385549, 360484251,  2718513148, 1386577185,
            1833613127, 2926418589, 1652463225, 548895720,  1343026759, 1797789098, 3229783023,
            1745843414, 200554865,  2442780740, 2359926428, 2970332116, 3097392757, 134294482,
            936225458,  1968264650, 64868134,   3821668262, 2502175363, 1623767635, 2936073062,
            1991791011, 2971174068, 3142195911, 2874818345, 2192526584, 496586185,  2491564144,
            2415210641, 314307270,  2936737494, 557604388,  1067914024, 3270690738, 375601880,
            962749065,  3610467620, 402112984,  1432929499, 3872957776, 3971384069, 2223968592,
            407083609,  2178236674, 1806303230, 3397564470, 12158764,   415570813,  4033667395,
            3687406137, 801878150,  953500350,  3667783172, 1203668106, 902418194,  779786150,
            774683730,  2870261992, 509192460,  1961621392, 1064906432, 3665710891, 1733725153,
            1887608856, 1314631523, 4097239005, 29074501,   3472521950, 4040841657, 532128023,
            2333441401, 1671717886, 1678544416, 1218347584, 3680929567, 4025753853, 2810948711,
            1846100306, 3377469279, 3144481747, 2625781306, 730632118,  3162408393, 3423660386,
            1364968369, 4270900402, 1075484840, 2892932277, 3700635052, 3853022563, 281755151,
            1530909868, 2364069707, 2361723426, 738500028,  1401903990, 1543704261, 2442916222,
            1076190609, 1882477803, 740024557,  1591015439, 2730909167, 2723330839, 1637373491,
            3777799860, 2921269571, 3698591972, 3997463570, 3877862147, 1912888417, 3365137165,
            3465700492, 771243134,  4037723169, 1715894739, 1025821874, 1924958945, 3382242859,
            121591031,  483980724,  546523388,  2446882279, 856267778,  578739009,  2978085488,
            480884914,  966764808,  457039953,  3817520708, 1113646451, 2503896910, 3507840816,
            717151671,  4149352573, 1568869830, 395015863,  773165995,  1853682362, 2861368846,
            1884368812, 1250092101,
        },
        {
            1337976093, 26141349,   2429497191, 3913889562, 1870442906, 2482302338, 1889496646,
            1056706892, 4245403287, 2389698313, 1967779956, 1445461814, 3292514548, 107812495,
            4011605597, 3854371718, 373586705,  3392523969, 2778276116, 2590645094, 2487281876,
            1538198747, 336673401,  449758498,  1326496278, 3988012354, 1504484669, 2180535164,
            924339431,  3445418543, 1390611195, 976607312,  23621787,   3499989135, 89162246,
            1597793376, 2616175682, 1921319880, 2168815349, 1419219821, 292430297,  3340050158,
            3130884371, 945027982,  3422222375, 3015884741, 2966904971, 4289432343, 1709120556,
            1611604013, 28726904,   3617816019, 2520665618, 931191167,  3956261794, 2576578747,
            1129741673, 2647404780, 2571706418, 1634321240, 2015482978, 3621569896, 3208943910,
            3887229679, 797083654,  12498958,   2616872881, 2753436678, 838207714,  1568841352,
            1013546987, 798903810,  1377209723, 2451060313, 2216283861, 2043473393, 3130820818,
            1603835053, 3770368379, 2235734875, 2002869327, 1483124088, 3211874324, 47956531,
            3001557313, 1233042312, 3031626292, 2793389143, 3442806979, 83868075,   79151405,
            1201580541, 2645985998, 3063806946, 691237653,  4043600465, 4200073500, 1613827928,
            3629969168, 3465787516, 2516627857, 2802248597, 1026724995, 3979872847, 3941825577,
            3557891977, 1230568072, 3888693138, 232077515,  3791416853, 1519511725, 2794766457,
            782739784,  3536979899, 1446327873, 344618254,  1264044681, 1155244583, 1853631184,
            2486799850, 1600905819, 1618771810, 2369696768, 2907852749, 3423893995, 3379927867,
            1711545692, 901066628,  2985485955, 3581754633, 1636489980, 624227173,  3019365248,
            2000572826, 3137855521, 2934049523, 1847255199, 3918910114, 4024801423, 3019933190,
            2180099610, 2331700833, 3600825360, 2360905571, 3230749988, 389767960,  3794666113,
            4150694153, 2266805820, 3115581469, 4017433965, 2076821079, 4053513196, 1525514483,
            1664098234, 927379861,  1623529201, 1733156780, 363441421,  1208688031, 220742271,
            1337976093, 26141349,   2429497191, 3913889562, 2130124872, 2482302338, 1889496646,
            1056706892, 4245403287, 1645849266, 1967779956, 1445461814, 3292514548, 107812495,
            673872088,  3854371718, 373586705,  3392523969, 2778276116, 2322773669, 2487281876,
            1538198747, 336673401,  449758498,  2915885173, 3988012354, 1504484669, 2180535164,
            924339431,  2416940268, 1390611195, 976607312,  23621787,   3499989135, 1442578890,
            1597793376, 2616175682, 1921319880, 2168815349, 614775033,  292430297,  3340050158,
            3130884371, 945027982,  4115416217, 3015884741, 2966904971, 4289432343, 1709120556,
            2956118345, 28726904,   3617816019, 2520665618, 931191167,  797776301,  2576578747,
            1129741673, 2647404780, 2571706418, 1919432300, 2015482978, 3621569896, 3208943910,
            3887229679, 658294354,  12498958,   2616872881, 2753436678, 838207714,  3684200250,
            1013546987, 798903810,  1377209723, 2451060313, 777034858,  2043473393, 3130820818,
            1603835053, 3770368379, 1867579442, 2002869327, 1483124088, 3211874324, 47956531,
            3348240991, 1233042312, 3031626292, 2793389143, 3442806979, 1116477348, 79151405,
            1201580541, 2645985998, 3063806946, 2805170821, 4043600465, 4200073500, 1613827928,
            3629969168, 1520366274, 2516627857, 2802248597, 1026724995, 3979872847, 364404296,
            3557891977, 1230568072, 3888693138, 232077515,  3050217042, 1519511725, 2794766457,
            782739784,  3536979899, 154227384,  344618254,  1264044681, 1155244583, 1853631184,
            3169299735, 1600905819, 1618771810, 2369696768, 2907852749, 3991328952, 3379927867,
            1711545692, 901066628,  2985485955, 3148040865, 1636489980, 624227173,  3019365248,
            2000572826, 2088111686, 2934049523, 1847255199, 3918910114, 4024801423, 1686056923,
            2180099610, 2331700833, 3600825360, 2360905571, 924358374,  389767960,  3794666113,
            4150694153, 2266805820, 1758419385, 4017433965, 2076821079, 4053513196, 1525514483,
            41254861,   927379861,  1623529201, 1733156780, 363441421,  633111753,  220742271,
            1337976093, 26141349,   2429497191, 484131166,  2130124872, 2482302338, 1889496646,
            1056706892, 2854054516, 1645849266, 1967779956, 1445461814, 3292514548, 1346371843,
            673872088,  3854371718, 373586705,  3392523969, 4222600756, 2322773669, 2487281876,
            1538198747, 336673401,  3048264459, 2915885173, 3988012354, 1504484669, 2180535164,
            1460961456, 2416940268, 1390611195, 976607312,  23621787,   1589654409, 1442578890,
            1597793376, 2616175682, 1921319880, 3530042851, 614775033,  292430297,  3340050158,
            3130884371, 3862330721, 4115416217, 3015884741, 2966904971, 4289432343, 1425336374,
            2956118345, 28726904,   3617816019, 2520665618, 2466423458, 797776301,  2576578747,
            1129741673, 2647404780, 2061349766, 1919432300, 2015482978, 3621569896, 3208943910,
            1521244879, 658294354,  12498958,   2616872881, 2753436678, 2162484056, 3684200250,
            1013546987, 798903810,  1377209723, 4247600125, 777034858,  2043473393, 3130820818,
            1603835053, 4168571108, 1867579442, 2002869327, 1483124088, 3211874324, 86410981,
            3348240991, 1233042312, 3031626292, 2793389143, 2365519610, 1116477348, 79151405,
            1201580541, 2645985998, 1948512415, 2805170821, 4043600465, 4200073500, 1613827928,
            21873391,   1520366274, 2516627857, 2802248597, 1026724995, 2762272326, 364404296,
            3557891977, 1230568072, 3888693138, 241333483,  3050217042, 1519511725, 2794766457,
            782739784,  3825806641, 154227384,  344618254,  1264044681, 1155244583, 2382228937,
            3169299735, 1600905819, 1618771810, 2369696768, 2438624206, 3991328952, 3379927867,
            1711545692, 901066628,  2341464888, 3148040865, 1636489980, 624227173,  3019365248,
            2725924041, 2088111686, 2934049523, 1847255199, 3918910114, 3650240958, 1686056923,
            2180099610, 2331700833, 3600825360, 44508284,   924358374,  389767960,  3794666113,
            4150694153, 3191254894, 1758419385, 4017433965, 2076821079, 4053513196, 3463838131,
            41254861,   927379861,  1623529201, 1733156780, 1622638066, 633111753,  220742271,
            1337976093, 26141349,   4260405624, 484131166,  2130124872, 2482302338, 1889496646,
            2363774488, 2854054516, 1645849266, 1967779956, 1445461814, 3113116928, 1346371843,
            673872088,  3854371718, 373586705,  2399439858, 4222600756, 2322773669, 2487281876,
            1538198747, 851808422,  3048264459, 2915885173, 3988012354, 1504484669, 1825362078,
            1460961456, 2416940268, 1390611195, 976607312,  1039343314, 1589654409, 1442578890,
            1597793376, 2616175682, 3385232393, 3530042851, 614775033,  292430297,  3340050158,
            850204880,  3862330721, 4115416217, 3015884741, 2966904971, 303967782,  1425336374,
            2956118345, 28726904,   3617816019, 2272708412, 2466423458, 797776301,  2576578747,
            1129741673, 3284350109, 2061349766, 1919432300, 2015482978, 3621569896, 1716858033,
            1521244879, 658294354,  12498958,   2616872881, 2847309459, 2162484056, 3684200250,
            1013546987, 798903810,  909511739,  4247600125, 777034858,  2043473393, 3130820818,
            3867757434, 4168571108, 1867579442, 2002869327, 1483124088, 957886251,  86410981,
            3348240991, 1233042312, 3031626292, 2989677697, 2365519610, 1116477348, 79151405,
            1201580541, 287267738,  1948512415, 2805170821, 4043600465, 4200073500, 1259037949,
            21873391,   1520366274, 2516627857, 2802248597, 309257106,  2762272326, 364404296,
            3557891977, 1230568072, 2163115187, 241333483,  3050217042, 1519511725, 2794766457,
            1955371400, 3825806641, 154227384,  344618254,  1264044681, 2275047064, 2382228937,
            3169299735, 1600905819, 1618771810, 339758752,  2438624206, 3991328952, 3379927867,
            1711545692, 1456050665, 2341464888, 3148040865, 1636489980, 624227173,  672745315,
            2725924041, 2088111686, 2934049523, 1847255199, 2379922662, 3650240958, 1686056923,
            2180099610, 2331700833, 3682996746, 44508284,   924358374,  389767960,  3794666113,
            3680675380, 3191254894, 1758419385, 4017433965, 2076821079, 124550499,  3463838131,
            41254861,   927379861,  1623529201, 3765002002, 550828501,  733381372,  2933683684,
            986300454,  3790060983, 2954614450, 3271538150, 3248538750, 1183730930, 2440614897,
            2397554686, 1072956273, 1338975095, 4144341069, 3335638626, 3658948717, 3503301348,
            3484396720, 766600111,  2685066037, 786366432,  2286073191, 3685372127, 3314022847,
            2886519421, 1849631242, 2108182992, 349857038,  1926845960, 2474328599, 453947131,
            304253620,  3447944014, 4179022577, 2772994831, 1518797706, 928380556,  128173209,
            3573319663, 30453543,   1563659443, 3650769693, 2322416052, 2613584163, 4042684625,
            2787614929, 3300840619, 2344029764, 4247385243, 3837344882, 1580770559, 1336831254,
            1719053124, 1941324022, 3258750551, 856868495,  1695167455, 2355308310, 1074276582,
            2502274973, 1455551053, 2001971792, 13320526,   2038071788, 1685897424, 2226063643,
            3125124726, 3311158554, 924058132,  2829039275, 1164059103, 2582253339, 343326154,
            2323572481, 1985517540, 3306838002, 3336834404, 1442346827, 1409296207, 2582861,
            1531964315, 99671410,   26219712,   2428606246, 2256987514, 1682361762, 1478827326,
            4076273408, 1830715357, 1145825767, 1550634396, 1443159531, 2724275488, 263770897,
            2239024173, 4275265899, 3175933509, 2016722421, 1187850757, 3185691052, 2798153229,
            1798424960, 3861962665, 1410075194, 3688368115, 960845433,  1833039969, 3600169813,
            2352802696, 2853566714, 2258036365, 3068784495, 2842572572, 1140370511, 1790506716,
            935098289,  1649137973, 3489523105, 2062592038, 1344455516, 3434374498, 3617580267,
            607937538,  1349289084, 4042502680, 4037034078, 2926550396, 2394672980, 3185854489,
            2892864196, 1042119945, 2856928801, 2953278462, 414158789,  696785125,  2986247093,
            2760338988, 2709993609, 1952847188, 453824678,  2530634816, 1329868286, 725287461,
            2865409087, 336837862,  3482693356, 3442641552, 4197063798, 3977346926, 3300488740,
            534499344,  2716696446, 3374458567, 643238826,  2960120883, 3070468432, 2037799139,
            2063804206, 1279628987,
        },
        {
            916910638,  961623451,  1193013401, 1016438484, 4091279871, 287282633,  8590725,
            3575333670, 324340905,  3133751747, 2840894649, 2980503178, 1111215768, 2783846375,
            72516413,   4158424384, 2184094569, 2305724254, 4057093054, 1407652993, 3105191537,
            768505376,  298782270,  993926164,  2694730042, 1479658113, 2376490281, 2767906402,
            1619969256, 3256472015, 2563843533, 2974784738, 2529307107, 4289918826, 3105587575,
            3748950898, 2182744253, 431888679,  3780324902, 2525978209, 54545903,   1688749940,
            2394884334, 3477656171, 263834270,  1562965459, 804704330,  4185729868, 138898835,
            2113063150, 327612841,  1252226275, 935318076,  2956823075, 4095101181, 1510586062,
            156282440,  3386839706, 2294393752, 1306167091, 4005033667, 651716500,  4115192738,
            123027719,  3873547487, 2910637335, 2571924586, 3489608656, 956791985,  2467423726,
            3214531645, 2054232851, 49634692,   377192215,  1865068750, 2479252980, 3481787748,
            3243507737, 605491073,  4062466752, 988602517,  1539348794, 1555068617, 2657884010,
            460334294,  4240766479, 3639800790, 253377117,  3969136265, 488705329,  1722560286,
            2289159295, 1025876008, 2927117896, 767521707,  2047999999, 4260853571, 2079302241,
            2409677301, 1087552976, 2363907365, 2574464321, 2606273241, 3716086457, 26053603,
            3162779415, 14843078,   2614076143, 1157531920, 2773275636, 2338825066, 435472225,
            1399711137, 1224374788, 2154533280, 560135209,  935800607,  1940258814, 3826959530,
            3423217355, 3704934971, 3815248829, 3878175339, 1395508015, 3295101527, 177901558,
            4167531389, 1375148189, 3125377631, 557218961,  4088880299, 3478859071, 3687276754,
            2845114223, 1713171361, 1756507633, 3160807894, 2375334470, 843542578,  1907952570,
            1544844563, 2294372007, 3336681376, 734347193,  102566945,  2311037104, 4294750194,
            3572240326, 732958152,  263733314,  2087890678, 331542297,  3549110380, 2073894939,
            2104101380, 3670791368, 3122901693, 3799823891, 3783548253, 1102633864, 44327348,
            916910638,  961623451,  1193013401, 1016438484, 1873779640, 287282633,  8590725,
            3575333670, 324340905,  1144671533, 2840894649, 2980503178, 1111215768, 2783846375,
            2000673937, 4158424384, 2184094569, 2305724254, 4057093054, 533488413,  3105191537,
            768505376,  298782270,  993926164,  2015456740, 1479658113, 2376490281, 2767906402,
            1619969256, 3120736988, 2563843533, 2974784738, 2529307107, 4289918826, 729503771,
            3748950898, 2182744253, 431888679,  3780324902, 373638396,  54545903,   1688749940,
            2394884334, 3477656171, 1083764681, 1562965459, 804704330,  4185729868, 138898835,
            823405282,  327612841,  1252226275, 935318076,  2956823075, 899234846,  1510586062,
            156282440,  3386839706, 2294393752, 2769934879, 4005033667, 651716500,  4115192738,
            123027719,  3729538641, 2910637335, 2571924586, 3489608656, 956791985,  139360134,
            3214531645, 2054232851, 49634692,   377192215,  2754746969, 2479252980, 3481787748,
            3243507737, 605491073,  732155706,  988602517,  1539348794, 1555068617, 2657884010,
            3753733088, 4240766479, 3639800790, 253377117,  3969136265, 3848735787, 1722560286,
            2289159295, 1025876008, 2927117896, 3661948694, 2047999999, 4260853571, 2079302241,
            2409677301, 3421911122, 2363907365, 2574464321, 2606273241, 3716086457, 2064343322,
            3162779415, 14843078,   2614076143, 1157531920, 826449637,  2338825066, 435472225,
            1399711137, 1224374788, 3770340198, 560135209,  935800607,  1940258814, 3826959530,
            2963586762, 3704934971, 3815248829, 3878175339, 1395508015, 3721612680, 177901558,
            4167531389, 1375148189, 3125377631, 1023552290, 4088880299, 3478859071, 3687276754,
            2845114223, 3831557301, 1756507633, 3160807894, 2375334470, 843542578,  2798365898,
            1544844563, 2294372007, 3336681376, 734347193,  1856808621, 2311037104, 4294750194,
            3572240326, 732958152,  1999195012, 2087890678, 331542297,  3549110380, 2073894939,
            3115936764, 3670791368, 3122901693, 3799823891, 3783548253, 132796150,  44327348,
            916910638,  961623451,  1193013401, 1753944196, 1873779640, 287282633,  8590725,
            3575333670, 1447720209, 1144671533, 2840894649, 2980503178, 1111215768, 1211945983,
            2000673937, 4158424384, 2184094569, 2305724254, 402617261,  533488413,  3105191537,
            768505376,  298782270,  2915553159, 2015456740, 1479658113, 2376490281, 2767906402,
            3473761811, 3120736988, 2563843533, 2974784738, 2529307107, 737859212,  729503771,
            3748950898, 2182744253, 431888679,  2013420163, 373638396,  54545903,   1688749940,
            2394884334, 675998523,  1083764681, 1562965459, 804704330,  4185729868, 1165431355,
            823405282,  327612841,  1252226275, 935318076,  2420680216, 899234846,  1510586062,
            156282440,  3386839706, 2101339651, 2769934879, 4005033667, 651716500,  4115192738,
            112049740,  3729538641, 2910637335, 2571924586, 3489608656, 305695595,  139360134,
            3214531645, 2054232851, 49634692,   1073828255, 2754746969, 2479252980, 3481787748,
            3243507737, 3392719169, 732155706,  988602517,  1539348794, 1555068617, 3246776527,
            3753733088, 4240766479, 3639800790, 253377117,  872273450,  3848735787, 1722560286,
            2289159295, 1025876008, 4168154213, 3661948694, 2047999999, 4260853571, 2079302241,
            2380420842, 3421911122, 2363907365, 2574464321, 2606273241, 3881916078, 2064343322,
            3162779415, 14843078,   2614076143, 473288515,  826449637,  2338825066, 435472225,
            1399711137, 3068538992, 3770340198, 560135209,  935800607,  1940258814, 1469655183,
            2963586762, 3704934971, 3815248829, 3878175339, 2410602840, 3721612680, 177901558,
            4167531389, 1375148189, 1367577763, 1023552290, 4088880299, 3478859071, 3687276754,
            678224549,  3831557301, 1756507633, 3160807894, 2375334470, 2884561721, 2798365898,
            1544844563, 2294372007, 3336681376, 1938834658, 1856808621, 2311037104, 4294750194,
            3572240326, 2786764913, 1999195012, 2087890678, 331542297,  3549110380, 3597797341,
            3115936764, 3670791368, 3122901693, 3799823891, 1271317799, 132796150,  44327348,
            916910638,  961623451,  2427821332, 1753944196, 1873779640, 287282633,  8590725,
            1244012658, 1447720209, 1144671533, 2840894649, 2980503178, 3548902577, 1211945983,
            2000673937, 4158424384, 2184094569, 2152623453, 402617261,  533488413,  3105191537,
            768505376,  1095141108, 2915553159, 2015456740, 1479658113, 2376490281, 337998873,
            3473761811, 3120736988, 2563843533, 2974784738, 3087228498, 737859212,  729503771,
            3748950898, 2182744253, 2140410733, 2013420163, 373638396,  54545903,   1688749940,
            528290088,  675998523,  1083764681, 1562965459, 804704330,  2536362875, 1165431355,
            823405282,  327612841,  1252226275, 4037635314, 2420680216, 899234846,  1510586062,
            156282440,  2012335895, 2101339651, 2769934879, 4005033667, 651716500,  2552583570,
            112049740,  3729538641, 2910637335, 2571924586, 2436645403, 305695595,  139360134,
            3214531645, 2054232851, 2384286326, 1073828255, 2754746969, 2479252980, 3481787748,
            1948315585, 3392719169, 732155706,  988602517,  1539348794, 4110558494, 3246776527,
            3753733088, 4240766479, 3639800790, 3627363812, 872273450,  3848735787, 1722560286,
            2289159295, 4122430477, 4168154213, 3661948694, 2047999999, 4260853571, 1767882442,
            2380420842, 3421911122, 2363907365, 2574464321, 2778622726, 3881916078, 2064343322,
            3162779415, 14843078,   1513897109, 473288515,  826449637,  2338825066, 435472225,
            322954918,  3068538992, 3770340198, 560135209,  935800607,  345602050,  1469655183,
            2963586762, 3704934971, 3815248829, 3508249920, 2410602840, 3721612680, 177901558,
            4167531389, 2161244150, 1367577763, 1023552290, 4088880299, 3478859071, 1108183104,
            678224549,  3831557301, 1756507633, 3160807894, 2551630811, 2884561721, 2798365898,
            1544844563, 2294372007, 2520267760, 1938834658, 1856808621, 2311037104, 4294750194,
            2310096003, 2786764913, 1999195012, 2087890678, 331542297,  1205238749, 3597797341,
            3115936764, 3670791368, 3122901693, 2008141679, 2018425028, 3435073328, 1452813805,
            1628661138, 1323367156, 1062553693, 4029321700, 2772685842, 3798388850, 1315172209,
            3930983291, 3816791373, 529176017,  3419610188, 3331589216, 4016977274, 2047089790,
            3892571923, 2363414008, 1144631948, 3004954882, 2558739305, 19774033,   2525079911,
            3774885821, 2817837373, 986111566,  1446678953, 3238485630, 3993748600, 1601954599,
            3100591537, 2098009380, 3935971261, 4202546603, 3713465083, 3845664764, 2466365355,
            1452340065, 2003576531, 1013434822, 2254608933, 783902023,  3129770529, 129130612,
            821418228,  350036483,  3473671510, 4128495167, 2773832518, 683262085,  2143353417,
            256251732,  1719056536, 2670223618, 328467339,  1564657740, 451231672,  2788353006,
            882900088,  3255241056, 3198073758, 2541070985, 1941509325, 674933160,  207753676,
            2605303964, 1681335994, 1143520001, 448872632,  302917879,  1100138495, 2058770021,
            3116955098, 2081754747, 3734924767, 1916718058, 3873335960, 2740460398, 2171157007,
            27677949,   2364721928, 175851655,  1468083950, 3162369526, 2441504540, 556978295,
            2372096172, 3181101116, 2582850132, 1101292643, 862643740,  2095546242, 3261953801,
            748040658,  3970037674, 819116843,  3594523650, 1597423019, 4109336883, 1198282420,
            2905230517, 1729529596, 3230132814, 3640242164, 1899059108, 1944906555, 3426510495,
            3035188107, 6448083,    1093882965, 2867500469, 3626379157, 1849073068, 897616501,
            604221668,  1020676159, 4083635798, 1716022041, 3671877965, 1738820843, 30077467,
            729231767,  3413193248, 207000406,  3854363185, 3302747326, 3293643267, 2101250157,
            460131091,  4159442595, 1133391045, 1031215443, 4195487944, 45931575,   2922629291,
            789302543,  3024994662, 442525623,  2850119076, 838309503,  2585361734, 1020449164,
            1623631007, 955374631,  2932467671, 3713639221, 3019179416, 977970472,  1817244230,
            3856774853, 1140530868, 886199600,  1218509766, 4001537244, 2840913665, 2133254364,
            3332344608, 475291624,
        },
        {
            1075811073, 2703898215, 3676051740, 2020588714, 952510021,  3650782380, 105510200,
            3004020744, 3084548452, 1247158211, 1087726434, 844191245,  2978407781, 2717697868,
            2464789795, 2438340051, 547587341,  1824273085, 1580930894, 3627742068, 1343742690,
            2632127642, 3534598391, 1682900758, 1340111064, 1213570485, 2070464357, 3412916144,
            2722805229, 2655427008, 1362840721, 1983303145, 1271781763, 4225066444, 2545776610,
            1119322818, 4078906419, 3342306839, 932250666,  77955158,   2143179838, 1715707896,
            3291364470, 979159833,  4226851464, 2023135704, 3730007922, 3561774237, 2766426723,
            3532111229, 2098171083, 2906854423, 746997560,  3916452151, 3213324283, 4132976181,
            1507536397, 3105152488, 2970548811, 2551292974, 4271038928, 1229697525, 4233776891,
            1516851405, 190605414,  1472799449, 720205335,  1920061824, 3778687311, 3141424333,
            518415382,  1300655204, 3430702483, 705406414,  3537713315, 386341107,  1650646161,
            2429011513, 1044981365, 3491482846, 302202270,  4047317093, 1486548661, 1622095316,
            3566212475, 2921738242, 432645660,  1899459924, 3409742811, 877486923,  3510162259,
            3115962336, 370223741,  2113602172, 2794009321, 2554967348, 2804063005, 3391225373,
            2449861344, 2061290771, 852249133,  4255408670, 2568815717, 122882371,  3342938562,
            4247334852, 330798251,  3379687524, 1993081737, 2956736138, 2570813000, 2264506420,
            3986073804, 3405680108, 2992401890, 3610761127, 2345419938, 2846143828, 4264489175,
            3132859891, 3349029454, 2367402493, 154757224,  2565045476, 2953246276, 2754483715,
            3936927647, 2809302405, 174157368,  2347854442, 1020219349, 4043528106, 684972287,
            1457312046, 1706160200, 641592812,  4090705836, 2436674075, 1731376904, 4161772935,
            624640859,  2612475635, 3663063019, 1758217706, 928581253,  1123119584, 3460519242,
            802950422,  1844641159, 2687548954, 1627839552, 3275418441, 3812376058, 656418541,
            1985492628, 3901110859, 66869277,   2829298715, 1648521770, 1808372904, 1472308817,
            1075811073, 2703898215, 3676051740, 2020588714, 2863939662, 3650782380, 105510200,
            3004020744, 3084548452, 479460654,  1087726434, 844191245,  2978407781, 2717697868,
            690359442,  2438340051, 547587341,  1824273085, 1580930894, 781275618,  1343742690,
            2632127642, 3534598391, 1682900758, 181867657,  1213570485, 2070464357, 3412916144,
            2722805229, 2508732343, 1362840721, 1983303145, 1271781763, 4225066444, 886452677,
            1119322818, 4078906419, 3342306839, 932250666,  699624652,  2143179838, 1715707896,
            3291364470, 979159833,  321410018,  2023135704, 3730007922, 3561774237, 2766426723,
            2568278202, 2098171083, 2906854423, 746997560,  3916452151, 3748885654, 4132976181,
            1507536397, 3105152488, 2970548811, 1108971486, 4271038928, 1229697525, 4233776891,
            1516851405, 904144525,  1472799449, 720205335,  1920061824, 3778687311, 968242076,
            518415382,  1300655204, 3430702483, 705406414,  3412461022, 386341107,  1650646161,
            2429011513, 1044981365, 3143831684, 302202270,  4047317093, 1486548661, 1622095316,
            4208922410, 2921738242, 432645660,  1899459924, 3409742811, 57143657,   3510162259,
            3115962336, 370223741,  2113602172, 1398231998, 2554967348, 2804063005, 3391225373,
            2449861344, 3155720921, 852249133,  4255408670, 2568815717, 122882371,  3034160235,
            4247334852, 330798251,  3379687524, 1993081737, 2533879351, 2570813000, 2264506420,
            3986073804, 3405680108, 2981640613, 3610761127, 2345419938, 2846143828, 4264489175,
            2982259157, 3349029454, 2367402493, 154757224,  2565045476, 3612848397, 2754483715,
            3936927647, 2809302405, 174157368,  994891944,  1020219349, 4043528106, 684972287,
            1457312046, 1234683899, 641592812,  4090705836, 2436674075, 1731376904, 1492383483,
            624640859,  2612475635, 3663063019, 1758217706, 3251675420, 1123119584, 3460519242,
            802950422,  1844641159, 418215814,  1627839552, 3275418441, 3812376058, 656418541,
            3501600792, 3901110859, 66869277,   2829298715, 1648521770, 220719549,  1472308817,
            1075811073, 2703898215, 3676051740, 375586949,  2863939662, 3650782380, 105510200,
            3004020744, 107592940,  479460654,  1087726434, 844191245,  2978407781, 1184542334,
            690359442,  2438340051, 547587341,  1824273085, 2736830963, 781275618,  1343742690,
            2632127642, 3534598391, 2434736374, 181867657,  1213570485, 2070464357, 3412916144,
            3385797051, 2508732343, 1362840721, 1983303145, 1271781763, 1735281609, 886452677,
            1119322818, 4078906419, 3342306839, 1980503377, 699624652,  2143179838, 1715707896,
            3291364470, 3666202295, 321410018,  2023135704, 3730007922, 3561774237, 3376303953,
            2568278202, 2098171083, 2906854423, 746997560,  1815994155, 3748885654, 4132976181,
            1507536397, 3105152488, 3881549655, 1108971486, 4271038928, 1229697525, 4233776891,
            3169968046, 904144525,  1472799449, 720205335,  1920061824, 3588958793, 968242076,
            518415382,  1300655204, 3430702483, 2116524176, 3412461022, 386341107,  1650646161,
            2429011513, 1938977574, 3143831684, 302202270,  4047317093, 1486548661, 2037784315,
            4208922410, 2921738242, 432645660,  1899459924, 129629094,  57143657,   3510162259,
            3115962336, 370223741,  2334201526, 1398231998, 2554967348, 2804063005, 3391225373,
            74338882,   3155720921, 852249133,  4255408670, 2568815717, 528603676,  3034160235,
            4247334852, 330798251,  3379687524, 2281824384, 2533879351, 2570813000, 2264506420,
            3986073804, 2622854401, 2981640613, 3610761127, 2345419938, 2846143828, 3445839877,
            2982259157, 3349029454, 2367402493, 154757224,  2461589219, 3612848397, 2754483715,
            3936927647, 2809302405, 1094843724, 994891944,  1020219349, 4043528106, 684972287,
            2208911233, 1234683899, 641592812,  4090705836, 2436674075, 251512102,  1492383483,
            624640859,  2612475635, 3663063019, 2004560422, 3251675420, 1123119584, 3460519242,
            802950422,  2398577956, 418215814,  1627839552, 3275418441, 3812376058, 862818611,
            3501600792, 3901110859, 66869277,   2829298715, 3765002443, 220719549,  1472308817,
            1075811073, 2703898215, 2512862016, 375586949,  2863939662, 3650782380, 105510200,
            2097266976, 107592940,  479460654,  1087726434, 844191245,  4249805866, 1184542334,
            690359442,  2438340051, 547587341,  2861073865, 2736830963, 781275618,  1343742690,
            2632127642, 46832470,   2434736374, 181867657,  1213570485, 2070464357, 995863826,
            3385797051, 2508732343, 1362840721, 1983303145, 60929008,   1735281609, 886452677,
            1119322818, 4078906419, 1472399773, 1980503377, 699624652,  2143179838, 1715707896,
            2216625412, 3666202295, 321410018,  2023135704, 3730007922, 4035965585, 3376303953,
            2568278202, 2098171083, 2906854423, 4010852675, 1815994155, 3748885654, 4132976181,
            1507536397, 422386082,  3881549655, 1108971486, 4271038928, 1229697525, 1117715739,
            3169968046, 904144525,  1472799449, 720205335,  4126549105, 3588958793, 968242076,
            518415382,  1300655204, 2516991711, 2116524176, 3412461022, 386341107,  1650646161,
            1961453056, 1938977574, 3143831684, 302202270,  4047317093, 1125832800, 2037784315,
            4208922410, 2921738242, 432645660,  3669804892, 129629094,  57143657,   3510162259,
            3115962336, 3290315925, 2334201526, 1398231998, 2554967348, 2804063005, 3145138699,
            74338882,   3155720921, 852249133,  4255408670, 1282879044, 528603676,  3034160235,
            4247334852, 330798251,  57723786,   2281824384, 2533879351, 2570813000, 2264506420,
            1847376023, 2622854401, 2981640613, 3610761127, 2345419938, 4037057283, 3445839877,
            2982259157, 3349029454, 2367402493, 2186872696, 2461589219, 3612848397, 2754483715,
            3936927647, 2675721148, 1094843724, 994891944,  1020219349, 4043528106, 4151294939,
            2208911233, 1234683899, 641592812,  4090705836, 2337874613, 251512102,  1492383483,
            624640859,  2612475635, 59243247,   2004560422, 3251675420, 1123119584, 3460519242,
            232794923,  2398577956, 418215814,  1627839552, 3275418441, 2771920322, 862818611,
            3501600792, 3901110859, 66869277,   2636110604, 4070290379, 3491577445, 2818995795,
            181196118,  1010167147, 696756951,  2826076879, 2428522518, 1312820992, 981211219,
            2592740063, 531168171,  3667283925, 2440266362, 2835839033, 4027641510, 3325788237,
            1891228851, 2561537009, 2414675980, 799106067,  802877031,  3805622276, 3272545622,
            2155183356, 2543200413, 2449904279, 119200698,  3070279531, 3724004268, 2202752408,
            3652012368, 187739853,  2018268004, 2757325493, 1890697365, 2678345836, 2034381457,
            800542788,  180677078,  2740663175, 3818819457, 1909311408, 1479057387, 355061559,
            2492439292, 2680905124, 4165990756, 3957020048, 1709650726, 2468951411, 1192611882,
            575123768,  3446517856, 3611886032, 2289818416, 3526382392, 339927063,  2679855707,
            4267496396, 919185751,  3152028925, 1448807525, 4233369005, 96030927,   3519089135,
            1957492514, 1795306796, 1396898684, 104985796,  486713864,  4232491432, 2451934611,
            4265284134, 2955025315, 913725219,  419547065,  2107739257, 2244168017, 3518522169,
            1785869053, 2946672454, 1419638808, 3461792356, 2531697723, 429662563,  709551235,
            1871309961, 331074771,  4004870845, 883896809,  1473580967, 1928919971, 2789594139,
            273838687,  1364199434, 2949008926, 4016430555, 2586439260, 3475191748, 3057837725,
            1079791578, 2294810594, 975929916,  3428867384, 1252055835, 3206285088, 3524530264,
            4153703539, 10914824,   1690551784, 642385261,  92667115,   2731336294, 2233222848,
            1974948002, 334807163,  3976562355, 964119941,  3256275794, 4067490565, 1955345121,
            2150617075, 1512066945, 3401033831, 3929867815, 3654388499, 3634971631, 1803062529,
            1729462890, 3397918725, 3033012145, 1047683269, 2879846218, 2662838005, 4195747288,
            1330216813, 54860945,   4032128354, 3234247508, 1268748769, 1164072135, 496083516,
            950722919,  2731780408, 2706658263, 3593435633, 402643181,  1427024141, 853664211,
            1057082104, 2985734108, 2837174362, 3357344794, 2479755510, 922105140,  94086151,
            3576534047, 1034661460,
        },
        {
            1854921599, 2655519695, 3124573588, 319882484,  603545603,  4175512633, 141286453,
            1183670252, 1789500145, 37351733,   3190829323, 2782782009, 493805446,  1228958246,
            2672482554, 2274981421, 2935438833, 3625733677, 3679506394, 687805550,  134516308,
            3576789728, 965007022,  1056542222, 2319405423, 3944221200, 950102624,  3848192810,
            3205299696, 82033760,   1241913280, 1360146137, 1675732327, 2164452797, 3920498715,
            2226452641, 3172047212, 1569171738, 2631589480, 2889660225, 2030783667, 2237381973,
            2706217212, 3143638386, 1733174225, 1166820137, 3818389960, 193959252,  2793509934,
            316291605,  2502743884, 1963136977, 3739017448, 25754513,   1590156485, 1856291967,
            4143674472, 2538785911, 2159135699, 1908446793, 3303325234, 2589568800, 1193586059,
            77481069,   789413194,  2556570543, 162987300,  1960844609, 2973799047, 4253906178,
            315868734,  2542622968, 3949539136, 1479106582, 4225431384, 1235059630, 1533374854,
            847792023,  4031286530, 4194276632, 164541100,  1010135841, 143302319,  1335585015,
            1237311692, 20896020,   344974153,  2576803233, 3430251730, 984163376,  2680612471,
            1276425436, 2400671554, 1628640140, 2161048926, 2109177634, 998215324,  3127793500,
            1759998050, 3105138908, 2583746384, 2126302368, 3258602104, 1262742375, 3565617377,
            3726060195, 157069329,  390662438,  3800994052, 2007694482, 377281730,  3251789121,
            236703173,  122782596,  775407411,  3394010206, 4232159202, 468321553,  2704615220,
            1332411375, 2978494251, 989230484,  3122841814, 2348872707, 731335994,  541354422,
            223117443,  2225009071, 4230058949, 1875162926, 3897048544, 3550177883, 2461273592,
            1046820583, 1333727817, 1378024753, 3686775275, 4230752590, 64834458,   1281467967,
            729116355,  3886390916, 65029451,   3478506446, 1387684482, 1172004841, 2525409243,
            1677678908, 1704646757, 930937262,  1088384271, 689357059,  1754542213, 702963842,
            2864311668, 1960202673, 1009675673, 3742350158, 3751269215, 3166659283, 9090161,
            1854921599, 2655519695, 3124573588, 319882484,  1422536794, 4175512633, 141286453,
            1183670252, 1789500145, 850391877,  3190829323, 2782782009, 493805446,  1228958246,
            837232655,  2274981421, 2935438833, 3625733677, 3679506394, 955772620,  134516308,
            3576789728, 965007022,  1056542222, 874117013,  3944221200, 950102624,  3848192810,
            3205299696, 543679720,  1241913280, 1360146137, 1675732327, 2164452797, 1169030022,
            2226452641, 3172047212, 1569171738, 2631589480, 3783543297, 2030783667, 2237381973,
            2706217212, 3143638386, 1560162209, 1166820137, 3818389960, 193959252,  2793509934,
            4258046618, 2502743884, 1963136977, 3739017448, 25754513,   1204846712, 1856291967,
            4143674472, 2538785911, 2159135699, 3889946075, 3303325234, 2589568800, 1193586059,
            77481069,   969912041,  2556570543, 162987300,  1960844609, 2973799047, 427583517,
            315868734,  2542622968, 3949539136, 1479106582, 92839917,   1235059630, 1533374854,
            847792023,  4031286530, 1147875681, 164541100,  1010135841, 143302319,  1335585015,
            368616909,  20896020,   344974153,  2576803233, 3430251730, 1078575783, 2680612471,
            1276425436, 2400671554, 1628640140, 4149623645, 2109177634, 998215324,  3127793500,
            1759998050, 3525419965, 2583746384, 2126302368, 3258602104, 1262742375, 1996113346,
            3726060195, 157069329,  390662438,  3800994052, 982000497,  377281730,  3251789121,
            236703173,  122782596,  2303768414, 3394010206, 4232159202, 468321553,  2704615220,
            681592492,  2978494251, 989230484,  3122841814, 2348872707, 4089094260, 541354422,
            223117443,  2225009071, 4230058949, 2754981128, 3897048544, 3550177883, 2461273592,
            1046820583, 668143612,  1378024753, 3686775275, 4230752590, 64834458,   3765910650,
            729116355,  3886390916, 65029451,   3478506446, 3419111947, 1172004841, 2525409243,
            1677678908, 1704646757, 155635560,  1088384271, 689357059,  1754542213, 702963842,
            2712009967, 1960202673, 1009675673, 3742350158, 3751269215, 129749802,  9090161,
            1854921599, 2655519695, 3124573588, 809557750,  1422536794, 4175512633, 141286453,
            1183670252, 1739311360, 850391877,  3190829323, 2782782009, 493805446,  1738527771,
            837232655,  2274981421, 2935438833, 3625733677, 1858071296, 955772620,  134516308,
            3576789728, 965007022,  3367712327, 874117013,  3944221200, 950102624,  3848192810,
            2420548306, 543679720,  1241913280, 1360146137, 1675732327, 176019367,  1169030022,
            2226452641, 3172047212, 1569171738, 76544055,   3783543297, 2030783667, 2237381973,
            2706217212, 3283985735, 1560162209, 1166820137, 3818389960, 193959252,  346134252,
            4258046618, 2502743884, 1963136977, 3739017448, 3887005605, 1204846712, 1856291967,
            4143674472, 2538785911, 366578749,  3889946075, 3303325234, 2589568800, 1193586059,
            2917569085, 969912041,  2556570543, 162987300,  1960844609, 61311938,   427583517,
            315868734,  2542622968, 3949539136, 2278526422, 92839917,   1235059630, 1533374854,
            847792023,  1361054176, 1147875681, 164541100,  1010135841, 143302319,  1348709332,
            368616909,  20896020,   344974153,  2576803233, 3290873783, 1078575783, 2680612471,
            1276425436, 2400671554, 628790408,  4149623645, 2109177634, 998215324,  3127793500,
            2019336900, 3525419965, 2583746384, 2126302368, 3258602104, 2858154034, 1996113346,
            3726060195, 157069329,  390662438,  2250549235, 982000497,  377281730,  3251789121,
            236703173,  3487415996, 2303768414, 3394010206, 4232159202, 468321553,  2773608982,
            681592492,  2978494251, 989230484,  3122841814, 3647638215, 4089094260, 541354422,
            223117443,  2225009071, 2829509947, 2754981128, 3897048544, 3550177883, 2461273592,
            282627696,  668143612,  1378024753, 3686775275, 4230752590, 1105868822, 3765910650,
            729116355,  3886390916, 65029451,   328554604,  3419111947, 1172004841, 2525409243,
            1677678908, 1395036942, 155635560,  1088384271, 689357059,  1754542213, 1076601715,
            2712009967, 1960202673, 1009675673, 3742350158, 2581225953, 129749802,  9090161,
            1854921599, 2655519695, 1393282220, 809557750,  1422536794, 4175512633, 141286453,
            2211497169, 1739311360, 850391877,  3190829323, 2782782009, 2694871802, 1738527771,
            837232655,  2274981421, 2935438833, 3145832503, 1858071296, 955772620,  134516308,
            3576789728, 4045354759, 3367712327, 874117013,  3944221200, 950102624,  3562634568,
            2420548306, 543679720,  1241913280, 1360146137, 3644280343, 176019367,  1169030022,
            2226452641, 3172047212, 3927720006, 76544055,   3783543297, 2030783667, 2237381973,
            1497233808, 3283985735, 1560162209, 1166820137, 3818389960, 2344066681, 346134252,
            4258046618, 2502743884, 1963136977, 79988846,   3887005605, 1204846712, 1856291967,
            4143674472, 3967952414, 366578749,  3889946075, 3303325234, 2589568800, 2193179011,
            2917569085, 969912041,  2556570543, 162987300,  52882655,   61311938,   427583517,
            315868734,  2542622968, 1575831590, 2278526422, 92839917,   1235059630, 1533374854,
            2397068791, 1361054176, 1147875681, 164541100,  1010135841, 2586368032, 1348709332,
            368616909,  20896020,   344974153,  3445652232, 3290873783, 1078575783, 2680612471,
            1276425436, 3682156544, 628790408,  4149623645, 2109177634, 998215324,  4049708298,
            2019336900, 3525419965, 2583746384, 2126302368, 1627944270, 2858154034, 1996113346,
            3726060195, 157069329,  1481222640, 2250549235, 982000497,  377281730,  3251789121,
            3564274539, 3487415996, 2303768414, 3394010206, 4232159202, 3509025997, 2773608982,
            681592492,  2978494251, 989230484,  980252048,  3647638215, 4089094260, 541354422,
            223117443,  543970497,  2829509947, 2754981128, 3897048544, 3550177883, 2736782140,
            282627696,  668143612,  1378024753, 3686775275, 2728601425, 1105868822, 3765910650,
            729116355,  3886390916, 1866378660, 328554604,  3419111947, 1172004841, 2525409243,
            1506924008, 1395036942, 155635560,  1088384271, 689357059,  3587092123, 1076601715,
            2712009967, 1960202673, 1009675673, 4292715891, 2465250857, 3267969665, 2459570573,
            3644463083, 1637197500, 684559293,  3520611957, 2976084366, 1512112440, 1778285193,
            1849742417, 3144801412, 3009052859, 820829188,  1382783871, 3373481539, 3777016406,
            266942530,  1792334422, 4109859515, 1468149634, 1356457853, 623893785,  1301686542,
            441704877,  3377795902, 879822753,  329462927,  543858304,  2221828617, 2996486613,
            981774202,  1032220084, 1066536452, 1004068806, 1336694798, 3744375323, 3802436665,
            3366526577, 418696462,  1776559103, 1291965608, 1623030339, 1443628607, 572114324,
            899621592,  332121275,  3637616671, 457287722,  3803043476, 408472701,  660940326,
            1209169008, 1202511620, 2906900959, 2600414642, 2015874468, 2931389161, 1760773669,
            2601299639, 543821664,  3426280682, 1337602255, 3334593650, 1320885980, 3857269540,
            2548321029, 2250001180, 673341051,  1900184720, 731675831,  2461790412, 2593291320,
            1640301250, 863529987,  91627443,   2437824309, 2834231475, 4093270720, 1474594761,
            4186662839, 1683556862, 1302286991, 806676270,  703274107,  3756759580, 674737904,
            912015048,  1823306025, 1509430520, 3128952761, 290841833,  3917789380, 1022040580,
            1810054038, 334998864,  1009274987, 310979037,  606749827,  546291081,  3438438313,
            1840081424, 1950680845, 4217236364, 1814584903, 2814353208, 194196981,  1540331253,
            3135937654, 773351497,  1878220007, 3097009802, 1252607159, 1378821846, 2741884614,
            178612659,  3656860395, 1259606652, 3942111545, 488406826,  3640897405, 3419000480,
            353909713,  2996208477, 2862593073, 108483327,  648472258,  1060249632, 1049865483,
            430087518,  1364157854, 3367631180, 251313827,  2374149836, 2109357086, 479172068,
            464775113,  1806677787, 3488082411, 356035738,  3080424395, 4134646749, 369528743,
            1031004516, 2525336414, 4189798138, 3928909462, 568714397,  1681832820, 1753328641,
            827357673,  1651960551, 1798317455, 737101952,  3257553606, 400882781,  1473208110,
            4134183873, 2193420912,
        },
        {
            287546114,  1691353531, 1209117247, 815163086,  4025051513, 1102751990, 3442978677,
            3607550431, 1623563608, 2818007290, 160881359,  3502630739, 2004794525, 4130080240,
            213334256,  4009886366, 3800127566, 2803380768, 3968323538, 2900509750, 756019302,
            3777779876, 2594832059, 3699064522, 1928098731, 3037524666, 3523425953, 512108928,
            3104024783, 3459472904, 588451508,  1163667526, 3231918721, 869992076,  1634455585,
            3600301964, 2709437176, 84210913,   852154367,  960644586,  1753854014, 2235681303,
            1752958397, 3235808697, 981791932,  3443307333, 3750194415, 1101438550, 1529333846,
            536329290,  2175939427, 3416356103, 793908398,  3380917903, 122513119,  2088349009,
            2136684581, 3220816427, 4273141048, 2573761965, 2760820885, 1472796086, 396503583,
            52240924,   1871519184, 1499497067, 2330725511, 4005841441, 1657006387, 259025800,
            2470355354, 1482200486, 1302198300, 2421100437, 3469422708, 2266783181, 432945856,
            3652957493, 2379255190, 2807461181, 309281255,  790026486,  2795347650, 4158027329,
            1845724700, 2269894626, 1521853266, 4228170316, 4091680367, 887495078,  2171633441,
            121417978,  1203090498, 3785485463, 3714886637, 2871048221, 776568297,  1066506408,
            3766146030, 3240604617, 2374590033, 814058594,  1090818449, 3939105642, 1512290608,
            2375368958, 1628560762, 1084758411, 2539035509, 914507943,  1160844665, 854530246,
            1877493697, 4179935894, 2328514258, 2826827214, 2947522907, 1898587442, 2726664773,
            2966472753, 4287401606, 3742209901, 3301945401, 794718489,  2068467932, 3735908395,
            3161858689, 83783963,   2780408691, 1966672120, 881600950,  1430523325, 3354266814,
            2996014385, 3178488657, 846402601,  3181463688, 2338118848, 2783339386, 352203800,
            1674996703, 1340214251, 1811132159, 3626324184, 947446963,  608394414,  2624400554,
            176184919,  3345989222, 3578452278, 4096464746, 702079551,  710360582,  1112441434,
            3121713743, 1237676859, 2550709342, 154687703,  2834426064, 3075937422, 2549461595,
            287546114,  1691353531, 1209117247, 815163086,  1380704280, 1102751990, 3442978677,
            3607550431, 1623563608, 2688083967, 160881359,  3502630739, 2004794525, 4130080240,
            2898693680, 4009886366, 3800127566, 2803380768, 3968323538, 739956172,  756019302,
            3777779876, 2594832059, 3699064522, 1319990491, 3037524666, 3523425953, 512108928,
            3104024783, 3798340022, 588451508,  1163667526, 3231918721, 869992076,  468045955,
            3600301964, 2709437176, 84210913,   852154367,  1108660931, 1753854014, 2235681303,
            1752958397, 3235808697, 1120944367, 3443307333, 3750194415, 1101438550, 1529333846,
            1026744192, 2175939427, 3416356103, 793908398,  3380917903, 1668321897, 2088349009,
            2136684581, 3220816427, 4273141048, 4137158661, 2760820885, 1472796086, 396503583,
            52240924,   865864801,  1499497067, 2330725511, 4005841441, 1657006387, 941949657,
            2470355354, 1482200486, 1302198300, 2421100437, 1107613131, 2266783181, 432945856,
            3652957493, 2379255190, 2202136630, 309281255,  790026486,  2795347650, 4158027329,
            2323393555, 2269894626, 1521853266, 4228170316, 4091680367, 460037458,  2171633441,
            121417978,  1203090498, 3785485463, 3619669147, 2871048221, 776568297,  1066506408,
            3766146030, 3312488376, 2374590033, 814058594,  1090818449, 3939105642, 2517689650,
            2375368958, 1628560762, 1084758411, 2539035509, 2159204016, 1160844665, 854530246,
            1877493697, 4179935894, 313507151,  2826827214, 2947522907, 1898587442, 2726664773,
            3015622595, 4287401606, 3742209901, 3301945401, 794718489,  2912068897, 3735908395,
            3161858689, 83783963,   2780408691, 460110400,  881600950,  1430523325, 3354266814,
            2996014385, 1223576728, 846402601,  3181463688, 2338118848, 2783339386, 3891915851,
            1674996703, 1340214251, 1811132159, 3626324184, 3842533055, 608394414,  2624400554,
            176184919,  3345989222, 1555926851, 4096464746, 702079551,  710360582,  1112441434,
            2786268578, 1237676859, 2550709342, 154687703,  2834426064, 1187362611, 2549461595,
            287546114,  1691353531, 1209117247, 2609157083, 1380704280, 1102751990, 3442978677,
            3607550431, 1121916195, 2688083967, 160881359,  3502630739, 2004794525, 3731857959,
            2898693680, 4009886366, 3800127566, 2803380768, 1236217292, 739956172,  756019302,
            3777779876, 2594832059, 4222705412, 1319990491, 3037524666, 3523425953, 512108928,
            2320682998, 3798340022, 588451508,  1163667526, 3231918721, 3831924125, 468045955,
            3600301964, 2709437176, 84210913,   498267226,  1108660931, 1753854014, 2235681303,
            1752958397, 3431339050, 1120944367, 3443307333, 3750194415, 1101438550, 3239541196,
            1026744192, 2175939427, 3416356103, 793908398,  3144205185, 1668321897, 2088349009,
            2136684581, 3220816427, 772353089,  4137158661, 2760820885, 1472796086, 396503583,
            3864264909, 865864801,  1499497067, 2330725511, 4005841441, 53907027,   941949657,
            2470355354, 1482200486, 1302198300, 1359798548, 1107613131, 2266783181, 432945856,
            3652957493, 3751071617, 2202136630, 309281255,  790026486,  2795347650, 2648824276,
            2323393555, 2269894626, 1521853266, 4228170316, 1547123433, 460037458,  2171633441,
            121417978,  1203090498, 3619566504, 3619669147, 2871048221, 776568297,  1066506408,
            3098132193, 3312488376, 2374590033, 814058594,  1090818449, 1545760098, 2517689650,
            2375368958, 1628560762, 1084758411, 3761574862, 2159204016, 1160844665, 854530246,
            1877493697, 1436305828, 313507151,  2826827214, 2947522907, 1898587442, 2977453247,
            3015622595, 4287401606, 3742209901, 3301945401, 2226348298, 2912068897, 3735908395,
            3161858689, 83783963,   3415275566, 460110400,  881600950,  1430523325, 3354266814,
            2708566546, 1223576728, 846402601,  3181463688, 2338118848, 3385855067, 3891915851,
            1674996703, 1340214251, 1811132159, 3855788390, 3842533055, 608394414,  2624400554,
            176184919,  2620223471, 1555926851, 4096464746, 702079551,  710360582,  3627447950,
            2786268578, 1237676859, 2550709342, 154687703,  708021466,  1187362611, 2549461595,
            287546114,  1691353531, 1405851922, 2609157083, 1380704280, 1102751990, 3442978677,
            3025088034, 1121916195, 2688083967, 160881359,  3502630739, 793790562,  3731857959,
            2898693680, 4009886366, 3800127566, 741552068,  1236217292, 739956172,  756019302,
            3777779876, 1239950732, 4222705412, 1319990491, 3037524666, 3523425953, 1502163428,
            2320682998, 3798340022, 588451508,  1163667526, 1913408620, 3831924125, 468045955,
            3600301964, 2709437176, 3108777528, 498267226,  1108660931, 1753854014, 2235681303,
            675121580,  3431339050, 1120944367, 3443307333, 3750194415, 4155512262, 3239541196,
            1026744192, 2175939427, 3416356103, 3664397917, 3144205185, 1668321897, 2088349009,
            2136684581, 3700103929, 772353089,  4137158661, 2760820885, 1472796086, 2653728317,
            3864264909, 865864801,  1499497067, 2330725511, 2790266733, 53907027,   941949657,
            2470355354, 1482200486, 4128145129, 1359798548, 1107613131, 2266783181, 432945856,
            541996453,  3751071617, 2202136630, 309281255,  790026486,  3374225015, 2648824276,
            2323393555, 2269894626, 1521853266, 3640549727, 1547123433, 460037458,  2171633441,
            121417978,  1137237747, 3619566504, 3619669147, 2871048221, 776568297,  3965676993,
            3098132193, 3312488376, 2374590033, 814058594,  3655686387, 1545760098, 2517689650,
            2375368958, 1628560762, 3955035569, 3761574862, 2159204016, 1160844665, 854530246,
            3594807865, 1436305828, 313507151,  2826827214, 2947522907, 2268656538, 2977453247,
            3015622595, 4287401606, 3742209901, 4007770285, 2226348298, 2912068897, 3735908395,
            3161858689, 2608356926, 3415275566, 460110400,  881600950,  1430523325, 1238627893,
            2708566546, 1223576728, 846402601,  3181463688, 2462005424, 3385855067, 3891915851,
            1674996703, 1340214251, 4079096585, 3855788390, 3842533055, 608394414,  2624400554,
            1852239609, 2620223471, 1555926851, 4096464746, 702079551,  208935289,  3627447950,
            2786268578, 1237676859, 2550709342, 3456802877, 410465223,  2527279502, 2371778681,
            2977359812, 2866454918, 1348901368, 2788515648, 1656164608, 2679414635, 1743589107,
            2271232039, 3337667096, 3309335034, 3041523564, 3556304923, 3088012933, 4890918,
            639508595,  1079676087, 4232978208, 3356605818, 2349396908, 755696831,  1965450669,
            2843189612, 1842828643, 2529799768, 3166250653, 3066708972, 1422024950, 55547676,
            2743620637, 2040487001, 106972738,  1151858428, 1714050436, 2324828005, 2303110746,
            3458393369, 409767326,  230056730,  2367234783, 1965199732, 4138511180, 2370359683,
            11510847,   1692269598, 3212810187, 1004131128, 235193870,  714411255,  946936306,
            1558975663, 3780068667, 1350692628, 148823932,  405893564,  2449241295, 3183670957,
            2895560892, 2635969951, 3123667304, 3943139846, 3440610780, 2782592016, 2834582539,
            2574396218, 1234892726, 2419421514, 3542212415, 3555945673, 1504695005, 1007772407,
            3386588704, 2184541749, 2877779265, 3938293530, 1346842419, 1855385478, 3976228826,
            154925238,  2813387627, 2191183695, 237263299,  2466389542, 3620890620, 3816083693,
            2161050775, 474995995,  2793579675, 2305437767, 1570484979, 1727331661, 3989933750,
            3753665949, 271981391,  4177423842, 3117260152, 392740456,  3296043721, 1897911388,
            2792086546, 2664552299, 3079919794, 2379149229, 2840030917, 3922196585, 466292334,
            1175443475, 4145476995, 2294724701, 537187052,  173346010,  1262636381, 2353176609,
            1064715525, 2525770753, 92642061,   1614224999, 1496652628, 1876801199, 4257907905,
            2764788104, 1442929103, 4251769243, 480443342,  1679561525, 3495007875, 4062945408,
            2490187887, 1224178047, 2867005574, 69620990,   3653112883, 1701875485, 4234557600,
            2175144515, 3452924068, 1562926928, 2983222881, 594503377,  3938413194, 222725825,
            1854991646, 254778104,  4228745713, 434053271,  4241966632, 3633584774, 1206019886,
            696551895,  3047810616, 3910429051, 490700305,  3502588296, 3702610161, 75968127,
            2727623645, 3947972838,
        },
        {
            2483976489, 2790651795, 3298324523, 3508205426, 2236819708, 917494217,  769620837,
            3411018785, 2391335000, 1627061280, 3356773416, 1288706527, 4178910717, 3636299534,
            4221874052, 3674654381, 537787012,  4271656840, 185820273,  1160533598, 1862365049,
            2550353307, 1392072847, 1870891365, 1517453821, 524666025,  3645751565, 2415020247,
            3691419894, 2580450642, 2130267479, 3636103610, 562446539,  750696587,  97137475,
            3894066051, 2239638596, 3256181120, 3981041836, 774947039,  451287677,  3618957054,
            4236303539, 1027744929, 1497195372, 498574915,  2164122779, 582902291,  3040883311,
            1626221455, 1853378,    2125490000, 3185055972, 1607660025, 432884530,  779476209,
            124284956,  2488937128, 2521389012, 107485781,  2873055013, 1171872946, 3130489952,
            4273333914, 646240524,  3970896645, 942009076,  4069926418, 3129385884, 3470469370,
            388702536,  450999415,  2995728716, 1687173264, 3049352827, 2648078738, 190663705,
            486809970,  424002670,  2421764946, 2941043524, 3841512738, 119077561,  1801381572,
            2208680167, 2502730219, 9899015,    2455199230, 3755314209, 3958460021, 3846398898,
            1405136244, 2870563334, 821846618,  2790899812, 863647562,  629585032,  958925512,
            1190540209, 57251233,   2109551995, 2294881622, 2603370255, 3839518646, 123838650,
            3436270690, 1637121394, 3761101432, 954001192,  759760236,  3268295908, 2313083096,
            630164216,  2367213191, 3992059381, 3292952769, 2040774258, 1420209005, 527547730,
            1222399440, 1515078401, 2005580991, 645585788,  2256370254, 3057235502, 2870727428,
            2785498804, 333440916,  1873686678, 2489794553, 3726728164, 3405629071, 3869328595,
            3081963448, 2122133003, 1428788181, 4141962679, 41030733,   183716455,  36316501,
            1430796327, 1884066707, 1216957106, 3455082673, 1092665987, 535070834,  3873372533,
            175757671,  3414803303, 791028991,  3436610906, 2950895946, 977680845,  4224715886,
            2809442211, 4044727083, 3035532020, 4253187882, 969203959,  2539482914, 813880136,
            2483976489, 2790651795, 3298324523, 3508205426, 49280479,   917494217,  769620837,
            3411018785, 2391335000, 3036738936, 3356773416, 1288706527, 4178910717, 3636299534,
            2294957038, 3674654381, 537787012,  4271656840, 185820273,  2622722506, 1862365049,
            2550353307, 1392072847, 1870891365, 2838104933, 524666025,  3645751565, 2415020247,
            3691419894, 1295777418, 2130267479, 3636103610, 562446539,  750696587,  249830932,
            3894066051, 2239638596, 3256181120, 3981041836, 3217398876, 451287677,  3618957054,
            4236303539, 1027744929, 1724964245, 498574915,  2164122779, 582902291,  3040883311,
            3101287841, 1853378,    2125490000, 3185055972, 1607660025, 1128474163, 779476209,
            124284956,  2488937128, 2521389012, 338597864,  2873055013, 1171872946, 3130489952,
            4273333914, 1557892392, 3970896645, 942009076,  4069926418, 3129385884, 2688433076,
            388702536,  450999415,  2995728716, 1687173264, 157685189,  2648078738, 190663705,
            486809970,  424002670,  979986388,  2941043524, 3841512738, 119077561,  1801381572,
            2668625968, 2502730219, 9899015,    2455199230, 3755314209, 2699515741, 3846398898,
            1405136244, 2870563334, 821846618,  505633792,  863647562,  629585032,  958925512,
            1190540209, 2067402799, 2109551995, 2294881622, 2603370255, 3839518646, 2688067120,
            3436270690, 1637121394, 3761101432, 954001192,  3206166733, 3268295908, 2313083096,
            630164216,  2367213191, 3007494680, 3292952769, 2040774258, 1420209005, 527547730,
            4047406592, 1515078401, 2005580991, 645585788,  2256370254, 13805572,   2870727428,
            2785498804, 333440916,  1873686678, 1928222740, 3726728164, 3405629071, 3869328595,
            3081963448, 2971423693, 1428788181, 4141962679, 41030733,   183716455,  4064095256,
            1430796327, 1884066707, 1216957106, 3455082673, 985592757,  535070834,  3873372533,
            175757671,  3414803303, 2159028553, 3436610906, 2950895946, 977680845,  4224715886,
            345462057,  4044727083, 3035532020, 4253187882, 969203959,  984166534,  813880136,
            2483976489, 2790651795, 3298324523, 1080001158, 49280479,   917494217,  769620837,
            3411018785, 3216598401, 3036738936, 3356773416, 1288706527, 4178910717, 3311472057,
            2294957038, 3674654381, 537787012,  4271656840, 220045511,  2622722506, 1862365049,
            2550353307, 1392072847, 3057632678, 2838104933, 524666025,  3645751565, 2415020247,
            252304106,  1295777418, 2130267479, 3636103610, 562446539,  80437039,   249830932,
            3894066051, 2239638596, 3256181120, 117173223,  3217398876, 451287677,  3618957054,
            4236303539, 1986849360, 1724964245, 498574915,  2164122779, 582902291,  288631030,
            3101287841, 1853378,    2125490000, 3185055972, 824635664,  1128474163, 779476209,
            124284956,  2488937128, 1231646648, 338597864,  2873055013, 1171872946, 3130489952,
            708957725,  1557892392, 3970896645, 942009076,  4069926418, 2286522565, 2688433076,
            388702536,  450999415,  2995728716, 2523361978, 157685189,  2648078738, 190663705,
            486809970,  151444406,  979986388,  2941043524, 3841512738, 119077561,  3762447035,
            2668625968, 2502730219, 9899015,    2455199230, 3532439568, 2699515741, 3846398898,
            1405136244, 2870563334, 2242036665, 505633792,  863647562,  629585032,  958925512,
            2618618630, 2067402799, 2109551995, 2294881622, 2603370255, 2461404010, 2688067120,
            3436270690, 1637121394, 3761101432, 1076814097, 3206166733, 3268295908, 2313083096,
            630164216,  12196305,   3007494680, 3292952769, 2040774258, 1420209005, 2609377752,
            4047406592, 1515078401, 2005580991, 645585788,  865985176,  13805572,   2870727428,
            2785498804, 333440916,  3735553268, 1928222740, 3726728164, 3405629071, 3869328595,
            501640466,  2971423693, 1428788181, 4141962679, 41030733,   97561214,   4064095256,
            1430796327, 1884066707, 1216957106, 3840122090, 985592757,  535070834,  3873372533,
            175757671,  3856277268, 2159028553, 3436610906, 2950895946, 977680845,  3313441827,
            345462057,  4044727083, 3035532020, 4253187882, 3468811573, 984166534,  813880136,
            2483976489, 2790651795, 3733649754, 1080001158, 49280479,   917494217,  769620837,
            3969566450, 3216598401, 3036738936, 3356773416, 1288706527, 2444128005, 3311472057,
            2294957038, 3674654381, 537787012,  4166109669, 220045511,  2622722506, 1862365049,
            2550353307, 2552992760, 3057632678, 2838104933, 524666025,  3645751565, 664164441,
            252304106,  1295777418, 2130267479, 3636103610, 3227561061, 80437039,   249830932,
            3894066051, 2239638596, 1071536668, 117173223,  3217398876, 451287677,  3618957054,
            3066415327, 1986849360, 1724964245, 498574915,  2164122779, 3541914330, 288631030,
            3101287841, 1853378,    2125490000, 2207189978, 824635664,  1128474163, 779476209,
            124284956,  2117633906, 1231646648, 338597864,  2873055013, 1171872946, 891038594,
            708957725,  1557892392, 3970896645, 942009076,  42952651,   2286522565, 2688433076,
            388702536,  450999415,  2986730356, 2523361978, 157685189,  2648078738, 190663705,
            3058267870, 151444406,  979986388,  2941043524, 3841512738, 1844101292, 3762447035,
            2668625968, 2502730219, 9899015,    2599582093, 3532439568, 2699515741, 3846398898,
            1405136244, 811001941,  2242036665, 505633792,  863647562,  629585032,  2722320710,
            2618618630, 2067402799, 2109551995, 2294881622, 1820862072, 2461404010, 2688067120,
            3436270690, 1637121394, 3642978005, 1076814097, 3206166733, 3268295908, 2313083096,
            1900318020, 12196305,   3007494680, 3292952769, 2040774258, 520848705,  2609377752,
            4047406592, 1515078401, 2005580991, 2530251392, 865985176,  13805572,   2870727428,
            2785498804, 2878984912, 3735553268, 1928222740, 3726728164, 3405629071, 2717736455,
            501640466,  2971423693, 1428788181, 4141962679, 3704214873, 97561214,   4064095256,
            1430796327, 1884066707, 1721732760, 3840122090, 985592757,  535070834,  3873372533,
            770732059,  3856277268, 2159028553, 3436610906, 2950895946, 33753949,   3313441827,
            345462057,  4044727083, 3035532020, 4166506071, 2719759982, 1025532659, 3811323959,
            713457907,  1577198020, 1719946821, 3963262337, 1719605451, 703663722,  1943886497,
            2916371044, 1655862745, 109438187,  195575943,  2572727533, 2421761970, 1796539813,
            2020762515, 1191344316, 2492085516, 2778033179, 4002316684, 1571080685, 1157340389,
            3859584731, 3403766082, 2292873365, 2032258920, 1749575450, 848549431,  1893685820,
            3510068298, 3308906564, 1193936308, 2561670234, 1043148718, 2611815896, 3832995202,
            2436487998, 3377369330, 1174818128, 796514731,  1985886833, 88296218,   3032898657,
            4101301361, 1486994584, 237792475,  1029399834, 1708840018, 2934039708, 1496674948,
            4243234983, 3896751668, 1726119825, 2706068825, 1900013134, 2639641919, 1433377392,
            2962655166, 1870954268, 3873603462, 1778084630, 2393311756, 4135022799, 3669603001,
            811404758,  784379778,  4283689136, 405168660,  3873488622, 486946690,  347427153,
            2139072474, 1143349522, 3780264455, 2938731842, 3864001470, 3497981827, 2703917008,
            3222236962, 2604106616, 1281570367, 175937153,  433252852,  3232065906, 1111895932,
            1027363895, 2435093744, 4232690481, 1940855209, 2844613991, 2095175619, 3479946852,
            393314401,  3625733631, 1073779513, 2884072879, 4089630675, 3614205484, 1379809260,
            3980251795, 3914556410, 3633356126, 3030204458, 1654727861, 3765074811, 959734060,
            842315676,  353688341,  145655006,  1972100601, 1456042517, 3767579955, 4282066379,
            498998655,  4123310742, 1801424182, 777808179,  655425670,  588715641,  2136252742,
            1283378143, 639191135,  3132375783, 276649124,  2036776039, 3352396498, 3893441746,
            3298373918, 1024178230, 2623051553, 1956117442, 2955394456, 2478945776, 3904945720,
            769232312,  2168822980, 3715831945, 453874622,  3351529191, 3256151193, 808042625,
            1700919462, 1008305347, 1518733915, 3194328753, 2228970756, 2604658038, 1376476152,
            2147167203, 2585867511, 445717950,  3595016420, 3673970127, 3640614546, 494944945,
            152508312,  4160926899,
        },
        {
            3768222172, 2387893372, 1009690886, 1356119455, 1423515759, 3059794750, 788779714,
            804769003,  4027776516, 2613606537, 355319065,  3427882437, 3410629786, 166022080,
            2059453911, 3231065028, 1005757210, 2662637739, 312073532,  1191557480, 4155755125,
            2376388482, 899163090,  1991371366, 1555415895, 106909804,  3427942745, 1402702969,
            3979660402, 1863197509, 1506383166, 622109507,  2890478459, 854092320,  535230382,
            1407679730, 2446615381, 2462005247, 557723077,  4125621321, 3976453128, 4105465176,
            541102572,  2154548888, 2984933516, 1892545081, 3631770854, 232142943,  2900323085,
            2416481322, 3269696738, 18878239,   2770064364, 3140815659, 3579910566, 3817677084,
            35078888,   862461863,  1714761173, 1982743914, 4087167827, 527751280,  1741859077,
            811845735,  4085396003, 2344463734, 810859036,  2775583142, 1610844650, 3107987288,
            912531903,  1159119082, 1562376198, 1118301950, 4233921985, 500654263,  3701966181,
            3095371291, 2985367014, 2909313497, 1817270838, 223321204,  1045772227, 2969601332,
            820221794,  2103779082, 2767611456, 111885353,  1385237722, 3258919291, 3814970359,
            1583140848, 1501659545, 320480791,  3663524173, 2011099222, 239545338,  2095779210,
            2376327920, 892461686,  524084755,  3062528013, 1276241796, 975515736,  2909890521,
            84893718,   1596224592, 1383942440, 79530681,   1781958804, 1798298860, 3920995111,
            4086149390, 3152362884, 1284184915, 3949103592, 3103845494, 3633238948, 2054717014,
            461449501,  4101397514, 1014519593, 1756272015, 4140072126, 1888270477, 1942153239,
            3764540263, 4209337880, 2960596017, 2843732938, 3887027560, 3757353348, 671035574,
            2580174722, 3236108872, 1832691422, 1751930116, 2138974919, 2651729683, 3152577662,
            2339274571, 282818302,  720279153,  2802524073, 1418605777, 1000343555, 979277932,
            2378965790, 1527493352, 2916164107, 2228106117, 4064632056, 2781294484, 442404507,
            1641767805, 3350246065, 2902851120, 3990037464, 1250120477, 1445180081, 3394752511,
            3768222172, 2387893372, 1009690886, 1356119455, 3789180470, 3059794750, 788779714,
            804769003,  4027776516, 2243897329, 355319065,  3427882437, 3410629786, 166022080,
            4026483215, 3231065028, 1005757210, 2662637739, 312073532,  4281885273, 4155755125,
            2376388482, 899163090,  1991371366, 1058529294, 106909804,  3427942745, 1402702969,
            3979660402, 20268130,   1506383166, 622109507,  2890478459, 854092320,  1461801104,
            1407679730, 2446615381, 2462005247, 557723077,  3689875621, 3976453128, 4105465176,
            541102572,  2154548888, 2350473764, 1892545081, 3631770854, 232142943,  2900323085,
            1543720156, 3269696738, 18878239,   2770064364, 3140815659, 654760494,  3817677084,
            35078888,   862461863,  1714761173, 1458997647, 4087167827, 527751280,  1741859077,
            811845735,  1595039757, 2344463734, 810859036,  2775583142, 1610844650, 2771429828,
            912531903,  1159119082, 1562376198, 1118301950, 20254062,   500654263,  3701966181,
            3095371291, 2985367014, 1781377640, 1817270838, 223321204,  1045772227, 2969601332,
            1978543308, 2103779082, 2767611456, 111885353,  1385237722, 2330272978, 3814970359,
            1583140848, 1501659545, 320480791,  3884271784, 2011099222, 239545338,  2095779210,
            2376327920, 3664002662, 524084755,  3062528013, 1276241796, 975515736,  3600054563,
            84893718,   1596224592, 1383942440, 79530681,   898175473,  1798298860, 3920995111,
            4086149390, 3152362884, 1474111457, 3949103592, 3103845494, 3633238948, 2054717014,
            1261909867, 4101397514, 1014519593, 1756272015, 4140072126, 136370913,  1942153239,
            3764540263, 4209337880, 2960596017, 1456050040, 3887027560, 3757353348, 671035574,
            2580174722, 1453957539, 1832691422, 1751930116, 2138974919, 2651729683, 1730481226,
            2339274571, 282818302,  720279153,  2802524073, 833849387,  1000343555, 979277932,
            2378965790, 1527493352, 1568302440, 2228106117, 4064632056, 2781294484, 442404507,
            1885932783, 3350246065, 2902851120, 3990037464, 1250120477, 2067765996, 3394752511,
            3768222172, 2387893372, 1009690886, 3577286715, 3789180470, 3059794750, 788779714,
            804769003,  3892626157, 2243897329, 355319065,  3427882437, 3410629786, 686040091,
            4026483215, 3231065028, 1005757210, 2662637739, 189512869,  4281885273, 4155755125,
            2376388482, 899163090,  2831286795, 1058529294, 106909804,  3427942745, 1402702969,
            940892897,  20268130,   1506383166, 622109507,  2890478459, 2686965496, 1461801104,
            1407679730, 2446615381, 2462005247, 2954376079, 3689875621, 3976453128, 4105465176,
            541102572,  4023579111, 2350473764, 1892545081, 3631770854, 232142943,  4220800612,
            1543720156, 3269696738, 18878239,   2770064364, 3882855629, 654760494,  3817677084,
            35078888,   862461863,  504086311,  1458997647, 4087167827, 527751280,  1741859077,
            1796475695, 1595039757, 2344463734, 810859036,  2775583142, 1370006688, 2771429828,
            912531903,  1159119082, 1562376198, 1653508041, 20254062,   500654263,  3701966181,
            3095371291, 760720945,  1781377640, 1817270838, 223321204,  1045772227, 3711293483,
            1978543308, 2103779082, 2767611456, 111885353,  2494269448, 2330272978, 3814970359,
            1583140848, 1501659545, 3722438802, 3884271784, 2011099222, 239545338,  2095779210,
            3179775087, 3664002662, 524084755,  3062528013, 1276241796, 3932792486, 3600054563,
            84893718,   1596224592, 1383942440, 638873554,  898175473,  1798298860, 3920995111,
            4086149390, 510521639,  1474111457, 3949103592, 3103845494, 3633238948, 261668710,
            1261909867, 4101397514, 1014519593, 1756272015, 2204458707, 136370913,  1942153239,
            3764540263, 4209337880, 1439582629, 1456050040, 3887027560, 3757353348, 671035574,
            3267485872, 1453957539, 1832691422, 1751930116, 2138974919, 415879626,  1730481226,
            2339274571, 282818302,  720279153,  3408966461, 833849387,  1000343555, 979277932,
            2378965790, 2166264580, 1568302440, 2228106117, 4064632056, 2781294484, 3984478460,
            1885932783, 3350246065, 2902851120, 3990037464, 4047770808, 2067765996, 3394752511,
            3768222172, 2387893372, 2359240697, 3577286715, 3789180470, 3059794750, 788779714,
            1422395729, 3892626157, 2243897329, 355319065,  3427882437, 186439692,  686040091,
            4026483215, 3231065028, 1005757210, 3889796672, 189512869,  4281885273, 4155755125,
            2376388482, 4102407701, 2831286795, 1058529294, 106909804,  3427942745, 1609640351,
            940892897,  20268130,   1506383166, 622109507,  3302024941, 2686965496, 1461801104,
            1407679730, 2446615381, 1859657509, 2954376079, 3689875621, 3976453128, 4105465176,
            1048179859, 4023579111, 2350473764, 1892545081, 3631770854, 1904993278, 4220800612,
            1543720156, 3269696738, 18878239,   3221689425, 3882855629, 654760494,  3817677084,
            35078888,   1647172374, 504086311,  1458997647, 4087167827, 527751280,  2789786040,
            1796475695, 1595039757, 2344463734, 810859036,  900782853,  1370006688, 2771429828,
            912531903,  1159119082, 3078633143, 1653508041, 20254062,   500654263,  3701966181,
            1323768974, 760720945,  1781377640, 1817270838, 223321204,  1229398662, 3711293483,
            1978543308, 2103779082, 2767611456, 1297688198, 2494269448, 2330272978, 3814970359,
            1583140848, 2761029056, 3722438802, 3884271784, 2011099222, 239545338,  1797471174,
            3179775087, 3664002662, 524084755,  3062528013, 1141383200, 3932792486, 3600054563,
            84893718,   1596224592, 1719763001, 638873554,  898175473,  1798298860, 3920995111,
            2355503218, 510521639,  1474111457, 3949103592, 3103845494, 2802707133, 261668710,
            1261909867, 4101397514, 1014519593, 166198958,  2204458707, 136370913,  1942153239,
            3764540263, 39164274,   1439582629, 1456050040, 3887027560, 3757353348, 2800830635,
            3267485872, 1453957539, 1832691422, 1751930116, 391425668,  415879626,  1730481226,
            2339274571, 282818302,  3250117746, 3408966461, 833849387,  1000343555, 979277932,
            3953423919, 2166264580, 1568302440, 2228106117, 4064632056, 1791653813, 3984478460,
            1885932783, 3350246065, 2902851120, 831769506,  115860071,  784412381,  3509278979,
            3714055523, 3217528798, 986270561,  2115343170, 2247260524, 2916137217, 2428781852,
            356419466,  2382851398, 507118053,  647388427,  3535883429, 3797563926, 3610680089,
            807658589,  2961110831, 3325050237, 1394169430, 901625889,  3975030204, 498254226,
            160561990,  2447755288, 440247320,  2655126355, 1112724649, 3509767111, 1933387809,
            360860498,  763486711,  2016115096, 998747839,  495486228,  149568843,  1087058102,
            378466686,  1928396139, 1844400850, 644612036,  116338267,  1313636548, 1827796299,
            588934667,  3144173381, 3662645142, 4116809072, 4261333625, 1588298130, 959901383,
            207818065,  2283909529, 3806317894, 3041226407, 520117613,  94551354,   2794568581,
            1908912284, 4221345433, 4218149178, 2778755735, 2728994635, 1905422291, 2007029929,
            3980305143, 1608773855, 372679629,  3537807381, 2617844017, 1767288650, 1184964650,
            3300433830, 2543695792, 1294638855, 1034173049, 1086203811, 95729793,   3900110099,
            519895172,  138224162,  4103368335, 2201766157, 2692380354, 4052382065, 3989778981,
            3261660772, 3844446885, 2070368801, 2767661787, 2328307364, 3028131379, 606354618,
            1832328704, 301998775,  2083459252, 1490943893, 1365468049, 3094155545, 999715991,
            2525292229, 469335476,  1211552861, 414655797,  3245382527, 1514791053, 1512602571,
            1845686662, 2462670460, 3130754167, 3026164805, 1933209982, 3000799147, 3685140855,
            3018906257, 3279398793, 2120248402, 2197715050, 3906494024, 278206013,  1461298455,
            1291014138, 2407383612, 2647629418, 1901124948, 3606438501, 824568411,  2628016312,
            1322474034, 684750816,  4075617482, 2865308217, 519062450,  3828364180, 1860865087,
            3939167290, 402431440,  2704730024, 1598071496, 1209273420, 1356717446, 939053516,
            3163991687, 3849895312, 616587746,  4025537247, 3728956148, 3856880375, 1683403936,
            2415051407, 250368395,  1402352867, 3612870502, 741078784,  1189183669, 2879377481,
            3690388646, 474377751,
        },
        {
            3225674336, 827428943,  2858523441, 2447266124, 1539223637, 2299756421, 776912458,
            279091824,  1152725492, 3903457284, 3987010398, 3996115574, 839506039,  3052513014,
            28550291,   2597814974, 2328446377, 1961600298, 3695276714, 1334932648, 1141381380,
            3025370440, 997698792,  931473445,  3091440507, 820119215,  3586778616, 1993126242,
            4252838072, 3033829531, 2120026924, 65722921,   746724958,  461423533,  1582298542,
            1564918930, 3710935369, 419349792,  3914061713, 2279209938, 770031171,  2062767935,
            3373230309, 3582372364, 2025682996, 3352859025, 1262632952, 3140021482, 501370035,
            2554730117, 352450195,  1002557127, 2813224858, 2808406559, 290476252,  4216846311,
            1187381982, 3131323304, 1094330039, 2646234280, 655242013,  1152156402, 3658526705,
            3565043535, 693375321,  2120064836, 3726555752, 97387177,   546586686,  1013492636,
            3874404446, 440995849,  1929251266, 95137166,   564969023,  3559119399, 3855477390,
            2439885481, 2492213232, 2611214170, 2054191666, 2778642234, 2267416277, 2194315209,
            1360165075, 1018128176, 2841084399, 3028189871, 3631770575, 541021087,  1091467742,
            2743780329, 3566538467, 1277066122, 279582475,  2712119598, 3296319359, 4187226385,
            1468994750, 2946664285, 2284913307, 740953233,  3351500634, 1791054313, 3355533193,
            610062694,  3089981426, 3469441840, 3225672476, 2223653903, 2593994385, 548784340,
            549871569,  865468702,  1593939385, 645229999,  1412095765, 2814231763, 3619658094,
            877462820,  2198765077, 1845119421, 4144145546, 1356681209, 848707034,  4144513299,
            3231318896, 3382035479, 693621410,  2821661683, 4236142563, 680649431,  3290999942,
            200856634,  617766412,  3194332974, 4102392657, 2776797278, 2932808060, 793967937,
            2149374605, 3736514467, 3547689148, 3744888920, 98278184,   1497045279, 2945126332,
            4285864315, 2791068812, 1939995011, 56752862,   864909862,  625377571,  2266362085,
            1050287398, 925722519,  1008109592, 2819528345, 3573068613, 1915083884, 1536828870,
            3225674336, 827428943,  2858523441, 2447266124, 2186287936, 2299756421, 776912458,
            279091824,  1152725492, 1271286102, 3987010398, 3996115574, 839506039,  3052513014,
            1036957208, 2597814974, 2328446377, 1961600298, 3695276714, 2395157917, 1141381380,
            3025370440, 997698792,  931473445,  2727078785, 820119215,  3586778616, 1993126242,
            4252838072, 1171102868, 2120026924, 65722921,   746724958,  461423533,  2335086228,
            1564918930, 3710935369, 419349792,  3914061713, 1136716661, 770031171,  2062767935,
            3373230309, 3582372364, 4100328450, 3352859025, 1262632952, 3140021482, 501370035,
            2579000299, 352450195,  1002557127, 2813224858, 2808406559, 2642514897, 4216846311,
            1187381982, 3131323304, 1094330039, 3092488663, 655242013,  1152156402, 3658526705,
            3565043535, 3280658482, 2120064836, 3726555752, 97387177,   546586686,  584864345,
            3874404446, 440995849,  1929251266, 95137166,   823950215,  3559119399, 3855477390,
            2439885481, 2492213232, 2297040376, 2054191666, 2778642234, 2267416277, 2194315209,
            573807317,  1018128176, 2841084399, 3028189871, 3631770575, 2747338726, 1091467742,
            2743780329, 3566538467, 1277066122, 1715139924, 2712119598, 3296319359, 4187226385,
            1468994750, 3361368810, 2284913307, 740953233,  3351500634, 1791054313, 4290564545,
            610062694,  3089981426, 3469441840, 3225672476, 1010959310, 2593994385, 548784340,
            549871569,  865468702,  1825306744, 645229999,  1412095765, 2814231763, 3619658094,
            3792219969, 2198765077, 1845119421, 4144145546, 1356681209, 268197516,  4144513299,
            3231318896, 3382035479, 693621410,  2786831464, 4236142563, 680649431,  3290999942,
            200856634,  3822069622, 3194332974, 4102392657, 2776797278, 2932808060, 525501162,
            2149374605, 3736514467, 3547689148, 3744888920, 3219948462, 1497045279, 2945126332,
            4285864315, 2791068812, 2678467476, 56752862,   864909862,  625377571,  2266362085,
            2258093843, 925722519,  1008109592, 2819528345, 3573068613, 2743241289, 1536828870,
            3225674336, 827428943,  2858523441, 992128922,  2186287936, 2299756421, 776912458,
            279091824,  2108721702, 1271286102, 3987010398, 3996115574, 839506039,  1315622698,
            1036957208, 2597814974, 2328446377, 1961600298, 3098343478, 2395157917, 1141381380,
            3025370440, 997698792,  1317753106, 2727078785, 820119215,  3586778616, 1993126242,
            2295599934, 1171102868, 2120026924, 65722921,   746724958,  3999203443, 2335086228,
            1564918930, 3710935369, 419349792,  1662083910, 1136716661, 770031171,  2062767935,
            3373230309, 3271761171, 4100328450, 3352859025, 1262632952, 3140021482, 3981040854,
            2579000299, 352450195,  1002557127, 2813224858, 1064251076, 2642514897, 4216846311,
            1187381982, 3131323304, 2077640887, 3092488663, 655242013,  1152156402, 3658526705,
            548941006,  3280658482, 2120064836, 3726555752, 97387177,   4112878213, 584864345,
            3874404446, 440995849,  1929251266, 227230803,  823950215,  3559119399, 3855477390,
            2439885481, 610498128,  2297040376, 2054191666, 2778642234, 2267416277, 518192832,
            573807317,  1018128176, 2841084399, 3028189871, 2512871059, 2747338726, 1091467742,
            2743780329, 3566538467, 386661563,  1715139924, 2712119598, 3296319359, 4187226385,
            2508754324, 3361368810, 2284913307, 740953233,  3351500634, 1296305541, 4290564545,
            610062694,  3089981426, 3469441840, 148510865,  1010959310, 2593994385, 548784340,
            549871569,  124676809,  1825306744, 645229999,  1412095765, 2814231763, 2540745278,
            3792219969, 2198765077, 1845119421, 4144145546, 3966655401, 268197516,  4144513299,
            3231318896, 3382035479, 1674022032, 2786831464, 4236142563, 680649431,  3290999942,
            4065303704, 3822069622, 3194332974, 4102392657, 2776797278, 3735376922, 525501162,
            2149374605, 3736514467, 3547689148, 2064870756, 3219948462, 1497045279, 2945126332,
            4285864315, 2389978045, 2678467476, 56752862,   864909862,  625377571,  2308006661,
            2258093843, 925722519,  1008109592, 2819528345, 2927186231, 2743241289, 1536828870,
            3225674336, 827428943,  1583633720, 992128922,  2186287936, 2299756421, 776912458,
            298217241,  2108721702, 1271286102, 3987010398, 3996115574, 1041730366, 1315622698,
            1036957208, 2597814974, 2328446377, 1386688725, 3098343478, 2395157917, 1141381380,
            3025370440, 2292273773, 1317753106, 2727078785, 820119215,  3586778616, 206996196,
            2295599934, 1171102868, 2120026924, 65722921,   3271158508, 3999203443, 2335086228,
            1564918930, 3710935369, 3305544914, 1662083910, 1136716661, 770031171,  2062767935,
            4244195826, 3271761171, 4100328450, 3352859025, 1262632952, 3581040310, 3981040854,
            2579000299, 352450195,  1002557127, 1789606594, 1064251076, 2642514897, 4216846311,
            1187381982, 1519386238, 2077640887, 3092488663, 655242013,  1152156402, 3732146227,
            548941006,  3280658482, 2120064836, 3726555752, 2631398817, 4112878213, 584864345,
            3874404446, 440995849,  3541162446, 227230803,  823950215,  3559119399, 3855477390,
            560704260,  610498128,  2297040376, 2054191666, 2778642234, 1614756373, 518192832,
            573807317,  1018128176, 2841084399, 927011949,  2512871059, 2747338726, 1091467742,
            2743780329, 566198434,  386661563,  1715139924, 2712119598, 3296319359, 520529825,
            2508754324, 3361368810, 2284913307, 740953233,  2414584088, 1296305541, 4290564545,
            610062694,  3089981426, 120496553,  148510865,  1010959310, 2593994385, 548784340,
            3206664898, 124676809,  1825306744, 645229999,  1412095765, 821445348,  2540745278,
            3792219969, 2198765077, 1845119421, 3434574619, 3966655401, 268197516,  4144513299,
            3231318896, 3856935910, 1674022032, 2786831464, 4236142563, 680649431,  3331403374,
            4065303704, 3822069622, 3194332974, 4102392657, 2194924932, 3735376922, 525501162,
            2149374605, 3736514467, 2041458481, 2064870756, 3219948462, 1497045279, 2945126332,
            3515890044, 2389978045, 2678467476, 56752862,   864909862,  1009125580, 2308006661,
            2258093843, 925722519,  1008109592, 4166824654, 3399481064, 3848337172, 841675162,
            2388734555, 3373081217, 1627287001, 1958651480, 1771323855, 2126620758, 3879967947,
            1885140905, 806066092,  2168342987, 3778265278, 943582962,  3895768303, 337928214,
            3677576461, 1884088203, 2629440785, 2357038005, 2362450760, 2080907681, 2644383608,
            4153875040, 794977307,  2675637463, 2655426076, 3481699657, 2262369403, 1038608931,
            4210267953, 2376694315, 2661705117, 3994997027, 2994346963, 4074343171, 833108024,
            3562046155, 1113632369, 3087093963, 2115712884, 2778607581, 2702162487, 1347693590,
            4271098334, 2746712394, 1629623802, 1932973152, 3077074108, 1338011180, 848785806,
            1834095770, 4017238,    2661097500, 2935787683, 1214195119, 3099491937, 3868451396,
            1063740008, 2768962809, 2554721244, 695479209,  2634119800, 1379839034, 2653377927,
            921934002,  3586936843, 3035369677, 769283110,  2417935220, 3330084607, 2020519519,
            2546176786, 1523223165, 3654065096, 1835059231, 2776263618, 3837173427, 3236141295,
            1184415634, 157448610,  2474336972, 3313035876, 309195150,  2288837115, 548743307,
            528342914,  1527562212, 554918643,  2739291918, 2630873849, 155419923,  226845272,
            1343735931, 3106346884, 4177975386, 2515480406, 2049734808, 2802879609, 1805234272,
            317920918,  745796250,  3816657414, 4198378080, 3057334192, 503016924,  2027816790,
            579332504,  3037999504, 2857298788, 911046668,  1170775701, 2369720,    3364839261,
            1462383461, 181600856,  1315241696, 2861043792, 3549404088, 3974245218, 4141518566,
            1195336199, 2291064152, 3287203016, 3867432937, 2593766219, 2114273192, 3716228986,
            410286941,  2497285113, 1338500439, 3748757692, 2315519304, 545570554,  1519868916,
            679216320,  3264840479, 4083041163, 261878334,  2370312122, 1408058272, 1287635274,
            3433241543, 3923613754, 2423502603, 3948993135, 1418484161, 230113502,  1766447938,
            3101286974, 917358979,  2836128279, 2859079881, 3162688352, 2158281644, 154509481,
            2409785274, 3096379437,
        },
        {
            2888041130, 1353034452, 2942798213, 3916486735, 3387336862, 1131379911, 2782124695,
            382126707,  2798839032, 2588455531, 53484123,   250958426,  554265301,  938342282,
            3249579558, 1230200046, 219044150,  1206811440, 2520699496, 3338497003, 469001208,
            1725090953, 725882921,  2092705126, 4026597173, 2766308469, 3392658638, 3210572728,
            1397930386, 1287421366, 3252562575, 470430496,  1081113826, 3428596773, 3123085295,
            3446410360, 594027749,  1970878796, 3863022584, 2418441029, 2024461903, 4226819726,
            2776946690, 458074073,  3529629538, 802442802,  894203835,  2109076088, 1453788307,
            1781671220, 3603552602, 1540040139, 4239172677, 3935533151, 54124542,   2077986152,
            74026906,   3763852844, 881347976,  3502559543, 2372118790, 2457163414, 2276046810,
            2833881573, 3595693262, 3242324819, 3774678838, 3816438006, 3503523122, 2207971549,
            292897381,  1538860032, 3512907885, 1919198892, 3967664827, 3066954911, 1080572103,
            1642011849, 472307085,  2896106016, 1115969773, 3177856515, 361646166,  2162004550,
            1986201422, 172641320,  3040377316, 3925141670, 3944446421, 202475521,  1486184122,
            1503033001, 3322953142, 3084598965, 322764827,  542616602,  134346188,  1946999837,
            1387643748, 1074348428, 879701397,  1287820687, 4041088199, 3729263093, 2133521829,
            784655903,  1668043050, 455956355,  3852009296, 2128916374, 3788354248, 844857868,
            2790051375, 2455914684, 3490512105, 1316043389, 435629620,  3110855640, 1403177648,
            1052066553, 1783847709, 646243123,  3896801145, 1159613807, 3680192618, 1846059843,
            2478567677, 3347457383, 3312320589, 1524976784, 1404853302, 3882097492, 3403936532,
            843333778,  3743149857, 1089064350, 1147421180, 332832650,  2958703821, 3863512833,
            763620813,  862959118,  1139883751, 2291911605, 2400935973, 1663527584, 776019445,
            4006108402, 4077697850, 694012832,  1592109448, 1252300567, 1505336079, 1313211074,
            793069227,  1072693355, 2967103946, 1589325694, 173490859,  3307367485, 1899532262,
            2888041130, 1353034452, 2942798213, 3916486735, 4086298004, 1131379911, 2782124695,
            382126707,  2798839032, 2896899077, 53484123,   250958426,  554265301,  938342282,
            337460222,  1230200046, 219044150,  1206811440, 2520699496, 4256911380, 469001208,
            1725090953, 725882921,  2092705126, 3539745381, 2766308469, 3392658638, 3210572728,
            1397930386, 1913887032, 3252562575, 470430496,  1081113826, 3428596773, 3250440412,
            3446410360, 594027749,  1970878796, 3863022584, 599611060,  2024461903, 4226819726,
            2776946690, 458074073,  4057392654, 802442802,  894203835,  2109076088, 1453788307,
            4287681779, 3603552602, 1540040139, 4239172677, 3935533151, 3056952644, 2077986152,
            74026906,   3763852844, 881347976,  1075388043, 2372118790, 2457163414, 2276046810,
            2833881573, 4158212177, 3242324819, 3774678838, 3816438006, 3503523122, 3114743716,
            292897381,  1538860032, 3512907885, 1919198892, 665140188,  3066954911, 1080572103,
            1642011849, 472307085,  2346139872, 1115969773, 3177856515, 361646166,  2162004550,
            1025757285, 172641320,  3040377316, 3925141670, 3944446421, 2479072733, 1486184122,
            1503033001, 3322953142, 3084598965, 330515274,  542616602,  134346188,  1946999837,
            1387643748, 4232937130, 879701397,  1287820687, 4041088199, 3729263093, 2554407170,
            784655903,  1668043050, 455956355,  3852009296, 699221097,  3788354248, 844857868,
            2790051375, 2455914684, 1032578822, 1316043389, 435629620,  3110855640, 1403177648,
            1361723113, 1783847709, 646243123,  3896801145, 1159613807, 1406292790, 1846059843,
            2478567677, 3347457383, 3312320589, 1408531774, 1404853302, 3882097492, 3403936532,
            843333778,  4061511056, 1089064350, 1147421180, 332832650,  2958703821, 2926996223,
            763620813,  862959118,  1139883751, 2291911605, 2274557624, 1663527584, 776019445,
            4006108402, 4077697850, 2843641427, 1592109448, 1252300567, 1505336079, 1313211074,
            3784922749, 1072693355, 2967103946, 1589325694, 173490859,  3218147015, 1899532262,
            2888041130, 1353034452, 2942798213, 1559014516, 4086298004, 1131379911, 2782124695,
            382126707,  42811396,   2896899077, 53484123,   250958426,  554265301,  3072592650,
            337460222,  1230200046, 219044150,  1206811440, 1307342702, 4256911380, 469001208,
            1725090953, 725882921,  171563309,  3539745381, 2766308469, 3392658638, 3210572728,
            1632345371, 1913887032, 3252562575, 470430496,  1081113826, 1444861914, 3250440412,
            3446410360, 594027749,  1970878796, 1308850036, 599611060,  2024461903, 4226819726,
            2776946690, 1077343668, 4057392654, 802442802,  894203835,  2109076088, 2420347655,
            4287681779, 3603552602, 1540040139, 4239172677, 1496020400, 3056952644, 2077986152,
            74026906,   3763852844, 1012831342, 1075388043, 2372118790, 2457163414, 2276046810,
            3489141936, 4158212177, 3242324819, 3774678838, 3816438006, 1892720652, 3114743716,
            292897381,  1538860032, 3512907885, 3865052069, 665140188,  3066954911, 1080572103,
            1642011849, 1354605120, 2346139872, 1115969773, 3177856515, 361646166,  2743125822,
            1025757285, 172641320,  3040377316, 3925141670, 211787819,  2479072733, 1486184122,
            1503033001, 3322953142, 673515641,  330515274,  542616602,  134346188,  1946999837,
            417895373,  4232937130, 879701397,  1287820687, 4041088199, 4202715604, 2554407170,
            784655903,  1668043050, 455956355,  4085141460, 699221097,  3788354248, 844857868,
            2790051375, 4024168522, 1032578822, 1316043389, 435629620,  3110855640, 523915432,
            1361723113, 1783847709, 646243123,  3896801145, 3979668423, 1406292790, 1846059843,
            2478567677, 3347457383, 4059378429, 1408531774, 1404853302, 3882097492, 3403936532,
            2732957979, 4061511056, 1089064350, 1147421180, 332832650,  1125381144, 2926996223,
            763620813,  862959118,  1139883751, 2352209994, 2274557624, 1663527584, 776019445,
            4006108402, 2950160604, 2843641427, 1592109448, 1252300567, 1505336079, 1997040963,
            3784922749, 1072693355, 2967103946, 1589325694, 2405408089, 3218147015, 1899532262,
            2888041130, 1353034452, 1210026511, 1559014516, 4086298004, 1131379911, 2782124695,
            2581644676, 42811396,   2896899077, 53484123,   250958426,  1834408317, 3072592650,
            337460222,  1230200046, 219044150,  3575746581, 1307342702, 4256911380, 469001208,
            1725090953, 2549186242, 171563309,  3539745381, 2766308469, 3392658638, 1872818023,
            1632345371, 1913887032, 3252562575, 470430496,  717319097,  1444861914, 3250440412,
            3446410360, 594027749,  2162714671, 1308850036, 599611060,  2024461903, 4226819726,
            159925483,  1077343668, 4057392654, 802442802,  894203835,  195413384,  2420347655,
            4287681779, 3603552602, 1540040139, 2115718338, 1496020400, 3056952644, 2077986152,
            74026906,   3630214352, 1012831342, 1075388043, 2372118790, 2457163414, 90766037,
            3489141936, 4158212177, 3242324819, 3774678838, 363617507,  1892720652, 3114743716,
            292897381,  1538860032, 468312098,  3865052069, 665140188,  3066954911, 1080572103,
            580622294,  1354605120, 2346139872, 1115969773, 3177856515, 3371747533, 2743125822,
            1025757285, 172641320,  3040377316, 3458891601, 211787819,  2479072733, 1486184122,
            1503033001, 2308237657, 673515641,  330515274,  542616602,  134346188,  3938212128,
            417895373,  4232937130, 879701397,  1287820687, 932881747,  4202715604, 2554407170,
            784655903,  1668043050, 3209225086, 4085141460, 699221097,  3788354248, 844857868,
            287131770,  4024168522, 1032578822, 1316043389, 435629620,  2100789831, 523915432,
            1361723113, 1783847709, 646243123,  785189639,  3979668423, 1406292790, 1846059843,
            2478567677, 949684565,  4059378429, 1408531774, 1404853302, 3882097492, 205717314,
            2732957979, 4061511056, 1089064350, 1147421180, 4252781228, 1125381144, 2926996223,
            763620813,  862959118,  3591030001, 2352209994, 2274557624, 1663527584, 776019445,
            3110713930, 2950160604, 2843641427, 1592109448, 1252300567, 2164406287, 1997040963,
            3784922749, 1072693355, 2967103946, 1538203927, 2359596597, 3644200738, 3505105412,
            2875838311, 185240515,  599990192,  809946989,  420283034,  1972561945, 2933477716,
            889574851,  2526292885, 2202382577, 3213662424, 4035553754, 3144365715, 1208550480,
            2333326921, 3217645239, 1481910907, 3930294224, 2028286656, 3618006985, 838100818,
            1624645244, 1332313257, 3670292579, 804296260,  3869581394, 37503251,   2703015506,
            3111827297, 1073295986, 2039337177, 649348660,  1145453001, 3607593447, 2106178576,
            2758276786, 1731607998, 3746218622, 1391985949, 4255540067, 2874660998, 3092126743,
            2677317095, 667456578,  1840722531, 692155339,  3430944806, 2033030184, 4103085099,
            2276116516, 2197998921, 1211307076, 3311366132, 1798567211, 344082138,  339523342,
            949262319,  3283202071, 2363699402, 777743786,  3447814557, 777176347,  4167760913,
            3148431407, 1797394330, 465430077,  3188212102, 503192324,  2359951612, 3529628727,
            1795673386, 4084676466, 4148686703, 3380926133, 2070248636, 2850196613, 591760168,
            1930171571, 3802219499, 1857666353, 296753530,  3545285599, 2352720014, 659687396,
            2984123124, 896137217,  3059353185, 3783572468, 3882675055, 2819838840, 1499137161,
            534329407,  3634575999, 2504298965, 1682568358, 2394947429, 1926367309, 3239114008,
            131055162,  1032715430, 3671495557, 2543035292, 149514324,  2880425333, 2398990045,
            3408587916, 2582954692, 175632560,  3703315914, 2849835339, 1618196018, 1324280601,
            1707254739, 3804112441, 3399591897, 3415185868, 1501471861, 3728201967, 3322887222,
            3543417526, 1392522045, 2833280667, 1506213109, 3172158122, 1796449358, 123421799,
            751554826,  632660654,  1556893928, 677580209,  4126865331, 976289968,  1755805088,
            362047206,  1331627112, 1190215829, 4202626781, 117617777,  1141981289, 3932629654,
            3353659227, 3756759401, 165764504,  2245180882, 37765994,   1634150858, 837122801,
            2290925755, 660283495,  2384832052, 3502247868, 1590987346, 3755389533, 2833178398,
            1229424995, 1991739656,
        },
        {
            2456954827, 2895978734, 1621803157, 230462381,  4046364119, 716597790,  2031510641,
            2208319977, 1107910846, 3379950723, 3628284249, 1393263274, 3842378742, 768116962,
            1782906996, 3022943801, 510040722,  2180373447, 1294989632, 1659724107, 953774117,
            500296619,  2269873184, 3215368465, 3933601613, 2401810535, 3568992417, 617528376,
            2437412983, 2921242388, 2311040363, 3695847323, 1609309841, 3222455492, 1108155620,
            397599239,  3344183623, 1159383441, 81554651,   4223302962, 2812031899, 2613176831,
            2967803832, 3560382993, 670173062,  2361031672, 1745444335, 2067906079, 3019908371,
            2662226130, 2962440272, 3053411095, 92212044,   1041941495, 4116546365, 2094375399,
            3992554702, 216246182,  2271736480, 1006434362, 4104644208, 2543874803, 1310440964,
            1956002873, 1485192936, 3027546418, 448786402,  749040342,  406538664,  2522826782,
            3681979470, 3941253886, 672615054,  3655479714, 392178376,  1619518340, 1639889010,
            666186812,  4094569743, 2947917117, 3308938954, 1572886498, 1065510431, 2158389109,
            1583642689, 1763046973, 3578310229, 4106948216, 58659757,   691952777,  3394715763,
            3333944006, 3020203798, 3598064251, 3151881711, 2071056894, 1263790655, 4188233031,
            4230429856, 3088041549, 3031631424, 3912597408, 1768734847, 1975027092, 3976493733,
            2376551740, 1137628506, 535767974,  3105256806, 15427398,   2472341690, 685997424,
            1374644561, 2446214061, 2844847931, 1058649390, 1581230869, 1725846082, 3062699842,
            1116400547, 1095426642, 2940190462, 4276038488, 2091764667, 4074059985, 98163536,
            4157153745, 32476821,   2354284775, 752663757,  2987293678, 1119786914, 3019442904,
            111185876,  3569592548, 3991775183, 3161418733, 3973354577, 1650454973, 426129509,
            3659038742, 1387393667, 543731583,  781586523,  917315276,  832142534,  3911092159,
            325250500,  2735441676, 163564958,  1002098855, 337936437,  1869530240, 2233969733,
            4108076124, 3255026725, 4072134049, 2083771067, 1559589006, 1845121907, 466036013,
            2456954827, 2895978734, 1621803157, 230462381,  2022150409, 716597790,  2031510641,
            2208319977, 1107910846, 1838834877, 3628284249, 1393263274, 3842378742, 768116962,
            2303040715, 3022943801, 510040722,  2180373447, 1294989632, 3074858415, 953774117,
            500296619,  2269873184, 3215368465, 3531413908, 2401810535, 3568992417, 617528376,
            2437412983, 1730632320, 2311040363, 3695847323, 1609309841, 3222455492, 3189359980,
            397599239,  3344183623, 1159383441, 81554651,   1933731121, 2812031899, 2613176831,
            2967803832, 3560382993, 758113139,  2361031672, 1745444335, 2067906079, 3019908371,
            3537991495, 2962440272, 3053411095, 92212044,   1041941495, 2653519981, 2094375399,
            3992554702, 216246182,  2271736480, 695350220,  4104644208, 2543874803, 1310440964,
            1956002873, 3373048130, 3027546418, 448786402,  749040342,  406538664,  4081844472,
            3681979470, 3941253886, 672615054,  3655479714, 197563239,  1619518340, 1639889010,
            666186812,  4094569743, 2518320719, 3308938954, 1572886498, 1065510431, 2158389109,
            3320483696, 1763046973, 3578310229, 4106948216, 58659757,   3412172826, 3394715763,
            3333944006, 3020203798, 3598064251, 1693717788, 2071056894, 1263790655, 4188233031,
            4230429856, 2564478937, 3031631424, 3912597408, 1768734847, 1975027092, 3546175061,
            2376551740, 1137628506, 535767974,  3105256806, 450760279,  2472341690, 685997424,
            1374644561, 2446214061, 1873063065, 1058649390, 1581230869, 1725846082, 3062699842,
            813496775,  1095426642, 2940190462, 4276038488, 2091764667, 3857233976, 98163536,
            4157153745, 32476821,   2354284775, 3115605568, 2987293678, 1119786914, 3019442904,
            111185876,  996447434,  3991775183, 3161418733, 3973354577, 1650454973, 1089784804,
            3659038742, 1387393667, 543731583,  781586523,  2711412312, 832142534,  3911092159,
            325250500,  2735441676, 3563501139, 1002098855, 337936437,  1869530240, 2233969733,
            1156926454, 3255026725, 4072134049, 2083771067, 1559589006, 3832870112, 466036013,
            2456954827, 2895978734, 1621803157, 2340808859, 2022150409, 716597790,  2031510641,
            2208319977, 1823993818, 1838834877, 3628284249, 1393263274, 3842378742, 2489609764,
            2303040715, 3022943801, 510040722,  2180373447, 4204167795, 3074858415, 953774117,
            500296619,  2269873184, 2320314628, 3531413908, 2401810535, 3568992417, 617528376,
            712451843,  1730632320, 2311040363, 3695847323, 1609309841, 3224192365, 3189359980,
            397599239,  3344183623, 1159383441, 758272390,  1933731121, 2812031899, 2613176831,
            2967803832, 3986798661, 758113139,  2361031672, 1745444335, 2067906079, 3814344052,
            3537991495, 2962440272, 3053411095, 92212044,   817573506,  2653519981, 2094375399,
            3992554702, 216246182,  2456924809, 695350220,  4104644208, 2543874803, 1310440964,
            1151286621, 3373048130, 3027546418, 448786402,  749040342,  637572176,  4081844472,
            3681979470, 3941253886, 672615054,  3038758846, 197563239,  1619518340, 1639889010,
            666186812,  4254608071, 2518320719, 3308938954, 1572886498, 1065510431, 3100620860,
            3320483696, 1763046973, 3578310229, 4106948216, 403923766,  3412172826, 3394715763,
            3333944006, 3020203798, 1859724785, 1693717788, 2071056894, 1263790655, 4188233031,
            2908736862, 2564478937, 3031631424, 3912597408, 1768734847, 966714666,  3546175061,
            2376551740, 1137628506, 535767974,  1561255376, 450760279,  2472341690, 685997424,
            1374644561, 3122124160, 1873063065, 1058649390, 1581230869, 1725846082, 3791666219,
            813496775,  1095426642, 2940190462, 4276038488, 2802023399, 3857233976, 98163536,
            4157153745, 32476821,   1640659450, 3115605568, 2987293678, 1119786914, 3019442904,
            4278091706, 996447434,  3991775183, 3161418733, 3973354577, 3398421232, 1089784804,
            3659038742, 1387393667, 543731583,  1694361696, 2711412312, 832142534,  3911092159,
            325250500,  166035542,  3563501139, 1002098855, 337936437,  1869530240, 1306446339,
            1156926454, 3255026725, 4072134049, 2083771067, 61899937,   3832870112, 466036013,
            2456954827, 2895978734, 767569205,  2340808859, 2022150409, 716597790,  2031510641,
            1690074863, 1823993818, 1838834877, 3628284249, 1393263274, 546011580,  2489609764,
            2303040715, 3022943801, 510040722,  825252468,  4204167795, 3074858415, 953774117,
            500296619,  1952242515, 2320314628, 3531413908, 2401810535, 3568992417, 4254767597,
            712451843,  1730632320, 2311040363, 3695847323, 2393864919, 3224192365, 3189359980,
            397599239,  3344183623, 1759399025, 758272390,  1933731121, 2812031899, 2613176831,
            2809078783, 3986798661, 758113139,  2361031672, 1745444335, 1223235915, 3814344052,
            3537991495, 2962440272, 3053411095, 3711100000, 817573506,  2653519981, 2094375399,
            3992554702, 2987412942, 2456924809, 695350220,  4104644208, 2543874803, 2746231792,
            1151286621, 3373048130, 3027546418, 448786402,  801157439,  637572176,  4081844472,
            3681979470, 3941253886, 975875511,  3038758846, 197563239,  1619518340, 1639889010,
            3137491209, 4254608071, 2518320719, 3308938954, 1572886498, 631178204,  3100620860,
            3320483696, 1763046973, 3578310229, 3338308117, 403923766,  3412172826, 3394715763,
            3333944006, 37220448,   1859724785, 1693717788, 2071056894, 1263790655, 228419012,
            2908736862, 2564478937, 3031631424, 3912597408, 3862306448, 966714666,  3546175061,
            2376551740, 1137628506, 1114919961, 1561255376, 450760279,  2472341690, 685997424,
            2456661198, 3122124160, 1873063065, 1058649390, 1581230869, 2996925693, 3791666219,
            813496775,  1095426642, 2940190462, 1642720015, 2802023399, 3857233976, 98163536,
            4157153745, 1578965959, 1640659450, 3115605568, 2987293678, 1119786914, 1748408698,
            4278091706, 996447434,  3991775183, 3161418733, 4123935663, 3398421232, 1089784804,
            3659038742, 1387393667, 770706529,  1694361696, 2711412312, 832142534,  3911092159,
            335435644,  166035542,  3563501139, 1002098855, 337936437,  2961857543, 1306446339,
            1156926454, 3255026725, 4072134049, 1717290230, 1323146393, 2156340433, 2065716367,
            2597996276, 3402032152, 779574284,  2369501052, 2316224856, 2720986136, 3016786025,
            2916554213, 3476215746, 1132150235, 2619889920, 1279664685, 679206534,  4014394509,
            3624968312, 1480455625, 725015758,  707677352,  3764409715, 1938306480, 2171474419,
            3379664161, 684262379,  2142433069, 43407198,   1398850259, 2059135843, 240266749,
            3788738212, 118513026,  820245055,  1152812311, 1398373423, 3188977726, 872620936,
            2084649448, 807979538,  819501992,  615447916,  3393148006, 1765623964, 2514767257,
            3711360450, 2941886951, 3739102698, 4022385962, 2306039667, 3321267290, 2179238310,
            3192652502, 2118792870, 2571142127, 761776508,  873010906,  1609627751, 4260021041,
            1747852747, 960771906,  2647903291, 77475681,   1282566533, 4022186916, 2681128032,
            1554542462, 3181701944, 1168469070, 74236514,   2806532232, 3981048887, 1888842784,
            2888607878, 1763028723, 701886756,  4124077776, 3738147505, 4066663138, 3816449863,
            921061872,  2956972182, 3159072916, 3337110888, 3552795700, 2281281091, 671098116,
            1282750020, 1008618197, 2363767765, 1812013295, 1854965999, 131027176,  666394000,
            2062217824, 1763334218, 551118598,  1277961175, 3523893635, 1855881150, 2067903393,
            2590963277, 3214508854, 1604911832, 1906690475, 389417851,  2711591984, 427723436,
            1039703630, 639602991,  444779318,  2722002973, 3927985419, 1297446054, 298277450,
            656022205,  134304205,  3847728042, 3339100423, 407022043,  1282443442, 3173884578,
            1417906094, 2364502739, 2158353472, 2402775649, 1807696073, 2837535198, 705887737,
            2129202688, 3853676283, 1388329793, 875153687,  2367465660, 2763058233, 2500632304,
            2196920062, 491306883,  277753357,  3868415380, 324867643,  3654474955, 2569410351,
            1128175417, 1853572398, 1133201743, 662085935,  2263514999, 3077768113, 3309730620,
            3602394176, 3747458070, 188422725,  813812450,  1502276531, 3909138356, 2766044599,
            3760928321, 573108836,
        },
        {
            1025521803, 2205096773, 2920214935, 2239079821, 2193757914, 2084224554, 594350123,
            1382277014, 286231969,  132438959,  3858364680, 4145119751, 773552432,  2943944647,
            3123265387, 2271558794, 492699276,  188733186,  1289004506, 1017888335, 652582793,
            1669497236, 482854814,  279617572,  57186635,   837852649,  128069448,  3580235043,
            3361460973, 2040376018, 3782028466, 3463799904, 1594274949, 335382598,  3835509837,
            1489963514, 4148054457, 2665032895, 1127150239, 423400489,  1005409675, 3603308223,
            3356443889, 879988291,  853892079,  2704795371, 637872748,  1232034912, 1157447837,
            2924638413, 3909437134, 4131047912, 1323885709, 2493649853, 2352892762, 1236883699,
            3567188100, 1696776475, 2007275,    4084462390, 2970341075, 314099069,  3522064776,
            4197488607, 1377249763, 1714947514, 3582563647, 2364601734, 2069882393, 1438241143,
            686672555,  1331385338, 1500235915, 685016037,  2353930618, 716532418,  726127521,
            3556186461, 994291487,  1808143924, 604115689,  2448616648, 790929864,  3178743516,
            4045802701, 469769356,  3563453172, 2882439389, 3590404347, 1830830909, 2997078845,
            663656573,  1632126068, 1376319261, 1995617443, 3844288545, 4237261606, 144083366,
            7403018,    2620097772, 249743296,  2849339407, 4168292956, 3812975279, 1597888553,
            2194623423, 4162637804, 2384556213, 3297049953, 1594929339, 2476057207, 734229660,
            822328743,  2037540079, 2729768287, 1763736391, 3056199787, 2201261523, 8864505,
            3815140075, 3971667665, 2394996141, 3163403262, 3930351753, 1067347875, 550382982,
            151306730,  3474638975, 4170503837, 3977625193, 3767246240, 1213163880, 3631382238,
            2666920557, 2219204481, 126127795,  2793014977, 3739878745, 751208351,  924730452,
            2646622872, 313204048,  631033196,  3775697135, 3080420856, 63941404,   2487398560,
            680531634,  2550637534, 3984723977, 669090736,  998914179,  4024114201, 2268036735,
            115711756,  2778578704, 1270803478, 1511169590, 1575945390, 558616172,  1068949809,
            1025521803, 2205096773, 2920214935, 2239079821, 44519432,   2084224554, 594350123,
            1382277014, 286231969,  2177694864, 3858364680, 4145119751, 773552432,  2943944647,
            3127967043, 2271558794, 492699276,  188733186,  1289004506, 172669137,  652582793,
            1669497236, 482854814,  279617572,  373755438,  837852649,  128069448,  3580235043,
            3361460973, 1397125918, 3782028466, 3463799904, 1594274949, 335382598,  747201111,
            1489963514, 4148054457, 2665032895, 1127150239, 864344378,  1005409675, 3603308223,
            3356443889, 879988291,  2968357376, 2704795371, 637872748,  1232034912, 1157447837,
            1041295140, 3909437134, 4131047912, 1323885709, 2493649853, 2368827164, 1236883699,
            3567188100, 1696776475, 2007275,    3420651258, 2970341075, 314099069,  3522064776,
            4197488607, 1838353954, 1714947514, 3582563647, 2364601734, 2069882393, 3550974033,
            686672555,  1331385338, 1500235915, 685016037,  2202285323, 716532418,  726127521,
            3556186461, 994291487,  1837491289, 604115689,  2448616648, 790929864,  3178743516,
            2457004477, 469769356,  3563453172, 2882439389, 3590404347, 51822152,   2997078845,
            663656573,  1632126068, 1376319261, 2708051197, 3844288545, 4237261606, 144083366,
            7403018,    2899440407, 249743296,  2849339407, 4168292956, 3812975279, 1485966253,
            2194623423, 4162637804, 2384556213, 3297049953, 908785408,  2476057207, 734229660,
            822328743,  2037540079, 2270848103, 1763736391, 3056199787, 2201261523, 8864505,
            650458951,  3971667665, 2394996141, 3163403262, 3930351753, 2741187557, 550382982,
            151306730,  3474638975, 4170503837, 2407181295, 3767246240, 1213163880, 3631382238,
            2666920557, 2537583838, 126127795,  2793014977, 3739878745, 751208351,  4251855793,
            2646622872, 313204048,  631033196,  3775697135, 2406961550, 63941404,   2487398560,
            680531634,  2550637534, 1095080788, 669090736,  998914179,  4024114201, 2268036735,
            2996174872, 2778578704, 1270803478, 1511169590, 1575945390, 1376766328, 1068949809,
            1025521803, 2205096773, 2920214935, 3852915291, 44519432,   2084224554, 594350123,
            1382277014, 720405979,  2177694864, 3858364680, 4145119751, 773552432,  1128092810,
            3127967043, 2271558794, 492699276,  188733186,  1431919981, 172669137,  652582793,
            1669497236, 482854814,  4176916343, 373755438,  837852649,  128069448,  3580235043,
            3133154622, 1397125918, 3782028466, 3463799904, 1594274949, 360451946,  747201111,
            1489963514, 4148054457, 2665032895, 4020214296, 864344378,  1005409675, 3603308223,
            3356443889, 1840319350, 2968357376, 2704795371, 637872748,  1232034912, 372275071,
            1041295140, 3909437134, 4131047912, 1323885709, 390060458,  2368827164, 1236883699,
            3567188100, 1696776475, 3665157390, 3420651258, 2970341075, 314099069,  3522064776,
            3749721156, 1838353954, 1714947514, 3582563647, 2364601734, 1319873442, 3550974033,
            686672555,  1331385338, 1500235915, 1537822194, 2202285323, 716532418,  726127521,
            3556186461, 715189744,  1837491289, 604115689,  2448616648, 790929864,  1434613480,
            2457004477, 469769356,  3563453172, 2882439389, 3613726329, 51822152,   2997078845,
            663656573,  1632126068, 2852422575, 2708051197, 3844288545, 4237261606, 144083366,
            2737899841, 2899440407, 249743296,  2849339407, 4168292956, 2045466522, 1485966253,
            2194623423, 4162637804, 2384556213, 4116814047, 908785408,  2476057207, 734229660,
            822328743,  3216531858, 2270848103, 1763736391, 3056199787, 2201261523, 1852538020,
            650458951,  3971667665, 2394996141, 3163403262, 1474794482, 2741187557, 550382982,
            151306730,  3474638975, 2569701012, 2407181295, 3767246240, 1213163880, 3631382238,
            167440744,  2537583838, 126127795,  2793014977, 3739878745, 1862924542, 4251855793,
            2646622872, 313204048,  631033196,  3747311184, 2406961550, 63941404,   2487398560,
            680531634,  2779327421, 1095080788, 669090736,  998914179,  4024114201, 2098192245,
            2996174872, 2778578704, 1270803478, 1511169590, 3344540365, 1376766328, 1068949809,
            1025521803, 2205096773, 4257501385, 3852915291, 44519432,   2084224554, 594350123,
            3042467483, 720405979,  2177694864, 3858364680, 4145119751, 2562339784, 1128092810,
            3127967043, 2271558794, 492699276,  830102957,  1431919981, 172669137,  652582793,
            1669497236, 3038472267, 4176916343, 373755438,  837852649,  128069448,  3894021673,
            3133154622, 1397125918, 3782028466, 3463799904, 187835074,  360451946,  747201111,
            1489963514, 4148054457, 3947551010, 4020214296, 864344378,  1005409675, 3603308223,
            68381434,   1840319350, 2968357376, 2704795371, 637872748,  1586000425, 372275071,
            1041295140, 3909437134, 4131047912, 1180221294, 390060458,  2368827164, 1236883699,
            3567188100, 2251836803, 3665157390, 3420651258, 2970341075, 314099069,  3427588345,
            3749721156, 1838353954, 1714947514, 3582563647, 2167451737, 1319873442, 3550974033,
            686672555,  1331385338, 4210697775, 1537822194, 2202285323, 716532418,  726127521,
            3015311189, 715189744,  1837491289, 604115689,  2448616648, 3748682796, 1434613480,
            2457004477, 469769356,  3563453172, 293877907,  3613726329, 51822152,   2997078845,
            663656573,  273167231,  2852422575, 2708051197, 3844288545, 4237261606, 2626440491,
            2737899841, 2899440407, 249743296,  2849339407, 1109825849, 2045466522, 1485966253,
            2194623423, 4162637804, 2983959006, 4116814047, 908785408,  2476057207, 734229660,
            1040117151, 3216531858, 2270848103, 1763736391, 3056199787, 1566873089, 1852538020,
            650458951,  3971667665, 2394996141, 4054315331, 1474794482, 2741187557, 550382982,
            151306730,  3277927400, 2569701012, 2407181295, 3767246240, 1213163880, 3289742239,
            167440744,  2537583838, 126127795,  2793014977, 3321714362, 1862924542, 4251855793,
            2646622872, 313204048,  2330753703, 3747311184, 2406961550, 63941404,   2487398560,
            3815952504, 2779327421, 1095080788, 669090736,  998914179,  2016598271, 2098192245,
            2996174872, 2778578704, 1270803478, 1297425653, 756407878,  1999333194, 3692774188,
            3148003759, 3459923888, 2199597009, 4066296519, 1591301622, 1140431150, 3981914011,
            3514363975, 3813756774, 1497206361, 2668415633, 2569647833, 1366128864, 3378375980,
            1641457640, 442870293,  2803456126, 137457780,  2491860311, 1520026120, 3678681069,
            2967814312, 2497920845, 2921383737, 1629123314, 438915631,  2306310471, 416889594,
            1000357295, 600358336,  2111440784, 1358888433, 3675111750, 318486407,  4241895799,
            2057515629, 2656204199, 3387877454, 3293953934, 2805492332, 1151397351, 2434602926,
            3258275587, 3648895973, 1254341940, 5454910,    2041886100, 2579047019, 1261368177,
            3212809954, 4004232794, 2160139893, 3700062635, 3265586343, 3736734432, 2421074174,
            3170256075, 3794062808, 1357450456, 3631600128, 1451489693, 1463495255, 1996089232,
            592678097,  3953616865, 4242022211, 3196446166, 3299321445, 3393290935, 3100733046,
            3035333979, 437508272,  152126630,  2435809627, 122551021,  828874076,  3639264400,
            1756896270, 1132339234, 1073603918, 3470467750, 3985511742, 2318032645, 2775049490,
            1900510488, 3742777417, 4212323306, 1078824816, 2704768144, 618078598,  2995692463,
            3925391929, 3281487887, 354832061,  480185715,  411530693,  65742795,   23515612,
            285614389,  3575960833, 1328568436, 3100907031, 2060438783, 1179808183, 2991661533,
            1580682999, 2866496521, 908060057,  2264327006, 620382484,  1092514749, 975634761,
            2092254493, 2832258867, 3778758807, 7576239,    2650913596, 3008493992, 1760757539,
            2499168949, 1608699140, 2151498705, 1165421266, 2895207367, 1856578709, 2689274922,
            757020750,  1166581272, 2485542218, 4134639838, 3130191953, 2070718923, 1809707964,
            3467770819, 2288560511, 3974300086, 1882510485, 3049882159, 3670047441, 665735520,
            3127776248, 887904320,  3187679975, 1633373367, 3995868473, 3991123493, 2885064126,
            1216628166, 3979177595, 2892559663, 2341041823, 3567526376, 2895575319, 3516474978,
            1661937274, 3331496298,
        },
        {
            1240264181, 1624064648, 3039823158, 2013985253, 1473300299, 2762062141, 3273470484,
            1889745445, 2516996174, 3190376531, 996186898,  3893981177, 1268272590, 3226095713,
            153038465,  2184871198, 3224094011, 2526518401, 1738960059, 1187560605, 4194384320,
            2837011297, 3638232350, 367907454,  574009898,  1948901330, 60430044,   1569835584,
            3160561697, 321792583,  3179087993, 1936928378, 412346905,  4020812489, 2603392174,
            3499496781, 1499441233, 1062415256, 1347130973, 1823246794, 3411391800, 4253618056,
            1507733072, 1605629518, 1503312494, 8035741,    4038904206, 2408545792, 969543501,
            954847087,  956553276,  3096241999, 2566194741, 84678421,   3882676079, 2483934330,
            3673546814, 2461422466, 620385599,  898325340,  2145883445, 3653728520, 3744850294,
            2441124935, 904854507,  3216304963, 2373268568, 2354362010, 1245572787, 2894748714,
            2889136188, 3716879184, 1766013949, 1305712667, 1227530310, 4051221847, 925440190,
            1508686692, 1104647879, 1496666754, 3300504219, 127787091,  1528394637, 1739640835,
            2475711496, 3792639955, 1450796299, 1634217367, 3289785095, 2149949989, 811612039,
            1750779366, 1157474938, 514004414,  2264909096, 3730411668, 3308882513, 1834571716,
            378288317,  3800023701, 763396788,  1597708317, 983953861,  94566098,   1548157668,
            3755427117, 1646496505, 3748241449, 3439805936, 2321644449, 3805706235, 4220083901,
            1069923823, 2984004391, 3824885361, 1967477766, 218978249,  348955028,  3188651823,
            1008338679, 2331688720, 1562995454, 1837179689, 3033872688, 3007293665, 1759522678,
            319754369,  2763991927, 1983149629, 1353197132, 1489552694, 2990539062, 3244609108,
            669775440,  886127995,  1636688014, 1251222487, 2351883247, 3261502906, 3139614137,
            3203790139, 2777648095, 3693390579, 3540514982, 3200191735, 750726325,  1014534145,
            2091792357, 3931704474, 1383925867, 2038878506, 2247134268, 2840132188, 61137652,
            1162051299, 399657268,  1682018695, 2640231287, 1733438115, 3611823506, 2077891037,
            1240264181, 1624064648, 3039823158, 2013985253, 4188888201, 2762062141, 3273470484,
            1889745445, 2516996174, 2621448256, 996186898,  3893981177, 1268272590, 3226095713,
            952803645,  2184871198, 3224094011, 2526518401, 1738960059, 738368399,  4194384320,
            2837011297, 3638232350, 367907454,  3772812520, 1948901330, 60430044,   1569835584,
            3160561697, 1655622513, 3179087993, 1936928378, 412346905,  4020812489, 3754224996,
            3499496781, 1499441233, 1062415256, 1347130973, 1167581269, 3411391800, 4253618056,
            1507733072, 1605629518, 1867781671, 8035741,    4038904206, 2408545792, 969543501,
            3189323143, 956553276,  3096241999, 2566194741, 84678421,   996778900,  2483934330,
            3673546814, 2461422466, 620385599,  3129088144, 2145883445, 3653728520, 3744850294,
            2441124935, 4230756652, 3216304963, 2373268568, 2354362010, 1245572787, 1600525238,
            2889136188, 3716879184, 1766013949, 1305712667, 59908073,   4051221847, 925440190,
            1508686692, 1104647879, 2931214731, 3300504219, 127787091,  1528394637, 1739640835,
            62963469,   3792639955, 1450796299, 1634217367, 3289785095, 667987389,  811612039,
            1750779366, 1157474938, 514004414,  2737193098, 3730411668, 3308882513, 1834571716,
            378288317,  3452657469, 763396788,  1597708317, 983953861,  94566098,   2752347916,
            3755427117, 1646496505, 3748241449, 3439805936, 4222757079, 3805706235, 4220083901,
            1069923823, 2984004391, 3887639520, 1967477766, 218978249,  348955028,  3188651823,
            4168456281, 2331688720, 1562995454, 1837179689, 3033872688, 814903833,  1759522678,
            319754369,  2763991927, 1983149629, 3818528075, 1489552694, 2990539062, 3244609108,
            669775440,  1004789460, 1636688014, 1251222487, 2351883247, 3261502906, 4143823654,
            3203790139, 2777648095, 3693390579, 3540514982, 153421222,  750726325,  1014534145,
            2091792357, 3931704474, 4018591985, 2038878506, 2247134268, 2840132188, 61137652,
            1455028838, 399657268,  1682018695, 2640231287, 1733438115, 1853142849, 2077891037,
            1240264181, 1624064648, 3039823158, 2235369076, 4188888201, 2762062141, 3273470484,
            1889745445, 3627876603, 2621448256, 996186898,  3893981177, 1268272590, 2687846008,
            952803645,  2184871198, 3224094011, 2526518401, 861379413,  738368399,  4194384320,
            2837011297, 3638232350, 3753321702, 3772812520, 1948901330, 60430044,   1569835584,
            581506474,  1655622513, 3179087993, 1936928378, 412346905,  2710043900, 3754224996,
            3499496781, 1499441233, 1062415256, 2704745463, 1167581269, 3411391800, 4253618056,
            1507733072, 4215403465, 1867781671, 8035741,    4038904206, 2408545792, 3252742933,
            3189323143, 956553276,  3096241999, 2566194741, 1865159158, 996778900,  2483934330,
            3673546814, 2461422466, 3123557619, 3129088144, 2145883445, 3653728520, 3744850294,
            21840044,   4230756652, 3216304963, 2373268568, 2354362010, 1934462999, 1600525238,
            2889136188, 3716879184, 1766013949, 2822794708, 59908073,   4051221847, 925440190,
            1508686692, 2938291976, 2931214731, 3300504219, 127787091,  1528394637, 1914923136,
            62963469,   3792639955, 1450796299, 1634217367, 257322213,  667987389,  811612039,
            1750779366, 1157474938, 3083649350, 2737193098, 3730411668, 3308882513, 1834571716,
            2778729422, 3452657469, 763396788,  1597708317, 983953861,  1337754195, 2752347916,
            3755427117, 1646496505, 3748241449, 3942745717, 4222757079, 3805706235, 4220083901,
            1069923823, 1314928500, 3887639520, 1967477766, 218978249,  348955028,  3425797638,
            4168456281, 2331688720, 1562995454, 1837179689, 1814071277, 814903833,  1759522678,
            319754369,  2763991927, 1079270448, 3818528075, 1489552694, 2990539062, 3244609108,
            2944573315, 1004789460, 1636688014, 1251222487, 2351883247, 1356892540, 4143823654,
            3203790139, 2777648095, 3693390579, 983917956,  153421222,  750726325,  1014534145,
            2091792357, 296882400,  4018591985, 2038878506, 2247134268, 2840132188, 3508266160,
            1455028838, 399657268,  1682018695, 2640231287, 2480988791, 1853142849, 2077891037,
            1240264181, 1624064648, 1741738969, 2235369076, 4188888201, 2762062141, 3273470484,
            3569498651, 3627876603, 2621448256, 996186898,  3893981177, 4026533880, 2687846008,
            952803645,  2184871198, 3224094011, 1290870737, 861379413,  738368399,  4194384320,
            2837011297, 3833099205, 3753321702, 3772812520, 1948901330, 60430044,   4131290878,
            581506474,  1655622513, 3179087993, 1936928378, 2379952582, 2710043900, 3754224996,
            3499496781, 1499441233, 593780490,  2704745463, 1167581269, 3411391800, 4253618056,
            621889762,  4215403465, 1867781671, 8035741,    4038904206, 2045289976, 3252742933,
            3189323143, 956553276,  3096241999, 2188329018, 1865159158, 996778900,  2483934330,
            3673546814, 2717648418, 3123557619, 3129088144, 2145883445, 3653728520, 1528077261,
            21840044,   4230756652, 3216304963, 2373268568, 803158556,  1934462999, 1600525238,
            2889136188, 3716879184, 161827512,  2822794708, 59908073,   4051221847, 925440190,
            3599942370, 2938291976, 2931214731, 3300504219, 127787091,  4082579845, 1914923136,
            62963469,   3792639955, 1450796299, 2035446714, 257322213,  667987389,  811612039,
            1750779366, 2344204796, 3083649350, 2737193098, 3730411668, 3308882513, 2765191583,
            2778729422, 3452657469, 763396788,  1597708317, 1854746879, 1337754195, 2752347916,
            3755427117, 1646496505, 4020292301, 3942745717, 4222757079, 3805706235, 4220083901,
            1408262601, 1314928500, 3887639520, 1967477766, 218978249,  2173193841, 3425797638,
            4168456281, 2331688720, 1562995454, 2835294077, 1814071277, 814903833,  1759522678,
            319754369,  4048528178, 1079270448, 3818528075, 1489552694, 2990539062, 787253600,
            2944573315, 1004789460, 1636688014, 1251222487, 3584515216, 1356892540, 4143823654,
            3203790139, 2777648095, 1681621541, 983917956,  153421222,  750726325,  1014534145,
            3951869055, 296882400,  4018591985, 2038878506, 2247134268, 1990726826, 3508266160,
            1455028838, 399657268,  1682018695, 3360119279, 3151120565, 3011208718, 3694535943,
            104562665,  2827623271, 249712003,  3413221355, 2347164236, 3227498378, 1805068659,
            2118219686, 1568133029, 902801951,  175637375,  3812819970, 2162769758, 3845613089,
            1795179477, 171494391,  3765826349, 1725798906, 345463508,  2481043227, 226569380,
            3250095421, 1085199388, 3107594542, 4011388155, 1092611190, 3239339214, 4211849464,
            4109911546, 81212018,   3691937144, 2477407396, 3320520455, 3070067913, 3808621884,
            252917069,  3394860294, 1092442235, 2876536384, 1684120191, 431096075,  1701716708,
            639881684,  3066183997, 3660504927, 2047274,    3424756424, 760932520,  2457976057,
            1705265011, 2691137533, 3684307557, 3532744498, 2319162513, 1015534908, 1907173398,
            2820698743, 1264455116, 2323788906, 3062240844, 1878550513, 1717353426, 1805673248,
            62425157,   3662381032, 1964107209, 2559831960, 2117844804, 1228721677, 4240498866,
            3212920337, 2338600301, 931588693,  2379606585, 3643222352, 4154645082, 1115847065,
            2079427925, 2256943798, 2795103368, 2688136486, 1458062143, 1767222217, 635424385,
            284062050,  1547163554, 3380046528, 1145758046, 3935976713, 4017430175, 3863367362,
            3041367424, 303263160,  1465965696, 3757919837, 3083072836, 4024514094, 1381331179,
            2393446325, 3256476469, 4066482738, 3437941107, 1051266504, 921764078,  2933305619,
            1358097211, 4100978724, 2709958834, 574590507,  961767386,  21100886,   753746372,
            4072632446, 733729367,  3060214669, 289165105,  426065754,  2036100240, 2172365757,
            502856627,  84490194,   2630806596, 1206161269, 1009438449, 569581317,  1836947000,
            3125379675, 1756936428, 3772694822, 3670337911, 3020603818, 2376224883, 2539951453,
            2053395002, 3525193914, 1991480838, 3786481083, 873873707,  1693894743, 2450223985,
            754878026,  1943356492, 401524329,  759931885,  611231307,  147950334,  599693701,
            3358729722, 3649058074, 906423787,  1333804225, 875187278,  1115838692, 2476325972,
            3307226674, 3539078918,
        },
        {
            2070193886, 4155224981, 565453968,  3612893025, 1400378275, 2349139103, 2304816808,
            1534918942, 2981906463, 4206467763, 3480572340, 1958782639, 2180222959, 3214819058,
            189886961,  1043510144, 78673846,   469605584,  2040457682, 486352693,  2091759118,
            3546311147, 3911397659, 1596981555, 906980248,  3619987783, 440998058,  1166943647,
            1190657754, 4288777557, 1516941271, 4137234563, 137644019,  3092587131, 3066646798,
            3771321266, 1666458009, 3412793280, 1141717862, 2633957973, 2623466764, 828030756,
            3508335439, 3759891819, 2656247914, 54404416,   2235905374, 2781469665, 1740674456,
            326583668,  2476767631, 2009580725, 1493295926, 891631160,  2823778218, 3105018041,
            1736873602, 2847119432, 1625372499, 1472579228, 2491622075, 1308181277, 2377147151,
            2607209568, 220876888,  3846505669, 389078792,  803432389,  2715484630, 3748649217,
            515206347,  130669642,  1626205892, 4227274360, 3908842478, 2925446333, 2887575760,
            2361685786, 1780212086, 2024368820, 2757706868, 2147078661, 455964950,  710030112,
            1530246391, 1600392129, 3002854150, 1665917336, 3915898453, 1151386624, 20349210,
            476962192,  2598680211, 698292919,  1707534563, 503530311,  4066450919, 473094127,
            1799132877, 4114406705, 2970287708, 3338157440, 2590277079, 4257948330, 1867650824,
            3261902411, 2278947140, 2377690828, 33519631,   3348648257, 3051176677, 3487786494,
            372361336,  1117643884, 3152896060, 3464914131, 3734832559, 3772614026, 829626029,
            2282901610, 1970019301, 210658279,  3122727906, 3161303597, 1051336855, 2491904976,
            3188487185, 1338616924, 664945329,  3055930318, 3895307179, 2850807804, 3151157576,
            3005618033, 521487109,  2075365892, 3022164205, 3677982876, 4108305145, 1242993425,
            3727199730, 349705713,  1489743465, 3684812066, 3360383063, 238042337,  726975713,
            2649985704, 865594562,  2012736193, 101981857,  1139086786, 43355547,   879508658,
            4115276297, 2317198393, 486518052,  1562936605, 2739143360, 3619253522, 1085323352,
            2070193886, 4155224981, 565453968,  3612893025, 4083586106, 2349139103, 2304816808,
            1534918942, 2981906463, 917903745,  3480572340, 1958782639, 2180222959, 3214819058,
            2314885275, 1043510144, 78673846,   469605584,  2040457682, 1833181345, 2091759118,
            3546311147, 3911397659, 1596981555, 1529638523, 3619987783, 440998058,  1166943647,
            1190657754, 1627713622, 1516941271, 4137234563, 137644019,  3092587131, 1825962945,
            3771321266, 1666458009, 3412793280, 1141717862, 4008602508, 2623466764, 828030756,
            3508335439, 3759891819, 101841274,  54404416,   2235905374, 2781469665, 1740674456,
            1363589133, 2476767631, 2009580725, 1493295926, 891631160,  3743704337, 3105018041,
            1736873602, 2847119432, 1625372499, 3578541279, 2491622075, 1308181277, 2377147151,
            2607209568, 3878704859, 3846505669, 389078792,  803432389,  2715484630, 2055930263,
            515206347,  130669642,  1626205892, 4227274360, 1919114418, 2925446333, 2887575760,
            2361685786, 1780212086, 2522224369, 2757706868, 2147078661, 455964950,  710030112,
            303230633,  1600392129, 3002854150, 1665917336, 3915898453, 1512031920, 20349210,
            476962192,  2598680211, 698292919,  3500091600, 503530311,  4066450919, 473094127,
            1799132877, 937516440,  2970287708, 3338157440, 2590277079, 4257948330, 2476026999,
            3261902411, 2278947140, 2377690828, 33519631,   2502832832, 3051176677, 3487786494,
            372361336,  1117643884, 2064437262, 3464914131, 3734832559, 3772614026, 829626029,
            805915271,  1970019301, 210658279,  3122727906, 3161303597, 2270029777, 2491904976,
            3188487185, 1338616924, 664945329,  1851267301, 3895307179, 2850807804, 3151157576,
            3005618033, 1094966645, 2075365892, 3022164205, 3677982876, 4108305145, 3051057513,
            3727199730, 349705713,  1489743465, 3684812066, 4013646209, 238042337,  726975713,
            2649985704, 865594562,  2827199988, 101981857,  1139086786, 43355547,   879508658,
            860203943,  2317198393, 486518052,  1562936605, 2739143360, 2246229542, 1085323352,
            2070193886, 4155224981, 565453968,  980049843,  4083586106, 2349139103, 2304816808,
            1534918942, 3584405219, 917903745,  3480572340, 1958782639, 2180222959, 1551153560,
            2314885275, 1043510144, 78673846,   469605584,  447949322,  1833181345, 2091759118,
            3546311147, 3911397659, 4100849174, 1529638523, 3619987783, 440998058,  1166943647,
            337276192,  1627713622, 1516941271, 4137234563, 137644019,  329531266,  1825962945,
            3771321266, 1666458009, 3412793280, 3573946458, 4008602508, 2623466764, 828030756,
            3508335439, 1846525907, 101841274,  54404416,   2235905374, 2781469665, 1162326455,
            1363589133, 2476767631, 2009580725, 1493295926, 4068945396, 3743704337, 3105018041,
            1736873602, 2847119432, 2623142801, 3578541279, 2491622075, 1308181277, 2377147151,
            643998123,  3878704859, 3846505669, 389078792,  803432389,  2781868101, 2055930263,
            515206347,  130669642,  1626205892, 504030288,  1919114418, 2925446333, 2887575760,
            2361685786, 1732965437, 2522224369, 2757706868, 2147078661, 455964950,  2006243273,
            303230633,  1600392129, 3002854150, 1665917336, 155211429,  1512031920, 20349210,
            476962192,  2598680211, 3168014605, 3500091600, 503530311,  4066450919, 473094127,
            1439913161, 937516440,  2970287708, 3338157440, 2590277079, 1036601342, 2476026999,
            3261902411, 2278947140, 2377690828, 390101157,  2502832832, 3051176677, 3487786494,
            372361336,  2418319054, 2064437262, 3464914131, 3734832559, 3772614026, 2956632622,
            805915271,  1970019301, 210658279,  3122727906, 1775848419, 2270029777, 2491904976,
            3188487185, 1338616924, 3160345414, 1851267301, 3895307179, 2850807804, 3151157576,
            1876795689, 1094966645, 2075365892, 3022164205, 3677982876, 3365222132, 3051057513,
            3727199730, 349705713,  1489743465, 3931913351, 4013646209, 238042337,  726975713,
            2649985704, 3296665491, 2827199988, 101981857,  1139086786, 43355547,   3494880457,
            860203943,  2317198393, 486518052,  1562936605, 2060852585, 2246229542, 1085323352,
            2070193886, 4155224981, 4240635581, 980049843,  4083586106, 2349139103, 2304816808,
            3108411583, 3584405219, 917903745,  3480572340, 1958782639, 1022913192, 1551153560,
            2314885275, 1043510144, 78673846,   90558037,   447949322,  1833181345, 2091759118,
            3546311147, 2344803222, 4100849174, 1529638523, 3619987783, 440998058,  1759344384,
            337276192,  1627713622, 1516941271, 4137234563, 1863373062, 329531266,  1825962945,
            3771321266, 1666458009, 1136057675, 3573946458, 4008602508, 2623466764, 828030756,
            3921966139, 1846525907, 101841274,  54404416,   2235905374, 4074654145, 1162326455,
            1363589133, 2476767631, 2009580725, 1906514808, 4068945396, 3743704337, 3105018041,
            1736873602, 143704216,  2623142801, 3578541279, 2491622075, 1308181277, 878534710,
            643998123,  3878704859, 3846505669, 389078792,  3343312925, 2781868101, 2055930263,
            515206347,  130669642,  2160240557, 504030288,  1919114418, 2925446333, 2887575760,
            2707467691, 1732965437, 2522224369, 2757706868, 2147078661, 1153987720, 2006243273,
            303230633,  1600392129, 3002854150, 856657236,  155211429,  1512031920, 20349210,
            476962192,  2681035402, 3168014605, 3500091600, 503530311,  4066450919, 3636751601,
            1439913161, 937516440,  2970287708, 3338157440, 605329567,  1036601342, 2476026999,
            3261902411, 2278947140, 3615264125, 390101157,  2502832832, 3051176677, 3487786494,
            1536494441, 2418319054, 2064437262, 3464914131, 3734832559, 580849219,  2956632622,
            805915271,  1970019301, 210658279,  201455011,  1775848419, 2270029777, 2491904976,
            3188487185, 2946165797, 3160345414, 1851267301, 3895307179, 2850807804, 3503817907,
            1876795689, 1094966645, 2075365892, 3022164205, 10989664,   3365222132, 3051057513,
            3727199730, 349705713,  18784313,   3931913351, 4013646209, 238042337,  726975713,
            4004751801, 3296665491, 2827199988, 101981857,  1139086786, 2927239609, 3494880457,
            860203943,  2317198393, 486518052,  3817402751, 178703472,  535604505,  2259709816,
            1825107994, 337855210,  722659552,  3367301752, 3586686171, 2801223730, 2638476354,
            1886382590, 2030615143, 795993704,  115062649,  505995640,  3492299393, 298769396,
            2002289722, 2002415579, 2482511974, 2426986319, 3656153657, 2434546108, 1453057365,
            3287506103, 3654042923, 3994688153, 4282003574, 3580396408, 1416267011, 3703766394,
            1624196494, 3873374373, 3612265161, 4076390737, 2643599597, 4016834389, 1043355745,
            1542578540, 104149372,  1408733052, 632578852,  3140119271, 1674855482, 2449326602,
            3283853732, 1242317972, 4254470729, 1506915204, 3765768057, 2820134356, 3876894077,
            1811637691, 1105588438, 8009914,    1633294394, 3179914485, 2231923391, 2390833750,
            376726347,  2739270658, 1886413391, 1151386577, 81165281,   3145865109, 3887618787,
            2978721703, 2809758861, 3336166022, 3132920684, 172282142,  3718867147, 3116297442,
            18881596,   277036024,  777294139,  3886396251, 2996541520, 2402871390, 3181467601,
            1332506076, 3785135425, 3572865675, 883257766,  1751592256, 1884378351, 4056055281,
            2229623502, 3305816568, 2008984175, 1914849680, 513574334,  2787875861, 2851915603,
            3189050734, 3623601712, 660436921,  2482877619, 1651929658, 1403885478, 3384413344,
            2738821435, 1141878617, 2197147146, 1560153383, 4127719127, 1731578262, 512463095,
            1960107702, 915631787,  1711184523, 3802717979, 249682524,  1028827580, 4129526228,
            1282580612, 1681910746, 4018701774, 1740041240, 1121187831, 1062617426, 3503418362,
            2012258063, 544197617,  2397924207, 2902159551, 3928716566, 2821971978, 383418518,
            2215737693, 2417376565, 2036807559, 2255368453, 1469129021, 3787733561, 3093943696,
            4038835738, 1186467077, 4178467532, 1595586790, 1606224006, 2535997042, 586370843,
            4242260713, 773320307,  789139018,  3310711501, 711856972,  610152365,  3147671629,
            1429078516, 2438012519, 970111891,  1069983026, 2306206490, 655346339,  4148194922,
            3288712653, 1310220788,
        },
};

#endif // GUARD_PRECALC_XORWOW_SKIPAHEAD_MATRICES_KERNEL_H
