/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File Extent.h
// Baudouin Raoult - ECMWF Oct 98

#ifndef Extent_H
#define Extent_H


// Headers
// #ifndef   machine_H
// #include <machine.h>
// #endif

// Forward declarations

// class ostream;
// typedef class _Pvts os_typespec; // Remove if not persistant

// 

template<class T>
class Extent {
public:

// -- Exceptions
	// None

// -- Contructors

	Extent();

// -- Destructor

	virtual ~Extent(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods

	static void delete_all();

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

//protected:

// -- Members
	// None

	Extent<T>* next_;
	Extent<T>* prev_;

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

	static Extent<T>* first_;
	static Extent<T>* last_;

	static T* first() { return (T*)first_; }
	T* next()         { return (T*)next_; }


// -- Class methods
	// None

//private:

// No copy allowed

// -- Members
	
	// None

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const Extent& p)
	//	{ p.print(s); return s; }

};

template<class T> Extent<T>* Extent<T>::first_ = 0;
template<class T> Extent<T>* Extent<T>::last_  = 0;

template<class T>
Extent<T>::Extent():
	next_(0),
	prev_(last_)
{
	if(last_) 
		last_->next_ = this;
	else 
		first_ = this;
	last_ = this;
}

template<class T>
Extent<T>::~Extent()
{
	if(prev_) prev_->next_ = next_; else first_ = next_;
	if(next_) next_->prev_ = prev_; else last_  = prev_;
}


template<class T>
void Extent<T>::delete_all()
{
	while(first_) delete first_;
}

#endif
