# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.exporter import Exporter


class JSONRenderWindowExporter(Exporter):
    r"""
    JSONRenderWindowExporter - Exports a render window for vtk-js
    
    Superclass: Exporter
    
    JSONRenderWindowExporter constructs a scene graph from an input
    render window and generates an archive for vtk-js. The traversal of
    the scene graph topology is handled by graph elements constructed by
    VtkJSViewNodeFactory, the translation from VTK to vtk-js scene
    elements (renderers, actors, mappers, etc.) is handled by
    VtkJSSceneGraphSerializer, and the transcription of data is
    handled by Archiver. The latter two classes are designed to be
    extensible via inheritance, and derived instances can be used to
    modify the vtk-js file format and output mode.
    
    @sa
    VtkJSSceneGraphSerializer VtkJSViewNodeFactory
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkJSONRenderWindowExporter, obj, update, **traits)
    
    compact_output = tvtk_base.true_bool_trait(desc=\
        r"""
        Write scene in compact form (default is true).
        """
    )

    def _compact_output_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCompactOutput,
                        self.compact_output_)

    def _get_archiver(self):
        return wrap_vtk(self._vtk_obj.GetArchiver())
    def _set_archiver(self, arg):
        old_val = self._get_archiver()
        self._wrap_call(self._vtk_obj.SetArchiver,
                        deref_vtk(arg))
        self.trait_property_changed('archiver', old_val, arg)
    archiver = traits.Property(_get_archiver, _set_archiver, desc=\
        r"""
        
        """
    )

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    def _set_input(self, arg):
        old_val = self._get_input()
        self._wrap_call(self._vtk_obj.SetInput,
                        deref_vtk(arg))
        self.trait_property_changed('input', old_val, arg)
    input = traits.Property(_get_input, _set_input, desc=\
        r"""
        
        """
    )

    def _get_serializer(self):
        return wrap_vtk(self._vtk_obj.GetSerializer())
    def _set_serializer(self, arg):
        old_val = self._get_serializer()
        self._wrap_call(self._vtk_obj.SetSerializer,
                        deref_vtk(arg))
        self.trait_property_changed('serializer', old_val, arg)
    serializer = traits.Property(_get_serializer, _set_serializer, desc=\
        r"""
        
        """
    )

    def write_data(self):
        """
        write_data(self) -> None
        
        Write scene data.
        """
        ret = self._vtk_obj.WriteData()
        return ret
        

    _updateable_traits_ = \
    (('compact_output', 'GetCompactOutput'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['compact_output', 'debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(JSONRenderWindowExporter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit JSONRenderWindowExporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compact_output'], [], ['object_name']),
            title='Edit JSONRenderWindowExporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit JSONRenderWindowExporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

