# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.point_set_algorithm import PointSetAlgorithm


class HausdorffDistancePointSetFilter(PointSetAlgorithm):
    r"""
    HausdorffDistancePointSetFilter - Compute Hausdorff distance
    between two point sets
    
    Superclass: PointSetAlgorithm
    
    This class computes the relative and hausdorff distances from two
    point sets (input port 0 and input port 1). If no topology is
    specified (ie. PointSet or PolyData without Polys), the
    distances are computed between point location. If polys exist (ie
    triangulation), the target_distance_method allows for an interpolation
    of the cells to ensure a better minimal distance exploration.
    
    The outputs (port 0 and 1) have the same geometry and topology as its
    respective input port. Two field_data arrays are added :
    hausdorff_distance and relative_distance. The former is equal on both
    outputs whereas the latter may differ. A point_data containing the
    specific point minimal distance is also added to both outputs.
    
    @author Frederic Commandeur@author Jerome Velut@author LTSI
    
    @see https://www.vtkjournal.org/browse/publication/839
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHausdorffDistancePointSetFilter, obj, update, **traits)
    
    target_distance_method = tvtk_base.RevPrefixMap({'point_to_point': 0, 'point_to_cell': 1}, default_value='point_to_point', desc=\
        r"""
        Specify the strategy for computing the distance. If no topology
        is specified (ie. PointSet or PolyData without Polys),
        the distances are computed between point location. If polys exist
        (i.e. triangulation), the target_distance_method allows for an
        interpolation of the cells to ensure a better minimal distance
        exploration.
        """
    )

    def _target_distance_method_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTargetDistanceMethod,
                        self.target_distance_method_)

    def _get_hausdorff_distance(self):
        return self._vtk_obj.GetHausdorffDistance()
    hausdorff_distance = traits.Property(_get_hausdorff_distance, desc=\
        r"""
        Get the Hausdorff Distance.
        """
    )

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        
        """
    )

    def _get_relative_distance(self):
        return self._vtk_obj.GetRelativeDistance()
    relative_distance = traits.Property(_get_relative_distance, desc=\
        r"""
        Get the Relative Distance from A to B and B to A.
        """
    )

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('target_distance_method', 'GetTargetDistanceMethod'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'target_distance_method', 'object_name',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HausdorffDistancePointSetFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HausdorffDistancePointSetFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], ['target_distance_method'], ['object_name']),
            title='Edit HausdorffDistancePointSetFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HausdorffDistancePointSetFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

