<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/

	///////////////////////////////////////////////////
	// French accent reference
	//	Â  	&Acirc;  	â  	&acirc;
	//	Æ 	&AElig; 	æ 	&aelig;
	//	À 	&Agrave; 	à 	&agrave;
	//	Ç 	&Ccedil; 	ç 	&ccedil;
	//	É 	&Eacute; 	é 	&eacute;
	//	Ê 	&Ecirc; 	ê 	&ecirc;
	//	È 	&Egrave; 	è 	&egrave;
	//	Ë 	&Euml; 		ë 	&euml;
	//	Î 	&Icirc; 	î 	&icirc;
	//	Ï 	&Iuml; 		ï 	&iuml;
	//	Ô 	&Ocirc; 	ô 	&ocirc;
	//	Ö 	&Ouml; 		ö 	&ouml;
	//	Ù 	&Ugrave; 	ù 	&ugrave;
	//	Û 	&Ucirc; 	û 	&ucirc;
	//	Ü 	&Uuml; 		ü 	&uuml;
	///////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////
	// Language Configuration section
	// NOTE: - English language is default, so it has to be defined
	////////////////////////////////////////////////////////////////////
	$lang = 'fr';
	$lang_name = 'Français';

	////////////////////////////////////////////////////////////////////
	// General
	////////////////////////////////////////////////////////////////////
	$MESSAGES['admin_title'][$lang] = "Centre de contrôle LTSP-Cluster"; //Title for the configurator web page		
	$MESSAGES['logout'][$lang] = "D&eacute;connexion";
	$MESSAGES['access_denied'][$lang] = "Acc&egrave;s refusé"; // When no authenticated session exist
	$MESSAGES['add'][$lang] = "Ajouter";
	$MESSAGES['delete'][$lang] = "Supprimer";
	$MESSAGES['cancel'][$lang] = "Annuler";
	$MESSAGES['computer'][$lang] = "Ordinateurs";
	$MESSAGES['node'][$lang] = "Contextes";
	$MESSAGES['save'][$lang] = "Sauvegarder";
	$MESSAGES['submit'][$lang] = "Soumettre";
	$MESSAGES['or'][$lang] = "Ou";
	$MESSAGES['destination'][$lang] = "destination";
	$MESSAGES['create'][$lang] = "Cr&eacute;er";
	$MESSAGES['create_child'][$lang] = "Cr&eacute;er un fils";
	$MESSAGES['move_to'][$lang] = "D&eacute;placer vers ";
	$MESSAGES['hardware_group'][$lang] = "Groupe mat&eacute;riel";
	$MESSAGES['set_hwgroup_key'][$lang] = "Ajouter une r&egrave;gle : ";
	$MESSAGES['configuration_manage_attribute'][$lang] = "Gestion des attributs de";
	$MESSAGES['configuration_manage_hwg_rule'][$lang] = "Gestion des groupes mat&eacute;riels (r&egrave;gles)";
	$MESSAGES['hardware_specification'][$lang] = "Sp&eacute;cifications mat&eacute;rielles";
	$MESSAGES['choosePredefineValue'][$lang] = "Choisir une valeur pr&eacute;-d&eacute;finie";
	$MESSAGES['get_hwgroup_name'][$lang] = "Entrez le nom du group mat&eacute;riel : ";
	$MESSAGES['newListAttribute'][$lang] = "S.V.P. Entrer la nouvelle valeur : ";
	$MESSAGES['get_node_name'][$lang] = "Entrez le nouveau nom de l'arborescence : ";
	$MESSAGES['select_attribute'][$lang] = "S&eacute;lectionner un attribut : ";
	$MESSAGES['url_wiki'][$lang] = "http://mille-xterm.org/fr/Attribut/";
	////////////////////////////////////////////////////////////////////
	// General Error message
	////////////////////////////////////////////////////////////////////
	$MESSAGES['node_not_found'][$lang] = "Le noeud auquel vous tentez d'acc&eacute;der n'existe pas dans la base de donn&eacute;e";
	$MESSAGES['attribute_not_found'][$lang] = "L'attribut auquel vous tentez d'acc&eacute;der n'existe pas dans la base de donn&eacute;e";
	$MESSAGES['not_found'][$lang] = "Entr&eacute;e non trouv&eacute;e: ";
	$MESSAGES['bad_node_id'][$lang] = "Le ID sp&eacute;cifi&eacute; n'est pas un ID ou une MAC addresse valide";
	$MESSAGES['bad_id'][$lang] = "Le ID sp&eacute;cifi&eacute; n'est pas un ID valide : ";
	$MESSAGES['not_a_query'][$lang] = "La requ&ecirc;te envoy&eacute; &agrave; la fonction n'est pas une s&ecute;lection.";
	$MESSAGES['not_an_update'][$lang] = "La requ&ecirc;te envoy&eacute; &agrave; la fonction n'est pas une mise &agrave; jour.";
	$MESSAGES['empty_node_name'][$lang] = "Le nom d'un noeud ne peut &ecirc;tre vide.";
	$MESSAGES['too_long_node_name'][$lang] = "Le nom d'un contexte ne doit pas d&eacute;passer 254 caract&egrave;res.";
	$MESSAGES['cannot_move_root'][$lang] = "Impossible de d&eacute;placer le contexte racine";
	$MESSAGES['error_moving_node'][$lang] = "Erreur lors du d&eacute;placement d'un noeud : ";
	$MESSAGES['same_node_and_parent'][$lang] = "Un noeud ne peut pas &ecirc;tre sont propre p&egrave;re.";
	$MESSAGES['parent_in_node_tree'][$lang] = "Le parent ne peut pas &ecirc;tre dans le sous-arbre du fils.";
	$MESSAGES['parent_not_a_node'][$lang] = "Le parent sp&eacute;cifi&eacute; n'est pas un noeud.";
	$MESSAGES['error_creating_node'][$lang] = "Erreur lors de la cr&eacute;ation d'un noeud : ";
	$MESSAGES['error_creating_computer'][$lang] = "Erreur lors de la cr&eacute;ation d'un ordinateur : ";
	$MESSAGES['not_a_mac'][$lang] = " N'est pas une adresse MAC valide.";
	$MESSAGES['computer_exists'][$lang] = " Cet ordinateur existe d&eacute;j&agrave; dans la base de donn&eacute;es.";
	$MESSAGES['group_role_msg'][$lang] = "Aucun groupe, v&eacute;rifier l'attirbut ldap pour les groupes";
	$MESSAGES['no_group_role_msg'][$lang] = "Cette usager est associ&eacute; aux groupes suivants :"; // LDAP Group roles msg
	$MESSAGES['no_role_msg'][$lang] = "Aucun r&ocirc;le"; // LDAP Group roles msg
	$MESSAGES['no_editable_attributes'][$lang] = "Il n'y aucun attribut pouvant &ecirc;tre modifi&eacute;.";
	$MESSAGES['bad_ip'][$lang] = "Ce n'est pas un IP valide : ";
	$MESSAGES['bad_mac'][$lang] = "Ce n'est pas une adresse MAC valide : ";
	$MESSAGES['bad_number'][$lang] = "Ce n'est pas un num&eacute;ro valide : ";
	$MESSAGES['bad_status'][$lang] = "Ce n'est pas un status valide : ";
	$MESSAGES['empty_username'][$lang] = "Le nom d'usager ne peut &ecirc;tre vide.";
	$MESSAGES['error_creating_def'][$lang] = "Erreur lors de la cr&eacute;ation de la nouvelle valeur : ";  // Error while creating/modifying attribute def (list management, table attributesdefdict)
	$MESSAGES['error_modifying_def'][$lang] = "Erreur lors de la mise &agrave; jour : ";
	$MESSAGES['empty_def_name'][$lang] = "Aucune des valeurs ne peut &ecirc;tre vide.";
	$MESSAGES['not_computer'][$lang] = "Le noeud s&eacute;lectionn&eacute; n'est pas un ordinateur.";
	$MESSAGES['not_hwgroup'][$lang] = "Le noeud s&eacute;lectionn&eacute; n'est pas un groupe mat&eacute;riel.";
	$MESSAGES['invalide_value'][$lang] = "Valeur invalide : ";
	$MESSAGES['invalide_nodes_browser_type'][$lang] = "Type de navigateur de noeud invalide : ";
	$MESSAGES['invalide_nodes_type'][$lang] = "Type de noeud invalide ";
	$MESSAGES['invalid_uga_node'][$lang] = "Type de noeud invalide pour la gestion groupe/usager";
	$MESSAGES['invalid_ltsp_node'][$lang] = "Type de noeud invalide pour la configuration et la gestion des noeuds";
	$MESSAGES['create_hwgroup'][$lang] = "Cr&eacute;er un groupe mat&eacute;riel";
	$MESSAGES['deleted_node'][$lang] = "Cet élément a &eacute;t&eacute; suprim&eacute;.";
	$MESSAGES['cannot_delete_trash'][$lang] = "Impossible de suprimer ou d&eacute;placer la corbeille.";
	$MESSAGES['noaccess'][$lang] = "L'adresse MAC n'existe pas ou acc&egrave;s interdit.";
	//Permission
	$MESSAGES['no_permission_to_delete_attribute'][$lang] = "Vous n'avez pas les droits pour acc&eacute;der &agrave; ce noeud : ";
	$MESSAGES['no_permission_to_write_attribute'][$lang] = "Vous n'avez pas les droits pour modifier cette attribut : ";
	$MESSAGES['no_permission_to_read_node'][$lang] = "Vous n'avez pas les droits pour acc&eacute;der &agrave; ce noeud : ";
	$MESSAGES['no_permission_to_add_node'][$lang] = "Vous n'avez pas les droits pour acc&eacute;der &agrave; ce noeud : ";
	$MESSAGES['no_permission_to_move_node'][$lang] = "Vous n'avez pas les droits pour effectuer ce d&eacute;placement";
	$MESSAGES['no_permission_to_write_node'][$lang] = "Vous n'avez pas les droits pour acc&eacute;der &agrave; ce noeud : ";
	// Database Error
	$MESSAGES['db_write_error'][$lang] = "Erreur lors de l'&eacute;criture dans la base de donn&eacute;e : ";
	$MESSAGES['db_connexion_failed'][$lang] = "Erreur lors de la connection &agrave; la base de donn&eacute;e";
	$MESSAGES['no_db_user'][$lang] = "L'usager utilisé pour la connexion à la base de donn&eacute;es du configurateur n'est pas bien définit.<br>La requête était : ";
	$MESSAGES['no_db_password'][$lang] = "Le mot de passe de l'usager utilisé pour la connexion à la base de donn&eacute;es du configurateur n'est pas bien définit.<br/>Vous pouvez le définir sous : « Param&egrave;tres du configurateur » -->  «  Base de donnée du configurateur » ou vous pouvez le définir manuellement dans le fichier « config.php » sur le configurateur avec l'attribut « db_password ».<br>La requête était : ";
	$MESSAGES['no_db_name'][$lang] = "Le nom de la base de donn&eacute;es  du configurateur n'est pas bien définit.<br/>Vous pouvez le définir sous : « Param&egrave;tres du configurateur » -->  «  Base de donnée du configurateur » ou vous pouvez le définir manuellement dans le fichier « config.php » sur le configurateur avec l'attribut « db_name ».<br>La requête était : ";
	$MESSAGES['db_error'][$lang] = "Erreur de requ&ecirc;te sur la base de donn&eacute;e : ";

	////////////////////////////////////////////////////////////////////
	// Module names
	////////////////////////////////////////////////////////////////////
	$MESSAGES['configuration_module'][$lang] = "Configuration des terminaux";
	$MESSAGES['nodesManager_module'][$lang] = "Gestion de l&#039;arborescence";
	$MESSAGES['entity_module'][$lang] = "Configuration Groupe/usager";
	$MESSAGES['managelist_module'][$lang] = "Liste des valeurs des attributs";
	$MESSAGES['info_module'][$lang] = "Infos techniques";
	$MESSAGES['logs_module'][$lang] = "Journal des activités des terminaux";
	$MESSAGES['stats_module'][$lang] = "Rapports";
	$MESSAGES['printing_module'][$lang] = "Gestion des imprimantes";
	$MESSAGES['setup_module'][$lang] = "Param&egrave;tres du configurateur";

	$MESSAGES['configuration_module_short'][$lang] = "Terminaux";
	$MESSAGES['nodesManager_module_short'][$lang] = "Arborescence";
	$MESSAGES['entity_module_short'][$lang] = "Groupe/Usager";
	$MESSAGES['managelist_module_short'][$lang] = "Attributs";
	$MESSAGES['info_module_short'][$lang] = "Infos techniques";
	$MESSAGES['logs_module_short'][$lang] = "Journal des activités";
	$MESSAGES['stats_module_short'][$lang] = "Rapports";
	$MESSAGES['printing_module_short'][$lang] = "Imprimantes";
	$MESSAGES['setup_module_short'][$lang] = "Param&egrave;tres";

	////////////////////////////////////////////////////////////////////
	// Configurator setup section
	////////////////////////////////////////////////////////////////////
	// General setup messages
	$MESSAGES['new_cfg_created'][$lang] = "Le nouveau fichier de configuation a &eacute;t&eacute; &eacute;crit.";
	$MESSAGES['cannot_open_cfg_file'][$lang] = "Impossible d'ouvrir le fichier config.php en &eacute;criture.";
	$MESSAGES['exit'][$lang] = "Verrouiller";
	$MESSAGES['modify'][$lang] = "Enregistrer";
	$MESSAGES['lock_setup'][$lang] = "Quitter";
	$MESSAGES['cfg_val_true'][$lang] = "Oui";
	$MESSAGES['cfg_val_false'][$lang] = "Non";
	$MESSAGES['test'][$lang] = "Tester";
	// Language configuration section
	$MESSAGES['cfg_lang_section'][$lang] = "Langue";
	$MESSAGES['cfg_language'][$lang] = "Langue de l'interface du configurateur";
	$MESSAGES['cfg_charset'][$lang] = "Table des caract&egrave;res &agrave; utiliser (Par d&eacute;faut UTF-8) :";
	// Configurator Security section
	$MESSAGES['cfg_configurator_security_section'][$lang] = "S&eacute;curit&eacute; du configurateur";
	$MESSAGES['use_https'][$lang] = "Accéder à l'interface du configurateur via une connexion s&eacute;curis&eacute;e (https)";
	$MESSAGES['need_https'][$lang] = 'Cette page doit utiliser une connexion sécurisée (https).';
	// Terminals Security section
	$MESSAGES['cfg_terminal_security_section'][$lang] = "Securité des terminaux";
	$MESSAGES['cfg_terminal_password'][$lang] = "Mot de passe des terminaux";
	$MESSAGES['cfg_terminal_auth'][$lang] = "Activation de l'authentification des terminaux";
	// Configurator database section
	$MESSAGES['cfg_db_section'][$lang] = "Base de donn&eacute;es du configurateur";
	$MESSAGES['cfg_db_server'][$lang] = "Adresse de la base de donn&eacute;es (Valeur par d&eacute;faut : localhost)";
	$MESSAGES['cfg_db_user'][$lang] = "Utilisateur utilisé pour la connexion à la base de donn&eacute;es (Valeur par d&eacute;faut : mille)";
	$MESSAGES['cfg_db_password'][$lang] = "Mot de passe de l'utilisateur utilisé pour la connexion à la base de donn&eacute;es (Valeur par d&eacute;faut : mille)";	
	$MESSAGES['cfg_db_name'][$lang] = "Nom de la base de données (Valeur par d&eacute;faut : millev2)";
	$MESSAGES['cfg_db_type'][$lang] = "Type de base de donn&eacute;es (Valeur par d&eacute;faut : postgres7)";
	// Authentification configuration section
	$MESSAGES['cfg_auth_section'][$lang] = "Système d'authentification pour l'accès à l'interface du configurateur";
	$MESSAGES['cfg_auth_name'][$lang] = "Sélectionner le mécanisme d'authentication pour l'accès à l'interace Web du configurateur";
	// LDAP configuration (subsection of Authentification configuration)
	$MESSAGES['cfg_ldap_section'][$lang] = "Configuration des paramètres pour l'authentification LDAP";
       	$MESSAGES['cfg_ldap_host'][$lang] = "URL du serveur LDAP (Valeur par d&eacute;faut : ldaps://ldap)";
       	$MESSAGES['cfg_ldap_basedn'][$lang] = "Base de recherche :";
       	$MESSAGES['cfg_ldap_object_class'][$lang] = "Classe object des utilisateurs (facultatif)";
	$MESSAGES['cfg_ldap_group_object_class'][$lang] = "Classe object des groupes (facultatif)";
	$MESSAGES['cfg_ldap_group'][$lang] = "Nom de l'attribut des groupes";	
	$MESSAGES['cfg_ldap_binddn'][$lang] = "Usager LDAP pour accèder à l'informations des utilisateurs (Par d&eacute;fault c'est le m&ecirc;me qu'&agrave; la connection";
	$MESSAGES['cfg_ldap_bindpw'][$lang] = "Mot de passe de l'usager pr&eacute;c&eacute;dant (Par d&eacute;fault c'est le m&ecirc;me qu'&agrave la connection)";
	$MESSAGES['cfg_ldap_uidAttribute'][$lang] = "Attribut utilis&eacute; pour la recherche d'un usager : ";
	$MESSAGES['cfg_ldap_version'][$lang] = "version du protocole LDAP (Valeur par d&eacute;faut : 3)";
	$MESSAGES['test_ldap'][$lang] = "Entrez votre nom d'usager et mot de passe afin de tester la configuration LDAP";
	// LDAP user and group rights association section 
	$MESSAGES['ldap_group_role'][$lang] = "Association des droits pour les utilisateurs et les groupes « Oubligatoire »";		
	// Load balancer section
	$MESSAGES['cfg_loadbalancer_section'][$lang] = "Système de répartition de la charge";
	$MESSAGES['cfg_loadbalancer'][$lang] = "URL (Valeur par défaut : localhost:8001)";	
	// printer servers section
	$MESSAGES['printer_server_section'][$lang] = "Serveurs d'impression (Cups)";

	////////////////////////////////////////////////////////////////////
	// Login Screen
	////////////////////////////////////////////////////////////////////
	$MESSAGES['index_title'][$lang] = 'Connexion au système de configuration Mille-Xterm';
	$MESSAGES['no_language_file'][$lang] = "Le fichier text-.php n'a pas été trouvé sur le serveur, la langue n'est pas supporté.";	
	$MESSAGES['ask_uid'][$lang] = 'Entrez votre nom d\'usager : ';
	$MESSAGES['ask_password'][$lang] = 'Enter your password : ';
	$MESSAGES['connect'][$lang] = 'Se connecter';
	$MESSAGES['bad_login'][$lang] = 'Nom d\'usager ou mot de passe invalide.';
	$MESSAGES['good_login'][$lang] = 'Connexion de l\'usager r&eacute;ussie.';

	////////////////////////////////////////////////////////////////////
	// Search node Module
	////////////////////////////////////////////////////////////////////
	$MESSAGES['id_or_mac'][$lang] = "Rerchercher un élément par son adresse MAC ou son numéro d'identification";
	$MESSAGES['find'][$lang] = "Rechercher";
	$MESSAGES['go'][$lang] = "Atteindre";		
    $MESSAGES['search_inv'][$lang] = "Rerchercher un élément par son numéro d'inventaire:";
	
	////////////////////////////////////////////////////////////////////
	// Configuration module
	////////////////////////////////////////////////////////////////////
	$MESSAGES['source'][$lang] = "Sélection de l'élément à gérer";
	$MESSAGES['nodes_editor_change_tree_name'][$lang] = "Modification du nom de l'arborescence";
	$MESSAGES['nodes_editor_manage_actual_nodes'][$lang] = "Gérer les enfants de cet arborescence";
	$MESSAGES['nodes_editor_deselect'][$lang] = "Désélectionner";
	$MESSAGES['config_attributes_listing'][$lang] = "Configuration actuelle";
	$MESSAGES['config_delete'][$lang] = "Supprimer";
	$MESSAGES['config_modify'][$lang] = "Modifier";
	$MESSAGES['config_cancel'][$lang] = "Désélectionner";
	$MESSAGES['config_select_tree'][$lang] = "Sélection de l'arborescence";

	////////////////////////////////////////////////////////////////////
	// User and group module
	////////////////////////////////////////////////////////////////////			
	$MESSAGES['add_user_group'][$lang] = "Ajouter un  ";
	$MESSAGES['user'][$lang] = "Usager";
	$MESSAGES['group'][$lang] = "Groupe";
	$MESSAGES['users'][$lang] = "Usagers";
	$MESSAGES['groups'][$lang] = "Groupes";
	$MESSAGES['search_user_group'][$lang] = "Nom de l'usager ou du groupe";
	$MESSAGES['invalide_node_name'][$lang] = "Nom invalide :";
	$MESSAGES['db_duplicate_value'][$lang] = "La valeur entr&eacute;e existe d&eacute;j&agrave; !";

	////////////////////////////////////////////////////////////////////
	// Ldap messages at Login Screen
	////////////////////////////////////////////////////////////////////	
	$MESSAGES['ldap_cant_connect'][$lang] = "Impossible de contacter le serveur LDAP &agrave; l'adresse : ".$CONFIG['ldap_host'];
	$MESSAGES['ldap_connected'][$lang] = "Vous êtes déjà connect&eacute au serveur LDAP.";
	$MESSAGES['ldap_not_connected'][$lang] = "Impossible de fermer la connexion au serveur LDAP.";
	$MESSAGES['ldap_version_not_supported'][$lang] = "Le serveur LDAP ne semble pas supporter la version ".$CONFIG['ldap_version']." du protocole LDAP";
	$MESSAGES['ldap_user_bind'][$lang] = "Param&ecirc;tre binddn ou bindpw manquant dans le fichier de configuration, connection avec l'usager";

	$MESSAGES['ldap_no_basedn'][$lang] = "La base de recherche de LDAP (basedn) n'est pas définit ou ne semble pas être valide.<br/>Vous pouvez la définir sous : « " .getMessage('setup_module')." » -->  «  ".getMessage('cfg_auth_section')." »  -->  «  ".getMessage('cfg_ldap_section')." » ou vous pouvez la définir manuellement dans le fichier « ".$CONFIG['rootInstall']."util/config.php » sur le configurateur avec l'attribut « ldap_basedn ».";

	$MESSAGES['ldap_cant_bind'][$lang] = "Impossible de contacter le serveur LDAP &agrave; l'adresse : ".$CONFIG['ldap_host']."<br/>Assurez-vous que le serveur LDAP fonctionne bien et que votre configuration est adéquate.<br/>Vous pouvez modifier la configuration sous : « " .getMessage('setup_module')." » -->  «  ".getMessage('cfg_auth_section')." »  -->  «  ".getMessage('cfg_ldap_section')." » ou vous pouvez la modifier manuellement dans le fichier « ".$CONFIG['rootInstall']."util/config.php » sur le serveur du configurateuravec l'attribut « ldap_host ».";

	$MESSAGES['ldap_no_host'][$lang] = "Il n'y a pas d'hôte de définit pour le serveur LDAP.<br/>Vous pouvez le définir sous : « Param&egrave;tres du configurateur » -->  «  Base de donnée du configurateur » ou vous pouvez le définir manuellement dans le fichier « ".$CONFIG['rootInstall']."util/config.php » sur le configurateur avec l'attribut « ldap_host ».";

	$MESSAGES['ldap_no_group'][$lang] = "Il n'y a pas de groupe LDAP de définit.<br/>Vous pouvez la définir sous : « Param&egrave;tres du configurateur » -->  «  Base de donnée du configurateur » ou vous pouvez la définir manuellement dans le fichier « ".$CONFIG['rootInstall']."util/config.php » sur le configurateur avec l'attribut « ldap_group ».";
	
	////////////////////////////////////////////////////////////////////
	// Group/User  Module
	////////////////////////////////////////////////////////////////////
	$MESSAGES['entity_add_entity_message'][$lang] = "Ajouter des utilisateurs et des groupes";
	$MESSAGES['entity_manage_user_group'][$lang] = "Gérer les utilisateurs et les groupes";
	$MESSAGES['newDefaultValueListAttribute'][$lang] = "";

	////////////////////////////////////////////////////////////////////
	// Report module
	////////////////////////////////////////////////////////////////////
	$MESSAGES['stats_node_selector_msg'][$lang] = "S&eacute;lectionnez les &eacute;l&eacute;ments que vous d&eacute;sirez traiter";
	$MESSAGES['stats_true_conditions'][$lang] = "S&eacute;lectionnez les conditions auxquelles les attributs des &eacute;l&eacute;ments doivent correspondre";
	$MESSAGES['stats_false_conditions'][$lang] = "S&eacute;lectionnez les conditions auxquelles les attributs des &eacute;l&eacute;ments ne doivent pas correspondre";
	$MESSAGES['stats_add_cond'][$lang] = "Ajouter";
	$MESSAGES['stats_add_value'][$lang] = "Ajouter";
	$MESSAGES['stats_selected_value'][$lang] = "Condition(s) s&eacute;lectionn&eacute;e(s) :";
	$MESSAGES['stats_select_what'][$lang] = "Traiter les : ";
	$MESSAGES['stats_terminals'][$lang] = "Terminaux";
	$MESSAGES['stats_contexts'][$lang] = "Contextes";
	$MESSAGES['stats_contexts_n_terminals'][$lang] = "Terminaux et les Contextes";
	$MESSAGES['stats_use_heritage'][$lang] = "Prendre en compte des attributs h&eacute;rit&eacute;s : ";
	$MESSAGES['stats_yes'][$lang] = "Oui";
	$MESSAGES['stats_no'][$lang] = "Non";
	$MESSAGES['stats_send'][$lang] = "Continuer";
	$MESSAGES['stats_validate'][$lang] = "Ok";
	$MESSAGES['stats_configuration'][$lang] = "Attributs de configuration";
	$MESSAGES['stats_network'][$lang] = "Attributs r&eacute;seau";
	$MESSAGES['stats_hardware'][$lang] = "Attributs mat&eacute;riels";
	$MESSAGES['stats_select_attr_title'][$lang] = "S&eacute;lectionez les attributs que vous d&eacute;sriez afficher leur valeur dans le rapport";
	$MESSAGES['stats_select_attr_config'][$lang] = "Attributs de configuration :";
	$MESSAGES['stats_select_attr_hardware'][$lang] = "Attributs mat&eacute;riels :";
	$MESSAGES['stats_select_attr_network'][$lang] = "Attributs r&eacute;seau :";
	$MESSAGES['stats_select_attr_type'][$lang] = "Afficher sous forme de :";
	$MESSAGES['stats_generate'][$lang] = "G&eacute;n&eacute;rer le rapport";
	$MESSAGES['stats_select_attr_type_context'][$lang] = "Contexte";
	$MESSAGES['stats_select_attr_type_table'][$lang] = "Tableau";
	$MESSAGES['stats_attribute'][$lang] = "Attributs";
	$MESSAGES['stats_report_no_attr'][$lang] = "Il n'y aucun attribut &agrave; afficher parmis ceux qui ont &eacute;t&eacute; s&eacute;lectionn&eacute;s.";
	$MESSAGES['stats_report_err_cond'][$lang] = "Cet &eacute;l&eacute;ment ne r&eacute;pond pas aux conditions fix&eacute;s";
	$MESSAGES['stats_equals'][$lang] = "Est &eacute;gal &agrave;";
	$MESSAGES['stats_unequals'][$lang] = "N'est pas &eacute;gal &agrave;";
	$MESSAGES['stats_greater'][$lang] = "Est plus grand que";
	$MESSAGES['stats_greater_equals'][$lang] = "Est plus grand ou &eacute;gal &agrave;";
	$MESSAGES['stats_lower'][$lang] = "Est plus petit que";
	$MESSAGES['stats_lower_equals'][$lang] = "Est plus petit ou &eacute;gal &agrave;";
	$MESSAGES['stats_no_node'][$lang] = "Vous n'avez pas s&eacute;lectionner d'&eacute;l&eacute;ments &agrave; traiter";
	$MESSAGES['stats_and'][$lang] = "ET";
	$MESSAGES['stats_or'][$lang] = "OU";
	$MESSAGES['stats_node'][$lang] = "&Eacute;l&eacute;ment";
	$MESSAGES['stats_path'][$lang] = "Emplacement";
	$MESSAGES['stats_no_frames'][$lang] = "Votre navigateur ne supporte pas les iframes. Pour accèder au module de rapports, suivez le lien suivant: ";
	////////////////////////////////////////////////////////////////////
	// Printer Module
	////////////////////////////////////////////////////////////////////
	$MESSAGES['printer_manage'][$lang] = "G&eacute;rer";
	$MESSAGES['printer_manage_list'][$lang] = "Sélection des serveurs d'impression à gérer";
	$MESSAGES['printer_server_list'][$lang] = "Liste des imprimantes du serveur";
	$MESSAGES['printer_add'][$lang] = "Ajouter";
	$MESSAGES['printer_delete'][$lang] = "Supprimer";
	$MESSAGES['printer_database'][$lang] = "Imprimantes installés dans la base de donn&eacute;es du configurateur";
	$MESSAGES['printer_servers'][$lang] = "Imprimantes disponibles";
	$MESSAGES['printer_standalone_list'][$lang] = "Liste des imprimantes indépendantes";
	$MESSAGES['printer_add_a_standalone'][$lang] = "Ajout d'imprimantes ind&eacute;pendantes";
	$MESSAGES['printer_no_printer_standalone'][$lang] = "Il n'y a aucune imprimante ind&eacute;pendante définie.";
	$MESSAGES['printer_warning_standalone'][$lang] = "Attention : Il est possible que des imprimantes soient dans la liste des imprimantes ind&eacute;pendantes si leur serveur ne répond pas.<br/>Ces imprimantes réapparaîtrons dans la liste de ce serveur lorsque celui-ci sera disponible à nouveau.";
	$MESSAGES['printer_no_server'][$lang] = "Le serveur ne répond pas.";
	$MESSAGES['printer_dead_server'][$lang] = "Le nom DNS du serveur existe mais le serveur ne répond pas.";
	$MESSAGES['printer_no_printer_server'][$lang] = "Il n'y a pas de serveur d'impression configur&eacute;.<br/><br/>Si vous le désirez, vous pouvez en ajouter à l'emplacement suivant : « ".getMessage('setup_module')." » --> « ".getMessage('printer_server_section')." »<br/>Vous pouvez néanmoins utiliser la « ".getMessage('printer_standalone_list')." »";
	$MESSAGES['printer_check_all'][$lang] = "Tout sélectionner";
	////////////////////////////////////////////////////////////////////
	// Log  Module
	////////////////////////////////////////////////////////////////////
	$MESSAGES['logs_ts'][$lang] = "Date et heure";
	$MESSAGES['logs_id'][$lang] = "ID du noeud du terminal";
	$MESSAGES['logs_mac'][$lang] = "Adresse MAC";
	$MESSAGES['logs_ip'][$lang] = "Adresse du terminal";
	$MESSAGES['logs_bootservip'][$lang] = "Adresse du serveur de démarrage";
	$MESSAGES['logs_appservip'][$lang] = "Adresse du serveur d'application ";
	$MESSAGES['logs_username'][$lang] = "Nom de l'utilisateur";
	$MESSAGES['logs_code'][$lang] = "Événement";
	$MESSAGES['logs_bootservretry'][$lang] = "Entrée Démarrage";
	$MESSAGES['logs_appservretry'][$lang] = "Entrée Application";
	$MESSAGES['logs_prev'][$lang] = "Précédente";
	$MESSAGES['logs_next'][$lang] = "Suivante";
	$MESSAGES['logs_nb_logs_message'][$lang] = "Résultats par page";
	$MESSAGES['logs_filter_message'][$lang] = "Gestion des filtres";
	$MESSAGES['logs_table_message'][$lang] = "Résultats";
	$MESSAGES['logs_validate'][$lang] = "Appliquer";
	$MESSAGES['logs_code_booting'][$lang] = "Démarrage du terminal";
	$MESSAGES['logs_code_GDM'][$lang] = "Écran de connexion";
	$MESSAGES['logs_code_logging'][$lang] = "Connexion de l'utilisateur";
	$MESSAGES['logs_code_unlogging'][$lang] = "Déconnexion de l'utilisateur";
	$MESSAGES['logs_msg_filter_seizure'][$lang] = "Saisie des filtres";
	$MESSAGES['logs_msg_active_filters'][$lang] = "Filtres actifs";
	$MESSAGES['logs_code_msg_legend'][$lang] = "Légende des événements";
	$MESSAGES['logs_equals'][$lang] = "=";
	$MESSAGES['logs_greater'][$lang] = ">";
	$MESSAGES['logs_gt_equals'][$lang] = ">=";
	$MESSAGES['logs_smaller'][$lang] = "<";
	$MESSAGES['logs_sm_equals'][$lang] = "<=";
	$MESSAGES['logs_not_equals'][$lang] = "!=";
	$MESSAGES['logs_send_add_filter'][$lang] = "Ajouter le filtre";
	$MESSAGES['logs_send_remove_filter'][$lang] = "Supprimer tous les filtres";

	////////////////////////////////////////////////////////////////////
	// Attribute Names & Values
	////////////////////////////////////////////////////////////////////
	//$MESSAGES['SOUND'][$lang] = "Activer le son";
	//$MESSAGES['SOUND_Y'][$lang] = "Oui";
	//$MESSAGES['SOUND_N'][$lang] = "Non";

	////////////////////////////////////////////////////////////////////
	// Message to use when asked message is not defined
	//
	// DO NOT REMOVE OR CHANGE THE NAME OF THIS MESSAGE,
	// YOU WILL GET INFINIT RECURSION IN GETMESSAGE FUNCTION
	////////////////////////////////////////////////////////////////////
	$MESSAGES['messages_error'][$lang] = 'This message is not set in text-fr.php';
	unset($lang);

///////////////////////////////////////////////////////////////////
// Old Messages - If you want to delete some message and you are not sure
// if this message is still in use, add the message temporaly here and
// comment it. Don't forget to add the remove date...
///////////////////////////////////////////////////////////////////
// ******** Message removed 24-07-2006 ************
// $MESSAGES['printer_selected'][$lang] = "Imprimante s&eacute;lectionn&eacute;e: ";
// $MESSAGES['selected_printer'][$lang] = "Selected printer";
// $MESSAGES['no_printer_selected'][$lang] = "No printer selected.";
// $MESSAGES['assign_printer_to_local'][$lang] = "Assign a printer to a local";
// $MESSAGES['assign'][$lang] = "Assigner";
// $MESSAGES['node_selected'][$lang] = "Selected node:";
// $MESSAGES['printer_selected'][$lang] = "Selected printer:";
// $MESSAGES['add'][$lang] = "Add";
// $MESSAGES['delete'][$lang] = "Delete";
// $MESSAGES['add_a_printer'][$lang] = "Add a printer";
// $MESSAGES['printer_name'][$lang] = "Printer name";
// $MESSAGES['printer_description'][$lang] = "Description";
// $MESSAGES['printer_not_found'][$lang] = "Printer not found";
// $MESSAGES['delete_printer_ok'][$lang] = "Printer deleted.";
// $MESSAGES['add_printer_ok'][$lang] = "Printer added.";
// $MESSAGES['printer_priceperpage'][$lang] = "$/page";
// $MESSAGES['printer_priceperjob'][$lang] = "$/job";
// $MESSAGES['cannot_update_dico'][$lang] = "Cannot update dictionary: ";
// $MESSAGES['sync'][$lang] = "Synchronize";
// $MESSAGES['sync_dict'][$lang] = "Synchronize the dictionary";
// $MESSAGES['sync_users'][$lang] = "Synchronize PyKota users";
// $MESSAGES['printer_servers_list'][$lang] = "Printer servers list";
// $MESSAGES['no_printer_servers_list'][$lang] = "No printer server configured<br />You can add one under Parameter --> Printing";
// $MESSAGES['cannot_get_status'][$lang] = "Cannot get status : ";
// $MESSAGES['cannot_set_status'][$lang] = "Cannot set status : ";
// $MESSAGES['id_printer'][$lang] = "Write the name, the ID or a regular expression for choosing your ptinter:";
// $MESSAGES['setup_title'][$lang] = 'Configurator setup';
// $MESSAGES['cfg_ldap_people'][$lang] = "Enter LDAP user base (Default is ou=People)";
// $MESSAGES['logs_note'][$lang] = "Terminals activity: from most recent to the oldest";
// $MESSAGES['logs_display'][$lang] = "\$Display";
?>
