#ifndef _IMAGE_CACHE_H
#define _IMAGE_CACHE_H

#include <string>
#include <vector>

#include "png++/image.hpp"
#include "png++/rgb_pixel.hpp"


typedef png::image<png::rgb_pixel> PngImage;

class ImageCache {
  public:
    PngImage& GetImage(const std::string& name);
    void SetImagesPath(const std::string& path);

  private:

    struct Image {
	std::string name;
	PngImage png;
	Image(std::string n, PngImage p):name(n), png(p){}
    };

    std::string path;
    std::vector<Image> images;
};

extern ImageCache image_cache;

#endif
