/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.launch;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.lisaac.ldt.launch.LisaacCompiler;
import org.lisaac.ldt.launch.LisaacLauncher;
import org.lisaac.ldt.model.LisaacModel;
import org.lisaac.ldt.model.items.Prototype;

public class LaunchConfiguration
implements ILaunchConfigurationDelegate {
    public static final String TYPE_ID = "org.lisaac.ldt.launchConfiguration";
    protected LisaacCompiler compiler;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        LisaacModel model;
        String projectName = configuration.getAttribute("launchProject", "");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        String mainPrototype = configuration.getAttribute("mainPrototype", "main.li");
        String programArguments = configuration.getAttribute("programArguments", "");
        boolean doAlwaysCompile = configuration.getAttribute("launchCompiler", true);
        boolean doRun = configuration.getAttribute("launchProgram", true);
        boolean hasCompiled = false;
        int index = mainPrototype.lastIndexOf(47);
        if (index != -1) {
            mainPrototype = mainPrototype.substring(index + 1);
        }
        if ((model = LisaacModel.getModel(project)) != null) {
            Prototype main = model.getPrototype(LisaacModel.extractPrototypeName(mainPrototype));
            if (main == null || main.getSlot("main") == null) {
                MessageDialog.openInformation(null, (String)"Lisaac Plug-in", (String)(String.valueOf(mainPrototype) + " : Slot 'main' is missing."));
                monitor.done();
                return;
            }
            String outputName = main.getName().toLowerCase();
            monitor.worked(5);
            if (!doAlwaysCompile && model.needCompilation() || doAlwaysCompile) {
                String option;
                this.compiler = new LisaacCompiler(model, mainPrototype, outputName, "make.lip");
                int count = 0;
                do {
                    if ((option = configuration.getAttribute("lipOption" + count, "")) != null && !option.equals("")) {
                        this.compiler.addOption("-" + option);
                        if (option.compareTo("run_mode") == 0) {
                            this.compiler.addOption(mode);
                        } else {
                            String optionArg = configuration.getAttribute("lipOptionARG" + count, "");
                            if (!optionArg.equals("")) {
                                this.compiler.addOption(optionArg);
                            }
                        }
                    }
                    ++count;
                } while (option != null && !option.equals(""));
                IContainer output = this.compiler.launchInConsole(launch, project, monitor);
                if (output == null) {
                    MessageDialog.openInformation(null, (String)"Lisaac Plug-in", (String)"Compilation Error!");
                }
                monitor.worked(50);
                hasCompiled = true;
                model.setCompiled(true);
                monitor.worked(1);
            }
            if (doRun && !hasCompiled) {
                IFile executable;
                IFolder bin = project.getFolder("bin");
                if (bin == null) {
                    bin = project;
                }
                if ((executable = bin.getFile((IPath)new Path(outputName))).exists()) {
                    String[] commandLine = new String[]{executable.getLocation().toString(), programArguments};
                    LisaacLauncher.executeCommandInConsole(launch, monitor, (IContainer)bin, commandLine, null);
                } else {
                    model.setCompiled(false);
                }
            }
        }
        monitor.done();
    }
}

