/* account_widget.c generated by valac, the Vala compiler
 * generated from account_widget.vala, do not modify */

/* account_widget.vala
 *
 * Copyright (C) 2009-2010  troorl
 * Copyright (C) 2010 Kushal Das <kushal@fedoraproject.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	troorl <troorl@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>


#define TYPE_ACCOUNT_WIDGET (account_widget_get_type ())
#define ACCOUNT_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_WIDGET, AccountWidget))
#define ACCOUNT_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT_WIDGET, AccountWidgetClass))
#define IS_ACCOUNT_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_WIDGET))
#define IS_ACCOUNT_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT_WIDGET))
#define ACCOUNT_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT_WIDGET, AccountWidgetClass))

typedef struct _AccountWidget AccountWidget;
typedef struct _AccountWidgetClass AccountWidgetClass;
typedef struct _AccountWidgetPrivate AccountWidgetPrivate;

#define AUTH_TYPE_ACCOUNTS (auth_accounts_get_type ())
#define AUTH_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUTH_TYPE_ACCOUNTS, AuthAccounts))
#define AUTH_ACCOUNTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUTH_TYPE_ACCOUNTS, AuthAccountsClass))
#define AUTH_IS_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUTH_TYPE_ACCOUNTS))
#define AUTH_IS_ACCOUNTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUTH_TYPE_ACCOUNTS))
#define AUTH_ACCOUNTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUTH_TYPE_ACCOUNTS, AuthAccountsClass))

typedef struct _AuthAccounts AuthAccounts;
typedef struct _AuthAccountsClass AuthAccountsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define AUTH_TYPE_ACCOUNT (auth_account_get_type ())
#define AUTH_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUTH_TYPE_ACCOUNT, AuthAccount))
#define AUTH_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUTH_TYPE_ACCOUNT, AuthAccountClass))
#define AUTH_IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUTH_TYPE_ACCOUNT))
#define AUTH_IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUTH_TYPE_ACCOUNT))
#define AUTH_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUTH_TYPE_ACCOUNT, AuthAccountClass))

typedef struct _AuthAccount AuthAccount;
typedef struct _AuthAccountClass AuthAccountClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_EDIT_ACCOUNT (edit_account_get_type ())
#define EDIT_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EDIT_ACCOUNT, EditAccount))
#define EDIT_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EDIT_ACCOUNT, EditAccountClass))
#define IS_EDIT_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EDIT_ACCOUNT))
#define IS_EDIT_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EDIT_ACCOUNT))
#define EDIT_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EDIT_ACCOUNT, EditAccountClass))

typedef struct _EditAccount EditAccount;
typedef struct _EditAccountClass EditAccountClass;
typedef struct _EditAccountPrivate EditAccountPrivate;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

struct _AccountWidget {
	GtkHBox parent_instance;
	AccountWidgetPrivate * priv;
	GtkListStore* model;
};

struct _AccountWidgetClass {
	GtkHBoxClass parent_class;
};

struct _AccountWidgetPrivate {
	GtkTreeView* table;
	GtkButton* add_button;
	GtkButton* edit_button;
	GtkButton* delete_button;
	GtkWindow* parent;
	AuthAccounts* accounts;
};

struct _EditAccount {
	GtkDialog parent_instance;
	EditAccountPrivate * priv;
	AuthAccount* acc;
	GtkEntry* login;
	GtkEntry* password;
	GtkComboBox* service;
	GtkEntry* proxy;
	gboolean ok;
};

struct _EditAccountClass {
	GtkDialogClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	AccountWidget * self;
	GtkTreeIter iter;
	AuthAccount* acc;
	EditAccount* edit_dialog;
};

struct _Block3Data {
	int _ref_count_;
	AccountWidget * self;
	EditAccount* edit_dialog;
};


static gpointer account_widget_parent_class = NULL;

GType account_widget_get_type (void);
GType auth_accounts_get_type (void);
#define ACCOUNT_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ACCOUNT_WIDGET, AccountWidgetPrivate))
enum  {
	ACCOUNT_WIDGET_DUMMY_PROPERTY
};
static void account_widget_add_event (AccountWidget* self);
static void _account_widget_add_event_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void account_widget_edit_event (AccountWidget* self);
static void _account_widget_edit_event_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void account_widget_delete_event (AccountWidget* self);
static void _account_widget_delete_event_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void account_widget_select_first (AccountWidget* self);
static void account_widget_table_setup (AccountWidget* self);
static void _lambda5_ (AccountWidget* self);
static void __lambda5__gtk_tree_view_cursor_changed (GtkTreeView* _sender, gpointer self);
AccountWidget* account_widget_new (GtkWindow* _parent, AuthAccounts* _accounts);
AccountWidget* account_widget_construct (GType object_type, GtkWindow* _parent, AuthAccounts* _accounts);
GType auth_account_get_type (void);
AuthAccount* auth_accounts_get_by_hash (AuthAccounts* self, const char* hash);
EditAccount* edit_account_new_with_acc (GtkWindow* _parent, AuthAccount* _acc);
EditAccount* edit_account_construct_with_acc (GType object_type, GtkWindow* _parent, AuthAccount* _acc);
GType edit_account_get_type (void);
const char* auth_account_get_login (AuthAccount* self);
const char* auth_account_get_service (AuthAccount* self);
const char* auth_account_get_proxy (AuthAccount* self);
const char* auth_account_get_password (AuthAccount* self);
void auth_accounts_write (AuthAccounts* self);
static void _lambda4_ (Block2Data* _data2_);
static void __lambda4__gtk_object_destroy (GtkObject* _sender, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
EditAccount* edit_account_new (GtkWindow* _parent);
EditAccount* edit_account_construct (GType object_type, GtkWindow* _parent);
void auth_accounts_add_account (AuthAccounts* self, AuthAccount* acc);
GeeArrayList* auth_accounts_get_accounts (AuthAccounts* self);
static void _lambda3_ (Block3Data* _data3_);
static void __lambda3__gtk_object_destroy (GtkObject* _sender, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
gboolean auth_account_get_active (AuthAccount* self);
void auth_accounts_delete_account (AuthAccounts* self, const char* hash);
static void account_widget_finalize (GObject* obj);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _account_widget_add_event_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_widget_add_event (self);
}


static void _account_widget_edit_event_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_widget_edit_event (self);
}


static void _account_widget_delete_event_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_widget_delete_event (self);
}


static void _lambda5_ (AccountWidget* self) {
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->edit_button, TRUE);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->delete_button, TRUE);
}


static void __lambda5__gtk_tree_view_cursor_changed (GtkTreeView* _sender, gpointer self) {
	_lambda5_ (self);
}


AccountWidget* account_widget_construct (GType object_type, GtkWindow* _parent, AuthAccounts* _accounts) {
	AccountWidget * self;
	GtkWindow* _tmp0_;
	AuthAccounts* _tmp1_;
	GtkTreeView* _tmp2_;
	GtkFrame* frame;
	GtkHBox* tbl_box;
	GtkVBox* tvbox;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkVBox* btn_box;
	GtkListStore* _tmp6_;
	GtkCellRendererText* _tmp7_;
	GtkCellRendererText* _tmp8_;
	GtkCellRendererText* _tmp9_;
	g_return_val_if_fail (_parent != NULL, NULL);
	g_return_val_if_fail (_accounts != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	self->priv->parent = (_tmp0_ = _g_object_ref0 (_parent), _g_object_unref0 (self->priv->parent), _tmp0_);
	self->priv->accounts = (_tmp1_ = _g_object_ref0 (_accounts), _g_object_unref0 (self->priv->accounts), _tmp1_);
	gtk_box_set_homogeneous ((GtkBox*) self, FALSE);
	gtk_box_set_spacing ((GtkBox*) self, 4);
	self->priv->table = (_tmp2_ = g_object_ref_sink ((GtkTreeView*) gtk_tree_view_new ()), _g_object_unref0 (self->priv->table), _tmp2_);
	frame = g_object_ref_sink ((GtkFrame*) gtk_frame_new (NULL));
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) self->priv->table);
	tbl_box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (TRUE, 0));
	gtk_box_pack_start ((GtkBox*) tbl_box, (GtkWidget*) frame, TRUE, TRUE, (guint) 0);
	tvbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (TRUE, 0));
	gtk_box_pack_start ((GtkBox*) tvbox, (GtkWidget*) tbl_box, TRUE, TRUE, (guint) 0);
	self->priv->add_button = (_tmp3_ = g_object_ref_sink ((GtkButton*) gtk_button_new_from_stock ("gtk-add")), _g_object_unref0 (self->priv->add_button), _tmp3_);
	g_signal_connect_object (self->priv->add_button, "clicked", (GCallback) _account_widget_add_event_gtk_button_clicked, self, 0);
	self->priv->edit_button = (_tmp4_ = g_object_ref_sink ((GtkButton*) gtk_button_new_from_stock ("gtk-edit")), _g_object_unref0 (self->priv->edit_button), _tmp4_);
	g_signal_connect_object (self->priv->edit_button, "clicked", (GCallback) _account_widget_edit_event_gtk_button_clicked, self, 0);
	self->priv->delete_button = (_tmp5_ = g_object_ref_sink ((GtkButton*) gtk_button_new_from_stock ("gtk-delete")), _g_object_unref0 (self->priv->delete_button), _tmp5_);
	g_signal_connect_object (self->priv->delete_button, "clicked", (GCallback) _account_widget_delete_event_gtk_button_clicked, self, 0);
	btn_box = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 4));
	gtk_box_pack_start ((GtkBox*) btn_box, (GtkWidget*) self->priv->add_button, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) btn_box, (GtkWidget*) self->priv->edit_button, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) btn_box, (GtkWidget*) self->priv->delete_button, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) tvbox, TRUE, TRUE, (guint) 0);
	gtk_box_pack_end ((GtkBox*) self, (GtkWidget*) btn_box, FALSE, FALSE, (guint) 0);
	self->model = (_tmp6_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, NULL), _g_object_unref0 (self->model), _tmp6_);
	gtk_tree_view_set_model (self->priv->table, (GtkTreeModel*) self->model);
	gtk_tree_selection_set_mode (gtk_tree_view_get_selection (self->priv->table), GTK_SELECTION_SINGLE);
	account_widget_select_first (self);
	gtk_tree_view_insert_column_with_attributes (self->priv->table, -1, _ ("Login"), (GtkCellRenderer*) (_tmp7_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 0, NULL);
	_g_object_unref0 (_tmp7_);
	gtk_tree_view_insert_column_with_attributes (self->priv->table, -1, _ ("Service"), (GtkCellRenderer*) (_tmp8_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 1, NULL);
	_g_object_unref0 (_tmp8_);
	gtk_tree_view_insert_column_with_attributes (self->priv->table, -1, _ ("URL"), (GtkCellRenderer*) (_tmp9_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 2, NULL);
	_g_object_unref0 (_tmp9_);
	account_widget_table_setup (self);
	g_signal_connect_object (self->priv->table, "cursor-changed", (GCallback) __lambda5__gtk_tree_view_cursor_changed, self, 0);
	_g_object_unref0 (frame);
	_g_object_unref0 (tbl_box);
	_g_object_unref0 (tvbox);
	_g_object_unref0 (btn_box);
	return self;
}


AccountWidget* account_widget_new (GtkWindow* _parent, AuthAccounts* _accounts) {
	return account_widget_construct (TYPE_ACCOUNT_WIDGET, _parent, _accounts);
}


static void account_widget_select_first (AccountWidget* self) {
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	if (gtk_tree_model_get_iter_first ((GtkTreeModel*) self->model, &iter)) {
		gtk_tree_selection_select_iter (gtk_tree_view_get_selection (self->priv->table), &iter);
	} else {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->edit_button, FALSE);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->delete_button, FALSE);
	}
}


static void _lambda4_ (Block2Data* _data2_) {
	AccountWidget * self;
	self = _data2_->self;
	if (_data2_->edit_dialog->ok) {
		GValue _tmp1_;
		GValue _tmp0_ = {0};
		GValue _tmp3_;
		GValue _tmp2_ = {0};
		GValue _tmp5_;
		GValue _tmp4_ = {0};
		char* _tmp6_;
		char* _tmp7_;
		char* hash;
		g_debug ("account_widget.vala:120: %s", auth_account_get_login (_data2_->acc));
		g_warning ("account_widget.vala:121: %s", auth_account_get_login (_data2_->edit_dialog->acc));
		gtk_list_store_set_value (self->model, &_data2_->iter, 0, (_tmp1_ = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, auth_account_get_login (_data2_->acc)), _tmp0_), &_tmp1_));
		gtk_list_store_set_value (self->model, &_data2_->iter, 1, (_tmp3_ = (g_value_init (&_tmp2_, G_TYPE_STRING), g_value_set_string (&_tmp2_, auth_account_get_service (_data2_->acc)), _tmp2_), &_tmp3_));
		gtk_list_store_set_value (self->model, &_data2_->iter, 2, (_tmp5_ = (g_value_init (&_tmp4_, G_TYPE_STRING), g_value_set_string (&_tmp4_, auth_account_get_proxy (_data2_->acc)), _tmp4_), &_tmp5_));
		hash = (_tmp7_ = g_strconcat (_tmp6_ = g_strconcat (auth_account_get_login (_data2_->acc), auth_account_get_password (_data2_->acc), NULL), auth_account_get_proxy (_data2_->acc), NULL), _g_free0 (_tmp6_), _tmp7_);
		g_signal_emit_by_name (self->priv->accounts, "changed", hash);
		auth_accounts_write (self->priv->accounts);
		g_signal_emit_by_name (self, "setup-menuui");
		_g_free0 (hash);
	}
}


static void __lambda4__gtk_object_destroy (GtkObject* _sender, gpointer self) {
	_lambda4_ (self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	++_data2_->_ref_count_;
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if ((--_data2_->_ref_count_) == 0) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->acc);
		_g_object_unref0 (_data2_->edit_dialog);
		g_slice_free (Block2Data, _data2_);
	}
}


static void account_widget_edit_event (AccountWidget* self) {
	Block2Data* _data2_;
	GtkTreeModel* tmp_model;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp0_ = NULL;
	GValue login = {0};
	GValue service = {0};
	GValue proxy = {0};
	GValue _tmp3_;
	GValue _tmp2_ = {0};
	GValue _tmp5_;
	GValue _tmp4_ = {0};
	GValue _tmp7_;
	GValue _tmp6_ = {0};
	char* _tmp9_;
	char* _tmp8_;
	AuthAccount* _tmp10_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	tmp_model = NULL;
	gtk_tree_selection_get_selected (gtk_tree_view_get_selection (self->priv->table), &_tmp0_, &_data2_->iter);
	tmp_model = (_tmp1_ = _g_object_ref0 (_tmp0_), _g_object_unref0 (tmp_model), _tmp1_);
	gtk_tree_model_get_value (tmp_model, &_data2_->iter, 0, &_tmp2_);
	login = (_tmp3_ = _tmp2_, G_IS_VALUE (&login) ? (g_value_unset (&login), NULL) : NULL, _tmp3_);
	gtk_tree_model_get_value (tmp_model, &_data2_->iter, 1, &_tmp4_);
	service = (_tmp5_ = _tmp4_, G_IS_VALUE (&service) ? (g_value_unset (&service), NULL) : NULL, _tmp5_);
	gtk_tree_model_get_value (tmp_model, &_data2_->iter, 2, &_tmp6_);
	proxy = (_tmp7_ = _tmp6_, G_IS_VALUE (&proxy) ? (g_value_unset (&proxy), NULL) : NULL, _tmp7_);
	_data2_->acc = (_tmp10_ = auth_accounts_get_by_hash (self->priv->accounts, _tmp9_ = g_strconcat (_tmp8_ = g_strconcat (g_value_get_string (&login), g_value_get_string (&service), NULL), g_value_get_string (&proxy), NULL)), _g_free0 (_tmp9_), _g_free0 (_tmp8_), _tmp10_);
	_data2_->edit_dialog = g_object_ref_sink (edit_account_new_with_acc (self->priv->parent, _data2_->acc));
	g_signal_connect_data ((GtkObject*) _data2_->edit_dialog, "destroy", (GCallback) __lambda4__gtk_object_destroy, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_g_object_unref0 (tmp_model);
	G_IS_VALUE (&login) ? (g_value_unset (&login), NULL) : NULL;
	G_IS_VALUE (&service) ? (g_value_unset (&service), NULL) : NULL;
	G_IS_VALUE (&proxy) ? (g_value_unset (&proxy), NULL) : NULL;
	block2_data_unref (_data2_);
}


static void _lambda3_ (Block3Data* _data3_) {
	AccountWidget * self;
	self = _data3_->self;
	if (_data3_->edit_dialog->ok) {
		GtkTreeIter iter = {0};
		auth_accounts_add_account (self->priv->accounts, _data3_->edit_dialog->acc);
		auth_accounts_write (self->priv->accounts);
		gtk_list_store_append (self->model, &iter);
		gtk_list_store_set (self->model, &iter, 0, auth_account_get_login (_data3_->edit_dialog->acc), 1, auth_account_get_service (_data3_->edit_dialog->acc), 2, auth_account_get_proxy (_data3_->edit_dialog->acc), -1);
		gtk_tree_selection_select_iter (gtk_tree_view_get_selection (self->priv->table), &iter);
		g_signal_emit_by_name (self->priv->table, "cursor-changed");
		g_signal_emit_by_name (self, "setup-menuui");
		if (gee_collection_get_size ((GeeCollection*) auth_accounts_get_accounts (self->priv->accounts)) == 1) {
			g_signal_emit_by_name (self->priv->accounts, "active-changed");
		}
	}
}


static void __lambda3__gtk_object_destroy (GtkObject* _sender, gpointer self) {
	_lambda3_ (self);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	++_data3_->_ref_count_;
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if ((--_data3_->_ref_count_) == 0) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->edit_dialog);
		g_slice_free (Block3Data, _data3_);
	}
}


static void account_widget_add_event (AccountWidget* self) {
	Block3Data* _data3_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->edit_dialog = g_object_ref_sink (edit_account_new (self->priv->parent));
	g_signal_connect_data ((GtkObject*) _data3_->edit_dialog, "destroy", (GCallback) __lambda3__gtk_object_destroy, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	block3_data_unref (_data3_);
}


static void account_widget_delete_event (AccountWidget* self) {
	GtkMessageDialog* message_dialog;
	GtkTreeIter iter = {0};
	GtkTreeModel* tmp_model;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp0_ = NULL;
	GValue login = {0};
	GValue service = {0};
	GValue proxy = {0};
	GValue _tmp3_;
	GValue _tmp2_ = {0};
	GValue _tmp5_;
	GValue _tmp4_ = {0};
	GValue _tmp7_;
	GValue _tmp6_ = {0};
	char* _tmp8_;
	char* _tmp9_;
	char* hash;
	AuthAccount* acc;
	gboolean was_active;
	g_return_if_fail (self != NULL);
	message_dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->priv->parent, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _ ("Sure you want to delete this account?")));
	if (gtk_dialog_run ((GtkDialog*) message_dialog) != GTK_RESPONSE_YES) {
		gtk_object_destroy ((GtkObject*) message_dialog);
		_g_object_unref0 (message_dialog);
		return;
	}
	gtk_object_destroy ((GtkObject*) message_dialog);
	tmp_model = NULL;
	gtk_tree_selection_get_selected (gtk_tree_view_get_selection (self->priv->table), &_tmp0_, &iter);
	tmp_model = (_tmp1_ = _g_object_ref0 (_tmp0_), _g_object_unref0 (tmp_model), _tmp1_);
	gtk_tree_model_get_value (tmp_model, &iter, 0, &_tmp2_);
	login = (_tmp3_ = _tmp2_, G_IS_VALUE (&login) ? (g_value_unset (&login), NULL) : NULL, _tmp3_);
	gtk_tree_model_get_value (tmp_model, &iter, 1, &_tmp4_);
	service = (_tmp5_ = _tmp4_, G_IS_VALUE (&service) ? (g_value_unset (&service), NULL) : NULL, _tmp5_);
	gtk_tree_model_get_value (tmp_model, &iter, 2, &_tmp6_);
	proxy = (_tmp7_ = _tmp6_, G_IS_VALUE (&proxy) ? (g_value_unset (&proxy), NULL) : NULL, _tmp7_);
	hash = (_tmp9_ = g_strconcat (_tmp8_ = g_strconcat (g_value_get_string (&login), g_value_get_string (&service), NULL), g_value_get_string (&proxy), NULL), _g_free0 (_tmp8_), _tmp9_);
	acc = auth_accounts_get_by_hash (self->priv->accounts, hash);
	was_active = auth_account_get_active (acc);
	auth_accounts_delete_account (self->priv->accounts, hash);
	auth_accounts_write (self->priv->accounts);
	gtk_list_store_remove (self->model, &iter);
	g_signal_emit_by_name (self, "setup-menuui");
	account_widget_select_first (self);
	if (was_active) {
		g_signal_emit_by_name (self->priv->accounts, "active-changed");
	}
	_g_object_unref0 (message_dialog);
	_g_object_unref0 (tmp_model);
	G_IS_VALUE (&login) ? (g_value_unset (&login), NULL) : NULL;
	G_IS_VALUE (&service) ? (g_value_unset (&service), NULL) : NULL;
	G_IS_VALUE (&proxy) ? (g_value_unset (&proxy), NULL) : NULL;
	_g_free0 (hash);
	_g_object_unref0 (acc);
}


static void account_widget_table_setup (AccountWidget* self) {
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _acc_it;
		_acc_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) auth_accounts_get_accounts (self->priv->accounts));
		while (TRUE) {
			AuthAccount* acc;
			if (!gee_iterator_next (_acc_it)) {
				break;
			}
			acc = (AuthAccount*) gee_iterator_get (_acc_it);
			gtk_list_store_append (self->model, &iter);
			gtk_list_store_set (self->model, &iter, 0, auth_account_get_login (acc), 1, auth_account_get_service (acc), 2, auth_account_get_proxy (acc), -1);
			_g_object_unref0 (acc);
		}
		_g_object_unref0 (_acc_it);
	}
}


static void account_widget_class_init (AccountWidgetClass * klass) {
	account_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AccountWidgetPrivate));
	G_OBJECT_CLASS (klass)->finalize = account_widget_finalize;
	g_signal_new ("setup_menuui", TYPE_ACCOUNT_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void account_widget_instance_init (AccountWidget * self) {
	self->priv = ACCOUNT_WIDGET_GET_PRIVATE (self);
}


static void account_widget_finalize (GObject* obj) {
	AccountWidget * self;
	self = ACCOUNT_WIDGET (obj);
	_g_object_unref0 (self->priv->table);
	_g_object_unref0 (self->priv->add_button);
	_g_object_unref0 (self->priv->edit_button);
	_g_object_unref0 (self->priv->delete_button);
	_g_object_unref0 (self->model);
	_g_object_unref0 (self->priv->parent);
	_g_object_unref0 (self->priv->accounts);
	G_OBJECT_CLASS (account_widget_parent_class)->finalize (obj);
}


GType account_widget_get_type (void) {
	static volatile gsize account_widget_type_id__volatile = 0;
	if (g_once_init_enter (&account_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AccountWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) account_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AccountWidget), 0, (GInstanceInitFunc) account_widget_instance_init, NULL };
		GType account_widget_type_id;
		account_widget_type_id = g_type_register_static (GTK_TYPE_HBOX, "AccountWidget", &g_define_type_info, 0);
		g_once_init_leave (&account_widget_type_id__volatile, account_widget_type_id);
	}
	return account_widget_type_id__volatile;
}




