/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "maintainer_description.h"
#include "maintainer_listingmodel.h"
#include "maintainer_policy.h"
#include "maintainer_record.h"

#include "maintainer_page.h"

MaintainerPage::MaintainerPage()
  : mModel( 0 ), mDescription( 0 ),
    mPolicy( 0 ), mRecord( 0 )
{
}

MaintainerPage::~MaintainerPage()
{
  delete mModel;
  mModel = 0;

  delete mDescription;
  mDescription = 0;

  delete mPolicy;
  mPolicy = 0;

  delete mRecord;
  mRecord = 0;
}

QString MaintainerPage::name() const
{
  return "maintainer";
}

QString MaintainerPage::title() const
{
  return QObject::tr( "Maintainers" );
}

QString MaintainerPage::description() const
{
  return QObject::tr( "Manage maintainers" );
}

QString MaintainerPage::iconName() const
{
  return "maintainer";
}

ListingModel* MaintainerPage::model()
{
  if ( !mModel )
    mModel = new MaintainerListingModel;

  return mModel;
}

Form::Description* MaintainerPage::formDescription()
{
  if ( !mDescription )
    mDescription = new Form::MaintainerDescription;

  return mDescription;
}

Form::PagePolicy* MaintainerPage::formPolicy()
{
  if ( !mPolicy )
    mPolicy = new Form::MaintainerPolicy;

  return mPolicy;
}

Form::Record* MaintainerPage::formRecord()
{
  if ( !mRecord )
    mRecord = new Form::MaintainerRecord;

  return mRecord;
}
