/*
 * Copyright (C) 2020 The HIME team, Taiwan
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation version 2.1
 * of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef HIME_CONF_H
#define HIME_CONF_H

#define CHANGE_FONT_SIZE "change font size"
#define GB_OUTPUT_TOGGLE "gb output toggle"
#define SIM_OUTPUT_TOGGLE "gb output sim"
#define TRAD_OUTPUT_TOGGLE "gb output trad"
#define KBM_TOGGLE "kbm toggle"
#define UPDATE_TRAY "update tray"
#define RELOAD_TSIN_DB "reload tsin db"
#define HIME_EXIT_MESSAGE "hime exit"

#define HIME_SETUP_WINDOW_TYPE_UTILITY "hime-setup-window-type-utility"
#define HIME_FONT_SIZE "hime-font-size"
#define HIME_FONT_NAME "hime-font-name"
#define HIME_FONT_SIZE_TSIN_PRESEL "hime-font-size-tsin-presel"
#define HIME_FONT_SIZE_SYMBOL "hime-font-size-symbol"
#define HIME_FONT_SIZE_TSIN_PHO_IN "hime-font-size-tsin-pho-in"
#define HIME_FONT_SIZE_GTAB_IN "hime-font-size-gtab-in"
#define HIME_FONT_SIZE_PHO_NEAR "hime-font-size-pho-near"
#define HIME_FONT_SIZE_WIN_KBM "hime-font-size-win-kbm"
#define HIME_FONT_SIZE_WIN_KBM_EN "hime-font-size-win-kbm-en"
#define HIME_INPUT_STYLE "hime-input-style"
#define HIME_ROOT_X "hime-root-x"
#define HIME_ROOT_Y "hime-root-y"
#define HIME_POP_UP_WIN "hime-pop-up-win"
#define HIME_ICON_DIR "hime-icon-dir"
#define HIME_INNER_FRAME "hime-inner-frame"
#define HIME_INIT_IM_ENABLED "hime-init-im-enabled"
#define HIME_INIT_FULL_MODE "hime-init-full-mode"
#define HIME_BELL_VOLUME "hime-bell-volume"
#define HIME_SOUND_PLAY_OVERLAP "hime-sound-play-overlap"
#define HIME_ENABLE_CTRL_ALT_SWITCH "hime-enable-ctrl-alt-switch"
#define HIME_EDIT_DISPLAY "hime-edit-display"
#define HIME_BELL_OFF "hime-bell-off"
#define HIME_ON_THE_SPOT_KEY "hime-on-the-spot-key"
#define HIME_TRAY_HF_WIN_KBM "hime-tray-hf-win-kbm"
#define HIME_SINGLE_STATE "hime-single-state"
#define HIME_PUNC_AUTO_SEND "hime-punc-auto-send"

#define HIME_IM_TOGGLE_KEYS "hime-im-toggle-keys"
#define HIME_CHINESE_ENGLISH_TOGGLE_KEY "hime-chinese-english-toggle-key"
#define DEFAULT_INPUT_METHOD "default-input-method"
// #define LEFT_RIGHT_BUTTON_TIPS "left-right-button-tips"
#define HIME_STR_IM_CYCLE "hime-str-im-cycle"
#define HIME_REMOTE_CLIENT "hime-remote-client"
#define HIME_SHIFT_SPACE_ENG_FULL "hime-shift-space-eng-full"
#define HIME_STATUS_TRAY "hime-status-tray"
#define HIME_WIN_COLOR_FG "hime-win-color-fg"
#define HIME_WIN_COLOR_BG "hime-win-color-bg"
#define HIME_USE_CUSTOM_THEME "hime-use-custom-theme"
#define HIME_CAPSLOCK_LOWER "hime-capslock-lower"
#define HIME_ENG_PHRASE_ENABLED "hime-eng-phrase-enabled"
#define HIME_WIN_SYM_CLICK_CLOSE "hime-win-sym-click-close"
#define HIME_SEL_KEY_COLOR "hime-sel-key-color"
#define HIME_CURSOR_COLOR "hime-cursor-color"
#define HIME_TRAY_DISPLAY "hime-tray-display"

#define GTAB_DUP_SELECT_BELL "gtab-dup-select-bell"
#define GTAB_SPACE_AUTO_FIRST "gtab-space-auto-first"
#define GTAB_AUTO_SELECT_BY_PHRASE "gtab-auto-select-by_phrase"
#define GTAB_PRE_SELECT "gtab-pre-select"
#define GTAB_PHRASE_PRE_SELECT "gtab-phrase-pre-select"
#define GTAB_PRESS_FULL_AUTO_SEND "gtab-press-full-auto-send"
#define GTAB_DISP_PARTIAL_MATCH "gtab-disp-partial-match"
#define GTAB_DISP_KEY_CODES "gtab-disp-key-codes"
#define GTAB_DISP_IM_NAME "gtab-disp-im-name"
#define GTAB_INVALID_KEY_IN "gtab-invalid-key-in"
#define GTAB_SHIFT_PHRASE_KEY "gtab-shift-phrase-key"
#define GTAB_HIDE_ROW2 "gtab-hide-row2"
#define GTAB_IN_ROW1 "gtab-in-row1"
#define GTAB_VERTICAL_SELECT "gtab-vertical-select"
#define GTAB_UNIQUE_AUTO_SEND "gtab-unique-auto-send"
#define GTAB_QUE_WILD_CARD "gtab-que-wild-card"
#define GTAB_QUE_WILD_CARD_ASTERISK "gtab-que-wild-card-asterisk"
#define GTAB_PHO_QUERY "gtab-pho-query"
#define GTAB_PHRASE_PRE_SELECT "gtab-phrase-pre-select"
#define GTAB_IN_AREA_BUTTON "gtab-in-area-button"

#define TSIN_PHRASE_PRE_SELECT "tsin-phrase-pre-select"
#define TSIN_SPACE_OPT "tsin-space-opt"
#define TSIN_BUFFER_SIZE "tsin-buffer-size"
#define TSIN_PHRASE_LINE_COLOR "tsin-phrase-line-color"
#define TSIN_TONE_CHAR_INPUT "tsin-tone-char-input"
#define TSIN_TAB_PHRASE_END "tsin-tab-phrase-end"
#define TSIN_TAIL_SELECT_KEY "tsin-tail-select-key"
#define TSIN_BUFFER_EDITING_MODE "tsin-buffer-editing-mode"
#define TSIN_USE_PHO_NEAR "tsin-use-pho-near"

#define PHO_HIDE_ROW2 "pho-hide-row2"
#define PHO_IN_ROW1 "pho-in-row1"

#define PHONETIC_KEYBOARD "phonetic-keyboard2"
#define PHONETIC_KEYBOARD_BAK "phonetic-keyboard-bak"

#define PHONETIC_CHAR_DYNAMIC_SEQUENCE "phonetic-char-dynamic-sequence"
#define PHONETIC_HUGE_TAB "phonetic-huge-tab"
#define PHONETIC_SPEAK "phonetic-speak"
#define PHONETIC_SPEAK_SEL "phonetic-speak-sel"

extern int hime_setup_window_type_utility,
    hime_font_size, hime_font_size_tsin_presel, hime_font_size_symbol,
    hime_font_size_tsin_pho_in, hime_font_size_pho_near,
    hime_font_size_gtab_in, hime_font_size_win_kbm, hime_font_size_win_kbm_en,
    hime_inner_frame, hime_single_state,
    hime_remote_client,
    gtab_disp_key_codes, gtab_disp_im_name, hime_shift_space_eng_full,
    gtab_invalid_key_in, gtab_hide_row2, gtab_in_row1,
    hime_capslock_lower, pho_hide_row2, pho_in_row1,
    hime_eng_phrase_enabled, hime_win_sym_click_close,
    gtab_que_wild_card, gtab_que_wild_card_asterisk, gtab_pho_query,
    hime_bell_volume, hime_sound_play_overlap, hime_enable_ctrl_alt_switch, hime_on_the_spot_key;

extern int default_input_method;
// extern int left_right_button_tips;
extern int gtab_dup_select_bell;
extern int gtab_space_auto_first;
extern int gtab_auto_select_by_phrase;
extern int hime_im_toggle_keys;
extern int hime_chinese_english_toggle_key;
extern int gtab_pre_select, gtab_phrase_pre_select;
extern int gtab_press_full_auto_send;
extern int gtab_disp_partial_match;
extern int gtab_shift_phrase_key, gtab_in_area_button;
extern int gtab_vertical_select, gtab_unique_auto_send;
extern int tsin_buffer_size;
extern int hime_input_style, hime_root_x, hime_root_y, hime_pop_up_win;
extern int hime_status_tray, hime_show_win_kbm, hime_tray_hf_win_kbm;
extern int hime_punc_auto_send;

extern int tsin_phrase_pre_select;
extern int tsin_tab_phrase_end, tsin_tail_select_key;
extern int tsin_buffer_editing_mode;
extern int tsin_use_pho_near;

extern int phonetic_char_dynamic_sequence;
extern int phonetic_huge_tab, phonetic_speak;
extern char *phonetic_speak_sel;
extern int tsin_space_opt, tsin_tone_char_input;

extern char *tsin_phrase_line_color, *hime_cursor_color, *hime_font_name, *hime_sel_key_color, *hime_icon_dir;
extern unich_t eng_full_str[], eng_half_str[], cht_full_str[];
extern char *eng_color_full_str, *eng_color_half_str, *cht_color_full_str;
extern char *hime_win_color_fg, *hime_win_color_bg;
extern int hime_use_custom_theme, hime_bell_off;
extern int hime_init_im_enabled, hime_init_full_mode;
extern int hime_edit_display, hime_tray_display;
extern char *pho_kbm_name, *pho_selkey, *hime_str_im_cycle;
extern int pho_candidate_col_N, pho_candidate_R2L;

// hime-conf.c
void init_TableDir (void);
void get_hime_dir (char *tt);
void init_omni_config (void);
void free_omni_config (void);
void save_omni_config (void);
gboolean get_hime_user_fname (char *name, char fname[]);
void get_hime_conf_fname (char *name, char fname[]);
void get_hime_user_or_sys_fname (char *name, char fname[]);
void get_hime_conf_str (char *name, char **rstr, char *default_str);
void get_hime_conf_fstr (char *name, char rstr[], char *default_str);
int get_hime_conf_int (char *name, int default_value);
void save_hime_conf_str (char *name, char *str);
void save_hime_conf_int (char *name, int val);
void get_sys_table_file_name (char *name, char *fname);
char *get_hime_xim_name (void);
Atom get_hime_atom (Display *display);

#endif /* HIME_CONF_H */
