/* plugin.c generated by valac 0.16.1, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <fsodevice.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <fsobasics.h>
#include <sys/inotify.h>
#include <freesmartphone.h>
#include <fsoframework.h>


#define ROUTER_TYPE_LIB_ALSA (router_lib_alsa_get_type ())
#define ROUTER_LIB_ALSA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ROUTER_TYPE_LIB_ALSA, RouterLibAlsa))
#define ROUTER_LIB_ALSA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ROUTER_TYPE_LIB_ALSA, RouterLibAlsaClass))
#define ROUTER_IS_LIB_ALSA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ROUTER_TYPE_LIB_ALSA))
#define ROUTER_IS_LIB_ALSA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ROUTER_TYPE_LIB_ALSA))
#define ROUTER_LIB_ALSA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ROUTER_TYPE_LIB_ALSA, RouterLibAlsaClass))

typedef struct _RouterLibAlsa RouterLibAlsa;
typedef struct _RouterLibAlsaClass RouterLibAlsaClass;
typedef struct _RouterLibAlsaPrivate RouterLibAlsaPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_queue_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__g_free0_ (var), NULL)))
#define _fso_device_mixer_control_unref0(var) ((var == NULL) ? NULL : (var = (fso_device_mixer_control_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _fso_device_bunch_of_mixer_controls_unref0(var) ((var == NULL) ? NULL : (var = (fso_device_bunch_of_mixer_controls_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

struct _RouterLibAlsa {
	FsoDeviceBaseAudioRouter parent_instance;
	RouterLibAlsaPrivate * priv;
};

struct _RouterLibAlsaClass {
	FsoDeviceBaseAudioRouterClass parent_class;
};

struct _RouterLibAlsaPrivate {
	FsoDeviceSoundDevice* device;
	GeeHashMap* allscenarios;
	gchar* currentscenario;
	GQueue* scenarios;
	gchar* configurationPath;
	gchar* dataPath;
};


static gpointer router_lib_alsa_parent_class = NULL;
static GType router_lib_alsa_type_id = 0;

GType router_lib_alsa_get_type (void) G_GNUC_CONST;
GType router_lib_alsa_register_type (GTypeModule * module);
#define ROUTER_LIB_ALSA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ROUTER_TYPE_LIB_ALSA, RouterLibAlsaPrivate))
enum  {
	ROUTER_LIB_ALSA_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
static void _g_queue_free__g_free0_ (GQueue* self);
#define ROUTER_LIB_ALSA_MODULE_NAME "fsodevice.router_alsa"
static void router_lib_alsa_addScenario (RouterLibAlsa* self, const gchar* scenario, GFile* file, guint idxMainVolume);
static void _vala_array_add1 (FsoDeviceMixerControl*** array, int* length, int* size, FsoDeviceMixerControl* value);
static void router_lib_alsa_initScenarios (RouterLibAlsa* self);
static void router_lib_alsa_onModifiedScenario (RouterLibAlsa* self, int flags, guint32 cookie, const gchar* name);
static void _router_lib_alsa_onModifiedScenario_fso_framework_inotify_notifier_func (int flags, guint32 cookie, const gchar* name, gpointer self);
static void _g_list_free__g_free0_ (GList* self);
static void router_lib_alsa_updateScenarioIfChanged (RouterLibAlsa* self, const gchar* scenario);
static gboolean router_lib_alsa_real_isScenarioAvailable (FsoDeviceBaseAudioRouter* base, const gchar* scenario);
static gchar** router_lib_alsa_real_availableScenarios (FsoDeviceBaseAudioRouter* base, int* result_length1);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static gchar* router_lib_alsa_real_currentScenario (FsoDeviceBaseAudioRouter* base);
static gchar* router_lib_alsa_real_pullScenario (FsoDeviceBaseAudioRouter* base, GError** error);
static void router_lib_alsa_real_pushScenario (FsoDeviceBaseAudioRouter* base, const gchar* scenario);
static void router_lib_alsa_real_setScenario (FsoDeviceBaseAudioRouter* base, const gchar* scenario);
static void router_lib_alsa_real_saveScenario (FsoDeviceBaseAudioRouter* base, const gchar* scenario, GError** error);
static guint8 router_lib_alsa_real_currentVolume (FsoDeviceBaseAudioRouter* base, GError** error);
static void router_lib_alsa_real_setVolume (FsoDeviceBaseAudioRouter* base, guint8 volume, GError** error);
static gchar* router_lib_alsa_real_repr (FsoFrameworkAbstractObject* base);
RouterLibAlsa* router_lib_alsa_new (void);
RouterLibAlsa* router_lib_alsa_construct (GType object_type);
static GObject * router_lib_alsa_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void router_lib_alsa_finalize (GObject* obj);
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error);
void fso_register_function (GTypeModule* module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_queue_free__g_free0_ (GQueue* self) {
	g_queue_foreach (self, (GFunc) _g_free0_, NULL);
	g_queue_free (self);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gpointer _fso_device_mixer_control_ref0 (gpointer self) {
	return self ? fso_device_mixer_control_ref (self) : NULL;
}


static void _vala_array_add1 (FsoDeviceMixerControl*** array, int* length, int* size, FsoDeviceMixerControl* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FsoDeviceMixerControl*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void router_lib_alsa_addScenario (RouterLibAlsa* self, const gchar* scenario, GFile* file, guint idxMainVolume) {
	FsoDeviceMixerControl** _tmp0_ = NULL;
	FsoDeviceMixerControl** controls;
	gint controls_length1;
	gint _controls_size_;
	gint line_count;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scenario != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_new0 (FsoDeviceMixerControl*, 0 + 1);
	controls = _tmp0_;
	controls_length1 = 0;
	_controls_size_ = controls_length1;
	line_count = 0;
	{
		GFile* _tmp1_;
		GFileInputStream* _tmp2_ = NULL;
		GFileInputStream* _tmp3_;
		GFileInputStream* _tmp4_;
		GDataInputStream* _tmp5_;
		GDataInputStream* _tmp6_;
		GDataInputStream* in_stream;
		gchar* line = NULL;
		FsoFrameworkLogger* _tmp37_;
		const gchar* _tmp38_;
		GFile* _tmp39_;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_;
		FsoDeviceMixerControl** _tmp44_;
		gint _tmp44__length1;
		guint _tmp45_;
		FsoDeviceBunchOfMixerControls* _tmp46_;
		FsoDeviceBunchOfMixerControls* bunch;
		GeeHashMap* _tmp47_;
		const gchar* _tmp48_;
		FsoDeviceBunchOfMixerControls* _tmp49_;
		_tmp1_ = file;
		_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp3_;
		_tmp5_ = g_data_input_stream_new ((GInputStream*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		in_stream = _tmp6_;
		while (TRUE) {
			GDataInputStream* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_ = NULL;
			gchar* stripped;
			gboolean _tmp14_ = FALSE;
			const gchar* _tmp15_;
			gboolean _tmp18_;
			_tmp7_ = in_stream;
			_tmp8_ = g_data_input_stream_read_line (_tmp7_, NULL, NULL, &_inner_error_);
			_tmp9_ = _tmp8_;
			if (_inner_error_ != NULL) {
				_g_free0 (line);
				_g_object_unref0 (in_stream);
				goto __catch0_g_error;
			}
			_g_free0 (line);
			line = _tmp9_;
			_tmp10_ = line;
			if (!(_tmp10_ != NULL)) {
				break;
			}
			_tmp11_ = line_count;
			line_count = _tmp11_ + 1;
			_tmp12_ = line;
			_tmp13_ = string_strip (_tmp12_);
			stripped = _tmp13_;
			_tmp15_ = stripped;
			if (g_strcmp0 (_tmp15_, "") == 0) {
				_tmp14_ = TRUE;
			} else {
				const gchar* _tmp16_;
				gboolean _tmp17_ = FALSE;
				_tmp16_ = stripped;
				_tmp17_ = g_str_has_prefix (_tmp16_, "#");
				_tmp14_ = _tmp17_;
			}
			_tmp18_ = _tmp14_;
			if (_tmp18_) {
				_g_free0 (stripped);
				continue;
			}
			{
				FsoDeviceSoundDevice* _tmp19_;
				const gchar* _tmp20_;
				FsoDeviceMixerControl* _tmp21_ = NULL;
				FsoDeviceMixerControl* control;
				FsoDeviceMixerControl** _tmp22_;
				gint _tmp22__length1;
				FsoDeviceMixerControl* _tmp23_;
				FsoDeviceMixerControl* _tmp24_;
				_tmp19_ = self->priv->device;
				_tmp20_ = line;
				_tmp21_ = fso_device_sound_device_controlForString (_tmp19_, _tmp20_, &_inner_error_);
				control = _tmp21_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
						goto __catch1_fso_device_sound_error;
					}
					_g_free0 (stripped);
					_g_free0 (line);
					_g_object_unref0 (in_stream);
					controls = (_vala_array_free (controls, controls_length1, (GDestroyNotify) fso_device_mixer_control_unref), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp22_ = controls;
				_tmp22__length1 = controls_length1;
				_tmp23_ = control;
				_tmp24_ = _fso_device_mixer_control_ref0 (_tmp23_);
				_vala_array_add1 (&controls, &controls_length1, &_controls_size_, _tmp24_);
				_fso_device_mixer_control_unref0 (control);
			}
			goto __finally1;
			__catch1_fso_device_sound_error:
			{
				GError* e = NULL;
				FsoFrameworkLogger* _tmp25_;
				gint _tmp26_;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_ = NULL;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_;
				FsoFrameworkLogger* _tmp33_;
				GError* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp25_ = ((FsoFrameworkAbstractObject*) self)->logger;
				_tmp26_ = line_count;
				_tmp27_ = g_strdup_printf ("%i", _tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = scenario;
				_tmp30_ = string_to_string (_tmp29_);
				_tmp31_ = g_strconcat ("Got error while parsing line ", _tmp28_, " of scenario ", _tmp30_, ":", NULL);
				_tmp32_ = _tmp31_;
				fso_framework_logger_error (_tmp25_, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp28_);
				_tmp33_ = ((FsoFrameworkAbstractObject*) self)->logger;
				_tmp34_ = e;
				_tmp35_ = _tmp34_->message;
				_tmp36_ = string_to_string (_tmp35_);
				fso_framework_logger_error (_tmp33_, _tmp36_);
				_g_error_free0 (e);
			}
			__finally1:
			if (_inner_error_ != NULL) {
				_g_free0 (stripped);
				_g_free0 (line);
				_g_object_unref0 (in_stream);
				goto __catch0_g_error;
			}
			_g_free0 (stripped);
		}
		_tmp37_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp38_ = scenario;
		_tmp39_ = file;
		_tmp40_ = g_file_get_path (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_strdup_printf ("Scenario %s successfully read from file %s", _tmp38_, _tmp41_);
		_tmp43_ = _tmp42_;
		fso_framework_logger_debug (_tmp37_, _tmp43_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp41_);
		_tmp44_ = controls;
		_tmp44__length1 = controls_length1;
		_tmp45_ = idxMainVolume;
		_tmp46_ = fso_device_bunch_of_mixer_controls_new (_tmp44_, _tmp44__length1, _tmp45_);
		bunch = _tmp46_;
		_tmp47_ = self->priv->allscenarios;
		_tmp48_ = scenario;
		_tmp49_ = bunch;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp47_, _tmp48_, _tmp49_);
		_fso_device_bunch_of_mixer_controls_unref0 (bunch);
		_g_free0 (line);
		_g_object_unref0 (in_stream);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FsoFrameworkLogger* _tmp50_;
		GError* _tmp51_;
		const gchar* _tmp52_;
		const gchar* _tmp53_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp50_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp51_ = e;
		_tmp52_ = _tmp51_->message;
		_tmp53_ = string_to_string (_tmp52_);
		fso_framework_logger_warning (_tmp50_, _tmp53_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		controls = (_vala_array_free (controls, controls_length1, (GDestroyNotify) fso_device_mixer_control_unref), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	controls = (_vala_array_free (controls, controls_length1, (GDestroyNotify) fso_device_mixer_control_unref), NULL);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _router_lib_alsa_onModifiedScenario_fso_framework_inotify_notifier_func (int flags, guint32 cookie, const gchar* name, gpointer self) {
	router_lib_alsa_onModifiedScenario (self, flags, cookie, name);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void router_lib_alsa_initScenarios (RouterLibAlsa* self) {
	FsoFrameworkSmartKeyFile* _tmp0_;
	FsoFrameworkSmartKeyFile* _tmp1_;
	FsoFrameworkSmartKeyFile* config;
	FsoFrameworkSmartKeyFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* extra_path;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GQueue* _tmp11_;
	GeeHashMap* _tmp12_;
	gchar* _tmp13_;
	FsoFrameworkSmartKeyFile* _tmp14_;
	FsoFrameworkSmartKeyFile* alsaconf;
	FsoFrameworkSmartKeyFile* _tmp15_;
	const gchar* _tmp16_;
	gboolean _tmp17_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = fso_framework_theConfig;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	config = _tmp1_;
	_tmp2_ = config;
	_tmp3_ = fso_framework_smart_key_file_stringValue (_tmp2_, ROUTER_LIB_ALSA_MODULE_NAME, "extra_path", "");
	extra_path = _tmp3_;
	_tmp4_ = fso_framework_utility_machineConfigurationDir ();
	_tmp5_ = _tmp4_;
	_tmp6_ = extra_path;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = g_strconcat ("/", _tmp7_, "/alsa.conf", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp5_, _tmp9_, NULL);
	_g_free0 (self->priv->configurationPath);
	self->priv->configurationPath = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp5_);
	_tmp11_ = g_queue_new ();
	__g_queue_free__g_free0_0 (self->priv->scenarios);
	self->priv->scenarios = _tmp11_;
	_tmp12_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FSO_DEVICE_TYPE_BUNCH_OF_MIXER_CONTROLS, (GBoxedCopyFunc) fso_device_bunch_of_mixer_controls_ref, fso_device_bunch_of_mixer_controls_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->allscenarios);
	self->priv->allscenarios = _tmp12_;
	_tmp13_ = g_strdup ("unknown");
	_g_free0 (self->priv->currentscenario);
	self->priv->currentscenario = _tmp13_;
	_tmp14_ = fso_framework_smart_key_file_new ();
	alsaconf = _tmp14_;
	_tmp15_ = alsaconf;
	_tmp16_ = self->priv->configurationPath;
	_tmp17_ = fso_framework_smart_key_file_loadFromFile (_tmp15_, _tmp16_);
	if (_tmp17_) {
		FsoFrameworkSmartKeyFile* _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* soundcard;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		gchar* _tmp28_;
		FsoFrameworkSmartKeyFile* _tmp38_;
		gchar* _tmp39_ = NULL;
		gchar* defaultscenario;
		FsoFrameworkSmartKeyFile* _tmp40_;
		GList* _tmp41_ = NULL;
		GList* sections;
		GList* _tmp42_;
		GeeHashMap* _tmp78_;
		const gchar* _tmp79_;
		gboolean _tmp80_ = FALSE;
		const gchar* _tmp83_;
		_tmp18_ = alsaconf;
		_tmp19_ = fso_framework_smart_key_file_stringValue (_tmp18_, "alsa", "cardname", "default");
		soundcard = _tmp19_;
		_tmp20_ = fso_framework_utility_machineConfigurationDir ();
		_tmp21_ = _tmp20_;
		_tmp22_ = extra_path;
		_tmp23_ = string_to_string (_tmp22_);
		_tmp24_ = soundcard;
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = g_strconcat ("/", _tmp23_, "/alsa-", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp21_, _tmp27_, NULL);
		_g_free0 (self->priv->dataPath);
		self->priv->dataPath = _tmp28_;
		_g_free0 (_tmp27_);
		_g_free0 (_tmp21_);
		{
			const gchar* _tmp29_;
			FsoDeviceSoundDevice* _tmp30_ = NULL;
			FsoDeviceSoundDevice* _tmp31_;
			_tmp29_ = soundcard;
			_tmp30_ = fso_device_sound_device_create (_tmp29_, &_inner_error_);
			_tmp31_ = _tmp30_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
					goto __catch2_fso_device_sound_error;
				}
				_g_free0 (soundcard);
				_g_object_unref0 (alsaconf);
				_g_free0 (extra_path);
				_g_object_unref0 (config);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (self->priv->device);
			self->priv->device = _tmp31_;
		}
		goto __finally2;
		__catch2_fso_device_sound_error:
		{
			GError* e = NULL;
			FsoFrameworkLogger* _tmp32_;
			GError* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp32_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp33_ = e;
			_tmp34_ = _tmp33_->message;
			_tmp35_ = string_to_string (_tmp34_);
			_tmp36_ = g_strconcat ("Sound card problem: ", _tmp35_, NULL);
			_tmp37_ = _tmp36_;
			fso_framework_logger_warning (_tmp32_, _tmp37_);
			_g_free0 (_tmp37_);
			_g_error_free0 (e);
			_g_free0 (soundcard);
			_g_object_unref0 (alsaconf);
			_g_free0 (extra_path);
			_g_object_unref0 (config);
			return;
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_free0 (soundcard);
			_g_object_unref0 (alsaconf);
			_g_free0 (extra_path);
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp38_ = alsaconf;
		_tmp39_ = fso_framework_smart_key_file_stringValue (_tmp38_, "alsa", "default_scenario", "stereoout");
		defaultscenario = _tmp39_;
		_tmp40_ = alsaconf;
		_tmp41_ = fso_framework_smart_key_file_sectionsWithPrefix (_tmp40_, "scenario.");
		sections = _tmp41_;
		_tmp42_ = sections;
		{
			GList* section_collection = NULL;
			GList* section_it = NULL;
			section_collection = _tmp42_;
			for (section_it = section_collection; section_it != NULL; section_it = section_it->next) {
				gchar* _tmp43_;
				gchar* section = NULL;
				_tmp43_ = g_strdup ((const gchar*) section_it->data);
				section = _tmp43_;
				{
					const gchar* _tmp44_;
					gchar** _tmp45_;
					gchar** _tmp46_ = NULL;
					gchar** _tmp47_;
					gint _tmp47__length1;
					const gchar* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					gchar* scenario;
					const gchar* _tmp51_;
					_tmp44_ = section;
					_tmp46_ = _tmp45_ = g_strsplit (_tmp44_, ".", 0);
					_tmp47_ = _tmp46_;
					_tmp47__length1 = _vala_array_length (_tmp45_);
					_tmp48_ = _tmp47_[1];
					_tmp49_ = g_strdup (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp47_ = (_vala_array_free (_tmp47_, _tmp47__length1, (GDestroyNotify) g_free), NULL);
					scenario = _tmp50_;
					_tmp51_ = scenario;
					if (g_strcmp0 (_tmp51_, "") != 0) {
						FsoFrameworkSmartKeyFile* _tmp52_;
						const gchar* _tmp53_;
						gint _tmp54_ = 0;
						gint idxMainVolume;
						FsoFrameworkLogger* _tmp55_;
						const gchar* _tmp56_;
						gint _tmp57_;
						gchar* _tmp58_ = NULL;
						gchar* _tmp59_;
						const gchar* _tmp60_;
						const gchar* _tmp61_;
						gchar* _tmp62_ = NULL;
						gchar* _tmp63_;
						GFile* _tmp64_ = NULL;
						GFile* _tmp65_;
						GFile* file;
						GFile* _tmp66_;
						gboolean _tmp67_ = FALSE;
						_tmp52_ = alsaconf;
						_tmp53_ = section;
						_tmp54_ = fso_framework_smart_key_file_intValue (_tmp52_, _tmp53_, "main_volume", 0);
						idxMainVolume = _tmp54_;
						_tmp55_ = ((FsoFrameworkAbstractObject*) self)->logger;
						_tmp56_ = scenario;
						_tmp57_ = idxMainVolume;
						_tmp58_ = g_strdup_printf ("Found scenario '%s' - main volume = %d", _tmp56_, _tmp57_);
						_tmp59_ = _tmp58_;
						fso_framework_logger_debug (_tmp55_, _tmp59_);
						_g_free0 (_tmp59_);
						_tmp60_ = self->priv->dataPath;
						_tmp61_ = scenario;
						_tmp62_ = g_build_filename (_tmp60_, _tmp61_, NULL);
						_tmp63_ = _tmp62_;
						_tmp64_ = g_file_new_for_path (_tmp63_);
						_tmp65_ = _tmp64_;
						_g_free0 (_tmp63_);
						file = _tmp65_;
						_tmp66_ = file;
						_tmp67_ = g_file_query_exists (_tmp66_, NULL);
						if (!_tmp67_) {
							FsoFrameworkLogger* _tmp68_;
							GFile* _tmp69_;
							gchar* _tmp70_ = NULL;
							gchar* _tmp71_;
							const gchar* _tmp72_ = NULL;
							gchar* _tmp73_ = NULL;
							gchar* _tmp74_;
							_tmp68_ = ((FsoFrameworkAbstractObject*) self)->logger;
							_tmp69_ = file;
							_tmp70_ = g_file_get_path (_tmp69_);
							_tmp71_ = _tmp70_;
							_tmp72_ = string_to_string (_tmp71_);
							_tmp73_ = g_strconcat ("Scenario file ", _tmp72_, " doesn't exist. Ignoring.", NULL);
							_tmp74_ = _tmp73_;
							fso_framework_logger_warning (_tmp68_, _tmp74_);
							_g_free0 (_tmp74_);
							_g_free0 (_tmp71_);
						} else {
							const gchar* _tmp75_;
							GFile* _tmp76_;
							gint _tmp77_;
							_tmp75_ = scenario;
							_tmp76_ = file;
							_tmp77_ = idxMainVolume;
							router_lib_alsa_addScenario (self, _tmp75_, _tmp76_, (guint) _tmp77_);
						}
						_g_object_unref0 (file);
					}
					_g_free0 (scenario);
					_g_free0 (section);
				}
			}
		}
		_tmp78_ = self->priv->allscenarios;
		_tmp79_ = defaultscenario;
		_tmp80_ = gee_map_contains ((GeeMap*) _tmp78_, _tmp79_);
		if (_tmp80_) {
			const gchar* _tmp81_;
			_tmp81_ = defaultscenario;
			fso_device_base_audio_router_pushScenario ((FsoDeviceBaseAudioRouter*) self, _tmp81_);
		} else {
			FsoFrameworkLogger* _tmp82_;
			_tmp82_ = ((FsoFrameworkAbstractObject*) self)->logger;
			fso_framework_logger_warning (_tmp82_, "Default scenario not found; can't push it to scenario stack");
		}
		_tmp83_ = self->priv->dataPath;
		fso_framework_inotifier_add (_tmp83_, IN_MODIFY, _router_lib_alsa_onModifiedScenario_fso_framework_inotify_notifier_func, self);
		__g_list_free__g_free0_0 (sections);
		_g_free0 (defaultscenario);
		_g_free0 (soundcard);
	} else {
		FsoFrameworkLogger* _tmp84_;
		const gchar* _tmp85_;
		const gchar* _tmp86_ = NULL;
		gchar* _tmp87_ = NULL;
		gchar* _tmp88_;
		_tmp84_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp85_ = self->priv->configurationPath;
		_tmp86_ = string_to_string (_tmp85_);
		_tmp87_ = g_strconcat ("Could not load ", _tmp86_, ". No scenarios available.", NULL);
		_tmp88_ = _tmp87_;
		fso_framework_logger_warning (_tmp84_, _tmp88_);
		_g_free0 (_tmp88_);
		{
			FsoDeviceSoundDevice* _tmp89_ = NULL;
			FsoDeviceSoundDevice* _tmp90_;
			FsoDeviceSoundDevice* _tmp91_;
			gint _tmp92_ = 0;
			FsoDeviceMixerControl** _tmp93_ = NULL;
			FsoDeviceMixerControl** _tmp94_;
			gint _tmp94__length1;
			gint __tmp94__size_;
			FsoDeviceMixerControl** _tmp95_;
			gint _tmp95__length1;
			FsoDeviceBunchOfMixerControls* _tmp96_;
			FsoDeviceBunchOfMixerControls* _tmp97_;
			FsoDeviceBunchOfMixerControls* bunch;
			GeeHashMap* _tmp98_;
			FsoDeviceBunchOfMixerControls* _tmp99_;
			gchar* _tmp100_;
			_tmp89_ = fso_device_sound_device_create ("default", &_inner_error_);
			_tmp90_ = _tmp89_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
					goto __catch3_fso_device_sound_error;
				}
				_g_object_unref0 (alsaconf);
				_g_free0 (extra_path);
				_g_object_unref0 (config);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (self->priv->device);
			self->priv->device = _tmp90_;
			_tmp91_ = self->priv->device;
			_tmp93_ = fso_device_sound_device_allMixerControls (_tmp91_, &_tmp92_, &_inner_error_);
			_tmp94_ = _tmp93_;
			_tmp94__length1 = _tmp92_;
			__tmp94__size_ = _tmp94__length1;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
					goto __catch3_fso_device_sound_error;
				}
				_g_object_unref0 (alsaconf);
				_g_free0 (extra_path);
				_g_object_unref0 (config);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp95_ = _tmp94_;
			_tmp95__length1 = _tmp94__length1;
			_tmp96_ = fso_device_bunch_of_mixer_controls_new (_tmp95_, _tmp94__length1, (guint) 0);
			_tmp97_ = _tmp96_;
			_tmp95_ = (_vala_array_free (_tmp95_, _tmp95__length1, (GDestroyNotify) fso_device_mixer_control_unref), NULL);
			bunch = _tmp97_;
			_tmp98_ = self->priv->allscenarios;
			_tmp99_ = bunch;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp98_, "current", _tmp99_);
			_tmp100_ = g_strdup ("current");
			_g_free0 (self->priv->currentscenario);
			self->priv->currentscenario = _tmp100_;
			_fso_device_bunch_of_mixer_controls_unref0 (bunch);
		}
		goto __finally3;
		__catch3_fso_device_sound_error:
		{
			GError* e = NULL;
			FsoFrameworkLogger* _tmp101_;
			GError* _tmp102_;
			const gchar* _tmp103_;
			const gchar* _tmp104_ = NULL;
			gchar* _tmp105_ = NULL;
			gchar* _tmp106_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp101_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp102_ = e;
			_tmp103_ = _tmp102_->message;
			_tmp104_ = string_to_string (_tmp103_);
			_tmp105_ = g_strconcat ("Sound card or mixer problem: ", _tmp104_, NULL);
			_tmp106_ = _tmp105_;
			fso_framework_logger_warning (_tmp101_, _tmp106_);
			_g_free0 (_tmp106_);
			_g_error_free0 (e);
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (alsaconf);
			_g_free0 (extra_path);
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (alsaconf);
	_g_free0 (extra_path);
	_g_object_unref0 (config);
}


static void router_lib_alsa_updateScenarioIfChanged (RouterLibAlsa* self, const gchar* scenario) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scenario != NULL);
	_tmp0_ = self->priv->currentscenario;
	_tmp1_ = scenario;
	if (g_strcmp0 (_tmp0_, _tmp1_) != 0) {
		FsoDeviceSoundDevice* _tmp2_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp2_ = self->priv->device;
		g_assert (_tmp2_ != NULL);
		{
			FsoDeviceSoundDevice* _tmp3_;
			GeeHashMap* _tmp4_;
			const gchar* _tmp5_;
			gpointer _tmp6_ = NULL;
			FsoDeviceBunchOfMixerControls* _tmp7_;
			FsoDeviceMixerControl** _tmp8_;
			gint _tmp8__length1;
			_tmp3_ = self->priv->device;
			_tmp4_ = self->priv->allscenarios;
			_tmp5_ = scenario;
			_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
			_tmp7_ = (FsoDeviceBunchOfMixerControls*) _tmp6_;
			_tmp8_ = _tmp7_->controls;
			_tmp8__length1 = _tmp7_->controls_length1;
			fso_device_sound_device_setAllMixerControls (_tmp3_, _tmp8_, _tmp8__length1, &_inner_error_);
			_fso_device_bunch_of_mixer_controls_unref0 (_tmp7_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
					goto __catch4_fso_device_sound_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally4;
		__catch4_fso_device_sound_error:
		{
			GError* e = NULL;
			FsoFrameworkLogger* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_ = NULL;
			GError* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp10_ = scenario;
			_tmp11_ = string_to_string (_tmp10_);
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			_tmp14_ = string_to_string (_tmp13_);
			_tmp15_ = g_strconcat ("Failed to update scenario '", _tmp11_, "' to get changes: ", _tmp14_, NULL);
			_tmp16_ = _tmp15_;
			fso_framework_logger_warning (_tmp9_, _tmp16_);
			_g_free0 (_tmp16_);
			_g_error_free0 (e);
		}
		__finally4:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp17_ = scenario;
		_tmp18_ = g_strdup (_tmp17_);
		_g_free0 (self->priv->currentscenario);
		self->priv->currentscenario = _tmp18_;
	}
}


static void router_lib_alsa_onModifiedScenario (RouterLibAlsa* self, int flags, guint32 cookie, const gchar* name) {
	const gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeHashMap* _tmp10_;
	const gchar* _tmp11_;
	gpointer _tmp12_ = NULL;
	FsoDeviceBunchOfMixerControls* _tmp13_;
	guint _tmp14_;
	guint _tmp15_;
	guint idxMainVolume;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = name;
	g_assert (_tmp0_ != NULL);
	_tmp1_ = self->priv->allscenarios;
	_tmp2_ = name;
	_tmp3_ = gee_map_contains ((GeeMap*) _tmp1_, _tmp2_);
	if (!_tmp3_) {
		FsoFrameworkLogger* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp4_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp5_ = name;
		_tmp6_ = string_to_string (_tmp5_);
		_tmp7_ = g_strconcat (_tmp6_, " is not a recognized scenario. Ignoring", NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = fso_framework_logger_debug (_tmp4_, _tmp8_);
		g_assert (_tmp9_);
		_g_free0 (_tmp8_);
		return;
	}
	_tmp10_ = self->priv->allscenarios;
	_tmp11_ = name;
	_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp11_);
	_tmp13_ = (FsoDeviceBunchOfMixerControls*) _tmp12_;
	_tmp14_ = _tmp13_->idxMainVolume;
	_tmp15_ = _tmp14_;
	_fso_device_bunch_of_mixer_controls_unref0 (_tmp13_);
	idxMainVolume = _tmp15_;
	_tmp16_ = name;
	_tmp17_ = self->priv->currentscenario;
	if (g_strcmp0 (_tmp16_, _tmp17_) == 0) {
		FsoFrameworkLogger* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		GFile* _tmp27_ = NULL;
		GFile* _tmp28_;
		GFile* file;
		GFile* _tmp29_;
		gboolean _tmp30_ = FALSE;
		_tmp18_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp19_ = name;
		_tmp20_ = string_to_string (_tmp19_);
		_tmp21_ = g_strconcat ("Scenario ", _tmp20_, " has been changed (being also the current scenario); invalidating cach" \
"e and reloading", NULL);
		_tmp22_ = _tmp21_;
		fso_framework_logger_info (_tmp18_, _tmp22_);
		_g_free0 (_tmp22_);
		_tmp23_ = self->priv->dataPath;
		_tmp24_ = name;
		_tmp25_ = g_build_filename (_tmp23_, _tmp24_, NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_file_new_for_path (_tmp26_);
		_tmp28_ = _tmp27_;
		_g_free0 (_tmp26_);
		file = _tmp28_;
		_tmp29_ = file;
		_tmp30_ = g_file_query_exists (_tmp29_, NULL);
		if (!_tmp30_) {
			FsoFrameworkLogger* _tmp31_;
			GFile* _tmp32_;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_;
			const gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_;
			_tmp31_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp32_ = file;
			_tmp33_ = g_file_get_path (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = string_to_string (_tmp34_);
			_tmp36_ = g_strconcat ("Scenario file ", _tmp35_, " doesn't exist. Ignoring.", NULL);
			_tmp37_ = _tmp36_;
			fso_framework_logger_warning (_tmp31_, _tmp37_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp34_);
		} else {
			const gchar* _tmp38_;
			GFile* _tmp39_;
			guint _tmp40_;
			_tmp38_ = name;
			_tmp39_ = file;
			_tmp40_ = idxMainVolume;
			router_lib_alsa_addScenario (self, _tmp38_, _tmp39_, _tmp40_);
			{
				FsoDeviceSoundDevice* _tmp41_;
				GeeHashMap* _tmp42_;
				const gchar* _tmp43_;
				gpointer _tmp44_ = NULL;
				FsoDeviceBunchOfMixerControls* _tmp45_;
				FsoDeviceMixerControl** _tmp46_;
				gint _tmp46__length1;
				_tmp41_ = self->priv->device;
				_tmp42_ = self->priv->allscenarios;
				_tmp43_ = name;
				_tmp44_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp42_, _tmp43_);
				_tmp45_ = (FsoDeviceBunchOfMixerControls*) _tmp44_;
				_tmp46_ = _tmp45_->controls;
				_tmp46__length1 = _tmp45_->controls_length1;
				fso_device_sound_device_setAllMixerControls (_tmp41_, _tmp46_, _tmp46__length1, &_inner_error_);
				_fso_device_bunch_of_mixer_controls_unref0 (_tmp45_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
						goto __catch5_fso_device_sound_error;
					}
					_g_object_unref0 (file);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			goto __finally5;
			__catch5_fso_device_sound_error:
			{
				GError* e = NULL;
				FsoFrameworkLogger* _tmp47_;
				const gchar* _tmp48_;
				const gchar* _tmp49_ = NULL;
				GError* _tmp50_;
				const gchar* _tmp51_;
				const gchar* _tmp52_ = NULL;
				gchar* _tmp53_ = NULL;
				gchar* _tmp54_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp47_ = ((FsoFrameworkAbstractObject*) self)->logger;
				_tmp48_ = name;
				_tmp49_ = string_to_string (_tmp48_);
				_tmp50_ = e;
				_tmp51_ = _tmp50_->message;
				_tmp52_ = string_to_string (_tmp51_);
				_tmp53_ = g_strconcat ("Failed to set mixer controls for scenario ", _tmp49_, ": ", _tmp52_, NULL);
				_tmp54_ = _tmp53_;
				fso_framework_logger_warning (_tmp47_, _tmp54_);
				_g_free0 (_tmp54_);
				_g_error_free0 (e);
			}
			__finally5:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (file);
	} else {
		FsoFrameworkLogger* _tmp55_;
		const gchar* _tmp56_;
		const gchar* _tmp57_ = NULL;
		gchar* _tmp58_ = NULL;
		gchar* _tmp59_;
		_tmp55_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp56_ = name;
		_tmp57_ = string_to_string (_tmp56_);
		_tmp58_ = g_strconcat ("Scenario ", _tmp57_, " has been changed; invalidating cache for this.", NULL);
		_tmp59_ = _tmp58_;
		fso_framework_logger_info (_tmp55_, _tmp59_);
		_g_free0 (_tmp59_);
		{
			FsoDeviceSoundDevice* _tmp60_;
			gint _tmp61_ = 0;
			FsoDeviceMixerControl** _tmp62_ = NULL;
			FsoDeviceMixerControl** _tmp63_;
			gint _tmp63__length1;
			gint __tmp63__size_;
			FsoDeviceMixerControl** _tmp64_;
			gint _tmp64__length1;
			FsoDeviceBunchOfMixerControls* _tmp65_;
			FsoDeviceBunchOfMixerControls* _tmp66_;
			FsoDeviceBunchOfMixerControls* scene;
			const gchar* _tmp67_;
			const gchar* _tmp68_;
			gchar* _tmp69_ = NULL;
			gchar* _tmp70_;
			GFile* _tmp71_ = NULL;
			GFile* _tmp72_;
			GFile* file;
			GFile* _tmp73_;
			gboolean _tmp74_ = FALSE;
			FsoDeviceSoundDevice* _tmp85_;
			FsoDeviceBunchOfMixerControls* _tmp86_;
			FsoDeviceMixerControl** _tmp87_;
			gint _tmp87__length1;
			_tmp60_ = self->priv->device;
			_tmp62_ = fso_device_sound_device_allMixerControls (_tmp60_, &_tmp61_, &_inner_error_);
			_tmp63_ = _tmp62_;
			_tmp63__length1 = _tmp61_;
			__tmp63__size_ = _tmp63__length1;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
					goto __catch6_fso_device_sound_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp64_ = _tmp63_;
			_tmp64__length1 = _tmp63__length1;
			_tmp65_ = fso_device_bunch_of_mixer_controls_new (_tmp64_, _tmp63__length1, (guint) 0);
			_tmp66_ = _tmp65_;
			_tmp64_ = (_vala_array_free (_tmp64_, _tmp64__length1, (GDestroyNotify) fso_device_mixer_control_unref), NULL);
			scene = _tmp66_;
			_tmp67_ = self->priv->dataPath;
			_tmp68_ = name;
			_tmp69_ = g_build_filename (_tmp67_, _tmp68_, NULL);
			_tmp70_ = _tmp69_;
			_tmp71_ = g_file_new_for_path (_tmp70_);
			_tmp72_ = _tmp71_;
			_g_free0 (_tmp70_);
			file = _tmp72_;
			_tmp73_ = file;
			_tmp74_ = g_file_query_exists (_tmp73_, NULL);
			if (!_tmp74_) {
				FsoFrameworkLogger* _tmp75_;
				GFile* _tmp76_;
				gchar* _tmp77_ = NULL;
				gchar* _tmp78_;
				const gchar* _tmp79_ = NULL;
				gchar* _tmp80_ = NULL;
				gchar* _tmp81_;
				_tmp75_ = ((FsoFrameworkAbstractObject*) self)->logger;
				_tmp76_ = file;
				_tmp77_ = g_file_get_path (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = string_to_string (_tmp78_);
				_tmp80_ = g_strconcat ("Scenario file ", _tmp79_, " doesn't exist. Ignoring.", NULL);
				_tmp81_ = _tmp80_;
				fso_framework_logger_warning (_tmp75_, _tmp81_);
				_g_free0 (_tmp81_);
				_g_free0 (_tmp78_);
			} else {
				const gchar* _tmp82_;
				GFile* _tmp83_;
				guint _tmp84_;
				_tmp82_ = name;
				_tmp83_ = file;
				_tmp84_ = idxMainVolume;
				router_lib_alsa_addScenario (self, _tmp82_, _tmp83_, _tmp84_);
			}
			_tmp85_ = self->priv->device;
			_tmp86_ = scene;
			_tmp87_ = _tmp86_->controls;
			_tmp87__length1 = _tmp86_->controls_length1;
			fso_device_sound_device_setAllMixerControls (_tmp85_, _tmp87_, _tmp87__length1, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file);
				_fso_device_bunch_of_mixer_controls_unref0 (scene);
				if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
					goto __catch6_fso_device_sound_error;
				}
				_g_object_unref0 (file);
				_fso_device_bunch_of_mixer_controls_unref0 (scene);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (file);
			_fso_device_bunch_of_mixer_controls_unref0 (scene);
		}
		goto __finally6;
		__catch6_fso_device_sound_error:
		{
			GError* e = NULL;
			FsoFrameworkLogger* _tmp88_;
			const gchar* _tmp89_;
			const gchar* _tmp90_ = NULL;
			GError* _tmp91_;
			const gchar* _tmp92_;
			const gchar* _tmp93_ = NULL;
			gchar* _tmp94_ = NULL;
			gchar* _tmp95_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp88_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp89_ = name;
			_tmp90_ = string_to_string (_tmp89_);
			_tmp91_ = e;
			_tmp92_ = _tmp91_->message;
			_tmp93_ = string_to_string (_tmp92_);
			_tmp94_ = g_strconcat ("Failed invalidating scenario ", _tmp90_, ": ", _tmp93_, NULL);
			_tmp95_ = _tmp94_;
			fso_framework_logger_warning (_tmp88_, _tmp95_);
			_g_free0 (_tmp95_);
			_g_error_free0 (e);
		}
		__finally6:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gboolean router_lib_alsa_real_isScenarioAvailable (FsoDeviceBaseAudioRouter* base, const gchar* scenario) {
	RouterLibAlsa * self;
	gboolean result = FALSE;
	GeeHashMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	self = (RouterLibAlsa*) base;
	g_return_val_if_fail (scenario != NULL, FALSE);
	_tmp0_ = self->priv->allscenarios;
	_tmp1_ = gee_abstract_map_get_keys ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = scenario;
	_tmp5_ = gee_collection_contains ((GeeCollection*) _tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp3_);
	result = _tmp6_;
	return result;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** router_lib_alsa_real_availableScenarios (FsoDeviceBaseAudioRouter* base, int* result_length1) {
	RouterLibAlsa * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** list;
	gint list_length1;
	gint _list_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	self = (RouterLibAlsa*) base;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	list = _tmp0_;
	list_length1 = 0;
	_list_size_ = list_length1;
	{
		GeeHashMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _key_it;
		_tmp1_ = self->priv->allscenarios;
		_tmp2_ = gee_abstract_map_get_keys ((GeeMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_key_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeIterator* _tmp9_;
			gpointer _tmp10_ = NULL;
			gchar* key;
			gchar** _tmp11_;
			gint _tmp11__length1;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp7_ = _key_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _key_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			key = (gchar*) _tmp10_;
			_tmp11_ = list;
			_tmp11__length1 = list_length1;
			_tmp12_ = key;
			_tmp13_ = g_strdup (_tmp12_);
			_vala_array_add2 (&list, &list_length1, &_list_size_, _tmp13_);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_it);
	}
	_tmp14_ = list;
	_tmp14__length1 = list_length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	return result;
}


static gchar* router_lib_alsa_real_currentScenario (FsoDeviceBaseAudioRouter* base) {
	RouterLibAlsa * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RouterLibAlsa*) base;
	_tmp0_ = self->priv->currentscenario;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* router_lib_alsa_real_pullScenario (FsoDeviceBaseAudioRouter* base, GError** error) {
	RouterLibAlsa * self;
	gchar* result = NULL;
	GQueue* _tmp0_;
	gpointer _tmp1_ = NULL;
	gchar* _tmp2_;
	GQueue* _tmp3_;
	gconstpointer _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* scenario;
	const gchar* _tmp6_;
	const gchar* _tmp8_;
	GError * _inner_error_ = NULL;
	self = (RouterLibAlsa*) base;
	_tmp0_ = self->priv->scenarios;
	_tmp1_ = g_queue_pop_head (_tmp0_);
	_tmp2_ = (gchar*) _tmp1_;
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->scenarios;
	_tmp4_ = g_queue_peek_head (_tmp3_);
	_tmp5_ = g_strdup ((const gchar*) _tmp4_);
	scenario = _tmp5_;
	_tmp6_ = scenario;
	if (_tmp6_ == NULL) {
		GError* _tmp7_;
		_tmp7_ = g_error_new_literal (FREE_SMARTPHONE_DEVICE_AUDIO_ERROR, FREE_SMARTPHONE_DEVICE_AUDIO_ERROR_SCENARIO_STACK_UNDERFLOW, "No scenario left to activate");
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == FREE_SMARTPHONE_DEVICE_AUDIO_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (scenario);
			return NULL;
		} else {
			_g_free0 (scenario);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = scenario;
	fso_device_base_audio_router_setScenario ((FsoDeviceBaseAudioRouter*) self, _tmp8_);
	result = scenario;
	return result;
}


static void router_lib_alsa_real_pushScenario (FsoDeviceBaseAudioRouter* base, const gchar* scenario) {
	RouterLibAlsa * self;
	const gchar* _tmp0_;
	GQueue* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	self = (RouterLibAlsa*) base;
	g_return_if_fail (scenario != NULL);
	_tmp0_ = scenario;
	fso_device_base_audio_router_setScenario ((FsoDeviceBaseAudioRouter*) self, _tmp0_);
	_tmp1_ = self->priv->scenarios;
	_tmp2_ = scenario;
	_tmp3_ = g_strdup (_tmp2_);
	g_queue_push_head (_tmp1_, _tmp3_);
}


static void router_lib_alsa_real_setScenario (FsoDeviceBaseAudioRouter* base, const gchar* scenario) {
	RouterLibAlsa * self;
	const gchar* _tmp0_;
	self = (RouterLibAlsa*) base;
	g_return_if_fail (scenario != NULL);
	_tmp0_ = scenario;
	router_lib_alsa_updateScenarioIfChanged (self, _tmp0_);
}


static void router_lib_alsa_real_saveScenario (FsoDeviceBaseAudioRouter* base, const gchar* scenario, GError** error) {
	RouterLibAlsa * self;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RouterLibAlsa*) base;
	g_return_if_fail (scenario != NULL);
	_tmp0_ = self->priv->allscenarios;
	_tmp1_ = scenario;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	if (!_tmp2_) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INVALID_PARAMETER, "Can't save a unknown scenario");
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == FREE_SMARTPHONE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		GeeHashMap* _tmp4_;
		const gchar* _tmp5_;
		gpointer _tmp6_ = NULL;
		FsoDeviceBunchOfMixerControls* _tmp7_;
		FsoDeviceMixerControl** _tmp8_;
		gint _tmp8__length1;
		FsoDeviceBunchOfMixerControls* _tmp9_;
		FsoDeviceBunchOfMixerControls* _tmp10_;
		FsoDeviceBunchOfMixerControls* scenario_controls;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* filename;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp4_ = self->priv->allscenarios;
		_tmp5_ = scenario;
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
		_tmp7_ = (FsoDeviceBunchOfMixerControls*) _tmp6_;
		_tmp8_ = _tmp7_->controls;
		_tmp8__length1 = _tmp7_->controls_length1;
		_tmp9_ = fso_device_bunch_of_mixer_controls_new (_tmp8_, _tmp8__length1, (guint) 0);
		_tmp10_ = _tmp9_;
		_fso_device_bunch_of_mixer_controls_unref0 (_tmp7_);
		scenario_controls = _tmp10_;
		_tmp11_ = self->priv->dataPath;
		_tmp12_ = scenario;
		_tmp13_ = g_build_filename (_tmp11_, _tmp12_, NULL);
		filename = _tmp13_;
		_tmp14_ = fso_device_bunch_of_mixer_controls_to_string (scenario_controls);
		_tmp15_ = _tmp14_;
		fso_framework_file_handling_write (_tmp15_, filename, FALSE);
		_g_free0 (_tmp15_);
		_g_free0 (filename);
		_fso_device_bunch_of_mixer_controls_unref0 (scenario_controls);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		FsoFrameworkLogger* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_ = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp17_ = scenario;
		_tmp18_ = string_to_string (_tmp17_);
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		_tmp21_ = string_to_string (_tmp20_);
		_tmp22_ = g_strconcat ("Saving scenario ", _tmp18_, " failed: ", _tmp21_, NULL);
		_tmp23_ = _tmp22_;
		fso_framework_logger_warning (_tmp16_, _tmp23_);
		_g_free0 (_tmp23_);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == FREE_SMARTPHONE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static guint8 router_lib_alsa_real_currentVolume (FsoDeviceBaseAudioRouter* base, GError** error) {
	RouterLibAlsa * self;
	guint8 result = 0U;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	FsoDeviceBunchOfMixerControls* scenario;
	FsoDeviceSoundDevice* _tmp3_;
	guint _tmp4_;
	guint8 _tmp5_ = 0U;
	self = (RouterLibAlsa*) base;
	_tmp0_ = self->priv->allscenarios;
	_tmp1_ = self->priv->currentscenario;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	scenario = (FsoDeviceBunchOfMixerControls*) _tmp2_;
	g_assert (scenario != NULL);
	_tmp3_ = self->priv->device;
	_tmp4_ = scenario->idxMainVolume;
	_tmp5_ = fso_device_sound_device_volumeForIndex (_tmp3_, _tmp4_);
	result = _tmp5_;
	_fso_device_bunch_of_mixer_controls_unref0 (scenario);
	return result;
}


static void router_lib_alsa_real_setVolume (FsoDeviceBaseAudioRouter* base, guint8 volume, GError** error) {
	RouterLibAlsa * self;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	FsoDeviceBunchOfMixerControls* scenario;
	FsoDeviceSoundDevice* _tmp3_;
	guint _tmp4_;
	guint8 _tmp5_;
	self = (RouterLibAlsa*) base;
	_tmp0_ = self->priv->allscenarios;
	_tmp1_ = self->priv->currentscenario;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	scenario = (FsoDeviceBunchOfMixerControls*) _tmp2_;
	g_assert (scenario != NULL);
	_tmp3_ = self->priv->device;
	_tmp4_ = scenario->idxMainVolume;
	_tmp5_ = volume;
	fso_device_sound_device_setVolumeForIndex (_tmp3_, _tmp4_, _tmp5_);
	_fso_device_bunch_of_mixer_controls_unref0 (scenario);
}


static gchar* router_lib_alsa_real_repr (FsoFrameworkAbstractObject* base) {
	RouterLibAlsa * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (RouterLibAlsa*) base;
	_tmp0_ = g_strdup ("<>");
	result = _tmp0_;
	return result;
}


RouterLibAlsa* router_lib_alsa_construct (GType object_type) {
	RouterLibAlsa * self = NULL;
	self = (RouterLibAlsa*) fso_device_base_audio_router_construct (object_type);
	return self;
}


RouterLibAlsa* router_lib_alsa_new (void) {
	return router_lib_alsa_construct (ROUTER_TYPE_LIB_ALSA);
}


static GObject * router_lib_alsa_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RouterLibAlsa * self;
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (router_lib_alsa_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ROUTER_LIB_ALSA (obj);
	router_lib_alsa_initScenarios (self);
	_tmp0_ = self->priv->currentscenario;
	if (g_strcmp0 (_tmp0_, "unknown") != 0) {
		{
			FsoDeviceSoundDevice* _tmp1_;
			GeeHashMap* _tmp2_;
			const gchar* _tmp3_;
			gpointer _tmp4_ = NULL;
			FsoDeviceBunchOfMixerControls* _tmp5_;
			FsoDeviceMixerControl** _tmp6_;
			gint _tmp6__length1;
			_tmp1_ = self->priv->device;
			_tmp2_ = self->priv->allscenarios;
			_tmp3_ = self->priv->currentscenario;
			_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, _tmp3_);
			_tmp5_ = (FsoDeviceBunchOfMixerControls*) _tmp4_;
			_tmp6_ = _tmp5_->controls;
			_tmp6__length1 = _tmp5_->controls_length1;
			fso_device_sound_device_setAllMixerControls (_tmp1_, _tmp6_, _tmp6__length1, &_inner_error_);
			_fso_device_bunch_of_mixer_controls_unref0 (_tmp5_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == FSO_DEVICE_SOUND_ERROR) {
					goto __catch8_fso_device_sound_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
		}
		goto __finally8;
		__catch8_fso_device_sound_error:
		{
			GError* e = NULL;
			FsoFrameworkLogger* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_ = NULL;
			GError* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp7_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp8_ = self->priv->currentscenario;
			_tmp9_ = string_to_string (_tmp8_);
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			_tmp12_ = string_to_string (_tmp11_);
			_tmp13_ = g_strconcat ("Setting mixer controls for scenario ", _tmp9_, " failed: ", _tmp12_, NULL);
			_tmp14_ = _tmp13_;
			fso_framework_logger_warning (_tmp7_, _tmp14_);
			_g_free0 (_tmp14_);
			_g_error_free0 (e);
		}
		__finally8:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	return obj;
}


static void router_lib_alsa_class_init (RouterLibAlsaClass * klass) {
	router_lib_alsa_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RouterLibAlsaPrivate));
	FSO_DEVICE_BASE_AUDIO_ROUTER_CLASS (klass)->isScenarioAvailable = router_lib_alsa_real_isScenarioAvailable;
	FSO_DEVICE_BASE_AUDIO_ROUTER_CLASS (klass)->availableScenarios = router_lib_alsa_real_availableScenarios;
	FSO_DEVICE_BASE_AUDIO_ROUTER_CLASS (klass)->currentScenario = router_lib_alsa_real_currentScenario;
	FSO_DEVICE_BASE_AUDIO_ROUTER_CLASS (klass)->pullScenario = router_lib_alsa_real_pullScenario;
	FSO_DEVICE_BASE_AUDIO_ROUTER_CLASS (klass)->pushScenario = router_lib_alsa_real_pushScenario;
	FSO_DEVICE_BASE_AUDIO_ROUTER_CLASS (klass)->setScenario = router_lib_alsa_real_setScenario;
	FSO_DEVICE_BASE_AUDIO_ROUTER_CLASS (klass)->saveScenario = router_lib_alsa_real_saveScenario;
	FSO_DEVICE_BASE_AUDIO_ROUTER_CLASS (klass)->currentVolume = router_lib_alsa_real_currentVolume;
	FSO_DEVICE_BASE_AUDIO_ROUTER_CLASS (klass)->setVolume = router_lib_alsa_real_setVolume;
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = router_lib_alsa_real_repr;
	G_OBJECT_CLASS (klass)->constructor = router_lib_alsa_constructor;
	G_OBJECT_CLASS (klass)->finalize = router_lib_alsa_finalize;
}


static void router_lib_alsa_instance_init (RouterLibAlsa * self) {
	self->priv = ROUTER_LIB_ALSA_GET_PRIVATE (self);
}


static void router_lib_alsa_finalize (GObject* obj) {
	RouterLibAlsa * self;
	self = ROUTER_LIB_ALSA (obj);
	_g_object_unref0 (self->priv->device);
	_g_object_unref0 (self->priv->allscenarios);
	_g_free0 (self->priv->currentscenario);
	__g_queue_free__g_free0_0 (self->priv->scenarios);
	_g_free0 (self->priv->configurationPath);
	_g_free0 (self->priv->dataPath);
	G_OBJECT_CLASS (router_lib_alsa_parent_class)->finalize (obj);
}


/**
 * Alsa Scenario Router
 **/
GType router_lib_alsa_get_type (void) {
	return router_lib_alsa_type_id;
}


GType router_lib_alsa_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (RouterLibAlsaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) router_lib_alsa_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RouterLibAlsa), 0, (GInstanceInitFunc) router_lib_alsa_instance_init, NULL };
	router_lib_alsa_type_id = g_type_module_register_type (module, FSO_DEVICE_TYPE_BASE_AUDIO_ROUTER, "RouterLibAlsa", &g_define_type_info, 0);
	return router_lib_alsa_type_id;
}


/**
 * This function gets called on plugin initialization time.
 * @return the name of your plugin here
 * @note that it needs to be a name in the format <subsystem>.<plugin>
 * else your module will be unloaded immediately.
 **/
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	_tmp0_ = g_strdup ("fsodevice.router_alsa");
	result = _tmp0_;
	return result;
}


void fso_register_function (GTypeModule* module) {
	FsoFrameworkLogger* _tmp0_;
	g_return_if_fail (module != NULL);
	router_lib_alsa_register_type (module);
	_tmp0_ = fso_framework_theLogger;
	fso_framework_logger_debug (_tmp0_, "fsodevice.router_alsa fso_register_function()");
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



