#                                                         -*- Perl -*-
# Copyright (c) 2001  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# BMP 顼᤿ե륯饹
#
package FreePWING::ColorGraphic;

require 5.005;
require Exporter;
use English;
use FileHandle;
use FreePWING::Tag;
use strict;
use integer;

use vars qw(@ISA
	    @EXPORT
	    @EXPORT_OK
	    $block_length
	    $tag_prefix);

@ISA = qw(Exporter);

#
# ֥åĹ (Хȿ)
#
$block_length = 2048;

#
# :
#	new()
# ᥽åɤζʬ:
# 	public 饹᥽åɡ
# :
# 	֥Ȥ롣
# :
# 	֥ȤؤΥե󥹤֤
#
sub new {
    my $type = shift;
    my $new = {
	# ХʥեΥϥɥ
	'handle' => FileHandle->new(),

	# Хʥե̾
	'file_name' => '',

	# 񤭹ȥ
	'entry_count' => 0,

	# ХʥեΥեå (ޤǤ˽񤭹Хȿ)
	'position' => 0,

	# 
	'tag' => FreePWING::Tag->new(),

	# 顼å
	'error_message' => '',
    };
    return bless($new, $type);
}

#
# :
#	open(file_name, [tag_file_name])
#           file_name
#		ƥȥե̾
#           tag_file_name
#		ե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	񤭹ѤΥƥȥե򳫤
# :
#	 1 ֤Ԥ 0 ֤
#
sub open {
    my $self = shift;
    my ($file_name, $tag_file_name) = @ARG;

    #
    # ե򳫤
    #
    $self->{'file_name'} = $file_name;
    if (!$self->{'handle'}->open($self->{'file_name'}, 'w')) {
	$self->{'error_message'} =
	    "failed to open the file, $ERRNO: " . $self->{'file_name'};
	$self->close_internal();
	return 0;
    }
    binmode($self->{'handle'});

    #
    # ե򳫤
    #
    if (defined($tag_file_name)
	&& !$self->{'tag'}->open($tag_file_name)) {
	$self->{'error_message'} = $self->{'tag'}->error_message();
	$self->close_internal();
        return 0;
    }

    return 1;
}

#
# :
#	close()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	֥ȤƤƥȥե뷲Ĥ롣
#	ƥȥե򳫤Ƥʤϡ⤷ʤ
# :
#	 1 ֤Ԥ 0 ֤
#
sub close {
    my $self = shift;

    if (!$self->{'handle'}->fileno()) {
	return 1;
    }

    #
    # Ⱦüʥ֥åθ "\0" 롣
    #
    my $pad_length = $block_length - $self->{'handle'}->tell() % $block_length;
    if ($pad_length < $block_length
	&& !$self->{'handle'}->print("\0" x $pad_length)) {
	$self->{'error_message'} =
	    "failed to write the file, $ERRNO: " . $self->{'file_name'};
	return 0;
    }
	
    #
    # եĤ롣
    #
    $self->close_internal();

    return 1;
}

#
# :
#	close_internal()
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
#       close() ѥ᥽åɡ
#
sub close_internal {
    my $self = shift;

    if ($self->{'handle'}->fileno()) {
	$self->{'handle'}->close();
    }
    $self->{'tag'}->close_internal();
}

#
# :
#	add_data(tag, file_name)
#	    tag
#		̾
#	    file_name
#		ɲäХʥե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	Ϳ줿եƤ򡢥ǡȤɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_data {
    my $self = shift;
    my ($tag, $file_name) = @ARG;

    my ($start_position) = $self->{'position'};

    #
    # Ͽ롣
    #
    if (!$self->{'tag'}->add_entry('cgraph:' . $tag, $start_position)) {
	$self->{'error_message'} = $self->{'tag'}->error_message();
	$self->close_internal();
	return 0;
    }

    #
    # إå񤭹ࡣ
    #
    my $file_size = -s $file_name;
    my $header = pack('a4V', 'data', $file_size);
    if (!$self->{'handle'}->print($header)) {
	$self->{'error_message'} =
	    "failed to write the file, $ERRNO: " . $self->{'file_name'};
	$self->close_internal();
	return 0;
    }
    $self->{'position'} += length($header);

    #
    # ꤵ줿ե򳫤
    #
    my $handle = FileHandle->new();
    if (!$handle->open($file_name, 'r')) {
	$self->{'error_message'} =
	    "failed to open the file, $ERRNO: " . $file_name;
	$self->close_internal();
	return 0;
    }
    binmode($handle);

    #
    # ꤵ줿եɤ߹ǡХʥե˽񤭹ࡣ
    #
    my ($data, $data_length);
    for (;;) {
	$data_length = $handle->read($data, $block_length);
	if (!defined($data_length)) {
	    $self->{'error_message'} =
		"failed to read the file, $ERRNO: " . $file_name;
	    $self->close_internal();
	    return 0;
	} elsif ($data_length == 0) {
	    last;
	}
	if (!$self->{'handle'}->print($data)) {
	    $self->{'error_message'} =
		"failed to write the file, $ERRNO: " . $self->{'file_name'};
	    $self->close_internal();
	    return 0;
	}

	$self->{'position'} += $data_length;
    }

    #
    # ꤵ줿եĤ롣
    #
    $handle->close();
    $self->{'entry_count'}++;

    #
    # λϿ롣
    #
    if (defined($self->{'end_tag_prefix'})) {
	my ($end_tag) = $self->{'end_tag_prefix'} . ':' . $tag;
	my ($end_position) = $self-{'position'} - 1;
	if ($end_position < $start_position) {
	    $end_position = $start_position;
	}

	if (!$self->{'tag'}->add_entry($end_tag, $end_position)) {
	    $self->{'error_message'} = $self->{'tag'}->error_message();
	    $self->close_internal();
	    return 0;
	}
    }

    return 1;
}

#
# :
#	add_binary(tag, binary)
#	    tag
#		̾
#	    binary
#		ɲäХʥǡ
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	Ϳ줿ХʥǡƤ򡢥ǡȤɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_binary {
    my $self = shift;
    my ($tag, $binary) = @ARG;

    my ($start_position) = $self->{'position'};

    #
    # Ͽ롣
    #
    if (!$self->{'tag'}->add_entry('cgraph:' . $tag, $start_position)) {
	$self->{'error_message'} = $self->{'tag'}->error_message();
	$self->close_internal();
	return 0;
    }

    #
    # إå񤭹ࡣ
    #
    my $file_size = length($binary);
    my $header = pack('a4V', 'data', $file_size);
    if (!$self->{'handle'}->print($header)) {
	$self->{'error_message'} =
	    "failed to write the file, $ERRNO: " . $self->{'file_name'};
	$self->close_internal();
	return 0;
    }
    $self->{'position'} += length($header);

    #
    # Хʥǡ񤭹ࡣ
    #
    if (!$self->{'handle'}->print($binary)) {
	$self->{'error_message'} =
	    "failed to write the file, $ERRNO: " . $self->{'file_name'};
	$self->close_internal();
	return 0;
    }
    $self->{'position'} += $file_size;

    #
    # 
    #
    $self->{'entry_count'}++;

    #
    # λϿ롣
    #
    if (defined($self->{'end_tag_prefix'})) {
	my ($end_tag) = $self->{'end_tag_prefix'} . ':' . $tag;
	my ($end_position) = $self-{'position'} - 1;
	if ($end_position < $start_position) {
	    $end_position = $start_position;
	}

	if (!$self->{'tag'}->add_entry($end_tag, $end_position)) {
	    $self->{'error_message'} = $self->{'tag'}->error_message();
	    $self->close_internal();
	    return 0;
	}
    }

    return 1;
}

######################################################################
# <󥹥ѿ֤ͤ᥽åɷ>
#
# :
#	󥹥ѿ̾()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
#	󥹥ѿ֤ͤ
#
sub file_name {
    my $self = shift;
    return $self->{'file_name'};
}

sub tag_file_name {
    my $self = shift;
    return $self->{'tag'}->file_name();
}

sub entry_count {
    my $self = shift;
    return $self->{'entry_count'};
}

sub error_message {
    my $self = shift;
    return $self->{'error_message'};
}

1;
