/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.List;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTEqualityExpression;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTPrimitiveType;
import net.sourceforge.pmd.ast.ASTRelationalExpression;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.NameOccurrence;

public abstract class AbstractInefficientZeroCheck
extends AbstractRule {
    public abstract boolean appliesToClassName(String var1);

    public abstract boolean isTargetMethod(NameOccurrence var1);

    public Object visit(ASTVariableDeclaratorId node, Object data) {
        SimpleNode nameNode = node.getTypeNameNode();
        if (nameNode instanceof ASTPrimitiveType) {
            return data;
        }
        if (!this.appliesToClassName(node.getNameDeclaration().getTypeImage())) {
            return data;
        }
        List<NameOccurrence> declars = node.getUsages();
        for (NameOccurrence occ : declars) {
            SimpleNode expr;
            if (!this.isTargetMethod(occ) || !((expr = (SimpleNode)occ.getLocation().jjtGetParent().jjtGetParent().jjtGetParent()) instanceof ASTEqualityExpression) && (!(expr instanceof ASTRelationalExpression) || !">".equals(expr.getImage())) || !this.isCompareZero(expr)) continue;
            this.addViolation(data, occ.getLocation());
        }
        return data;
    }

    private boolean isCompareZero(SimpleNode equality) {
        return this.checkComparison(equality, 0) || this.checkComparison(equality, 1);
    }

    private boolean checkComparison(SimpleNode equality, int i) {
        SimpleNode target = (SimpleNode)equality.jjtGetChild(i).jjtGetChild(0);
        if (target.jjtGetNumChildren() == 0) {
            return false;
        }
        return (target = (SimpleNode)target.jjtGetChild(0)) instanceof ASTLiteral && "0".equals(target.getImage());
    }
}

