
/*
 * Copyright (c) 2019, NVIDIA CORPORATION.  All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */


static double ll_as_double(long long a) { return *(double*)&a; }
static long long double_as_ll(double a) { return *(long long*)&a; }

const double TWO_TO_53 = 9007199254740992.0;

const double LOG_2[] __attribute__ ((aligned (64))) = {
6.9314718055994531e-01, 6.9314718055994531e-01, 6.9314718055994531e-01, 6.9314718055994531e-01,
6.9314718055994531e-01, 6.9314718055994531e-01, 6.9314718055994531e-01, 6.9314718055994531e-01
};

const double ONE_D[] __attribute__ ((aligned (64))) = {
1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0
};

const unsigned long long ONE_I[] __attribute__ ((aligned (64))) = {
1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL, 1ULL
};

const double THRESHOLD[]  __attribute__ ((aligned (64))) = {
0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75
};

const unsigned long long MANTISSA_MASK[]  __attribute__ ((aligned (64))) = {
0xfffffffffffffULL, 0xfffffffffffffULL, 0xfffffffffffffULL, 0xfffffffffffffULL,
0xfffffffffffffULL, 0xfffffffffffffULL, 0xfffffffffffffULL, 0xfffffffffffffULL
};

const unsigned long long HALFIFIER[]  __attribute__ ((aligned (64))) = {
0x10000000000000ULL, 0x10000000000000ULL, 0x10000000000000ULL, 0x10000000000000ULL,
0x10000000000000ULL, 0x10000000000000ULL, 0x10000000000000ULL, 0x10000000000000ULL
};

const unsigned long long PINF[]  __attribute__ ((aligned (64))) = {
0x7ff0000000000000ULL, 0x7ff0000000000000ULL, 0x7ff0000000000000ULL, 0x7ff0000000000000ULL,
0x7ff0000000000000ULL, 0x7ff0000000000000ULL, 0x7ff0000000000000ULL, 0x7ff0000000000000ULL
};

const unsigned long long NINF[]  __attribute__ ((aligned (64))) = {
0xfff0000000000000ULL, 0xfff0000000000000ULL, 0xfff0000000000000ULL, 0xfff0000000000000ULL,
0xfff0000000000000ULL, 0xfff0000000000000ULL, 0xfff0000000000000ULL, 0xfff0000000000000ULL
};

const unsigned long long CANONICAL_NAN[]  __attribute__ ((aligned (64))) = {
0xfff8000000000000ULL, 0xfff8000000000000ULL, 0xfff8000000000000ULL, 0xfff8000000000000ULL,
0xfff8000000000000ULL, 0xfff8000000000000ULL, 0xfff8000000000000ULL, 0xfff8000000000000ULL
};

const double c0[] __attribute__ ((aligned (64))) = {
-9.1687710165590294e-3, -9.1687710165590294e-3, -9.1687710165590294e-3, -9.1687710165590294e-3,
-9.1687710165590294e-3, -9.1687710165590294e-3, -9.1687710165590294e-3, -9.1687710165590294e-3
};
const double c1[] __attribute__ ((aligned (64))) = {
 3.2362086913721021e-2, 3.2362086913721021e-2, 3.2362086913721021e-2, 3.2362086913721021e-2,
 3.2362086913721021e-2, 3.2362086913721021e-2, 3.2362086913721021e-2, 3.2362086913721021e-2
};
const double c2[] __attribute__ ((aligned (64))) = {
-5.4432424615008503e-2, -5.4432424615008503e-2, -5.4432424615008503e-2, -5.4432424615008503e-2,
-5.4432424615008503e-2, -5.4432424615008503e-2, -5.4432424615008503e-2, -5.4432424615008503e-2
};
const double c3[] __attribute__ ((aligned (64))) = {
 6.3120973646273712e-2, 6.3120973646273712e-2, 6.3120973646273712e-2, 6.3120973646273712e-2,
 6.3120973646273712e-2, 6.3120973646273712e-2, 6.3120973646273712e-2, 6.3120973646273712e-2
};
const double c4[] __attribute__ ((aligned (64))) = {
-6.4323331807744785e-2, -6.4323331807744785e-2, -6.4323331807744785e-2, -6.4323331807744785e-2,
-6.4323331807744785e-2, -6.4323331807744785e-2, -6.4323331807744785e-2, -6.4323331807744785e-2
};
const double c5[] __attribute__ ((aligned (64))) = {
 6.6585005193631794e-2, 6.6585005193631794e-2, 6.6585005193631794e-2, 6.6585005193631794e-2,
 6.6585005193631794e-2, 6.6585005193631794e-2, 6.6585005193631794e-2, 6.6585005193631794e-2
};
const double c6[] __attribute__ ((aligned (64))) = {
-7.1210953378695693e-2, -7.1210953378695693e-2, -7.1210953378695693e-2, -7.1210953378695693e-2,
-7.1210953378695693e-2, -7.1210953378695693e-2, -7.1210953378695693e-2, -7.1210953378695693e-2
};
const double c7[] __attribute__ ((aligned (64))) = {
 7.6892810611050785e-2, 7.6892810611050785e-2, 7.6892810611050785e-2, 7.6892810611050785e-2,
 7.6892810611050785e-2, 7.6892810611050785e-2, 7.6892810611050785e-2, 7.6892810611050785e-2
};
const double c8[] __attribute__ ((aligned (64))) = {
-8.3344068879612862e-2, -8.3344068879612862e-2, -8.3344068879612862e-2, -8.3344068879612862e-2,
-8.3344068879612862e-2, -8.3344068879612862e-2, -8.3344068879612862e-2, -8.3344068879612862e-2
};
const double c9[] __attribute__ ((aligned (64))) = {
 9.0911836824887890e-2, 9.0911836824887890e-2, 9.0911836824887890e-2, 9.0911836824887890e-2,
 9.0911836824887890e-2, 9.0911836824887890e-2, 9.0911836824887890e-2, 9.0911836824887890e-2
};
const double c10[] __attribute__ ((aligned (64))) = {
-9.9999773268643677e-2, -9.9999773268643677e-2, -9.9999773268643677e-2, -9.9999773268643677e-2,
-9.9999773268643677e-2, -9.9999773268643677e-2, -9.9999773268643677e-2, -9.9999773268643677e-2
};
const double c11[] __attribute__ ((aligned (64))) = {
 1.1111100747019420e-1, 1.1111100747019420e-1, 1.1111100747019420e-1, 1.1111100747019420e-1,
 1.1111100747019420e-1, 1.1111100747019420e-1, 1.1111100747019420e-1, 1.1111100747019420e-1
};
const double c12[] __attribute__ ((aligned (64))) = {
-1.2500000067645678e-1, -1.2500000067645678e-1, -1.2500000067645678e-1, -1.2500000067645678e-1,
-1.2500000067645678e-1, -1.2500000067645678e-1, -1.2500000067645678e-1, -1.2500000067645678e-1
};
const double c13[] __attribute__ ((aligned (64))) = {
 1.4285714480151776e-1, 1.4285714480151776e-1, 1.4285714480151776e-1, 1.4285714480151776e-1,
 1.4285714480151776e-1, 1.4285714480151776e-1, 1.4285714480151776e-1, 1.4285714480151776e-1
};
const double c14[] __attribute__ ((aligned (64))) = {
-1.6666666670813565e-1, -1.6666666670813565e-1, -1.6666666670813565e-1, -1.6666666670813565e-1,
-1.6666666670813565e-1, -1.6666666670813565e-1, -1.6666666670813565e-1, -1.6666666670813565e-1
};
const double c15[] __attribute__ ((aligned (64))) = {
 1.9999999998292198e-1, 1.9999999998292198e-1, 1.9999999998292198e-1, 1.9999999998292198e-1,
 1.9999999998292198e-1, 1.9999999998292198e-1, 1.9999999998292198e-1, 1.9999999998292198e-1
};
const double c16[] __attribute__ ((aligned (64))) = {
-2.4999999999954195e-1, -2.4999999999954195e-1, -2.4999999999954195e-1, -2.4999999999954195e-1,
-2.4999999999954195e-1, -2.4999999999954195e-1, -2.4999999999954195e-1, -2.4999999999954195e-1
};
const double c17[] __attribute__ ((aligned (64))) = {
 3.3333333333338410e-1, 3.3333333333338410e-1, 3.3333333333338410e-1, 3.3333333333338410e-1,
 3.3333333333338410e-1, 3.3333333333338410e-1, 3.3333333333338410e-1, 3.3333333333338410e-1
};
const double c18[] __attribute__ ((aligned (64))) = {
-5.0000000000000100e-1, -5.0000000000000100e-1, -5.0000000000000100e-1, -5.0000000000000100e-1,
-5.0000000000000100e-1, -5.0000000000000100e-1, -5.0000000000000100e-1, -5.0000000000000100e-1
};


