/*
 * Decompiled with CFR 0.152.
 */
package friendless.games.filler;

import friendless.games.filler.FillerBoard;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JRadioButton;

public class ColourButton
extends JRadioButton {
    protected static final int WIDTH = 20;
    protected static final int HEIGHT = 20;
    protected static final Font numFont = new Font("dialog", 1, 10);
    protected int id;
    protected int xoff;
    protected int yoff;
    protected String label;
    protected Image pressed;
    protected Image normal;
    protected Image disabled;
    protected Color colour;

    public ColourButton(Color color, int n) {
        this.setBorderPainted(true);
        this.setPreferredSize(new Dimension(20, 20));
        this.setMinimumSize(new Dimension(20, 20));
        this.setRolloverEnabled(false);
        this.id = n;
        this.label = Integer.toString(n / 2 + 1);
        this.colour = color;
    }

    public void addNotify() {
        super.addNotify();
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(numFont);
        this.xoff = (20 - fontMetrics.stringWidth(this.label) + 1) / 2;
        this.yoff = 14;
        this.normal = this.createImage(20, 20);
        Graphics graphics = this.normal.getGraphics();
        this.normalPaintIcon(this, graphics, 0, 0);
        graphics.dispose();
        this.setIcon(new ImageIcon(this.normal));
        this.disabled = this.createImage(20, 20);
        graphics = this.disabled.getGraphics();
        this.disabledPaintIcon(this, graphics, 0, 0);
        graphics.dispose();
        this.setDisabledIcon(new ImageIcon(this.disabled));
    }

    public void normalPaintIcon(Component component, Graphics graphics, int n, int n2) {
        graphics.setColor(this.colour);
        this.drawInside(component, graphics, n, n2);
        graphics.setColor(FillerBoard.contrastingColour(this.colour));
        graphics.setFont(numFont);
        graphics.drawString(this.label, this.xoff, this.yoff);
    }

    public void disabledPaintIcon(Component component, Graphics graphics, int n, int n2) {
        graphics.setColor(Color.lightGray);
        this.drawInside(component, graphics, n, n2);
    }

    protected void drawInside(Component component, Graphics graphics, int n, int n2) {
        graphics.fillRect(n + 3, n2 + 3, 14, 14);
    }

    public int getID() {
        return this.id;
    }
}

