/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribResourceReader;
import ucar.grib.NotSupportedException;
import ucar.grib.Parameter;
import ucar.grid.GridParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GribPDSParamTable {
    private static Logger logger = LoggerFactory.getLogger(GribPDSParamTable.class);
    private static final String RESOURCE_PATH = "resources/grib/tables";
    private static final String TABLE_LIST = "tablelookup.lst";
    private static final Pattern valid = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_@:\\.\\-\\+]*$");
    private static final Pattern numberFirst = Pattern.compile("^[0-9]");
    private static volatile GribPDSParamTable[] paramTables = null;
    private static Object lock = new Object();
    private static boolean debug = false;
    private static Map<String, GribPDSParamTable> tableMap = new ConcurrentHashMap<String, GribPDSParamTable>();
    private int center_id;
    private int subcenter_id;
    private int table_number;
    private String filename = null;
    private String path = null;
    private Map<String, GridParameter> parameters = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addParameterUserLookup(InputStream is) throws IOException {
        ArrayList<GribPDSParamTable> tables = new ArrayList<GribPDSParamTable>();
        if (!GribPDSParamTable.readTableEntries(is, null, tables)) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            GribPDSParamTable[] tmp = new GribPDSParamTable[paramTables.length + tables.size()];
            for (int idx = 0; idx < paramTables.length + tables.size(); ++idx) {
                tmp[idx] = idx < tables.size() ? tables.get(idx) : paramTables[idx - tables.size()];
            }
            paramTables = tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addParameterUserLookup(String userGribTabList) throws IOException {
        ArrayList<GribPDSParamTable> tables = new ArrayList<GribPDSParamTable>();
        if (!GribPDSParamTable.readTableEntries(userGribTabList, tables)) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            GribPDSParamTable[] tmp = new GribPDSParamTable[paramTables.length + tables.size()];
            for (int idx = 0; idx < paramTables.length + tables.size(); ++idx) {
                tmp[idx] = idx < tables.size() ? tables.get(idx) : paramTables[idx - tables.size()];
            }
            paramTables = tmp;
        }
    }

    private static void initFromJAR(ArrayList<GribPDSParamTable> aTables) throws IOException {
        String resourceName = "resources/grib/tables/tablelookup.lst";
        GribPDSParamTable.readTableEntries(resourceName, aTables);
    }

    private static InputStream getInputStream(String resourceName) {
        return GribResourceReader.getInputStream(resourceName);
    }

    private static boolean readTableEntries(String aTableList, ArrayList<GribPDSParamTable> aTables) throws IOException {
        InputStream inputStream = GribPDSParamTable.getInputStream(aTableList);
        if (inputStream == null) {
            logger.debug("Could not open table file:" + aTableList);
            return false;
        }
        return GribPDSParamTable.readTableEntries(inputStream, aTableList, aTables);
    }

    private static boolean readTableEntries(InputStream is, String aTableList, ArrayList<GribPDSParamTable> aTables) throws IOException {
        String line;
        if (is == null) {
            return false;
        }
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            GribPDSParamTable table = new GribPDSParamTable();
            String[] tableDefArr = line.split(":");
            table.center_id = Integer.parseInt(tableDefArr[0].trim());
            table.subcenter_id = Integer.parseInt(tableDefArr[1].trim());
            table.table_number = Integer.parseInt(tableDefArr[2].trim());
            table.filename = tableDefArr[3].trim();
            if (table.filename.startsWith("/") || table.filename.startsWith("\\") || table.filename.startsWith("file:") || table.filename.startsWith("http://")) {
                table.path = table.filename;
            } else if (aTableList != null) {
                table.path = GribResourceReader.getFileRoot(aTableList);
                table.path = table.path.equals(aTableList) ? table.filename : table.path + "/" + table.filename;
                table.path = table.path.replace('\\', '/');
            }
            aTables.add(table);
        }
        is.close();
        return true;
    }

    public static GribPDSParamTable getParameterTable(int center, int subcenter, int number) throws NotSupportedException {
        String key = center + "_" + subcenter + "_" + number;
        if (center == -1) {
            logger.error("GribPDSParamTable: non existent table for center, subcenter, table = " + key);
            return null;
        }
        GribPDSParamTable table = tableMap.get(key);
        if (table != null) {
            return table;
        }
        table = GribPDSParamTable.readParameterTable(center, subcenter, number, true);
        if (table == null) {
            logger.error("GribPDSParamTable: cannot find table for center, subcenter, table " + key);
            throw new NotSupportedException("Could not find a table entry for GRIB file with center: " + center + " subCenter: " + subcenter + " number: " + number);
        }
        tableMap.put(key, table);
        return table;
    }

    private static GribPDSParamTable readParameterTable(int center, int subcenter, int number, boolean firstTry) {
        GribPDSParamTable[] localCopy;
        for (GribPDSParamTable table : localCopy = paramTables) {
            if (center != table.center_id || table.subcenter_id != -1 && subcenter != table.subcenter_id || number != table.table_number) continue;
            if (table.parameters == null) {
                if (!firstTry) {
                    logger.warn("GribPDSParamTable: Using default table:" + table.path + " (" + table.center_id + ":" + table.subcenter_id + ":" + table.table_number + ")");
                }
                table.readParameterTable();
                if (table.parameters == null) continue;
                for (int j = 0; j < paramTables.length; ++j) {
                    GribPDSParamTable tab = paramTables[j];
                    if (!tab.path.equals(table.path)) continue;
                    tab.parameters = table.parameters;
                }
            }
            return table;
        }
        if (number != -1) {
            return GribPDSParamTable.readParameterTable(center, subcenter, -1, false);
        }
        if (subcenter != -1) {
            logger.warn("GribPDSParamTable: Could not find table for center:" + center + " subcenter:" + subcenter + " number:" + number);
            return GribPDSParamTable.readParameterTable(center, -1, -1, false);
        }
        if (center != -1) {
            return GribPDSParamTable.readParameterTable(-1, -1, -1, false);
        }
        return null;
    }

    private static String makeValidDesc(String description) {
        if (valid.matcher(description = description.replaceAll("\\s+", "_")).find()) {
            return description;
        }
        if (numberFirst.matcher(description).find()) {
            description = "N" + description;
        }
        return description.replaceAll("\\)|\\(|=|,|;|\\[|\\]", "");
    }

    private GribPDSParamTable() {
    }

    private void readParameterTable() {
        if (this.path == null) {
            return;
        }
        try {
            InputStream is = GribPDSParamTable.getInputStream(this.path);
            if (is == null) {
                return;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = br.readLine();
            if (debug) {
                System.out.println(line);
            }
            String[] tableDefArr = line.split(":");
            HashMap<String, GridParameter> tmpParameters = new HashMap<String, GridParameter>();
            while ((line = br.readLine()) != null) {
                if (line.length() == 0 || line.startsWith("#")) continue;
                Parameter parameter = new Parameter();
                tableDefArr = line.split(":");
                parameter.setNumber(Integer.parseInt(tableDefArr[0].trim()));
                parameter.setName(tableDefArr[1].trim());
                if (tableDefArr[2].indexOf(91) == -1) {
                    parameter.setDescription(tableDefArr[2].trim());
                    parameter.setUnit(tableDefArr[2].trim());
                } else {
                    String[] arr2 = tableDefArr[2].split("\\[");
                    parameter.setDescription(GribPDSParamTable.makeValidDesc(arr2[0].trim()));
                    parameter.setUnit(arr2[1].substring(0, arr2[1].lastIndexOf(93)).trim());
                }
                tmpParameters.put(Integer.toString(parameter.getNumber()), parameter);
                if (!debug) continue;
                System.out.println(parameter.getNumber() + " " + parameter.getDescription() + " " + parameter.getUnit());
            }
            this.parameters = tmpParameters;
        }
        catch (IOException ioError) {
            logger.warn("An error occurred in GribPDSParamTable while trying to open the parameter table " + this.filename + " : " + ioError);
        }
    }

    public GridParameter getParameter(int id) {
        GridParameter p = this.parameters.get(Integer.toString(id));
        if (p != null) {
            return p;
        }
        logger.warn("GribPDSParamTable: Could not find parameter " + id + " for center:" + this.center_id + " subcenter:" + this.subcenter_id + " number:" + this.table_number);
        return new GridParameter(id, "Unknown", "Unknown", "Unknown");
    }

    public static void main(String[] args) {
        debug = true;
        GribPDSParamTable.readParameterTable(59, 2, 0, true);
    }

    static {
        try {
            ArrayList<GribPDSParamTable> tables = new ArrayList<GribPDSParamTable>();
            GribPDSParamTable.initFromJAR(tables);
            paramTables = tables.toArray(new GribPDSParamTable[tables.size()]);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

