/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.Location;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.codec.ByteVector;

public class ICSReader
extends FormatReader {
    private static final String[] CATEGORIES = new String[]{"ics_version", "filename", "source", "layout", "representation", "parameter", "sensor", "history", "document", "view", "end"};
    private static final String[] SUB_CATEGORIES = new String[]{"file", "offset", "parameters", "order", "sizes", "coordinates", "significant_bits", "format", "sign", "compression", "byte_order", "origin", "scale", "units", "labels", "SCIL_TYPE", "type", "model", "s_params", "laser", "gain1", "gain2", "gain3", "gain4", "dwell", "shutter1", "shutter2", "shutter3", "pinhole", "laser1", "laser2", "laser3", "objective", "PassCount", "step1", "step2", "step3", "view", "view1", "date", "GMTdate", "label"};
    private static final String[] SUB_SUB_CATEGORIES = new String[]{"Channels", "PinholeRadius", "LambdaEx", "LambdaEm", "ExPhotonCnt", "RefInxMedium", "NumAperture", "RefInxLensMedium", "PinholeSpacing", "power", "wavelength", "name", "Type", "Magnification", "NA", "WorkingDistance", "Immersion", "Pinhole", "Channel 1", "Channel 2", "Channel 3", "Channel 4", "Gain 1", "Gain 2", "Gain 3", "Gain 4", "Shutter 1", "Shutter 2", "Shutter 3", "Position", "Size", "Port", "Cursor", "Color", "BlackLevel", "Saturation", "Gamma", "IntZoom", "Live", "Synchronize", "ShowIndex", "AutoResize", "UseUnits", "Zoom", "IgnoreAspect", "ShowCursor", "ShowAll", "Axis", "Order", "Tile", "scale", "DimViewOption"};
    protected String currentIcsId;
    protected String currentIdsId;
    protected Location icsIn;
    protected int bitsPerPixel;
    protected boolean versionTwo;
    protected byte[] data;

    public ICSReader() {
        super("Image Cytometry Standard", new String[]{"ics", "ids"});
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        int bpp = this.bitsPerPixel / 8;
        int len = this.core.sizeX[0] * this.core.sizeY[0] * bpp * this.getRGBChannelCount();
        int offset = len * no;
        if (!this.core.rgb[0] && this.core.sizeC[0] > 4) {
            int pt = 0;
            for (int i = no * bpp; i < this.data.length; i += this.core.sizeC[0] * bpp) {
                System.arraycopy(this.data, i, buf, pt, bpp);
                pt += bpp;
            }
        } else {
            System.arraycopy(this.data, offset, buf, 0, len);
        }
        return buf;
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.versionTwo) {
            return new String[]{this.currentIdsId == null ? "" : this.currentIdsId};
        }
        return new String[]{this.currentIdsId, this.currentIcsId};
    }

    public void close() throws IOException {
        super.close();
        this.icsIn = null;
        this.currentIcsId = null;
        this.currentIdsId = null;
        this.data = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        String test;
        boolean gzip;
        char[] c;
        String ext;
        if (debug) {
            this.debug("ICSReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.status("Finding companion file");
        String icsId = id;
        String idsId = id;
        int dot = id.lastIndexOf(".");
        String string = ext = dot < 0 ? "" : id.substring(dot + 1).toLowerCase();
        if (ext.equals("ics")) {
            c = idsId.toCharArray();
            int n = c.length - 2;
            c[n] = (char)(c[n] + '\u0001');
            idsId = new String(c);
        } else if (ext.equals("ids")) {
            c = icsId.toCharArray();
            int n = c.length - 2;
            c[n] = (char)(c[n] - '\u0001');
            icsId = new String(c);
        }
        if (icsId == null) {
            throw new FormatException("No ICS file found.");
        }
        Location icsFile = new Location(icsId);
        if (!icsFile.exists()) {
            throw new FormatException("ICS file not found.");
        }
        this.status("Checking file version");
        RandomAccessStream f = new RandomAccessStream(icsId);
        byte[] b = new byte[17];
        f.read(b);
        f.close();
        if (new String(b).trim().equals("ics_version\t2.0")) {
            this.in = new RandomAccessStream(icsId);
            this.versionTwo = true;
        } else {
            if (idsId == null) {
                throw new FormatException("No IDS file found.");
            }
            Location idsFile = new Location(idsId);
            if (!idsFile.exists()) {
                throw new FormatException("IDS file not found.");
            }
            this.currentIdsId = idsId;
            this.in = new RandomAccessStream(idsId);
        }
        this.currentIcsId = icsId;
        this.icsIn = icsFile;
        this.status("Reading metadata");
        String layoutSizes = null;
        String layoutOrder = null;
        String byteOrder = null;
        String rFormat = null;
        String compression = null;
        String scale = null;
        RandomAccessStream reader = new RandomAccessStream(this.icsIn.getAbsolutePath());
        String s = reader.readString((int)reader.length());
        reader.close();
        StringTokenizer st = new StringTokenizer(s, "\n");
        String line = st.nextToken();
        line = st.nextToken();
        while (line != null && !line.trim().equals("end")) {
            StringTokenizer t = new StringTokenizer(line);
            StringBuffer key = new StringBuffer();
            while (t.hasMoreTokens()) {
                int i;
                String token = t.nextToken();
                boolean foundValue = true;
                for (i = 0; i < CATEGORIES.length; ++i) {
                    if (!token.equals(CATEGORIES[i])) continue;
                    foundValue = false;
                }
                for (i = 0; i < SUB_CATEGORIES.length; ++i) {
                    if (!token.equals(SUB_CATEGORIES[i])) continue;
                    foundValue = false;
                }
                for (i = 0; i < SUB_SUB_CATEGORIES.length; ++i) {
                    if (!token.equals(SUB_SUB_CATEGORIES[i])) continue;
                    foundValue = false;
                }
                if (foundValue) {
                    StringBuffer value = new StringBuffer();
                    value.append(token);
                    while (t.hasMoreTokens()) {
                        value.append(" ");
                        value.append(t.nextToken());
                    }
                    String k = key.toString().trim();
                    String v = value.toString().trim();
                    this.addMeta(k, v);
                    if (k.equals("layout sizes")) {
                        layoutSizes = v;
                        continue;
                    }
                    if (k.equals("layout order")) {
                        layoutOrder = v;
                        continue;
                    }
                    if (k.equals("representation byte_order")) {
                        byteOrder = v;
                        continue;
                    }
                    if (k.equals("representation format")) {
                        rFormat = v;
                        continue;
                    }
                    if (k.equals("representation compression")) {
                        compression = v;
                        continue;
                    }
                    if (!k.equals("parameter scale")) continue;
                    scale = v;
                    continue;
                }
                key.append(token);
                key.append(" ");
            }
            if (st.hasMoreTokens()) {
                line = st.nextToken();
                continue;
            }
            line = null;
        }
        this.status("Populating metadata");
        layoutOrder = layoutOrder.trim();
        StringTokenizer t1 = new StringTokenizer(layoutSizes);
        StringTokenizer t2 = new StringTokenizer(layoutOrder);
        boolean bl = this.core.rgb[0] = layoutOrder.indexOf("ch") >= 0 && layoutOrder.indexOf("ch") < layoutOrder.indexOf("x");
        while (t1.hasMoreTokens() && t2.hasMoreTokens()) {
            String imageToken = t1.nextToken().trim();
            String orderToken = t2.nextToken().trim();
            if (orderToken.equals("bits")) {
                this.bitsPerPixel = Integer.parseInt(imageToken);
                continue;
            }
            if (orderToken.equals("x")) {
                this.core.sizeX[0] = Integer.parseInt(imageToken);
                continue;
            }
            if (orderToken.equals("y")) {
                this.core.sizeY[0] = Integer.parseInt(imageToken);
                continue;
            }
            if (orderToken.equals("z")) {
                this.core.sizeZ[0] = Integer.parseInt(imageToken);
                continue;
            }
            if (orderToken.equals("ch")) {
                this.core.sizeC[0] = Integer.parseInt(imageToken);
                if (this.core.sizeC[0] <= 4) continue;
                this.core.rgb[0] = false;
                continue;
            }
            this.core.sizeT[0] = Integer.parseInt(imageToken);
        }
        if (this.core.sizeZ[0] == 0) {
            this.core.sizeZ[0] = 1;
        }
        if (this.core.sizeC[0] == 0) {
            this.core.sizeC[0] = 1;
        }
        if (this.core.sizeT[0] == 0) {
            this.core.sizeT[0] = 1;
        }
        if (this.core.imageCount[0] == 0) {
            this.core.imageCount[0] = 1;
        }
        this.core.rgb[0] = this.core.rgb[0] && this.core.sizeC[0] > 1;
        this.core.interleaved[0] = this.core.rgb[0];
        this.core.imageCount[0] = this.core.sizeZ[0] * this.core.sizeT[0];
        if (!this.core.rgb[0]) {
            this.core.imageCount[0] = this.core.imageCount[0] * this.core.sizeC[0];
        }
        this.core.indexed[0] = false;
        this.core.falseColor[0] = false;
        this.core.metadataComplete[0] = true;
        String endian = byteOrder;
        this.core.littleEndian[0] = true;
        if (endian != null) {
            StringTokenizer endianness = new StringTokenizer(endian);
            String firstByte = endianness.nextToken();
            int first = Integer.parseInt(firstByte);
            this.core.littleEndian[0] = rFormat.equals("real") ? first == 1 : first != 1;
        }
        boolean bl2 = gzip = (test = compression) == null ? false : test.equals("gzip");
        if (this.versionTwo) {
            s = this.in.readLine();
            while (!s.trim().equals("end")) {
                s = this.in.readLine();
            }
        }
        this.data = new byte[(int)(this.in.length() - this.in.getFilePointer())];
        if (gzip && this.data.length / this.core.imageCount[0] < this.core.sizeX[0] * this.core.sizeY[0] * this.bitsPerPixel / 8) {
            this.status("Decompressing pixel data");
            this.in.read(this.data);
            byte[] buf = new byte[8192];
            ByteVector v = new ByteVector();
            try {
                GZIPInputStream decompressor = new GZIPInputStream(new ByteArrayInputStream(this.data));
                int r = decompressor.read(buf, 0, buf.length);
                while (r > 0) {
                    v.add(buf, 0, r);
                    r = decompressor.read(buf, 0, buf.length);
                }
                this.data = v.toByteArray();
            }
            catch (IOException dfe) {
                throw new FormatException("Error uncompressing gzip'ed data", dfe);
            }
        } else {
            this.in.readFully(this.data);
        }
        this.status("Populating metadata");
        MetadataStore store = this.getMetadataStore();
        String fname = (String)this.getMeta("filename");
        if (fname == null) {
            fname = this.currentId;
        }
        store.setImage(fname, null, null, null);
        String o = layoutOrder;
        o = o.trim();
        o = o.substring(o.indexOf("x")).trim();
        char[] tempOrder = new char[o.length() / 2 + 1];
        int pt = 0;
        for (int i = 0; i < o.length(); i += 2) {
            tempOrder[pt] = o.charAt(i);
            ++pt;
        }
        o = new String(tempOrder).toUpperCase().trim();
        if (o.indexOf("Z") == -1) {
            o = o + "Z";
        }
        if (o.indexOf("T") == -1) {
            o = o + "T";
        }
        if (o.indexOf("C") == -1) {
            o = o + "C";
        }
        String fmt = rFormat;
        if (this.bitsPerPixel < 32) {
            boolean bl3 = this.core.littleEndian[0] = !this.core.littleEndian[0];
        }
        if (fmt.equals("real")) {
            this.core.pixelType[0] = 6;
        } else if (fmt.equals("integer")) {
            while (this.bitsPerPixel % 8 != 0) {
                ++this.bitsPerPixel;
            }
            if (this.bitsPerPixel == 24 || this.bitsPerPixel == 48) {
                this.bitsPerPixel /= 3;
            }
            switch (this.bitsPerPixel) {
                case 8: {
                    this.core.pixelType[0] = 1;
                    break;
                }
                case 16: {
                    this.core.pixelType[0] = 3;
                    break;
                }
                case 32: {
                    this.core.pixelType[0] = 5;
                }
            }
        } else {
            throw new RuntimeException("Unknown pixel format: " + this.format);
        }
        this.core.currentOrder[0] = o.trim();
        FormatTools.populatePixels(store, this);
        String pixelSizes = scale;
        o = layoutOrder;
        if (pixelSizes != null) {
            StringTokenizer pixelSizeTokens = new StringTokenizer(pixelSizes);
            StringTokenizer axisTokens = new StringTokenizer(o);
            Float pixX = null;
            Float pixY = null;
            Float pixZ = null;
            Float pixC = null;
            Float pixT = null;
            while (pixelSizeTokens.hasMoreTokens()) {
                String axis = axisTokens.nextToken().trim().toLowerCase();
                String size = pixelSizeTokens.nextToken().trim();
                if (axis.equals("x")) {
                    pixX = new Float(size);
                    continue;
                }
                if (axis.equals("y")) {
                    pixY = new Float(size);
                    continue;
                }
                if (axis.equals("ch")) {
                    pixC = new Float(size);
                    continue;
                }
                if (axis.equals("z")) {
                    pixZ = new Float(size);
                    continue;
                }
                if (!axis.equals("t")) continue;
                pixT = new Float(size);
            }
            store.setDimensions(pixX, pixY, pixZ, pixC, pixT, null);
        }
        String em = (String)this.getMeta("sensor s_params LambdaEm");
        String ex = (String)this.getMeta("sensor s_params LambdaEx");
        int[] emWave = new int[this.core.sizeC[0]];
        int[] exWave = new int[this.core.sizeC[0]];
        if (em != null) {
            StringTokenizer emTokens = new StringTokenizer(em);
            for (int i = 0; i < this.core.sizeC[0]; ++i) {
                emWave[i] = (int)Float.parseFloat(emTokens.nextToken().trim());
            }
        }
        if (ex != null) {
            StringTokenizer exTokens = new StringTokenizer(ex);
            for (int i = 0; i < this.core.sizeC[0]; ++i) {
                exWave[i] = (int)Float.parseFloat(exTokens.nextToken().trim());
            }
        }
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new Integer(emWave[i]), new Integer(exWave[i]), null, null, null);
        }
    }
}

