.TH LIST 3  "September 22, 1991"
.UC 6
.SH NAME
list_init, list_mvprev, list_mvnext, list_mvfront, list_mvrear, list_front, list_curr, list_rear, list_insert_before, list_insert_after, list_remove_front, list_remove_curr, list_remove_rear, list_size, list_empty, list_traverse, list_free \-- generic linked-list routines
.SH SYNOPSIS
.PP
cc [
.I flags 
]
.IR files
.B -llist 
[ 
.IR libraries
]
.nf
.PP
.ft B
\#include <list.h>
.PP
.ft B
LIST *list_init()
.PP
.ft B
LIST *list_mvprev(list)
    LIST *list;
.PP
.ft B
LIST *list_mvnext(list)
    LIST *list;
.PP
.ft B
LIST *list_mvfront(list)
    LIST *list;
.PP
.ft B
LIST *list_mvrear(list)
    LIST *list;
.PP
.ft B
char *list_front(list)
    LIST *list;
.PP
.ft B
char *list_curr(list)
    LIST *list;
.PP
.ft B
char *list_rear(list)
    LIST *list;
.PP
.ft B
char *list_insert_before(list, data, bytes)
    LIST *list;
    char *data;
    int bytes;
.PP
.ft B
char *list_insert_after(list, data, bytes)
    LIST *list;
    char *data;
    int bytes;
.PP
.ft B
char *list_remove_front(list)
    LIST *list;
.PP
.ft B
char *list_remove_curr(list)
    LIST *list;
.PP
.ft B
char *list_remove_rear(list)
    LIST *list;
.PP
.ft B
int list_size(list)
    LIST *list;
.PP
.ft B
int list_empty(list)
    LIST *list;
.PP
.ft B
int list_traverse(list, data, func, opts)
    LIST *list;
    char *data;
    int (*func)();
    int opts;
.PP
.ft B
void list_free(list, dealloc)
    LIST *list;
    void (*dealloc)();
.PP
.SH DESCRIPTION
These routines provide generic manipulation of (potentially)
multiple linked lists.  Each list can hold arbitrarily sized elements, with
individual elements within a list varying in size.  It is the
programmers responsibility to account for such differences.

Lists are referred to by variables declared as LIST *; the type LIST
is defined in <list.h> to be a C structure.  Each descriptor maintains
references to the front, rear, and current elements, as well as the
size (or length) of the list.  Various routines operate relative to the
current element.
.PP
.IR list_init
initializes and returns a list descriptor.
.PP
.IR list_mvprev ,
.IR list_mvnext ,
.IR list_mvfront ,
.IR list_mvrear ,
move to the previous, next, front, or rear element in
.IR list ,
and return the modified list descriptor.  Movement previous or next is relative
to the current element.
.PP
.IR list_front ,
.IR list_curr ,
and
.IR list_rear 
return pointers to the front, current, or rear element in
.IR list . \c
#ifdef USE_MACROS
This routine is implemented as a macro. \c
#endif
.PP
.IR list_insert_before
and
.IR list_insert_after
insert an element, pointed to by
.IR data
and of size
.IR bytes ,
into
.IR list ,
either before or after the current element.  The newly inserted element is
then considered the current element.  Both routines return a pointer to the
newly inserted data.  If
.IR bytes
is greater than 0, then data is copied into the list, otherwise
only the reference
.IR data
is copied into the list.  This allows the user to determine the
memory allocation policy.
.PP
.IR list_remove_front ,
.IR list_remove_curr ,
and
.IR list_remove_rear 
remove the front, current, or rear element from
.IR list 
and return a pointer to the removed data.
The current element is then set to the next element (prior to the remove) in
the list, unless the element at the rear of the list was removed.  In this
case, the current element is set to the previous element (prior to the
remove).
.PP
.IR list_size
returns the size (or number of elements) of
.IR list
as an integer. \c
#ifdef USE_MACROS
This routine is implemented as a macro. \c
#endif
.PP
.IR list_empty
returns 1 (TRUE) if
.IR list
is empty, 0 (FALSE) otherwise. \c
#ifdef USE_MACROS
This routine is implemented as a macro. \c
#endif
.PP
.IR list_traverse
traverses
.IR list
according to
.IR opts ,
calling
.IR func
at each element encountered in the traversal, until
.IR func
returns 0 (FALSE) or the extent of the list is reached.  This routine
can be used to search for an item or print the contents of the list,
for example.  See the section LIST TRAVERSAL for more information.
.PP
.IR list_free
deallocates
.IR list,
applying the user-supplied function
.IR dealloc
to the data portion of each element remaining in the list.  If
.IR dealloc
is LIST_DEALLOC, then the package will apply its own deallocation
routine.  This, however, should only be done if the package has been
responsible for data element allocation, i.e., the insert routines
have been invoked with
.IR bytes
greater than 0.  If
.IR dealloc
is LIST_NODEALLOC, no per-element deallocation will be performed.
.SH LIST TRAVERSAL
The behavior of the routine
.IR list_traversal
is controlled by the user-supplied function
.IR func
which is responsible for the actions performed at each element in the
traversal.  In addition, the scope and direction of the
traversal can be specified with the
.IR opts
parameter.
.IR Func
should be declared as follows:
.PP
.RS
int func(data, curr)
    char *data;
    char *curr;
.RE
.PP
and should return 1 (TRUE) if the traversal should continue, or 0 (FALSE)
if the traversal should terminate.  The function does not need to check
if the extent of the list has been reached; the return code from
.IR list_traverse
will indicate the status of the traversal.  At each element encountered
in the traversal,
.IR list_traverse
will invoke
.IR func ,
passing it the two parameters
.IR data
and
.IR curr ;
.IR data
being the data pointer sent to
.IR list_traverse
originally, and
.IR curr
being the data pointer of the current element in the traversal.  For example,
by passing the following function to
.IR list_traverse ,
the contents of a list of names could be printed.
.PP
.RS
.nf
int func(data, curr)
    char *data;
    char *curr;
{
    printf("Name=%30s.\\n", curr->name);
    return(TRUE);
}
.fi
.RE
.PP
In this example, the parameter
.IR data
is ignored and the function unconditionally returns 1 (TRUE), but functions
like
.PP
.RS
.nf
int func(data, curr)
    char *data;
    char *curr;
{
    if (strcmp(data, curr))
       return(TRUE);
    else
       return(FALSE);
}
.fi
.RE
.PP
can be used to position the current element pointer prior to insertion, so
as to keep the list ordered.  
.PP
The direction and scope of the traversal can be controlled by specifying
one or more of the following options:
.PP
.RS
.nf
.ta 1.0i +1.0i +.5i
LIST_FORW	*	traverse forward (next)
LIST_BACK		traverse backwards (prev)
LIST_FRNT	*	start from the front of the
			list (implies LIST_FORW)
LIST_CURR		start from the current element
LIST_REAR		start from the rear element
			(implies LIST_BACK)
LIST_SAVE	*	do not alter the current element
			pointer during the traversal
LIST_ALTR		alter the current element pointer
			during the traversal
.fi
.RE
.PP
The asterisks (*) denote the default values.  These options can be combined
with the logical OR operator, but at least one value must be specified.
For example, specifying
.PP
.RS
LIST_FORW
.RE
.PP
for
.IR opts
would request a traversal forwards from the current position,
restoring the current element pointer after the traversal, whereas
.PP
.RS
(LIST_BACK | LIST_CURR | LIST_ALTR)
.RE
.PP
would request a traversal backwards from the current position, and would
set the current element pointer to the last element encountered in the
traversal.

It should be noted that
.IR func
should not invoke any of the list routines unless LIST_ALTR has been
specified, since many of the routines act relative to the current
element pointer, which is not modified during a traversal with
LIST_SAVE specified.
.SH MEMORY ALLOCATION
The routines
.IR list_init ,
.IR list_insert_before ,
and
.IR list_insert_after
allocate memory during their execution.  As such, 
.IR list_insert_before
and
.IR list_insert_after
insert a copy of the data into the list when they are invoked with
.IR bytes
greater than 0.  If
.IR bytes
is 0, then only the reference is copied into the list.  This allows
the user to control the memory allocation policy.  Both functions may
fail during memory allocation; see DIAGNOSTICS below for more information.

Note that
.IR list_remove_front ,
.IR list_remove_curr ,
and
.IR list_remove_rear
do not allocate memory for the removing data.  They simply disassociate the
data from the list, and thus return a pointer to data that was previously
allocated by the package.  It is the programmers responsibility to deallocate
such removed data.

If the user has been responsile for data element storage allocation, i.e. the
insert routines have been called with
.IR bytes
equal to 0, then the user must be responsible for storage deallocation
as well.  A user-supplied deallocation function should be passed to
.IR list_free
for this purpose.  The deallocation function should be declared as:
.PP
.RS
void dealloc(data)
   char *data;
.RE
.PP
and will be sent the data element reference of each element in the list
when
.IR list_free
is invoked.  If the package has been responsible for data element allocation,
.IR list_free
can be invoked with LIST_DEALLOC for
.IR dealloc,;
the list package will apply its own deallocation routine, or
LIST_NODEALLOC if no per-element deallocation is required.  It is the
programmers responsibility to insure that the memory allocation
policy is applied properly.
.SH DIAGNOSTICS
A NULL returned by
.IR list_init ,
.IR list_insert_before ,
or
.IR list_insert_after
indicates a failure in allocating memory for the new list or element.  See
.IR malloc (3)
for more information.

.IR list_mvprev ,
.IR list_mvnext ,
.IR list_mvfront ,
.IR list_mvrear ,
.IR list_front ,
.IR list_curr ,
.IR list_rear ,
.IR list_remove_front,
.IR list_remove_curr,
and
.IR list_remove_rear
all return NULL if
.IR list
is empty.

.IR list_traverse
returns LIST_EMPTY for an empty list, LIST_EXTENT if an attempt was
made to move beyond the extent of the list, or LIST_OK otherwise.

A core dump indicates a bug ;-)
.SH BUGS
The routines
.IR list_remove_front ,
.IR list_remove_curr ,
.IR list_remove_rear ,
and
.IR list_free
do not physically reclaim storage space, although they do make it
available for reuse.  While this is a function of
.IR free (3),
its application here could be considered a bug.
.SH SEE ALSO
queue(3), stack(3), cache(3)
.SH AUTHOR
Bradley C. Spatz (bcs@ufl.edu), University of Florida.
