#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("toggles all output settings")

    def run(self):
        if self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "speech", "enabled"
        ) or self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "sound", "enabled"
        ):
            self.env["runtime"]["OutputManager"].present_text(
                _("Fenrir muted"), sound_icon="Accept", interrupt=True
            )
            self.env["runtime"]["SettingsManager"].set_setting(
                "speech", "enabled", "False"
            )
            self.env["runtime"]["SettingsManager"].set_setting(
                "sound", "enabled", "False"
            )
        else:
            self.env["runtime"]["SettingsManager"].set_setting(
                "speech", "enabled", "True"
            )
            self.env["runtime"]["SettingsManager"].set_setting(
                "sound", "enabled", "True"
            )
            self.env["runtime"]["OutputManager"].present_text(
                _("Fenrir unmuted"), sound_icon="Cancel", interrupt=True
            )

    def set_callback(self, callback):
        pass
