#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import char_utils


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("move review to top of screen")

    def run(self):
        self.env["screen"]["newCursorReview"] = {"x": 0, "y": 0}
        self.env["runtime"]["OutputManager"].present_text(
            _("Top"), interrupt=True, flush=False
        )

    def set_callback(self, callback):
        pass
