/* $Id: Connect.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Connect: Connect a driver to a signal.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __CONNECT_HPP_INCLUDED
#define __CONNECT_HPP_INCLUDED

#include "intermediate/opcodes/OpCode.hpp"
#include "intermediate/operands/Operand.hpp"

namespace intermediate {

//! Connect a driver to a signal.
/** This class can be used to connect a driver to a given signal.
 *  
 *  Read operands: drv, sig
 *  Write operands: None.
 *
 *  Operation:
 *     Call an external mechanism to connect the driver to the signal.
 */
class Connect : public OpCode {
public:
	//! c'tor
	/** @param drv Operand referring to a driver pointer.
	 *  @param sig Operand referring to a signal pointer.
	 */
	Connect(Operand *drv, Operand *sig) : driver(drv), signal(sig) {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	//! driver to connect.
	Operand *driver;
	//! signal the driver gets connected to.
	Operand *signal;

protected:
	virtual ~Connect() {
		util::MiscUtil::terminate(this->driver);
		util::MiscUtil::terminate(this->signal);
	}

};

}; /* namespace intermediate */

#endif /* __CONNECT_HPP_INCLUDED */
