/* $Id: TypeConversion.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __TYPE_CONVERSION_HPP_INCLUDED
#define __TYPE_CONVERSION_HPP_INCLUDED

#include "frontend/ast/Expression.hpp"
#include "frontend/ast/TypeDeclaration.hpp"

namespace ast {

/** convert a source expression to a target type.
 *  This class represents both explicit VHDL type conversions as well
 *  as implicit type conversions, which type analysis will insert at
 *  the places in question.
 */
class TypeConversion : public Expression {
public:
	/** c'tor
	 *  @param src source expression
	 *  @param trg type to which source should get converted to.
	 *  @param loc Location of the type conversion in question.
	 */
	TypeConversion(
		Expression *src,
		const TypeDeclaration *trg,
		Location loc
		) : 	Expression(loc),
			source(src),
			targetType(trg)	{}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor &visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << this->targetType << '(' << this->source << ')';
	}


	/** source Expression of the TypeConversion */
	Expression *source;
	/** type to which source should get converted to. 
	 *  doesn't get reference counted. */
	const TypeDeclaration *targetType;

protected:
	/** Destructor */
	virtual ~TypeConversion() {
		util::MiscUtil::terminate(source);
	}
}; 

}; /* namespace ast */

#endif /* __TYPE_CONVERSION_HPP_INCLUDED */
