/*
 * Decompiled with CFR 0.152.
 */
package dumphd.util;

public class ByteArray {
    public static int getUByte(byte[] source, int index) {
        return source[index] & 0xFF;
    }

    public static int getUShort(byte[] source, int index) {
        int output = (source[index] & 0xFF) << 8;
        return output |= source[index + 1] & 0xFF;
    }

    public static long getUInt(byte[] source, int index) {
        long output = ((long)source[index] & 0xFFL) << 24;
        output |= ((long)source[index + 1] & 0xFFL) << 16;
        output |= ((long)source[index + 2] & 0xFFL) << 8;
        return output |= (long)source[index + 3] & 0xFFL;
    }

    public static int getInt(byte[] source, int index) {
        int output = (source[index] & 0xFF) << 24;
        output |= (source[index + 1] & 0xFF) << 16;
        output |= (source[index + 2] & 0xFF) << 8;
        return output |= source[index + 3] & 0xFF;
    }

    public static long getLong(byte[] source, int index) {
        long output = ((long)source[index] & 0xFFL) << 56;
        output |= ((long)source[index + 1] & 0xFFL) << 48;
        output |= ((long)source[index + 2] & 0xFFL) << 40;
        output |= ((long)source[index + 3] & 0xFFL) << 32;
        output |= ((long)source[index + 4] & 0xFFL) << 24;
        output |= ((long)source[index + 5] & 0xFFL) << 16;
        output |= ((long)source[index + 6] & 0xFFL) << 8;
        return output |= (long)source[index + 7] & 0xFFL;
    }

    public static long getVarLong(byte[] source, int index, int length) {
        long output = 0L;
        int i = 0;
        while (i < length) {
            output |= ((long)source[index + i] & 0xFFL) << (length - i - 1) * 8;
            ++i;
        }
        return output;
    }

    public static void setByte(byte[] source, int index, int data) {
        source[index] = (byte)data;
    }

    public static void setShort(byte[] source, int index, int data) {
        source[index + 1] = (byte)data;
        source[index] = (byte)(data >>>= 8);
    }

    public static void setInt(byte[] source, int index, int data) {
        source[index + 3] = (byte)data;
        source[index + 2] = (byte)(data >>>= 8);
        source[index + 1] = (byte)(data >>>= 8);
        source[index] = (byte)(data >>>= 8);
    }

    public static void setLong(byte[] source, int index, long data) {
        source[index + 7] = (byte)data;
        source[index + 6] = (byte)(data >>>= 8);
        source[index + 5] = (byte)(data >>>= 8);
        source[index + 4] = (byte)(data >>>= 8);
        source[index + 3] = (byte)(data >>>= 8);
        source[index + 2] = (byte)(data >>>= 8);
        source[index + 1] = (byte)(data >>>= 8);
        source[index] = (byte)(data >>>= 8);
    }

    public static void setVarLong(byte[] source, int index, long data, int length) {
        int i = 0;
        while (i < length) {
            source[index + length - i - 1] = (byte)data;
            data >>>= 8;
            ++i;
        }
    }
}

