#ifndef QTDPUSER_H
#define QTDPUSER_H

#include <QWidget>
#include <QLineEdit>
#include <QStringList>
#include <QStatusBar>
#include <QLabel>
#include <QString>
#include <QThread>
#include <QTextEdit>
#include <QEvent>
#include <QMutex>

//#include "QFitsGlobal.h"
class QFitsSimplestButton;

//extern QMutex *dpusermutex;
extern QMutex *qtinputmutex;
extern QStringList qtinput;
extern bool DPUSERbusy;

class dpuser_thread : public QThread {
    Q_OBJECT
public:
    virtual void run();
    void dosleep(int i) { msleep(i); }
    void sendText(const QString &text) { emit dpuserText(text); }
    void sendProgress(const int &onWhich, const char *onText) {
        emit dpuserProgress(onWhich, QString(onText));
    }
    void sendHelp(const QString &request) { emit dpuserHelp(request); }
    void sendVar(const int &which);
    void sendPgplot(const int &which, const QImage &image) { emit pgplotUpdate(which, image); }
    void sendPgplot(const int &which, const int &w, const int &h) { emit pgplotUpdate(which, w, h); }
signals:
    void dpuserText(const QString &);
    void dpuserProgress(const int &onWhich, const QString &onText);
    void dpuserHelp(const QString &);
    void dpuserVar(const int &which);
    void pgplotUpdate(const int &which, const QImage &image);
    void pgplotUpdate(const int &which, const int &w, const int &h);
};

extern dpuser_thread dpuserthread;

class dpuserOutput : public QTextEdit {
    Q_OBJECT
public:
    dpuserOutput(QWidget *);
protected:
    virtual void focusInEvent(QFocusEvent *e);
    virtual void dropEvent(QDropEvent *e);
signals:
    void pasteRequested();
public slots:
    void paste();
};

extern dpuserOutput *hist;

class qtdpuserInput : public QLineEdit {
    Q_OBJECT
public:
    qtdpuserInput(QWidget *parent = NULL);
protected:
    bool event(QEvent *e);
    virtual void keyPressEvent(QKeyEvent *e);
    virtual void dropEvent(QDropEvent *e);
signals:
    void tabPressed();
    void upPressed();
    void downPressed();
    void pasteRequested();
public slots:
    void paste();
};	

class qtdpuser : public QWidget {
    Q_OBJECT
public:
    qtdpuser(QWidget *parent = NULL);
    qtdpuserInput *input;
    QStringList *list;
    dpuserOutput *history;
    QStringList::const_iterator histpos;
    QLabel *prompt;
    QFitsSimplestButton *hideButton;
    void executeCommand(const QString &);
    void executeScript(const QStringList &);
    virtual void keyPressEvent(QKeyEvent *e);
    QString oldfont;
    int oldfontsize;
    void dropEvent(QDropEvent* event);
signals:
    void statusbartext(const QString &);
    void dpuserExited();
public slots:
    void appendHistory();
    void fileNameCompletion();
    void historyUp();
    void historyDown();
    void dpuserText(const QString &);
    void paste();
    void fontchanged();
protected:
    virtual void resizeEvent( QResizeEvent *e );
    virtual void enterEvent(QEvent *);
};

/* Utility function to easily request help */
void dpDisplayOutput(const QString &what);

#endif /* QTDPUSER_H */
