/*

   Derby - Class org.apache.derby.impl.jdbc.EmbedPreparedStatement30

   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to you under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 */

package org.apache.derby.impl.jdbc;

import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.Util;

import org.apache.derby.iapi.sql.ResultSet;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.net.URL;

/**
 * This class extends the EmbedPreparedStatement20 class
 * in order to support new methods and classes that come with JDBC 3.0.

  <P><B>Supports</B>
   <UL>
   <LI> JDBC 3.0 - dependency on java.sql.ParameterMetaData introduced in JDBC 3.0 
   </UL>

  * @see org.apache.derby.impl.jdbc.EmbedPreparedStatement
 *
 */
public class EmbedPreparedStatement30 extends EmbedPreparedStatement20
{

	//////////////////////////////////////////////////////////////
	//
	// CONSTRUCTORS
	//
	//////////////////////////////////////////////////////////////
	/*
		Constructor assumes caller will setup context stack
		and restore it.
	    @exception SQLException on error
	 */
	public EmbedPreparedStatement30 (EmbedConnection conn, String sql, boolean forMetaData,
									  int resultSetType, int resultSetConcurrency, int resultSetHoldability,
									  int autoGeneratedKeys, int[] columnIndexes, String[] columnNames)
		throws SQLException {

		super(conn, sql, forMetaData, resultSetType, resultSetConcurrency, resultSetHoldability,
		autoGeneratedKeys, columnIndexes, columnNames);
	}

	/**
    * JDBC 3.0
    *
    * Retrieves the number, types and properties of this PreparedStatement
    * object's parameters.
    *
    * @return a ParameterMetaData object that contains information about the
    * number, types and properties of this PreparedStatement object's parameters.
    * @exception SQLException if a database access error occurs
	*/
	public ParameterMetaData getParameterMetaData()
    throws SQLException
	{
	  checkStatus();
	  return new EmbedParameterMetaData30(
				getParms(), preparedStatement.getParameterTypes());
	}
}

