% Generated by roxygen2 (4.0.2): do not edit by hand
\name{dbColumnInfo}
\alias{dbColumnInfo}
\title{Information about result types.}
\usage{
dbColumnInfo(res, ...)
}
\arguments{
\item{res}{An object inheriting from \code{\linkS4class{DBIResult}}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
A data.frame with one row per output field in \code{res}. Methods
  MUST include \code{name}, \code{field.type} (the SQL type),
  and \code{data.type} (the R data type) columns, and MAY contain other
  database specific information like scale and precision or whether the
  field can store \code{NULL}s.
}
\description{
Produces a data.frame that describes the output of a query. The data.frame
should have as many rows as there are output fields in the result set, and
each column in the data.frame should describe an aspect of the result set
field (field name, type, etc.)
}
\seealso{
Other DBIResult generics: \code{\link{dbClearResult}};
  \code{\link{dbFetch}},
  \code{\link{dbFetch,DBIResult-method}},
  \code{\link{fetch}}; \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowCount,DBIResult-method}};
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetRowsAffected,DBIResult-method}};
  \code{\link{dbGetStatement}},
  \code{\link{dbGetStatement,DBIResult-method}};
  \code{\link{dbHasCompleted}},
  \code{\link{dbHasCompleted,DBIResult-method}}
}

