#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""glal_selected.py """

# Copyright (C) 2011 Federico Brega

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

import os.path
import sys

INTERFACES = {'qt': 'qt',
              'gtk3': 'gtk3',
              'cli': 'glal.py'}
if_path = os.path.join(os.path.dirname(os.path.abspath(__file__)))
              
def use(lib):
    """Set lib to use"""
    global library

    if not (lib in INTERFACES and os.path.exists(os.path.join(if_path, INTERFACES[lib]))):
        sys.stderr.write(lib + ' interface not installed\n')
        return None
    library = lib
    return library

def getname():
    """Return name of the used interface"""
    return library

# vim:sw=4:softtabstop=4:expandtab
