#include "ipstore"

void IPStore::weed() {
    time_t now = time(0);
    bool done = false;
    
    Mutex::lock(&store);

    while (!done) {
	done = true;
	for (StoreMap::iterator iter = store.begin();
	     iter != store.end();
	     iter++) {
	    if (now - ((*iter).second.lastaccess) > config.ipstoretimeout()) {
		if (config.debug()) {
		    Timestamp tm((*iter).second.lastaccess);
		    _debugmsg (Mstr("Stale entry: ") + Mstr(inet_ntoa(iter->first)) +
			       Mstr(" visited on ") + tm.desc() +
			       ", erasing\n");
		}
		done = false;
		store.erase(iter);
		break;
	    }
	}
    }
    
    Mutex::unlock(&store);
}
