# Системные таблицы

Системные таблицы используются для реализации части функциональности системы, а также предоставляют доступ к информации о работе системы.
Вы не можете удалить системную таблицу (хотя можете сделать DETACH).
Для системных таблиц нет файлов с данными на диске и файлов с метаданными. Сервер создаёт все системные таблицы при старте.
В системные таблицы нельзя записывать данные - можно только читать.
Системные таблицы расположены в базе данных system.

## system.asynchronous_metrics

Содержат метрики, используемые для профилирования и мониторинга.
Обычно отражают количество событий, происходящих в данный момент в системе, или ресурсов, суммарно потребляемых системой.
Пример: количество запросов типа SELECT, исполняемых в текущий момент; количество потребляемой памяти.
`system.asynchronous_metrics` и `system.metrics` отличаются набором и способом вычисления метрик.

## system.clusters

Содержит информацию о доступных в конфигурационном файле кластерах и серверах, которые в них входят.
Столбцы:

```
cluster String      - имя кластера
shard_num UInt32    - номер шарда в кластере, начиная с 1
shard_weight UInt32 - относительный вес шарда при записи данных
replica_num UInt32  - номер реплики в шарде, начиная с 1
host_name String    - имя хоста, как прописано в конфиге
host_address String - IP-адрес хоста, полученный из DNS
port UInt16         - порт, на который обращаться для соединения с сервером
user String         - имя пользователя, которого использовать для соединения с сервером
```
## system.columns

Содержит информацию о столбцах всех таблиц.
С помощью этой таблицы можно получить информацию аналогично запросу `DESCRIBE TABLE`, но для многих таблиц сразу.

```
database String           - имя базы данных, в которой находится таблица
table String              - имя таблицы
name String               - имя столбца
type String               - тип столбца
default_type String       - тип (DEFAULT, MATERIALIZED, ALIAS) выражения для значения по умолчанию, или пустая строка, если оно не описано
default_expression String - выражение для значения по умолчанию, или пустая строка, если оно не описано
```
## system.databases

Таблица содержит один столбец name типа String - имя базы данных.
Для каждой базы данных, о которой знает сервер, будет присутствовать соответствующая запись в таблице.
Эта системная таблица используется для реализации запроса `SHOW DATABASES`.
## system.dictionaries

Содержит информацию о внешних словарях.

Столбцы:

- `name String` — Имя словаря.
- `type String` — Тип словаря: Flat, Hashed, Cache.
- `origin String` — Путь к конфигурационному файлу, в котором описан словарь.
- `attribute.names Array(String)` — Массив имён атрибутов, предоставляемых словарём.
- `attribute.types Array(String)` — Соответствующий массив типов атрибутов, предоставляемых словарём.
- `has_hierarchy UInt8` — Является ли словарь иерархическим.
- `bytes_allocated UInt64` — Количество оперативной памяти, которое использует словарь.
- `hit_rate Float64` — Для cache-словарей - доля использований, для которых значение было в кэше.
- `element_count UInt64` — Количество хранящихся в словаре элементов.
- `load_factor Float64` — Доля заполненности словаря (для hashed словаря - доля заполнения хэш-таблицы).
- `creation_time DateTime` — Время создания или последней успешной перезагрузки словаря.
- `last_exception String` — Текст ошибки, возникшей при создании или перезагрузке словаря, если словарь не удалось создать.
- `source String` - Текст, описывающий источник данных для словаря.


Заметим, что количество оперативной памяти, которое использует словарь, не является пропорциональным количеству элементов, хранящихся в словаре. Так, для flat и cached словарей, все ячейки памяти выделяются заранее, независимо от реальной заполненности словаря.

## system.events

Содержит информацию о количестве произошедших в системе событий, для профилирования и мониторинга.
Пример: количество обработанных запросов типа SELECT.
Столбцы: event String - имя события, value UInt64 - количество.
## system.functions

Содержит информацию об обычных и агрегатных функциях.

Столбцы:

- `name` (`String`) – Имя функции.
- `is_aggregate` (`UInt8`) – Признак, является ли функция агрегатной.
## system.merges

Содержит информацию о производящихся прямо сейчас слияниях для таблиц семейства MergeTree.

Столбцы:

- `database String` — Имя базы данных, в которой находится таблица.
- `table String` — Имя таблицы.
- `elapsed Float64` — Время в секундах, прошедшее от начала выполнения слияния.
- `progress Float64` — Доля выполненной работы от 0 до 1.
- `num_parts UInt64` — Количество сливаемых кусков.
- `result_part_name String` — Имя куска, который будет образован в результате слияния.
- `total_size_bytes_compressed UInt64` — Суммарный размер сжатых данных сливаемых кусков.
- `total_size_marks UInt64` — Суммарное количество засечек в сливаемых кусках.
- `bytes_read_uncompressed UInt64` — Количество прочитанных байт, разжатых.
- `rows_read UInt64` — Количество прочитанных строк.
- `bytes_written_uncompressed UInt64` — Количество записанных байт, несжатых.
- `rows_written UInt64` — Количество записанных строк.

## system.metrics
## system.numbers

Таблица содержит один столбец с именем number типа UInt64, содержащим почти все натуральные числа, начиная с нуля.
Эту таблицу можно использовать для тестов, а также если вам нужно сделать перебор.
Чтения из этой таблицы не распараллеливаются.
## system.numbers_mt

То же самое, что и system.numbers, но чтение распараллеливается. Числа могут возвращаться в произвольном порядке.
Используется для тестов.
## system.one

Таблица содержит одну строку с одним столбцом dummy типа UInt8, содержащим значение 0.
Эта таблица используется, если в SELECT запросе не указана секция FROM.
То есть, это - аналог таблицы DUAL, которую можно найти в других СУБД.

## system.parts

Содержит информацию о кусках таблиц семейства [MergeTree](table_engines/mergetree.md).

Каждая строка описывает один кусок данных.

Столбцы:

- partition (String) - Имя партиции. Что такое партиция можно узнать из описания запроса [ALTER](../query_language/alter.md#query_language_queries_alter).

	Форматы:

	- `YYYYMM` для автоматической схемы партиционирования по месяцам.
	- `any_string` при партиционировании вручную.

- name (String) - Имя куска.
- active (UInt8) - Признак активности. Если кусок активен, то он используется таблице, в противном случает он будет удален. Неактивные куски остаются после слияний.
- marks (UInt64) - Количество засечек. Чтобы получить примерное количество строк в куске, умножьте ``marks`` на гранулированность индекса (обычно 8192).
- marks_size (UInt64) - Размер файла с засечками.
- rows (UInt64) - Количество строк.
- bytes (UInt64) - Количество байт в сжатом виде.
- modification_time (DateTime) - Время модификации директории с куском. Обычно соответствует времени создания куска.
- remove_time (DateTime) - Время, когда кусок стал неактивным.
- refcount (UInt32) - Количество мест, в котором кусок используется. Значение больше 2 говорит о том, что кусок участвует в запросах или в слияниях.
- min_date (Date) - Минимальное значение ключа даты в куске.
- max_date (Date) - Максимальное значение ключа даты в куске.
- min_block_number (UInt64) - Минимальный номер куска из которых состоит текущий после слияния.
- max_block_number (UInt64) - Максимальный номер куска из которых состоит текущий после слияния.
- level (UInt32) - Глубина дерева слияний. Если слияний не было, то ``level=0``.
- primary_key_bytes_in_memory (UInt64) - Объем памяти (в байтах), занимаемой значениями первичных ключей.
- primary_key_bytes_in_memory_allocated (UInt64) - Выделенный с резервом объем памяти (в байтах) для размещения первичных ключей.
- database (String) - Имя базы данных.
- table (String) - Имя таблицы.
- engine (String) - Имя движка таблицы, без параметров.
## system.processes

Эта системная таблица используется для реализации запроса `SHOW PROCESSLIST`.
Столбцы:

```
user String              - имя пользователя, который задал запрос. При распределённой обработке запроса, относится к пользователю, с помощью которого сервер-инициатор запроса отправил запрос на данный сервер, а не к имени пользователя, который задал распределённый запрос на сервер-инициатор запроса.

address String           - IP-адрес, с которого задан запрос. При распределённой обработке запроса, аналогично.

elapsed Float64          - время в секундах, прошедшее от начала выполнения запроса.

rows_read UInt64         - количество прочитанных из таблиц строк. При распределённой обработке запроса, на сервере-инициаторе запроса, представляет собой сумму по всем удалённым серверам.

bytes_read UInt64        - количество прочитанных из таблиц байт, в несжатом виде. При распределённой обработке запроса, на сервере-инициаторе запроса, представляет собой сумму по всем удалённым серверам.

total_rows_approx UInt64 - приблизительная оценка общего количества строк, которые должны быть прочитаны. При распределённой обработке запроса, на сервере-инициаторе запроса, представляет собой сумму по всем удалённым серверам. Может обновляться в процессе выполнения запроса, когда становятся известны новые источники для обработки.

memory_usage UInt64      - потребление памяти запросом. Может не учитывать некоторые виды выделенной памяти.

query String             - текст запроса. В случае INSERT - без данных для INSERT-а.

query_id String          - идентификатор запроса, если был задан.
```
## system.replicas

Содержит информацию и статус для реплицируемых таблиц, расположенных на локальном сервере.
Эту таблицу можно использовать для мониторинга. Таблица содержит по строчке для каждой Replicated\*-таблицы.

Пример:

``` sql
SELECT *
FROM system.replicas
WHERE table = 'visits'
FORMAT Vertical
```

```
Row 1:
──────
database:           merge
table:              visits
engine:             ReplicatedCollapsingMergeTree
is_leader:          1
is_readonly:        0
is_session_expired: 0
future_parts:       1
parts_to_check:     0
zookeeper_path:     /clickhouse/tables/01-06/visits
replica_name:       example01-06-1.yandex.ru
replica_path:       /clickhouse/tables/01-06/visits/replicas/example01-06-1.yandex.ru
columns_version:    9
queue_size:         1
inserts_in_queue:   0
merges_in_queue:    1
log_max_index:      596273
log_pointer:        596274
total_replicas:     2
active_replicas:    2
```

Столбцы:

```
database:           имя БД
table:              имя таблицы
engine:             имя движка таблицы

is_leader:          является ли реплика лидером

В один момент времени, не более одной из реплик является лидером. Лидер отвечает за выбор фоновых слияний, которые следует произвести.
Замечу, что запись можно осуществлять на любую реплику (доступную и имеющую сессию в ZK), независимо от лидерства.

is_readonly:        находится ли реплика в режиме "только для чтения"
Этот режим включается, если в конфиге нет секции с ZK; если при переинициализации сессии в ZK произошла неизвестная ошибка; во время переинициализации сессии с ZK.

is_session_expired: истекла ли сессия с ZK.
В основном, то же самое, что и is_readonly.

future_parts:       количество кусков с данными, которые появятся в результате INSERT-ов или слияний, которых ещё предстоит сделать

parts_to_check:     количество кусков с данными в очереди на проверку
Кусок помещается в очередь на проверку, если есть подозрение, что он может быть битым.

zookeeper_path:     путь к данным таблицы в ZK
replica_name:       имя реплики в ZK; разные реплики одной таблицы имеют разное имя
replica_path:       путь к данным реплики в ZK. То же самое, что конкатенация zookeeper_path/replicas/replica_path.

columns_version:    номер версии структуры таблицы
Обозначает, сколько раз был сделан ALTER. Если на репликах разные версии, значит некоторые реплики сделали ещё не все ALTER-ы.

queue_size:         размер очереди действий, которых предстоит сделать
К действиям относятся вставки блоков данных, слияния, и некоторые другие действия.
Как правило, совпадает с future_parts.

inserts_in_queue:   количество вставок блоков данных, которых предстоит сделать
Обычно вставки должны быстро реплицироваться. Если величина большая - значит что-то не так.

merges_in_queue:    количество слияний, которых предстоит сделать
Бывают длинные слияния - то есть, это значение может быть больше нуля продолжительное время.

Следующие 4 столбца имеют ненулевое значение только если активна сессия с ZK.

log_max_index:      максимальный номер записи в общем логе действий
log_pointer:        максимальный номер записи из общего лога действий, которую реплика скопировала в свою очередь для выполнения, плюс единица
Если log_pointer сильно меньше log_max_index, значит что-то не так.

total_replicas:     общее число известных реплик этой таблицы
active_replicas:    число реплик этой таблицы, имеющих сессию в ZK; то есть, число работающих реплик
```

Если запрашивать все столбцы, то таблица может работать слегка медленно, так как на каждую строчку делается несколько чтений из ZK.
Если не запрашивать последние 4 столбца (log_max_index, log_pointer, total_replicas, active_replicas), то таблица работает быстро.

Например, так можно проверить, что всё хорошо:

``` sql
SELECT
    database,
    table,
    is_leader,
    is_readonly,
    is_session_expired,
    future_parts,
    parts_to_check,
    columns_version,
    queue_size,
    inserts_in_queue,
    merges_in_queue,
    log_max_index,
    log_pointer,
    total_replicas,
    active_replicas
FROM system.replicas
WHERE
       is_readonly
    OR is_session_expired
    OR future_parts > 20
    OR parts_to_check > 10
    OR queue_size > 20
    OR inserts_in_queue > 10
    OR log_max_index - log_pointer > 10
    OR total_replicas < 2
    OR active_replicas < total_replicas
```

Если этот запрос ничего не возвращает - значит всё хорошо.
## system.settings

Содержит информацию о настройках, используемых в данный момент.
То есть, используемых для выполнения запроса, с помощью которого вы читаете из таблицы system.settings.

Столбцы:

```
name String   - имя настройки
value String  - значение настройки
changed UInt8 - была ли настройка явно задана в конфиге или изменена явным образом
```

Пример:

``` sql
SELECT *
FROM system.settings
WHERE changed
```

```
┌─name───────────────────┬─value───────┬─changed─┐
│ max_threads            │ 8           │       1 │
│ use_uncompressed_cache │ 0           │       1 │
│ load_balancing         │ random      │       1 │
│ max_memory_usage       │ 10000000000 │       1 │
└────────────────────────┴─────────────┴─────────┘
```
## system.tables

Таблица содержит столбцы database, name, engine типа String.
Также таблица содержит три виртуальных столбца: metadata_modification_time типа DateTime, create_table_query и engine_full типа String.
Для каждой таблицы, о которой знает сервер, будет присутствовать соответствующая запись в таблице system.tables.
Эта системная таблица используется для реализации запросов SHOW TABLES.


## system.zookeeper

Таблицы не существует, если ZooKeeper не сконфигурирован. Позволяет читать данные из ZooKeeper кластера, описанного в конфигурации.
В запросе обязательно в секции WHERE должно присутствовать условие на равенство path - путь в ZooKeeper, для детей которого вы хотите получить данные.

Запрос `SELECT * FROM system.zookeeper WHERE path = '/clickhouse'` выведет данные по всем детям узла `/clickhouse`.
Чтобы вывести данные по всем узлам в корне, напишите path = '/'.
Если узла, указанного в path не существует, то будет брошено исключение.

Столбцы:

- `name String` — Имя узла.
- `path String` — Путь к узлу.
- `value String` — Значение узла.
- `dataLength Int32` — Размер значения.
- `numChildren Int32` — Количество детей.
- `czxid Int64` — Идентификатор транзакции, в которой узел был создан.
- `mzxid Int64` — Идентификатор транзакции, в которой узел был последний раз изменён.
- `pzxid Int64` — Идентификатор транзакции, последний раз удаливший или добавивший детей.
- `ctime DateTime` — Время создания узла.
- `mtime DateTime` — Время последней модификации узла.
- `version Int32` — Версия узла - количество раз, когда узел был изменён.
- `cversion Int32` — Количество добавлений или удалений детей.
- `aversion Int32` — Количество изменений ACL.
- `ephemeralOwner Int64` — Для эфемерных узлов - идентификатор сессии, которая владеет этим узлом.


Пример:

``` sql
SELECT *
FROM system.zookeeper
WHERE path = '/clickhouse/tables/01-08/visits/replicas'
FORMAT Vertical
```

```
Row 1:
──────
name:           example01-08-1.yandex.ru
value:
czxid:          932998691229
mzxid:          932998691229
ctime:          2015-03-27 16:49:51
mtime:          2015-03-27 16:49:51
version:        0
cversion:       47
aversion:       0
ephemeralOwner: 0
dataLength:     0
numChildren:    7
pzxid:          987021031383
path:           /clickhouse/tables/01-08/visits/replicas

Row 2:
──────
name:           example01-08-2.yandex.ru
value:
czxid:          933002738135
mzxid:          933002738135
ctime:          2015-03-27 16:57:01
mtime:          2015-03-27 16:57:01
version:        0
cversion:       37
aversion:       0
ephemeralOwner: 0
dataLength:     0
numChildren:    7
pzxid:          987021252247
path:           /clickhouse/tables/01-08/visits/replicas
```

[Оригинальная статья](https://clickhouse.yandex/docs/ru/operations/system_tables/) <!--hide-->
