/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2021 Univ. Grenoble Alpes, CNRS, Grenoble INP, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#ifndef RESAMPLEEXTENSION_H
#define RESAMPLEEXTENSION_H

#include <ActionExtension.h>

class ResampleExtension : public camitk::ActionExtension {
    Q_OBJECT
    Q_INTERFACES(camitk::ActionExtension)
    Q_PLUGIN_METADATA(IID "fr.imag.camitk.sdk.action.imageresampling")

public:
    /// Constructor
    ResampleExtension() : ActionExtension() {}

    /// Destructor
    virtual ~ResampleExtension() {}

    /// Method returning the action extension name
    virtual QString getName() override {
        return "ResampleExtension";
    };

    /// Method returning the action extension description
    virtual QString getDescription() override {
        return "Resamples the input image.";
    };

    /// Initialize all the actions
    virtual void init() override;

};

#endif // RESAMPLEEXTENSION_H
