# --------------------------
# Include all CamiTK macros
# --------------------------

# -- generic useful macros
include(GetSubdirectories)
include(GatherHeadersAndSources)
include(ParseArguments)
include(GetDirectoryName)
include(GetSubdirectoryFiles)
include(ExportHeaders)

# -- CamiTK specific macros
include(camitk/CamiTKAddSubDirectory)
include(camitk/CamiTKInstallAllHeaders)

# -- CamiTK extensions and library macro
include(camitk/CamiTKExtensionProject)
include(camitk/CamiTKExtension)
include(camitk/CamiTKLibrary)
include(camitk/CamiTKApplication)

# -- CamiTK subproject gathering
include(camitk/cdash/projects/CamiTKSubProjectInit)
include(camitk/cdash/projects/CamiTKSubProjectAdd)
include(camitk/cdash/projects/CamiTKSubProjectValidate)

# -- CamiTK test macros (see also http://www.org/cmake/help/v2.8.8/cmake.html#section_PropertiesonTests)
include(camitk/test/CamiTKInitTest)
include(camitk/test/CamiTKAddTest)

# -- packaging macros
include(camitk/packaging/CamiTKOpenSourcePackaging)
include(camitk/packaging/CamiTKCEPPackaging)

# -- CamiTK actions / components parsing test macros
include(camitk/test/level/CamiTKParseTestInit)
include(camitk/test/level/CamiTKParseTestAdd)
include(camitk/test/level/CamiTKParseTestAddSeparator)
include(camitk/test/level/CamiTKParseTestValidate)

# -- Translations
include(camitk/CamiTKTranslate)
