// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __error_severity_h__
#define __error_severity_h__

// Severity of errors: represented by a short integer and a text

namespace Puma {


class ErrorSeverity {
  unsigned short _severity;
  const char *_text;

public:
  ErrorSeverity (unsigned short s = 0, const char* t = (const char*)0) :
    _severity (s), _text (t) {}
  ErrorSeverity (const ErrorSeverity &s) :
    _severity (s._severity), _text (s._text) {}
  ErrorSeverity &operator =(const ErrorSeverity &s) 
    { _severity = s._severity; _text = s._text; return *this; }

  int operator < (const ErrorSeverity &s) const
   { return _severity < s._severity; }
  int operator > (const ErrorSeverity &s) const
   { return _severity > s._severity; }
  int operator <= (const ErrorSeverity &s) const
   { return _severity < s._severity || _severity == s._severity; }
  int operator >= (const ErrorSeverity &s) const
   { return _severity > s._severity || _severity == s._severity; }
  int operator == (const ErrorSeverity &s) const
   { return _severity == s._severity; }
  int operator != (const ErrorSeverity &s) const
   { return _severity != s._severity; }
  const char *text () const
   { return _text; }
};

extern const ErrorSeverity sev_none;
extern const ErrorSeverity sev_message;
extern const ErrorSeverity sev_warning;
extern const ErrorSeverity sev_error;
extern const ErrorSeverity sev_fatal;
      

} // namespace Puma

#endif /* __error_severity_h__ */
