/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.reflect;

import net.sf.jiapi.reflect.TypeHelper;

public class Signature {
    private String descriptor;
    private String returnType;
    private String[] params;

    public Signature(String returnType, String[] params) {
        if (params == null) {
            throw new IllegalArgumentException("params may not be null");
        }
        for (int i = 0; i < params.length; ++i) {
            String s = params[i].trim();
            int idx = s.indexOf(32);
            if (idx == -1) continue;
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < s.length(); ++j) {
                if (s.charAt(j) == ' ') continue;
                sb.append(s.charAt(j));
            }
            params[i] = sb.toString();
        }
        this.returnType = returnType;
        this.params = params;
        this.descriptor = TypeHelper.signatureToDescriptor(this);
    }

    public Signature(String descriptor) {
        try {
            this.descriptor = descriptor;
            int idx = descriptor.lastIndexOf(41);
            this.returnType = TypeHelper.descriptorToType(descriptor.substring(idx + 1));
            this.params = TypeHelper.descriptorsToTypes(descriptor.substring(1, idx));
        }
        catch (RuntimeException e) {
            System.err.println("Failed to create Signature from " + descriptor);
            throw e;
        }
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String[] getParameters() {
        return this.params;
    }

    public String[] getParameterDescriptors() {
        String d = this.descriptor.substring(1, this.descriptor.length() - 2);
        return TypeHelper.splitDescriptors(d);
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return this.descriptor;
    }

    public boolean equals(Signature s) {
        String[] otherParams = s.getParameters();
        if (this.params.length != otherParams.length) {
            return false;
        }
        for (int i = 0; i < this.params.length; ++i) {
            if (this.params[i].equals(otherParams[i])) continue;
            return false;
        }
        return true;
    }
}

