/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 12:38:30 GMT 2018
 */

package uk.ac.sanger.artemis.components.genebuilder.ortholog;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import javax.swing.JButton;
import javax.swing.JPasswordField;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.genebuilder.ortholog.SimilarityTable;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.util.DatabaseDocument;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class SimilarityTable_ESTest extends SimilarityTable_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("!VB[d^Y#og v,n/6S", "ySlPyw_(o/uU");
      JPasswordField jPasswordField0 = new JPasswordField("ySlPyw_(o/uU");
      DatabaseDocument databaseDocument0 = new DatabaseDocument("!VB[d^Y#og v,n/6S", jPasswordField0);
      SimilarityTable similarityTable0 = new SimilarityTable(qualifier0, databaseDocument0);
      // Undeclared exception!
      try { 
        similarityTable0.updateQualifierString(177);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 177 >= 1
         //
         verifyException("java.util.Vector", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("", "");
      JPasswordField jPasswordField0 = new JPasswordField("");
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0);
      SimilarityTable similarityTable0 = null;
      try {
        similarityTable0 = new SimilarityTable(qualifier0, databaseDocument0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // Array index out of range: 0
         //
         verifyException("java.util.Vector", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      String[] stringArray0 = new String[3];
      stringArray0[0] = "0;=rQ&;iZ";
      StringVector stringVector0 = new StringVector(stringArray0);
      // Undeclared exception!
      try { 
        SimilarityTable.containsStringInStringVector("0;=rQ&;iZ", stringVector0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // Array index out of range: 3
         //
         verifyException("java.util.Vector", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      String[] stringArray0 = new String[3];
      StringVector stringVector0 = new StringVector(stringArray0);
      // Undeclared exception!
      try { 
        SimilarityTable.containsStringInStringVector("0;=rQ&;iZ", stringVector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.StringVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      StringVector stringVector0 = new StringVector();
      boolean boolean0 = SimilarityTable.containsStringInStringVector("subject ", stringVector0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("'az@cZ;q0nU%W^", "'az@cZ;q0nU%W^");
      JPasswordField jPasswordField0 = new JPasswordField("", 0);
      DatabaseDocument databaseDocument0 = new DatabaseDocument("'az@cZ;q0nU%W^", jPasswordField0, "'az@cZ;q0nU%W^", "", true);
      SimilarityTable similarityTable0 = new SimilarityTable(qualifier0, databaseDocument0);
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("!VB[d^Y#og v,n/6S", "ySlPyw_(o/uU");
      String[] stringArray0 = new String[8];
      stringArray0[0] = "!VB[d^Y#og v,n/6S";
      stringArray0[1] = "!VB[d^Y#og v,n/6S";
      stringArray0[2] = "\"sYFSb!V#Z]hn";
      stringArray0[3] = "sYFSby!V#Z]hn\"";
      StringVector stringVector0 = new StringVector(stringArray0);
      qualifier0.addValues(stringVector0);
      JPasswordField jPasswordField0 = new JPasswordField("ySlPyw_(o/uU");
      DatabaseDocument databaseDocument0 = new DatabaseDocument("!VB[d^Y#og v,n/6S", jPasswordField0);
      SimilarityTable similarityTable0 = null;
      try {
        similarityTable0 = new SimilarityTable(qualifier0, databaseDocument0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      StringVector stringVector0 = new StringVector("sYFSby!V#Z]hn");
      Qualifier qualifier0 = new Qualifier("", stringVector0);
      SimilarityTable similarityTable0 = new SimilarityTable(qualifier0, (DatabaseDocument) null);
      JButton jButton0 = similarityTable0.getInfoLevelButton();
      assertFalse(jButton0.getIgnoreRepaint());
  }

  @Test(timeout = 4000)
  public void test8()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("Overlapping Features (to be fixed before reordering)", "Overlapping Features (to be fixed before reordering)");
      JPasswordField jPasswordField0 = new JPasswordField(0);
      DatabaseDocument databaseDocument0 = new DatabaseDocument("Overlapping Features (to be fixed before reordering)", jPasswordField0, "jBEY#EK", "South", true);
      SimilarityTable similarityTable0 = new SimilarityTable(qualifier0, databaseDocument0);
      // Undeclared exception!
      try { 
        similarityTable0.updateQualifierString(0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }
}
