/* TurtleJavacc.java */
/* Generated By:JavaCC: Do not edit this line. TurtleJavacc.java */
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.riot.lang.extra.javacc;

import org.apache.jena.graph.*;
import org.apache.jena.riot.lang.extra.* ;

public class TurtleJavacc extends TurtleParserBase implements TurtleJavaccConstants {

// Entry point
  final public void parse() throws ParseException {
    ByteOrderMark();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PREFIX_OLD:
      case BASE_OLD:
      case BASE:
      case PREFIX:
      case IRIref:
      case LPAREN:
      case LBRACKET:
      case ANON:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:{

        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      Statement();
    }
    jj_consume_token(0);
  }

  final public void ByteOrderMark() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOM:{
      jj_consume_token(BOM);
      break;
      }
    default:
      jj_la1[1] = jj_gen;

    }
  }

  final public void Statement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BASE:
    case PREFIX:{
      Directive();
      break;
      }
    case PREFIX_OLD:
    case BASE_OLD:{
      DirectiveOld();
      break;
      }
    case IRIref:
    case LPAREN:
    case LBRACKET:
    case ANON:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:{
      TriplesSameSubject();
      jj_consume_token(DOT);
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void Directive() throws ParseException {Token t ; String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PREFIX:{
      jj_consume_token(PREFIX);
      t = jj_consume_token(PNAME_NS);
      iri = IRIREF();
String s = fixupPrefix(t.image, t.beginLine, t.beginColumn) ;
      setPrefix(s, iri, t.beginLine, t.beginColumn) ;
      break;
      }
    case BASE:{
      t = jj_consume_token(BASE);
      iri = IRIREF();
setBase(iri, t.beginLine, t.beginColumn) ;
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void DirectiveOld() throws ParseException {Token t ; String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PREFIX_OLD:{
      jj_consume_token(PREFIX_OLD);
      t = jj_consume_token(PNAME_NS);
      iri = IRIREF();
      jj_consume_token(DOT);
String s = fixupPrefix(t.image, t.beginLine, t.beginColumn) ;
      setPrefix(s, iri, t.beginLine, t.beginColumn) ;
      break;
      }
    case BASE_OLD:{
      t = jj_consume_token(BASE_OLD);
      iri = IRIREF();
      jj_consume_token(DOT);
setBase(iri, t.beginLine, t.beginColumn) ;
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Token AnyDirective() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PREFIX:{
      t = jj_consume_token(PREFIX);
      break;
      }
    case BASE:{
      t = jj_consume_token(BASE);
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t ;}
    throw new Error("Missing return statement in function");
  }

  final public void TriplesSameSubject() throws ParseException {Node s ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case ANON:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:{
      s = SubjectNode();
      PropertyListNotEmpty(s);
      break;
      }
    case LPAREN:
    case LBRACKET:{
      s = TriplesNode();
      PropertyList(s);
      break;
      }
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void PropertyList(Node s) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case KW_A:
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      PropertyListNotEmpty(s);
      break;
      }
    default:
      jj_la1[7] = jj_gen;

    }
  }

  final public void PropertyListNotEmpty(Node s) throws ParseException {Node p = null ;
    p = Verb();
    ObjectList(s, p);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{

        break;
        }
      default:
        jj_la1[8] = jj_gen;
        break label_2;
      }
      jj_consume_token(SEMICOLON);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case KW_A:
      case IRIref:
      case PNAME_NS:
      case PNAME_LN:{
        p = Verb();
        ObjectList(s, p);
        break;
        }
      default:
        jj_la1[9] = jj_gen;

      }
    }
  }

  final public void ObjectList(Node s, Node p) throws ParseException {Node o ;
    Object(s, p);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{

        break;
        }
      default:
        jj_la1[10] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
      Object(s, p);
    }
  }

  final public void Object(Node s, Node p) throws ParseException {Node o ;
    o = GraphNode();
emitTriple(token.beginLine, token.beginColumn, s, p, o) ;
  }

  final public Node Verb() throws ParseException {Node p ; String iri;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      iri = iri();
p = createNode(iri);
      break;
      }
    case KW_A:{
      jj_consume_token(KW_A);
p = nRDFtype ;
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return p ;}
    throw new Error("Missing return statement in function");
  }

// -------- Triple expansions

// Anything that can stand in a node slot and which is
// a number of triples
  final public 
Node TriplesNode() throws ParseException {Node n ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:{
      n = Collection();
{if ("" != null) return n ;}
      break;
      }
    case LBRACKET:{
      n = BlankNodePropertyList();
{if ("" != null) return n ;}
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node BlankNodePropertyList() throws ParseException {Token t ;
    t = jj_consume_token(LBRACKET);
Node n = createBNode( t.beginLine, t.beginColumn) ;
    PropertyListNotEmpty(n);
    jj_consume_token(RBRACKET);
{if ("" != null) return n ;}
    throw new Error("Missing return statement in function");
  }

// The syntax for RDF* 
//Node TripleStar() : 
//     { Node s , p , o ; Token t ; }
// {
//   t = "<<"
//     { int beginLine = t.beginLine; int beginColumn = t.beginColumn; t = null; }
//         id = createTripleId(beginLine, beginColumn() ;
//     }
//   s = GraphNode()
//   p = GraphNode()
//   o = GraphNode()
//   ">>"
//   { Node n = tripleStar(s, p, o);
//     return n;
//   }
// }
// 

// ------- RDF collections
// Ordering?
  final public 
Node Collection() throws ParseException {Node listHead = nRDFnil ; Node lastCell = null ; int mark ; Node n ; Token t ;
    t = jj_consume_token(LPAREN);
int line = t.beginLine; int column = t.beginColumn;
    listStart(line, column);
    label_4:
    while (true) {
Node cell = createListNode(line, column) ;
      if ( listHead == nRDFnil )
         listHead = cell ;
      if ( lastCell != null )
        listTriple(line, column, lastCell, nRDFrest,  cell) ;
      n = GraphNode();
listTriple(line, column, cell, nRDFfirst, n) ;
      lastCell = cell ;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TRUE:
      case FALSE:
      case IRIref:
      case INTEGER:
      case DECIMAL:
      case DOUBLE:
      case STRING_LITERAL1:
      case STRING_LITERAL2:
      case STRING_LITERAL_LONG1:
      case STRING_LITERAL_LONG2:
      case LPAREN:
      case NIL:
      case LBRACKET:
      case ANON:
      case PNAME_NS:
      case PNAME_LN:
      case BLANK_NODE_LABEL:{

        break;
        }
      default:
        jj_la1[13] = jj_gen;
        break label_4;
      }
    }
    jj_consume_token(RPAREN);
if ( lastCell != null )
       listTriple(line, column, lastCell, nRDFrest,  nRDFnil) ;
     listFinish(line, column);
     {if ("" != null) return listHead ;}
    throw new Error("Missing return statement in function");
  }

  final public Node SubjectNode() throws ParseException {Node s; String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ANON:
    case BLANK_NODE_LABEL:{
      s = BlankNode();
{if ("" != null) return s ;}
      break;
      }
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      iri = iri();
{if ("" != null) return createNode(iri) ;}
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node GraphNode() throws ParseException {Node n ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TRUE:
    case FALSE:
    case IRIref:
    case INTEGER:
    case DECIMAL:
    case DOUBLE:
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:
    case NIL:
    case ANON:
    case PNAME_NS:
    case PNAME_LN:
    case BLANK_NODE_LABEL:{
      n = GraphTerm();
{if ("" != null) return n ;}
      break;
      }
    case LPAREN:
    case LBRACKET:{
      n = TriplesNode();
{if ("" != null) return n ;}
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node GraphTerm() throws ParseException {Node n ; String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:
    case PNAME_NS:
    case PNAME_LN:{
      iri = iri();
{if ("" != null) return createNode(iri) ;}
      break;
      }
    case STRING_LITERAL1:
    case STRING_LITERAL2:
    case STRING_LITERAL_LONG1:
    case STRING_LITERAL_LONG2:{
      n = RDFLiteral();
{if ("" != null) return n ;}
      break;
      }
    case INTEGER:
    case DECIMAL:
    case DOUBLE:{
      n = NumericLiteral();
{if ("" != null) return n ;}
      break;
      }
    case TRUE:
    case FALSE:{
      n = BooleanLiteral();
{if ("" != null) return n ;}
      break;
      }
    case ANON:
    case BLANK_NODE_LABEL:{
      n = BlankNode();
{if ("" != null) return n ;}
      break;
      }
    case NIL:{
      jj_consume_token(NIL);
{if ("" != null) return nRDFnil ;}
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node RDFLiteral() throws ParseException {Token t ; String lex = null ;
    lex = String();
String lang = null ; String uri = null ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BASE:
    case PREFIX:
    case DATATYPE:
    case LANGTAG:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BASE:
      case PREFIX:
      case LANGTAG:{
        lang = LangTag();
        break;
        }
      case DATATYPE:{
        jj_consume_token(DATATYPE);
        uri = iri();
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[18] = jj_gen;

    }
{if ("" != null) return createLiteral(lex, lang, uri) ;}
    throw new Error("Missing return statement in function");
  }

  final public String LangTag() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LANGTAG:{
      t = jj_consume_token(LANGTAG);
      break;
      }
    case BASE:
    case PREFIX:{
      t = AnyDirective();
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
String lang = stripChars(t.image, 1) ; {if ("" != null) return lang ;}
    throw new Error("Missing return statement in function");
  }

  final public Node NumericLiteral() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INTEGER:{
      t = jj_consume_token(INTEGER);
{if ("" != null) return createLiteralInteger(t.image) ;}
      break;
      }
    case DECIMAL:{
      t = jj_consume_token(DECIMAL);
{if ("" != null) return createLiteralDecimal(t.image) ;}
      break;
      }
    case DOUBLE:{
      t = jj_consume_token(DOUBLE);
{if ("" != null) return createLiteralDouble(t.image) ;}
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node BooleanLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TRUE:{
      jj_consume_token(TRUE);
{if ("" != null) return XSD_TRUE ;}
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
{if ("" != null) return XSD_FALSE ;}
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String String() throws ParseException {Token t ; String lex ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING_LITERAL1:{
      t = jj_consume_token(STRING_LITERAL1);
lex = stripQuotes(t.image) ;
      break;
      }
    case STRING_LITERAL2:{
      t = jj_consume_token(STRING_LITERAL2);
lex = stripQuotes(t.image) ;
      break;
      }
    case STRING_LITERAL_LONG1:{
      t = jj_consume_token(STRING_LITERAL_LONG1);
lex = stripQuotes3(t.image) ;
      break;
      }
    case STRING_LITERAL_LONG2:{
      t = jj_consume_token(STRING_LITERAL_LONG2);
lex = stripQuotes3(t.image) ;
      break;
      }
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
lex = unescapeStr(lex,  t.beginLine, t.beginColumn) ;
      {if ("" != null) return lex ;}
    throw new Error("Missing return statement in function");
  }

  final public String iri() throws ParseException {String iri ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IRIref:{
      iri = IRIREF();
{if ("" != null) return iri ;}
      break;
      }
    case PNAME_NS:
    case PNAME_LN:{
      iri = PrefixedName();
{if ("" != null) return iri ;}
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String PrefixedName() throws ParseException {Token t ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PNAME_LN:{
      t = jj_consume_token(PNAME_LN);
{if ("" != null) return resolvePName(t.image, t.beginLine, t.beginColumn) ;}
      break;
      }
    case PNAME_NS:{
      t = jj_consume_token(PNAME_NS);
{if ("" != null) return resolvePName(t.image, t.beginLine, t.beginColumn) ;}
      break;
      }
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Node BlankNode() throws ParseException {Token t = null ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BLANK_NODE_LABEL:{
      t = jj_consume_token(BLANK_NODE_LABEL);
{if ("" != null) return createBNode(t.image, t.beginLine, t.beginColumn) ;}
      break;
      }
    case ANON:{
      //  <LBRACKET> <RBRACKET> { return createBNode(t.beginLine, t.beginColumn) ; }
        t = jj_consume_token(ANON);
{if ("" != null) return createBNode(t.beginLine, t.beginColumn) ;}
      break;
      }
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String IRIREF() throws ParseException {Token t ;
    t = jj_consume_token(IRIref);
{if ("" != null) return resolveQuotedIRI(t.image, t.beginLine, t.beginColumn) ;}
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public TurtleJavaccTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[26];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x21e00,0x10000,0x21e00,0x1800,0x600,0x1800,0x20000,0x20100,0x0,0x20100,0x0,0x20100,0x0,0x80e26000,0x20000,0x80e26000,0x80e26000,0x1800,0x1800,0x1800,0xe00000,0x6000,0x80000000,0x20000,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x70508,0x0,0x70508,0x0,0x0,0x0,0x70508,0x30000,0x800,0x30000,0x1000,0x30000,0x108,0x7052f,0x70400,0x7052f,0x70427,0x84000,0x84000,0x80000,0x0,0x0,0x7,0x30000,0x30000,0x40400,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }

  /** Constructor with InputStream. */
  public TurtleJavacc(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public TurtleJavacc(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new TurtleJavaccTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 26; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 26; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public TurtleJavacc(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new TurtleJavaccTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 26; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 26; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public TurtleJavacc(TurtleJavaccTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 26; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(TurtleJavaccTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 26; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[65];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 26; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 65; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

 }
