/*
 * Copyright 2011, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * THIS FILE WAS GENERATED BY A SCRIPT. DO NOT EDIT.
 */

namespace android {
namespace gltrace {

// Declarations for GL2 APIs

void GLTrace_glActiveTexture(GLenum texture);
void GLTrace_glAttachShader(GLuint program, GLuint shader);
void GLTrace_glBindAttribLocation(GLuint program, GLuint index, const GLchar * name);
void GLTrace_glBindBuffer(GLenum target, GLuint buffer);
void GLTrace_glBindFramebuffer(GLenum target, GLuint framebuffer);
void GLTrace_glBindRenderbuffer(GLenum target, GLuint renderbuffer);
void GLTrace_glBindTexture(GLenum target, GLuint texture);
void GLTrace_glBlendColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
void GLTrace_glBlendEquation(GLenum mode);
void GLTrace_glBlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha);
void GLTrace_glBlendFunc(GLenum sfactor, GLenum dfactor);
void GLTrace_glBlendFuncSeparate(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);
void GLTrace_glBufferData(GLenum target, GLsizeiptr size, const void * data, GLenum usage);
void GLTrace_glBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const void * data);
GLenum GLTrace_glCheckFramebufferStatus(GLenum target);
void GLTrace_glClear(GLbitfield mask);
void GLTrace_glClearColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
void GLTrace_glClearDepthf(GLfloat d);
void GLTrace_glClearStencil(GLint s);
void GLTrace_glColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
void GLTrace_glCompileShader(GLuint shader);
void GLTrace_glCompressedTexImage2D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void * data);
void GLTrace_glCompressedTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void * data);
void GLTrace_glCopyTexImage2D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
void GLTrace_glCopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
GLuint GLTrace_glCreateProgram(void);
GLuint GLTrace_glCreateShader(GLenum type);
void GLTrace_glCullFace(GLenum mode);
void GLTrace_glDeleteBuffers(GLsizei n, const GLuint * buffers);
void GLTrace_glDeleteFramebuffers(GLsizei n, const GLuint * framebuffers);
void GLTrace_glDeleteProgram(GLuint program);
void GLTrace_glDeleteRenderbuffers(GLsizei n, const GLuint * renderbuffers);
void GLTrace_glDeleteShader(GLuint shader);
void GLTrace_glDeleteTextures(GLsizei n, const GLuint * textures);
void GLTrace_glDepthFunc(GLenum func);
void GLTrace_glDepthMask(GLboolean flag);
void GLTrace_glDepthRangef(GLfloat n, GLfloat f);
void GLTrace_glDetachShader(GLuint program, GLuint shader);
void GLTrace_glDisable(GLenum cap);
void GLTrace_glDisableVertexAttribArray(GLuint index);
void GLTrace_glDrawArrays(GLenum mode, GLint first, GLsizei count);
void GLTrace_glDrawElements(GLenum mode, GLsizei count, GLenum type, const void * indices);
void GLTrace_glEnable(GLenum cap);
void GLTrace_glEnableVertexAttribArray(GLuint index);
void GLTrace_glFinish(void);
void GLTrace_glFlush(void);
void GLTrace_glFramebufferRenderbuffer(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
void GLTrace_glFramebufferTexture2D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
void GLTrace_glFrontFace(GLenum mode);
void GLTrace_glGenBuffers(GLsizei n, GLuint * buffers);
void GLTrace_glGenerateMipmap(GLenum target);
void GLTrace_glGenFramebuffers(GLsizei n, GLuint * framebuffers);
void GLTrace_glGenRenderbuffers(GLsizei n, GLuint * renderbuffers);
void GLTrace_glGenTextures(GLsizei n, GLuint * textures);
void GLTrace_glGetActiveAttrib(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name);
void GLTrace_glGetActiveUniform(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name);
void GLTrace_glGetAttachedShaders(GLuint program, GLsizei maxCount, GLsizei * count, GLuint * shaders);
GLint GLTrace_glGetAttribLocation(GLuint program, const GLchar * name);
void GLTrace_glGetBooleanv(GLenum pname, GLboolean * data);
void GLTrace_glGetBufferParameteriv(GLenum target, GLenum pname, GLint * params);
GLenum GLTrace_glGetError(void);
void GLTrace_glGetFloatv(GLenum pname, GLfloat * data);
void GLTrace_glGetFramebufferAttachmentParameteriv(GLenum target, GLenum attachment, GLenum pname, GLint * params);
void GLTrace_glGetIntegerv(GLenum pname, GLint * data);
void GLTrace_glGetProgramiv(GLuint program, GLenum pname, GLint * params);
void GLTrace_glGetProgramInfoLog(GLuint program, GLsizei bufSize, GLsizei * length, GLchar * infoLog);
void GLTrace_glGetRenderbufferParameteriv(GLenum target, GLenum pname, GLint * params);
void GLTrace_glGetShaderiv(GLuint shader, GLenum pname, GLint * params);
void GLTrace_glGetShaderInfoLog(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * infoLog);
void GLTrace_glGetShaderPrecisionFormat(GLenum shadertype, GLenum precisiontype, GLint * range, GLint * precision);
void GLTrace_glGetShaderSource(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * source);
const GLubyte * GLTrace_glGetString(GLenum name);
void GLTrace_glGetTexParameterfv(GLenum target, GLenum pname, GLfloat * params);
void GLTrace_glGetTexParameteriv(GLenum target, GLenum pname, GLint * params);
void GLTrace_glGetUniformfv(GLuint program, GLint location, GLfloat * params);
void GLTrace_glGetUniformiv(GLuint program, GLint location, GLint * params);
GLint GLTrace_glGetUniformLocation(GLuint program, const GLchar * name);
void GLTrace_glGetVertexAttribfv(GLuint index, GLenum pname, GLfloat * params);
void GLTrace_glGetVertexAttribiv(GLuint index, GLenum pname, GLint * params);
void GLTrace_glGetVertexAttribPointerv(GLuint index, GLenum pname, void ** pointer);
void GLTrace_glHint(GLenum target, GLenum mode);
GLboolean GLTrace_glIsBuffer(GLuint buffer);
GLboolean GLTrace_glIsEnabled(GLenum cap);
GLboolean GLTrace_glIsFramebuffer(GLuint framebuffer);
GLboolean GLTrace_glIsProgram(GLuint program);
GLboolean GLTrace_glIsRenderbuffer(GLuint renderbuffer);
GLboolean GLTrace_glIsShader(GLuint shader);
GLboolean GLTrace_glIsTexture(GLuint texture);
void GLTrace_glLineWidth(GLfloat width);
void GLTrace_glLinkProgram(GLuint program);
void GLTrace_glPixelStorei(GLenum pname, GLint param);
void GLTrace_glPolygonOffset(GLfloat factor, GLfloat units);
void GLTrace_glReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, void * pixels);
void GLTrace_glReleaseShaderCompiler(void);
void GLTrace_glRenderbufferStorage(GLenum target, GLenum internalformat, GLsizei width, GLsizei height);
void GLTrace_glSampleCoverage(GLfloat value, GLboolean invert);
void GLTrace_glScissor(GLint x, GLint y, GLsizei width, GLsizei height);
void GLTrace_glShaderBinary(GLsizei count, const GLuint * shaders, GLenum binaryformat, const void * binary, GLsizei length);
void GLTrace_glShaderSource(GLuint shader, GLsizei count, const GLchar *const* string, const GLint * length);
void GLTrace_glStencilFunc(GLenum func, GLint ref, GLuint mask);
void GLTrace_glStencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask);
void GLTrace_glStencilMask(GLuint mask);
void GLTrace_glStencilMaskSeparate(GLenum face, GLuint mask);
void GLTrace_glStencilOp(GLenum fail, GLenum zfail, GLenum zpass);
void GLTrace_glStencilOpSeparate(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass);
void GLTrace_glTexImage2D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void * pixels);
void GLTrace_glTexParameterf(GLenum target, GLenum pname, GLfloat param);
void GLTrace_glTexParameterfv(GLenum target, GLenum pname, const GLfloat * params);
void GLTrace_glTexParameteri(GLenum target, GLenum pname, GLint param);
void GLTrace_glTexParameteriv(GLenum target, GLenum pname, const GLint * params);
void GLTrace_glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void * pixels);
void GLTrace_glUniform1f(GLint location, GLfloat v0);
void GLTrace_glUniform1fv(GLint location, GLsizei count, const GLfloat * value);
void GLTrace_glUniform1i(GLint location, GLint v0);
void GLTrace_glUniform1iv(GLint location, GLsizei count, const GLint * value);
void GLTrace_glUniform2f(GLint location, GLfloat v0, GLfloat v1);
void GLTrace_glUniform2fv(GLint location, GLsizei count, const GLfloat * value);
void GLTrace_glUniform2i(GLint location, GLint v0, GLint v1);
void GLTrace_glUniform2iv(GLint location, GLsizei count, const GLint * value);
void GLTrace_glUniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
void GLTrace_glUniform3fv(GLint location, GLsizei count, const GLfloat * value);
void GLTrace_glUniform3i(GLint location, GLint v0, GLint v1, GLint v2);
void GLTrace_glUniform3iv(GLint location, GLsizei count, const GLint * value);
void GLTrace_glUniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
void GLTrace_glUniform4fv(GLint location, GLsizei count, const GLfloat * value);
void GLTrace_glUniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
void GLTrace_glUniform4iv(GLint location, GLsizei count, const GLint * value);
void GLTrace_glUniformMatrix2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glUniformMatrix3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glUniformMatrix4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glUseProgram(GLuint program);
void GLTrace_glValidateProgram(GLuint program);
void GLTrace_glVertexAttrib1f(GLuint index, GLfloat x);
void GLTrace_glVertexAttrib1fv(GLuint index, const GLfloat * v);
void GLTrace_glVertexAttrib2f(GLuint index, GLfloat x, GLfloat y);
void GLTrace_glVertexAttrib2fv(GLuint index, const GLfloat * v);
void GLTrace_glVertexAttrib3f(GLuint index, GLfloat x, GLfloat y, GLfloat z);
void GLTrace_glVertexAttrib3fv(GLuint index, const GLfloat * v);
void GLTrace_glVertexAttrib4f(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void GLTrace_glVertexAttrib4fv(GLuint index, const GLfloat * v);
void GLTrace_glVertexAttribPointer(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const void * pointer);
void GLTrace_glViewport(GLint x, GLint y, GLsizei width, GLsizei height);
void GLTrace_glReadBuffer(GLenum mode);
void GLTrace_glDrawRangeElements(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void * indices);
void GLTrace_glTexImage3D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void * pixels);
void GLTrace_glTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void * pixels);
void GLTrace_glCopyTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
void GLTrace_glCompressedTexImage3D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void * data);
void GLTrace_glCompressedTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void * data);
void GLTrace_glGenQueries(GLsizei n, GLuint * ids);
void GLTrace_glDeleteQueries(GLsizei n, const GLuint * ids);
GLboolean GLTrace_glIsQuery(GLuint id);
void GLTrace_glBeginQuery(GLenum target, GLuint id);
void GLTrace_glEndQuery(GLenum target);
void GLTrace_glGetQueryiv(GLenum target, GLenum pname, GLint * params);
void GLTrace_glGetQueryObjectuiv(GLuint id, GLenum pname, GLuint * params);
GLboolean GLTrace_glUnmapBuffer(GLenum target);
void GLTrace_glGetBufferPointerv(GLenum target, GLenum pname, void ** params);
void GLTrace_glDrawBuffers(GLsizei n, const GLenum * bufs);
void GLTrace_glUniformMatrix2x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glUniformMatrix3x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glUniformMatrix2x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glUniformMatrix4x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glUniformMatrix3x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glUniformMatrix4x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glBlitFramebuffer(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
void GLTrace_glRenderbufferStorageMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
void GLTrace_glFramebufferTextureLayer(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer);
void * GLTrace_glMapBufferRange(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access);
void GLTrace_glFlushMappedBufferRange(GLenum target, GLintptr offset, GLsizeiptr length);
void GLTrace_glBindVertexArray(GLuint array);
void GLTrace_glDeleteVertexArrays(GLsizei n, const GLuint * arrays);
void GLTrace_glGenVertexArrays(GLsizei n, GLuint * arrays);
GLboolean GLTrace_glIsVertexArray(GLuint array);
void GLTrace_glGetIntegeri_v(GLenum target, GLuint index, GLint * data);
void GLTrace_glBeginTransformFeedback(GLenum primitiveMode);
void GLTrace_glEndTransformFeedback(void);
void GLTrace_glBindBufferRange(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size);
void GLTrace_glBindBufferBase(GLenum target, GLuint index, GLuint buffer);
void GLTrace_glTransformFeedbackVaryings(GLuint program, GLsizei count, const GLchar *const* varyings, GLenum bufferMode);
void GLTrace_glGetTransformFeedbackVarying(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLsizei * size, GLenum * type, GLchar * name);
void GLTrace_glVertexAttribIPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const void * pointer);
void GLTrace_glGetVertexAttribIiv(GLuint index, GLenum pname, GLint * params);
void GLTrace_glGetVertexAttribIuiv(GLuint index, GLenum pname, GLuint * params);
void GLTrace_glVertexAttribI4i(GLuint index, GLint x, GLint y, GLint z, GLint w);
void GLTrace_glVertexAttribI4ui(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w);
void GLTrace_glVertexAttribI4iv(GLuint index, const GLint * v);
void GLTrace_glVertexAttribI4uiv(GLuint index, const GLuint * v);
void GLTrace_glGetUniformuiv(GLuint program, GLint location, GLuint * params);
GLint GLTrace_glGetFragDataLocation(GLuint program, const GLchar * name);
void GLTrace_glUniform1ui(GLint location, GLuint v0);
void GLTrace_glUniform2ui(GLint location, GLuint v0, GLuint v1);
void GLTrace_glUniform3ui(GLint location, GLuint v0, GLuint v1, GLuint v2);
void GLTrace_glUniform4ui(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);
void GLTrace_glUniform1uiv(GLint location, GLsizei count, const GLuint * value);
void GLTrace_glUniform2uiv(GLint location, GLsizei count, const GLuint * value);
void GLTrace_glUniform3uiv(GLint location, GLsizei count, const GLuint * value);
void GLTrace_glUniform4uiv(GLint location, GLsizei count, const GLuint * value);
void GLTrace_glClearBufferiv(GLenum buffer, GLint drawbuffer, const GLint * value);
void GLTrace_glClearBufferuiv(GLenum buffer, GLint drawbuffer, const GLuint * value);
void GLTrace_glClearBufferfv(GLenum buffer, GLint drawbuffer, const GLfloat * value);
void GLTrace_glClearBufferfi(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil);
const GLubyte * GLTrace_glGetStringi(GLenum name, GLuint index);
void GLTrace_glCopyBufferSubData(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size);
void GLTrace_glGetUniformIndices(GLuint program, GLsizei uniformCount, const GLchar *const* uniformNames, GLuint * uniformIndices);
void GLTrace_glGetActiveUniformsiv(GLuint program, GLsizei uniformCount, const GLuint * uniformIndices, GLenum pname, GLint * params);
GLuint GLTrace_glGetUniformBlockIndex(GLuint program, const GLchar * uniformBlockName);
void GLTrace_glGetActiveUniformBlockiv(GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint * params);
void GLTrace_glGetActiveUniformBlockName(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei * length, GLchar * uniformBlockName);
void GLTrace_glUniformBlockBinding(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding);
void GLTrace_glDrawArraysInstanced(GLenum mode, GLint first, GLsizei count, GLsizei instancecount);
void GLTrace_glDrawElementsInstanced(GLenum mode, GLsizei count, GLenum type, const void * indices, GLsizei instancecount);
GLsync GLTrace_glFenceSync(GLenum condition, GLbitfield flags);
GLboolean GLTrace_glIsSync(GLsync sync);
void GLTrace_glDeleteSync(GLsync sync);
GLenum GLTrace_glClientWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout);
void GLTrace_glWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout);
void GLTrace_glGetInteger64v(GLenum pname, GLint64 * data);
void GLTrace_glGetSynciv(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei * length, GLint * values);
void GLTrace_glGetInteger64i_v(GLenum target, GLuint index, GLint64 * data);
void GLTrace_glGetBufferParameteri64v(GLenum target, GLenum pname, GLint64 * params);
void GLTrace_glGenSamplers(GLsizei count, GLuint * samplers);
void GLTrace_glDeleteSamplers(GLsizei count, const GLuint * samplers);
GLboolean GLTrace_glIsSampler(GLuint sampler);
void GLTrace_glBindSampler(GLuint unit, GLuint sampler);
void GLTrace_glSamplerParameteri(GLuint sampler, GLenum pname, GLint param);
void GLTrace_glSamplerParameteriv(GLuint sampler, GLenum pname, const GLint * param);
void GLTrace_glSamplerParameterf(GLuint sampler, GLenum pname, GLfloat param);
void GLTrace_glSamplerParameterfv(GLuint sampler, GLenum pname, const GLfloat * param);
void GLTrace_glGetSamplerParameteriv(GLuint sampler, GLenum pname, GLint * params);
void GLTrace_glGetSamplerParameterfv(GLuint sampler, GLenum pname, GLfloat * params);
void GLTrace_glVertexAttribDivisor(GLuint index, GLuint divisor);
void GLTrace_glBindTransformFeedback(GLenum target, GLuint id);
void GLTrace_glDeleteTransformFeedbacks(GLsizei n, const GLuint * ids);
void GLTrace_glGenTransformFeedbacks(GLsizei n, GLuint * ids);
GLboolean GLTrace_glIsTransformFeedback(GLuint id);
void GLTrace_glPauseTransformFeedback(void);
void GLTrace_glResumeTransformFeedback(void);
void GLTrace_glGetProgramBinary(GLuint program, GLsizei bufSize, GLsizei * length, GLenum * binaryFormat, void * binary);
void GLTrace_glProgramBinary(GLuint program, GLenum binaryFormat, const void * binary, GLsizei length);
void GLTrace_glProgramParameteri(GLuint program, GLenum pname, GLint value);
void GLTrace_glInvalidateFramebuffer(GLenum target, GLsizei numAttachments, const GLenum * attachments);
void GLTrace_glInvalidateSubFramebuffer(GLenum target, GLsizei numAttachments, const GLenum * attachments, GLint x, GLint y, GLsizei width, GLsizei height);
void GLTrace_glTexStorage2D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
void GLTrace_glTexStorage3D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
void GLTrace_glGetInternalformativ(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint * params);
void GLTrace_glDispatchCompute(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z);
void GLTrace_glDispatchComputeIndirect(GLintptr indirect);
void GLTrace_glDrawArraysIndirect(GLenum mode, const void * indirect);
void GLTrace_glDrawElementsIndirect(GLenum mode, GLenum type, const void * indirect);
void GLTrace_glFramebufferParameteri(GLenum target, GLenum pname, GLint param);
void GLTrace_glGetFramebufferParameteriv(GLenum target, GLenum pname, GLint * params);
void GLTrace_glGetProgramInterfaceiv(GLuint program, GLenum programInterface, GLenum pname, GLint * params);
GLuint GLTrace_glGetProgramResourceIndex(GLuint program, GLenum programInterface, const GLchar * name);
void GLTrace_glGetProgramResourceName(GLuint program, GLenum programInterface, GLuint index, GLsizei bufSize, GLsizei * length, GLchar * name);
void GLTrace_glGetProgramResourceiv(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum * props, GLsizei bufSize, GLsizei * length, GLint * params);
GLint GLTrace_glGetProgramResourceLocation(GLuint program, GLenum programInterface, const GLchar * name);
void GLTrace_glUseProgramStages(GLuint pipeline, GLbitfield stages, GLuint program);
void GLTrace_glActiveShaderProgram(GLuint pipeline, GLuint program);
GLuint GLTrace_glCreateShaderProgramv(GLenum type, GLsizei count, const GLchar *const* strings);
void GLTrace_glBindProgramPipeline(GLuint pipeline);
void GLTrace_glDeleteProgramPipelines(GLsizei n, const GLuint * pipelines);
void GLTrace_glGenProgramPipelines(GLsizei n, GLuint * pipelines);
GLboolean GLTrace_glIsProgramPipeline(GLuint pipeline);
void GLTrace_glGetProgramPipelineiv(GLuint pipeline, GLenum pname, GLint * params);
void GLTrace_glProgramUniform1i(GLuint program, GLint location, GLint v0);
void GLTrace_glProgramUniform2i(GLuint program, GLint location, GLint v0, GLint v1);
void GLTrace_glProgramUniform3i(GLuint program, GLint location, GLint v0, GLint v1, GLint v2);
void GLTrace_glProgramUniform4i(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
void GLTrace_glProgramUniform1ui(GLuint program, GLint location, GLuint v0);
void GLTrace_glProgramUniform2ui(GLuint program, GLint location, GLuint v0, GLuint v1);
void GLTrace_glProgramUniform3ui(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2);
void GLTrace_glProgramUniform4ui(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);
void GLTrace_glProgramUniform1f(GLuint program, GLint location, GLfloat v0);
void GLTrace_glProgramUniform2f(GLuint program, GLint location, GLfloat v0, GLfloat v1);
void GLTrace_glProgramUniform3f(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
void GLTrace_glProgramUniform4f(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
void GLTrace_glProgramUniform1iv(GLuint program, GLint location, GLsizei count, const GLint * value);
void GLTrace_glProgramUniform2iv(GLuint program, GLint location, GLsizei count, const GLint * value);
void GLTrace_glProgramUniform3iv(GLuint program, GLint location, GLsizei count, const GLint * value);
void GLTrace_glProgramUniform4iv(GLuint program, GLint location, GLsizei count, const GLint * value);
void GLTrace_glProgramUniform1uiv(GLuint program, GLint location, GLsizei count, const GLuint * value);
void GLTrace_glProgramUniform2uiv(GLuint program, GLint location, GLsizei count, const GLuint * value);
void GLTrace_glProgramUniform3uiv(GLuint program, GLint location, GLsizei count, const GLuint * value);
void GLTrace_glProgramUniform4uiv(GLuint program, GLint location, GLsizei count, const GLuint * value);
void GLTrace_glProgramUniform1fv(GLuint program, GLint location, GLsizei count, const GLfloat * value);
void GLTrace_glProgramUniform2fv(GLuint program, GLint location, GLsizei count, const GLfloat * value);
void GLTrace_glProgramUniform3fv(GLuint program, GLint location, GLsizei count, const GLfloat * value);
void GLTrace_glProgramUniform4fv(GLuint program, GLint location, GLsizei count, const GLfloat * value);
void GLTrace_glProgramUniformMatrix2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glProgramUniformMatrix3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glProgramUniformMatrix4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glProgramUniformMatrix2x3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glProgramUniformMatrix3x2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glProgramUniformMatrix2x4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glProgramUniformMatrix4x2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glProgramUniformMatrix3x4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glProgramUniformMatrix4x3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glValidateProgramPipeline(GLuint pipeline);
void GLTrace_glGetProgramPipelineInfoLog(GLuint pipeline, GLsizei bufSize, GLsizei * length, GLchar * infoLog);
void GLTrace_glBindImageTexture(GLuint unit, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLenum format);
void GLTrace_glGetBooleani_v(GLenum target, GLuint index, GLboolean * data);
void GLTrace_glMemoryBarrier(GLbitfield barriers);
void GLTrace_glMemoryBarrierByRegion(GLbitfield barriers);
void GLTrace_glTexStorage2DMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
void GLTrace_glGetMultisamplefv(GLenum pname, GLuint index, GLfloat * val);
void GLTrace_glSampleMaski(GLuint maskNumber, GLbitfield mask);
void GLTrace_glGetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint * params);
void GLTrace_glGetTexLevelParameterfv(GLenum target, GLint level, GLenum pname, GLfloat * params);
void GLTrace_glBindVertexBuffer(GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride);
void GLTrace_glVertexAttribFormat(GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset);
void GLTrace_glVertexAttribIFormat(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
void GLTrace_glVertexAttribBinding(GLuint attribindex, GLuint bindingindex);
void GLTrace_glVertexBindingDivisor(GLuint bindingindex, GLuint divisor);

// Declarations for GL2Ext APIs

void GLTrace_glBlendBarrierKHR(void);
void GLTrace_glDebugMessageControlKHR(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint * ids, GLboolean enabled);
void GLTrace_glDebugMessageInsertKHR(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar * buf);
void GLTrace_glDebugMessageCallbackKHR(GLDEBUGPROCKHR callback, const void * userParam);
GLuint GLTrace_glGetDebugMessageLogKHR(GLuint count, GLsizei bufSize, GLenum * sources, GLenum * types, GLuint * ids, GLenum * severities, GLsizei * lengths, GLchar * messageLog);
void GLTrace_glPushDebugGroupKHR(GLenum source, GLuint id, GLsizei length, const GLchar * message);
void GLTrace_glPopDebugGroupKHR(void);
void GLTrace_glObjectLabelKHR(GLenum identifier, GLuint name, GLsizei length, const GLchar * label);
void GLTrace_glGetObjectLabelKHR(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei * length, GLchar * label);
void GLTrace_glObjectPtrLabelKHR(const void * ptr, GLsizei length, const GLchar * label);
void GLTrace_glGetObjectPtrLabelKHR(const void * ptr, GLsizei bufSize, GLsizei * length, GLchar * label);
void GLTrace_glGetPointervKHR(GLenum pname, void ** params);
void GLTrace_glEGLImageTargetTexture2DOES(GLenum target, GLeglImageOES image);
void GLTrace_glEGLImageTargetRenderbufferStorageOES(GLenum target, GLeglImageOES image);
void GLTrace_glGetProgramBinaryOES(GLuint program, GLsizei bufSize, GLsizei * length, GLenum * binaryFormat, void * binary);
void GLTrace_glProgramBinaryOES(GLuint program, GLenum binaryFormat, const void * binary, GLint length);
void * GLTrace_glMapBufferOES(GLenum target, GLenum access);
GLboolean GLTrace_glUnmapBufferOES(GLenum target);
void GLTrace_glGetBufferPointervOES(GLenum target, GLenum pname, void ** params);
void GLTrace_glMinSampleShadingOES(GLfloat value);
void GLTrace_glTexImage3DOES(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void * pixels);
void GLTrace_glTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void * pixels);
void GLTrace_glCopyTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
void GLTrace_glCompressedTexImage3DOES(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void * data);
void GLTrace_glCompressedTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void * data);
void GLTrace_glFramebufferTexture3DOES(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
void GLTrace_glTexStorage3DMultisampleOES(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
void GLTrace_glBindVertexArrayOES(GLuint array);
void GLTrace_glDeleteVertexArraysOES(GLsizei n, const GLuint * arrays);
void GLTrace_glGenVertexArraysOES(GLsizei n, GLuint * arrays);
GLboolean GLTrace_glIsVertexArrayOES(GLuint array);
void GLTrace_glGetPerfMonitorGroupsAMD(GLint * numGroups, GLsizei groupsSize, GLuint * groups);
void GLTrace_glGetPerfMonitorCountersAMD(GLuint group, GLint * numCounters, GLint * maxActiveCounters, GLsizei counterSize, GLuint * counters);
void GLTrace_glGetPerfMonitorGroupStringAMD(GLuint group, GLsizei bufSize, GLsizei * length, GLchar * groupString);
void GLTrace_glGetPerfMonitorCounterStringAMD(GLuint group, GLuint counter, GLsizei bufSize, GLsizei * length, GLchar * counterString);
void GLTrace_glGetPerfMonitorCounterInfoAMD(GLuint group, GLuint counter, GLenum pname, void * data);
void GLTrace_glGenPerfMonitorsAMD(GLsizei n, GLuint * monitors);
void GLTrace_glDeletePerfMonitorsAMD(GLsizei n, GLuint * monitors);
void GLTrace_glSelectPerfMonitorCountersAMD(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint * counterList);
void GLTrace_glBeginPerfMonitorAMD(GLuint monitor);
void GLTrace_glEndPerfMonitorAMD(GLuint monitor);
void GLTrace_glGetPerfMonitorCounterDataAMD(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint * data, GLint * bytesWritten);
void GLTrace_glBlitFramebufferANGLE(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
void GLTrace_glRenderbufferStorageMultisampleANGLE(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
void GLTrace_glDrawArraysInstancedANGLE(GLenum mode, GLint first, GLsizei count, GLsizei primcount);
void GLTrace_glDrawElementsInstancedANGLE(GLenum mode, GLsizei count, GLenum type, const void * indices, GLsizei primcount);
void GLTrace_glVertexAttribDivisorANGLE(GLuint index, GLuint divisor);
void GLTrace_glGetTranslatedShaderSourceANGLE(GLuint shader, GLsizei bufsize, GLsizei * length, GLchar * source);
void GLTrace_glCopyTextureLevelsAPPLE(GLuint destinationTexture, GLuint sourceTexture, GLint sourceBaseLevel, GLsizei sourceLevelCount);
void GLTrace_glRenderbufferStorageMultisampleAPPLE(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
void GLTrace_glResolveMultisampleFramebufferAPPLE(void);
GLsync GLTrace_glFenceSyncAPPLE(GLenum condition, GLbitfield flags);
GLboolean GLTrace_glIsSyncAPPLE(GLsync sync);
void GLTrace_glDeleteSyncAPPLE(GLsync sync);
GLenum GLTrace_glClientWaitSyncAPPLE(GLsync sync, GLbitfield flags, GLuint64 timeout);
void GLTrace_glWaitSyncAPPLE(GLsync sync, GLbitfield flags, GLuint64 timeout);
void GLTrace_glGetInteger64vAPPLE(GLenum pname, GLint64 * params);
void GLTrace_glGetSyncivAPPLE(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei * length, GLint * values);
void GLTrace_glCopyImageSubDataEXT(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth);
void GLTrace_glLabelObjectEXT(GLenum type, GLuint object, GLsizei length, const GLchar * label);
void GLTrace_glGetObjectLabelEXT(GLenum type, GLuint object, GLsizei bufSize, GLsizei * length, GLchar * label);
void GLTrace_glInsertEventMarkerEXT(GLsizei length, const GLchar * marker);
void GLTrace_glPushGroupMarkerEXT(GLsizei length, const GLchar * marker);
void GLTrace_glPopGroupMarkerEXT(void);
void GLTrace_glDiscardFramebufferEXT(GLenum target, GLsizei numAttachments, const GLenum * attachments);
void GLTrace_glGenQueriesEXT(GLsizei n, GLuint * ids);
void GLTrace_glDeleteQueriesEXT(GLsizei n, const GLuint * ids);
GLboolean GLTrace_glIsQueryEXT(GLuint id);
void GLTrace_glBeginQueryEXT(GLenum target, GLuint id);
void GLTrace_glEndQueryEXT(GLenum target);
void GLTrace_glQueryCounterEXT(GLuint id, GLenum target);
void GLTrace_glGetQueryivEXT(GLenum target, GLenum pname, GLint * params);
void GLTrace_glGetQueryObjectivEXT(GLuint id, GLenum pname, GLint * params);
void GLTrace_glGetQueryObjectuivEXT(GLuint id, GLenum pname, GLuint * params);
void GLTrace_glGetQueryObjecti64vEXT(GLuint id, GLenum pname, GLint64 * params);
void GLTrace_glGetQueryObjectui64vEXT(GLuint id, GLenum pname, GLuint64 * params);
void GLTrace_glDrawBuffersEXT(GLsizei n, const GLenum * bufs);
void GLTrace_glEnableiEXT(GLenum target, GLuint index);
void GLTrace_glDisableiEXT(GLenum target, GLuint index);
void GLTrace_glBlendEquationiEXT(GLuint buf, GLenum mode);
void GLTrace_glBlendEquationSeparateiEXT(GLuint buf, GLenum modeRGB, GLenum modeAlpha);
void GLTrace_glBlendFunciEXT(GLuint buf, GLenum src, GLenum dst);
void GLTrace_glBlendFuncSeparateiEXT(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);
void GLTrace_glColorMaskiEXT(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a);
GLboolean GLTrace_glIsEnablediEXT(GLenum target, GLuint index);
void GLTrace_glDrawArraysInstancedEXT(GLenum mode, GLint start, GLsizei count, GLsizei primcount);
void GLTrace_glDrawElementsInstancedEXT(GLenum mode, GLsizei count, GLenum type, const void * indices, GLsizei primcount);
void GLTrace_glFramebufferTextureEXT(GLenum target, GLenum attachment, GLuint texture, GLint level);
void GLTrace_glVertexAttribDivisorEXT(GLuint index, GLuint divisor);
void * GLTrace_glMapBufferRangeEXT(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access);
void GLTrace_glFlushMappedBufferRangeEXT(GLenum target, GLintptr offset, GLsizeiptr length);
void GLTrace_glMultiDrawArraysEXT(GLenum mode, const GLint * first, const GLsizei * count, GLsizei primcount);
void GLTrace_glMultiDrawElementsEXT(GLenum mode, const GLsizei * count, GLenum type, const void *const* indices, GLsizei primcount);
void GLTrace_glRenderbufferStorageMultisampleEXT(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
void GLTrace_glFramebufferTexture2DMultisampleEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples);
void GLTrace_glReadBufferIndexedEXT(GLenum src, GLint index);
void GLTrace_glDrawBuffersIndexedEXT(GLint n, const GLenum * location, const GLint * indices);
void GLTrace_glGetIntegeri_vEXT(GLenum target, GLuint index, GLint * data);
void GLTrace_glPrimitiveBoundingBoxEXT(GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW);
GLenum GLTrace_glGetGraphicsResetStatusEXT(void);
void GLTrace_glReadnPixelsEXT(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void * data);
void GLTrace_glGetnUniformfvEXT(GLuint program, GLint location, GLsizei bufSize, GLfloat * params);
void GLTrace_glGetnUniformivEXT(GLuint program, GLint location, GLsizei bufSize, GLint * params);
void GLTrace_glActiveShaderProgramEXT(GLuint pipeline, GLuint program);
void GLTrace_glBindProgramPipelineEXT(GLuint pipeline);
GLuint GLTrace_glCreateShaderProgramvEXT(GLenum type, GLsizei count, const GLchar ** strings);
void GLTrace_glDeleteProgramPipelinesEXT(GLsizei n, const GLuint * pipelines);
void GLTrace_glGenProgramPipelinesEXT(GLsizei n, GLuint * pipelines);
void GLTrace_glGetProgramPipelineInfoLogEXT(GLuint pipeline, GLsizei bufSize, GLsizei * length, GLchar * infoLog);
void GLTrace_glGetProgramPipelineivEXT(GLuint pipeline, GLenum pname, GLint * params);
GLboolean GLTrace_glIsProgramPipelineEXT(GLuint pipeline);
void GLTrace_glProgramParameteriEXT(GLuint program, GLenum pname, GLint value);
void GLTrace_glProgramUniform1fEXT(GLuint program, GLint location, GLfloat v0);
void GLTrace_glProgramUniform1fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat * value);
void GLTrace_glProgramUniform1iEXT(GLuint program, GLint location, GLint v0);
void GLTrace_glProgramUniform1ivEXT(GLuint program, GLint location, GLsizei count, const GLint * value);
void GLTrace_glProgramUniform2fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1);
void GLTrace_glProgramUniform2fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat * value);
void GLTrace_glProgramUniform2iEXT(GLuint program, GLint location, GLint v0, GLint v1);
void GLTrace_glProgramUniform2ivEXT(GLuint program, GLint location, GLsizei count, const GLint * value);
void GLTrace_glProgramUniform3fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
void GLTrace_glProgramUniform3fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat * value);
void GLTrace_glProgramUniform3iEXT(GLuint program, GLint location, GLint v0, GLint v1, GLint v2);
void GLTrace_glProgramUniform3ivEXT(GLuint program, GLint location, GLsizei count, const GLint * value);
void GLTrace_glProgramUniform4fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
void GLTrace_glProgramUniform4fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat * value);
void GLTrace_glProgramUniform4iEXT(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
void GLTrace_glProgramUniform4ivEXT(GLuint program, GLint location, GLsizei count, const GLint * value);
void GLTrace_glProgramUniformMatrix2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glProgramUniformMatrix3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glProgramUniformMatrix4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glUseProgramStagesEXT(GLuint pipeline, GLbitfield stages, GLuint program);
void GLTrace_glValidateProgramPipelineEXT(GLuint pipeline);
void GLTrace_glProgramUniform1uiEXT(GLuint program, GLint location, GLuint v0);
void GLTrace_glProgramUniform2uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1);
void GLTrace_glProgramUniform3uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2);
void GLTrace_glProgramUniform4uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);
void GLTrace_glProgramUniform1uivEXT(GLuint program, GLint location, GLsizei count, const GLuint * value);
void GLTrace_glProgramUniform2uivEXT(GLuint program, GLint location, GLsizei count, const GLuint * value);
void GLTrace_glProgramUniform3uivEXT(GLuint program, GLint location, GLsizei count, const GLuint * value);
void GLTrace_glProgramUniform4uivEXT(GLuint program, GLint location, GLsizei count, const GLuint * value);
void GLTrace_glProgramUniformMatrix2x3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glProgramUniformMatrix3x2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glProgramUniformMatrix2x4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glProgramUniformMatrix4x2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glProgramUniformMatrix3x4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glProgramUniformMatrix4x3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glPatchParameteriEXT(GLenum pname, GLint value);
void GLTrace_glTexParameterIivEXT(GLenum target, GLenum pname, const GLint * params);
void GLTrace_glTexParameterIuivEXT(GLenum target, GLenum pname, const GLuint * params);
void GLTrace_glGetTexParameterIivEXT(GLenum target, GLenum pname, GLint * params);
void GLTrace_glGetTexParameterIuivEXT(GLenum target, GLenum pname, GLuint * params);
void GLTrace_glSamplerParameterIivEXT(GLuint sampler, GLenum pname, const GLint * param);
void GLTrace_glSamplerParameterIuivEXT(GLuint sampler, GLenum pname, const GLuint * param);
void GLTrace_glGetSamplerParameterIivEXT(GLuint sampler, GLenum pname, GLint * params);
void GLTrace_glGetSamplerParameterIuivEXT(GLuint sampler, GLenum pname, GLuint * params);
void GLTrace_glTexBufferEXT(GLenum target, GLenum internalformat, GLuint buffer);
void GLTrace_glTexBufferRangeEXT(GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size);
void GLTrace_glTexStorage1DEXT(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);
void GLTrace_glTexStorage2DEXT(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
void GLTrace_glTexStorage3DEXT(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
void GLTrace_glTextureStorage1DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);
void GLTrace_glTextureStorage2DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
void GLTrace_glTextureStorage3DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
void GLTrace_glTextureViewEXT(GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers);
void GLTrace_glRenderbufferStorageMultisampleIMG(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
void GLTrace_glFramebufferTexture2DMultisampleIMG(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples);
void GLTrace_glBeginPerfQueryINTEL(GLuint queryHandle);
void GLTrace_glCreatePerfQueryINTEL(GLuint queryId, GLuint * queryHandle);
void GLTrace_glDeletePerfQueryINTEL(GLuint queryHandle);
void GLTrace_glEndPerfQueryINTEL(GLuint queryHandle);
void GLTrace_glGetFirstPerfQueryIdINTEL(GLuint * queryId);
void GLTrace_glGetNextPerfQueryIdINTEL(GLuint queryId, GLuint * nextQueryId);
void GLTrace_glGetPerfCounterInfoINTEL(GLuint queryId, GLuint counterId, GLuint counterNameLength, GLchar * counterName, GLuint counterDescLength, GLchar * counterDesc, GLuint * counterOffset, GLuint * counterDataSize, GLuint * counterTypeEnum, GLuint * counterDataTypeEnum, GLuint64 * rawCounterMaxValue);
void GLTrace_glGetPerfQueryDataINTEL(GLuint queryHandle, GLuint flags, GLsizei dataSize, GLvoid * data, GLuint * bytesWritten);
void GLTrace_glGetPerfQueryIdByNameINTEL(GLchar * queryName, GLuint * queryId);
void GLTrace_glGetPerfQueryInfoINTEL(GLuint queryId, GLuint queryNameLength, GLchar * queryName, GLuint * dataSize, GLuint * noCounters, GLuint * noInstances, GLuint * capsMask);
void GLTrace_glBlendParameteriNV(GLenum pname, GLint value);
void GLTrace_glBlendBarrierNV(void);
void GLTrace_glCopyBufferSubDataNV(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size);
void GLTrace_glCoverageMaskNV(GLboolean mask);
void GLTrace_glCoverageOperationNV(GLenum operation);
void GLTrace_glDrawBuffersNV(GLsizei n, const GLenum * bufs);
void GLTrace_glDrawArraysInstancedNV(GLenum mode, GLint first, GLsizei count, GLsizei primcount);
void GLTrace_glDrawElementsInstancedNV(GLenum mode, GLsizei count, GLenum type, const void * indices, GLsizei primcount);
void GLTrace_glDeleteFencesNV(GLsizei n, const GLuint * fences);
void GLTrace_glGenFencesNV(GLsizei n, GLuint * fences);
GLboolean GLTrace_glIsFenceNV(GLuint fence);
GLboolean GLTrace_glTestFenceNV(GLuint fence);
void GLTrace_glGetFenceivNV(GLuint fence, GLenum pname, GLint * params);
void GLTrace_glFinishFenceNV(GLuint fence);
void GLTrace_glSetFenceNV(GLuint fence, GLenum condition);
void GLTrace_glBlitFramebufferNV(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
void GLTrace_glRenderbufferStorageMultisampleNV(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
void GLTrace_glVertexAttribDivisorNV(GLuint index, GLuint divisor);
void GLTrace_glUniformMatrix2x3fvNV(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glUniformMatrix3x2fvNV(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glUniformMatrix2x4fvNV(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glUniformMatrix4x2fvNV(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glUniformMatrix3x4fvNV(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glUniformMatrix4x3fvNV(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
void GLTrace_glReadBufferNV(GLenum mode);
void GLTrace_glAlphaFuncQCOM(GLenum func, GLclampf ref);
void GLTrace_glGetDriverControlsQCOM(GLint * num, GLsizei size, GLuint * driverControls);
void GLTrace_glGetDriverControlStringQCOM(GLuint driverControl, GLsizei bufSize, GLsizei * length, GLchar * driverControlString);
void GLTrace_glEnableDriverControlQCOM(GLuint driverControl);
void GLTrace_glDisableDriverControlQCOM(GLuint driverControl);
void GLTrace_glExtGetTexturesQCOM(GLuint * textures, GLint maxTextures, GLint * numTextures);
void GLTrace_glExtGetBuffersQCOM(GLuint * buffers, GLint maxBuffers, GLint * numBuffers);
void GLTrace_glExtGetRenderbuffersQCOM(GLuint * renderbuffers, GLint maxRenderbuffers, GLint * numRenderbuffers);
void GLTrace_glExtGetFramebuffersQCOM(GLuint * framebuffers, GLint maxFramebuffers, GLint * numFramebuffers);
void GLTrace_glExtGetTexLevelParameterivQCOM(GLuint texture, GLenum face, GLint level, GLenum pname, GLint * params);
void GLTrace_glExtTexObjectStateOverrideiQCOM(GLenum target, GLenum pname, GLint param);
void GLTrace_glExtGetTexSubImageQCOM(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, void * texels);
void GLTrace_glExtGetBufferPointervQCOM(GLenum target, void ** params);
void GLTrace_glExtGetShadersQCOM(GLuint * shaders, GLint maxShaders, GLint * numShaders);
void GLTrace_glExtGetProgramsQCOM(GLuint * programs, GLint maxPrograms, GLint * numPrograms);
GLboolean GLTrace_glExtIsProgramBinaryQCOM(GLuint program);
void GLTrace_glExtGetProgramBinarySourceQCOM(GLuint program, GLenum shadertype, GLchar * source, GLint * length);
void GLTrace_glStartTilingQCOM(GLuint x, GLuint y, GLuint width, GLuint height, GLbitfield preserveMask);
void GLTrace_glEndTilingQCOM(GLbitfield preserveMask);

// Declarations for GL1 APIs

void GLTrace_glAlphaFunc(GLenum func, GLfloat ref);
void GLTrace_glClipPlanef(GLenum p, const GLfloat * eqn);
void GLTrace_glColor4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
void GLTrace_glFogf(GLenum pname, GLfloat param);
void GLTrace_glFogfv(GLenum pname, const GLfloat * params);
void GLTrace_glFrustumf(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f);
void GLTrace_glGetClipPlanef(GLenum plane, GLfloat * equation);
void GLTrace_glGetLightfv(GLenum light, GLenum pname, GLfloat * params);
void GLTrace_glGetMaterialfv(GLenum face, GLenum pname, GLfloat * params);
void GLTrace_glGetTexEnvfv(GLenum target, GLenum pname, GLfloat * params);
void GLTrace_glLightModelf(GLenum pname, GLfloat param);
void GLTrace_glLightModelfv(GLenum pname, const GLfloat * params);
void GLTrace_glLightf(GLenum light, GLenum pname, GLfloat param);
void GLTrace_glLightfv(GLenum light, GLenum pname, const GLfloat * params);
void GLTrace_glLoadMatrixf(const GLfloat * m);
void GLTrace_glMaterialf(GLenum face, GLenum pname, GLfloat param);
void GLTrace_glMaterialfv(GLenum face, GLenum pname, const GLfloat * params);
void GLTrace_glMultMatrixf(const GLfloat * m);
void GLTrace_glMultiTexCoord4f(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
void GLTrace_glNormal3f(GLfloat nx, GLfloat ny, GLfloat nz);
void GLTrace_glOrthof(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f);
void GLTrace_glPointParameterf(GLenum pname, GLfloat param);
void GLTrace_glPointParameterfv(GLenum pname, const GLfloat * params);
void GLTrace_glPointSize(GLfloat size);
void GLTrace_glRotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
void GLTrace_glScalef(GLfloat x, GLfloat y, GLfloat z);
void GLTrace_glTexEnvf(GLenum target, GLenum pname, GLfloat param);
void GLTrace_glTexEnvfv(GLenum target, GLenum pname, const GLfloat * params);
void GLTrace_glTranslatef(GLfloat x, GLfloat y, GLfloat z);
void GLTrace_glAlphaFuncx(GLenum func, GLfixed ref);
void GLTrace_glClearColorx(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha);
void GLTrace_glClearDepthx(GLfixed depth);
void GLTrace_glClientActiveTexture(GLenum texture);
void GLTrace_glClipPlanex(GLenum plane, const GLfixed * equation);
void GLTrace_glColor4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha);
void GLTrace_glColor4x(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha);
void GLTrace_glColorPointer(GLint size, GLenum type, GLsizei stride, const void * pointer);
void GLTrace_glDepthRangex(GLfixed n, GLfixed f);
void GLTrace_glDisableClientState(GLenum array);
void GLTrace_glEnableClientState(GLenum array);
void GLTrace_glFogx(GLenum pname, GLfixed param);
void GLTrace_glFogxv(GLenum pname, const GLfixed * param);
void GLTrace_glFrustumx(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f);
void GLTrace_glGetClipPlanex(GLenum plane, GLfixed * equation);
void GLTrace_glGetFixedv(GLenum pname, GLfixed * params);
void GLTrace_glGetLightxv(GLenum light, GLenum pname, GLfixed * params);
void GLTrace_glGetMaterialxv(GLenum face, GLenum pname, GLfixed * params);
void GLTrace_glGetPointerv(GLenum pname, void ** params);
void GLTrace_glGetTexEnviv(GLenum target, GLenum pname, GLint * params);
void GLTrace_glGetTexEnvxv(GLenum target, GLenum pname, GLfixed * params);
void GLTrace_glGetTexParameterxv(GLenum target, GLenum pname, GLfixed * params);
void GLTrace_glLightModelx(GLenum pname, GLfixed param);
void GLTrace_glLightModelxv(GLenum pname, const GLfixed * param);
void GLTrace_glLightx(GLenum light, GLenum pname, GLfixed param);
void GLTrace_glLightxv(GLenum light, GLenum pname, const GLfixed * params);
void GLTrace_glLineWidthx(GLfixed width);
void GLTrace_glLoadIdentity(void);
void GLTrace_glLoadMatrixx(const GLfixed * m);
void GLTrace_glLogicOp(GLenum opcode);
void GLTrace_glMaterialx(GLenum face, GLenum pname, GLfixed param);
void GLTrace_glMaterialxv(GLenum face, GLenum pname, const GLfixed * param);
void GLTrace_glMatrixMode(GLenum mode);
void GLTrace_glMultMatrixx(const GLfixed * m);
void GLTrace_glMultiTexCoord4x(GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q);
void GLTrace_glNormal3x(GLfixed nx, GLfixed ny, GLfixed nz);
void GLTrace_glNormalPointer(GLenum type, GLsizei stride, const void * pointer);
void GLTrace_glOrthox(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f);
void GLTrace_glPointParameterx(GLenum pname, GLfixed param);
void GLTrace_glPointParameterxv(GLenum pname, const GLfixed * params);
void GLTrace_glPointSizex(GLfixed size);
void GLTrace_glPolygonOffsetx(GLfixed factor, GLfixed units);
void GLTrace_glPopMatrix(void);
void GLTrace_glPushMatrix(void);
void GLTrace_glRotatex(GLfixed angle, GLfixed x, GLfixed y, GLfixed z);
void GLTrace_glSampleCoveragex(GLclampx value, GLboolean invert);
void GLTrace_glScalex(GLfixed x, GLfixed y, GLfixed z);
void GLTrace_glShadeModel(GLenum mode);
void GLTrace_glTexCoordPointer(GLint size, GLenum type, GLsizei stride, const void * pointer);
void GLTrace_glTexEnvi(GLenum target, GLenum pname, GLint param);
void GLTrace_glTexEnvx(GLenum target, GLenum pname, GLfixed param);
void GLTrace_glTexEnviv(GLenum target, GLenum pname, const GLint * params);
void GLTrace_glTexEnvxv(GLenum target, GLenum pname, const GLfixed * params);
void GLTrace_glTexParameterx(GLenum target, GLenum pname, GLfixed param);
void GLTrace_glTexParameterxv(GLenum target, GLenum pname, const GLfixed * params);
void GLTrace_glTranslatex(GLfixed x, GLfixed y, GLfixed z);
void GLTrace_glVertexPointer(GLint size, GLenum type, GLsizei stride, const void * pointer);

// Declarations for GL1Ext APIs

void GLTrace_glBlendEquationSeparateOES(GLenum modeRGB, GLenum modeAlpha);
void GLTrace_glBlendFuncSeparateOES(GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);
void GLTrace_glBlendEquationOES(GLenum mode);
void GLTrace_glMultiTexCoord1bOES(GLenum texture, GLbyte s);
void GLTrace_glMultiTexCoord1bvOES(GLenum texture, const GLbyte * coords);
void GLTrace_glMultiTexCoord2bOES(GLenum texture, GLbyte s, GLbyte t);
void GLTrace_glMultiTexCoord2bvOES(GLenum texture, const GLbyte * coords);
void GLTrace_glMultiTexCoord3bOES(GLenum texture, GLbyte s, GLbyte t, GLbyte r);
void GLTrace_glMultiTexCoord3bvOES(GLenum texture, const GLbyte * coords);
void GLTrace_glMultiTexCoord4bOES(GLenum texture, GLbyte s, GLbyte t, GLbyte r, GLbyte q);
void GLTrace_glMultiTexCoord4bvOES(GLenum texture, const GLbyte * coords);
void GLTrace_glTexCoord1bOES(GLbyte s);
void GLTrace_glTexCoord1bvOES(const GLbyte * coords);
void GLTrace_glTexCoord2bOES(GLbyte s, GLbyte t);
void GLTrace_glTexCoord2bvOES(const GLbyte * coords);
void GLTrace_glTexCoord3bOES(GLbyte s, GLbyte t, GLbyte r);
void GLTrace_glTexCoord3bvOES(const GLbyte * coords);
void GLTrace_glTexCoord4bOES(GLbyte s, GLbyte t, GLbyte r, GLbyte q);
void GLTrace_glTexCoord4bvOES(const GLbyte * coords);
void GLTrace_glVertex2bOES(GLbyte x);
void GLTrace_glVertex2bvOES(const GLbyte * coords);
void GLTrace_glVertex3bOES(GLbyte x, GLbyte y);
void GLTrace_glVertex3bvOES(const GLbyte * coords);
void GLTrace_glVertex4bOES(GLbyte x, GLbyte y, GLbyte z);
void GLTrace_glVertex4bvOES(const GLbyte * coords);
void GLTrace_glDrawTexsOES(GLshort x, GLshort y, GLshort z, GLshort width, GLshort height);
void GLTrace_glDrawTexiOES(GLint x, GLint y, GLint z, GLint width, GLint height);
void GLTrace_glDrawTexxOES(GLfixed x, GLfixed y, GLfixed z, GLfixed width, GLfixed height);
void GLTrace_glDrawTexsvOES(const GLshort * coords);
void GLTrace_glDrawTexivOES(const GLint * coords);
void GLTrace_glDrawTexxvOES(const GLfixed * coords);
void GLTrace_glDrawTexfOES(GLfloat x, GLfloat y, GLfloat z, GLfloat width, GLfloat height);
void GLTrace_glDrawTexfvOES(const GLfloat * coords);
void GLTrace_glAlphaFuncxOES(GLenum func, GLfixed ref);
void GLTrace_glClearColorxOES(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha);
void GLTrace_glClearDepthxOES(GLfixed depth);
void GLTrace_glClipPlanexOES(GLenum plane, const GLfixed * equation);
void GLTrace_glColor4xOES(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha);
void GLTrace_glDepthRangexOES(GLfixed n, GLfixed f);
void GLTrace_glFogxOES(GLenum pname, GLfixed param);
void GLTrace_glFogxvOES(GLenum pname, const GLfixed * param);
void GLTrace_glFrustumxOES(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f);
void GLTrace_glGetClipPlanexOES(GLenum plane, GLfixed * equation);
void GLTrace_glGetFixedvOES(GLenum pname, GLfixed * params);
void GLTrace_glGetTexEnvxvOES(GLenum target, GLenum pname, GLfixed * params);
void GLTrace_glGetTexParameterxvOES(GLenum target, GLenum pname, GLfixed * params);
void GLTrace_glLightModelxOES(GLenum pname, GLfixed param);
void GLTrace_glLightModelxvOES(GLenum pname, const GLfixed * param);
void GLTrace_glLightxOES(GLenum light, GLenum pname, GLfixed param);
void GLTrace_glLightxvOES(GLenum light, GLenum pname, const GLfixed * params);
void GLTrace_glLineWidthxOES(GLfixed width);
void GLTrace_glLoadMatrixxOES(const GLfixed * m);
void GLTrace_glMaterialxOES(GLenum face, GLenum pname, GLfixed param);
void GLTrace_glMaterialxvOES(GLenum face, GLenum pname, const GLfixed * param);
void GLTrace_glMultMatrixxOES(const GLfixed * m);
void GLTrace_glMultiTexCoord4xOES(GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q);
void GLTrace_glNormal3xOES(GLfixed nx, GLfixed ny, GLfixed nz);
void GLTrace_glOrthoxOES(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f);
void GLTrace_glPointParameterxvOES(GLenum pname, const GLfixed * params);
void GLTrace_glPointSizexOES(GLfixed size);
void GLTrace_glPolygonOffsetxOES(GLfixed factor, GLfixed units);
void GLTrace_glRotatexOES(GLfixed angle, GLfixed x, GLfixed y, GLfixed z);
void GLTrace_glSampleCoverageOES(GLfixed value, GLboolean invert);
void GLTrace_glScalexOES(GLfixed x, GLfixed y, GLfixed z);
void GLTrace_glTexEnvxOES(GLenum target, GLenum pname, GLfixed param);
void GLTrace_glTexEnvxvOES(GLenum target, GLenum pname, const GLfixed * params);
void GLTrace_glTexParameterxOES(GLenum target, GLenum pname, GLfixed param);
void GLTrace_glTexParameterxvOES(GLenum target, GLenum pname, const GLfixed * params);
void GLTrace_glTranslatexOES(GLfixed x, GLfixed y, GLfixed z);
void GLTrace_glGetLightxvOES(GLenum light, GLenum pname, GLfixed * params);
void GLTrace_glGetMaterialxvOES(GLenum face, GLenum pname, GLfixed * params);
void GLTrace_glPointParameterxOES(GLenum pname, GLfixed param);
void GLTrace_glSampleCoveragexOES(GLclampx value, GLboolean invert);
void GLTrace_glGetTexGenxvOES(GLenum coord, GLenum pname, GLfixed * params);
void GLTrace_glTexGenxOES(GLenum coord, GLenum pname, GLfixed param);
void GLTrace_glTexGenxvOES(GLenum coord, GLenum pname, const GLfixed * params);
GLboolean GLTrace_glIsRenderbufferOES(GLuint renderbuffer);
void GLTrace_glBindRenderbufferOES(GLenum target, GLuint renderbuffer);
void GLTrace_glDeleteRenderbuffersOES(GLsizei n, const GLuint * renderbuffers);
void GLTrace_glGenRenderbuffersOES(GLsizei n, GLuint * renderbuffers);
void GLTrace_glRenderbufferStorageOES(GLenum target, GLenum internalformat, GLsizei width, GLsizei height);
void GLTrace_glGetRenderbufferParameterivOES(GLenum target, GLenum pname, GLint * params);
GLboolean GLTrace_glIsFramebufferOES(GLuint framebuffer);
void GLTrace_glBindFramebufferOES(GLenum target, GLuint framebuffer);
void GLTrace_glDeleteFramebuffersOES(GLsizei n, const GLuint * framebuffers);
void GLTrace_glGenFramebuffersOES(GLsizei n, GLuint * framebuffers);
GLenum GLTrace_glCheckFramebufferStatusOES(GLenum target);
void GLTrace_glFramebufferRenderbufferOES(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
void GLTrace_glFramebufferTexture2DOES(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
void GLTrace_glGetFramebufferAttachmentParameterivOES(GLenum target, GLenum attachment, GLenum pname, GLint * params);
void GLTrace_glGenerateMipmapOES(GLenum target);
void GLTrace_glCurrentPaletteMatrixOES(GLuint matrixpaletteindex);
void GLTrace_glLoadPaletteFromModelViewMatrixOES(void);
void GLTrace_glMatrixIndexPointerOES(GLint size, GLenum type, GLsizei stride, const void * pointer);
void GLTrace_glWeightPointerOES(GLint size, GLenum type, GLsizei stride, const void * pointer);
void GLTrace_glPointSizePointerOES(GLenum type, GLsizei stride, const void * pointer);
GLbitfield GLTrace_glQueryMatrixxOES(GLfixed * mantissa, GLint * exponent);
void GLTrace_glClearDepthfOES(GLclampf depth);
void GLTrace_glClipPlanefOES(GLenum plane, const GLfloat * equation);
void GLTrace_glDepthRangefOES(GLclampf n, GLclampf f);
void GLTrace_glFrustumfOES(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f);
void GLTrace_glGetClipPlanefOES(GLenum plane, GLfloat * equation);
void GLTrace_glOrthofOES(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f);
void GLTrace_glTexGenfOES(GLenum coord, GLenum pname, GLfloat param);
void GLTrace_glTexGenfvOES(GLenum coord, GLenum pname, const GLfloat * params);
void GLTrace_glTexGeniOES(GLenum coord, GLenum pname, GLint param);
void GLTrace_glTexGenivOES(GLenum coord, GLenum pname, const GLint * params);
void GLTrace_glGetTexGenfvOES(GLenum coord, GLenum pname, GLfloat * params);
void GLTrace_glGetTexGenivOES(GLenum coord, GLenum pname, GLint * params);
void GLTrace_glClipPlanefIMG(GLenum p, const GLfloat * eqn);
void GLTrace_glClipPlanexIMG(GLenum p, const GLfixed * eqn);

}; // namespace gltrace
}; // namespace android
