# B.5 Is capitalism empowering and based on human action?

A key element of the social vision propounded by capitalism, particularly
"libertarian" capitalism, is that of "voting" by the "customer," which is
compared to political voting by the "citizen." According to Milton Friedman,
_"when you vote in the supermarket, you get precisely what you voted for and
so does everyone else."_ Such "voting" with one's pocket is then claimed to be
an example of the wonderful "freedom" people enjoy under capitalism (as
opposed to "socialism," always equated by right-wingers with **state**
socialism, which will be discussed in [section H](secHcon.md)). However, in
evaluating this claim, the difference between customers and citizens is
critical.

The customer chooses between products on the shelf that have been designed and
built by others for the purpose of profit. The consumer is the end-user,
essentially a spectator rather than an actor, merely choosing between options
created elsewhere by others. Market decision making is therefore fundamentally
**passive** and **reactionary,** i.e. based on reacting to developments
initiated by others. In contrast, the "citizen" is actively involved, at least
ideally, in all stages of the decision making process, either directly or
through elected delegates. Therefore, given decentralised and participatory-
democratic organisations, decision making by citizens can be **pro-active,**
based on human **action** in which one takes the initiative and sets the
agenda oneself. Indeed, most supporters of the "citizen" model support it
precisely **because** it actively involves individuals in participating in
social decision making, so creating an educational aspect to the process and
developing the abilities and powers of those involved.

In addition, the power of the consumer is not evenly distributed across
society. Thus the expression "voting" when used in a market context expresses
a radically different idea than the one usually associated with it. In
political voting everyone gets one vote, in the market it is one vote per
dollar. What sort of "democracy" is it that gives one person more votes than
tens of thousands of others combined?

Therefore the "consumer" idea fails to take into account the differences in
power that exist on the market as well as assigning an essentially passive
role to the individual. At best they can act on the market as isolated
individuals through their purchasing power. However, such a position is part
of the problem for, as E.F. Schumacher argues, the _"buyer is essentially a
bargain hunter; he is not concerned with the origin of the goods or the
conditions under which they have been produced. His sole concern is to obtain
the best value for money."_ He goes on to note that the market _"therefore
respects only the surface of society and its significance relates to the
momentary situation as it exists there and then. There is no probing into the
depths of things, into the natural or social facts that lie behind them."_
[**Small is Beautiful**, p. 29]

Indeed, the "customer" model actually works **against** any attempt to "probe"
the facts of things. Firstly, consumers rarely know the significance or
implications of the goods they are offered because the price mechanism
withholds such information from them. Secondly, because the atomistic nature
of the market makes discussion about the "why" and "how" of production
difficult -- we get to choose between various "whats". Instead of critically
evaluating the pros and cons of certain economic practices, all we are offered
is the option of choosing between things already produced. We can only
**re**-act when the damage is already done by picking the option which does
least damage (often we do not have even that choice). And to discover a given
products social and ecological impact we have to take a pro-active role by
joining groups which provide this sort of information (information which,
while essential for a rational decision, the market does not and cannot
provide).

Moreover, the "consumer" model fails to recognise that the decisions we make
on the market to satisfy our "wants" are determined by social and market
forces. What we are capable of wanting is relative to the forms of social
organisation we live in. For example, people choose to buy cars because
General Motors bought up and destroyed the tram network in the 1930s and
people buy "fast food" because they have no time to cook because of increasing
working hours. This means that our decisions within the market are often
restricted by economic pressures. For example, the market forces firms, on
pain of bankruptcy, to do whatever possible to be cost-effective. Firms that
pollute, have bad working conditions and so on often gain competitive
advantage in so doing and other firms either have to follow suit or go out of
business. A "race to the bottom" ensures, with individuals making "decisions
of desperation" just to survive. Individual commitments to certain values, in
other words, may become irrelevant simply because the countervailing economic
pressures are simply too intense (little wonder Robert Owen argued that the
profit motive was _"a principle entirely unfavourable to individual and public
happiness"_).

And, of course, the market also does not, and cannot, come up with goods that
we do not want in our capacity as consumers but desire to protect for future
generations or because of ecological reasons. By making the protection of the
planet, eco-systems and other such "goods" dependent on the market, capitalism
ensures that unless we put our money where our mouth is we can have no say in
the protection of such goods as eco-systems, historical sites, and so on. The
need to protect such "resources" in the long term is ignored in favour of
short-termism -- indeed, if we do not "consume" such products today they will
not be there tomorrow. Placed within a society that the vast majority of
people often face difficulties making ends meet, this means that capitalism
can never provide us with goods which we would like to see available as
**people** (either for others or for future generations or just to protect the
planet) but cannot afford or desire as **consumers.**

It is clearly a sign of the increasing dominance of capitalist ideology that
the "customer" model is being transferred to the political arena. This
reflects the fact that the increasing scale of political institutions has
reinforced the tendency noted earlier for voters to become passive spectators,
placing their "support" behind one or another "product" (i.e. party or
leader). As Murray Bookchin comments, _"educated, knowledgeable citizens
become reduced to mere taxpayers who exchange money for 'services.'"_
[**Remaking Society**, p. 71] In practice, due to state centralism, this turns
the political process into an extension of the market, with "citizens" being
reduced to "consumers." Or, in Erich Fromm's apt analysis, _"The functioning
of the political machinery in a democratic country is not essentially
different from the procedure on the commodity market. The political parties
are not too different from big commercial enterprises, and the professional
politicians try to sell their wares to the public."_ [**The Sane Society**,
pp. 186-187]

But does it matter? Friedman suggests that being a customer is **better** than
being a citizen as you get "precisely" what you, and everyone else, wants.

The key questions here are whether people always get what they want when they
shop. Do consumers who buy bleached newsprint and toilet paper **really** want
tons of dioxins and other organochlorides in rivers, lakes and coastal waters?
Do customers who buy cars **really** want traffic jams, air pollution,
motorways carving up the landscape and the greenhouse effect? And what of
those who do not buy these things? They are also affected by the decisions of
others. The notion that only the consumer is affected by his or her decision
is nonsense -- as is the childish desire to get "precisely" what you want,
regardless of the social impact.

Perhaps Friedman could claim that when we consume we also approve of its
impact. But when we "vote" on the market we cannot say that we approved of the
resulting pollution (or distribution of income or power) because that was not
a choice on offer. Such changes are **pre-defined** or an aggregate outcome
and can only be chosen by a collective decision. In this way we can modify
outcomes we could bring about individually but which harm us collectively. And
unlike the market, in politics we can **change our minds** and revert back to
a former state, undoing the mistakes made. No such option is available on the
market.

So Friedman's claims that in elections _"you end up with something different
from what you voted for"_ is equally applicable to the market place.

These considerations indicate that the "consumer" model of human action is
somewhat limited (to say the least!). Instead we need to recognise the
importance of the "citizen" model, which we should point out includes the
"consumer" model within it. Taking part as an active member of the community
does not imply that we stop making individual consumption choices between
those available, all it does is potentially enrich our available options by
removing lousy choices (such as ecology or profit, cheap goods or labour
rights, family or career).

In addition we must stress its role in developing those who practice the
"citizen" model and how it can enrich our social and personal life. Being
active within participatory institutions fosters and develops an active,
"public-spirited" type of character. Citizens, because they are making
**collective** decisions have to weight other interests **as well as** their
own and so consider the impact on themselves, others, society and the
environment of possible decisions. It is, by its very nature, an educative
process by which all benefit by developing their critical abilities and
expanding their definition of self-interest to take into account themselves as
part of a society and eco-system **as well as** as an individual. The
"consumer" model, with its passive and exclusively private/money orientation
develops few of people's faculties and narrows their self-interest to such a
degree that their "rational" actions can actually (indirectly) harm them.

As Noam Chomsky argues, it is _"now widely realised that the economists
'externalities' can no longer be consigned to footnotes. No one who gives a
moment's thought to the problems of contemporary society can fail to be aware
of the social costs of consumption and production, the progressive destruction
of the environment, the utter irrationality of the utilisation of contemporary
technology, the inability of a system based on profit or growth maximisation
to deal with needs that can only be expressed collectively, and the enormous
bias this system imposes towards maximisation of commodities for personal use
in place of the general improvement of the quality of life."_ [**Radical
Priorities**, pp. 190-1]

The "citizen" model takes on board the fact that the sum of rational
individual decisions may not yield a rational collective outcome (which, we
must add, harms the individuals involved and so works against their self-
interest). Social standards, created and enriched by a process of discussion
and dialogue can be effective in realms where the atomised "consumer" model is
essentially powerless to achieve constructive social change, never mind
protect the individual from "agreeing" to "decisions of desperation" that
leave them and society as a whole worse off (see also sections
[E.3](secE3.md) and [E.5](secE5.md)).

This is **not** to suggest that anarchists desire to eliminate individual
decision making, far from it. An anarchist society will be based upon
individuals making decisions on what they want to consume, where they want to
work, what kind of work they want to do and so on. So the aim of the "citizen"
model is not to "replace" the "consumer" model, but only to improve the social
environment within which we make our individual consumption decisions. What
the "citizen" model of human action desires is to place such decisions within
a social framework, one that allows each individual to take an active part in
improving the quality of life for us all by removing "Hobson choices" as far
as possible.

[‹ B.4 How does capitalism affect liberty?](secB4.md "Go to previous page" )
[up](secBcon.md "Go to parent page" ) [B.6 But won't decisions made by
individuals with their own money be the best? ›](secB6.md "Go to next page"
)

