       SUBROUTINE SST03I(WIN,WOUT,NSIZIN,NSIZOT,ISCR,SPTYPE)
C
C THIS ROUTINE ANTISYMMETRIZES THE RING INCREMENT LIST FOR AA AND BB
C   SPIN CASES. 
C
C THE INCREMENT LIST (A,J;B,I) IS PRESUMED TO BE PACKED AJ-BI.  THIS 
C   ROUTINE RETURNS THE ANTISYMMETRIZED INCREMENT LIST AS (A<B;I<J) PACKED
C   AS AB-IJ.  THIS ROUTINE FUNCTIONS AS THE INVERSE OF ROUTINE SST
C   THE LIST AS (A<B;I<J) PACKED AS AB-IJ.  
C
C *** IMPORTANT *** : THE SPACE ALLOCATED FOR BOTH WIN AND WOUT IN THE
C                     CALLING ROUTINE MUST BE EQUAL TO THE SIZE OF
C                     *WIN*
C
C INPUT: 
C           WIN  - THE SYMMETRY PACKED AB-IJ LIST.
C         NSIZIN - THE TOTAL SIZE OF THE SYM. PACKED INPUT VECTOR.
C         NSIZOT - THE TOTAL SIZE OF THE SYM. PACKED OUTPUT VECTOR.
C         SPTYPE - THE SPIN TYPE FOR THE INPUT LIST
C
C                        'AAAA' FOR (AJ-BI)
C                        'BBBB' FOR (aj-bi)
C
C OUTPUT: 
C          WOUT  - THE SYMMETRY PACKED A<B-I<J OR a<b-i<j LIST.
C       
C SCRATCH:
C         ISCR   - SCRATCH AREA TO HOLD THE SYMMETRY VECTORS AND INVERSE
C                   SYMMETRY VECTORS WHICH ARE NEEDED. 
C                   (SIZE: NVRT*(NVRT-1)/2+NOCC*(NOCC-1)/2+NOCC*NVRT)
C         
CEND
      IMPLICIT INTEGER (A-Z)
      CHARACTER*4 REORTP,SPTYPE,RERDTP
      DOUBLE PRECISION WIN(NSIZIN),WOUT(NSIZOT),ISCR(*)
      COMMON/MACHSP/IINTLN,IFLTLN,IINTFP,IALONE,IBITWD
      COMMON/SYMINF/NSTART,NIRREP,IRREP0(255,2),DIRPRD(8,8)
      COMMON/SYMPOP/IRPDPD(8,22),ISYTYP(2,500),ID(18)
      COMMON/SYM/POP(8,2),VRT(8,2),NT(2),NFMI(2),NFEA(2)
C
      IRREPX=1
C
      IF(SPTYPE.EQ.'AAAA')THEN
       ISPIN=1
      ELSEIF(SPTYPE.EQ.'BBBB')THEN
       ISPIN=2
      ELSE
       WRITE(6,1000)SPTYPE
1000   FORMAT(T3,'@SST03I-F, Unknown spin type ',A4,' passed in.')
       CALL ERREX
      ENDIF
C
      CALL SSTGEN(WIN,WOUT,NSIZIN,VRT(1,ISPIN),POP(1,ISPIN),
     &            VRT(1,ISPIN),POP(1,ISPIN),ISCR,IRREPX,'1324')
C
C ANTISYMMETRIZE AND COMPRESS TO A<B,I<J
C
      IOFFT=1
      IOFFF=1
      DO 10 IRREPR=1,NIRREP
       IRREPL=DIRPRD(IRREPR,IRREPX)
       DISSZT=IRPDPD(IRREPL,ISPIN)
       NUMDST=IRPDPD(IRREPR,2+ISPIN)
       DISSZF=IRPDPD(IRREPL,18+ISPIN)
       NUMDSF=IRPDPD(IRREPR,20+ISPIN)
       CALL ASSYM2(IRREPR,POP(1,ISPIN),DISSZF,WOUT(IOFFF))
       CALL TRANSP(WOUT(IOFFF),WIN,NUMDST,DISSZF)
       CALL ASSYM2(IRREPL,VRT(1,ISPIN),NUMDST,WIN)
       CALL TRANSP(WIN,WOUT(IOFFT),DISSZT,NUMDST)
       IOFFF=IOFFF+NUMDSF*DISSZF
       IOFFT=IOFFT+NUMDST*DISSZT
10    CONTINUE
C
      RETURN
      END
