#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2020 HS-157
set -o errexit

###
# Breach & Clear series:
# - Breach & Clear
# - Breach & Clear: Deadline
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251019.1

PLAYIT_COMPATIILITY_LEVEL='2.33'

GAME_ID_ORIGINAL='breach-and-clear-1'
GAME_NAME_ORIGINAL='Breach & Clear'

GAME_ID_DEADLINE='breach-and-clear-2'
GAME_NAME_DEADLINE='Breach & Clear: Deadline'

## Breach & Clear

ARCHIVE_BASE_ORIGINAL_HUMBLE_0_NAME='BncNix_12_4_15_NODRM.rar'
ARCHIVE_BASE_ORIGINAL_HUMBLE_0_MD5='a2eff200bdce1b96852d2b709614d17a'
ARCHIVE_BASE_ORIGINAL_HUMBLE_0_SIZE='2500000'
ARCHIVE_BASE_ORIGINAL_HUMBLE_0_VERSION='2.1.1-humble1'
ARCHIVE_BASE_ORIGINAL_HUMBLE_0_URL='https://www.humblebundle.com/store/breach-clear'

## This archive is no longer available for sale from gog.com, starting on 2024-09-13
## cf. https://www.gog.com/forum/general/delisting_breach_clear_will_be_removed_from_the_store_on_september_13th/post1
ARCHIVE_BASE_ORIGINAL_GOG_0_NAME='gog_breach_clear_2.0.0.3.sh'
ARCHIVE_BASE_ORIGINAL_GOG_0_MD5='e7f6b59d8ce97c9ab850b47608941b7d'
ARCHIVE_BASE_ORIGINAL_GOG_0_TYPE='mojosetup'
ARCHIVE_BASE_ORIGINAL_GOG_0_SIZE='2500000'
ARCHIVE_BASE_ORIGINAL_GOG_0_VERSION='2.1.1-gog2.0.0.3'

## Breach & Clear: Deadline

ARCHIVE_BASE_DEADLINE_0_NAME='gog_breach_and_clear_deadline_2.3.0.8.sh'
ARCHIVE_BASE_DEADLINE_0_MD5='fcf5e77ea47ec4446bd67168372f6e34'
ARCHIVE_BASE_DEADLINE_0_TYPE='mojosetup'
ARCHIVE_BASE_DEADLINE_0_SIZE='3300000'
ARCHIVE_BASE_DEADLINE_0_VERSION='1.05-gog2.3.0.8'
ARCHIVE_BASE_DEADLINE_0_URL='https://www.gog.com/game/breach_clear_deadline'

UNITY3D_NAME_ORIGINAL_HUMBLE='Bnc'
UNITY3D_NAME_ORIGINAL_GOG='Bnc_Nix'
UNITY3D_NAME_DEADLINE='DEADline'
UNITY3D_PLUGINS='
ScreenSelector.so'

CONTENT_PATH_DEFAULT_ORIGINAL_HUMBLE='BncHumboNix'
CONTENT_PATH_DEFAULT_ORIGINAL_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_DEADLINE='data/noarch/game'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libGL.so.1
libGLU.so.1
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXcursor.so.1'
## Easier upgrades from pre-20251019.1 packages
PKG_BIN_PROVIDES_ORIGINAL='
breach-and-clear'
PKG_BIN_PROVIDES_DEADLINE='
breach-and-clear-deadline'

PKG_DATA_ID_ORIGINAL="${GAME_ID_ORIGINAL}-data"
PKG_DATA_ID_DEADLINE="${GAME_ID_DEADLINE}-data"
PKG_DATA_DESCRIPTION='data'
## Easier upgrades from pre-20251019.1 packages
PKG_DATA_PROVIDES_ORIGINAL='
breach-and-clear-data'
PKG_DATA_PROVIDES_DEADLINE='
breach-and-clear-deadline-data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
