// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gdk;
use glib;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectExt;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::GString;
use glib::StaticType;
use glib::ToValue;
use glib::Value;
use glib_sys;
use gobject_sys;
use gtk_sys;
use libc;
use pango;
#[cfg(any(feature = "v3_16", feature = "dox"))]
use signal::Inhibit;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;
use Align;
use Buildable;
use Container;
use DeleteType;
use InputHints;
use InputPurpose;
use Justification;
use MovementStep;
use ResizeMode;
use ScrollStep;
use Scrollable;
use TextAttributes;
use TextBuffer;
use TextChildAnchor;
#[cfg(any(feature = "v3_16", feature = "dox"))]
use TextExtendSelection;
use TextIter;
use TextMark;
use TextWindowType;
use Widget;
use WrapMode;

glib_wrapper! {
    pub struct TextView(Object<gtk_sys::GtkTextView, gtk_sys::GtkTextViewClass, TextViewClass>) @extends Container, Widget, @implements Buildable, Scrollable;

    match fn {
        get_type => || gtk_sys::gtk_text_view_get_type(),
    }
}

impl TextView {
    pub fn new() -> TextView {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(gtk_sys::gtk_text_view_new()).unsafe_cast() }
    }

    pub fn new_with_buffer<P: IsA<TextBuffer>>(buffer: &P) -> TextView {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(gtk_sys::gtk_text_view_new_with_buffer(
                buffer.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }
}

impl Default for TextView {
    fn default() -> Self {
        Self::new()
    }
}

pub struct TextViewBuilder {
    accepts_tab: Option<bool>,
    #[cfg(any(feature = "v3_18", feature = "dox"))]
    bottom_margin: Option<i32>,
    buffer: Option<TextBuffer>,
    cursor_visible: Option<bool>,
    editable: Option<bool>,
    im_module: Option<String>,
    indent: Option<i32>,
    input_hints: Option<InputHints>,
    input_purpose: Option<InputPurpose>,
    justification: Option<Justification>,
    left_margin: Option<i32>,
    monospace: Option<bool>,
    overwrite: Option<bool>,
    pixels_above_lines: Option<i32>,
    pixels_below_lines: Option<i32>,
    pixels_inside_wrap: Option<i32>,
    populate_all: Option<bool>,
    right_margin: Option<i32>,
    tabs: Option<pango::TabArray>,
    #[cfg(any(feature = "v3_18", feature = "dox"))]
    top_margin: Option<i32>,
    wrap_mode: Option<WrapMode>,
    border_width: Option<u32>,
    child: Option<Widget>,
    resize_mode: Option<ResizeMode>,
    app_paintable: Option<bool>,
    can_default: Option<bool>,
    can_focus: Option<bool>,
    events: Option<gdk::EventMask>,
    expand: Option<bool>,
    #[cfg(any(feature = "v3_20", feature = "dox"))]
    focus_on_click: Option<bool>,
    halign: Option<Align>,
    has_default: Option<bool>,
    has_focus: Option<bool>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    is_focus: Option<bool>,
    margin: Option<i32>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    no_show_all: Option<bool>,
    opacity: Option<f64>,
    parent: Option<Container>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    //style: /*Unknown type*/,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
}

impl TextViewBuilder {
    pub fn new() -> Self {
        Self {
            accepts_tab: None,
            #[cfg(any(feature = "v3_18", feature = "dox"))]
            bottom_margin: None,
            buffer: None,
            cursor_visible: None,
            editable: None,
            im_module: None,
            indent: None,
            input_hints: None,
            input_purpose: None,
            justification: None,
            left_margin: None,
            monospace: None,
            overwrite: None,
            pixels_above_lines: None,
            pixels_below_lines: None,
            pixels_inside_wrap: None,
            populate_all: None,
            right_margin: None,
            tabs: None,
            #[cfg(any(feature = "v3_18", feature = "dox"))]
            top_margin: None,
            wrap_mode: None,
            border_width: None,
            child: None,
            resize_mode: None,
            app_paintable: None,
            can_default: None,
            can_focus: None,
            events: None,
            expand: None,
            #[cfg(any(feature = "v3_20", feature = "dox"))]
            focus_on_click: None,
            halign: None,
            has_default: None,
            has_focus: None,
            has_tooltip: None,
            height_request: None,
            hexpand: None,
            hexpand_set: None,
            is_focus: None,
            margin: None,
            margin_bottom: None,
            margin_end: None,
            margin_start: None,
            margin_top: None,
            name: None,
            no_show_all: None,
            opacity: None,
            parent: None,
            receives_default: None,
            sensitive: None,
            tooltip_markup: None,
            tooltip_text: None,
            valign: None,
            vexpand: None,
            vexpand_set: None,
            visible: None,
            width_request: None,
        }
    }

    pub fn build(self) -> TextView {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref accepts_tab) = self.accepts_tab {
            properties.push(("accepts-tab", accepts_tab));
        }
        #[cfg(any(feature = "v3_18", feature = "dox"))]
        {
            if let Some(ref bottom_margin) = self.bottom_margin {
                properties.push(("bottom-margin", bottom_margin));
            }
        }
        if let Some(ref buffer) = self.buffer {
            properties.push(("buffer", buffer));
        }
        if let Some(ref cursor_visible) = self.cursor_visible {
            properties.push(("cursor-visible", cursor_visible));
        }
        if let Some(ref editable) = self.editable {
            properties.push(("editable", editable));
        }
        if let Some(ref im_module) = self.im_module {
            properties.push(("im-module", im_module));
        }
        if let Some(ref indent) = self.indent {
            properties.push(("indent", indent));
        }
        if let Some(ref input_hints) = self.input_hints {
            properties.push(("input-hints", input_hints));
        }
        if let Some(ref input_purpose) = self.input_purpose {
            properties.push(("input-purpose", input_purpose));
        }
        if let Some(ref justification) = self.justification {
            properties.push(("justification", justification));
        }
        if let Some(ref left_margin) = self.left_margin {
            properties.push(("left-margin", left_margin));
        }
        if let Some(ref monospace) = self.monospace {
            properties.push(("monospace", monospace));
        }
        if let Some(ref overwrite) = self.overwrite {
            properties.push(("overwrite", overwrite));
        }
        if let Some(ref pixels_above_lines) = self.pixels_above_lines {
            properties.push(("pixels-above-lines", pixels_above_lines));
        }
        if let Some(ref pixels_below_lines) = self.pixels_below_lines {
            properties.push(("pixels-below-lines", pixels_below_lines));
        }
        if let Some(ref pixels_inside_wrap) = self.pixels_inside_wrap {
            properties.push(("pixels-inside-wrap", pixels_inside_wrap));
        }
        if let Some(ref populate_all) = self.populate_all {
            properties.push(("populate-all", populate_all));
        }
        if let Some(ref right_margin) = self.right_margin {
            properties.push(("right-margin", right_margin));
        }
        if let Some(ref tabs) = self.tabs {
            properties.push(("tabs", tabs));
        }
        #[cfg(any(feature = "v3_18", feature = "dox"))]
        {
            if let Some(ref top_margin) = self.top_margin {
                properties.push(("top-margin", top_margin));
            }
        }
        if let Some(ref wrap_mode) = self.wrap_mode {
            properties.push(("wrap-mode", wrap_mode));
        }
        if let Some(ref border_width) = self.border_width {
            properties.push(("border-width", border_width));
        }
        if let Some(ref child) = self.child {
            properties.push(("child", child));
        }
        if let Some(ref resize_mode) = self.resize_mode {
            properties.push(("resize-mode", resize_mode));
        }
        if let Some(ref app_paintable) = self.app_paintable {
            properties.push(("app-paintable", app_paintable));
        }
        if let Some(ref can_default) = self.can_default {
            properties.push(("can-default", can_default));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref events) = self.events {
            properties.push(("events", events));
        }
        if let Some(ref expand) = self.expand {
            properties.push(("expand", expand));
        }
        #[cfg(any(feature = "v3_20", feature = "dox"))]
        {
            if let Some(ref focus_on_click) = self.focus_on_click {
                properties.push(("focus-on-click", focus_on_click));
            }
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_default) = self.has_default {
            properties.push(("has-default", has_default));
        }
        if let Some(ref has_focus) = self.has_focus {
            properties.push(("has-focus", has_focus));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref is_focus) = self.is_focus {
            properties.push(("is-focus", is_focus));
        }
        if let Some(ref margin) = self.margin {
            properties.push(("margin", margin));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref no_show_all) = self.no_show_all {
            properties.push(("no-show-all", no_show_all));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref parent) = self.parent {
            properties.push(("parent", parent));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        glib::Object::new(TextView::static_type(), &properties)
            .expect("object new")
            .downcast()
            .expect("downcast")
    }

    pub fn accepts_tab(mut self, accepts_tab: bool) -> Self {
        self.accepts_tab = Some(accepts_tab);
        self
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    pub fn bottom_margin(mut self, bottom_margin: i32) -> Self {
        self.bottom_margin = Some(bottom_margin);
        self
    }

    pub fn buffer(mut self, buffer: &TextBuffer) -> Self {
        self.buffer = Some(buffer.clone());
        self
    }

    pub fn cursor_visible(mut self, cursor_visible: bool) -> Self {
        self.cursor_visible = Some(cursor_visible);
        self
    }

    pub fn editable(mut self, editable: bool) -> Self {
        self.editable = Some(editable);
        self
    }

    pub fn im_module(mut self, im_module: &str) -> Self {
        self.im_module = Some(im_module.to_string());
        self
    }

    pub fn indent(mut self, indent: i32) -> Self {
        self.indent = Some(indent);
        self
    }

    pub fn input_hints(mut self, input_hints: InputHints) -> Self {
        self.input_hints = Some(input_hints);
        self
    }

    pub fn input_purpose(mut self, input_purpose: InputPurpose) -> Self {
        self.input_purpose = Some(input_purpose);
        self
    }

    pub fn justification(mut self, justification: Justification) -> Self {
        self.justification = Some(justification);
        self
    }

    pub fn left_margin(mut self, left_margin: i32) -> Self {
        self.left_margin = Some(left_margin);
        self
    }

    pub fn monospace(mut self, monospace: bool) -> Self {
        self.monospace = Some(monospace);
        self
    }

    pub fn overwrite(mut self, overwrite: bool) -> Self {
        self.overwrite = Some(overwrite);
        self
    }

    pub fn pixels_above_lines(mut self, pixels_above_lines: i32) -> Self {
        self.pixels_above_lines = Some(pixels_above_lines);
        self
    }

    pub fn pixels_below_lines(mut self, pixels_below_lines: i32) -> Self {
        self.pixels_below_lines = Some(pixels_below_lines);
        self
    }

    pub fn pixels_inside_wrap(mut self, pixels_inside_wrap: i32) -> Self {
        self.pixels_inside_wrap = Some(pixels_inside_wrap);
        self
    }

    pub fn populate_all(mut self, populate_all: bool) -> Self {
        self.populate_all = Some(populate_all);
        self
    }

    pub fn right_margin(mut self, right_margin: i32) -> Self {
        self.right_margin = Some(right_margin);
        self
    }

    pub fn tabs(mut self, tabs: &pango::TabArray) -> Self {
        self.tabs = Some(tabs.clone());
        self
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    pub fn top_margin(mut self, top_margin: i32) -> Self {
        self.top_margin = Some(top_margin);
        self
    }

    pub fn wrap_mode(mut self, wrap_mode: WrapMode) -> Self {
        self.wrap_mode = Some(wrap_mode);
        self
    }

    pub fn border_width(mut self, border_width: u32) -> Self {
        self.border_width = Some(border_width);
        self
    }

    pub fn child(mut self, child: &Widget) -> Self {
        self.child = Some(child.clone());
        self
    }

    pub fn resize_mode(mut self, resize_mode: ResizeMode) -> Self {
        self.resize_mode = Some(resize_mode);
        self
    }

    pub fn app_paintable(mut self, app_paintable: bool) -> Self {
        self.app_paintable = Some(app_paintable);
        self
    }

    pub fn can_default(mut self, can_default: bool) -> Self {
        self.can_default = Some(can_default);
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn events(mut self, events: gdk::EventMask) -> Self {
        self.events = Some(events);
        self
    }

    pub fn expand(mut self, expand: bool) -> Self {
        self.expand = Some(expand);
        self
    }

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn halign(mut self, halign: Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_default(mut self, has_default: bool) -> Self {
        self.has_default = Some(has_default);
        self
    }

    pub fn has_focus(mut self, has_focus: bool) -> Self {
        self.has_focus = Some(has_focus);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn is_focus(mut self, is_focus: bool) -> Self {
        self.is_focus = Some(is_focus);
        self
    }

    pub fn margin(mut self, margin: i32) -> Self {
        self.margin = Some(margin);
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn no_show_all(mut self, no_show_all: bool) -> Self {
        self.no_show_all = Some(no_show_all);
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn parent(mut self, parent: &Container) -> Self {
        self.parent = Some(parent.clone());
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }
}

pub const NONE_TEXT_VIEW: Option<&TextView> = None;

pub trait TextViewExt: 'static {
    fn add_child_at_anchor<P: IsA<Widget>, Q: IsA<TextChildAnchor>>(&self, child: &P, anchor: &Q);

    fn add_child_in_window<P: IsA<Widget>>(
        &self,
        child: &P,
        which_window: TextWindowType,
        xpos: i32,
        ypos: i32,
    );

    fn backward_display_line(&self, iter: &mut TextIter) -> bool;

    fn backward_display_line_start(&self, iter: &mut TextIter) -> bool;

    fn buffer_to_window_coords(
        &self,
        win: TextWindowType,
        buffer_x: i32,
        buffer_y: i32,
    ) -> (i32, i32);

    fn forward_display_line(&self, iter: &mut TextIter) -> bool;

    fn forward_display_line_end(&self, iter: &mut TextIter) -> bool;

    fn get_accepts_tab(&self) -> bool;

    fn get_border_window_size(&self, type_: TextWindowType) -> i32;

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn get_bottom_margin(&self) -> i32;

    fn get_buffer(&self) -> Option<TextBuffer>;

    fn get_cursor_locations(&self, iter: Option<&TextIter>) -> (gdk::Rectangle, gdk::Rectangle);

    fn get_cursor_visible(&self) -> bool;

    fn get_default_attributes(&self) -> TextAttributes;

    fn get_editable(&self) -> bool;

    fn get_indent(&self) -> i32;

    fn get_input_hints(&self) -> InputHints;

    fn get_input_purpose(&self) -> InputPurpose;

    fn get_iter_at_location(&self, x: i32, y: i32) -> Option<TextIter>;

    fn get_iter_at_position(&self, x: i32, y: i32) -> Option<(TextIter, i32)>;

    fn get_iter_location(&self, iter: &TextIter) -> gdk::Rectangle;

    fn get_justification(&self) -> Justification;

    fn get_left_margin(&self) -> i32;

    fn get_line_at_y(&self, y: i32) -> (TextIter, i32);

    fn get_line_yrange(&self, iter: &TextIter) -> (i32, i32);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_monospace(&self) -> bool;

    fn get_overwrite(&self) -> bool;

    fn get_pixels_above_lines(&self) -> i32;

    fn get_pixels_below_lines(&self) -> i32;

    fn get_pixels_inside_wrap(&self) -> i32;

    fn get_right_margin(&self) -> i32;

    fn get_tabs(&self) -> Option<pango::TabArray>;

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn get_top_margin(&self) -> i32;

    fn get_visible_rect(&self) -> gdk::Rectangle;

    fn get_window(&self, win: TextWindowType) -> Option<gdk::Window>;

    fn get_window_type<P: IsA<gdk::Window>>(&self, window: &P) -> TextWindowType;

    fn get_wrap_mode(&self) -> WrapMode;

    fn im_context_filter_keypress(&self, event: &gdk::EventKey) -> bool;

    fn move_child<P: IsA<Widget>>(&self, child: &P, xpos: i32, ypos: i32);

    fn move_mark_onscreen<P: IsA<TextMark>>(&self, mark: &P) -> bool;

    fn move_visually(&self, iter: &mut TextIter, count: i32) -> bool;

    fn place_cursor_onscreen(&self) -> bool;

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn reset_cursor_blink(&self);

    fn reset_im_context(&self);

    fn scroll_mark_onscreen<P: IsA<TextMark>>(&self, mark: &P);

    fn scroll_to_iter(
        &self,
        iter: &mut TextIter,
        within_margin: f64,
        use_align: bool,
        xalign: f64,
        yalign: f64,
    ) -> bool;

    fn scroll_to_mark<P: IsA<TextMark>>(
        &self,
        mark: &P,
        within_margin: f64,
        use_align: bool,
        xalign: f64,
        yalign: f64,
    );

    fn set_accepts_tab(&self, accepts_tab: bool);

    fn set_border_window_size(&self, type_: TextWindowType, size: i32);

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn set_bottom_margin(&self, bottom_margin: i32);

    fn set_buffer<P: IsA<TextBuffer>>(&self, buffer: Option<&P>);

    fn set_cursor_visible(&self, setting: bool);

    fn set_editable(&self, setting: bool);

    fn set_indent(&self, indent: i32);

    fn set_input_hints(&self, hints: InputHints);

    fn set_input_purpose(&self, purpose: InputPurpose);

    fn set_justification(&self, justification: Justification);

    fn set_left_margin(&self, left_margin: i32);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_monospace(&self, monospace: bool);

    fn set_overwrite(&self, overwrite: bool);

    fn set_pixels_above_lines(&self, pixels_above_lines: i32);

    fn set_pixels_below_lines(&self, pixels_below_lines: i32);

    fn set_pixels_inside_wrap(&self, pixels_inside_wrap: i32);

    fn set_right_margin(&self, right_margin: i32);

    fn set_tabs(&self, tabs: &pango::TabArray);

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn set_top_margin(&self, top_margin: i32);

    fn set_wrap_mode(&self, wrap_mode: WrapMode);

    fn starts_display_line(&self, iter: &TextIter) -> bool;

    fn window_to_buffer_coords(
        &self,
        win: TextWindowType,
        window_x: i32,
        window_y: i32,
    ) -> (i32, i32);

    fn get_property_im_module(&self) -> Option<GString>;

    fn set_property_im_module(&self, im_module: Option<&str>);

    fn get_property_monospace(&self) -> bool;

    fn set_property_monospace(&self, monospace: bool);

    fn get_property_populate_all(&self) -> bool;

    fn set_property_populate_all(&self, populate_all: bool);

    fn connect_backspace<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_backspace(&self);

    fn connect_copy_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_copy_clipboard(&self);

    fn connect_cut_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_cut_clipboard(&self);

    fn connect_delete_from_cursor<F: Fn(&Self, DeleteType, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_delete_from_cursor(&self, type_: DeleteType, count: i32);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_extend_selection<
        F: Fn(&Self, TextExtendSelection, &TextIter, &TextIter, &TextIter) -> Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_insert_at_cursor<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_insert_at_cursor(&self, string: &str);

    #[cfg(any(feature = "v3_22_26", feature = "dox"))]
    fn connect_insert_emoji<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_22_26", feature = "dox"))]
    fn emit_insert_emoji(&self);

    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32, bool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_move_cursor(&self, step: MovementStep, count: i32, extend_selection: bool);

    fn connect_move_viewport<F: Fn(&Self, ScrollStep, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_move_viewport(&self, step: ScrollStep, count: i32);

    fn connect_paste_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_paste_clipboard(&self);

    fn connect_populate_popup<F: Fn(&Self, &Widget) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_preedit_changed<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_preedit_changed(&self, preedit: &str);

    fn connect_select_all<F: Fn(&Self, bool) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_select_all(&self, select: bool);

    fn connect_set_anchor<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_set_anchor(&self);

    fn connect_toggle_cursor_visible<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_toggle_cursor_visible(&self);

    fn connect_toggle_overwrite<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_toggle_overwrite(&self);

    fn connect_property_accepts_tab_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn connect_property_bottom_margin_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_buffer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_cursor_visible_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_im_module_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_indent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_input_hints_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_input_purpose_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_justification_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_left_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_monospace_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_overwrite_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_pixels_above_lines_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_pixels_below_lines_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_pixels_inside_wrap_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_populate_all_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    fn connect_property_right_margin_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    fn connect_property_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn connect_property_top_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<TextView>> TextViewExt for O {
    fn add_child_at_anchor<P: IsA<Widget>, Q: IsA<TextChildAnchor>>(&self, child: &P, anchor: &Q) {
        unsafe {
            gtk_sys::gtk_text_view_add_child_at_anchor(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                anchor.as_ref().to_glib_none().0,
            );
        }
    }

    fn add_child_in_window<P: IsA<Widget>>(
        &self,
        child: &P,
        which_window: TextWindowType,
        xpos: i32,
        ypos: i32,
    ) {
        unsafe {
            gtk_sys::gtk_text_view_add_child_in_window(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                which_window.to_glib(),
                xpos,
                ypos,
            );
        }
    }

    fn backward_display_line(&self, iter: &mut TextIter) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_backward_display_line(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            ))
        }
    }

    fn backward_display_line_start(&self, iter: &mut TextIter) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_backward_display_line_start(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            ))
        }
    }

    fn buffer_to_window_coords(
        &self,
        win: TextWindowType,
        buffer_x: i32,
        buffer_y: i32,
    ) -> (i32, i32) {
        unsafe {
            let mut window_x = mem::uninitialized();
            let mut window_y = mem::uninitialized();
            gtk_sys::gtk_text_view_buffer_to_window_coords(
                self.as_ref().to_glib_none().0,
                win.to_glib(),
                buffer_x,
                buffer_y,
                &mut window_x,
                &mut window_y,
            );
            (window_x, window_y)
        }
    }

    fn forward_display_line(&self, iter: &mut TextIter) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_forward_display_line(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            ))
        }
    }

    fn forward_display_line_end(&self, iter: &mut TextIter) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_forward_display_line_end(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            ))
        }
    }

    fn get_accepts_tab(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_get_accepts_tab(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_border_window_size(&self, type_: TextWindowType) -> i32 {
        unsafe {
            gtk_sys::gtk_text_view_get_border_window_size(
                self.as_ref().to_glib_none().0,
                type_.to_glib(),
            )
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn get_bottom_margin(&self) -> i32 {
        unsafe { gtk_sys::gtk_text_view_get_bottom_margin(self.as_ref().to_glib_none().0) }
    }

    fn get_buffer(&self) -> Option<TextBuffer> {
        unsafe {
            from_glib_none(gtk_sys::gtk_text_view_get_buffer(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_cursor_locations(&self, iter: Option<&TextIter>) -> (gdk::Rectangle, gdk::Rectangle) {
        unsafe {
            let mut strong = gdk::Rectangle::uninitialized();
            let mut weak = gdk::Rectangle::uninitialized();
            gtk_sys::gtk_text_view_get_cursor_locations(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none().0,
                strong.to_glib_none_mut().0,
                weak.to_glib_none_mut().0,
            );
            (strong, weak)
        }
    }

    fn get_cursor_visible(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_get_cursor_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_default_attributes(&self) -> TextAttributes {
        unsafe {
            from_glib_full(gtk_sys::gtk_text_view_get_default_attributes(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_editable(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_get_editable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_indent(&self) -> i32 {
        unsafe { gtk_sys::gtk_text_view_get_indent(self.as_ref().to_glib_none().0) }
    }

    fn get_input_hints(&self) -> InputHints {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_get_input_hints(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_input_purpose(&self) -> InputPurpose {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_get_input_purpose(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_iter_at_location(&self, x: i32, y: i32) -> Option<TextIter> {
        unsafe {
            let mut iter = TextIter::uninitialized();
            let ret = from_glib(gtk_sys::gtk_text_view_get_iter_at_location(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                x,
                y,
            ));
            if ret {
                Some(iter)
            } else {
                None
            }
        }
    }

    fn get_iter_at_position(&self, x: i32, y: i32) -> Option<(TextIter, i32)> {
        unsafe {
            let mut iter = TextIter::uninitialized();
            let mut trailing = mem::uninitialized();
            let ret = from_glib(gtk_sys::gtk_text_view_get_iter_at_position(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                &mut trailing,
                x,
                y,
            ));
            if ret {
                Some((iter, trailing))
            } else {
                None
            }
        }
    }

    fn get_iter_location(&self, iter: &TextIter) -> gdk::Rectangle {
        unsafe {
            let mut location = gdk::Rectangle::uninitialized();
            gtk_sys::gtk_text_view_get_iter_location(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none().0,
                location.to_glib_none_mut().0,
            );
            location
        }
    }

    fn get_justification(&self) -> Justification {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_get_justification(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_left_margin(&self) -> i32 {
        unsafe { gtk_sys::gtk_text_view_get_left_margin(self.as_ref().to_glib_none().0) }
    }

    fn get_line_at_y(&self, y: i32) -> (TextIter, i32) {
        unsafe {
            let mut target_iter = TextIter::uninitialized();
            let mut line_top = mem::uninitialized();
            gtk_sys::gtk_text_view_get_line_at_y(
                self.as_ref().to_glib_none().0,
                target_iter.to_glib_none_mut().0,
                y,
                &mut line_top,
            );
            (target_iter, line_top)
        }
    }

    fn get_line_yrange(&self, iter: &TextIter) -> (i32, i32) {
        unsafe {
            let mut y = mem::uninitialized();
            let mut height = mem::uninitialized();
            gtk_sys::gtk_text_view_get_line_yrange(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none().0,
                &mut y,
                &mut height,
            );
            (y, height)
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_monospace(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_get_monospace(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_overwrite(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_get_overwrite(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_pixels_above_lines(&self) -> i32 {
        unsafe { gtk_sys::gtk_text_view_get_pixels_above_lines(self.as_ref().to_glib_none().0) }
    }

    fn get_pixels_below_lines(&self) -> i32 {
        unsafe { gtk_sys::gtk_text_view_get_pixels_below_lines(self.as_ref().to_glib_none().0) }
    }

    fn get_pixels_inside_wrap(&self) -> i32 {
        unsafe { gtk_sys::gtk_text_view_get_pixels_inside_wrap(self.as_ref().to_glib_none().0) }
    }

    fn get_right_margin(&self) -> i32 {
        unsafe { gtk_sys::gtk_text_view_get_right_margin(self.as_ref().to_glib_none().0) }
    }

    fn get_tabs(&self) -> Option<pango::TabArray> {
        unsafe {
            from_glib_full(gtk_sys::gtk_text_view_get_tabs(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn get_top_margin(&self) -> i32 {
        unsafe { gtk_sys::gtk_text_view_get_top_margin(self.as_ref().to_glib_none().0) }
    }

    fn get_visible_rect(&self) -> gdk::Rectangle {
        unsafe {
            let mut visible_rect = gdk::Rectangle::uninitialized();
            gtk_sys::gtk_text_view_get_visible_rect(
                self.as_ref().to_glib_none().0,
                visible_rect.to_glib_none_mut().0,
            );
            visible_rect
        }
    }

    fn get_window(&self, win: TextWindowType) -> Option<gdk::Window> {
        unsafe {
            from_glib_none(gtk_sys::gtk_text_view_get_window(
                self.as_ref().to_glib_none().0,
                win.to_glib(),
            ))
        }
    }

    fn get_window_type<P: IsA<gdk::Window>>(&self, window: &P) -> TextWindowType {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_get_window_type(
                self.as_ref().to_glib_none().0,
                window.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_wrap_mode(&self) -> WrapMode {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_get_wrap_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn im_context_filter_keypress(&self, event: &gdk::EventKey) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_im_context_filter_keypress(
                self.as_ref().to_glib_none().0,
                mut_override(event.to_glib_none().0),
            ))
        }
    }

    fn move_child<P: IsA<Widget>>(&self, child: &P, xpos: i32, ypos: i32) {
        unsafe {
            gtk_sys::gtk_text_view_move_child(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                xpos,
                ypos,
            );
        }
    }

    fn move_mark_onscreen<P: IsA<TextMark>>(&self, mark: &P) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_move_mark_onscreen(
                self.as_ref().to_glib_none().0,
                mark.as_ref().to_glib_none().0,
            ))
        }
    }

    fn move_visually(&self, iter: &mut TextIter, count: i32) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_move_visually(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                count,
            ))
        }
    }

    fn place_cursor_onscreen(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_place_cursor_onscreen(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn reset_cursor_blink(&self) {
        unsafe {
            gtk_sys::gtk_text_view_reset_cursor_blink(self.as_ref().to_glib_none().0);
        }
    }

    fn reset_im_context(&self) {
        unsafe {
            gtk_sys::gtk_text_view_reset_im_context(self.as_ref().to_glib_none().0);
        }
    }

    fn scroll_mark_onscreen<P: IsA<TextMark>>(&self, mark: &P) {
        unsafe {
            gtk_sys::gtk_text_view_scroll_mark_onscreen(
                self.as_ref().to_glib_none().0,
                mark.as_ref().to_glib_none().0,
            );
        }
    }

    fn scroll_to_iter(
        &self,
        iter: &mut TextIter,
        within_margin: f64,
        use_align: bool,
        xalign: f64,
        yalign: f64,
    ) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_scroll_to_iter(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                within_margin,
                use_align.to_glib(),
                xalign,
                yalign,
            ))
        }
    }

    fn scroll_to_mark<P: IsA<TextMark>>(
        &self,
        mark: &P,
        within_margin: f64,
        use_align: bool,
        xalign: f64,
        yalign: f64,
    ) {
        unsafe {
            gtk_sys::gtk_text_view_scroll_to_mark(
                self.as_ref().to_glib_none().0,
                mark.as_ref().to_glib_none().0,
                within_margin,
                use_align.to_glib(),
                xalign,
                yalign,
            );
        }
    }

    fn set_accepts_tab(&self, accepts_tab: bool) {
        unsafe {
            gtk_sys::gtk_text_view_set_accepts_tab(
                self.as_ref().to_glib_none().0,
                accepts_tab.to_glib(),
            );
        }
    }

    fn set_border_window_size(&self, type_: TextWindowType, size: i32) {
        unsafe {
            gtk_sys::gtk_text_view_set_border_window_size(
                self.as_ref().to_glib_none().0,
                type_.to_glib(),
                size,
            );
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn set_bottom_margin(&self, bottom_margin: i32) {
        unsafe {
            gtk_sys::gtk_text_view_set_bottom_margin(self.as_ref().to_glib_none().0, bottom_margin);
        }
    }

    fn set_buffer<P: IsA<TextBuffer>>(&self, buffer: Option<&P>) {
        unsafe {
            gtk_sys::gtk_text_view_set_buffer(
                self.as_ref().to_glib_none().0,
                buffer.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_cursor_visible(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_text_view_set_cursor_visible(
                self.as_ref().to_glib_none().0,
                setting.to_glib(),
            );
        }
    }

    fn set_editable(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_text_view_set_editable(self.as_ref().to_glib_none().0, setting.to_glib());
        }
    }

    fn set_indent(&self, indent: i32) {
        unsafe {
            gtk_sys::gtk_text_view_set_indent(self.as_ref().to_glib_none().0, indent);
        }
    }

    fn set_input_hints(&self, hints: InputHints) {
        unsafe {
            gtk_sys::gtk_text_view_set_input_hints(self.as_ref().to_glib_none().0, hints.to_glib());
        }
    }

    fn set_input_purpose(&self, purpose: InputPurpose) {
        unsafe {
            gtk_sys::gtk_text_view_set_input_purpose(
                self.as_ref().to_glib_none().0,
                purpose.to_glib(),
            );
        }
    }

    fn set_justification(&self, justification: Justification) {
        unsafe {
            gtk_sys::gtk_text_view_set_justification(
                self.as_ref().to_glib_none().0,
                justification.to_glib(),
            );
        }
    }

    fn set_left_margin(&self, left_margin: i32) {
        unsafe {
            gtk_sys::gtk_text_view_set_left_margin(self.as_ref().to_glib_none().0, left_margin);
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_monospace(&self, monospace: bool) {
        unsafe {
            gtk_sys::gtk_text_view_set_monospace(
                self.as_ref().to_glib_none().0,
                monospace.to_glib(),
            );
        }
    }

    fn set_overwrite(&self, overwrite: bool) {
        unsafe {
            gtk_sys::gtk_text_view_set_overwrite(
                self.as_ref().to_glib_none().0,
                overwrite.to_glib(),
            );
        }
    }

    fn set_pixels_above_lines(&self, pixels_above_lines: i32) {
        unsafe {
            gtk_sys::gtk_text_view_set_pixels_above_lines(
                self.as_ref().to_glib_none().0,
                pixels_above_lines,
            );
        }
    }

    fn set_pixels_below_lines(&self, pixels_below_lines: i32) {
        unsafe {
            gtk_sys::gtk_text_view_set_pixels_below_lines(
                self.as_ref().to_glib_none().0,
                pixels_below_lines,
            );
        }
    }

    fn set_pixels_inside_wrap(&self, pixels_inside_wrap: i32) {
        unsafe {
            gtk_sys::gtk_text_view_set_pixels_inside_wrap(
                self.as_ref().to_glib_none().0,
                pixels_inside_wrap,
            );
        }
    }

    fn set_right_margin(&self, right_margin: i32) {
        unsafe {
            gtk_sys::gtk_text_view_set_right_margin(self.as_ref().to_glib_none().0, right_margin);
        }
    }

    fn set_tabs(&self, tabs: &pango::TabArray) {
        unsafe {
            gtk_sys::gtk_text_view_set_tabs(
                self.as_ref().to_glib_none().0,
                mut_override(tabs.to_glib_none().0),
            );
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn set_top_margin(&self, top_margin: i32) {
        unsafe {
            gtk_sys::gtk_text_view_set_top_margin(self.as_ref().to_glib_none().0, top_margin);
        }
    }

    fn set_wrap_mode(&self, wrap_mode: WrapMode) {
        unsafe {
            gtk_sys::gtk_text_view_set_wrap_mode(
                self.as_ref().to_glib_none().0,
                wrap_mode.to_glib(),
            );
        }
    }

    fn starts_display_line(&self, iter: &TextIter) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_text_view_starts_display_line(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none().0,
            ))
        }
    }

    fn window_to_buffer_coords(
        &self,
        win: TextWindowType,
        window_x: i32,
        window_y: i32,
    ) -> (i32, i32) {
        unsafe {
            let mut buffer_x = mem::uninitialized();
            let mut buffer_y = mem::uninitialized();
            gtk_sys::gtk_text_view_window_to_buffer_coords(
                self.as_ref().to_glib_none().0,
                win.to_glib(),
                window_x,
                window_y,
                &mut buffer_x,
                &mut buffer_y,
            );
            (buffer_x, buffer_y)
        }
    }

    fn get_property_im_module(&self) -> Option<GString> {
        unsafe {
            let mut value = Value::from_type(<GString as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"im-module\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value.get()
        }
    }

    fn set_property_im_module(&self, im_module: Option<&str>) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"im-module\0".as_ptr() as *const _,
                Value::from(im_module).to_glib_none().0,
            );
        }
    }

    fn get_property_monospace(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"monospace\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value.get().unwrap()
        }
    }

    fn set_property_monospace(&self, monospace: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"monospace\0".as_ptr() as *const _,
                Value::from(&monospace).to_glib_none().0,
            );
        }
    }

    fn get_property_populate_all(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"populate-all\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value.get().unwrap()
        }
    }

    fn set_property_populate_all(&self, populate_all: bool) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"populate-all\0".as_ptr() as *const _,
                Value::from(&populate_all).to_glib_none().0,
            );
        }
    }

    fn connect_backspace<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn backspace_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"backspace\0".as_ptr() as *const _,
                Some(transmute(backspace_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_backspace(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("backspace", &[])
                .unwrap()
        };
    }

    fn connect_copy_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn copy_clipboard_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"copy-clipboard\0".as_ptr() as *const _,
                Some(transmute(copy_clipboard_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_copy_clipboard(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("copy-clipboard", &[])
                .unwrap()
        };
    }

    fn connect_cut_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn cut_clipboard_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"cut-clipboard\0".as_ptr() as *const _,
                Some(transmute(cut_clipboard_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_cut_clipboard(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("cut-clipboard", &[])
                .unwrap()
        };
    }

    fn connect_delete_from_cursor<F: Fn(&Self, DeleteType, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn delete_from_cursor_trampoline<
            P,
            F: Fn(&P, DeleteType, i32) + 'static,
        >(
            this: *mut gtk_sys::GtkTextView,
            type_: gtk_sys::GtkDeleteType,
            count: libc::c_int,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(
                &TextView::from_glib_borrow(this).unsafe_cast(),
                from_glib(type_),
                count,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"delete-from-cursor\0".as_ptr() as *const _,
                Some(transmute(delete_from_cursor_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_delete_from_cursor(&self, type_: DeleteType, count: i32) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("delete-from-cursor", &[&type_, &count])
                .unwrap()
        };
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_extend_selection<
        F: Fn(&Self, TextExtendSelection, &TextIter, &TextIter, &TextIter) -> Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn extend_selection_trampoline<
            P,
            F: Fn(&P, TextExtendSelection, &TextIter, &TextIter, &TextIter) -> Inhibit + 'static,
        >(
            this: *mut gtk_sys::GtkTextView,
            granularity: gtk_sys::GtkTextExtendSelection,
            location: *mut gtk_sys::GtkTextIter,
            start: *mut gtk_sys::GtkTextIter,
            end: *mut gtk_sys::GtkTextIter,
            f: glib_sys::gpointer,
        ) -> glib_sys::gboolean
        where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(
                &TextView::from_glib_borrow(this).unsafe_cast(),
                from_glib(granularity),
                &from_glib_borrow(location),
                &from_glib_borrow(start),
                &from_glib_borrow(end),
            )
            .to_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"extend-selection\0".as_ptr() as *const _,
                Some(transmute(extend_selection_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_insert_at_cursor<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn insert_at_cursor_trampoline<P, F: Fn(&P, &str) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            string: *mut libc::c_char,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(
                &TextView::from_glib_borrow(this).unsafe_cast(),
                &GString::from_glib_borrow(string),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"insert-at-cursor\0".as_ptr() as *const _,
                Some(transmute(insert_at_cursor_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_insert_at_cursor(&self, string: &str) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("insert-at-cursor", &[&string])
                .unwrap()
        };
    }

    #[cfg(any(feature = "v3_22_26", feature = "dox"))]
    fn connect_insert_emoji<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn insert_emoji_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"insert-emoji\0".as_ptr() as *const _,
                Some(transmute(insert_emoji_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_22_26", feature = "dox"))]
    fn emit_insert_emoji(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("insert-emoji", &[])
                .unwrap()
        };
    }

    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32, bool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_cursor_trampoline<
            P,
            F: Fn(&P, MovementStep, i32, bool) + 'static,
        >(
            this: *mut gtk_sys::GtkTextView,
            step: gtk_sys::GtkMovementStep,
            count: libc::c_int,
            extend_selection: glib_sys::gboolean,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(
                &TextView::from_glib_borrow(this).unsafe_cast(),
                from_glib(step),
                count,
                from_glib(extend_selection),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-cursor\0".as_ptr() as *const _,
                Some(transmute(move_cursor_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_cursor(&self, step: MovementStep, count: i32, extend_selection: bool) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("move-cursor", &[&step, &count, &extend_selection])
                .unwrap()
        };
    }

    fn connect_move_viewport<F: Fn(&Self, ScrollStep, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_viewport_trampoline<P, F: Fn(&P, ScrollStep, i32) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            step: gtk_sys::GtkScrollStep,
            count: libc::c_int,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(
                &TextView::from_glib_borrow(this).unsafe_cast(),
                from_glib(step),
                count,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-viewport\0".as_ptr() as *const _,
                Some(transmute(move_viewport_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_viewport(&self, step: ScrollStep, count: i32) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("move-viewport", &[&step, &count])
                .unwrap()
        };
    }

    fn connect_paste_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn paste_clipboard_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"paste-clipboard\0".as_ptr() as *const _,
                Some(transmute(paste_clipboard_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_paste_clipboard(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("paste-clipboard", &[])
                .unwrap()
        };
    }

    fn connect_populate_popup<F: Fn(&Self, &Widget) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn populate_popup_trampoline<P, F: Fn(&P, &Widget) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            popup: *mut gtk_sys::GtkWidget,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(
                &TextView::from_glib_borrow(this).unsafe_cast(),
                &from_glib_borrow(popup),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"populate-popup\0".as_ptr() as *const _,
                Some(transmute(populate_popup_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_preedit_changed<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn preedit_changed_trampoline<P, F: Fn(&P, &str) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            preedit: *mut libc::c_char,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(
                &TextView::from_glib_borrow(this).unsafe_cast(),
                &GString::from_glib_borrow(preedit),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"preedit-changed\0".as_ptr() as *const _,
                Some(transmute(preedit_changed_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_preedit_changed(&self, preedit: &str) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("preedit-changed", &[&preedit])
                .unwrap()
        };
    }

    fn connect_select_all<F: Fn(&Self, bool) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn select_all_trampoline<P, F: Fn(&P, bool) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            select: glib_sys::gboolean,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(
                &TextView::from_glib_borrow(this).unsafe_cast(),
                from_glib(select),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"select-all\0".as_ptr() as *const _,
                Some(transmute(select_all_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_select_all(&self, select: bool) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("select-all", &[&select])
                .unwrap()
        };
    }

    fn connect_set_anchor<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn set_anchor_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"set-anchor\0".as_ptr() as *const _,
                Some(transmute(set_anchor_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_set_anchor(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("set-anchor", &[])
                .unwrap()
        };
    }

    fn connect_toggle_cursor_visible<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn toggle_cursor_visible_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"toggle-cursor-visible\0".as_ptr() as *const _,
                Some(transmute(
                    toggle_cursor_visible_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_toggle_cursor_visible(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("toggle-cursor-visible", &[])
                .unwrap()
        };
    }

    fn connect_toggle_overwrite<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn toggle_overwrite_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"toggle-overwrite\0".as_ptr() as *const _,
                Some(transmute(toggle_overwrite_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_toggle_overwrite(&self) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.to_glib_none().0 as *mut gobject_sys::GObject)
                .emit("toggle-overwrite", &[])
                .unwrap()
        };
    }

    fn connect_property_accepts_tab_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_accepts_tab_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::accepts-tab\0".as_ptr() as *const _,
                Some(transmute(notify_accepts_tab_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn connect_property_bottom_margin_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_bottom_margin_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::bottom-margin\0".as_ptr() as *const _,
                Some(transmute(
                    notify_bottom_margin_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_buffer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_buffer_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::buffer\0".as_ptr() as *const _,
                Some(transmute(notify_buffer_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_cursor_visible_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_cursor_visible_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cursor-visible\0".as_ptr() as *const _,
                Some(transmute(
                    notify_cursor_visible_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_editable_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::editable\0".as_ptr() as *const _,
                Some(transmute(notify_editable_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_im_module_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_im_module_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::im-module\0".as_ptr() as *const _,
                Some(transmute(notify_im_module_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_indent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_indent_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::indent\0".as_ptr() as *const _,
                Some(transmute(notify_indent_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_input_hints_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_hints_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::input-hints\0".as_ptr() as *const _,
                Some(transmute(notify_input_hints_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_input_purpose_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_purpose_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::input-purpose\0".as_ptr() as *const _,
                Some(transmute(
                    notify_input_purpose_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_justification_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_justification_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::justification\0".as_ptr() as *const _,
                Some(transmute(
                    notify_justification_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_left_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_left_margin_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::left-margin\0".as_ptr() as *const _,
                Some(transmute(notify_left_margin_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_monospace_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_monospace_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::monospace\0".as_ptr() as *const _,
                Some(transmute(notify_monospace_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_overwrite_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_overwrite_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::overwrite\0".as_ptr() as *const _,
                Some(transmute(notify_overwrite_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_pixels_above_lines_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_above_lines_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-above-lines\0".as_ptr() as *const _,
                Some(transmute(
                    notify_pixels_above_lines_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_pixels_below_lines_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_below_lines_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-below-lines\0".as_ptr() as *const _,
                Some(transmute(
                    notify_pixels_below_lines_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_pixels_inside_wrap_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_inside_wrap_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-inside-wrap\0".as_ptr() as *const _,
                Some(transmute(
                    notify_pixels_inside_wrap_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_populate_all_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_populate_all_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::populate-all\0".as_ptr() as *const _,
                Some(transmute(
                    notify_populate_all_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_right_margin_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_right_margin_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::right-margin\0".as_ptr() as *const _,
                Some(transmute(
                    notify_right_margin_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tabs_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tabs\0".as_ptr() as *const _,
                Some(transmute(notify_tabs_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn connect_property_top_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_top_margin_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::top-margin\0".as_ptr() as *const _,
                Some(transmute(notify_top_margin_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_mode_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTextView,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TextView>,
        {
            let f: &F = &*(f as *const F);
            f(&TextView::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap-mode\0".as_ptr() as *const _,
                Some(transmute(notify_wrap_mode_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for TextView {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "TextView")
    }
}
