# Copyright 2015 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

require 'date'
require 'google/apis/core/base_service'
require 'google/apis/core/json_representation'
require 'google/apis/core/hashable'
require 'google/apis/errors'

module Google
  module Apis
    module ComputeBeta
      
      # A specification of the type and number of accelerator cards attached to the
      # instance.
      class AcceleratorConfig
        include Google::Apis::Core::Hashable
      
        # The number of the guest accelerator cards exposed to this instance.
        # Corresponds to the JSON property `acceleratorCount`
        # @return [Fixnum]
        attr_accessor :accelerator_count
      
        # Full or partial URL of the accelerator type resource to attach to this
        # instance. For example: projects/my-project/zones/us-central1-c/
        # acceleratorTypes/nvidia-tesla-p100 If you are creating an instance template,
        # specify only the accelerator name. See GPUs on Compute Engine for a full list
        # of accelerator types.
        # Corresponds to the JSON property `acceleratorType`
        # @return [String]
        attr_accessor :accelerator_type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @accelerator_count = args[:accelerator_count] if args.key?(:accelerator_count)
          @accelerator_type = args[:accelerator_type] if args.key?(:accelerator_type)
        end
      end
      
      # Represents an Accelerator Type resource.
      # Google Cloud Platform provides graphics processing units (accelerators) that
      # you can add to VM instances to improve or accelerate performance when working
      # with intensive workloads. For more information, read GPUs on Compute Engine. (=
      # = resource_for beta.acceleratorTypes ==) (== resource_for v1.acceleratorTypes =
      # =)
      class AcceleratorType
        include Google::Apis::Core::Hashable
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # Deprecation status for a public resource.
        # Corresponds to the JSON property `deprecated`
        # @return [Google::Apis::ComputeBeta::DeprecationStatus]
        attr_accessor :deprecated
      
        # [Output Only] An optional textual description of the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] The type of the resource. Always compute#acceleratorType for
        # accelerator types.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] Maximum accelerator cards allowed per instance.
        # Corresponds to the JSON property `maximumCardsPerInstance`
        # @return [Fixnum]
        attr_accessor :maximum_cards_per_instance
      
        # [Output Only] Name of the resource.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # [Output Only] Server-defined fully-qualified URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] The name of the zone where the accelerator type resides, such as
        # us-central1-a. You must specify this field as part of the HTTP request URL. It
        # is not settable as a field in the request body.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @deprecated = args[:deprecated] if args.key?(:deprecated)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @maximum_cards_per_instance = args[:maximum_cards_per_instance] if args.key?(:maximum_cards_per_instance)
          @name = args[:name] if args.key?(:name)
          @self_link = args[:self_link] if args.key?(:self_link)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class AcceleratorTypeAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of AcceleratorTypesScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::AcceleratorTypesScopedList>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#acceleratorTypeAggregatedList
        # for aggregated lists of accelerator types.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::AcceleratorTypeAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::AcceleratorTypeAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of accelerator types.
      class AcceleratorTypeList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of AcceleratorType resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::AcceleratorType>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#acceleratorTypeList for lists
        # of accelerator types.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::AcceleratorTypeList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::AcceleratorTypeList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class AcceleratorTypesScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] A list of accelerator types contained in this scope.
        # Corresponds to the JSON property `acceleratorTypes`
        # @return [Array<Google::Apis::ComputeBeta::AcceleratorType>]
        attr_accessor :accelerator_types
      
        # [Output Only] An informational warning that appears when the accelerator types
        # list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::AcceleratorTypesScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @accelerator_types = args[:accelerator_types] if args.key?(:accelerator_types)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] An informational warning that appears when the accelerator types
        # list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::AcceleratorTypesScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # An access configuration attached to an instance's network interface. Only one
      # access config per instance is supported.
      class AccessConfig
        include Google::Apis::Core::Hashable
      
        # [Output Only] Type of the resource. Always compute#accessConfig for access
        # configs.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # The name of this access configuration. The default and recommended name is
        # External NAT, but you can use any arbitrary string, such as My external IP or
        # Network Access.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # An external IP address associated with this instance. Specify an unused static
        # external IP address available to the project or leave this field undefined to
        # use an IP from a shared ephemeral IP address pool. If you specify a static
        # external IP address, it must live in the same region as the zone of the
        # instance.
        # Corresponds to the JSON property `natIP`
        # @return [String]
        attr_accessor :nat_ip
      
        # This signifies the networking tier used for configuring this access
        # configuration and can only take the following values: PREMIUM, STANDARD.
        # If an AccessConfig is specified without a valid external IP address, an
        # ephemeral IP will be created with this networkTier.
        # If an AccessConfig with a valid external IP address is specified, it must
        # match that of the networkTier associated with the Address resource owning that
        # IP.
        # Corresponds to the JSON property `networkTier`
        # @return [String]
        attr_accessor :network_tier
      
        # The DNS domain name for the public PTR record. You can set this field only if
        # the `setPublicPtr` field is enabled.
        # Corresponds to the JSON property `publicPtrDomainName`
        # @return [String]
        attr_accessor :public_ptr_domain_name
      
        # Specifies whether a public DNS 'PTR' record should be created to map the
        # external IP address of the instance to a DNS domain name.
        # Corresponds to the JSON property `setPublicPtr`
        # @return [Boolean]
        attr_accessor :set_public_ptr
        alias_method :set_public_ptr?, :set_public_ptr
      
        # The type of configuration. The default and only option is ONE_TO_ONE_NAT.
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @nat_ip = args[:nat_ip] if args.key?(:nat_ip)
          @network_tier = args[:network_tier] if args.key?(:network_tier)
          @public_ptr_domain_name = args[:public_ptr_domain_name] if args.key?(:public_ptr_domain_name)
          @set_public_ptr = args[:set_public_ptr] if args.key?(:set_public_ptr)
          @type = args[:type] if args.key?(:type)
        end
      end
      
      # Represents an IP Address resource.
      # An address resource represents a regional internal IP address. Regional
      # internal IP addresses are RFC 1918 addresses that come from either a primary
      # or secondary IP range of a subnet in a VPC network. Regional external IP
      # addresses can be assigned to GCP VM instances, Cloud VPN gateways, regional
      # external forwarding rules for network load balancers (in either Standard or
      # Premium Tier), and regional external forwarding rules for HTTP(S), SSL Proxy,
      # and TCP Proxy load balancers in Standard Tier. For more information, read IP
      # addresses.
      # A globalAddresses resource represent a global external IP address. Global
      # external IP addresses are IPv4 or IPv6 addresses. They can only be assigned to
      # global forwarding rules for HTTP(S), SSL Proxy, or TCP Proxy load balancers in
      # Premium Tier. For more information, read Global resources. (== resource_for
      # beta.addresses ==) (== resource_for v1.addresses ==) (== resource_for beta.
      # globalAddresses ==) (== resource_for v1.globalAddresses ==)
      class Address
        include Google::Apis::Core::Hashable
      
        # The static IP address represented by this resource.
        # Corresponds to the JSON property `address`
        # @return [String]
        attr_accessor :address
      
        # The type of address to reserve, either INTERNAL or EXTERNAL. If unspecified,
        # defaults to EXTERNAL.
        # Corresponds to the JSON property `addressType`
        # @return [String]
        attr_accessor :address_type
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this field when you create
        # the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # The IP version that will be used by this address. Valid options are IPV4 or
        # IPV6. This can only be specified for a global address.
        # Corresponds to the JSON property `ipVersion`
        # @return [String]
        attr_accessor :ip_version
      
        # [Output Only] Type of the resource. Always compute#address for addresses.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # A fingerprint for the labels being applied to this Address, which is
        # essentially a hash of the labels set used for optimistic locking. The
        # fingerprint is initially generated by Compute Engine and changes after every
        # request to modify or update labels. You must always provide an up-to-date
        # fingerprint hash in order to update or change labels, otherwise the request
        # will fail with error 412 conditionNotMet.
        # To see the latest fingerprint, make a get() request to retrieve an Address.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # Labels to apply to this Address resource. These can be later modified by the
        # setLabels method. Each label key/value must comply with RFC1035. Label values
        # may be empty.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # Name of the resource. Provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all
        # following characters (except for the last character) must be a dash, lowercase
        # letter, or digit. The last character must be a lowercase letter or digit.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The URL of the network in which to reserve the address. This field can only be
        # used with INTERNAL type with the VPC_PEERING purpose.
        # Corresponds to the JSON property `network`
        # @return [String]
        attr_accessor :network
      
        # This signifies the networking tier used for configuring this address and can
        # only take the following values: PREMIUM or STANDARD. Global forwarding rules
        # can only be Premium Tier. Regional forwarding rules can be either Premium or
        # Standard Tier. Standard Tier addresses applied to regional forwarding rules
        # can be used with any external load balancer. Regional forwarding rules in
        # Premium Tier can only be used with a network load balancer.
        # If this field is not specified, it is assumed to be PREMIUM.
        # Corresponds to the JSON property `networkTier`
        # @return [String]
        attr_accessor :network_tier
      
        # The prefix length if the resource reprensents an IP range.
        # Corresponds to the JSON property `prefixLength`
        # @return [Fixnum]
        attr_accessor :prefix_length
      
        # The purpose of this resource, which can be one of the following values:
        # - `GCE_ENDPOINT` for addresses that are used by VM instances, alias IP ranges,
        # internal load balancers, and similar resources.
        # - `DNS_RESOLVER` for a DNS resolver address in a subnetwork
        # - `VPC_PEERING` for addresses that are reserved for VPC peer networks.
        # - `NAT_AUTO` for addresses that are external IP addresses automatically
        # reserved for Cloud NAT.
        # Corresponds to the JSON property `purpose`
        # @return [String]
        attr_accessor :purpose
      
        # [Output Only] The URL of the region where the regional address resides. This
        # field is not applicable to global addresses. You must specify this field as
        # part of the HTTP request URL.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] The status of the address, which can be one of RESERVING,
        # RESERVED, or IN_USE. An address that is RESERVING is currently in the process
        # of being reserved. A RESERVED address is currently reserved and available to
        # use. An IN_USE address is currently being used by another resource and is not
        # available.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        # The URL of the subnetwork in which to reserve the address. If an IP address is
        # specified, it must be within the subnetwork's IP range. This field can only be
        # used with INTERNAL type with a GCE_ENDPOINT or DNS_RESOLVER purpose.
        # Corresponds to the JSON property `subnetwork`
        # @return [String]
        attr_accessor :subnetwork
      
        # [Output Only] The URLs of the resources that are using this address.
        # Corresponds to the JSON property `users`
        # @return [Array<String>]
        attr_accessor :users
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @address = args[:address] if args.key?(:address)
          @address_type = args[:address_type] if args.key?(:address_type)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @ip_version = args[:ip_version] if args.key?(:ip_version)
          @kind = args[:kind] if args.key?(:kind)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
          @name = args[:name] if args.key?(:name)
          @network = args[:network] if args.key?(:network)
          @network_tier = args[:network_tier] if args.key?(:network_tier)
          @prefix_length = args[:prefix_length] if args.key?(:prefix_length)
          @purpose = args[:purpose] if args.key?(:purpose)
          @region = args[:region] if args.key?(:region)
          @self_link = args[:self_link] if args.key?(:self_link)
          @status = args[:status] if args.key?(:status)
          @subnetwork = args[:subnetwork] if args.key?(:subnetwork)
          @users = args[:users] if args.key?(:users)
        end
      end
      
      # 
      class AddressAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of AddressesScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::AddressesScopedList>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#addressAggregatedList for
        # aggregated lists of addresses.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::AddressAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::AddressAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of addresses.
      class AddressList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Address resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::Address>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#addressList for lists of
        # addresses.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::AddressList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::AddressList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class AddressesScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] A list of addresses contained in this scope.
        # Corresponds to the JSON property `addresses`
        # @return [Array<Google::Apis::ComputeBeta::Address>]
        attr_accessor :addresses
      
        # [Output Only] Informational warning which replaces the list of addresses when
        # the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::AddressesScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @addresses = args[:addresses] if args.key?(:addresses)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning which replaces the list of addresses when
        # the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::AddressesScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # An alias IP range attached to an instance's network interface.
      class AliasIpRange
        include Google::Apis::Core::Hashable
      
        # The IP alias ranges to allocate for this interface. This IP CIDR range must
        # belong to the specified subnetwork and cannot contain IP addresses reserved by
        # system or used by other network interfaces. This range may be a single IP
        # address (such as 10.2.3.4), a netmask (such as /24) or a CIDR-formatted string
        # (such as 10.1.2.0/24).
        # Corresponds to the JSON property `ipCidrRange`
        # @return [String]
        attr_accessor :ip_cidr_range
      
        # The name of a subnetwork secondary IP range from which to allocate an IP alias
        # range. If not specified, the primary range of the subnetwork is used.
        # Corresponds to the JSON property `subnetworkRangeName`
        # @return [String]
        attr_accessor :subnetwork_range_name
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @ip_cidr_range = args[:ip_cidr_range] if args.key?(:ip_cidr_range)
          @subnetwork_range_name = args[:subnetwork_range_name] if args.key?(:subnetwork_range_name)
        end
      end
      
      # 
      class AllocationSpecificSkuAllocationAllocatedInstancePropertiesReservedDisk
        include Google::Apis::Core::Hashable
      
        # Specifies the size of the disk in base-2 GB.
        # Corresponds to the JSON property `diskSizeGb`
        # @return [Fixnum]
        attr_accessor :disk_size_gb
      
        # Specifies the disk interface to use for attaching this disk, which is either
        # SCSI or NVME. The default is SCSI. For performance characteristics of SCSI
        # over NVMe, see Local SSD performance.
        # Corresponds to the JSON property `interface`
        # @return [String]
        attr_accessor :interface
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @disk_size_gb = args[:disk_size_gb] if args.key?(:disk_size_gb)
          @interface = args[:interface] if args.key?(:interface)
        end
      end
      
      # Properties of the SKU instances being reserved.
      class AllocationSpecificSkuAllocationReservedInstanceProperties
        include Google::Apis::Core::Hashable
      
        # Specifies accelerator type and count.
        # Corresponds to the JSON property `guestAccelerators`
        # @return [Array<Google::Apis::ComputeBeta::AcceleratorConfig>]
        attr_accessor :guest_accelerators
      
        # Specifies amount of local ssd to reserve with each instance. The type of disk
        # is local-ssd.
        # Corresponds to the JSON property `localSsds`
        # @return [Array<Google::Apis::ComputeBeta::AllocationSpecificSkuAllocationAllocatedInstancePropertiesReservedDisk>]
        attr_accessor :local_ssds
      
        # Specifies type of machine (name only) which has fixed number of vCPUs and
        # fixed amount of memory. This also includes specifying custom machine type
        # following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
        # Corresponds to the JSON property `machineType`
        # @return [String]
        attr_accessor :machine_type
      
        # Minimum cpu platform the reservation.
        # Corresponds to the JSON property `minCpuPlatform`
        # @return [String]
        attr_accessor :min_cpu_platform
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @guest_accelerators = args[:guest_accelerators] if args.key?(:guest_accelerators)
          @local_ssds = args[:local_ssds] if args.key?(:local_ssds)
          @machine_type = args[:machine_type] if args.key?(:machine_type)
          @min_cpu_platform = args[:min_cpu_platform] if args.key?(:min_cpu_platform)
        end
      end
      
      # This reservation type allows to pre allocate specific instance configuration.
      class AllocationSpecificSkuReservation
        include Google::Apis::Core::Hashable
      
        # Specifies the number of resources that are allocated.
        # Corresponds to the JSON property `count`
        # @return [Fixnum]
        attr_accessor :count
      
        # [OutputOnly] Indicates how many instances are in use.
        # Corresponds to the JSON property `inUseCount`
        # @return [Fixnum]
        attr_accessor :in_use_count
      
        # Properties of the SKU instances being reserved.
        # Corresponds to the JSON property `instanceProperties`
        # @return [Google::Apis::ComputeBeta::AllocationSpecificSkuAllocationReservedInstanceProperties]
        attr_accessor :instance_properties
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @count = args[:count] if args.key?(:count)
          @in_use_count = args[:in_use_count] if args.key?(:in_use_count)
          @instance_properties = args[:instance_properties] if args.key?(:instance_properties)
        end
      end
      
      # An instance-attached disk resource.
      class AttachedDisk
        include Google::Apis::Core::Hashable
      
        # Specifies whether the disk will be auto-deleted when the instance is deleted (
        # but not when the disk is detached from the instance).
        # Corresponds to the JSON property `autoDelete`
        # @return [Boolean]
        attr_accessor :auto_delete
        alias_method :auto_delete?, :auto_delete
      
        # Indicates that this is a boot disk. The virtual machine will use the first
        # partition of the disk for its root filesystem.
        # Corresponds to the JSON property `boot`
        # @return [Boolean]
        attr_accessor :boot
        alias_method :boot?, :boot
      
        # Specifies a unique device name of your choice that is reflected into the /dev/
        # disk/by-id/google-* tree of a Linux operating system running within the
        # instance. This name can be used to reference the device for mounting, resizing,
        # and so on, from within the instance.
        # If not specified, the server chooses a default device name to apply to this
        # disk, in the form persistent-disk-x, where x is a number assigned by Google
        # Compute Engine. This field is only applicable for persistent disks.
        # Corresponds to the JSON property `deviceName`
        # @return [String]
        attr_accessor :device_name
      
        # Represents a customer-supplied encryption key
        # Corresponds to the JSON property `diskEncryptionKey`
        # @return [Google::Apis::ComputeBeta::CustomerEncryptionKey]
        attr_accessor :disk_encryption_key
      
        # A list of features to enable on the guest operating system. Applicable only
        # for bootable images. Read  Enabling guest operating system features to see a
        # list of available options.
        # Corresponds to the JSON property `guestOsFeatures`
        # @return [Array<Google::Apis::ComputeBeta::GuestOsFeature>]
        attr_accessor :guest_os_features
      
        # [Output Only] A zero-based index to this disk, where 0 is reserved for the
        # boot disk. If you have many disks attached to an instance, each disk would
        # have a unique index number.
        # Corresponds to the JSON property `index`
        # @return [Fixnum]
        attr_accessor :index
      
        # [Input Only] Specifies the parameters for a new disk that will be created
        # alongside the new instance. Use initialization parameters to create boot disks
        # or local SSDs attached to the new instance.
        # This property is mutually exclusive with the source property; you can only
        # define one or the other, but not both.
        # Corresponds to the JSON property `initializeParams`
        # @return [Google::Apis::ComputeBeta::AttachedDiskInitializeParams]
        attr_accessor :initialize_params
      
        # Specifies the disk interface to use for attaching this disk, which is either
        # SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and
        # the request will fail if you attempt to attach a persistent disk in any other
        # format than SCSI. Local SSDs can use either NVME or SCSI. For performance
        # characteristics of SCSI over NVMe, see Local SSD performance. TODO(b/131765817)
        # : Update documentation when NVME is supported.
        # Corresponds to the JSON property `interface`
        # @return [String]
        attr_accessor :interface
      
        # [Output Only] Type of the resource. Always compute#attachedDisk for attached
        # disks.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] Any valid publicly visible licenses.
        # Corresponds to the JSON property `licenses`
        # @return [Array<String>]
        attr_accessor :licenses
      
        # The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not
        # specified, the default is to attach the disk in READ_WRITE mode.
        # Corresponds to the JSON property `mode`
        # @return [String]
        attr_accessor :mode
      
        # Specifies a valid partial or full URL to an existing Persistent Disk resource.
        # When creating a new instance, one of initializeParams.sourceImage or
        # initializeParams.sourceSnapshot or disks.source is required except for local
        # SSD.
        # If desired, you can also attach existing non-root persistent disks using this
        # property. This field is only applicable for persistent disks.
        # Note that for InstanceTemplate, specify the disk name, not the URL for the
        # disk.
        # Corresponds to the JSON property `source`
        # @return [String]
        attr_accessor :source
      
        # Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified,
        # the default is PERSISTENT.
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @auto_delete = args[:auto_delete] if args.key?(:auto_delete)
          @boot = args[:boot] if args.key?(:boot)
          @device_name = args[:device_name] if args.key?(:device_name)
          @disk_encryption_key = args[:disk_encryption_key] if args.key?(:disk_encryption_key)
          @guest_os_features = args[:guest_os_features] if args.key?(:guest_os_features)
          @index = args[:index] if args.key?(:index)
          @initialize_params = args[:initialize_params] if args.key?(:initialize_params)
          @interface = args[:interface] if args.key?(:interface)
          @kind = args[:kind] if args.key?(:kind)
          @licenses = args[:licenses] if args.key?(:licenses)
          @mode = args[:mode] if args.key?(:mode)
          @source = args[:source] if args.key?(:source)
          @type = args[:type] if args.key?(:type)
        end
      end
      
      # [Input Only] Specifies the parameters for a new disk that will be created
      # alongside the new instance. Use initialization parameters to create boot disks
      # or local SSDs attached to the new instance.
      # This property is mutually exclusive with the source property; you can only
      # define one or the other, but not both.
      class AttachedDiskInitializeParams
        include Google::Apis::Core::Hashable
      
        # An optional description. Provide this property when creating the disk.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Specifies the disk name. If not specified, the default is to use the name of
        # the instance. If the disk with the instance name exists already in the given
        # zone/region, a new name will be automatically generated.
        # Corresponds to the JSON property `diskName`
        # @return [String]
        attr_accessor :disk_name
      
        # Specifies the size of the disk in base-2 GB. If not specified, the disk will
        # be the same size as the image (usually 10GB). If specified, the size must be
        # equal to or larger than 10GB.
        # Corresponds to the JSON property `diskSizeGb`
        # @return [Fixnum]
        attr_accessor :disk_size_gb
      
        # Specifies the disk type to use to create the instance. If not specified, the
        # default is pd-standard, specified using the full URL. For example:
        # https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/pd-
        # standard
        # Other values include pd-ssd and local-ssd. If you define this field, you can
        # provide either the full or partial URL. For example, the following are valid
        # values:
        # - https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/
        # diskType
        # - projects/project/zones/zone/diskTypes/diskType
        # - zones/zone/diskTypes/diskType  Note that for InstanceTemplate, this is the
        # name of the disk type, not URL.
        # Corresponds to the JSON property `diskType`
        # @return [String]
        attr_accessor :disk_type
      
        # A list of features to enable on the guest operating system. Applicable only
        # for bootable images. Read  Enabling guest operating system features to see a
        # list of available options.
        # Guest OS features are applied by merging initializeParams.guestOsFeatures and
        # disks.guestOsFeatures
        # Corresponds to the JSON property `guestOsFeatures`
        # @return [Array<Google::Apis::ComputeBeta::GuestOsFeature>]
        attr_accessor :guest_os_features
      
        # Labels to apply to this disk. These can be later modified by the disks.
        # setLabels method. This field is only applicable for persistent disks.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # Resource policies applied to this disk for automatic snapshot creations.
        # Specified using the full or partial URL. For instance template, specify only
        # the resource policy name.
        # Corresponds to the JSON property `resourcePolicies`
        # @return [Array<String>]
        attr_accessor :resource_policies
      
        # The source image to create this disk. When creating a new instance, one of
        # initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.
        # source is required except for local SSD.
        # To create a disk with one of the public operating system images, specify the
        # image by its family name. For example, specify family/debian-9 to use the
        # latest Debian 9 image:
        # projects/debian-cloud/global/images/family/debian-9
        # Alternatively, use a specific version of a public operating system image:
        # projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
        # To create a disk with a custom image that you created, specify the image name
        # in the following format:
        # global/images/my-custom-image
        # You can also specify a custom image by its image family, which returns the
        # latest version of the image in that family. Replace the image name with family/
        # family-name:
        # global/images/family/my-image-family
        # If the source image is deleted later, this field will not be set.
        # Corresponds to the JSON property `sourceImage`
        # @return [String]
        attr_accessor :source_image
      
        # Represents a customer-supplied encryption key
        # Corresponds to the JSON property `sourceImageEncryptionKey`
        # @return [Google::Apis::ComputeBeta::CustomerEncryptionKey]
        attr_accessor :source_image_encryption_key
      
        # The source snapshot to create this disk. When creating a new instance, one of
        # initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.
        # source is required except for local SSD.
        # To create a disk with a snapshot that you created, specify the snapshot name
        # in the following format:
        # global/snapshots/my-backup
        # If the source snapshot is deleted later, this field will not be set.
        # Corresponds to the JSON property `sourceSnapshot`
        # @return [String]
        attr_accessor :source_snapshot
      
        # Represents a customer-supplied encryption key
        # Corresponds to the JSON property `sourceSnapshotEncryptionKey`
        # @return [Google::Apis::ComputeBeta::CustomerEncryptionKey]
        attr_accessor :source_snapshot_encryption_key
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @description = args[:description] if args.key?(:description)
          @disk_name = args[:disk_name] if args.key?(:disk_name)
          @disk_size_gb = args[:disk_size_gb] if args.key?(:disk_size_gb)
          @disk_type = args[:disk_type] if args.key?(:disk_type)
          @guest_os_features = args[:guest_os_features] if args.key?(:guest_os_features)
          @labels = args[:labels] if args.key?(:labels)
          @resource_policies = args[:resource_policies] if args.key?(:resource_policies)
          @source_image = args[:source_image] if args.key?(:source_image)
          @source_image_encryption_key = args[:source_image_encryption_key] if args.key?(:source_image_encryption_key)
          @source_snapshot = args[:source_snapshot] if args.key?(:source_snapshot)
          @source_snapshot_encryption_key = args[:source_snapshot_encryption_key] if args.key?(:source_snapshot_encryption_key)
        end
      end
      
      # Specifies the audit configuration for a service. The configuration determines
      # which permission types are logged, and what identities, if any, are exempted
      # from logging. An AuditConfig must have one or more AuditLogConfigs.
      # If there are AuditConfigs for both `allServices` and a specific service, the
      # union of the two AuditConfigs is used for that service: the log_types
      # specified in each AuditConfig are enabled, and the exempted_members in each
      # AuditLogConfig are exempted.
      # Example Policy with multiple AuditConfigs:
      # ` "audit_configs": [ ` "service": "allServices" "audit_log_configs": [ ` "
      # log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] `, ` "
      # log_type": "DATA_WRITE", `, ` "log_type": "ADMIN_READ", ` ] `, ` "service": "
      # sampleservice.googleapis.com" "audit_log_configs": [ ` "log_type": "DATA_READ",
      # `, ` "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com"
      # ] ` ] ` ] `
      # For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
      # logging. It also exempts jose@example.com from DATA_READ logging, and aliya@
      # example.com from DATA_WRITE logging.
      class AuditConfig
        include Google::Apis::Core::Hashable
      
        # The configuration for logging of each type of permission.
        # Corresponds to the JSON property `auditLogConfigs`
        # @return [Array<Google::Apis::ComputeBeta::AuditLogConfig>]
        attr_accessor :audit_log_configs
      
        # 
        # Corresponds to the JSON property `exemptedMembers`
        # @return [Array<String>]
        attr_accessor :exempted_members
      
        # Specifies a service that will be enabled for audit logging. For example, `
        # storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special
        # value that covers all services.
        # Corresponds to the JSON property `service`
        # @return [String]
        attr_accessor :service
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @audit_log_configs = args[:audit_log_configs] if args.key?(:audit_log_configs)
          @exempted_members = args[:exempted_members] if args.key?(:exempted_members)
          @service = args[:service] if args.key?(:service)
        end
      end
      
      # Provides the configuration for logging a type of permissions. Example:
      # ` "audit_log_configs": [ ` "log_type": "DATA_READ", "exempted_members": [ "
      # user:jose@example.com" ] `, ` "log_type": "DATA_WRITE", ` ] `
      # This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@
      # example.com from DATA_READ logging.
      class AuditLogConfig
        include Google::Apis::Core::Hashable
      
        # Specifies the identities that do not cause logging for this type of permission.
        # Follows the same format of [Binding.members][].
        # Corresponds to the JSON property `exemptedMembers`
        # @return [Array<String>]
        attr_accessor :exempted_members
      
        # 
        # Corresponds to the JSON property `ignoreChildExemptions`
        # @return [Boolean]
        attr_accessor :ignore_child_exemptions
        alias_method :ignore_child_exemptions?, :ignore_child_exemptions
      
        # The log type that this config enables.
        # Corresponds to the JSON property `logType`
        # @return [String]
        attr_accessor :log_type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @exempted_members = args[:exempted_members] if args.key?(:exempted_members)
          @ignore_child_exemptions = args[:ignore_child_exemptions] if args.key?(:ignore_child_exemptions)
          @log_type = args[:log_type] if args.key?(:log_type)
        end
      end
      
      # Authorization-related information used by Cloud Audit Logging.
      class AuthorizationLoggingOptions
        include Google::Apis::Core::Hashable
      
        # The type of the permission that was checked.
        # Corresponds to the JSON property `permissionType`
        # @return [String]
        attr_accessor :permission_type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @permission_type = args[:permission_type] if args.key?(:permission_type)
        end
      end
      
      # Represents an Autoscaler resource.
      # Use autoscalers to automatically add or delete instances from a managed
      # instance group according to your defined autoscaling policy. For more
      # information, read Autoscaling Groups of Instances.
      # For zonal managed instance groups resource, use the autoscaler resource.
      # For regional managed instance groups, use the regionAutoscalers resource. (==
      # resource_for beta.autoscalers ==) (== resource_for v1.autoscalers ==) (==
      # resource_for beta.regionAutoscalers ==) (== resource_for v1.regionAutoscalers =
      # =)
      class Autoscaler
        include Google::Apis::Core::Hashable
      
        # Cloud Autoscaler policy.
        # Corresponds to the JSON property `autoscalingPolicy`
        # @return [Google::Apis::ComputeBeta::AutoscalingPolicy]
        attr_accessor :autoscaling_policy
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Type of the resource. Always compute#autoscaler for autoscalers.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Name of the resource. Provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter,
        # and all following characters must be a dash, lowercase letter, or digit,
        # except the last character, which cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # [Output Only] URL of the region where the instance group resides (for
        # autoscalers living in regional scope).
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] The status of the autoscaler configuration.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        # [Output Only] Human-readable details about the current state of the autoscaler.
        # Read the documentation for Commonly returned status messages for examples of
        # status messages you might encounter.
        # Corresponds to the JSON property `statusDetails`
        # @return [Array<Google::Apis::ComputeBeta::AutoscalerStatusDetails>]
        attr_accessor :status_details
      
        # URL of the managed instance group that this autoscaler will scale.
        # Corresponds to the JSON property `target`
        # @return [String]
        attr_accessor :target
      
        # [Output Only] URL of the zone where the instance group resides (for
        # autoscalers living in zonal scope).
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @autoscaling_policy = args[:autoscaling_policy] if args.key?(:autoscaling_policy)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @region = args[:region] if args.key?(:region)
          @self_link = args[:self_link] if args.key?(:self_link)
          @status = args[:status] if args.key?(:status)
          @status_details = args[:status_details] if args.key?(:status_details)
          @target = args[:target] if args.key?(:target)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class AutoscalerAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of AutoscalersScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::AutoscalersScopedList>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#autoscalerAggregatedList for
        # aggregated lists of autoscalers.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::AutoscalerAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::AutoscalerAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of Autoscaler resources.
      class AutoscalerList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Autoscaler resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::Autoscaler>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#autoscalerList for lists of
        # autoscalers.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::AutoscalerList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::AutoscalerList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class AutoscalerStatusDetails
        include Google::Apis::Core::Hashable
      
        # The status message.
        # Corresponds to the JSON property `message`
        # @return [String]
        attr_accessor :message
      
        # The type of error returned.
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @message = args[:message] if args.key?(:message)
          @type = args[:type] if args.key?(:type)
        end
      end
      
      # 
      class AutoscalersScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] A list of autoscalers contained in this scope.
        # Corresponds to the JSON property `autoscalers`
        # @return [Array<Google::Apis::ComputeBeta::Autoscaler>]
        attr_accessor :autoscalers
      
        # [Output Only] Informational warning which replaces the list of autoscalers
        # when the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::AutoscalersScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @autoscalers = args[:autoscalers] if args.key?(:autoscalers)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning which replaces the list of autoscalers
        # when the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::AutoscalersScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Cloud Autoscaler policy.
      class AutoscalingPolicy
        include Google::Apis::Core::Hashable
      
        # The number of seconds that the autoscaler should wait before it starts
        # collecting information from a new instance. This prevents the autoscaler from
        # collecting information when the instance is initializing, during which the
        # collected usage would not be reliable. The default time autoscaler waits is 60
        # seconds.
        # Virtual machine initialization times might vary because of numerous factors.
        # We recommend that you test how long an instance may take to initialize. To do
        # this, create an instance and time the startup process.
        # Corresponds to the JSON property `coolDownPeriodSec`
        # @return [Fixnum]
        attr_accessor :cool_down_period_sec
      
        # CPU utilization policy.
        # Corresponds to the JSON property `cpuUtilization`
        # @return [Google::Apis::ComputeBeta::AutoscalingPolicyCpuUtilization]
        attr_accessor :cpu_utilization
      
        # Configuration parameters of autoscaling based on a custom metric.
        # Corresponds to the JSON property `customMetricUtilizations`
        # @return [Array<Google::Apis::ComputeBeta::AutoscalingPolicyCustomMetricUtilization>]
        attr_accessor :custom_metric_utilizations
      
        # Configuration parameters of autoscaling based on load balancing.
        # Corresponds to the JSON property `loadBalancingUtilization`
        # @return [Google::Apis::ComputeBeta::AutoscalingPolicyLoadBalancingUtilization]
        attr_accessor :load_balancing_utilization
      
        # The maximum number of instances that the autoscaler can scale up to. This is
        # required when creating or updating an autoscaler. The maximum number of
        # replicas should not be lower than minimal number of replicas.
        # Corresponds to the JSON property `maxNumReplicas`
        # @return [Fixnum]
        attr_accessor :max_num_replicas
      
        # The minimum number of replicas that the autoscaler can scale down to. This
        # cannot be less than 0. If not provided, autoscaler will choose a default value
        # depending on maximum number of instances allowed.
        # Corresponds to the JSON property `minNumReplicas`
        # @return [Fixnum]
        attr_accessor :min_num_replicas
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @cool_down_period_sec = args[:cool_down_period_sec] if args.key?(:cool_down_period_sec)
          @cpu_utilization = args[:cpu_utilization] if args.key?(:cpu_utilization)
          @custom_metric_utilizations = args[:custom_metric_utilizations] if args.key?(:custom_metric_utilizations)
          @load_balancing_utilization = args[:load_balancing_utilization] if args.key?(:load_balancing_utilization)
          @max_num_replicas = args[:max_num_replicas] if args.key?(:max_num_replicas)
          @min_num_replicas = args[:min_num_replicas] if args.key?(:min_num_replicas)
        end
      end
      
      # CPU utilization policy.
      class AutoscalingPolicyCpuUtilization
        include Google::Apis::Core::Hashable
      
        # The target CPU utilization that the autoscaler should maintain. Must be a
        # float value in the range (0, 1]. If not specified, the default is 0.6.
        # If the CPU level is below the target utilization, the autoscaler scales down
        # the number of instances until it reaches the minimum number of instances you
        # specified or until the average CPU of your instances reaches the target
        # utilization.
        # If the average CPU is above the target utilization, the autoscaler scales up
        # until it reaches the maximum number of instances you specified or until the
        # average utilization reaches the target utilization.
        # Corresponds to the JSON property `utilizationTarget`
        # @return [Float]
        attr_accessor :utilization_target
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @utilization_target = args[:utilization_target] if args.key?(:utilization_target)
        end
      end
      
      # Custom utilization metric policy.
      class AutoscalingPolicyCustomMetricUtilization
        include Google::Apis::Core::Hashable
      
        # A filter string, compatible with a Stackdriver Monitoring filter string for
        # TimeSeries.list API call. This filter is used to select a specific TimeSeries
        # for the purpose of autoscaling and to determine whether the metric is
        # exporting per-instance or per-group data.
        # For the filter to be valid for autoscaling purposes, the following rules apply:
        # 
        # - You can only use the AND operator for joining selectors.
        # - You can only use direct equality comparison operator (=) without any
        # functions for each selector.
        # - You can specify the metric in both the filter string and in the metric field.
        # However, if specified in both places, the metric must be identical.
        # - The monitored resource type determines what kind of values are expected for
        # the metric. If it is a gce_instance, the autoscaler expects the metric to
        # include a separate TimeSeries for each instance in a group. In such a case,
        # you cannot filter on resource labels.
        # If the resource type is any other value, the autoscaler expects this metric to
        # contain values that apply to the entire autoscaled instance group and resource
        # label filtering can be performed to point autoscaler at the correct TimeSeries
        # to scale upon. This is called a per-group metric for the purpose of
        # autoscaling.
        # If not specified, the type defaults to gce_instance.
        # You should provide a filter that is selective enough to pick just one
        # TimeSeries for the autoscaled group or for each of the instances (if you are
        # using gce_instance resource type). If multiple TimeSeries are returned upon
        # the query execution, the autoscaler will sum their respective values to obtain
        # its scaling value.
        # Corresponds to the JSON property `filter`
        # @return [String]
        attr_accessor :filter
      
        # The identifier (type) of the Stackdriver Monitoring metric. The metric cannot
        # have negative values.
        # The metric must have a value type of INT64 or DOUBLE.
        # Corresponds to the JSON property `metric`
        # @return [String]
        attr_accessor :metric
      
        # If scaling is based on a per-group metric value that represents the total
        # amount of work to be done or resource usage, set this value to an amount
        # assigned for a single instance of the scaled group. Autoscaler will keep the
        # number of instances proportional to the value of this metric, the metric
        # itself should not change value due to group resizing.
        # A good metric to use with the target is for example pubsub.googleapis.com/
        # subscription/num_undelivered_messages or a custom metric exporting the total
        # number of requests coming to your instances.
        # A bad example would be a metric exporting an average or median latency, since
        # this value can't include a chunk assignable to a single instance, it could be
        # better used with utilization_target instead.
        # Corresponds to the JSON property `singleInstanceAssignment`
        # @return [Float]
        attr_accessor :single_instance_assignment
      
        # The target value of the metric that autoscaler should maintain. This must be a
        # positive value. A utilization metric scales number of virtual machines
        # handling requests to increase or decrease proportionally to the metric.
        # For example, a good metric to use as a utilization_target is compute.
        # googleapis.com/instance/network/received_bytes_count. The autoscaler will work
        # to keep this value constant for each of the instances.
        # Corresponds to the JSON property `utilizationTarget`
        # @return [Float]
        attr_accessor :utilization_target
      
        # Defines how target utilization value is expressed for a Stackdriver Monitoring
        # metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE.
        # Corresponds to the JSON property `utilizationTargetType`
        # @return [String]
        attr_accessor :utilization_target_type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @filter = args[:filter] if args.key?(:filter)
          @metric = args[:metric] if args.key?(:metric)
          @single_instance_assignment = args[:single_instance_assignment] if args.key?(:single_instance_assignment)
          @utilization_target = args[:utilization_target] if args.key?(:utilization_target)
          @utilization_target_type = args[:utilization_target_type] if args.key?(:utilization_target_type)
        end
      end
      
      # Configuration parameters of autoscaling based on load balancing.
      class AutoscalingPolicyLoadBalancingUtilization
        include Google::Apis::Core::Hashable
      
        # Fraction of backend capacity utilization (set in HTTP(S) load balancing
        # configuration) that autoscaler should maintain. Must be a positive float value.
        # If not defined, the default is 0.8.
        # Corresponds to the JSON property `utilizationTarget`
        # @return [Float]
        attr_accessor :utilization_target
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @utilization_target = args[:utilization_target] if args.key?(:utilization_target)
        end
      end
      
      # Message containing information of one individual backend.
      class Backend
        include Google::Apis::Core::Hashable
      
        # Specifies the balancing mode for the backend.
        # When choosing a balancing mode, you need to consider the loadBalancingScheme,
        # and protocol for the backend service, as well as the type of backend (instance
        # group or NEG).
        # 
        # - If the load balancing mode is CONNECTION, then the load is spread based on
        # how many concurrent connections the backend can handle.
        # You can use the CONNECTION balancing mode if the protocol for the backend
        # service is SSL, TCP, or UDP.
        # If the loadBalancingScheme for the backend service is EXTERNAL (SSL Proxy and
        # TCP Proxy load balancers), you must also specify exactly one of the following
        # parameters: maxConnections, maxConnectionsPerInstance, or
        # maxConnectionsPerEndpoint.
        # If the loadBalancingScheme for the backend service is INTERNAL (internal TCP/
        # UDP load balancers), you cannot specify any additional parameters.
        # 
        # - If the load balancing mode is RATE, the load is spread based on the rate of
        # HTTP requests per second (RPS).
        # You can use the RATE balancing mode if the protocol for the backend service is
        # HTTP or HTTPS. You must specify exactly one of the following parameters:
        # maxRate, maxRatePerInstance, or maxRatePerEndpoint.
        # 
        # - If the load balancing mode is UTILIZATION, the load is spread based on the
        # CPU utilization of instances in an instance group.
        # You can use the UTILIZATION balancing mode if the loadBalancingScheme of the
        # backend service is EXTERNAL, INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED and
        # the backends are instance groups. There are no restrictions on the backend
        # service protocol.
        # Corresponds to the JSON property `balancingMode`
        # @return [String]
        attr_accessor :balancing_mode
      
        # A multiplier applied to the group's maximum servicing capacity (based on
        # UTILIZATION, RATE or CONNECTION). Default value is 1, which means the group
        # will serve up to 100% of its configured capacity (depending on balancingMode).
        # A setting of 0 means the group is completely drained, offering 0% of its
        # available Capacity. Valid range is [0.0,1.0].
        # This cannot be used for internal load balancing.
        # Corresponds to the JSON property `capacityScaler`
        # @return [Float]
        attr_accessor :capacity_scaler
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # This field designates whether this is a failover backend. More than one
        # failover backend can be configured for a given BackendService.
        # Corresponds to the JSON property `failover`
        # @return [Boolean]
        attr_accessor :failover
        alias_method :failover?, :failover
      
        # The fully-qualified URL of an instance group or network endpoint group (NEG)
        # resource. The type of backend that a backend service supports depends on the
        # backend service's loadBalancingScheme.
        # 
        # - When the loadBalancingScheme for the backend service is EXTERNAL,
        # INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, the backend can be either an
        # instance group or a NEG. The backends on the backend service must be either
        # all instance groups or all NEGs. You cannot mix instance group and NEG
        # backends on the same backend service.
        # - When the loadBalancingScheme for the backend service is INTERNAL, the
        # backend must be an instance group in the same region as the backend service.
        # NEGs are not supported.
        # You must use the fully-qualified URL (starting with https://www.googleapis.com/
        # ) to specify the instance group or NEG. Partial URLs are not supported.
        # Corresponds to the JSON property `group`
        # @return [String]
        attr_accessor :group
      
        # Defines a maximum target for simultaneous connections for the entire backend (
        # instance group or NEG). If the backend's balancingMode is UTILIZATION, this is
        # an optional parameter. If the backend's balancingMode is CONNECTION, and
        # backend is attached to a backend service whose loadBalancingScheme is EXTERNAL,
        # you must specify either this parameter, maxConnectionsPerInstance, or
        # maxConnectionsPerEndpoint.
        # Not available if the backend's balancingMode is RATE. If the
        # loadBalancingScheme is INTERNAL, then maxConnections is not supported, even
        # though the backend requires a balancing mode of CONNECTION.
        # Corresponds to the JSON property `maxConnections`
        # @return [Fixnum]
        attr_accessor :max_connections
      
        # Defines a maximum target for simultaneous connections for an endpoint of a NEG.
        # This is multiplied by the number of endpoints in the NEG to implicitly
        # calculate a maximum number of target maximum simultaneous connections for the
        # NEG. If the backend's balancingMode is CONNECTION, and the backend is attached
        # to a backend service whose loadBalancingScheme is EXTERNAL, you must specify
        # either this parameter, maxConnections, or maxConnectionsPerInstance.
        # Not available if the backend's balancingMode is RATE. Internal TCP/UDP load
        # balancing does not support setting maxConnectionsPerEndpoint even though its
        # backends require a balancing mode of CONNECTION.
        # Corresponds to the JSON property `maxConnectionsPerEndpoint`
        # @return [Fixnum]
        attr_accessor :max_connections_per_endpoint
      
        # Defines a maximum target for simultaneous connections for a single VM in a
        # backend instance group. This is multiplied by the number of instances in the
        # instance group to implicitly calculate a target maximum number of simultaneous
        # connections for the whole instance group. If the backend's balancingMode is
        # UTILIZATION, this is an optional parameter. If the backend's balancingMode is
        # CONNECTION, and backend is attached to a backend service whose
        # loadBalancingScheme is EXTERNAL, you must specify either this parameter,
        # maxConnections, or maxConnectionsPerEndpoint.
        # Not available if the backend's balancingMode is RATE. Internal TCP/UDP load
        # balancing does not support setting maxConnectionsPerInstance even though its
        # backends require a balancing mode of CONNECTION.
        # Corresponds to the JSON property `maxConnectionsPerInstance`
        # @return [Fixnum]
        attr_accessor :max_connections_per_instance
      
        # The max requests per second (RPS) of the group. Can be used with either RATE
        # or UTILIZATION balancing modes, but required if RATE mode. For RATE mode,
        # either maxRate or maxRatePerInstance must be set.
        # This cannot be used for internal load balancing.
        # Corresponds to the JSON property `maxRate`
        # @return [Fixnum]
        attr_accessor :max_rate
      
        # Defines a maximum target for requests per second (RPS) for an endpoint of a
        # NEG. This is multiplied by the number of endpoints in the NEG to implicitly
        # calculate a target maximum rate for the NEG.
        # If the backend's balancingMode is RATE, you must specify either this parameter,
        # maxRate, or maxRatePerInstance.
        # Not available if the backend's balancingMode is CONNECTION.
        # Corresponds to the JSON property `maxRatePerEndpoint`
        # @return [Float]
        attr_accessor :max_rate_per_endpoint
      
        # Defines a maximum target for requests per second (RPS) for a single VM in a
        # backend instance group. This is multiplied by the number of instances in the
        # instance group to implicitly calculate a target maximum rate for the whole
        # instance group.
        # If the backend's balancingMode is UTILIZATION, this is an optional parameter.
        # If the backend's balancingMode is RATE, you must specify either this parameter,
        # maxRate, or maxRatePerEndpoint.
        # Not available if the backend's balancingMode is CONNECTION.
        # Corresponds to the JSON property `maxRatePerInstance`
        # @return [Float]
        attr_accessor :max_rate_per_instance
      
        # Defines the maximum average CPU utilization of a backend VM in an instance
        # group. The valid range is [0.0, 1.0]. This is an optional parameter if the
        # backend's balancingMode is UTILIZATION.
        # This parameter can be used in conjunction with maxRate, maxRatePerInstance,
        # maxConnections, or maxConnectionsPerInstance.
        # Corresponds to the JSON property `maxUtilization`
        # @return [Float]
        attr_accessor :max_utilization
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @balancing_mode = args[:balancing_mode] if args.key?(:balancing_mode)
          @capacity_scaler = args[:capacity_scaler] if args.key?(:capacity_scaler)
          @description = args[:description] if args.key?(:description)
          @failover = args[:failover] if args.key?(:failover)
          @group = args[:group] if args.key?(:group)
          @max_connections = args[:max_connections] if args.key?(:max_connections)
          @max_connections_per_endpoint = args[:max_connections_per_endpoint] if args.key?(:max_connections_per_endpoint)
          @max_connections_per_instance = args[:max_connections_per_instance] if args.key?(:max_connections_per_instance)
          @max_rate = args[:max_rate] if args.key?(:max_rate)
          @max_rate_per_endpoint = args[:max_rate_per_endpoint] if args.key?(:max_rate_per_endpoint)
          @max_rate_per_instance = args[:max_rate_per_instance] if args.key?(:max_rate_per_instance)
          @max_utilization = args[:max_utilization] if args.key?(:max_utilization)
        end
      end
      
      # Represents a Cloud Storage Bucket resource.
      # This Cloud Storage bucket resource is referenced by a URL map of a load
      # balancer. For more information, read Backend Buckets.
      class BackendBucket
        include Google::Apis::Core::Hashable
      
        # Cloud Storage bucket name.
        # Corresponds to the JSON property `bucketName`
        # @return [String]
        attr_accessor :bucket_name
      
        # Message containing Cloud CDN configuration for a backend bucket.
        # Corresponds to the JSON property `cdnPolicy`
        # @return [Google::Apis::ComputeBeta::BackendBucketCdnPolicy]
        attr_accessor :cdn_policy
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional textual description of the resource; provided by the client when
        # the resource is created.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # If true, enable Cloud CDN for this BackendBucket.
        # Corresponds to the JSON property `enableCdn`
        # @return [Boolean]
        attr_accessor :enable_cdn
        alias_method :enable_cdn?, :enable_cdn
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Type of the resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Name of the resource. Provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter,
        # and all following characters must be a dash, lowercase letter, or digit,
        # except the last character, which cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @bucket_name = args[:bucket_name] if args.key?(:bucket_name)
          @cdn_policy = args[:cdn_policy] if args.key?(:cdn_policy)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @enable_cdn = args[:enable_cdn] if args.key?(:enable_cdn)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @self_link = args[:self_link] if args.key?(:self_link)
        end
      end
      
      # Message containing Cloud CDN configuration for a backend bucket.
      class BackendBucketCdnPolicy
        include Google::Apis::Core::Hashable
      
        # Maximum number of seconds the response to a signed URL request will be
        # considered fresh. After this time period, the response will be revalidated
        # before being served. Defaults to 1hr (3600s). When serving responses to signed
        # URL requests, Cloud CDN will internally behave as though all responses from
        # this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless
        # of any existing Cache-Control header. The actual headers served in responses
        # will not be altered.
        # Corresponds to the JSON property `signedUrlCacheMaxAgeSec`
        # @return [Fixnum]
        attr_accessor :signed_url_cache_max_age_sec
      
        # [Output Only] Names of the keys for signing request URLs.
        # Corresponds to the JSON property `signedUrlKeyNames`
        # @return [Array<String>]
        attr_accessor :signed_url_key_names
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @signed_url_cache_max_age_sec = args[:signed_url_cache_max_age_sec] if args.key?(:signed_url_cache_max_age_sec)
          @signed_url_key_names = args[:signed_url_key_names] if args.key?(:signed_url_key_names)
        end
      end
      
      # Contains a list of BackendBucket resources.
      class BackendBucketList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of BackendBucket resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::BackendBucket>]
        attr_accessor :items
      
        # Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::BackendBucketList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::BackendBucketList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Represents a Backend Service resource.
      # Backend services must have an associated health check. Backend services also
      # store information about session affinity. For more information, read Backend
      # Services.
      # A backendServices resource represents a global backend service. Global backend
      # services are used for HTTP(S), SSL Proxy, TCP Proxy load balancing and Traffic
      # Director.
      # A regionBackendServices resource represents a regional backend service.
      # Regional backend services are used for internal TCP/UDP load balancing. For
      # more information, read Internal TCP/UDP Load balancing. (== resource_for v1.
      # backendService ==) (== resource_for beta.backendService ==)
      class BackendService
        include Google::Apis::Core::Hashable
      
        # If set to 0, the cookie is non-persistent and lasts only until the end of the
        # browser session (or equivalent). The maximum allowed value is one day (86,400).
        # Corresponds to the JSON property `affinityCookieTtlSec`
        # @return [Fixnum]
        attr_accessor :affinity_cookie_ttl_sec
      
        # The list of backends that serve this BackendService.
        # Corresponds to the JSON property `backends`
        # @return [Array<Google::Apis::ComputeBeta::Backend>]
        attr_accessor :backends
      
        # Message containing Cloud CDN configuration for a backend service.
        # Corresponds to the JSON property `cdnPolicy`
        # @return [Google::Apis::ComputeBeta::BackendServiceCdnPolicy]
        attr_accessor :cdn_policy
      
        # Settings controlling the volume of connections to a backend service.
        # Corresponds to the JSON property `circuitBreakers`
        # @return [Google::Apis::ComputeBeta::CircuitBreakers]
        attr_accessor :circuit_breakers
      
        # Message containing connection draining configuration.
        # Corresponds to the JSON property `connectionDraining`
        # @return [Google::Apis::ComputeBeta::ConnectionDraining]
        attr_accessor :connection_draining
      
        # This message defines settings for a consistent hash style load balancer.
        # Corresponds to the JSON property `consistentHash`
        # @return [Google::Apis::ComputeBeta::ConsistentHashLoadBalancerSettings]
        attr_accessor :consistent_hash
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # Headers that the HTTP/S load balancer should add to proxied requests.
        # Corresponds to the JSON property `customRequestHeaders`
        # @return [Array<String>]
        attr_accessor :custom_request_headers
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # If true, enables Cloud CDN for the backend service. Only applicable if the
        # loadBalancingScheme is EXTERNAL and the protocol is HTTP or HTTPS.
        # Corresponds to the JSON property `enableCDN`
        # @return [Boolean]
        attr_accessor :enable_cdn
        alias_method :enable_cdn?, :enable_cdn
      
        # Applicable only to Failover for Internal TCP/UDP Load Balancing. Requires at
        # least one backend instance group to be defined as a backup (failover) backend.
        # Corresponds to the JSON property `failoverPolicy`
        # @return [Google::Apis::ComputeBeta::BackendServiceFailoverPolicy]
        attr_accessor :failover_policy
      
        # Fingerprint of this resource. A hash of the contents stored in this object.
        # This field is used in optimistic locking. This field will be ignored when
        # inserting a BackendService. An up-to-date fingerprint must be provided in
        # order to update the BackendService, otherwise the request will fail with error
        # 412 conditionNotMet.
        # To see the latest fingerprint, make a get() request to retrieve a
        # BackendService.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # The list of URLs to the HttpHealthCheck or HttpsHealthCheck resource for
        # health checking this BackendService. Currently at most one health check can be
        # specified, and a health check is required for Compute Engine backend services.
        # A health check must not be specified for App Engine backend and Cloud Function
        # backend.
        # For internal load balancing, a URL to a HealthCheck resource must be specified
        # instead.
        # Corresponds to the JSON property `healthChecks`
        # @return [Array<String>]
        attr_accessor :health_checks
      
        # Identity-Aware Proxy
        # Corresponds to the JSON property `iap`
        # @return [Google::Apis::ComputeBeta::BackendServiceIap]
        attr_accessor :iap
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Type of resource. Always compute#backendService for backend
        # services.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Indicates whether the backend service will be used with internal or external
        # load balancing. A backend service created for one type of load balancing
        # cannot be used with the other. Possible values are INTERNAL and EXTERNAL.
        # Corresponds to the JSON property `loadBalancingScheme`
        # @return [String]
        attr_accessor :load_balancing_scheme
      
        # The load balancing algorithm used within the scope of the locality. The
        # possible values are:
        # - ROUND_ROBIN: This is a simple policy in which each healthy backend is
        # selected in round robin order. This is the default.
        # - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and
        # picks the host which has fewer active requests.
        # - RING_HASH: The ring/modulo hash load balancer implements consistent hashing
        # to backends. The algorithm has the property that the addition/removal of a
        # host from a set of N hosts only affects 1/N of the requests.
        # - RANDOM: The load balancer selects a random healthy host.
        # - ORIGINAL_DESTINATION: Backend host is selected based on the client
        # connection metadata, i.e., connections are opened to the same address as the
        # destination address of the incoming connection before the connection was
        # redirected to the load balancer.
        # - MAGLEV: used as a drop in replacement for the ring hash load balancer.
        # Maglev is not as stable as ring hash but has faster table lookup build times
        # and host selection times. For more information about Maglev, refer to https://
        # ai.google/research/pubs/pub44824
        # This field is applicable to either:
        # - A regional backend service with the service_protocol set to HTTP, HTTPS, or
        # HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
        # - A global backend service with the load_balancing_scheme set to
        # INTERNAL_SELF_MANAGED.
        # Corresponds to the JSON property `localityLbPolicy`
        # @return [String]
        attr_accessor :locality_lb_policy
      
        # The available logging options for the load balancer traffic served by this
        # backend service.
        # Corresponds to the JSON property `logConfig`
        # @return [Google::Apis::ComputeBeta::BackendServiceLogConfig]
        attr_accessor :log_config
      
        # Name of the resource. Provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter,
        # and all following characters must be a dash, lowercase letter, or digit,
        # except the last character, which cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The URL of the network to which this backend service belongs. This field can
        # only be spcified when the load balancing scheme is set to INTERNAL.
        # Corresponds to the JSON property `network`
        # @return [String]
        attr_accessor :network
      
        # Settings controlling eviction of unhealthy hosts from the load balancing pool.
        # Corresponds to the JSON property `outlierDetection`
        # @return [Google::Apis::ComputeBeta::OutlierDetection]
        attr_accessor :outlier_detection
      
        # Deprecated in favor of portName. The TCP port to connect on the backend. The
        # default value is 80.
        # This cannot be used if the loadBalancingScheme is INTERNAL (Internal TCP/UDP
        # Load Balancing).
        # Corresponds to the JSON property `port`
        # @return [Fixnum]
        attr_accessor :port
      
        # A named port on a backend instance group representing the port for
        # communication to the backend VMs in that group. Required when the
        # loadBalancingScheme is EXTERNAL and the backends are instance groups. The
        # named port must be defined on each backend instance group. This parameter has
        # no meaning if the backends are NEGs.
        # Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP
        # Load Blaancing).
        # Corresponds to the JSON property `portName`
        # @return [String]
        attr_accessor :port_name
      
        # The protocol this BackendService uses to communicate with backends.
        # Possible values are HTTP, HTTPS, TCP, SSL, or UDP, depending on the chosen
        # load balancer or Traffic Director configuration. Refer to the documentation
        # for the load balancer or for Traffic director for more information.
        # Corresponds to the JSON property `protocol`
        # @return [String]
        attr_accessor :protocol
      
        # [Output Only] URL of the region where the regional backend service resides.
        # This field is not applicable to global backend services. You must specify this
        # field as part of the HTTP request URL. It is not settable as a field in the
        # request body.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # [Output Only] The resource URL for the security policy associated with this
        # backend service.
        # Corresponds to the JSON property `securityPolicy`
        # @return [String]
        attr_accessor :security_policy
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Type of session affinity to use. The default is NONE. Session affinity is not
        # applicable if the --protocol is UDP.
        # When the loadBalancingScheme is EXTERNAL, possible values are NONE, CLIENT_IP,
        # or GENERATED_COOKIE. You can use GENERATED_COOKIE if the protocol is HTTP or
        # HTTPS.
        # When the loadBalancingScheme is INTERNAL, possible values are NONE, CLIENT_IP,
        # CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.
        # When the loadBalancingScheme is INTERNAL_SELF_MANAGED, possible values are
        # NONE, CLIENT_IP, GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.
        # Corresponds to the JSON property `sessionAffinity`
        # @return [String]
        attr_accessor :session_affinity
      
        # The backend service timeout has a different meaning depending on the type of
        # load balancer. For more information read,  Backend service settings The
        # default is 30 seconds.
        # Corresponds to the JSON property `timeoutSec`
        # @return [Fixnum]
        attr_accessor :timeout_sec
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @affinity_cookie_ttl_sec = args[:affinity_cookie_ttl_sec] if args.key?(:affinity_cookie_ttl_sec)
          @backends = args[:backends] if args.key?(:backends)
          @cdn_policy = args[:cdn_policy] if args.key?(:cdn_policy)
          @circuit_breakers = args[:circuit_breakers] if args.key?(:circuit_breakers)
          @connection_draining = args[:connection_draining] if args.key?(:connection_draining)
          @consistent_hash = args[:consistent_hash] if args.key?(:consistent_hash)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @custom_request_headers = args[:custom_request_headers] if args.key?(:custom_request_headers)
          @description = args[:description] if args.key?(:description)
          @enable_cdn = args[:enable_cdn] if args.key?(:enable_cdn)
          @failover_policy = args[:failover_policy] if args.key?(:failover_policy)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @health_checks = args[:health_checks] if args.key?(:health_checks)
          @iap = args[:iap] if args.key?(:iap)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @load_balancing_scheme = args[:load_balancing_scheme] if args.key?(:load_balancing_scheme)
          @locality_lb_policy = args[:locality_lb_policy] if args.key?(:locality_lb_policy)
          @log_config = args[:log_config] if args.key?(:log_config)
          @name = args[:name] if args.key?(:name)
          @network = args[:network] if args.key?(:network)
          @outlier_detection = args[:outlier_detection] if args.key?(:outlier_detection)
          @port = args[:port] if args.key?(:port)
          @port_name = args[:port_name] if args.key?(:port_name)
          @protocol = args[:protocol] if args.key?(:protocol)
          @region = args[:region] if args.key?(:region)
          @security_policy = args[:security_policy] if args.key?(:security_policy)
          @self_link = args[:self_link] if args.key?(:self_link)
          @session_affinity = args[:session_affinity] if args.key?(:session_affinity)
          @timeout_sec = args[:timeout_sec] if args.key?(:timeout_sec)
        end
      end
      
      # Contains a list of BackendServicesScopedList.
      class BackendServiceAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of BackendServicesScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::BackendServicesScopedList>]
        attr_accessor :items
      
        # Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::BackendServiceAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::BackendServiceAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Message containing Cloud CDN configuration for a backend service.
      class BackendServiceCdnPolicy
        include Google::Apis::Core::Hashable
      
        # Message containing what to include in the cache key for a request for Cloud
        # CDN.
        # Corresponds to the JSON property `cacheKeyPolicy`
        # @return [Google::Apis::ComputeBeta::CacheKeyPolicy]
        attr_accessor :cache_key_policy
      
        # Maximum number of seconds the response to a signed URL request will be
        # considered fresh. After this time period, the response will be revalidated
        # before being served. Defaults to 1hr (3600s). When serving responses to signed
        # URL requests, Cloud CDN will internally behave as though all responses from
        # this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless
        # of any existing Cache-Control header. The actual headers served in responses
        # will not be altered.
        # Corresponds to the JSON property `signedUrlCacheMaxAgeSec`
        # @return [Fixnum]
        attr_accessor :signed_url_cache_max_age_sec
      
        # [Output Only] Names of the keys for signing request URLs.
        # Corresponds to the JSON property `signedUrlKeyNames`
        # @return [Array<String>]
        attr_accessor :signed_url_key_names
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @cache_key_policy = args[:cache_key_policy] if args.key?(:cache_key_policy)
          @signed_url_cache_max_age_sec = args[:signed_url_cache_max_age_sec] if args.key?(:signed_url_cache_max_age_sec)
          @signed_url_key_names = args[:signed_url_key_names] if args.key?(:signed_url_key_names)
        end
      end
      
      # 
      class BackendServiceFailoverPolicy
        include Google::Apis::Core::Hashable
      
        # This can be set to true only if the protocol is TCP.
        # The default is false.
        # Corresponds to the JSON property `disableConnectionDrainOnFailover`
        # @return [Boolean]
        attr_accessor :disable_connection_drain_on_failover
        alias_method :disable_connection_drain_on_failover?, :disable_connection_drain_on_failover
      
        # Applicable only to Failover for Internal TCP/UDP Load Balancing. If set to
        # true, connections to the load balancer are dropped when all primary and all
        # backup backend VMs are unhealthy. If set to false, connections are distributed
        # among all primary VMs when all primary and all backup backend VMs are
        # unhealthy.
        # The default is false.
        # Corresponds to the JSON property `dropTrafficIfUnhealthy`
        # @return [Boolean]
        attr_accessor :drop_traffic_if_unhealthy
        alias_method :drop_traffic_if_unhealthy?, :drop_traffic_if_unhealthy
      
        # Applicable only to Failover for Internal TCP/UDP Load Balancing. The value of
        # the field must be in the range [0, 1]. If the value is 0, the load balancer
        # performs a failover when the number of healthy primary VMs equals zero. For
        # all other values, the load balancer performs a failover when the total number
        # of healthy primary VMs is less than this ratio.
        # Corresponds to the JSON property `failoverRatio`
        # @return [Float]
        attr_accessor :failover_ratio
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @disable_connection_drain_on_failover = args[:disable_connection_drain_on_failover] if args.key?(:disable_connection_drain_on_failover)
          @drop_traffic_if_unhealthy = args[:drop_traffic_if_unhealthy] if args.key?(:drop_traffic_if_unhealthy)
          @failover_ratio = args[:failover_ratio] if args.key?(:failover_ratio)
        end
      end
      
      # 
      class BackendServiceGroupHealth
        include Google::Apis::Core::Hashable
      
        # Health state of the backend instances or endpoints in requested instance or
        # network endpoint group, determined based on configured health checks.
        # Corresponds to the JSON property `healthStatus`
        # @return [Array<Google::Apis::ComputeBeta::HealthStatus>]
        attr_accessor :health_status
      
        # [Output Only] Type of resource. Always compute#backendServiceGroupHealth for
        # the health of backend services.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @health_status = args[:health_status] if args.key?(:health_status)
          @kind = args[:kind] if args.key?(:kind)
        end
      end
      
      # Identity-Aware Proxy
      class BackendServiceIap
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `enabled`
        # @return [Boolean]
        attr_accessor :enabled
        alias_method :enabled?, :enabled
      
        # 
        # Corresponds to the JSON property `oauth2ClientId`
        # @return [String]
        attr_accessor :oauth2_client_id
      
        # 
        # Corresponds to the JSON property `oauth2ClientSecret`
        # @return [String]
        attr_accessor :oauth2_client_secret
      
        # [Output Only] SHA256 hash value for the field oauth2_client_secret above.
        # Corresponds to the JSON property `oauth2ClientSecretSha256`
        # @return [String]
        attr_accessor :oauth2_client_secret_sha256
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @enabled = args[:enabled] if args.key?(:enabled)
          @oauth2_client_id = args[:oauth2_client_id] if args.key?(:oauth2_client_id)
          @oauth2_client_secret = args[:oauth2_client_secret] if args.key?(:oauth2_client_secret)
          @oauth2_client_secret_sha256 = args[:oauth2_client_secret_sha256] if args.key?(:oauth2_client_secret_sha256)
        end
      end
      
      # Contains a list of BackendService resources.
      class BackendServiceList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of BackendService resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::BackendService>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#backendServiceList for lists of
        # backend services.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::BackendServiceList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::BackendServiceList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # The available logging options for the load balancer traffic served by this
      # backend service.
      class BackendServiceLogConfig
        include Google::Apis::Core::Hashable
      
        # This field denotes whether to enable logging for the load balancer traffic
        # served by this backend service.
        # Corresponds to the JSON property `enable`
        # @return [Boolean]
        attr_accessor :enable
        alias_method :enable?, :enable
      
        # This field can only be specified if logging is enabled for this backend
        # service. The value of the field must be in [0, 1]. This configures the
        # sampling rate of requests to the load balancer where 1.0 means all logged
        # requests are reported and 0.0 means no logged requests are reported. The
        # default value is 1.0.
        # Corresponds to the JSON property `sampleRate`
        # @return [Float]
        attr_accessor :sample_rate
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @enable = args[:enable] if args.key?(:enable)
          @sample_rate = args[:sample_rate] if args.key?(:sample_rate)
        end
      end
      
      # 
      class BackendServiceReference
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `backendService`
        # @return [String]
        attr_accessor :backend_service
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @backend_service = args[:backend_service] if args.key?(:backend_service)
        end
      end
      
      # 
      class BackendServicesScopedList
        include Google::Apis::Core::Hashable
      
        # A list of BackendServices contained in this scope.
        # Corresponds to the JSON property `backendServices`
        # @return [Array<Google::Apis::ComputeBeta::BackendService>]
        attr_accessor :backend_services
      
        # Informational warning which replaces the list of backend services when the
        # list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::BackendServicesScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @backend_services = args[:backend_services] if args.key?(:backend_services)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Informational warning which replaces the list of backend services when the
        # list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::BackendServicesScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class BfdPacket
        include Google::Apis::Core::Hashable
      
        # The Authentication Present bit of the BFD packet. This is specified in section
        # 4.1 of RFC5880
        # Corresponds to the JSON property `authenticationPresent`
        # @return [Boolean]
        attr_accessor :authentication_present
        alias_method :authentication_present?, :authentication_present
      
        # The Control Plane Independent bit of the BFD packet. This is specified in
        # section 4.1 of RFC5880
        # Corresponds to the JSON property `controlPlaneIndependent`
        # @return [Boolean]
        attr_accessor :control_plane_independent
        alias_method :control_plane_independent?, :control_plane_independent
      
        # The demand bit of the BFD packet. This is specified in section 4.1 of RFC5880
        # Corresponds to the JSON property `demand`
        # @return [Boolean]
        attr_accessor :demand
        alias_method :demand?, :demand
      
        # The diagnostic code specifies the local system's reason for the last change in
        # session state. This allows remote systems to determine the reason that the
        # previous session failed, for example. These diagnostic codes are specified in
        # section 4.1 of RFC5880
        # Corresponds to the JSON property `diagnostic`
        # @return [String]
        attr_accessor :diagnostic
      
        # The Final bit of the BFD packet. This is specified in section 4.1 of RFC5880
        # Corresponds to the JSON property `final`
        # @return [Boolean]
        attr_accessor :final
        alias_method :final?, :final
      
        # The length of the BFD Control packet in bytes. This is specified in section 4.
        # 1 of RFC5880
        # Corresponds to the JSON property `length`
        # @return [Fixnum]
        attr_accessor :length
      
        # The Required Min Echo RX Interval value in the BFD packet. This is specified
        # in section 4.1 of RFC5880
        # Corresponds to the JSON property `minEchoRxIntervalMs`
        # @return [Fixnum]
        attr_accessor :min_echo_rx_interval_ms
      
        # The Required Min RX Interval value in the BFD packet. This is specified in
        # section 4.1 of RFC5880
        # Corresponds to the JSON property `minRxIntervalMs`
        # @return [Fixnum]
        attr_accessor :min_rx_interval_ms
      
        # The Desired Min TX Interval value in the BFD packet. This is specified in
        # section 4.1 of RFC5880
        # Corresponds to the JSON property `minTxIntervalMs`
        # @return [Fixnum]
        attr_accessor :min_tx_interval_ms
      
        # The detection time multiplier of the BFD packet. This is specified in section
        # 4.1 of RFC5880
        # Corresponds to the JSON property `multiplier`
        # @return [Fixnum]
        attr_accessor :multiplier
      
        # The multipoint bit of the BFD packet. This is specified in section 4.1 of
        # RFC5880
        # Corresponds to the JSON property `multipoint`
        # @return [Boolean]
        attr_accessor :multipoint
        alias_method :multipoint?, :multipoint
      
        # The My Discriminator value in the BFD packet. This is specified in section 4.1
        # of RFC5880
        # Corresponds to the JSON property `myDiscriminator`
        # @return [Fixnum]
        attr_accessor :my_discriminator
      
        # The Poll bit of the BFD packet. This is specified in section 4.1 of RFC5880
        # Corresponds to the JSON property `poll`
        # @return [Boolean]
        attr_accessor :poll
        alias_method :poll?, :poll
      
        # The current BFD session state as seen by the transmitting system. These states
        # are specified in section 4.1 of RFC5880
        # Corresponds to the JSON property `state`
        # @return [String]
        attr_accessor :state
      
        # The version number of the BFD protocol, as specified in section 4.1 of RFC5880.
        # Corresponds to the JSON property `version`
        # @return [Fixnum]
        attr_accessor :version
      
        # The Your Discriminator value in the BFD packet. This is specified in section 4.
        # 1 of RFC5880
        # Corresponds to the JSON property `yourDiscriminator`
        # @return [Fixnum]
        attr_accessor :your_discriminator
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @authentication_present = args[:authentication_present] if args.key?(:authentication_present)
          @control_plane_independent = args[:control_plane_independent] if args.key?(:control_plane_independent)
          @demand = args[:demand] if args.key?(:demand)
          @diagnostic = args[:diagnostic] if args.key?(:diagnostic)
          @final = args[:final] if args.key?(:final)
          @length = args[:length] if args.key?(:length)
          @min_echo_rx_interval_ms = args[:min_echo_rx_interval_ms] if args.key?(:min_echo_rx_interval_ms)
          @min_rx_interval_ms = args[:min_rx_interval_ms] if args.key?(:min_rx_interval_ms)
          @min_tx_interval_ms = args[:min_tx_interval_ms] if args.key?(:min_tx_interval_ms)
          @multiplier = args[:multiplier] if args.key?(:multiplier)
          @multipoint = args[:multipoint] if args.key?(:multipoint)
          @my_discriminator = args[:my_discriminator] if args.key?(:my_discriminator)
          @poll = args[:poll] if args.key?(:poll)
          @state = args[:state] if args.key?(:state)
          @version = args[:version] if args.key?(:version)
          @your_discriminator = args[:your_discriminator] if args.key?(:your_discriminator)
        end
      end
      
      # Next free: 15
      class BfdStatus
        include Google::Apis::Core::Hashable
      
        # The BFD session initialization mode for this BGP peer. If set to ACTIVE, the
        # Cloud Router will initiate the BFD session for this BGP peer. If set to
        # PASSIVE, the Cloud Router will wait for the peer router to initiate the BFD
        # session for this BGP peer. If set to DISABLED, BFD is disabled for this BGP
        # peer.
        # Corresponds to the JSON property `bfdSessionInitializationMode`
        # @return [String]
        attr_accessor :bfd_session_initialization_mode
      
        # Unix timestamp of the most recent config update.
        # Corresponds to the JSON property `configUpdateTimestampMicros`
        # @return [Fixnum]
        attr_accessor :config_update_timestamp_micros
      
        # Control packet counts for the current BFD session.
        # Corresponds to the JSON property `controlPacketCounts`
        # @return [Google::Apis::ComputeBeta::BfdStatusPacketCounts]
        attr_accessor :control_packet_counts
      
        # Inter-packet time interval statistics for control packets.
        # Corresponds to the JSON property `controlPacketIntervals`
        # @return [Array<Google::Apis::ComputeBeta::PacketIntervals>]
        attr_accessor :control_packet_intervals
      
        # The diagnostic code specifies the local system's reason for the last change in
        # session state. This allows remote systems to determine the reason that the
        # previous session failed, for example. These diagnostic codes are specified in
        # section 4.1 of RFC5880
        # Corresponds to the JSON property `localDiagnostic`
        # @return [String]
        attr_accessor :local_diagnostic
      
        # The current BFD session state as seen by the transmitting system. These states
        # are specified in section 4.1 of RFC5880
        # Corresponds to the JSON property `localState`
        # @return [String]
        attr_accessor :local_state
      
        # Negotiated transmit interval for control packets.
        # Corresponds to the JSON property `negotiatedLocalControlTxIntervalMs`
        # @return [Fixnum]
        attr_accessor :negotiated_local_control_tx_interval_ms
      
        # 
        # Corresponds to the JSON property `rxPacket`
        # @return [Google::Apis::ComputeBeta::BfdPacket]
        attr_accessor :rx_packet
      
        # 
        # Corresponds to the JSON property `txPacket`
        # @return [Google::Apis::ComputeBeta::BfdPacket]
        attr_accessor :tx_packet
      
        # Session uptime in milliseconds. Value will be 0 if session is not up.
        # Corresponds to the JSON property `uptimeMs`
        # @return [Fixnum]
        attr_accessor :uptime_ms
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @bfd_session_initialization_mode = args[:bfd_session_initialization_mode] if args.key?(:bfd_session_initialization_mode)
          @config_update_timestamp_micros = args[:config_update_timestamp_micros] if args.key?(:config_update_timestamp_micros)
          @control_packet_counts = args[:control_packet_counts] if args.key?(:control_packet_counts)
          @control_packet_intervals = args[:control_packet_intervals] if args.key?(:control_packet_intervals)
          @local_diagnostic = args[:local_diagnostic] if args.key?(:local_diagnostic)
          @local_state = args[:local_state] if args.key?(:local_state)
          @negotiated_local_control_tx_interval_ms = args[:negotiated_local_control_tx_interval_ms] if args.key?(:negotiated_local_control_tx_interval_ms)
          @rx_packet = args[:rx_packet] if args.key?(:rx_packet)
          @tx_packet = args[:tx_packet] if args.key?(:tx_packet)
          @uptime_ms = args[:uptime_ms] if args.key?(:uptime_ms)
        end
      end
      
      # 
      class BfdStatusPacketCounts
        include Google::Apis::Core::Hashable
      
        # Number of packets received since the beginning of the current BFD session.
        # Corresponds to the JSON property `numRx`
        # @return [Fixnum]
        attr_accessor :num_rx
      
        # Number of packets received that were rejected because of errors since the
        # beginning of the current BFD session.
        # Corresponds to the JSON property `numRxRejected`
        # @return [Fixnum]
        attr_accessor :num_rx_rejected
      
        # Number of packets received that were successfully processed since the
        # beginning of the current BFD session.
        # Corresponds to the JSON property `numRxSuccessful`
        # @return [Fixnum]
        attr_accessor :num_rx_successful
      
        # Number of packets transmitted since the beginning of the current BFD session.
        # Corresponds to the JSON property `numTx`
        # @return [Fixnum]
        attr_accessor :num_tx
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @num_rx = args[:num_rx] if args.key?(:num_rx)
          @num_rx_rejected = args[:num_rx_rejected] if args.key?(:num_rx_rejected)
          @num_rx_successful = args[:num_rx_successful] if args.key?(:num_rx_successful)
          @num_tx = args[:num_tx] if args.key?(:num_tx)
        end
      end
      
      # Associates `members` with a `role`.
      class Binding
        include Google::Apis::Core::Hashable
      
        # Represents an expression text. Example:
        # title: "User account presence" description: "Determines whether the request
        # has a user account" expression: "size(request.user) > 0"
        # Corresponds to the JSON property `condition`
        # @return [Google::Apis::ComputeBeta::Expr]
        attr_accessor :condition
      
        # Specifies the identities requesting access for a Cloud Platform resource. `
        # members` can have the following values:
        # * `allUsers`: A special identifier that represents anyone who is on the
        # internet; with or without a Google account.
        # * `allAuthenticatedUsers`: A special identifier that represents anyone who is
        # authenticated with a Google account or a service account.
        # * `user:`emailid``: An email address that represents a specific Google account.
        # For example, `alice@example.com` .
        # * `serviceAccount:`emailid``: An email address that represents a service
        # account. For example, `my-other-app@appspot.gserviceaccount.com`.
        # * `group:`emailid``: An email address that represents a Google group. For
        # example, `admins@example.com`.
        # * `domain:`domain``: The G Suite domain (primary) that represents all the
        # users of that domain. For example, `google.com` or `example.com`.
        # Corresponds to the JSON property `members`
        # @return [Array<String>]
        attr_accessor :members
      
        # Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`
        # , or `roles/owner`.
        # Corresponds to the JSON property `role`
        # @return [String]
        attr_accessor :role
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @condition = args[:condition] if args.key?(:condition)
          @members = args[:members] if args.key?(:members)
          @role = args[:role] if args.key?(:role)
        end
      end
      
      # 
      class CacheInvalidationRule
        include Google::Apis::Core::Hashable
      
        # If set, this invalidation rule will only apply to requests with a Host header
        # matching host.
        # Corresponds to the JSON property `host`
        # @return [String]
        attr_accessor :host
      
        # 
        # Corresponds to the JSON property `path`
        # @return [String]
        attr_accessor :path
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @host = args[:host] if args.key?(:host)
          @path = args[:path] if args.key?(:path)
        end
      end
      
      # Message containing what to include in the cache key for a request for Cloud
      # CDN.
      class CacheKeyPolicy
        include Google::Apis::Core::Hashable
      
        # If true, requests to different hosts will be cached separately.
        # Corresponds to the JSON property `includeHost`
        # @return [Boolean]
        attr_accessor :include_host
        alias_method :include_host?, :include_host
      
        # If true, http and https requests will be cached separately.
        # Corresponds to the JSON property `includeProtocol`
        # @return [Boolean]
        attr_accessor :include_protocol
        alias_method :include_protocol?, :include_protocol
      
        # If true, include query string parameters in the cache key according to
        # query_string_whitelist and query_string_blacklist. If neither is set, the
        # entire query string will be included. If false, the query string will be
        # excluded from the cache key entirely.
        # Corresponds to the JSON property `includeQueryString`
        # @return [Boolean]
        attr_accessor :include_query_string
        alias_method :include_query_string?, :include_query_string
      
        # Names of query string parameters to exclude in cache keys. All other
        # parameters will be included. Either specify query_string_whitelist or
        # query_string_blacklist, not both. '&' and '=' will be percent encoded and not
        # treated as delimiters.
        # Corresponds to the JSON property `queryStringBlacklist`
        # @return [Array<String>]
        attr_accessor :query_string_blacklist
      
        # Names of query string parameters to include in cache keys. All other
        # parameters will be excluded. Either specify query_string_whitelist or
        # query_string_blacklist, not both. '&' and '=' will be percent encoded and not
        # treated as delimiters.
        # Corresponds to the JSON property `queryStringWhitelist`
        # @return [Array<String>]
        attr_accessor :query_string_whitelist
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @include_host = args[:include_host] if args.key?(:include_host)
          @include_protocol = args[:include_protocol] if args.key?(:include_protocol)
          @include_query_string = args[:include_query_string] if args.key?(:include_query_string)
          @query_string_blacklist = args[:query_string_blacklist] if args.key?(:query_string_blacklist)
          @query_string_whitelist = args[:query_string_whitelist] if args.key?(:query_string_whitelist)
        end
      end
      
      # Settings controlling the volume of connections to a backend service.
      class CircuitBreakers
        include Google::Apis::Core::Hashable
      
        # A Duration represents a fixed-length span of time represented as a count of
        # seconds and fractions of seconds at nanosecond resolution. It is independent
        # of any calendar and concepts like "day" or "month". Range is approximately 10,
        # 000 years.
        # Corresponds to the JSON property `connectTimeout`
        # @return [Google::Apis::ComputeBeta::Duration]
        attr_accessor :connect_timeout
      
        # The maximum number of connections to the backend cluster. If not specified,
        # the default is 1024.
        # Corresponds to the JSON property `maxConnections`
        # @return [Fixnum]
        attr_accessor :max_connections
      
        # The maximum number of pending requests allowed to the backend cluster. If not
        # specified, the default is 1024.
        # Corresponds to the JSON property `maxPendingRequests`
        # @return [Fixnum]
        attr_accessor :max_pending_requests
      
        # The maximum number of parallel requests that allowed to the backend cluster.
        # If not specified, the default is 1024.
        # Corresponds to the JSON property `maxRequests`
        # @return [Fixnum]
        attr_accessor :max_requests
      
        # Maximum requests for a single backend connection. This parameter is respected
        # by both the HTTP/1.1 and HTTP/2 implementations. If not specified, there is no
        # limit. Setting this parameter to 1 will effectively disable keep alive.
        # Corresponds to the JSON property `maxRequestsPerConnection`
        # @return [Fixnum]
        attr_accessor :max_requests_per_connection
      
        # The maximum number of parallel retries allowed to the backend cluster. If not
        # specified, the default is 3.
        # Corresponds to the JSON property `maxRetries`
        # @return [Fixnum]
        attr_accessor :max_retries
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @connect_timeout = args[:connect_timeout] if args.key?(:connect_timeout)
          @max_connections = args[:max_connections] if args.key?(:max_connections)
          @max_pending_requests = args[:max_pending_requests] if args.key?(:max_pending_requests)
          @max_requests = args[:max_requests] if args.key?(:max_requests)
          @max_requests_per_connection = args[:max_requests_per_connection] if args.key?(:max_requests_per_connection)
          @max_retries = args[:max_retries] if args.key?(:max_retries)
        end
      end
      
      # Represents a regional Commitment resource.
      # Creating a commitment resource means that you are purchasing a committed use
      # contract with an explicit start and end time. You can create commitments based
      # on vCPUs and memory usage and receive discounted rates. For full details, read
      # Signing Up for Committed Use Discounts. (== resource_for beta.
      # regionCommitments ==) (== resource_for v1.regionCommitments ==)
      class Commitment
        include Google::Apis::Core::Hashable
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] Commitment end time in RFC3339 text format.
        # Corresponds to the JSON property `endTimestamp`
        # @return [String]
        attr_accessor :end_timestamp
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Type of the resource. Always compute#commitment for commitments.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Name of the resource. Provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter,
        # and all following characters must be a dash, lowercase letter, or digit,
        # except the last character, which cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The plan for this commitment, which determines duration and discount rate. The
        # currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3
        # years).
        # Corresponds to the JSON property `plan`
        # @return [String]
        attr_accessor :plan
      
        # [Output Only] URL of the region where this commitment may be used.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # List of reservations in this commitment.
        # Corresponds to the JSON property `reservations`
        # @return [Array<Google::Apis::ComputeBeta::Reservation>]
        attr_accessor :reservations
      
        # A list of commitment amounts for particular resources. Note that VCPU and
        # MEMORY resource commitments must occur together.
        # Corresponds to the JSON property `resources`
        # @return [Array<Google::Apis::ComputeBeta::ResourceCommitment>]
        attr_accessor :resources
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Commitment start time in RFC3339 text format.
        # Corresponds to the JSON property `startTimestamp`
        # @return [String]
        attr_accessor :start_timestamp
      
        # [Output Only] Status of the commitment with regards to eventual expiration (
        # each commitment has an end date defined). One of the following values:
        # NOT_YET_ACTIVE, ACTIVE, EXPIRED.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        # [Output Only] An optional, human-readable explanation of the status.
        # Corresponds to the JSON property `statusMessage`
        # @return [String]
        attr_accessor :status_message
      
        # The type of commitment, which affects the discount rate and the eligible
        # resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply
        # to memory optimized machines.
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @end_timestamp = args[:end_timestamp] if args.key?(:end_timestamp)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @plan = args[:plan] if args.key?(:plan)
          @region = args[:region] if args.key?(:region)
          @reservations = args[:reservations] if args.key?(:reservations)
          @resources = args[:resources] if args.key?(:resources)
          @self_link = args[:self_link] if args.key?(:self_link)
          @start_timestamp = args[:start_timestamp] if args.key?(:start_timestamp)
          @status = args[:status] if args.key?(:status)
          @status_message = args[:status_message] if args.key?(:status_message)
          @type = args[:type] if args.key?(:type)
        end
      end
      
      # 
      class CommitmentAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of CommitmentsScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::CommitmentsScopedList>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#commitmentAggregatedList for
        # aggregated lists of commitments.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::CommitmentAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::CommitmentAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of Commitment resources.
      class CommitmentList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Commitment resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::Commitment>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#commitmentList for lists of
        # commitments.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::CommitmentList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::CommitmentList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class CommitmentsScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] A list of commitments contained in this scope.
        # Corresponds to the JSON property `commitments`
        # @return [Array<Google::Apis::ComputeBeta::Commitment>]
        attr_accessor :commitments
      
        # [Output Only] Informational warning which replaces the list of commitments
        # when the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::CommitmentsScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @commitments = args[:commitments] if args.key?(:commitments)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning which replaces the list of commitments
        # when the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::CommitmentsScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # A condition to be met.
      class Condition
        include Google::Apis::Core::Hashable
      
        # Trusted attributes supplied by the IAM system.
        # Corresponds to the JSON property `iam`
        # @return [String]
        attr_accessor :iam
      
        # An operator to apply the subject with.
        # Corresponds to the JSON property `op`
        # @return [String]
        attr_accessor :op
      
        # Trusted attributes discharged by the service.
        # Corresponds to the JSON property `svc`
        # @return [String]
        attr_accessor :svc
      
        # Trusted attributes supplied by any service that owns resources and uses the
        # IAM system for access control.
        # Corresponds to the JSON property `sys`
        # @return [String]
        attr_accessor :sys
      
        # The objects of the condition.
        # Corresponds to the JSON property `values`
        # @return [Array<String>]
        attr_accessor :values
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @iam = args[:iam] if args.key?(:iam)
          @op = args[:op] if args.key?(:op)
          @svc = args[:svc] if args.key?(:svc)
          @sys = args[:sys] if args.key?(:sys)
          @values = args[:values] if args.key?(:values)
        end
      end
      
      # Message containing connection draining configuration.
      class ConnectionDraining
        include Google::Apis::Core::Hashable
      
        # The amount of time in seconds to allow existing connections to persist while
        # on unhealthy backend VMs. Only applicable if the protocol is not UDP. The
        # valid range is [0, 3600].
        # Corresponds to the JSON property `drainingTimeoutSec`
        # @return [Fixnum]
        attr_accessor :draining_timeout_sec
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @draining_timeout_sec = args[:draining_timeout_sec] if args.key?(:draining_timeout_sec)
        end
      end
      
      # This message defines settings for a consistent hash style load balancer.
      class ConsistentHashLoadBalancerSettings
        include Google::Apis::Core::Hashable
      
        # The information about the HTTP Cookie on which the hash function is based for
        # load balancing policies that use a consistent hash.
        # Corresponds to the JSON property `httpCookie`
        # @return [Google::Apis::ComputeBeta::ConsistentHashLoadBalancerSettingsHttpCookie]
        attr_accessor :http_cookie
      
        # The hash based on the value of the specified header field. This field is
        # applicable if the sessionAffinity is set to HEADER_FIELD.
        # Corresponds to the JSON property `httpHeaderName`
        # @return [String]
        attr_accessor :http_header_name
      
        # The minimum number of virtual nodes to use for the hash ring. Defaults to 1024.
        # Larger ring sizes result in more granular load distributions. If the number
        # of hosts in the load balancing pool is larger than the ring size, each host
        # will be assigned a single virtual node.
        # Corresponds to the JSON property `minimumRingSize`
        # @return [Fixnum]
        attr_accessor :minimum_ring_size
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @http_cookie = args[:http_cookie] if args.key?(:http_cookie)
          @http_header_name = args[:http_header_name] if args.key?(:http_header_name)
          @minimum_ring_size = args[:minimum_ring_size] if args.key?(:minimum_ring_size)
        end
      end
      
      # The information about the HTTP Cookie on which the hash function is based for
      # load balancing policies that use a consistent hash.
      class ConsistentHashLoadBalancerSettingsHttpCookie
        include Google::Apis::Core::Hashable
      
        # Name of the cookie.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Path to set for the cookie.
        # Corresponds to the JSON property `path`
        # @return [String]
        attr_accessor :path
      
        # A Duration represents a fixed-length span of time represented as a count of
        # seconds and fractions of seconds at nanosecond resolution. It is independent
        # of any calendar and concepts like "day" or "month". Range is approximately 10,
        # 000 years.
        # Corresponds to the JSON property `ttl`
        # @return [Google::Apis::ComputeBeta::Duration]
        attr_accessor :ttl
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @name = args[:name] if args.key?(:name)
          @path = args[:path] if args.key?(:path)
          @ttl = args[:ttl] if args.key?(:ttl)
        end
      end
      
      # The specification for allowing client side cross-origin requests. Please see
      # W3C Recommendation for Cross Origin Resource Sharing
      class CorsPolicy
        include Google::Apis::Core::Hashable
      
        # In response to a preflight request, setting this to true indicates that the
        # actual request can include user credentials. This translates to the Access-
        # Control-Allow-Credentials header.
        # Default is false.
        # Corresponds to the JSON property `allowCredentials`
        # @return [Boolean]
        attr_accessor :allow_credentials
        alias_method :allow_credentials?, :allow_credentials
      
        # Specifies the content for the Access-Control-Allow-Headers header.
        # Corresponds to the JSON property `allowHeaders`
        # @return [Array<String>]
        attr_accessor :allow_headers
      
        # Specifies the content for the Access-Control-Allow-Methods header.
        # Corresponds to the JSON property `allowMethods`
        # @return [Array<String>]
        attr_accessor :allow_methods
      
        # Specifies the regualar expression patterns that match allowed origins. For
        # regular expression grammar please see en.cppreference.com/w/cpp/regex/
        # ecmascript
        # An origin is allowed if it matches either allow_origins or allow_origin_regex.
        # Corresponds to the JSON property `allowOriginRegexes`
        # @return [Array<String>]
        attr_accessor :allow_origin_regexes
      
        # Specifies the list of origins that will be allowed to do CORS requests.
        # An origin is allowed if it matches either allow_origins or allow_origin_regex.
        # Corresponds to the JSON property `allowOrigins`
        # @return [Array<String>]
        attr_accessor :allow_origins
      
        # If true, specifies the CORS policy is disabled. The default value of false,
        # which indicates that the CORS policy is in effect.
        # Corresponds to the JSON property `disabled`
        # @return [Boolean]
        attr_accessor :disabled
        alias_method :disabled?, :disabled
      
        # Specifies the content for the Access-Control-Expose-Headers header.
        # Corresponds to the JSON property `exposeHeaders`
        # @return [Array<String>]
        attr_accessor :expose_headers
      
        # Specifies how long the results of a preflight request can be cached. This
        # translates to the content for the Access-Control-Max-Age header.
        # Corresponds to the JSON property `maxAge`
        # @return [Fixnum]
        attr_accessor :max_age
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @allow_credentials = args[:allow_credentials] if args.key?(:allow_credentials)
          @allow_headers = args[:allow_headers] if args.key?(:allow_headers)
          @allow_methods = args[:allow_methods] if args.key?(:allow_methods)
          @allow_origin_regexes = args[:allow_origin_regexes] if args.key?(:allow_origin_regexes)
          @allow_origins = args[:allow_origins] if args.key?(:allow_origins)
          @disabled = args[:disabled] if args.key?(:disabled)
          @expose_headers = args[:expose_headers] if args.key?(:expose_headers)
          @max_age = args[:max_age] if args.key?(:max_age)
        end
      end
      
      # Represents a customer-supplied encryption key
      class CustomerEncryptionKey
        include Google::Apis::Core::Hashable
      
        # The name of the encryption key that is stored in Google Cloud KMS.
        # Corresponds to the JSON property `kmsKeyName`
        # @return [String]
        attr_accessor :kms_key_name
      
        # Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648
        # base64 to either encrypt or decrypt this resource.
        # Corresponds to the JSON property `rawKey`
        # @return [String]
        attr_accessor :raw_key
      
        # Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit customer-supplied
        # encryption key to either encrypt or decrypt this resource.
        # The key must meet the following requirements before you can provide it to
        # Compute Engine:
        # - The key is wrapped using a RSA public key certificate provided by Google.
        # - After being wrapped, the key must be encoded in RFC 4648 base64 encoding.
        # Gets the RSA public key certificate provided by Google at:
        # https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem
        # Corresponds to the JSON property `rsaEncryptedKey`
        # @return [String]
        attr_accessor :rsa_encrypted_key
      
        # [Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-
        # supplied encryption key that protects this resource.
        # Corresponds to the JSON property `sha256`
        # @return [String]
        attr_accessor :sha256
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @kms_key_name = args[:kms_key_name] if args.key?(:kms_key_name)
          @raw_key = args[:raw_key] if args.key?(:raw_key)
          @rsa_encrypted_key = args[:rsa_encrypted_key] if args.key?(:rsa_encrypted_key)
          @sha256 = args[:sha256] if args.key?(:sha256)
        end
      end
      
      # 
      class CustomerEncryptionKeyProtectedDisk
        include Google::Apis::Core::Hashable
      
        # Represents a customer-supplied encryption key
        # Corresponds to the JSON property `diskEncryptionKey`
        # @return [Google::Apis::ComputeBeta::CustomerEncryptionKey]
        attr_accessor :disk_encryption_key
      
        # Specifies a valid partial or full URL to an existing Persistent Disk resource.
        # This field is only applicable for persistent disks.
        # Corresponds to the JSON property `source`
        # @return [String]
        attr_accessor :source
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @disk_encryption_key = args[:disk_encryption_key] if args.key?(:disk_encryption_key)
          @source = args[:source] if args.key?(:source)
        end
      end
      
      # Deprecation status for a public resource.
      class DeprecationStatus
        include Google::Apis::Core::Hashable
      
        # An optional RFC3339 timestamp on or after which the state of this resource is
        # intended to change to DELETED. This is only informational and the status will
        # not change unless the client explicitly changes it.
        # Corresponds to the JSON property `deleted`
        # @return [String]
        attr_accessor :deleted
      
        # An optional RFC3339 timestamp on or after which the state of this resource is
        # intended to change to DEPRECATED. This is only informational and the status
        # will not change unless the client explicitly changes it.
        # Corresponds to the JSON property `deprecated`
        # @return [String]
        attr_accessor :deprecated
      
        # An optional RFC3339 timestamp on or after which the state of this resource is
        # intended to change to OBSOLETE. This is only informational and the status will
        # not change unless the client explicitly changes it.
        # Corresponds to the JSON property `obsolete`
        # @return [String]
        attr_accessor :obsolete
      
        # The URL of the suggested replacement for a deprecated resource. The suggested
        # replacement resource must be the same kind of resource as the deprecated
        # resource.
        # Corresponds to the JSON property `replacement`
        # @return [String]
        attr_accessor :replacement
      
        # The deprecation state of this resource. This can be ACTIVE, DEPRECATED,
        # OBSOLETE, or DELETED. Operations which communicate the end of life date for an
        # image, can use ACTIVE. Operations which create a new resource using a
        # DEPRECATED resource will return successfully, but with a warning indicating
        # the deprecated resource and recommending its replacement. Operations which use
        # OBSOLETE or DELETED resources will be rejected and result in an error.
        # Corresponds to the JSON property `state`
        # @return [String]
        attr_accessor :state
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @deleted = args[:deleted] if args.key?(:deleted)
          @deprecated = args[:deprecated] if args.key?(:deprecated)
          @obsolete = args[:obsolete] if args.key?(:obsolete)
          @replacement = args[:replacement] if args.key?(:replacement)
          @state = args[:state] if args.key?(:state)
        end
      end
      
      # Represents a Persistent Disk resource.
      # Persistent disks are required for running your VM instances. Create both boot
      # and non-boot (data) persistent disks. For more information, read Persistent
      # Disks. For more storage options, read Storage options.
      # The disks resource represents a zonal persistent disk. For more information,
      # read Zonal persistent disks.
      # The regionDisks resource represents a regional persistent disk. For more
      # information, read  Regional resources. (== resource_for beta.disks ==) (==
      # resource_for v1.disks ==) (== resource_for v1.regionDisks ==) (== resource_for
      # beta.regionDisks ==)
      class Disk
        include Google::Apis::Core::Hashable
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Represents a customer-supplied encryption key
        # Corresponds to the JSON property `diskEncryptionKey`
        # @return [Google::Apis::ComputeBeta::CustomerEncryptionKey]
        attr_accessor :disk_encryption_key
      
        # A list of features to enable on the guest operating system. Applicable only
        # for bootable images. Read  Enabling guest operating system features to see a
        # list of available options.
        # Corresponds to the JSON property `guestOsFeatures`
        # @return [Array<Google::Apis::ComputeBeta::GuestOsFeature>]
        attr_accessor :guest_os_features
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Type of the resource. Always compute#disk for disks.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # A fingerprint for the labels being applied to this disk, which is essentially
        # a hash of the labels set used for optimistic locking. The fingerprint is
        # initially generated by Compute Engine and changes after every request to
        # modify or update labels. You must always provide an up-to-date fingerprint
        # hash in order to update or change labels, otherwise the request will fail with
        # error 412 conditionNotMet.
        # To see the latest fingerprint, make a get() request to retrieve a disk.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # Labels to apply to this disk. These can be later modified by the setLabels
        # method.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # [Output Only] Last attach timestamp in RFC3339 text format.
        # Corresponds to the JSON property `lastAttachTimestamp`
        # @return [String]
        attr_accessor :last_attach_timestamp
      
        # [Output Only] Last detach timestamp in RFC3339 text format.
        # Corresponds to the JSON property `lastDetachTimestamp`
        # @return [String]
        attr_accessor :last_detach_timestamp
      
        # Integer license codes indicating which licenses are attached to this disk.
        # Corresponds to the JSON property `licenseCodes`
        # @return [Array<Fixnum>]
        attr_accessor :license_codes
      
        # A list of publicly visible licenses. Reserved for Google's use.
        # Corresponds to the JSON property `licenses`
        # @return [Array<String>]
        attr_accessor :licenses
      
        # Name of the resource. Provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter,
        # and all following characters must be a dash, lowercase letter, or digit,
        # except the last character, which cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Internal use only.
        # Corresponds to the JSON property `options`
        # @return [String]
        attr_accessor :options
      
        # Physical block size of the persistent disk, in bytes. If not present in a
        # request, a default value is used. Currently supported sizes are 4096 and 16384,
        # other sizes may be added in the future. If an unsupported value is requested,
        # the error message will list the supported values for the caller's project.
        # Corresponds to the JSON property `physicalBlockSizeBytes`
        # @return [Fixnum]
        attr_accessor :physical_block_size_bytes
      
        # [Output Only] URL of the region where the disk resides. Only applicable for
        # regional resources. You must specify this field as part of the HTTP request
        # URL. It is not settable as a field in the request body.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # URLs of the zones where the disk should be replicated to. Only applicable for
        # regional resources.
        # Corresponds to the JSON property `replicaZones`
        # @return [Array<String>]
        attr_accessor :replica_zones
      
        # Resource policies applied to this disk for automatic snapshot creations.
        # Corresponds to the JSON property `resourcePolicies`
        # @return [Array<String>]
        attr_accessor :resource_policies
      
        # [Output Only] Server-defined fully-qualified URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Size of the persistent disk, specified in GB. You can specify this field when
        # creating a persistent disk using the sourceImage or sourceSnapshot parameter,
        # or specify it alone to create an empty persistent disk.
        # If you specify this field along with sourceImage or sourceSnapshot, the value
        # of sizeGb must not be less than the size of the sourceImage or the size of the
        # snapshot. Acceptable values are 1 to 65536, inclusive.
        # Corresponds to the JSON property `sizeGb`
        # @return [Fixnum]
        attr_accessor :size_gb
      
        # The source image used to create this disk. If the source image is deleted,
        # this field will not be set.
        # To create a disk with one of the public operating system images, specify the
        # image by its family name. For example, specify family/debian-9 to use the
        # latest Debian 9 image:
        # projects/debian-cloud/global/images/family/debian-9
        # Alternatively, use a specific version of a public operating system image:
        # projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
        # To create a disk with a custom image that you created, specify the image name
        # in the following format:
        # global/images/my-custom-image
        # You can also specify a custom image by its image family, which returns the
        # latest version of the image in that family. Replace the image name with family/
        # family-name:
        # global/images/family/my-image-family
        # Corresponds to the JSON property `sourceImage`
        # @return [String]
        attr_accessor :source_image
      
        # Represents a customer-supplied encryption key
        # Corresponds to the JSON property `sourceImageEncryptionKey`
        # @return [Google::Apis::ComputeBeta::CustomerEncryptionKey]
        attr_accessor :source_image_encryption_key
      
        # [Output Only] The ID value of the image used to create this disk. This value
        # identifies the exact image that was used to create this persistent disk. For
        # example, if you created the persistent disk from an image that was later
        # deleted and recreated under the same name, the source image ID would identify
        # the exact version of the image that was used.
        # Corresponds to the JSON property `sourceImageId`
        # @return [String]
        attr_accessor :source_image_id
      
        # The source snapshot used to create this disk. You can provide this as a
        # partial or full URL to the resource. For example, the following are valid
        # values:
        # - https://www.googleapis.com/compute/v1/projects/project/global/snapshots/
        # snapshot
        # - projects/project/global/snapshots/snapshot
        # - global/snapshots/snapshot
        # Corresponds to the JSON property `sourceSnapshot`
        # @return [String]
        attr_accessor :source_snapshot
      
        # Represents a customer-supplied encryption key
        # Corresponds to the JSON property `sourceSnapshotEncryptionKey`
        # @return [Google::Apis::ComputeBeta::CustomerEncryptionKey]
        attr_accessor :source_snapshot_encryption_key
      
        # [Output Only] The unique ID of the snapshot used to create this disk. This
        # value identifies the exact snapshot that was used to create this persistent
        # disk. For example, if you created the persistent disk from a snapshot that was
        # later deleted and recreated under the same name, the source snapshot ID would
        # identify the exact version of the snapshot that was used.
        # Corresponds to the JSON property `sourceSnapshotId`
        # @return [String]
        attr_accessor :source_snapshot_id
      
        # [Output Only] The status of disk creation. CREATING: Disk is provisioning.
        # RESTORING: Source data is being copied into the disk. FAILED: Disk creation
        # failed. READY: Disk is ready for use. DELETING: Disk is deleting.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        # [Deprecated] Storage type of the persistent disk.
        # Corresponds to the JSON property `storageType`
        # @return [String]
        attr_accessor :storage_type
      
        # URL of the disk type resource describing which disk type to use to create the
        # disk. Provide this when creating the disk. For example: projects/project/zones/
        # zone/diskTypes/pd-standard or pd-ssd
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        # [Output Only] Links to the users of the disk (attached instances) in form:
        # projects/project/zones/zone/instances/instance
        # Corresponds to the JSON property `users`
        # @return [Array<String>]
        attr_accessor :users
      
        # [Output Only] URL of the zone where the disk resides. You must specify this
        # field as part of the HTTP request URL. It is not settable as a field in the
        # request body.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @disk_encryption_key = args[:disk_encryption_key] if args.key?(:disk_encryption_key)
          @guest_os_features = args[:guest_os_features] if args.key?(:guest_os_features)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
          @last_attach_timestamp = args[:last_attach_timestamp] if args.key?(:last_attach_timestamp)
          @last_detach_timestamp = args[:last_detach_timestamp] if args.key?(:last_detach_timestamp)
          @license_codes = args[:license_codes] if args.key?(:license_codes)
          @licenses = args[:licenses] if args.key?(:licenses)
          @name = args[:name] if args.key?(:name)
          @options = args[:options] if args.key?(:options)
          @physical_block_size_bytes = args[:physical_block_size_bytes] if args.key?(:physical_block_size_bytes)
          @region = args[:region] if args.key?(:region)
          @replica_zones = args[:replica_zones] if args.key?(:replica_zones)
          @resource_policies = args[:resource_policies] if args.key?(:resource_policies)
          @self_link = args[:self_link] if args.key?(:self_link)
          @size_gb = args[:size_gb] if args.key?(:size_gb)
          @source_image = args[:source_image] if args.key?(:source_image)
          @source_image_encryption_key = args[:source_image_encryption_key] if args.key?(:source_image_encryption_key)
          @source_image_id = args[:source_image_id] if args.key?(:source_image_id)
          @source_snapshot = args[:source_snapshot] if args.key?(:source_snapshot)
          @source_snapshot_encryption_key = args[:source_snapshot_encryption_key] if args.key?(:source_snapshot_encryption_key)
          @source_snapshot_id = args[:source_snapshot_id] if args.key?(:source_snapshot_id)
          @status = args[:status] if args.key?(:status)
          @storage_type = args[:storage_type] if args.key?(:storage_type)
          @type = args[:type] if args.key?(:type)
          @users = args[:users] if args.key?(:users)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class DiskAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of DisksScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::DisksScopedList>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#diskAggregatedList for
        # aggregated lists of persistent disks.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::DiskAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::DiskAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # A specification of the desired way to instantiate a disk in the instance
      # template when its created from a source instance.
      class DiskInstantiationConfig
        include Google::Apis::Core::Hashable
      
        # Specifies whether the disk will be auto-deleted when the instance is deleted (
        # but not when the disk is detached from the instance).
        # Corresponds to the JSON property `autoDelete`
        # @return [Boolean]
        attr_accessor :auto_delete
        alias_method :auto_delete?, :auto_delete
      
        # The custom source image to be used to restore this disk when instantiating
        # this instance template.
        # Corresponds to the JSON property `customImage`
        # @return [String]
        attr_accessor :custom_image
      
        # Specifies the device name of the disk to which the configurations apply to.
        # Corresponds to the JSON property `deviceName`
        # @return [String]
        attr_accessor :device_name
      
        # Specifies whether to include the disk and what image to use. Possible values
        # are:
        # - source-image: to use the same image that was used to create the source
        # instance's corresponding disk. Applicable to the boot disk and additional read-
        # write disks.
        # - source-image-family: to use the same image family that was used to create
        # the source instance's corresponding disk. Applicable to the boot disk and
        # additional read-write disks.
        # - custom-image: to use a user-provided image url for disk creation. Applicable
        # to the boot disk and additional read-write disks.
        # - attach-read-only: to attach a read-only disk. Applicable to read-only disks.
        # - do-not-include: to exclude a disk from the template. Applicable to
        # additional read-write disks, local SSDs, and read-only disks.
        # Corresponds to the JSON property `instantiateFrom`
        # @return [String]
        attr_accessor :instantiate_from
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @auto_delete = args[:auto_delete] if args.key?(:auto_delete)
          @custom_image = args[:custom_image] if args.key?(:custom_image)
          @device_name = args[:device_name] if args.key?(:device_name)
          @instantiate_from = args[:instantiate_from] if args.key?(:instantiate_from)
        end
      end
      
      # A list of Disk resources.
      class DiskList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Disk resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::Disk>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#diskList for lists of disks.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::DiskList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::DiskList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class DiskMoveRequest
        include Google::Apis::Core::Hashable
      
        # The URL of the destination zone to move the disk. This can be a full or
        # partial URL. For example, the following are all valid URLs to a zone:
        # - https://www.googleapis.com/compute/v1/projects/project/zones/zone
        # - projects/project/zones/zone
        # - zones/zone
        # Corresponds to the JSON property `destinationZone`
        # @return [String]
        attr_accessor :destination_zone
      
        # The URL of the target disk to move. This can be a full or partial URL. For
        # example, the following are all valid URLs to a disk:
        # - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
        # - projects/project/zones/zone/disks/disk
        # - zones/zone/disks/disk
        # Corresponds to the JSON property `targetDisk`
        # @return [String]
        attr_accessor :target_disk
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @destination_zone = args[:destination_zone] if args.key?(:destination_zone)
          @target_disk = args[:target_disk] if args.key?(:target_disk)
        end
      end
      
      # Represents a Disk Type resource.
      # You can choose from a variety of disk types based on your needs. For more
      # information, read Storage options.
      # The diskTypes resource represents disk types for a zonal persistent disk. For
      # more information, read Zonal persistent disks.
      # The regionDiskTypes resource represents disk types for a regional persistent
      # disk. For more information, read Regional persistent disks. (== resource_for
      # beta.diskTypes ==) (== resource_for v1.diskTypes ==) (== resource_for v1.
      # regionDiskTypes ==) (== resource_for beta.regionDiskTypes ==)
      class DiskType
        include Google::Apis::Core::Hashable
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # [Output Only] Server-defined default disk size in GB.
        # Corresponds to the JSON property `defaultDiskSizeGb`
        # @return [Fixnum]
        attr_accessor :default_disk_size_gb
      
        # Deprecation status for a public resource.
        # Corresponds to the JSON property `deprecated`
        # @return [Google::Apis::ComputeBeta::DeprecationStatus]
        attr_accessor :deprecated
      
        # [Output Only] An optional description of this resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Type of the resource. Always compute#diskType for disk types.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] Name of the resource.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # [Output Only] URL of the region where the disk type resides. Only applicable
        # for regional resources. You must specify this field as part of the HTTP
        # request URL. It is not settable as a field in the request body.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] An optional textual description of the valid disk size, such as "
        # 10GB-10TB".
        # Corresponds to the JSON property `validDiskSize`
        # @return [String]
        attr_accessor :valid_disk_size
      
        # [Output Only] URL of the zone where the disk type resides. You must specify
        # this field as part of the HTTP request URL. It is not settable as a field in
        # the request body.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @default_disk_size_gb = args[:default_disk_size_gb] if args.key?(:default_disk_size_gb)
          @deprecated = args[:deprecated] if args.key?(:deprecated)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @region = args[:region] if args.key?(:region)
          @self_link = args[:self_link] if args.key?(:self_link)
          @valid_disk_size = args[:valid_disk_size] if args.key?(:valid_disk_size)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class DiskTypeAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of DiskTypesScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::DiskTypesScopedList>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#diskTypeAggregatedList.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::DiskTypeAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::DiskTypeAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of disk types.
      class DiskTypeList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of DiskType resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::DiskType>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#diskTypeList for disk types.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::DiskTypeList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::DiskTypeList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class DiskTypesScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] A list of disk types contained in this scope.
        # Corresponds to the JSON property `diskTypes`
        # @return [Array<Google::Apis::ComputeBeta::DiskType>]
        attr_accessor :disk_types
      
        # [Output Only] Informational warning which replaces the list of disk types when
        # the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::DiskTypesScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @disk_types = args[:disk_types] if args.key?(:disk_types)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning which replaces the list of disk types when
        # the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::DiskTypesScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class DisksAddResourcePoliciesRequest
        include Google::Apis::Core::Hashable
      
        # Resource policies to be added to this disk.
        # Corresponds to the JSON property `resourcePolicies`
        # @return [Array<String>]
        attr_accessor :resource_policies
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @resource_policies = args[:resource_policies] if args.key?(:resource_policies)
        end
      end
      
      # 
      class DisksRemoveResourcePoliciesRequest
        include Google::Apis::Core::Hashable
      
        # Resource policies to be removed from this disk.
        # Corresponds to the JSON property `resourcePolicies`
        # @return [Array<String>]
        attr_accessor :resource_policies
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @resource_policies = args[:resource_policies] if args.key?(:resource_policies)
        end
      end
      
      # 
      class DisksResizeRequest
        include Google::Apis::Core::Hashable
      
        # The new size of the persistent disk, which is specified in GB.
        # Corresponds to the JSON property `sizeGb`
        # @return [Fixnum]
        attr_accessor :size_gb
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @size_gb = args[:size_gb] if args.key?(:size_gb)
        end
      end
      
      # 
      class DisksScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] A list of disks contained in this scope.
        # Corresponds to the JSON property `disks`
        # @return [Array<Google::Apis::ComputeBeta::Disk>]
        attr_accessor :disks
      
        # [Output Only] Informational warning which replaces the list of disks when the
        # list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::DisksScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @disks = args[:disks] if args.key?(:disks)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning which replaces the list of disks when the
        # list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::DisksScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # A set of Display Device options
      class DisplayDevice
        include Google::Apis::Core::Hashable
      
        # Defines whether the instance has Display enabled.
        # Corresponds to the JSON property `enableDisplay`
        # @return [Boolean]
        attr_accessor :enable_display
        alias_method :enable_display?, :enable_display
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @enable_display = args[:enable_display] if args.key?(:enable_display)
        end
      end
      
      # 
      class DistributionPolicy
        include Google::Apis::Core::Hashable
      
        # Zones where the regional managed instance group will create and manage
        # instances.
        # Corresponds to the JSON property `zones`
        # @return [Array<Google::Apis::ComputeBeta::DistributionPolicyZoneConfiguration>]
        attr_accessor :zones
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @zones = args[:zones] if args.key?(:zones)
        end
      end
      
      # 
      class DistributionPolicyZoneConfiguration
        include Google::Apis::Core::Hashable
      
        # The URL of the zone. The zone must exist in the region where the managed
        # instance group is located.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # A Duration represents a fixed-length span of time represented as a count of
      # seconds and fractions of seconds at nanosecond resolution. It is independent
      # of any calendar and concepts like "day" or "month". Range is approximately 10,
      # 000 years.
      class Duration
        include Google::Apis::Core::Hashable
      
        # Span of time that's a fraction of a second at nanosecond resolution. Durations
        # less than one second are represented with a 0 `seconds` field and a positive `
        # nanos` field. Must be from 0 to 999,999,999 inclusive.
        # Corresponds to the JSON property `nanos`
        # @return [Fixnum]
        attr_accessor :nanos
      
        # Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
        # inclusive. Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24
        # hr/day * 365.25 days/year * 10000 years
        # Corresponds to the JSON property `seconds`
        # @return [Fixnum]
        attr_accessor :seconds
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @nanos = args[:nanos] if args.key?(:nanos)
          @seconds = args[:seconds] if args.key?(:seconds)
        end
      end
      
      # 
      class ExchangedPeeringRoute
        include Google::Apis::Core::Hashable
      
        # The destination range of the route.
        # Corresponds to the JSON property `destRange`
        # @return [String]
        attr_accessor :dest_range
      
        # True if the peering route has been imported from a peer. The actual import
        # happens if the field networkPeering.importCustomRoutes is true for this
        # network, and networkPeering.exportCustomRoutes is true for the peer network,
        # and the import does not result in a route conflict.
        # Corresponds to the JSON property `imported`
        # @return [Boolean]
        attr_accessor :imported
        alias_method :imported?, :imported
      
        # The region of peering route next hop, only applies to dynamic routes.
        # Corresponds to the JSON property `nextHopRegion`
        # @return [String]
        attr_accessor :next_hop_region
      
        # The priority of the peering route.
        # Corresponds to the JSON property `priority`
        # @return [Fixnum]
        attr_accessor :priority
      
        # The type of the peering route.
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @dest_range = args[:dest_range] if args.key?(:dest_range)
          @imported = args[:imported] if args.key?(:imported)
          @next_hop_region = args[:next_hop_region] if args.key?(:next_hop_region)
          @priority = args[:priority] if args.key?(:priority)
          @type = args[:type] if args.key?(:type)
        end
      end
      
      # 
      class ExchangedPeeringRoutesList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of ExchangedPeeringRoute resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::ExchangedPeeringRoute>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#exchangedPeeringRoutesList for
        # exchanged peering routes lists.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::ExchangedPeeringRoutesList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::ExchangedPeeringRoutesList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Represents an expression text. Example:
      # title: "User account presence" description: "Determines whether the request
      # has a user account" expression: "size(request.user) > 0"
      class Expr
        include Google::Apis::Core::Hashable
      
        # An optional description of the expression. This is a longer text which
        # describes the expression, e.g. when hovered over it in a UI.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Textual representation of an expression in Common Expression Language syntax.
        # The application context of the containing message determines which well-known
        # feature set of CEL is supported.
        # Corresponds to the JSON property `expression`
        # @return [String]
        attr_accessor :expression
      
        # An optional string indicating the location of the expression for error
        # reporting, e.g. a file name and a position in the file.
        # Corresponds to the JSON property `location`
        # @return [String]
        attr_accessor :location
      
        # An optional title for the expression, i.e. a short string describing its
        # purpose. This can be used e.g. in UIs which allow to enter the expression.
        # Corresponds to the JSON property `title`
        # @return [String]
        attr_accessor :title
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @description = args[:description] if args.key?(:description)
          @expression = args[:expression] if args.key?(:expression)
          @location = args[:location] if args.key?(:location)
          @title = args[:title] if args.key?(:title)
        end
      end
      
      # External VPN gateway is the on-premises VPN gateway(s) or another cloud
      # provider?s VPN gateway that connects to your Google Cloud VPN gateway. To
      # create a highly available VPN from Google Cloud to your on-premises side or
      # another Cloud provider's VPN gateway, you must create a external VPN gateway
      # resource in GCP, which provides the information to GCP about your external VPN
      # gateway.
      class ExternalVpnGateway
        include Google::Apis::Core::Hashable
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # List of interfaces for this external VPN gateway.
        # Corresponds to the JSON property `interfaces`
        # @return [Array<Google::Apis::ComputeBeta::ExternalVpnGatewayInterface>]
        attr_accessor :interfaces
      
        # [Output Only] Type of the resource. Always compute#externalVpnGateway for
        # externalVpnGateways.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # A fingerprint for the labels being applied to this ExternalVpnGateway, which
        # is essentially a hash of the labels set used for optimistic locking. The
        # fingerprint is initially generated by Compute Engine and changes after every
        # request to modify or update labels. You must always provide an up-to-date
        # fingerprint hash in order to update or change labels, otherwise the request
        # will fail with error 412 conditionNotMet.
        # To see the latest fingerprint, make a get() request to retrieve an
        # ExternalVpnGateway.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # Labels to apply to this ExternalVpnGateway resource. These can be later
        # modified by the setLabels method. Each label key/value must comply with
        # RFC1035. Label values may be empty.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # Name of the resource. Provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter,
        # and all following characters must be a dash, lowercase letter, or digit,
        # except the last character, which cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Indicates the user-supplied redundancy type of this external VPN gateway.
        # Corresponds to the JSON property `redundancyType`
        # @return [String]
        attr_accessor :redundancy_type
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @interfaces = args[:interfaces] if args.key?(:interfaces)
          @kind = args[:kind] if args.key?(:kind)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
          @name = args[:name] if args.key?(:name)
          @redundancy_type = args[:redundancy_type] if args.key?(:redundancy_type)
          @self_link = args[:self_link] if args.key?(:self_link)
        end
      end
      
      # The interface for the external VPN gateway.
      class ExternalVpnGatewayInterface
        include Google::Apis::Core::Hashable
      
        # The numeric ID of this interface. The allowed input values for this id for
        # different redundancy types of external VPN gateway:
        # SINGLE_IP_INTERNALLY_REDUNDANT - 0 TWO_IPS_REDUNDANCY - 0, 1
        # FOUR_IPS_REDUNDANCY - 0, 1, 2, 3
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # IP address of the interface in the external VPN gateway. Only IPv4 is
        # supported. This IP address can be either from your on-premise gateway or
        # another Cloud provider?s VPN gateway, it cannot be an IP address from Google
        # Compute Engine.
        # Corresponds to the JSON property `ipAddress`
        # @return [String]
        attr_accessor :ip_address
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @ip_address = args[:ip_address] if args.key?(:ip_address)
        end
      end
      
      # Response to the list request, and contains a list of externalVpnGateways.
      class ExternalVpnGatewayList
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `etag`
        # @return [String]
        attr_accessor :etag
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of ExternalVpnGateway resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::ExternalVpnGateway>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#externalVpnGatewayList  for
        # lists of externalVpnGateways.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::ExternalVpnGatewayList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @etag = args[:etag] if args.key?(:etag)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::ExternalVpnGatewayList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Represents a Firewall Rule resource.
      # Firewall rules allow or deny ingress traffic to, and egress traffic from your
      # instances. For more information, read Firewall rules.
      class Firewall
        include Google::Apis::Core::Hashable
      
        # The list of ALLOW rules specified by this firewall. Each rule specifies a
        # protocol and port-range tuple that describes a permitted connection.
        # Corresponds to the JSON property `allowed`
        # @return [Array<Google::Apis::ComputeBeta::Firewall::Allowed>]
        attr_accessor :allowed
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # The list of DENY rules specified by this firewall. Each rule specifies a
        # protocol and port-range tuple that describes a denied connection.
        # Corresponds to the JSON property `denied`
        # @return [Array<Google::Apis::ComputeBeta::Firewall::Denied>]
        attr_accessor :denied
      
        # An optional description of this resource. Provide this field when you create
        # the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # If destination ranges are specified, the firewall rule applies only to traffic
        # that has destination IP address in these ranges. These ranges must be
        # expressed in CIDR format. Only IPv4 is supported.
        # Corresponds to the JSON property `destinationRanges`
        # @return [Array<String>]
        attr_accessor :destination_ranges
      
        # Direction of traffic to which this firewall applies, either `INGRESS` or `
        # EGRESS`. The default is `INGRESS`. For `INGRESS` traffic, you cannot specify
        # the destinationRanges field, and for `EGRESS` traffic, you cannot specify the
        # sourceRanges or sourceTags fields.
        # Corresponds to the JSON property `direction`
        # @return [String]
        attr_accessor :direction
      
        # Denotes whether the firewall rule is disabled. When set to true, the firewall
        # rule is not enforced and the network behaves as if it did not exist. If this
        # is unspecified, the firewall rule will be enabled.
        # Corresponds to the JSON property `disabled`
        # @return [Boolean]
        attr_accessor :disabled
        alias_method :disabled?, :disabled
      
        # Deprecated in favor of enable in LogConfig. This field denotes whether to
        # enable logging for a particular firewall rule. If logging is enabled, logs
        # will be exported to Stackdriver.
        # Corresponds to the JSON property `enableLogging`
        # @return [Boolean]
        attr_accessor :enable_logging
        alias_method :enable_logging?, :enable_logging
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Type of the resource. Always compute#firewall for firewall rules.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # The available logging options for a firewall rule.
        # Corresponds to the JSON property `logConfig`
        # @return [Google::Apis::ComputeBeta::FirewallLogConfig]
        attr_accessor :log_config
      
        # Name of the resource; provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?. The first character must be a lowercase letter, and all
        # following characters (except for the last character) must be a dash, lowercase
        # letter, or digit. The last character must be a lowercase letter or digit.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # URL of the network resource for this firewall rule. If not specified when
        # creating a firewall rule, the default network is used:
        # global/networks/default
        # If you choose to specify this field, you can specify the network as a full or
        # partial URL. For example, the following are all valid URLs:
        # - https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-
        # network
        # - projects/myproject/global/networks/my-network
        # - global/networks/default
        # Corresponds to the JSON property `network`
        # @return [String]
        attr_accessor :network
      
        # Priority for this rule. This is an integer between `0` and `65535`, both
        # inclusive. The default value is `1000`. Relative priorities determine which
        # rule takes effect if multiple rules apply. Lower values indicate higher
        # priority. For example, a rule with priority `0` has higher precedence than a
        # rule with priority `1`. DENY rules take precedence over ALLOW rules if they
        # have equal priority. Note that VPC networks have implied rules with a priority
        # of `65535`. To avoid conflicts with the implied rules, use a priority number
        # less than `65535`.
        # Corresponds to the JSON property `priority`
        # @return [Fixnum]
        attr_accessor :priority
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # If source ranges are specified, the firewall rule applies only to traffic that
        # has a source IP address in these ranges. These ranges must be expressed in
        # CIDR format. One or both of sourceRanges and sourceTags may be set. If both
        # fields are set, the rule applies to traffic that has a source IP address
        # within sourceRanges OR a source IP from a resource with a matching tag listed
        # in the sourceTags field. The connection does not need to match both fields for
        # the rule to apply. Only IPv4 is supported.
        # Corresponds to the JSON property `sourceRanges`
        # @return [Array<String>]
        attr_accessor :source_ranges
      
        # If source service accounts are specified, the firewall rules apply only to
        # traffic originating from an instance with a service account in this list.
        # Source service accounts cannot be used to control traffic to an instance's
        # external IP address because service accounts are associated with an instance,
        # not an IP address. sourceRanges can be set at the same time as
        # sourceServiceAccounts. If both are set, the firewall applies to traffic that
        # has a source IP address within the sourceRanges OR a source IP that belongs to
        # an instance with service account listed in sourceServiceAccount. The
        # connection does not need to match both fields for the firewall to apply.
        # sourceServiceAccounts cannot be used at the same time as sourceTags or
        # targetTags.
        # Corresponds to the JSON property `sourceServiceAccounts`
        # @return [Array<String>]
        attr_accessor :source_service_accounts
      
        # If source tags are specified, the firewall rule applies only to traffic with
        # source IPs that match the primary network interfaces of VM instances that have
        # the tag and are in the same VPC network. Source tags cannot be used to control
        # traffic to an instance's external IP address, it only applies to traffic
        # between instances in the same virtual network. Because tags are associated
        # with instances, not IP addresses. One or both of sourceRanges and sourceTags
        # may be set. If both fields are set, the firewall applies to traffic that has a
        # source IP address within sourceRanges OR a source IP from a resource with a
        # matching tag listed in the sourceTags field. The connection does not need to
        # match both fields for the firewall to apply.
        # Corresponds to the JSON property `sourceTags`
        # @return [Array<String>]
        attr_accessor :source_tags
      
        # A list of service accounts indicating sets of instances located in the network
        # that may make network connections as specified in allowed[].
        # targetServiceAccounts cannot be used at the same time as targetTags or
        # sourceTags. If neither targetServiceAccounts nor targetTags are specified, the
        # firewall rule applies to all instances on the specified network.
        # Corresponds to the JSON property `targetServiceAccounts`
        # @return [Array<String>]
        attr_accessor :target_service_accounts
      
        # A list of tags that controls which instances the firewall rule applies to. If
        # targetTags are specified, then the firewall rule applies only to instances in
        # the VPC network that have one of those tags. If no targetTags are specified,
        # the firewall rule applies to all instances on the specified network.
        # Corresponds to the JSON property `targetTags`
        # @return [Array<String>]
        attr_accessor :target_tags
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @allowed = args[:allowed] if args.key?(:allowed)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @denied = args[:denied] if args.key?(:denied)
          @description = args[:description] if args.key?(:description)
          @destination_ranges = args[:destination_ranges] if args.key?(:destination_ranges)
          @direction = args[:direction] if args.key?(:direction)
          @disabled = args[:disabled] if args.key?(:disabled)
          @enable_logging = args[:enable_logging] if args.key?(:enable_logging)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @log_config = args[:log_config] if args.key?(:log_config)
          @name = args[:name] if args.key?(:name)
          @network = args[:network] if args.key?(:network)
          @priority = args[:priority] if args.key?(:priority)
          @self_link = args[:self_link] if args.key?(:self_link)
          @source_ranges = args[:source_ranges] if args.key?(:source_ranges)
          @source_service_accounts = args[:source_service_accounts] if args.key?(:source_service_accounts)
          @source_tags = args[:source_tags] if args.key?(:source_tags)
          @target_service_accounts = args[:target_service_accounts] if args.key?(:target_service_accounts)
          @target_tags = args[:target_tags] if args.key?(:target_tags)
        end
        
        # 
        class Allowed
          include Google::Apis::Core::Hashable
        
          # The IP protocol to which this rule applies. The protocol type is required when
          # creating a firewall rule. This value can either be one of the following well
          # known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp) or the IP
          # protocol number.
          # Corresponds to the JSON property `IPProtocol`
          # @return [String]
          attr_accessor :ip_protocol
        
          # An optional list of ports to which this rule applies. This field is only
          # applicable for the UDP or TCP protocol. Each entry must be either an integer
          # or a range. If not specified, this rule applies to connections through any
          # port.
          # Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
          # Corresponds to the JSON property `ports`
          # @return [Array<String>]
          attr_accessor :ports
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @ip_protocol = args[:ip_protocol] if args.key?(:ip_protocol)
            @ports = args[:ports] if args.key?(:ports)
          end
        end
        
        # 
        class Denied
          include Google::Apis::Core::Hashable
        
          # The IP protocol to which this rule applies. The protocol type is required when
          # creating a firewall rule. This value can either be one of the following well
          # known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp) or the IP
          # protocol number.
          # Corresponds to the JSON property `IPProtocol`
          # @return [String]
          attr_accessor :ip_protocol
        
          # An optional list of ports to which this rule applies. This field is only
          # applicable for the UDP or TCP protocol. Each entry must be either an integer
          # or a range. If not specified, this rule applies to connections through any
          # port.
          # Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
          # Corresponds to the JSON property `ports`
          # @return [Array<String>]
          attr_accessor :ports
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @ip_protocol = args[:ip_protocol] if args.key?(:ip_protocol)
            @ports = args[:ports] if args.key?(:ports)
          end
        end
      end
      
      # Contains a list of firewalls.
      class FirewallList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Firewall resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::Firewall>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#firewallList for lists of
        # firewalls.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::FirewallList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::FirewallList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # The available logging options for a firewall rule.
      class FirewallLogConfig
        include Google::Apis::Core::Hashable
      
        # This field denotes whether to enable logging for a particular firewall rule.
        # Corresponds to the JSON property `enable`
        # @return [Boolean]
        attr_accessor :enable
        alias_method :enable?, :enable
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @enable = args[:enable] if args.key?(:enable)
        end
      end
      
      # Encapsulates numeric value that can be either absolute or relative.
      class FixedOrPercent
        include Google::Apis::Core::Hashable
      
        # [Output Only] Absolute value of VM instances calculated based on the specific
        # mode.
        # 
        # - If the value is fixed, then the calculated value is equal to the fixed value.
        # 
        # - If the value is a percent, then the calculated value is percent/100 *
        # targetSize. For example, the calculated value of a 80% of a managed instance
        # group with 150 instances would be (80/100 * 150) = 120 VM instances. If there
        # is a remainder, the number is rounded up.
        # Corresponds to the JSON property `calculated`
        # @return [Fixnum]
        attr_accessor :calculated
      
        # Specifies a fixed number of VM instances. This must be a positive integer.
        # Corresponds to the JSON property `fixed`
        # @return [Fixnum]
        attr_accessor :fixed
      
        # Specifies a percentage of instances between 0 to 100%, inclusive. For example,
        # specify 80 for 80%.
        # Corresponds to the JSON property `percent`
        # @return [Fixnum]
        attr_accessor :percent
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @calculated = args[:calculated] if args.key?(:calculated)
          @fixed = args[:fixed] if args.key?(:fixed)
          @percent = args[:percent] if args.key?(:percent)
        end
      end
      
      # Represents a Forwarding Rule resource.
      # A forwardingRules resource represents a regional forwarding rule.
      # Regional external forwarding rules can reference any of the following
      # resources:
      # 
      # - A target instance
      # - A Cloud VPN Classic gateway (targetVpnGateway),
      # - A target pool for a Network Load Balancer
      # - A global target HTTP(S) proxy for an HTTP(S) load balancer using Standard
      # Tier
      # - A target SSL proxy for a SSL Proxy load balancer using Standard Tier
      # - A target TCP proxy for a TCP Proxy load balancer using Standard Tier.
      # Regional internal forwarding rules can reference the backend service of an
      # internal TCP/UDP load balancer.
      # For regional internal forwarding rules, the following applies:
      # - If the loadBalancingScheme for the load balancer is INTERNAL, then the
      # forwarding rule references a regional internal backend service.
      # - If the loadBalancingScheme for the load balancer is INTERNAL_MANAGED, then
      # the forwarding rule must reference a regional target HTTP(S) proxy.
      # For more information, read Using Forwarding rules.
      # A globalForwardingRules resource represents a global forwarding rule.
      # Global forwarding rules are only used by load balancers that use Premium Tier.
      # (== resource_for beta.forwardingRules ==) (== resource_for v1.forwardingRules =
      # =) (== resource_for beta.globalForwardingRules ==) (== resource_for v1.
      # globalForwardingRules ==) (== resource_for beta.regionForwardingRules ==) (==
      # resource_for v1.regionForwardingRules ==)
      class ForwardingRule
        include Google::Apis::Core::Hashable
      
        # IP address that this forwarding rule serves. When a client sends traffic to
        # this IP address, the forwarding rule directs the traffic to the target that
        # you specify in the forwarding rule.
        # If you don't specify a reserved IP address, an ephemeral IP address is
        # assigned. Methods for specifying an IP address:
        # * IPv4 dotted decimal, as in `100.1.2.3` * Full URL, as in https://www.
        # googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-
        # name * Partial URL or by name, as in: * projects/project_id/regions/region/
        # addresses/address-name * regions/region/addresses/address-name * global/
        # addresses/address-name * address-name
        # The loadBalancingScheme and the forwarding rule's target determine the type of
        # IP address that you can use. For detailed information, refer to [IP address
        # specifications](/load-balancing/docs/forwarding-rule-concepts#
        # ip_address_specifications).
        # Corresponds to the JSON property `IPAddress`
        # @return [String]
        attr_accessor :ip_address
      
        # The IP protocol to which this rule applies. Valid options are TCP, UDP, ESP,
        # AH, SCTP or ICMP.
        # When the load balancing scheme is INTERNAL, only TCP and UDP are valid. When
        # the load balancing scheme is INTERNAL_SELF_MANAGED, only TCPis valid.
        # Corresponds to the JSON property `IPProtocol`
        # @return [String]
        attr_accessor :ip_protocol
      
        # This field is used along with the backend_service field for internal load
        # balancing or with the target field for internal TargetInstance. This field
        # cannot be used with port or portRange fields.
        # When the load balancing scheme is INTERNAL and protocol is TCP/UDP, specify
        # this field to allow packets addressed to any ports will be forwarded to the
        # backends configured with this forwarding rule.
        # Corresponds to the JSON property `allPorts`
        # @return [Boolean]
        attr_accessor :all_ports
        alias_method :all_ports?, :all_ports
      
        # This field is used along with the backend_service field for internal load
        # balancing or with the target field for internal TargetInstance. If the field
        # is set to TRUE, clients can access ILB from all regions. Otherwise only allows
        # access from clients in the same region as the internal load balancer.
        # Corresponds to the JSON property `allowGlobalAccess`
        # @return [Boolean]
        attr_accessor :allow_global_access
        alias_method :allow_global_access?, :allow_global_access
      
        # This field is only used for INTERNAL load balancing.
        # For internal load balancing, this field identifies the BackendService resource
        # to receive the matched traffic.
        # Corresponds to the JSON property `backendService`
        # @return [String]
        attr_accessor :backend_service
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Fingerprint of this resource. A hash of the contents stored in this object.
        # This field is used in optimistic locking. This field will be ignored when
        # inserting a ForwardingRule. Include the fingerprint in patch request to ensure
        # that you do not overwrite changes that were applied from another concurrent
        # request.
        # To see the latest fingerprint, make a get() request to retrieve a
        # ForwardingRule.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # The IP Version that will be used by this forwarding rule. Valid options are
        # IPV4 or IPV6. This can only be specified for an external global forwarding
        # rule.
        # Corresponds to the JSON property `ipVersion`
        # @return [String]
        attr_accessor :ip_version
      
        # [Output Only] Type of the resource. Always compute#forwardingRule for
        # Forwarding Rule resources.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # A fingerprint for the labels being applied to this resource, which is
        # essentially a hash of the labels set used for optimistic locking. The
        # fingerprint is initially generated by Compute Engine and changes after every
        # request to modify or update labels. You must always provide an up-to-date
        # fingerprint hash in order to update or change labels, otherwise the request
        # will fail with error 412 conditionNotMet.
        # To see the latest fingerprint, make a get() request to retrieve a
        # ForwardingRule.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # Labels to apply to this resource. These can be later modified by the setLabels
        # method. Each label key/value pair must comply with RFC1035. Label values may
        # be empty.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # This signifies what the ForwardingRule will be used for and can only take the
        # following values: INTERNAL, INTERNAL_SELF_MANAGED, EXTERNAL. The value of
        # INTERNAL means that this will be used for Internal Network Load Balancing (TCP,
        # UDP). The value of INTERNAL_SELF_MANAGED means that this will be used for
        # Internal Global HTTP(S) LB. The value of EXTERNAL means that this will be used
        # for External Load Balancing (HTTP(S) LB, External TCP/UDP LB, SSL Proxy)
        # Corresponds to the JSON property `loadBalancingScheme`
        # @return [String]
        attr_accessor :load_balancing_scheme
      
        # Opaque filter criteria used by Loadbalancer to restrict routing configuration
        # to a limited set xDS compliant clients. In their xDS requests to Loadbalancer,
        # xDS clients present node metadata. If a match takes place, the relevant
        # routing configuration is made available to those proxies.
        # For each metadataFilter in this list, if its filterMatchCriteria is set to
        # MATCH_ANY, at least one of the filterLabels must match the corresponding label
        # provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then
        # all of its filterLabels must match with corresponding labels in the provided
        # metadata.
        # metadataFilters specified here can be overridden by those specified in the
        # UrlMap that this ForwardingRule references.
        # metadataFilters only applies to Loadbalancers that have their
        # loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        # Corresponds to the JSON property `metadataFilters`
        # @return [Array<Google::Apis::ComputeBeta::MetadataFilter>]
        attr_accessor :metadata_filters
      
        # Name of the resource; provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter,
        # and all following characters must be a dash, lowercase letter, or digit,
        # except the last character, which cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # This field is not used for external load balancing.
        # For INTERNAL and INTERNAL_SELF_MANAGED load balancing, this field identifies
        # the network that the load balanced IP should belong to for this Forwarding
        # Rule. If this field is not specified, the default network will be used.
        # Corresponds to the JSON property `network`
        # @return [String]
        attr_accessor :network
      
        # This signifies the networking tier used for configuring this load balancer and
        # can only take the following values: PREMIUM , STANDARD.
        # For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For
        # GlobalForwardingRule, the valid value is PREMIUM.
        # If this field is not specified, it is assumed to be PREMIUM. If IPAddress is
        # specified, this value must be equal to the networkTier of the Address.
        # Corresponds to the JSON property `networkTier`
        # @return [String]
        attr_accessor :network_tier
      
        # This field is deprecated. See the port
        # field.
        # Corresponds to the JSON property `portRange`
        # @return [String]
        attr_accessor :port_range
      
        # List of comma-separated ports. The forwarding rule forwards packets with
        # matching destination ports. If the forwarding rule's loadBalancingScheme is
        # EXTERNAL, and the forwarding rule references a target pool, specifying ports
        # is optional. You can specify an unlimited number of ports, but they must be
        # contiguous. If you omit ports, GCP forwards traffic on any port of the
        # forwarding rule's protocol.
        # If the forwarding rule's loadBalancingScheme is EXTERNAL, and the forwarding
        # rule references a target HTTP proxy, target HTTPS proxy, target TCP proxy,
        # target SSL proxy, or target VPN gateway, you must specify ports using the
        # following constraints:
        # 
        # - TargetHttpProxy: 80, 8080
        # - TargetHttpsProxy: 443
        # - TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688,
        # 1883, 5222
        # - TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688,
        # 1883, 5222
        # - TargetVpnGateway: 500, 4500
        # If the forwarding rule's loadBalancingScheme is INTERNAL, you must specify
        # ports in one of the following ways:
        # * A list of up to five ports, which can be non-contiguous * Keyword ALL, which
        # causes the forwarding rule to forward traffic on any port of the forwarding
        # rule's protocol.
        # The ports field is used along with the target field for TargetHttpProxy,
        # TargetHttpsProxy, TargetSslProxy, TargetTcpProxy, TargetVpnGateway, TargetPool,
        # TargetInstance.
        # Applicable only when IPProtocol is TCP, UDP, or SCTP. Forwarding rules with
        # the same [IPAddress, IPProtocol] pair must have disjoint port ranges.
        # Corresponds to the JSON property `ports`
        # @return [Array<String>]
        attr_accessor :ports
      
        # [Output Only] URL of the region where the regional forwarding rule resides.
        # This field is not applicable to global forwarding rules. You must specify this
        # field as part of the HTTP request URL. It is not settable as a field in the
        # request body.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # An optional prefix to the service name for this Forwarding Rule. If specified,
        # the prefix is the first label of the fully qualified service name.
        # The label must be 1-63 characters long, and comply with RFC1035. Specifically,
        # the label must be 1-63 characters long and match the regular expression `[a-z](
        # [-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase
        # letter, and all following characters must be a dash, lowercase letter, or
        # digit, except the last character, which cannot be a dash.
        # This field is only used for internal load balancing.
        # Corresponds to the JSON property `serviceLabel`
        # @return [String]
        attr_accessor :service_label
      
        # [Output Only] The internal fully qualified service name for this Forwarding
        # Rule.
        # This field is only used for internal load balancing.
        # Corresponds to the JSON property `serviceName`
        # @return [String]
        attr_accessor :service_name
      
        # This field is only used for INTERNAL load balancing.
        # For internal load balancing, this field identifies the subnetwork that the
        # load balanced IP should belong to for this Forwarding Rule.
        # If the network specified is in auto subnet mode, this field is optional.
        # However, if the network is in custom subnet mode, a subnetwork must be
        # specified.
        # Corresponds to the JSON property `subnetwork`
        # @return [String]
        attr_accessor :subnetwork
      
        # The URL of the target resource to receive the matched traffic. For regional
        # forwarding rules, this target must live in the same region as the forwarding
        # rule. For global forwarding rules, this target must be a global load balancing
        # resource. The forwarded traffic must be of a type appropriate to the target
        # object. For INTERNAL_SELF_MANAGED load balancing, only HTTP and HTTPS targets
        # are valid.
        # Corresponds to the JSON property `target`
        # @return [String]
        attr_accessor :target
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @ip_address = args[:ip_address] if args.key?(:ip_address)
          @ip_protocol = args[:ip_protocol] if args.key?(:ip_protocol)
          @all_ports = args[:all_ports] if args.key?(:all_ports)
          @allow_global_access = args[:allow_global_access] if args.key?(:allow_global_access)
          @backend_service = args[:backend_service] if args.key?(:backend_service)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @id = args[:id] if args.key?(:id)
          @ip_version = args[:ip_version] if args.key?(:ip_version)
          @kind = args[:kind] if args.key?(:kind)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
          @load_balancing_scheme = args[:load_balancing_scheme] if args.key?(:load_balancing_scheme)
          @metadata_filters = args[:metadata_filters] if args.key?(:metadata_filters)
          @name = args[:name] if args.key?(:name)
          @network = args[:network] if args.key?(:network)
          @network_tier = args[:network_tier] if args.key?(:network_tier)
          @port_range = args[:port_range] if args.key?(:port_range)
          @ports = args[:ports] if args.key?(:ports)
          @region = args[:region] if args.key?(:region)
          @self_link = args[:self_link] if args.key?(:self_link)
          @service_label = args[:service_label] if args.key?(:service_label)
          @service_name = args[:service_name] if args.key?(:service_name)
          @subnetwork = args[:subnetwork] if args.key?(:subnetwork)
          @target = args[:target] if args.key?(:target)
        end
      end
      
      # 
      class ForwardingRuleAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of ForwardingRulesScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::ForwardingRulesScopedList>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#forwardingRuleAggregatedList
        # for lists of forwarding rules.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::ForwardingRuleAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::ForwardingRuleAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of ForwardingRule resources.
      class ForwardingRuleList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of ForwardingRule resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::ForwardingRule>]
        attr_accessor :items
      
        # Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::ForwardingRuleList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::ForwardingRuleList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class ForwardingRuleReference
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `forwardingRule`
        # @return [String]
        attr_accessor :forwarding_rule
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @forwarding_rule = args[:forwarding_rule] if args.key?(:forwarding_rule)
        end
      end
      
      # 
      class ForwardingRulesScopedList
        include Google::Apis::Core::Hashable
      
        # A list of forwarding rules contained in this scope.
        # Corresponds to the JSON property `forwardingRules`
        # @return [Array<Google::Apis::ComputeBeta::ForwardingRule>]
        attr_accessor :forwarding_rules
      
        # Informational warning which replaces the list of forwarding rules when the
        # list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::ForwardingRulesScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @forwarding_rules = args[:forwarding_rules] if args.key?(:forwarding_rules)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Informational warning which replaces the list of forwarding rules when the
        # list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::ForwardingRulesScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class GlobalSetLabelsRequest
        include Google::Apis::Core::Hashable
      
        # The fingerprint of the previous set of labels for this resource, used to
        # detect conflicts. The fingerprint is initially generated by Compute Engine and
        # changes after every request to modify or update labels. You must always
        # provide an up-to-date fingerprint hash when updating or changing labels,
        # otherwise the request will fail with error 412 conditionNotMet. Make a get()
        # request to the resource to get the latest fingerprint.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # A list of labels to apply for this resource. Each label key & value must
        # comply with RFC1035. Specifically, the name must be 1-63 characters long and
        # match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the
        # first character must be a lowercase letter, and all following characters must
        # be a dash, lowercase letter, or digit, except the last character, which cannot
        # be a dash. For example, "webserver-frontend": "images". A label value can also
        # be empty (e.g. "my-label": "").
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
        end
      end
      
      # 
      class GlobalSetPolicyRequest
        include Google::Apis::Core::Hashable
      
        # Flatten Policy to create a backward compatible wire-format. Deprecated. Use '
        # policy' to specify bindings.
        # Corresponds to the JSON property `bindings`
        # @return [Array<Google::Apis::ComputeBeta::Binding>]
        attr_accessor :bindings
      
        # Flatten Policy to create a backward compatible wire-format. Deprecated. Use '
        # policy' to specify the etag.
        # Corresponds to the JSON property `etag`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :etag
      
        # Defines an Identity and Access Management (IAM) policy. It is used to specify
        # access control policies for Cloud Platform resources.
        # A `Policy` consists of a list of `bindings`. A `binding` binds a list of `
        # members` to a `role`, where the members can be user accounts, Google groups,
        # Google domains, and service accounts. A `role` is a named list of permissions
        # defined by IAM.
        # **JSON Example**
        # ` "bindings": [ ` "role": "roles/owner", "members": [ "user:mike@example.com",
        # "group:admins@example.com", "domain:google.com", "serviceAccount:my-other-app@
        # appspot.gserviceaccount.com" ] `, ` "role": "roles/viewer", "members": ["user:
        # sean@example.com"] ` ] `
        # **YAML Example**
        # bindings: - members: - user:mike@example.com - group:admins@example.com -
        # domain:google.com - serviceAccount:my-other-app@appspot.gserviceaccount.com
        # role: roles/owner - members: - user:sean@example.com role: roles/viewer
        # For a description of IAM and its features, see the [IAM developer's guide](
        # https://cloud.google.com/iam/docs).
        # Corresponds to the JSON property `policy`
        # @return [Google::Apis::ComputeBeta::Policy]
        attr_accessor :policy
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @bindings = args[:bindings] if args.key?(:bindings)
          @etag = args[:etag] if args.key?(:etag)
          @policy = args[:policy] if args.key?(:policy)
        end
      end
      
      # A guest attributes entry.
      class GuestAttributes
        include Google::Apis::Core::Hashable
      
        # [Output Only] Type of the resource. Always compute#guestAttributes for guest
        # attributes entry.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # The path to be queried. This can be the default namespace ('/') or a nested
        # namespace ('//') or a specified key ('//')
        # Corresponds to the JSON property `queryPath`
        # @return [String]
        attr_accessor :query_path
      
        # Array of guest attribute namespace/key/value tuples.
        # Corresponds to the JSON property `queryValue`
        # @return [Google::Apis::ComputeBeta::GuestAttributesValue]
        attr_accessor :query_value
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # The key to search for.
        # Corresponds to the JSON property `variableKey`
        # @return [String]
        attr_accessor :variable_key
      
        # [Output Only] The value found for the requested key.
        # Corresponds to the JSON property `variableValue`
        # @return [String]
        attr_accessor :variable_value
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @kind = args[:kind] if args.key?(:kind)
          @query_path = args[:query_path] if args.key?(:query_path)
          @query_value = args[:query_value] if args.key?(:query_value)
          @self_link = args[:self_link] if args.key?(:self_link)
          @variable_key = args[:variable_key] if args.key?(:variable_key)
          @variable_value = args[:variable_value] if args.key?(:variable_value)
        end
      end
      
      # A guest attributes namespace/key/value entry.
      class GuestAttributesEntry
        include Google::Apis::Core::Hashable
      
        # Key for the guest attribute entry.
        # Corresponds to the JSON property `key`
        # @return [String]
        attr_accessor :key
      
        # Namespace for the guest attribute entry.
        # Corresponds to the JSON property `namespace`
        # @return [String]
        attr_accessor :namespace
      
        # Value for the guest attribute entry.
        # Corresponds to the JSON property `value`
        # @return [String]
        attr_accessor :value
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @key = args[:key] if args.key?(:key)
          @namespace = args[:namespace] if args.key?(:namespace)
          @value = args[:value] if args.key?(:value)
        end
      end
      
      # Array of guest attribute namespace/key/value tuples.
      class GuestAttributesValue
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::GuestAttributesEntry>]
        attr_accessor :items
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @items = args[:items] if args.key?(:items)
        end
      end
      
      # Guest OS features.
      class GuestOsFeature
        include Google::Apis::Core::Hashable
      
        # The ID of a supported feature. Read  Enabling guest operating system features
        # to see a list of available options.
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @type = args[:type] if args.key?(:type)
        end
      end
      
      # 
      class Http2HealthCheck
        include Google::Apis::Core::Hashable
      
        # The value of the host header in the HTTP/2 health check request. If left empty
        # (default value), the IP on behalf of which this health check is performed will
        # be used.
        # Corresponds to the JSON property `host`
        # @return [String]
        attr_accessor :host
      
        # The TCP port number for the health check request. The default value is 443.
        # Valid values are 1 through 65535.
        # Corresponds to the JSON property `port`
        # @return [Fixnum]
        attr_accessor :port
      
        # Port name as defined in InstanceGroup#NamedPort#name. If both port and
        # port_name are defined, port takes precedence.
        # Corresponds to the JSON property `portName`
        # @return [String]
        attr_accessor :port_name
      
        # Specifies how port is selected for health checking, can be one of following
        # values:
        # USE_FIXED_PORT: The port number in
        # port
        # is used for health checking.
        # USE_NAMED_PORT: The
        # portName
        # is used for health checking.
        # USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each
        # network endpoint is used for health checking. For other backends, the port or
        # named port specified in the Backend Service is used for health checking.
        # If not specified, HTTP2 health check follows behavior specified in
        # port
        # and
        # portName
        # fields.
        # Corresponds to the JSON property `portSpecification`
        # @return [String]
        attr_accessor :port_specification
      
        # Specifies the type of proxy header to append before sending data to the
        # backend, either NONE or PROXY_V1. The default is NONE.
        # Corresponds to the JSON property `proxyHeader`
        # @return [String]
        attr_accessor :proxy_header
      
        # The request path of the HTTP/2 health check request. The default value is /.
        # Corresponds to the JSON property `requestPath`
        # @return [String]
        attr_accessor :request_path
      
        # The string to match anywhere in the first 1024 bytes of the response body. If
        # left empty (the default value), the status code determines health. The
        # response data can only be ASCII.
        # Corresponds to the JSON property `response`
        # @return [String]
        attr_accessor :response
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @host = args[:host] if args.key?(:host)
          @port = args[:port] if args.key?(:port)
          @port_name = args[:port_name] if args.key?(:port_name)
          @port_specification = args[:port_specification] if args.key?(:port_specification)
          @proxy_header = args[:proxy_header] if args.key?(:proxy_header)
          @request_path = args[:request_path] if args.key?(:request_path)
          @response = args[:response] if args.key?(:response)
        end
      end
      
      # 
      class HttpHealthCheck
        include Google::Apis::Core::Hashable
      
        # The value of the host header in the HTTP health check request. If left empty (
        # default value), the IP on behalf of which this health check is performed will
        # be used.
        # Corresponds to the JSON property `host`
        # @return [String]
        attr_accessor :host
      
        # The TCP port number for the health check request. The default value is 80.
        # Valid values are 1 through 65535.
        # Corresponds to the JSON property `port`
        # @return [Fixnum]
        attr_accessor :port
      
        # Port name as defined in InstanceGroup#NamedPort#name. If both port and
        # port_name are defined, port takes precedence.
        # Corresponds to the JSON property `portName`
        # @return [String]
        attr_accessor :port_name
      
        # Specifies how port is selected for health checking, can be one of following
        # values:
        # USE_FIXED_PORT: The port number in
        # port
        # is used for health checking.
        # USE_NAMED_PORT: The
        # portName
        # is used for health checking.
        # USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each
        # network endpoint is used for health checking. For other backends, the port or
        # named port specified in the Backend Service is used for health checking.
        # If not specified, HTTP health check follows behavior specified in
        # port
        # and
        # portName
        # fields.
        # Corresponds to the JSON property `portSpecification`
        # @return [String]
        attr_accessor :port_specification
      
        # Specifies the type of proxy header to append before sending data to the
        # backend, either NONE or PROXY_V1. The default is NONE.
        # Corresponds to the JSON property `proxyHeader`
        # @return [String]
        attr_accessor :proxy_header
      
        # The request path of the HTTP health check request. The default value is /.
        # Corresponds to the JSON property `requestPath`
        # @return [String]
        attr_accessor :request_path
      
        # The string to match anywhere in the first 1024 bytes of the response body. If
        # left empty (the default value), the status code determines health. The
        # response data can only be ASCII.
        # Corresponds to the JSON property `response`
        # @return [String]
        attr_accessor :response
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @host = args[:host] if args.key?(:host)
          @port = args[:port] if args.key?(:port)
          @port_name = args[:port_name] if args.key?(:port_name)
          @port_specification = args[:port_specification] if args.key?(:port_specification)
          @proxy_header = args[:proxy_header] if args.key?(:proxy_header)
          @request_path = args[:request_path] if args.key?(:request_path)
          @response = args[:response] if args.key?(:response)
        end
      end
      
      # 
      class HttpsHealthCheck
        include Google::Apis::Core::Hashable
      
        # The value of the host header in the HTTPS health check request. If left empty (
        # default value), the IP on behalf of which this health check is performed will
        # be used.
        # Corresponds to the JSON property `host`
        # @return [String]
        attr_accessor :host
      
        # The TCP port number for the health check request. The default value is 443.
        # Valid values are 1 through 65535.
        # Corresponds to the JSON property `port`
        # @return [Fixnum]
        attr_accessor :port
      
        # Port name as defined in InstanceGroup#NamedPort#name. If both port and
        # port_name are defined, port takes precedence.
        # Corresponds to the JSON property `portName`
        # @return [String]
        attr_accessor :port_name
      
        # Specifies how port is selected for health checking, can be one of following
        # values:
        # USE_FIXED_PORT: The port number in
        # port
        # is used for health checking.
        # USE_NAMED_PORT: The
        # portName
        # is used for health checking.
        # USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each
        # network endpoint is used for health checking. For other backends, the port or
        # named port specified in the Backend Service is used for health checking.
        # If not specified, HTTPS health check follows behavior specified in
        # port
        # and
        # portName
        # fields.
        # Corresponds to the JSON property `portSpecification`
        # @return [String]
        attr_accessor :port_specification
      
        # Specifies the type of proxy header to append before sending data to the
        # backend, either NONE or PROXY_V1. The default is NONE.
        # Corresponds to the JSON property `proxyHeader`
        # @return [String]
        attr_accessor :proxy_header
      
        # The request path of the HTTPS health check request. The default value is /.
        # Corresponds to the JSON property `requestPath`
        # @return [String]
        attr_accessor :request_path
      
        # The string to match anywhere in the first 1024 bytes of the response body. If
        # left empty (the default value), the status code determines health. The
        # response data can only be ASCII.
        # Corresponds to the JSON property `response`
        # @return [String]
        attr_accessor :response
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @host = args[:host] if args.key?(:host)
          @port = args[:port] if args.key?(:port)
          @port_name = args[:port_name] if args.key?(:port_name)
          @port_specification = args[:port_specification] if args.key?(:port_specification)
          @proxy_header = args[:proxy_header] if args.key?(:proxy_header)
          @request_path = args[:request_path] if args.key?(:request_path)
          @response = args[:response] if args.key?(:response)
        end
      end
      
      # Represents a Health Check resource.
      # Health checks are used for most GCP load balancers and managed instance group
      # auto-healing. For more information, read Health Check Concepts.
      # To perform health checks on network load balancers, you must use either
      # httpHealthChecks or httpsHealthChecks.
      class HealthCheck
        include Google::Apis::Core::Hashable
      
        # How often (in seconds) to send a health check. The default value is 5 seconds.
        # Corresponds to the JSON property `checkIntervalSec`
        # @return [Fixnum]
        attr_accessor :check_interval_sec
      
        # [Output Only] Creation timestamp in 3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # A so-far unhealthy instance will be marked healthy after this many consecutive
        # successes. The default value is 2.
        # Corresponds to the JSON property `healthyThreshold`
        # @return [Fixnum]
        attr_accessor :healthy_threshold
      
        # 
        # Corresponds to the JSON property `http2HealthCheck`
        # @return [Google::Apis::ComputeBeta::Http2HealthCheck]
        attr_accessor :http2_health_check
      
        # 
        # Corresponds to the JSON property `httpHealthCheck`
        # @return [Google::Apis::ComputeBeta::HttpHealthCheck]
        attr_accessor :http_health_check
      
        # 
        # Corresponds to the JSON property `httpsHealthCheck`
        # @return [Google::Apis::ComputeBeta::HttpsHealthCheck]
        attr_accessor :https_health_check
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Type of the resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Name of the resource. Provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter,
        # and all following characters must be a dash, lowercase letter, or digit,
        # except the last character, which cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # [Output Only] Region where the health check resides. Not applicable to global
        # health checks.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # 
        # Corresponds to the JSON property `sslHealthCheck`
        # @return [Google::Apis::ComputeBeta::SslHealthCheck]
        attr_accessor :ssl_health_check
      
        # 
        # Corresponds to the JSON property `tcpHealthCheck`
        # @return [Google::Apis::ComputeBeta::TcpHealthCheck]
        attr_accessor :tcp_health_check
      
        # How long (in seconds) to wait before claiming failure. The default value is 5
        # seconds. It is invalid for timeoutSec to have greater value than
        # checkIntervalSec.
        # Corresponds to the JSON property `timeoutSec`
        # @return [Fixnum]
        attr_accessor :timeout_sec
      
        # Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS or HTTP2.
        # If not specified, the default is TCP. Exactly one of the protocol-specific
        # health check field must be specified, which must match type field.
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        # A so-far healthy instance will be marked unhealthy after this many consecutive
        # failures. The default value is 2.
        # Corresponds to the JSON property `unhealthyThreshold`
        # @return [Fixnum]
        attr_accessor :unhealthy_threshold
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @check_interval_sec = args[:check_interval_sec] if args.key?(:check_interval_sec)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @healthy_threshold = args[:healthy_threshold] if args.key?(:healthy_threshold)
          @http2_health_check = args[:http2_health_check] if args.key?(:http2_health_check)
          @http_health_check = args[:http_health_check] if args.key?(:http_health_check)
          @https_health_check = args[:https_health_check] if args.key?(:https_health_check)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @region = args[:region] if args.key?(:region)
          @self_link = args[:self_link] if args.key?(:self_link)
          @ssl_health_check = args[:ssl_health_check] if args.key?(:ssl_health_check)
          @tcp_health_check = args[:tcp_health_check] if args.key?(:tcp_health_check)
          @timeout_sec = args[:timeout_sec] if args.key?(:timeout_sec)
          @type = args[:type] if args.key?(:type)
          @unhealthy_threshold = args[:unhealthy_threshold] if args.key?(:unhealthy_threshold)
        end
      end
      
      # Contains a list of HealthCheck resources.
      class HealthCheckList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of HealthCheck resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::HealthCheck>]
        attr_accessor :items
      
        # Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::HealthCheckList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::HealthCheckList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # A full or valid partial URL to a health check. For example, the following are
      # valid URLs:
      # - https://www.googleapis.com/compute/beta/projects/project-id/global/
      # httpHealthChecks/health-check
      # - projects/project-id/global/httpHealthChecks/health-check
      # - global/httpHealthChecks/health-check
      class HealthCheckReference
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `healthCheck`
        # @return [String]
        attr_accessor :health_check
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @health_check = args[:health_check] if args.key?(:health_check)
        end
      end
      
      # 
      class HealthChecksAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of HealthChecksScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::HealthChecksScopedList>]
        attr_accessor :items
      
        # Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::HealthChecksAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::HealthChecksAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class HealthChecksScopedList
        include Google::Apis::Core::Hashable
      
        # A list of HealthChecks contained in this scope.
        # Corresponds to the JSON property `healthChecks`
        # @return [Array<Google::Apis::ComputeBeta::HealthCheck>]
        attr_accessor :health_checks
      
        # Informational warning which replaces the list of backend services when the
        # list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::HealthChecksScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @health_checks = args[:health_checks] if args.key?(:health_checks)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Informational warning which replaces the list of backend services when the
        # list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::HealthChecksScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class HealthStatus
        include Google::Apis::Core::Hashable
      
        # Health state of the instance.
        # Corresponds to the JSON property `healthState`
        # @return [String]
        attr_accessor :health_state
      
        # URL of the instance resource.
        # Corresponds to the JSON property `instance`
        # @return [String]
        attr_accessor :instance
      
        # The IP address represented by this resource.
        # Corresponds to the JSON property `ipAddress`
        # @return [String]
        attr_accessor :ip_address
      
        # The port on the instance.
        # Corresponds to the JSON property `port`
        # @return [Fixnum]
        attr_accessor :port
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @health_state = args[:health_state] if args.key?(:health_state)
          @instance = args[:instance] if args.key?(:instance)
          @ip_address = args[:ip_address] if args.key?(:ip_address)
          @port = args[:port] if args.key?(:port)
        end
      end
      
      # 
      class HealthStatusForNetworkEndpoint
        include Google::Apis::Core::Hashable
      
        # URL of the backend service associated with the health state of the network
        # endpoint.
        # Corresponds to the JSON property `backendService`
        # @return [Google::Apis::ComputeBeta::BackendServiceReference]
        attr_accessor :backend_service
      
        # URL of the forwarding rule associated with the health state of the network
        # endpoint.
        # Corresponds to the JSON property `forwardingRule`
        # @return [Google::Apis::ComputeBeta::ForwardingRuleReference]
        attr_accessor :forwarding_rule
      
        # A full or valid partial URL to a health check. For example, the following are
        # valid URLs:
        # - https://www.googleapis.com/compute/beta/projects/project-id/global/
        # httpHealthChecks/health-check
        # - projects/project-id/global/httpHealthChecks/health-check
        # - global/httpHealthChecks/health-check
        # Corresponds to the JSON property `healthCheck`
        # @return [Google::Apis::ComputeBeta::HealthCheckReference]
        attr_accessor :health_check
      
        # Health state of the network endpoint determined based on the health checks
        # configured.
        # Corresponds to the JSON property `healthState`
        # @return [String]
        attr_accessor :health_state
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @backend_service = args[:backend_service] if args.key?(:backend_service)
          @forwarding_rule = args[:forwarding_rule] if args.key?(:forwarding_rule)
          @health_check = args[:health_check] if args.key?(:health_check)
          @health_state = args[:health_state] if args.key?(:health_state)
        end
      end
      
      # UrlMaps A host-matching rule for a URL. If matched, will use the named
      # PathMatcher to select the BackendService.
      class HostRule
        include Google::Apis::Core::Hashable
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # The list of host patterns to match. They must be valid hostnames, except *
        # will match any string of ([a-z0-9-.]*). In that case, * must be the first
        # character and must be followed in the pattern by either - or ..
        # Corresponds to the JSON property `hosts`
        # @return [Array<String>]
        attr_accessor :hosts
      
        # The name of the PathMatcher to use to match the path portion of the URL if the
        # hostRule matches the URL's host portion.
        # Corresponds to the JSON property `pathMatcher`
        # @return [String]
        attr_accessor :path_matcher
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @description = args[:description] if args.key?(:description)
          @hosts = args[:hosts] if args.key?(:hosts)
          @path_matcher = args[:path_matcher] if args.key?(:path_matcher)
        end
      end
      
      # Specification for how requests are aborted as part of fault injection.
      class HttpFaultAbort
        include Google::Apis::Core::Hashable
      
        # The HTTP status code used to abort the request.
        # The value must be between 200 and 599 inclusive.
        # Corresponds to the JSON property `httpStatus`
        # @return [Fixnum]
        attr_accessor :http_status
      
        # The percentage of traffic (connections/operations/requests) which will be
        # aborted as part of fault injection.
        # The value must be between 0.0 and 100.0 inclusive.
        # Corresponds to the JSON property `percentage`
        # @return [Float]
        attr_accessor :percentage
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @http_status = args[:http_status] if args.key?(:http_status)
          @percentage = args[:percentage] if args.key?(:percentage)
        end
      end
      
      # Specifies the delay introduced by Loadbalancer before forwarding the request
      # to the backend service as part of fault injection.
      class HttpFaultDelay
        include Google::Apis::Core::Hashable
      
        # A Duration represents a fixed-length span of time represented as a count of
        # seconds and fractions of seconds at nanosecond resolution. It is independent
        # of any calendar and concepts like "day" or "month". Range is approximately 10,
        # 000 years.
        # Corresponds to the JSON property `fixedDelay`
        # @return [Google::Apis::ComputeBeta::Duration]
        attr_accessor :fixed_delay
      
        # The percentage of traffic (connections/operations/requests) on which delay
        # will be introduced as part of fault injection.
        # The value must be between 0.0 and 100.0 inclusive.
        # Corresponds to the JSON property `percentage`
        # @return [Float]
        attr_accessor :percentage
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @fixed_delay = args[:fixed_delay] if args.key?(:fixed_delay)
          @percentage = args[:percentage] if args.key?(:percentage)
        end
      end
      
      # The specification for fault injection introduced into traffic to test the
      # resiliency of clients to backend service failure. As part of fault injection,
      # when clients send requests to a backend service, delays can be introduced by
      # Loadbalancer on a percentage of requests before sending those request to the
      # backend service. Similarly requests from clients can be aborted by the
      # Loadbalancer for a percentage of requests.
      class HttpFaultInjection
        include Google::Apis::Core::Hashable
      
        # Specification for how requests are aborted as part of fault injection.
        # Corresponds to the JSON property `abort`
        # @return [Google::Apis::ComputeBeta::HttpFaultAbort]
        attr_accessor :abort
      
        # Specifies the delay introduced by Loadbalancer before forwarding the request
        # to the backend service as part of fault injection.
        # Corresponds to the JSON property `delay`
        # @return [Google::Apis::ComputeBeta::HttpFaultDelay]
        attr_accessor :delay
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @abort = args[:abort] if args.key?(:abort)
          @delay = args[:delay] if args.key?(:delay)
        end
      end
      
      # The request and response header transformations that take effect before the
      # request is passed along to the selected backendService.
      class HttpHeaderAction
        include Google::Apis::Core::Hashable
      
        # Headers to add to a matching request prior to forwarding the request to the
        # backendService.
        # Corresponds to the JSON property `requestHeadersToAdd`
        # @return [Array<Google::Apis::ComputeBeta::HttpHeaderOption>]
        attr_accessor :request_headers_to_add
      
        # A list of header names for headers that need to be removed from the request
        # prior to forwarding the request to the backendService.
        # Corresponds to the JSON property `requestHeadersToRemove`
        # @return [Array<String>]
        attr_accessor :request_headers_to_remove
      
        # Headers to add the response prior to sending the response back to the client.
        # Corresponds to the JSON property `responseHeadersToAdd`
        # @return [Array<Google::Apis::ComputeBeta::HttpHeaderOption>]
        attr_accessor :response_headers_to_add
      
        # A list of header names for headers that need to be removed from the response
        # prior to sending the response back to the client.
        # Corresponds to the JSON property `responseHeadersToRemove`
        # @return [Array<String>]
        attr_accessor :response_headers_to_remove
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @request_headers_to_add = args[:request_headers_to_add] if args.key?(:request_headers_to_add)
          @request_headers_to_remove = args[:request_headers_to_remove] if args.key?(:request_headers_to_remove)
          @response_headers_to_add = args[:response_headers_to_add] if args.key?(:response_headers_to_add)
          @response_headers_to_remove = args[:response_headers_to_remove] if args.key?(:response_headers_to_remove)
        end
      end
      
      # matchRule criteria for request header matches.
      class HttpHeaderMatch
        include Google::Apis::Core::Hashable
      
        # The value should exactly match contents of exactMatch.
        # Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or
        # rangeMatch must be set.
        # Corresponds to the JSON property `exactMatch`
        # @return [String]
        attr_accessor :exact_match
      
        # The name of the HTTP header to match.
        # For matching against the HTTP request's authority, use a headerMatch with the
        # header name ":authority".
        # For matching a request's method, use the headerName ":method".
        # Corresponds to the JSON property `headerName`
        # @return [String]
        attr_accessor :header_name
      
        # If set to false, the headerMatch is considered a match if the match criteria
        # above are met. If set to true, the headerMatch is considered a match if the
        # match criteria above are NOT met.
        # The default setting is false.
        # Corresponds to the JSON property `invertMatch`
        # @return [Boolean]
        attr_accessor :invert_match
        alias_method :invert_match?, :invert_match
      
        # The value of the header must start with the contents of prefixMatch.
        # Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or
        # rangeMatch must be set.
        # Corresponds to the JSON property `prefixMatch`
        # @return [String]
        attr_accessor :prefix_match
      
        # A header with the contents of headerName must exist. The match takes place
        # whether or not the request's header has a value or not.
        # Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or
        # rangeMatch must be set.
        # Corresponds to the JSON property `presentMatch`
        # @return [Boolean]
        attr_accessor :present_match
        alias_method :present_match?, :present_match
      
        # HttpRouteRuleMatch criteria for field values that must stay within the
        # specified integer range.
        # Corresponds to the JSON property `rangeMatch`
        # @return [Google::Apis::ComputeBeta::Int64RangeMatch]
        attr_accessor :range_match
      
        # The value of the header must match the regualar expression specified in
        # regexMatch. For regular expression grammar, please see:  en.cppreference.com/w/
        # cpp/regex/ecmascript
        # For matching against a port specified in the HTTP request, use a headerMatch
        # with headerName set to PORT and a regular expression that satisfies the
        # RFC2616 Host header's port specifier.
        # Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or
        # rangeMatch must be set.
        # Corresponds to the JSON property `regexMatch`
        # @return [String]
        attr_accessor :regex_match
      
        # The value of the header must end with the contents of suffixMatch.
        # Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or
        # rangeMatch must be set.
        # Corresponds to the JSON property `suffixMatch`
        # @return [String]
        attr_accessor :suffix_match
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @exact_match = args[:exact_match] if args.key?(:exact_match)
          @header_name = args[:header_name] if args.key?(:header_name)
          @invert_match = args[:invert_match] if args.key?(:invert_match)
          @prefix_match = args[:prefix_match] if args.key?(:prefix_match)
          @present_match = args[:present_match] if args.key?(:present_match)
          @range_match = args[:range_match] if args.key?(:range_match)
          @regex_match = args[:regex_match] if args.key?(:regex_match)
          @suffix_match = args[:suffix_match] if args.key?(:suffix_match)
        end
      end
      
      # Specification determining how headers are added to requests or responses.
      class HttpHeaderOption
        include Google::Apis::Core::Hashable
      
        # The name of the header.
        # Corresponds to the JSON property `headerName`
        # @return [String]
        attr_accessor :header_name
      
        # The value of the header to add.
        # Corresponds to the JSON property `headerValue`
        # @return [String]
        attr_accessor :header_value
      
        # If false, headerValue is appended to any values that already exist for the
        # header. If true, headerValue is set for the header, discarding any values that
        # were set for that header.
        # The default value is false.
        # Corresponds to the JSON property `replace`
        # @return [Boolean]
        attr_accessor :replace
        alias_method :replace?, :replace
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @header_name = args[:header_name] if args.key?(:header_name)
          @header_value = args[:header_value] if args.key?(:header_value)
          @replace = args[:replace] if args.key?(:replace)
        end
      end
      
      # Represents a legacy HTTP Health Check resource.
      # Legacy health checks are required by network load balancers. For more
      # information, read Health Check Concepts.
      class HttpHealthCheck
        include Google::Apis::Core::Hashable
      
        # How often (in seconds) to send a health check. The default value is 5 seconds.
        # Corresponds to the JSON property `checkIntervalSec`
        # @return [Fixnum]
        attr_accessor :check_interval_sec
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # A so-far unhealthy instance will be marked healthy after this many consecutive
        # successes. The default value is 2.
        # Corresponds to the JSON property `healthyThreshold`
        # @return [Fixnum]
        attr_accessor :healthy_threshold
      
        # The value of the host header in the HTTP health check request. If left empty (
        # default value), the public IP on behalf of which this health check is
        # performed will be used.
        # Corresponds to the JSON property `host`
        # @return [String]
        attr_accessor :host
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Type of the resource. Always compute#httpHealthCheck for HTTP
        # health checks.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Name of the resource. Provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter,
        # and all following characters must be a dash, lowercase letter, or digit,
        # except the last character, which cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The TCP port number for the HTTP health check request. The default value is 80.
        # Corresponds to the JSON property `port`
        # @return [Fixnum]
        attr_accessor :port
      
        # The request path of the HTTP health check request. The default value is /.
        # This field does not support query parameters.
        # Corresponds to the JSON property `requestPath`
        # @return [String]
        attr_accessor :request_path
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # How long (in seconds) to wait before claiming failure. The default value is 5
        # seconds. It is invalid for timeoutSec to have greater value than
        # checkIntervalSec.
        # Corresponds to the JSON property `timeoutSec`
        # @return [Fixnum]
        attr_accessor :timeout_sec
      
        # A so-far healthy instance will be marked unhealthy after this many consecutive
        # failures. The default value is 2.
        # Corresponds to the JSON property `unhealthyThreshold`
        # @return [Fixnum]
        attr_accessor :unhealthy_threshold
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @check_interval_sec = args[:check_interval_sec] if args.key?(:check_interval_sec)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @healthy_threshold = args[:healthy_threshold] if args.key?(:healthy_threshold)
          @host = args[:host] if args.key?(:host)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @port = args[:port] if args.key?(:port)
          @request_path = args[:request_path] if args.key?(:request_path)
          @self_link = args[:self_link] if args.key?(:self_link)
          @timeout_sec = args[:timeout_sec] if args.key?(:timeout_sec)
          @unhealthy_threshold = args[:unhealthy_threshold] if args.key?(:unhealthy_threshold)
        end
      end
      
      # Contains a list of HttpHealthCheck resources.
      class HttpHealthCheckList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of HttpHealthCheck resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::HttpHealthCheck>]
        attr_accessor :items
      
        # Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::HttpHealthCheckList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::HttpHealthCheckList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # HttpRouteRuleMatch criteria for a request's query parameter.
      class HttpQueryParameterMatch
        include Google::Apis::Core::Hashable
      
        # The queryParameterMatch matches if the value of the parameter exactly matches
        # the contents of exactMatch.
        # Only one of presentMatch, exactMatch and regexMatch must be set.
        # Corresponds to the JSON property `exactMatch`
        # @return [String]
        attr_accessor :exact_match
      
        # The name of the query parameter to match. The query parameter must exist in
        # the request, in the absence of which the request match fails.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Specifies that the queryParameterMatch matches if the request contains the
        # query parameter, irrespective of whether the parameter has a value or not.
        # Only one of presentMatch, exactMatch and regexMatch must be set.
        # Corresponds to the JSON property `presentMatch`
        # @return [Boolean]
        attr_accessor :present_match
        alias_method :present_match?, :present_match
      
        # The queryParameterMatch matches if the value of the parameter matches the
        # regular expression specified by regexMatch. For the regular expression grammar,
        # please see en.cppreference.com/w/cpp/regex/ecmascript
        # Only one of presentMatch, exactMatch and regexMatch must be set.
        # Corresponds to the JSON property `regexMatch`
        # @return [String]
        attr_accessor :regex_match
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @exact_match = args[:exact_match] if args.key?(:exact_match)
          @name = args[:name] if args.key?(:name)
          @present_match = args[:present_match] if args.key?(:present_match)
          @regex_match = args[:regex_match] if args.key?(:regex_match)
        end
      end
      
      # Specifies settings for an HTTP redirect.
      class HttpRedirectAction
        include Google::Apis::Core::Hashable
      
        # The host that will be used in the redirect response instead of the one that
        # was supplied in the request.
        # The value must be between 1 and 255 characters.
        # Corresponds to the JSON property `hostRedirect`
        # @return [String]
        attr_accessor :host_redirect
      
        # If set to true, the URL scheme in the redirected request is set to https. If
        # set to false, the URL scheme of the redirected request will remain the same as
        # that of the request.
        # This must only be set for UrlMaps used in TargetHttpProxys. Setting this true
        # for TargetHttpsProxy is not permitted.
        # The default is set to false.
        # Corresponds to the JSON property `httpsRedirect`
        # @return [Boolean]
        attr_accessor :https_redirect
        alias_method :https_redirect?, :https_redirect
      
        # The path that will be used in the redirect response instead of the one that
        # was supplied in the request.
        # Only one of pathRedirect or prefixRedirect must be specified.
        # The value must be between 1 and 1024 characters.
        # Corresponds to the JSON property `pathRedirect`
        # @return [String]
        attr_accessor :path_redirect
      
        # The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch,
        # retaining the remaining portion of the URL before redirecting the request.
        # Corresponds to the JSON property `prefixRedirect`
        # @return [String]
        attr_accessor :prefix_redirect
      
        # The HTTP Status code to use for this RedirectAction.
        # Supported values are:
        # - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
        # 
        # - FOUND, which corresponds to 302.
        # - SEE_OTHER which corresponds to 303.
        # - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request
        # method will be retained.
        # - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request
        # method will be retained.
        # Corresponds to the JSON property `redirectResponseCode`
        # @return [String]
        attr_accessor :redirect_response_code
      
        # If set to true, any accompanying query portion of the original URL is removed
        # prior to redirecting the request. If set to false, the query portion of the
        # original URL is retained.
        # The default is set to false.
        # Corresponds to the JSON property `stripQuery`
        # @return [Boolean]
        attr_accessor :strip_query
        alias_method :strip_query?, :strip_query
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @host_redirect = args[:host_redirect] if args.key?(:host_redirect)
          @https_redirect = args[:https_redirect] if args.key?(:https_redirect)
          @path_redirect = args[:path_redirect] if args.key?(:path_redirect)
          @prefix_redirect = args[:prefix_redirect] if args.key?(:prefix_redirect)
          @redirect_response_code = args[:redirect_response_code] if args.key?(:redirect_response_code)
          @strip_query = args[:strip_query] if args.key?(:strip_query)
        end
      end
      
      # The retry policy associates with HttpRouteRule
      class HttpRetryPolicy
        include Google::Apis::Core::Hashable
      
        # Specifies the allowed number retries. This number must be > 0.
        # Corresponds to the JSON property `numRetries`
        # @return [Fixnum]
        attr_accessor :num_retries
      
        # A Duration represents a fixed-length span of time represented as a count of
        # seconds and fractions of seconds at nanosecond resolution. It is independent
        # of any calendar and concepts like "day" or "month". Range is approximately 10,
        # 000 years.
        # Corresponds to the JSON property `perTryTimeout`
        # @return [Google::Apis::ComputeBeta::Duration]
        attr_accessor :per_try_timeout
      
        # Specfies one or more conditions when this retry rule applies. Valid values are:
        # 
        # - 5xx: Loadbalancer will attempt a retry if the backend service responds with
        # any 5xx response code, or if the backend service does not respond at all,
        # example: disconnects, reset, read timeout, connection failure, and refused
        # streams.
        # - gateway-error: Similar to 5xx, but only applies to response codes 502, 503
        # or 504.
        # -
        # - connect-failure: Loadbalancer will retry on failures connecting to backend
        # services, for example due to connection timeouts.
        # - retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
        # Currently the only retriable error supported is 409.
        # - refused-stream:Loadbalancer will retry if the backend service resets the
        # stream with a REFUSED_STREAM error code. This reset type indicates that it is
        # safe to retry.
        # - cancelledLoadbalancer will retry if the gRPC status code in the response
        # header is set to cancelled
        # - deadline-exceeded: Loadbalancer will retry if the gRPC status code in the
        # response header is set to deadline-exceeded
        # - resource-exhausted: Loadbalancer will retry if the gRPC status code in the
        # response header is set to resource-exhausted
        # - unavailable: Loadbalancer will retry if the gRPC status code in the response
        # header is set to unavailable
        # Corresponds to the JSON property `retryConditions`
        # @return [Array<String>]
        attr_accessor :retry_conditions
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @num_retries = args[:num_retries] if args.key?(:num_retries)
          @per_try_timeout = args[:per_try_timeout] if args.key?(:per_try_timeout)
          @retry_conditions = args[:retry_conditions] if args.key?(:retry_conditions)
        end
      end
      
      # 
      class HttpRouteAction
        include Google::Apis::Core::Hashable
      
        # The specification for allowing client side cross-origin requests. Please see
        # W3C Recommendation for Cross Origin Resource Sharing
        # Corresponds to the JSON property `corsPolicy`
        # @return [Google::Apis::ComputeBeta::CorsPolicy]
        attr_accessor :cors_policy
      
        # The specification for fault injection introduced into traffic to test the
        # resiliency of clients to backend service failure. As part of fault injection,
        # when clients send requests to a backend service, delays can be introduced by
        # Loadbalancer on a percentage of requests before sending those request to the
        # backend service. Similarly requests from clients can be aborted by the
        # Loadbalancer for a percentage of requests.
        # Corresponds to the JSON property `faultInjectionPolicy`
        # @return [Google::Apis::ComputeBeta::HttpFaultInjection]
        attr_accessor :fault_injection_policy
      
        # A policy that specifies how requests intended for the route's backends are
        # shadowed to a separate mirrored backend service. Loadbalancer does not wait
        # for responses from the shadow service. Prior to sending traffic to the shadow
        # service, the host / authority header is suffixed with -shadow.
        # Corresponds to the JSON property `requestMirrorPolicy`
        # @return [Google::Apis::ComputeBeta::RequestMirrorPolicy]
        attr_accessor :request_mirror_policy
      
        # The retry policy associates with HttpRouteRule
        # Corresponds to the JSON property `retryPolicy`
        # @return [Google::Apis::ComputeBeta::HttpRetryPolicy]
        attr_accessor :retry_policy
      
        # A Duration represents a fixed-length span of time represented as a count of
        # seconds and fractions of seconds at nanosecond resolution. It is independent
        # of any calendar and concepts like "day" or "month". Range is approximately 10,
        # 000 years.
        # Corresponds to the JSON property `timeout`
        # @return [Google::Apis::ComputeBeta::Duration]
        attr_accessor :timeout
      
        # The spec for modifying the path before sending the request to the matched
        # backend service.
        # Corresponds to the JSON property `urlRewrite`
        # @return [Google::Apis::ComputeBeta::UrlRewrite]
        attr_accessor :url_rewrite
      
        # A list of weighted backend services to send traffic to when a route match
        # occurs. The weights determine the fraction of traffic that flows to their
        # corresponding backend service. If all traffic needs to go to a single backend
        # service, there must be one  weightedBackendService with weight set to a non 0
        # number.
        # Once a backendService is identified and before forwarding the request to the
        # backend service, advanced routing actions like Url rewrites and header
        # transformations are applied depending on additional settings specified in this
        # HttpRouteAction.
        # Corresponds to the JSON property `weightedBackendServices`
        # @return [Array<Google::Apis::ComputeBeta::WeightedBackendService>]
        attr_accessor :weighted_backend_services
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @cors_policy = args[:cors_policy] if args.key?(:cors_policy)
          @fault_injection_policy = args[:fault_injection_policy] if args.key?(:fault_injection_policy)
          @request_mirror_policy = args[:request_mirror_policy] if args.key?(:request_mirror_policy)
          @retry_policy = args[:retry_policy] if args.key?(:retry_policy)
          @timeout = args[:timeout] if args.key?(:timeout)
          @url_rewrite = args[:url_rewrite] if args.key?(:url_rewrite)
          @weighted_backend_services = args[:weighted_backend_services] if args.key?(:weighted_backend_services)
        end
      end
      
      # An HttpRouteRule specifies how to match an HTTP request and the corresponding
      # routing action that load balancing proxies will perform.
      class HttpRouteRule
        include Google::Apis::Core::Hashable
      
        # The request and response header transformations that take effect before the
        # request is passed along to the selected backendService.
        # Corresponds to the JSON property `headerAction`
        # @return [Google::Apis::ComputeBeta::HttpHeaderAction]
        attr_accessor :header_action
      
        # 
        # Corresponds to the JSON property `matchRules`
        # @return [Array<Google::Apis::ComputeBeta::HttpRouteRuleMatch>]
        attr_accessor :match_rules
      
        # In response to a matching matchRule, the load balancer performs advanced
        # routing actions like URL rewrites, header transformations, etc. prior to
        # forwarding the request to the selected backend. If  routeAction specifies any
        # weightedBackendServices, service must not be set. Conversely if service is set,
        # routeAction cannot contain any  weightedBackendServices.
        # Only one of routeAction or urlRedirect must be set.
        # Corresponds to the JSON property `routeAction`
        # @return [Google::Apis::ComputeBeta::HttpRouteAction]
        attr_accessor :route_action
      
        # The full or partial URL of the backend service resource to which traffic is
        # directed if this rule is matched. If routeAction is additionally specified,
        # advanced routing actions like URL Rewrites, etc. take effect prior to sending
        # the request to the backend. However, if service is specified, routeAction
        # cannot contain any weightedBackendService s. Conversely, if routeAction
        # specifies any  weightedBackendServices, service must not be specified.
        # Only one of urlRedirect, service or routeAction.weightedBackendService must be
        # set.
        # Corresponds to the JSON property `service`
        # @return [String]
        attr_accessor :service
      
        # Specifies settings for an HTTP redirect.
        # Corresponds to the JSON property `urlRedirect`
        # @return [Google::Apis::ComputeBeta::HttpRedirectAction]
        attr_accessor :url_redirect
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @header_action = args[:header_action] if args.key?(:header_action)
          @match_rules = args[:match_rules] if args.key?(:match_rules)
          @route_action = args[:route_action] if args.key?(:route_action)
          @service = args[:service] if args.key?(:service)
          @url_redirect = args[:url_redirect] if args.key?(:url_redirect)
        end
      end
      
      # HttpRouteRuleMatch specifies a set of criteria for matching requests to an
      # HttpRouteRule. All specified criteria must be satisfied for a match to occur.
      class HttpRouteRuleMatch
        include Google::Apis::Core::Hashable
      
        # For satifying the matchRule condition, the path of the request must exactly
        # match the value specified in fullPathMatch after removing any query parameters
        # and anchor that may be part of the original URL.
        # FullPathMatch must be between 1 and 1024 characters.
        # Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
        # Corresponds to the JSON property `fullPathMatch`
        # @return [String]
        attr_accessor :full_path_match
      
        # Specifies a list of header match criteria, all of which must match
        # corresponding headers in the request.
        # Corresponds to the JSON property `headerMatches`
        # @return [Array<Google::Apis::ComputeBeta::HttpHeaderMatch>]
        attr_accessor :header_matches
      
        # Specifies that prefixMatch and fullPathMatch matches are case sensitive.
        # The default value is false.
        # caseSensitive must not be used with regexMatch.
        # Corresponds to the JSON property `ignoreCase`
        # @return [Boolean]
        attr_accessor :ignore_case
        alias_method :ignore_case?, :ignore_case
      
        # Opaque filter criteria used by Loadbalancer to restrict routing configuration
        # to a limited set xDS compliant clients. In their xDS requests to Loadbalancer,
        # xDS clients present node metadata. If a match takes place, the relevant
        # routing configuration is made available to those proxies.
        # For each metadataFilter in this list, if its filterMatchCriteria is set to
        # MATCH_ANY, at least one of the filterLabels must match the corresponding label
        # provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then
        # all of its filterLabels must match with corresponding labels in the provided
        # metadata.
        # metadataFilters specified here can be overrides those specified in
        # ForwardingRule that refers to this UrlMap.
        # metadataFilters only applies to Loadbalancers that have their
        # loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        # Corresponds to the JSON property `metadataFilters`
        # @return [Array<Google::Apis::ComputeBeta::MetadataFilter>]
        attr_accessor :metadata_filters
      
        # For satifying the matchRule condition, the request's path must begin with the
        # specified prefixMatch. prefixMatch must begin with a /.
        # The value must be between 1 and 1024 characters.
        # Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
        # Corresponds to the JSON property `prefixMatch`
        # @return [String]
        attr_accessor :prefix_match
      
        # Specifies a list of query parameter match criteria, all of which must match
        # corresponding query parameters in the request.
        # Corresponds to the JSON property `queryParameterMatches`
        # @return [Array<Google::Apis::ComputeBeta::HttpQueryParameterMatch>]
        attr_accessor :query_parameter_matches
      
        # For satifying the matchRule condition, the path of the request must satisfy
        # the regular expression specified in regexMatch after removing any query
        # parameters and anchor supplied with the original URL. For regular expression
        # grammar please see en.cppreference.com/w/cpp/regex/ecmascript
        # Only one of prefixMatch, fullPathMatch or regexMatch must be specified.
        # Corresponds to the JSON property `regexMatch`
        # @return [String]
        attr_accessor :regex_match
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @full_path_match = args[:full_path_match] if args.key?(:full_path_match)
          @header_matches = args[:header_matches] if args.key?(:header_matches)
          @ignore_case = args[:ignore_case] if args.key?(:ignore_case)
          @metadata_filters = args[:metadata_filters] if args.key?(:metadata_filters)
          @prefix_match = args[:prefix_match] if args.key?(:prefix_match)
          @query_parameter_matches = args[:query_parameter_matches] if args.key?(:query_parameter_matches)
          @regex_match = args[:regex_match] if args.key?(:regex_match)
        end
      end
      
      # Represents a legacy HTTPS Health Check resource.
      # Legacy health checks are required by network load balancers. For more
      # information, read Health Check Concepts.
      class HttpsHealthCheck
        include Google::Apis::Core::Hashable
      
        # How often (in seconds) to send a health check. The default value is 5 seconds.
        # Corresponds to the JSON property `checkIntervalSec`
        # @return [Fixnum]
        attr_accessor :check_interval_sec
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # A so-far unhealthy instance will be marked healthy after this many consecutive
        # successes. The default value is 2.
        # Corresponds to the JSON property `healthyThreshold`
        # @return [Fixnum]
        attr_accessor :healthy_threshold
      
        # The value of the host header in the HTTPS health check request. If left empty (
        # default value), the public IP on behalf of which this health check is
        # performed will be used.
        # Corresponds to the JSON property `host`
        # @return [String]
        attr_accessor :host
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Type of the resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Name of the resource. Provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter,
        # and all following characters must be a dash, lowercase letter, or digit,
        # except the last character, which cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The TCP port number for the HTTPS health check request. The default value is
        # 443.
        # Corresponds to the JSON property `port`
        # @return [Fixnum]
        attr_accessor :port
      
        # The request path of the HTTPS health check request. The default value is "/".
        # Corresponds to the JSON property `requestPath`
        # @return [String]
        attr_accessor :request_path
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # How long (in seconds) to wait before claiming failure. The default value is 5
        # seconds. It is invalid for timeoutSec to have a greater value than
        # checkIntervalSec.
        # Corresponds to the JSON property `timeoutSec`
        # @return [Fixnum]
        attr_accessor :timeout_sec
      
        # A so-far healthy instance will be marked unhealthy after this many consecutive
        # failures. The default value is 2.
        # Corresponds to the JSON property `unhealthyThreshold`
        # @return [Fixnum]
        attr_accessor :unhealthy_threshold
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @check_interval_sec = args[:check_interval_sec] if args.key?(:check_interval_sec)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @healthy_threshold = args[:healthy_threshold] if args.key?(:healthy_threshold)
          @host = args[:host] if args.key?(:host)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @port = args[:port] if args.key?(:port)
          @request_path = args[:request_path] if args.key?(:request_path)
          @self_link = args[:self_link] if args.key?(:self_link)
          @timeout_sec = args[:timeout_sec] if args.key?(:timeout_sec)
          @unhealthy_threshold = args[:unhealthy_threshold] if args.key?(:unhealthy_threshold)
        end
      end
      
      # Contains a list of HttpsHealthCheck resources.
      class HttpsHealthCheckList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of HttpsHealthCheck resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::HttpsHealthCheck>]
        attr_accessor :items
      
        # Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::HttpsHealthCheckList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::HttpsHealthCheckList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Represents an Image resource.
      # You can use images to create boot disks for your VM instances. For more
      # information, read Images. (== resource_for beta.images ==) (== resource_for v1.
      # images ==)
      class Image
        include Google::Apis::Core::Hashable
      
        # Size of the image tar.gz archive stored in Google Cloud Storage (in bytes).
        # Corresponds to the JSON property `archiveSizeBytes`
        # @return [Fixnum]
        attr_accessor :archive_size_bytes
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # Deprecation status for a public resource.
        # Corresponds to the JSON property `deprecated`
        # @return [Google::Apis::ComputeBeta::DeprecationStatus]
        attr_accessor :deprecated
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Size of the image when restored onto a persistent disk (in GB).
        # Corresponds to the JSON property `diskSizeGb`
        # @return [Fixnum]
        attr_accessor :disk_size_gb
      
        # The name of the image family to which this image belongs. You can create disks
        # by specifying an image family instead of a specific image name. The image
        # family always returns its latest image that is not deprecated. The name of the
        # image family must comply with RFC1035.
        # Corresponds to the JSON property `family`
        # @return [String]
        attr_accessor :family
      
        # A list of features to enable on the guest operating system. Applicable only
        # for bootable images. Read  Enabling guest operating system features to see a
        # list of available options.
        # Corresponds to the JSON property `guestOsFeatures`
        # @return [Array<Google::Apis::ComputeBeta::GuestOsFeature>]
        attr_accessor :guest_os_features
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Represents a customer-supplied encryption key
        # Corresponds to the JSON property `imageEncryptionKey`
        # @return [Google::Apis::ComputeBeta::CustomerEncryptionKey]
        attr_accessor :image_encryption_key
      
        # [Output Only] Type of the resource. Always compute#image for images.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # A fingerprint for the labels being applied to this image, which is essentially
        # a hash of the labels used for optimistic locking. The fingerprint is initially
        # generated by Compute Engine and changes after every request to modify or
        # update labels. You must always provide an up-to-date fingerprint hash in order
        # to update or change labels, otherwise the request will fail with error 412
        # conditionNotMet.
        # To see the latest fingerprint, make a get() request to retrieve an image.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # Labels to apply to this image. These can be later modified by the setLabels
        # method.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # Integer license codes indicating which licenses are attached to this image.
        # Corresponds to the JSON property `licenseCodes`
        # @return [Array<Fixnum>]
        attr_accessor :license_codes
      
        # Any applicable license URI.
        # Corresponds to the JSON property `licenses`
        # @return [Array<String>]
        attr_accessor :licenses
      
        # Name of the resource; provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter,
        # and all following characters must be a dash, lowercase letter, or digit,
        # except the last character, which cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The parameters of the raw disk image.
        # Corresponds to the JSON property `rawDisk`
        # @return [Google::Apis::ComputeBeta::Image::RawDisk]
        attr_accessor :raw_disk
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # URL of the source disk used to create this image. This can be a full or valid
        # partial URL. You must provide either this property or the rawDisk.source
        # property but not both to create an image. For example, the following are valid
        # values:
        # - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
        # - projects/project/zones/zone/disks/disk
        # - zones/zone/disks/disk
        # Corresponds to the JSON property `sourceDisk`
        # @return [String]
        attr_accessor :source_disk
      
        # Represents a customer-supplied encryption key
        # Corresponds to the JSON property `sourceDiskEncryptionKey`
        # @return [Google::Apis::ComputeBeta::CustomerEncryptionKey]
        attr_accessor :source_disk_encryption_key
      
        # [Output Only] The ID value of the disk used to create this image. This value
        # may be used to determine whether the image was taken from the current or a
        # previous instance of a given disk name.
        # Corresponds to the JSON property `sourceDiskId`
        # @return [String]
        attr_accessor :source_disk_id
      
        # URL of the source image used to create this image. This can be a full or valid
        # partial URL. You must provide exactly one of:
        # - this property, or
        # - the rawDisk.source property, or
        # - the sourceDisk property   in order to create an image.
        # Corresponds to the JSON property `sourceImage`
        # @return [String]
        attr_accessor :source_image
      
        # Represents a customer-supplied encryption key
        # Corresponds to the JSON property `sourceImageEncryptionKey`
        # @return [Google::Apis::ComputeBeta::CustomerEncryptionKey]
        attr_accessor :source_image_encryption_key
      
        # [Output Only] The ID value of the image used to create this image. This value
        # may be used to determine whether the image was taken from the current or a
        # previous instance of a given image name.
        # Corresponds to the JSON property `sourceImageId`
        # @return [String]
        attr_accessor :source_image_id
      
        # URL of the source snapshot used to create this image. This can be a full or
        # valid partial URL. You must provide exactly one of:
        # - this property, or
        # - the sourceImage property, or
        # - the rawDisk.source property, or
        # - the sourceDisk property   in order to create an image.
        # Corresponds to the JSON property `sourceSnapshot`
        # @return [String]
        attr_accessor :source_snapshot
      
        # Represents a customer-supplied encryption key
        # Corresponds to the JSON property `sourceSnapshotEncryptionKey`
        # @return [Google::Apis::ComputeBeta::CustomerEncryptionKey]
        attr_accessor :source_snapshot_encryption_key
      
        # [Output Only] The ID value of the snapshot used to create this image. This
        # value may be used to determine whether the snapshot was taken from the current
        # or a previous instance of a given snapshot name.
        # Corresponds to the JSON property `sourceSnapshotId`
        # @return [String]
        attr_accessor :source_snapshot_id
      
        # The type of the image used to create this disk. The default and only value is
        # RAW
        # Corresponds to the JSON property `sourceType`
        # @return [String]
        attr_accessor :source_type
      
        # [Output Only] The status of the image. An image can be used to create other
        # resources, such as instances, only after the image has been successfully
        # created and the status is set to READY. Possible values are FAILED, PENDING,
        # or READY.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        # Cloud Storage bucket storage location of the image (regional or multi-regional)
        # .
        # Corresponds to the JSON property `storageLocations`
        # @return [Array<String>]
        attr_accessor :storage_locations
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @archive_size_bytes = args[:archive_size_bytes] if args.key?(:archive_size_bytes)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @deprecated = args[:deprecated] if args.key?(:deprecated)
          @description = args[:description] if args.key?(:description)
          @disk_size_gb = args[:disk_size_gb] if args.key?(:disk_size_gb)
          @family = args[:family] if args.key?(:family)
          @guest_os_features = args[:guest_os_features] if args.key?(:guest_os_features)
          @id = args[:id] if args.key?(:id)
          @image_encryption_key = args[:image_encryption_key] if args.key?(:image_encryption_key)
          @kind = args[:kind] if args.key?(:kind)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
          @license_codes = args[:license_codes] if args.key?(:license_codes)
          @licenses = args[:licenses] if args.key?(:licenses)
          @name = args[:name] if args.key?(:name)
          @raw_disk = args[:raw_disk] if args.key?(:raw_disk)
          @self_link = args[:self_link] if args.key?(:self_link)
          @source_disk = args[:source_disk] if args.key?(:source_disk)
          @source_disk_encryption_key = args[:source_disk_encryption_key] if args.key?(:source_disk_encryption_key)
          @source_disk_id = args[:source_disk_id] if args.key?(:source_disk_id)
          @source_image = args[:source_image] if args.key?(:source_image)
          @source_image_encryption_key = args[:source_image_encryption_key] if args.key?(:source_image_encryption_key)
          @source_image_id = args[:source_image_id] if args.key?(:source_image_id)
          @source_snapshot = args[:source_snapshot] if args.key?(:source_snapshot)
          @source_snapshot_encryption_key = args[:source_snapshot_encryption_key] if args.key?(:source_snapshot_encryption_key)
          @source_snapshot_id = args[:source_snapshot_id] if args.key?(:source_snapshot_id)
          @source_type = args[:source_type] if args.key?(:source_type)
          @status = args[:status] if args.key?(:status)
          @storage_locations = args[:storage_locations] if args.key?(:storage_locations)
        end
        
        # The parameters of the raw disk image.
        class RawDisk
          include Google::Apis::Core::Hashable
        
          # The format used to encode and transmit the block device, which should be TAR.
          # This is just a container and transmission format and not a runtime format.
          # Provided by the client when the disk image is created.
          # Corresponds to the JSON property `containerType`
          # @return [String]
          attr_accessor :container_type
        
          # [Deprecated] This field is deprecated. An optional SHA1 checksum of the disk
          # image before unpackaging provided by the client when the disk image is created.
          # Corresponds to the JSON property `sha1Checksum`
          # @return [String]
          attr_accessor :sha1_checksum
        
          # The full Google Cloud Storage URL where the disk image is stored. You must
          # provide either this property or the sourceDisk property but not both.
          # Corresponds to the JSON property `source`
          # @return [String]
          attr_accessor :source
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @container_type = args[:container_type] if args.key?(:container_type)
            @sha1_checksum = args[:sha1_checksum] if args.key?(:sha1_checksum)
            @source = args[:source] if args.key?(:source)
          end
        end
      end
      
      # Contains a list of images.
      class ImageList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Image resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::Image>]
        attr_accessor :items
      
        # Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::ImageList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::ImageList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Represents an Instance resource.
      # An instance is a virtual machine that is hosted on Google Cloud Platform. For
      # more information, read Virtual Machine Instances. (== resource_for beta.
      # instances ==) (== resource_for v1.instances ==)
      class Instance
        include Google::Apis::Core::Hashable
      
        # Allows this instance to send and receive packets with non-matching destination
        # or source IPs. This is required if you plan to use this instance to forward
        # routes. For more information, see Enabling IP Forwarding.
        # Corresponds to the JSON property `canIpForward`
        # @return [Boolean]
        attr_accessor :can_ip_forward
        alias_method :can_ip_forward?, :can_ip_forward
      
        # [Output Only] The CPU platform used by this instance.
        # Corresponds to the JSON property `cpuPlatform`
        # @return [String]
        attr_accessor :cpu_platform
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # Whether the resource should be protected against deletion.
        # Corresponds to the JSON property `deletionProtection`
        # @return [Boolean]
        attr_accessor :deletion_protection
        alias_method :deletion_protection?, :deletion_protection
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Array of disks associated with this instance. Persistent disks must be created
        # before you can assign them.
        # Corresponds to the JSON property `disks`
        # @return [Array<Google::Apis::ComputeBeta::AttachedDisk>]
        attr_accessor :disks
      
        # A set of Display Device options
        # Corresponds to the JSON property `displayDevice`
        # @return [Google::Apis::ComputeBeta::DisplayDevice]
        attr_accessor :display_device
      
        # A list of the type and count of accelerator cards attached to the instance.
        # Corresponds to the JSON property `guestAccelerators`
        # @return [Array<Google::Apis::ComputeBeta::AcceleratorConfig>]
        attr_accessor :guest_accelerators
      
        # Specifies the hostname of the instance. The specified hostname must be RFC1035
        # compliant. If hostname is not specified, the default hostname is [
        # INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [
        # INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
        # Corresponds to the JSON property `hostname`
        # @return [String]
        attr_accessor :hostname
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Type of the resource. Always compute#instance for instances.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # A fingerprint for this request, which is essentially a hash of the label's
        # contents and used for optimistic locking. The fingerprint is initially
        # generated by Compute Engine and changes after every request to modify or
        # update labels. You must always provide an up-to-date fingerprint hash in order
        # to update or change labels.
        # To see the latest fingerprint, make get() request to the instance.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # Labels to apply to this instance. These can be later modified by the setLabels
        # method.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # Full or partial URL of the machine type resource to use for this instance, in
        # the format: zones/zone/machineTypes/machine-type. This is provided by the
        # client when the instance is created. For example, the following is a valid
        # partial url to a predefined machine type:
        # zones/us-central1-f/machineTypes/n1-standard-1
        # To create a custom machine type, provide a URL to a machine type in the
        # following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24,
        # etc), and MEMORY is the total memory for this instance. Memory must be a
        # multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB):
        # zones/zone/machineTypes/custom-CPUS-MEMORY
        # For example: zones/us-central1-f/machineTypes/custom-4-5120
        # For a full list of restrictions, read the Specifications for custom machine
        # types.
        # Corresponds to the JSON property `machineType`
        # @return [String]
        attr_accessor :machine_type
      
        # A metadata key/value entry.
        # Corresponds to the JSON property `metadata`
        # @return [Google::Apis::ComputeBeta::Metadata]
        attr_accessor :metadata
      
        # Specifies a minimum CPU platform for the VM instance. Applicable values are
        # the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell"
        # or minCpuPlatform: "Intel Sandy Bridge".
        # Corresponds to the JSON property `minCpuPlatform`
        # @return [String]
        attr_accessor :min_cpu_platform
      
        # The name of the resource, provided by the client when initially creating the
        # resource. The resource name must be 1-63 characters long, and comply with
        # RFC1035. Specifically, the name must be 1-63 characters long and match the
        # regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must be a
        # dash, lowercase letter, or digit, except the last character, which cannot be a
        # dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # An array of network configurations for this instance. These specify how
        # interfaces are configured to interact with other network services, such as
        # connecting to the internet. Multiple interfaces are supported per instance.
        # Corresponds to the JSON property `networkInterfaces`
        # @return [Array<Google::Apis::ComputeBeta::NetworkInterface>]
        attr_accessor :network_interfaces
      
        # Specifies the reservations that this instance can consume from.
        # Corresponds to the JSON property `reservationAffinity`
        # @return [Google::Apis::ComputeBeta::ReservationAffinity]
        attr_accessor :reservation_affinity
      
        # Sets the scheduling options for an Instance. NextID: 9
        # Corresponds to the JSON property `scheduling`
        # @return [Google::Apis::ComputeBeta::Scheduling]
        attr_accessor :scheduling
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # A list of service accounts, with their specified scopes, authorized for this
        # instance. Only one service account per VM instance is supported.
        # Service accounts generate access tokens that can be accessed through the
        # metadata server and used to authenticate applications on the instance. See
        # Service Accounts for more information.
        # Corresponds to the JSON property `serviceAccounts`
        # @return [Array<Google::Apis::ComputeBeta::ServiceAccount>]
        attr_accessor :service_accounts
      
        # A set of Shielded Instance options.
        # Corresponds to the JSON property `shieldedInstanceConfig`
        # @return [Google::Apis::ComputeBeta::ShieldedInstanceConfig]
        attr_accessor :shielded_instance_config
      
        # The policy describes the baseline against which Instance boot integrity is
        # measured.
        # Corresponds to the JSON property `shieldedInstanceIntegrityPolicy`
        # @return [Google::Apis::ComputeBeta::ShieldedInstanceIntegrityPolicy]
        attr_accessor :shielded_instance_integrity_policy
      
        # A set of Shielded VM options.
        # Corresponds to the JSON property `shieldedVmConfig`
        # @return [Google::Apis::ComputeBeta::ShieldedVmConfig]
        attr_accessor :shielded_vm_config
      
        # The policy describes the baseline against which VM instance boot integrity is
        # measured.
        # Corresponds to the JSON property `shieldedVmIntegrityPolicy`
        # @return [Google::Apis::ComputeBeta::ShieldedVmIntegrityPolicy]
        attr_accessor :shielded_vm_integrity_policy
      
        # [Output Only] Whether a VM has been restricted for start because Compute
        # Engine has detected suspicious activity.
        # Corresponds to the JSON property `startRestricted`
        # @return [Boolean]
        attr_accessor :start_restricted
        alias_method :start_restricted?, :start_restricted
      
        # [Output Only] The status of the instance. One of the following values:
        # PROVISIONING, STAGING, RUNNING, STOPPING, STOPPED, SUSPENDING, SUSPENDED, and
        # TERMINATED.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        # [Output Only] An optional, human-readable explanation of the status.
        # Corresponds to the JSON property `statusMessage`
        # @return [String]
        attr_accessor :status_message
      
        # A set of instance tags.
        # Corresponds to the JSON property `tags`
        # @return [Google::Apis::ComputeBeta::Tags]
        attr_accessor :tags
      
        # [Output Only] URL of the zone where the instance resides. You must specify
        # this field as part of the HTTP request URL. It is not settable as a field in
        # the request body.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @can_ip_forward = args[:can_ip_forward] if args.key?(:can_ip_forward)
          @cpu_platform = args[:cpu_platform] if args.key?(:cpu_platform)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @deletion_protection = args[:deletion_protection] if args.key?(:deletion_protection)
          @description = args[:description] if args.key?(:description)
          @disks = args[:disks] if args.key?(:disks)
          @display_device = args[:display_device] if args.key?(:display_device)
          @guest_accelerators = args[:guest_accelerators] if args.key?(:guest_accelerators)
          @hostname = args[:hostname] if args.key?(:hostname)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
          @machine_type = args[:machine_type] if args.key?(:machine_type)
          @metadata = args[:metadata] if args.key?(:metadata)
          @min_cpu_platform = args[:min_cpu_platform] if args.key?(:min_cpu_platform)
          @name = args[:name] if args.key?(:name)
          @network_interfaces = args[:network_interfaces] if args.key?(:network_interfaces)
          @reservation_affinity = args[:reservation_affinity] if args.key?(:reservation_affinity)
          @scheduling = args[:scheduling] if args.key?(:scheduling)
          @self_link = args[:self_link] if args.key?(:self_link)
          @service_accounts = args[:service_accounts] if args.key?(:service_accounts)
          @shielded_instance_config = args[:shielded_instance_config] if args.key?(:shielded_instance_config)
          @shielded_instance_integrity_policy = args[:shielded_instance_integrity_policy] if args.key?(:shielded_instance_integrity_policy)
          @shielded_vm_config = args[:shielded_vm_config] if args.key?(:shielded_vm_config)
          @shielded_vm_integrity_policy = args[:shielded_vm_integrity_policy] if args.key?(:shielded_vm_integrity_policy)
          @start_restricted = args[:start_restricted] if args.key?(:start_restricted)
          @status = args[:status] if args.key?(:status)
          @status_message = args[:status_message] if args.key?(:status_message)
          @tags = args[:tags] if args.key?(:tags)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class InstanceAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # An object that contains a list of instances scoped by zone.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::InstancesScopedList>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#instanceAggregatedList for
        # aggregated lists of Instance resources.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::InstanceAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::InstanceAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Represents an unmanaged Instance Group resource.
      # Use unmanaged instance groups if you need to apply load balancing to groups of
      # heterogeneous instances or if you need to manage the instances yourself. For
      # more information, read  Instance groups.
      # For zonal unmanaged Instance Group, use instanceGroups resource.
      # For regional unmanaged Instance Group, use regionInstanceGroups resource. (==
      # resource_for beta.instanceGroups ==) (== resource_for v1.instanceGroups ==) (==
      # resource_for beta.regionInstanceGroups ==) (== resource_for v1.
      # regionInstanceGroups ==)
      class InstanceGroup
        include Google::Apis::Core::Hashable
      
        # [Output Only] The creation timestamp for this instance group in RFC3339 text
        # format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The fingerprint of the named ports. The system uses this
        # fingerprint to detect conflicts when multiple users change the named ports
        # concurrently.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # [Output Only] A unique identifier for this instance group, generated by the
        # server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] The resource type, which is always compute#instanceGroup for
        # instance groups.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # The name of the instance group. The name must be 1-63 characters long, and
        # comply with RFC1035.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Assigns a name to a port number. For example: `name: "http", port: 80`
        # This allows the system to reference ports by the assigned name instead of a
        # port number. Named ports can also contain multiple ports. For example: [`name:
        # "http", port: 80`,`name: "http", port: 8080`]
        # Named ports apply to all instances in this instance group.
        # Corresponds to the JSON property `namedPorts`
        # @return [Array<Google::Apis::ComputeBeta::NamedPort>]
        attr_accessor :named_ports
      
        # The URL of the network to which all instances in the instance group belong.
        # Corresponds to the JSON property `network`
        # @return [String]
        attr_accessor :network
      
        # [Output Only] The URL of the region where the instance group is located (for
        # regional resources).
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # [Output Only] The URL for this instance group. The server generates this URL.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] The total number of instances in the instance group.
        # Corresponds to the JSON property `size`
        # @return [Fixnum]
        attr_accessor :size
      
        # [Output Only] The URL of the subnetwork to which all instances in the instance
        # group belong.
        # Corresponds to the JSON property `subnetwork`
        # @return [String]
        attr_accessor :subnetwork
      
        # [Output Only] The URL of the zone where the instance group is located (for
        # zonal resources).
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @named_ports = args[:named_ports] if args.key?(:named_ports)
          @network = args[:network] if args.key?(:network)
          @region = args[:region] if args.key?(:region)
          @self_link = args[:self_link] if args.key?(:self_link)
          @size = args[:size] if args.key?(:size)
          @subnetwork = args[:subnetwork] if args.key?(:subnetwork)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class InstanceGroupAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InstanceGroupsScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::InstanceGroupsScopedList>]
        attr_accessor :items
      
        # [Output Only] The resource type, which is always compute#
        # instanceGroupAggregatedList for aggregated lists of instance groups.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::InstanceGroupAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::InstanceGroupAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # A list of InstanceGroup resources.
      class InstanceGroupList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InstanceGroup resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::InstanceGroup>]
        attr_accessor :items
      
        # [Output Only] The resource type, which is always compute#instanceGroupList for
        # instance group lists.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::InstanceGroupList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::InstanceGroupList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Represents a Managed Instance Group resource.
      # An instance group is a collection of VM instances that you can manage as a
      # single entity. For more information, read Instance groups.
      # For zonal Managed Instance Group, use the instanceGroupManagers resource.
      # For regional Managed Instance Group, use the regionInstanceGroupManagers
      # resource. (== resource_for beta.instanceGroupManagers ==) (== resource_for v1.
      # instanceGroupManagers ==) (== resource_for beta.regionInstanceGroupManagers ==)
      # (== resource_for v1.regionInstanceGroupManagers ==)
      class InstanceGroupManager
        include Google::Apis::Core::Hashable
      
        # The autohealing policy for this managed instance group. You can specify only
        # one value.
        # Corresponds to the JSON property `autoHealingPolicies`
        # @return [Array<Google::Apis::ComputeBeta::InstanceGroupManagerAutoHealingPolicy>]
        attr_accessor :auto_healing_policies
      
        # The base instance name to use for instances in this group. The value must be 1-
        # 58 characters long. Instances are named by appending a hyphen and a random
        # four-character string to the base instance name. The base instance name must
        # comply with RFC1035.
        # Corresponds to the JSON property `baseInstanceName`
        # @return [String]
        attr_accessor :base_instance_name
      
        # [Output Only] The creation timestamp for this managed instance group in
        # RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # [Output Only] The list of instance actions and the number of instances in this
        # managed instance group that are scheduled for each of those actions.
        # Corresponds to the JSON property `currentActions`
        # @return [Google::Apis::ComputeBeta::InstanceGroupManagerActionsSummary]
        attr_accessor :current_actions
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Policy specifying intended distribution of instances in regional managed
        # instance group.
        # Corresponds to the JSON property `distributionPolicy`
        # @return [Google::Apis::ComputeBeta::DistributionPolicy]
        attr_accessor :distribution_policy
      
        # The action to perform in case of zone failure. Only one value is supported,
        # NO_FAILOVER. The default is NO_FAILOVER.
        # Corresponds to the JSON property `failoverAction`
        # @return [String]
        attr_accessor :failover_action
      
        # Fingerprint of this resource. This field may be used in optimistic locking. It
        # will be ignored when inserting an InstanceGroupManager. An up-to-date
        # fingerprint must be provided in order to update the InstanceGroupManager,
        # otherwise the request will fail with error 412 conditionNotMet.
        # To see the latest fingerprint, make a get() request to retrieve an
        # InstanceGroupManager.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # [Output Only] A unique identifier for this resource type. The server generates
        # this identifier.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] The URL of the Instance Group resource.
        # Corresponds to the JSON property `instanceGroup`
        # @return [String]
        attr_accessor :instance_group
      
        # The URL of the instance template that is specified for this managed instance
        # group. The group uses this template to create all new instances in the managed
        # instance group.
        # Corresponds to the JSON property `instanceTemplate`
        # @return [String]
        attr_accessor :instance_template
      
        # [Output Only] The resource type, which is always compute#instanceGroupManager
        # for managed instance groups.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # The name of the managed instance group. The name must be 1-63 characters long,
        # and comply with RFC1035.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Named ports configured for the Instance Groups complementary to this Instance
        # Group Manager.
        # Corresponds to the JSON property `namedPorts`
        # @return [Array<Google::Apis::ComputeBeta::NamedPort>]
        attr_accessor :named_ports
      
        # [Deprecated] This field is deprecated and will be removed. Prefer using the
        # status field instead. Please contact cloud-updater-feedback@google.com to
        # leave feedback if your workload relies on this field. [Output Only] The list
        # of instance actions and the number of instances in this managed instance group
        # that are pending for each of those actions.
        # Corresponds to the JSON property `pendingActions`
        # @return [Google::Apis::ComputeBeta::InstanceGroupManagerPendingActionsSummary]
        attr_accessor :pending_actions
      
        # [Output Only] The URL of the region where the managed instance group resides (
        # for regional resources).
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # [Output Only] The URL for this managed instance group. The server defines this
        # URL.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # The service account to be used as credentials for all operations performed by
        # the managed instance group on instances. The service accounts needs all
        # permissions required to create and delete instances. By default, the service
        # account `projectNumber`@cloudservices.gserviceaccount.com is used.
        # Corresponds to the JSON property `serviceAccount`
        # @return [String]
        attr_accessor :service_account
      
        # [Output Only] The status of this managed instance group.
        # Corresponds to the JSON property `status`
        # @return [Google::Apis::ComputeBeta::InstanceGroupManagerStatus]
        attr_accessor :status
      
        # The URLs for all TargetPool resources to which instances in the instanceGroup
        # field are added. The target pools automatically apply to all of the instances
        # in the managed instance group.
        # Corresponds to the JSON property `targetPools`
        # @return [Array<String>]
        attr_accessor :target_pools
      
        # The target number of running instances for this managed instance group.
        # Deleting or abandoning instances reduces this number. Resizing the group
        # changes this number.
        # Corresponds to the JSON property `targetSize`
        # @return [Fixnum]
        attr_accessor :target_size
      
        # The update policy for this managed instance group.
        # Corresponds to the JSON property `updatePolicy`
        # @return [Google::Apis::ComputeBeta::InstanceGroupManagerUpdatePolicy]
        attr_accessor :update_policy
      
        # Specifies the instance templates used by this managed instance group to create
        # instances.
        # Each version is defined by an instanceTemplate and a name. Every version can
        # appear at most once per instance group. This field overrides the top-level
        # instanceTemplate field. Read more about the relationships between these fields.
        # Exactly one version must leave the targetSize field unset. That version will
        # be applied to all remaining instances. For more information, read about canary
        # updates.
        # Corresponds to the JSON property `versions`
        # @return [Array<Google::Apis::ComputeBeta::InstanceGroupManagerVersion>]
        attr_accessor :versions
      
        # [Output Only] The URL of the zone where the managed instance group is located (
        # for zonal resources).
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @auto_healing_policies = args[:auto_healing_policies] if args.key?(:auto_healing_policies)
          @base_instance_name = args[:base_instance_name] if args.key?(:base_instance_name)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @current_actions = args[:current_actions] if args.key?(:current_actions)
          @description = args[:description] if args.key?(:description)
          @distribution_policy = args[:distribution_policy] if args.key?(:distribution_policy)
          @failover_action = args[:failover_action] if args.key?(:failover_action)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @id = args[:id] if args.key?(:id)
          @instance_group = args[:instance_group] if args.key?(:instance_group)
          @instance_template = args[:instance_template] if args.key?(:instance_template)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @named_ports = args[:named_ports] if args.key?(:named_ports)
          @pending_actions = args[:pending_actions] if args.key?(:pending_actions)
          @region = args[:region] if args.key?(:region)
          @self_link = args[:self_link] if args.key?(:self_link)
          @service_account = args[:service_account] if args.key?(:service_account)
          @status = args[:status] if args.key?(:status)
          @target_pools = args[:target_pools] if args.key?(:target_pools)
          @target_size = args[:target_size] if args.key?(:target_size)
          @update_policy = args[:update_policy] if args.key?(:update_policy)
          @versions = args[:versions] if args.key?(:versions)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class InstanceGroupManagerActionsSummary
        include Google::Apis::Core::Hashable
      
        # [Output Only] The total number of instances in the managed instance group that
        # are scheduled to be abandoned. Abandoning an instance removes it from the
        # managed instance group without deleting it.
        # Corresponds to the JSON property `abandoning`
        # @return [Fixnum]
        attr_accessor :abandoning
      
        # [Output Only] The number of instances in the managed instance group that are
        # scheduled to be created or are currently being created. If the group fails to
        # create any of these instances, it tries again until it creates the instance
        # successfully.
        # If you have disabled creation retries, this field will not be populated;
        # instead, the creatingWithoutRetries field will be populated.
        # Corresponds to the JSON property `creating`
        # @return [Fixnum]
        attr_accessor :creating
      
        # [Output Only] The number of instances that the managed instance group will
        # attempt to create. The group attempts to create each instance only once. If
        # the group fails to create any of these instances, it decreases the group's
        # targetSize value accordingly.
        # Corresponds to the JSON property `creatingWithoutRetries`
        # @return [Fixnum]
        attr_accessor :creating_without_retries
      
        # [Output Only] The number of instances in the managed instance group that are
        # scheduled to be deleted or are currently being deleted.
        # Corresponds to the JSON property `deleting`
        # @return [Fixnum]
        attr_accessor :deleting
      
        # [Output Only] The number of instances in the managed instance group that are
        # running and have no scheduled actions.
        # Corresponds to the JSON property `none`
        # @return [Fixnum]
        attr_accessor :none
      
        # [Output Only] The number of instances in the managed instance group that are
        # scheduled to be recreated or are currently being being recreated. Recreating
        # an instance deletes the existing root persistent disk and creates a new disk
        # from the image that is defined in the instance template.
        # Corresponds to the JSON property `recreating`
        # @return [Fixnum]
        attr_accessor :recreating
      
        # [Output Only] The number of instances in the managed instance group that are
        # being reconfigured with properties that do not require a restart or a recreate
        # action. For example, setting or removing target pools for the instance.
        # Corresponds to the JSON property `refreshing`
        # @return [Fixnum]
        attr_accessor :refreshing
      
        # [Output Only] The number of instances in the managed instance group that are
        # scheduled to be restarted or are currently being restarted.
        # Corresponds to the JSON property `restarting`
        # @return [Fixnum]
        attr_accessor :restarting
      
        # [Output Only] The number of instances in the managed instance group that are
        # being verified. See the managedInstances[].currentAction property in the
        # listManagedInstances method documentation.
        # Corresponds to the JSON property `verifying`
        # @return [Fixnum]
        attr_accessor :verifying
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @abandoning = args[:abandoning] if args.key?(:abandoning)
          @creating = args[:creating] if args.key?(:creating)
          @creating_without_retries = args[:creating_without_retries] if args.key?(:creating_without_retries)
          @deleting = args[:deleting] if args.key?(:deleting)
          @none = args[:none] if args.key?(:none)
          @recreating = args[:recreating] if args.key?(:recreating)
          @refreshing = args[:refreshing] if args.key?(:refreshing)
          @restarting = args[:restarting] if args.key?(:restarting)
          @verifying = args[:verifying] if args.key?(:verifying)
        end
      end
      
      # 
      class InstanceGroupManagerAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InstanceGroupManagersScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::InstanceGroupManagersScopedList>]
        attr_accessor :items
      
        # [Output Only] The resource type, which is always compute#
        # instanceGroupManagerAggregatedList for an aggregated list of managed instance
        # groups.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::InstanceGroupManagerAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::InstanceGroupManagerAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class InstanceGroupManagerAutoHealingPolicy
        include Google::Apis::Core::Hashable
      
        # The URL for the health check that signals autohealing.
        # Corresponds to the JSON property `healthCheck`
        # @return [String]
        attr_accessor :health_check
      
        # The number of seconds that the managed instance group waits before it applies
        # autohealing policies to new instances or recently recreated instances. This
        # initial delay allows instances to initialize and run their startup scripts
        # before the instance group determines that they are UNHEALTHY. This prevents
        # the managed instance group from recreating its instances prematurely. This
        # value must be from range [0, 3600].
        # Corresponds to the JSON property `initialDelaySec`
        # @return [Fixnum]
        attr_accessor :initial_delay_sec
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @health_check = args[:health_check] if args.key?(:health_check)
          @initial_delay_sec = args[:initial_delay_sec] if args.key?(:initial_delay_sec)
        end
      end
      
      # [Output Only] A list of managed instance groups.
      class InstanceGroupManagerList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InstanceGroupManager resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::InstanceGroupManager>]
        attr_accessor :items
      
        # [Output Only] The resource type, which is always compute#
        # instanceGroupManagerList for a list of managed instance groups.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::InstanceGroupManagerList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::InstanceGroupManagerList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class InstanceGroupManagerPendingActionsSummary
        include Google::Apis::Core::Hashable
      
        # [Deprecated] This field is deprecated and will be removed. Prefer using the
        # status field instead. Please contact cloud-updater-feedback@google.com to
        # leave feedback if your workload relies on this field. [Output Only] The number
        # of instances in the managed instance group that are pending to be created.
        # Corresponds to the JSON property `creating`
        # @return [Fixnum]
        attr_accessor :creating
      
        # [Deprecated] This field is deprecated and will be removed. Prefer using the
        # status field instead. Please contact cloud-updater-feedback@google.com to
        # leave feedback if your workload relies on this field. [Output Only] The number
        # of instances in the managed instance group that are pending to be deleted.
        # Corresponds to the JSON property `deleting`
        # @return [Fixnum]
        attr_accessor :deleting
      
        # [Deprecated] This field is deprecated and will be removed. Prefer using the
        # status field instead. Please contact cloud-updater-feedback@google.com to
        # leave feedback if your workload relies on this field. [Output Only] The number
        # of instances in the managed instance group that are pending to be recreated.
        # Corresponds to the JSON property `recreating`
        # @return [Fixnum]
        attr_accessor :recreating
      
        # [Deprecated] This field is deprecated and will be removed. Prefer using the
        # status field instead. Please contact cloud-updater-feedback@google.com to
        # leave feedback if your workload relies on this field. [Output Only] The number
        # of instances in the managed instance group that are pending to be restarted.
        # Corresponds to the JSON property `restarting`
        # @return [Fixnum]
        attr_accessor :restarting
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creating = args[:creating] if args.key?(:creating)
          @deleting = args[:deleting] if args.key?(:deleting)
          @recreating = args[:recreating] if args.key?(:recreating)
          @restarting = args[:restarting] if args.key?(:restarting)
        end
      end
      
      # 
      class InstanceGroupManagerStatus
        include Google::Apis::Core::Hashable
      
        # [Output Only] A bit indicating whether the managed instance group is in a
        # stable state. A stable state means that: none of the instances in the managed
        # instance group is currently undergoing any type of change (for example,
        # creation, restart, or deletion); no future changes are scheduled for instances
        # in the managed instance group; and the managed instance group itself is not
        # being modified.
        # Corresponds to the JSON property `isStable`
        # @return [Boolean]
        attr_accessor :is_stable
        alias_method :is_stable?, :is_stable
      
        # [Output Only] A status of consistency of Instances' versions with their target
        # version specified by version field on Instance Group Manager.
        # Corresponds to the JSON property `versionTarget`
        # @return [Google::Apis::ComputeBeta::InstanceGroupManagerStatusVersionTarget]
        attr_accessor :version_target
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @is_stable = args[:is_stable] if args.key?(:is_stable)
          @version_target = args[:version_target] if args.key?(:version_target)
        end
      end
      
      # 
      class InstanceGroupManagerStatusVersionTarget
        include Google::Apis::Core::Hashable
      
        # [Output Only] A bit indicating whether version target has been reached in this
        # managed instance group, i.e. all instances are in their target version.
        # Instances' target version are specified by version field on Instance Group
        # Manager.
        # Corresponds to the JSON property `isReached`
        # @return [Boolean]
        attr_accessor :is_reached
        alias_method :is_reached?, :is_reached
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @is_reached = args[:is_reached] if args.key?(:is_reached)
        end
      end
      
      # 
      class InstanceGroupManagerUpdatePolicy
        include Google::Apis::Core::Hashable
      
        # The  instance redistribution policy for regional managed instance groups.
        # Valid values are:
        # - PROACTIVE (default): The group attempts to maintain an even distribution of
        # VM instances across zones in the region.
        # - NONE: For non-autoscaled groups, proactive redistribution is disabled.
        # Corresponds to the JSON property `instanceRedistributionType`
        # @return [String]
        attr_accessor :instance_redistribution_type
      
        # Encapsulates numeric value that can be either absolute or relative.
        # Corresponds to the JSON property `maxSurge`
        # @return [Google::Apis::ComputeBeta::FixedOrPercent]
        attr_accessor :max_surge
      
        # Encapsulates numeric value that can be either absolute or relative.
        # Corresponds to the JSON property `maxUnavailable`
        # @return [Google::Apis::ComputeBeta::FixedOrPercent]
        attr_accessor :max_unavailable
      
        # Minimum number of seconds to wait for after a newly created instance becomes
        # available. This value must be from range [0, 3600].
        # Corresponds to the JSON property `minReadySec`
        # @return [Fixnum]
        attr_accessor :min_ready_sec
      
        # Minimal action to be taken on an instance. You can specify either RESTART to
        # restart existing instances or REPLACE to delete and create new instances from
        # the target template. If you specify a RESTART, the Updater will attempt to
        # perform that action only. However, if the Updater determines that the minimal
        # action you specify is not enough to perform the update, it might perform a
        # more disruptive action.
        # Corresponds to the JSON property `minimalAction`
        # @return [String]
        attr_accessor :minimal_action
      
        # The type of update process. You can specify either PROACTIVE so that the
        # instance group manager proactively executes actions in order to bring
        # instances to their target versions or OPPORTUNISTIC so that no action is
        # proactively executed but the update will be performed as part of other actions
        # (for example, resizes or recreateInstances calls).
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_redistribution_type = args[:instance_redistribution_type] if args.key?(:instance_redistribution_type)
          @max_surge = args[:max_surge] if args.key?(:max_surge)
          @max_unavailable = args[:max_unavailable] if args.key?(:max_unavailable)
          @min_ready_sec = args[:min_ready_sec] if args.key?(:min_ready_sec)
          @minimal_action = args[:minimal_action] if args.key?(:minimal_action)
          @type = args[:type] if args.key?(:type)
        end
      end
      
      # 
      class InstanceGroupManagerVersion
        include Google::Apis::Core::Hashable
      
        # The URL of the instance template that is specified for this managed instance
        # group. The group uses this template to create new instances in the managed
        # instance group until the `targetSize` for this version is reached.
        # Corresponds to the JSON property `instanceTemplate`
        # @return [String]
        attr_accessor :instance_template
      
        # Name of the version. Unique among all versions in the scope of this managed
        # instance group.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Encapsulates numeric value that can be either absolute or relative.
        # Corresponds to the JSON property `targetSize`
        # @return [Google::Apis::ComputeBeta::FixedOrPercent]
        attr_accessor :target_size
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_template = args[:instance_template] if args.key?(:instance_template)
          @name = args[:name] if args.key?(:name)
          @target_size = args[:target_size] if args.key?(:target_size)
        end
      end
      
      # 
      class InstanceGroupManagersAbandonInstancesRequest
        include Google::Apis::Core::Hashable
      
        # The URLs of one or more instances to abandon. This can be a full URL or a
        # partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
        # Corresponds to the JSON property `instances`
        # @return [Array<String>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # InstanceGroupManagers.applyUpdatesToInstances
      class InstanceGroupManagersApplyUpdatesRequest
        include Google::Apis::Core::Hashable
      
        # The list of URLs of one or more instances for which you want to apply updates.
        # Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[
        # INSTANCE_NAME].
        # Corresponds to the JSON property `instances`
        # @return [Array<String>]
        attr_accessor :instances
      
        # The minimal action that you want to perform on each instance during the update:
        # 
        # - REPLACE: At minimum, delete the instance and create it again.
        # - RESTART: Stop the instance and start it again.
        # - REFRESH: Do not stop the instance.
        # - NONE: Do not disrupt the instance at all.  By default, the minimum action is
        # NONE. If your update requires a more disruptive action than you set with this
        # flag, the necessary action is performed to execute the update.
        # Corresponds to the JSON property `minimalAction`
        # @return [String]
        attr_accessor :minimal_action
      
        # The most disruptive action that you want to perform on each instance during
        # the update:
        # - REPLACE: Delete the instance and create it again.
        # - RESTART: Stop the instance and start it again.
        # - REFRESH: Do not stop the instance.
        # - NONE: Do not disrupt the instance at all.  By default, the most disruptive
        # allowed action is REPLACE. If your update requires a more disruptive action
        # than you set with this flag, the update request will fail.
        # Corresponds to the JSON property `mostDisruptiveAllowedAction`
        # @return [String]
        attr_accessor :most_disruptive_allowed_action
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
          @minimal_action = args[:minimal_action] if args.key?(:minimal_action)
          @most_disruptive_allowed_action = args[:most_disruptive_allowed_action] if args.key?(:most_disruptive_allowed_action)
        end
      end
      
      # InstanceGroupManagers.createInstances
      class InstanceGroupManagersCreateInstancesRequest
        include Google::Apis::Core::Hashable
      
        # [Required] List of specifications of per-instance configs.
        # Corresponds to the JSON property `instances`
        # @return [Array<Google::Apis::ComputeBeta::PerInstanceConfig>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # 
      class InstanceGroupManagersDeleteInstancesRequest
        include Google::Apis::Core::Hashable
      
        # The URLs of one or more instances to delete. This can be a full URL or a
        # partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
        # Corresponds to the JSON property `instances`
        # @return [Array<String>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # 
      class InstanceGroupManagersListManagedInstancesResponse
        include Google::Apis::Core::Hashable
      
        # [Output Only] The list of instances in the managed instance group.
        # Corresponds to the JSON property `managedInstances`
        # @return [Array<Google::Apis::ComputeBeta::ManagedInstance>]
        attr_accessor :managed_instances
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @managed_instances = args[:managed_instances] if args.key?(:managed_instances)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
        end
      end
      
      # 
      class InstanceGroupManagersRecreateInstancesRequest
        include Google::Apis::Core::Hashable
      
        # The URLs of one or more instances to recreate. This can be a full URL or a
        # partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
        # Corresponds to the JSON property `instances`
        # @return [Array<String>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # 
      class InstanceGroupManagersResizeAdvancedRequest
        include Google::Apis::Core::Hashable
      
        # If this flag is true, the managed instance group attempts to create all
        # instances initiated by this resize request only once. If there is an error
        # during creation, the managed instance group does not retry create this
        # instance, and we will decrease the targetSize of the request instead. If the
        # flag is false, the group attempts to recreate each instance continuously until
        # it succeeds.
        # This flag matters only in the first attempt of creation of an instance. After
        # an instance is successfully created while this flag is enabled, the instance
        # behaves the same way as all the other instances created with a regular resize
        # request. In particular, if a running instance dies unexpectedly at a later
        # time and needs to be recreated, this mode does not affect the recreation
        # behavior in that scenario.
        # This flag is applicable only to the current resize request. It does not
        # influence other resize requests in any way.
        # You can see which instances is being creating in which mode by calling the get
        # or listManagedInstances API.
        # Corresponds to the JSON property `noCreationRetries`
        # @return [Boolean]
        attr_accessor :no_creation_retries
        alias_method :no_creation_retries?, :no_creation_retries
      
        # The number of running instances that the managed instance group should
        # maintain at any given time. The group automatically adds or removes instances
        # to maintain the number of instances specified by this parameter.
        # Corresponds to the JSON property `targetSize`
        # @return [Fixnum]
        attr_accessor :target_size
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @no_creation_retries = args[:no_creation_retries] if args.key?(:no_creation_retries)
          @target_size = args[:target_size] if args.key?(:target_size)
        end
      end
      
      # 
      class InstanceGroupManagersScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] The list of managed instance groups that are contained in the
        # specified project and zone.
        # Corresponds to the JSON property `instanceGroupManagers`
        # @return [Array<Google::Apis::ComputeBeta::InstanceGroupManager>]
        attr_accessor :instance_group_managers
      
        # [Output Only] The warning that replaces the list of managed instance groups
        # when the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::InstanceGroupManagersScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_group_managers = args[:instance_group_managers] if args.key?(:instance_group_managers)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] The warning that replaces the list of managed instance groups
        # when the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::InstanceGroupManagersScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class InstanceGroupManagersSetAutoHealingRequest
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `autoHealingPolicies`
        # @return [Array<Google::Apis::ComputeBeta::InstanceGroupManagerAutoHealingPolicy>]
        attr_accessor :auto_healing_policies
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @auto_healing_policies = args[:auto_healing_policies] if args.key?(:auto_healing_policies)
        end
      end
      
      # 
      class InstanceGroupManagersSetInstanceTemplateRequest
        include Google::Apis::Core::Hashable
      
        # The URL of the instance template that is specified for this managed instance
        # group. The group uses this template to create all new instances in the managed
        # instance group.
        # Corresponds to the JSON property `instanceTemplate`
        # @return [String]
        attr_accessor :instance_template
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_template = args[:instance_template] if args.key?(:instance_template)
        end
      end
      
      # 
      class InstanceGroupManagersSetTargetPoolsRequest
        include Google::Apis::Core::Hashable
      
        # The fingerprint of the target pools information. Use this optional property to
        # prevent conflicts when multiple users change the target pools settings
        # concurrently. Obtain the fingerprint with the instanceGroupManagers.get method.
        # Then, include the fingerprint in your request to ensure that you do not
        # overwrite changes that were applied from another concurrent request.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # The list of target pool URLs that instances in this managed instance group
        # belong to. The managed instance group applies these target pools to all of the
        # instances in the group. Existing instances and new instances in the group all
        # receive these target pool settings.
        # Corresponds to the JSON property `targetPools`
        # @return [Array<String>]
        attr_accessor :target_pools
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @target_pools = args[:target_pools] if args.key?(:target_pools)
        end
      end
      
      # 
      class InstanceGroupsAddInstancesRequest
        include Google::Apis::Core::Hashable
      
        # The list of instances to add to the instance group.
        # Corresponds to the JSON property `instances`
        # @return [Array<Google::Apis::ComputeBeta::InstanceReference>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # 
      class InstanceGroupsListInstances
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InstanceWithNamedPorts resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::InstanceWithNamedPorts>]
        attr_accessor :items
      
        # [Output Only] The resource type, which is always compute#
        # instanceGroupsListInstances for the list of instances in the specified
        # instance group.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::InstanceGroupsListInstances::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::InstanceGroupsListInstances::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class InstanceGroupsListInstancesRequest
        include Google::Apis::Core::Hashable
      
        # A filter for the state of the instances in the instance group. Valid options
        # are ALL or RUNNING. If you do not specify this parameter the list includes all
        # instances regardless of their state.
        # Corresponds to the JSON property `instanceState`
        # @return [String]
        attr_accessor :instance_state
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_state = args[:instance_state] if args.key?(:instance_state)
        end
      end
      
      # 
      class InstanceGroupsRemoveInstancesRequest
        include Google::Apis::Core::Hashable
      
        # The list of instances to remove from the instance group.
        # Corresponds to the JSON property `instances`
        # @return [Array<Google::Apis::ComputeBeta::InstanceReference>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # 
      class InstanceGroupsScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] The list of instance groups that are contained in this scope.
        # Corresponds to the JSON property `instanceGroups`
        # @return [Array<Google::Apis::ComputeBeta::InstanceGroup>]
        attr_accessor :instance_groups
      
        # [Output Only] An informational warning that replaces the list of instance
        # groups when the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::InstanceGroupsScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_groups = args[:instance_groups] if args.key?(:instance_groups)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] An informational warning that replaces the list of instance
        # groups when the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::InstanceGroupsScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class InstanceGroupsSetNamedPortsRequest
        include Google::Apis::Core::Hashable
      
        # The fingerprint of the named ports information for this instance group. Use
        # this optional property to prevent conflicts when multiple users change the
        # named ports settings concurrently. Obtain the fingerprint with the
        # instanceGroups.get method. Then, include the fingerprint in your request to
        # ensure that you do not overwrite changes that were applied from another
        # concurrent request. A request with an incorrect fingerprint will fail with
        # error 412 conditionNotMet.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # The list of named ports to set for this instance group.
        # Corresponds to the JSON property `namedPorts`
        # @return [Array<Google::Apis::ComputeBeta::NamedPort>]
        attr_accessor :named_ports
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @named_ports = args[:named_ports] if args.key?(:named_ports)
        end
      end
      
      # Contains a list of instances.
      class InstanceList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Instance resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::Instance>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#instanceList for lists of
        # Instance resources.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::InstanceList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::InstanceList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of instance referrers.
      class InstanceListReferrers
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Reference resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::Reference>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#instanceListReferrers for lists
        # of Instance referrers.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::InstanceListReferrers::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::InstanceListReferrers::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class MoveInstanceRequest
        include Google::Apis::Core::Hashable
      
        # The URL of the destination zone to move the instance. This can be a full or
        # partial URL. For example, the following are all valid URLs to a zone:
        # - https://www.googleapis.com/compute/v1/projects/project/zones/zone
        # - projects/project/zones/zone
        # - zones/zone
        # Corresponds to the JSON property `destinationZone`
        # @return [String]
        attr_accessor :destination_zone
      
        # The URL of the target instance to move. This can be a full or partial URL. For
        # example, the following are all valid URLs to an instance:
        # - https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/
        # instance
        # - projects/project/zones/zone/instances/instance
        # - zones/zone/instances/instance
        # Corresponds to the JSON property `targetInstance`
        # @return [String]
        attr_accessor :target_instance
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @destination_zone = args[:destination_zone] if args.key?(:destination_zone)
          @target_instance = args[:target_instance] if args.key?(:target_instance)
        end
      end
      
      # 
      class InstanceProperties
        include Google::Apis::Core::Hashable
      
        # Enables instances created based on this template to send packets with source
        # IP addresses other than their own and receive packets with destination IP
        # addresses other than their own. If these instances will be used as an IP
        # gateway or it will be set as the next-hop in a Route resource, specify true.
        # If unsure, leave this set to false. See the Enable IP forwarding documentation
        # for more information.
        # Corresponds to the JSON property `canIpForward`
        # @return [Boolean]
        attr_accessor :can_ip_forward
        alias_method :can_ip_forward?, :can_ip_forward
      
        # An optional text description for the instances that are created from this
        # instance template.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # An array of disks that are associated with the instances that are created from
        # this template.
        # Corresponds to the JSON property `disks`
        # @return [Array<Google::Apis::ComputeBeta::AttachedDisk>]
        attr_accessor :disks
      
        # A set of Display Device options
        # Corresponds to the JSON property `displayDevice`
        # @return [Google::Apis::ComputeBeta::DisplayDevice]
        attr_accessor :display_device
      
        # A list of guest accelerator cards' type and count to use for instances created
        # from the instance template.
        # Corresponds to the JSON property `guestAccelerators`
        # @return [Array<Google::Apis::ComputeBeta::AcceleratorConfig>]
        attr_accessor :guest_accelerators
      
        # Labels to apply to instances that are created from this template.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # The machine type to use for instances that are created from this template.
        # Corresponds to the JSON property `machineType`
        # @return [String]
        attr_accessor :machine_type
      
        # A metadata key/value entry.
        # Corresponds to the JSON property `metadata`
        # @return [Google::Apis::ComputeBeta::Metadata]
        attr_accessor :metadata
      
        # Minimum cpu/platform to be used by this instance. The instance may be
        # scheduled on the specified or newer cpu/platform. Applicable values are the
        # friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or
        # minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a
        # Minimum CPU Platform.
        # Corresponds to the JSON property `minCpuPlatform`
        # @return [String]
        attr_accessor :min_cpu_platform
      
        # An array of network access configurations for this interface.
        # Corresponds to the JSON property `networkInterfaces`
        # @return [Array<Google::Apis::ComputeBeta::NetworkInterface>]
        attr_accessor :network_interfaces
      
        # Specifies the reservations that this instance can consume from.
        # Corresponds to the JSON property `reservationAffinity`
        # @return [Google::Apis::ComputeBeta::ReservationAffinity]
        attr_accessor :reservation_affinity
      
        # Sets the scheduling options for an Instance. NextID: 9
        # Corresponds to the JSON property `scheduling`
        # @return [Google::Apis::ComputeBeta::Scheduling]
        attr_accessor :scheduling
      
        # A list of service accounts with specified scopes. Access tokens for these
        # service accounts are available to the instances that are created from this
        # template. Use metadata queries to obtain the access tokens for these instances.
        # Corresponds to the JSON property `serviceAccounts`
        # @return [Array<Google::Apis::ComputeBeta::ServiceAccount>]
        attr_accessor :service_accounts
      
        # A set of Shielded Instance options.
        # Corresponds to the JSON property `shieldedInstanceConfig`
        # @return [Google::Apis::ComputeBeta::ShieldedInstanceConfig]
        attr_accessor :shielded_instance_config
      
        # A set of Shielded VM options.
        # Corresponds to the JSON property `shieldedVmConfig`
        # @return [Google::Apis::ComputeBeta::ShieldedVmConfig]
        attr_accessor :shielded_vm_config
      
        # A set of instance tags.
        # Corresponds to the JSON property `tags`
        # @return [Google::Apis::ComputeBeta::Tags]
        attr_accessor :tags
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @can_ip_forward = args[:can_ip_forward] if args.key?(:can_ip_forward)
          @description = args[:description] if args.key?(:description)
          @disks = args[:disks] if args.key?(:disks)
          @display_device = args[:display_device] if args.key?(:display_device)
          @guest_accelerators = args[:guest_accelerators] if args.key?(:guest_accelerators)
          @labels = args[:labels] if args.key?(:labels)
          @machine_type = args[:machine_type] if args.key?(:machine_type)
          @metadata = args[:metadata] if args.key?(:metadata)
          @min_cpu_platform = args[:min_cpu_platform] if args.key?(:min_cpu_platform)
          @network_interfaces = args[:network_interfaces] if args.key?(:network_interfaces)
          @reservation_affinity = args[:reservation_affinity] if args.key?(:reservation_affinity)
          @scheduling = args[:scheduling] if args.key?(:scheduling)
          @service_accounts = args[:service_accounts] if args.key?(:service_accounts)
          @shielded_instance_config = args[:shielded_instance_config] if args.key?(:shielded_instance_config)
          @shielded_vm_config = args[:shielded_vm_config] if args.key?(:shielded_vm_config)
          @tags = args[:tags] if args.key?(:tags)
        end
      end
      
      # 
      class InstanceReference
        include Google::Apis::Core::Hashable
      
        # The URL for a specific instance.
        # Corresponds to the JSON property `instance`
        # @return [String]
        attr_accessor :instance
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance = args[:instance] if args.key?(:instance)
        end
      end
      
      # Represents an Instance Template resource.
      # You can use instance templates to create VM instances and managed instance
      # groups. For more information, read Instance Templates. (== resource_for beta.
      # instanceTemplates ==) (== resource_for v1.instanceTemplates ==)
      class InstanceTemplate
        include Google::Apis::Core::Hashable
      
        # [Output Only] The creation timestamp for this instance template in RFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] A unique identifier for this instance template. The server
        # defines this identifier.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] The resource type, which is always compute#instanceTemplate for
        # instance templates.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Name of the resource; provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter,
        # and all following characters must be a dash, lowercase letter, or digit,
        # except the last character, which cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # 
        # Corresponds to the JSON property `properties`
        # @return [Google::Apis::ComputeBeta::InstanceProperties]
        attr_accessor :properties
      
        # [Output Only] The URL for this instance template. The server defines this URL.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # The source instance used to create the template. You can provide this as a
        # partial or full URL to the resource. For example, the following are valid
        # values:
        # - https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/
        # instance
        # - projects/project/zones/zone/instances/instance
        # Corresponds to the JSON property `sourceInstance`
        # @return [String]
        attr_accessor :source_instance
      
        # A specification of the parameters to use when creating the instance template
        # from a source instance.
        # Corresponds to the JSON property `sourceInstanceParams`
        # @return [Google::Apis::ComputeBeta::SourceInstanceParams]
        attr_accessor :source_instance_params
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @properties = args[:properties] if args.key?(:properties)
          @self_link = args[:self_link] if args.key?(:self_link)
          @source_instance = args[:source_instance] if args.key?(:source_instance)
          @source_instance_params = args[:source_instance_params] if args.key?(:source_instance_params)
        end
      end
      
      # A list of instance templates.
      class InstanceTemplateList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InstanceTemplate resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::InstanceTemplate>]
        attr_accessor :items
      
        # [Output Only] The resource type, which is always compute#
        # instanceTemplatesListResponse for instance template lists.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::InstanceTemplateList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::InstanceTemplateList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class InstanceWithNamedPorts
        include Google::Apis::Core::Hashable
      
        # [Output Only] The URL of the instance.
        # Corresponds to the JSON property `instance`
        # @return [String]
        attr_accessor :instance
      
        # [Output Only] The named ports that belong to this instance group.
        # Corresponds to the JSON property `namedPorts`
        # @return [Array<Google::Apis::ComputeBeta::NamedPort>]
        attr_accessor :named_ports
      
        # [Output Only] The status of the instance.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance = args[:instance] if args.key?(:instance)
          @named_ports = args[:named_ports] if args.key?(:named_ports)
          @status = args[:status] if args.key?(:status)
        end
      end
      
      # 
      class InstancesResumeRequest
        include Google::Apis::Core::Hashable
      
        # Array of disks associated with this instance that are protected with a
        # customer-supplied encryption key.
        # In order to resume the instance, the disk url and its corresponding key must
        # be provided.
        # If the disk is not protected with a customer-supplied encryption key it should
        # not be specified.
        # Corresponds to the JSON property `disks`
        # @return [Array<Google::Apis::ComputeBeta::CustomerEncryptionKeyProtectedDisk>]
        attr_accessor :disks
      
        # Represents a customer-supplied encryption key
        # Corresponds to the JSON property `instanceEncryptionKey`
        # @return [Google::Apis::ComputeBeta::CustomerEncryptionKey]
        attr_accessor :instance_encryption_key
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @disks = args[:disks] if args.key?(:disks)
          @instance_encryption_key = args[:instance_encryption_key] if args.key?(:instance_encryption_key)
        end
      end
      
      # 
      class InstancesScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] A list of instances contained in this scope.
        # Corresponds to the JSON property `instances`
        # @return [Array<Google::Apis::ComputeBeta::Instance>]
        attr_accessor :instances
      
        # [Output Only] Informational warning which replaces the list of instances when
        # the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::InstancesScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning which replaces the list of instances when
        # the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::InstancesScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class InstancesSetLabelsRequest
        include Google::Apis::Core::Hashable
      
        # Fingerprint of the previous set of labels for this resource, used to prevent
        # conflicts. Provide the latest fingerprint value when making a request to add
        # or change labels.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # 
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
        end
      end
      
      # 
      class InstancesSetMachineResourcesRequest
        include Google::Apis::Core::Hashable
      
        # A list of the type and count of accelerator cards attached to the instance.
        # Corresponds to the JSON property `guestAccelerators`
        # @return [Array<Google::Apis::ComputeBeta::AcceleratorConfig>]
        attr_accessor :guest_accelerators
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @guest_accelerators = args[:guest_accelerators] if args.key?(:guest_accelerators)
        end
      end
      
      # 
      class InstancesSetMachineTypeRequest
        include Google::Apis::Core::Hashable
      
        # Full or partial URL of the machine type resource. See Machine Types for a full
        # list of machine types. For example: zones/us-central1-f/machineTypes/n1-
        # standard-1
        # Corresponds to the JSON property `machineType`
        # @return [String]
        attr_accessor :machine_type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @machine_type = args[:machine_type] if args.key?(:machine_type)
        end
      end
      
      # 
      class InstancesSetMinCpuPlatformRequest
        include Google::Apis::Core::Hashable
      
        # Minimum cpu/platform this instance should be started at.
        # Corresponds to the JSON property `minCpuPlatform`
        # @return [String]
        attr_accessor :min_cpu_platform
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @min_cpu_platform = args[:min_cpu_platform] if args.key?(:min_cpu_platform)
        end
      end
      
      # 
      class InstancesSetServiceAccountRequest
        include Google::Apis::Core::Hashable
      
        # Email address of the service account.
        # Corresponds to the JSON property `email`
        # @return [String]
        attr_accessor :email
      
        # The list of scopes to be made available for this service account.
        # Corresponds to the JSON property `scopes`
        # @return [Array<String>]
        attr_accessor :scopes
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @email = args[:email] if args.key?(:email)
          @scopes = args[:scopes] if args.key?(:scopes)
        end
      end
      
      # 
      class InstancesStartWithEncryptionKeyRequest
        include Google::Apis::Core::Hashable
      
        # Array of disks associated with this instance that are protected with a
        # customer-supplied encryption key.
        # In order to start the instance, the disk url and its corresponding key must be
        # provided.
        # If the disk is not protected with a customer-supplied encryption key it should
        # not be specified.
        # Corresponds to the JSON property `disks`
        # @return [Array<Google::Apis::ComputeBeta::CustomerEncryptionKeyProtectedDisk>]
        attr_accessor :disks
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @disks = args[:disks] if args.key?(:disks)
        end
      end
      
      # HttpRouteRuleMatch criteria for field values that must stay within the
      # specified integer range.
      class Int64RangeMatch
        include Google::Apis::Core::Hashable
      
        # The end of the range (exclusive) in signed long integer format.
        # Corresponds to the JSON property `rangeEnd`
        # @return [Fixnum]
        attr_accessor :range_end
      
        # The start of the range (inclusive) in signed long integer format.
        # Corresponds to the JSON property `rangeStart`
        # @return [Fixnum]
        attr_accessor :range_start
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @range_end = args[:range_end] if args.key?(:range_end)
          @range_start = args[:range_start] if args.key?(:range_start)
        end
      end
      
      # Represents an Interconnect resource.
      # An Interconnect resource is a dedicated connection between the GCP network and
      # your on-premises network. For more information, read the  Dedicated
      # Interconnect Overview. (== resource_for v1.interconnects ==) (== resource_for
      # beta.interconnects ==)
      class Interconnect
        include Google::Apis::Core::Hashable
      
        # Administrative status of the interconnect. When this is set to true, the
        # Interconnect is functional and can carry traffic. When set to false, no
        # packets can be carried over the interconnect and no BGP routes are exchanged
        # over it. By default, the status is set to true.
        # Corresponds to the JSON property `adminEnabled`
        # @return [Boolean]
        attr_accessor :admin_enabled
        alias_method :admin_enabled?, :admin_enabled
      
        # [Output Only] A list of CircuitInfo objects, that describe the individual
        # circuits in this LAG.
        # Corresponds to the JSON property `circuitInfos`
        # @return [Array<Google::Apis::ComputeBeta::InterconnectCircuitInfo>]
        attr_accessor :circuit_infos
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # Customer name, to put in the Letter of Authorization as the party authorized
        # to request a crossconnect.
        # Corresponds to the JSON property `customerName`
        # @return [String]
        attr_accessor :customer_name
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] A list of outages expected for this Interconnect.
        # Corresponds to the JSON property `expectedOutages`
        # @return [Array<Google::Apis::ComputeBeta::InterconnectOutageNotification>]
        attr_accessor :expected_outages
      
        # [Output Only] IP address configured on the Google side of the Interconnect
        # link. This can be used only for ping tests.
        # Corresponds to the JSON property `googleIpAddress`
        # @return [String]
        attr_accessor :google_ip_address
      
        # [Output Only] Google reference ID to be used when raising support tickets with
        # Google or otherwise to debug backend connectivity issues.
        # Corresponds to the JSON property `googleReferenceId`
        # @return [String]
        attr_accessor :google_reference_id
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] A list of the URLs of all InterconnectAttachments configured to
        # use this Interconnect.
        # Corresponds to the JSON property `interconnectAttachments`
        # @return [Array<String>]
        attr_accessor :interconnect_attachments
      
        # Type of interconnect, which can take one of the following values:
        # - PARTNER: A partner-managed interconnection shared between customers though a
        # partner.
        # - DEDICATED: A dedicated physical interconnection with the customer. Note that
        # a value IT_PRIVATE has been deprecated in favor of DEDICATED.
        # Corresponds to the JSON property `interconnectType`
        # @return [String]
        attr_accessor :interconnect_type
      
        # [Output Only] Type of the resource. Always compute#interconnect for
        # interconnects.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # A fingerprint for the labels being applied to this Interconnect, which is
        # essentially a hash of the labels set used for optimistic locking. The
        # fingerprint is initially generated by Compute Engine and changes after every
        # request to modify or update labels. You must always provide an up-to-date
        # fingerprint hash in order to update or change labels, otherwise the request
        # will fail with error 412 conditionNotMet.
        # To see the latest fingerprint, make a get() request to retrieve an
        # Interconnect.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # Labels to apply to this Interconnect resource. These can be later modified by
        # the setLabels method. Each label key/value must comply with RFC1035. Label
        # values may be empty.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # Type of link requested, which can take one of the following values:
        # - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics
        # - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this
        # field indicates the speed of each of the links in the bundle, not the speed of
        # the entire bundle.
        # Corresponds to the JSON property `linkType`
        # @return [String]
        attr_accessor :link_type
      
        # URL of the InterconnectLocation object that represents where this connection
        # is to be provisioned.
        # Corresponds to the JSON property `location`
        # @return [String]
        attr_accessor :location
      
        # Name of the resource. Provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter,
        # and all following characters must be a dash, lowercase letter, or digit,
        # except the last character, which cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Email address to contact the customer NOC for operations and maintenance
        # notifications regarding this Interconnect. If specified, this will be used for
        # notifications in addition to all other forms described, such as Stackdriver
        # logs alerting and Cloud Notifications.
        # Corresponds to the JSON property `nocContactEmail`
        # @return [String]
        attr_accessor :noc_contact_email
      
        # [Output Only] The current status of this Interconnect's functionality, which
        # can take one of the following values:
        # - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use.
        # Attachments may be provisioned on this Interconnect.
        # - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No
        # attachments may be provisioned on this Interconnect.
        # - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal
        # maintenance. No attachments may be provisioned or updated on this Interconnect.
        # Corresponds to the JSON property `operationalStatus`
        # @return [String]
        attr_accessor :operational_status
      
        # [Output Only] IP address configured on the customer side of the Interconnect
        # link. The customer should configure this IP address during turnup when
        # prompted by Google NOC. This can be used only for ping tests.
        # Corresponds to the JSON property `peerIpAddress`
        # @return [String]
        attr_accessor :peer_ip_address
      
        # [Output Only] Number of links actually provisioned in this interconnect.
        # Corresponds to the JSON property `provisionedLinkCount`
        # @return [Fixnum]
        attr_accessor :provisioned_link_count
      
        # Target number of physical links in the link bundle, as requested by the
        # customer.
        # Corresponds to the JSON property `requestedLinkCount`
        # @return [Fixnum]
        attr_accessor :requested_link_count
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] The current state of Interconnect functionality, which can take
        # one of the following values:
        # - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments
        # may be provisioned on this Interconnect.
        # - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may
        # be provisioned on this Interconnect.
        # - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No
        # attachments may be provisioned or updated on this Interconnect.
        # Corresponds to the JSON property `state`
        # @return [String]
        attr_accessor :state
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @admin_enabled = args[:admin_enabled] if args.key?(:admin_enabled)
          @circuit_infos = args[:circuit_infos] if args.key?(:circuit_infos)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @customer_name = args[:customer_name] if args.key?(:customer_name)
          @description = args[:description] if args.key?(:description)
          @expected_outages = args[:expected_outages] if args.key?(:expected_outages)
          @google_ip_address = args[:google_ip_address] if args.key?(:google_ip_address)
          @google_reference_id = args[:google_reference_id] if args.key?(:google_reference_id)
          @id = args[:id] if args.key?(:id)
          @interconnect_attachments = args[:interconnect_attachments] if args.key?(:interconnect_attachments)
          @interconnect_type = args[:interconnect_type] if args.key?(:interconnect_type)
          @kind = args[:kind] if args.key?(:kind)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
          @link_type = args[:link_type] if args.key?(:link_type)
          @location = args[:location] if args.key?(:location)
          @name = args[:name] if args.key?(:name)
          @noc_contact_email = args[:noc_contact_email] if args.key?(:noc_contact_email)
          @operational_status = args[:operational_status] if args.key?(:operational_status)
          @peer_ip_address = args[:peer_ip_address] if args.key?(:peer_ip_address)
          @provisioned_link_count = args[:provisioned_link_count] if args.key?(:provisioned_link_count)
          @requested_link_count = args[:requested_link_count] if args.key?(:requested_link_count)
          @self_link = args[:self_link] if args.key?(:self_link)
          @state = args[:state] if args.key?(:state)
        end
      end
      
      # Represents an Interconnect Attachment (VLAN) resource.
      # You can use Interconnect attachments (VLANS) to connect your Virtual Private
      # Cloud networks to your on-premises networks through an Interconnect. For more
      # information, read  Creating VLAN Attachments. (== resource_for beta.
      # interconnectAttachments ==) (== resource_for v1.interconnectAttachments ==)
      class InterconnectAttachment
        include Google::Apis::Core::Hashable
      
        # Determines whether this Attachment will carry packets. Not present for
        # PARTNER_PROVIDER.
        # Corresponds to the JSON property `adminEnabled`
        # @return [Boolean]
        attr_accessor :admin_enabled
        alias_method :admin_enabled?, :admin_enabled
      
        # Provisioned bandwidth capacity for the interconnect attachment. For
        # attachments of type DEDICATED, the user can set the bandwidth. For attachments
        # of type PARTNER, the Google Partner that is operating the interconnect must
        # set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER
        # and DEDICATED, and can take one of the following values:
        # - BPS_50M: 50 Mbit/s
        # - BPS_100M: 100 Mbit/s
        # - BPS_200M: 200 Mbit/s
        # - BPS_300M: 300 Mbit/s
        # - BPS_400M: 400 Mbit/s
        # - BPS_500M: 500 Mbit/s
        # - BPS_1G: 1 Gbit/s
        # - BPS_2G: 2 Gbit/s
        # - BPS_5G: 5 Gbit/s
        # - BPS_10G: 10 Gbit/s
        # - BPS_20G: 20 Gbit/s
        # - BPS_50G: 50 Gbit/s
        # Corresponds to the JSON property `bandwidth`
        # @return [String]
        attr_accessor :bandwidth
      
        # Up to 16 candidate prefixes that can be used to restrict the allocation of
        # cloudRouterIpAddress and customerRouterIpAddress for this attachment. All
        # prefixes must be within link-local address space (169.254.0.0/16) and must be /
        # 29 or shorter (/28, /27, etc). Google will attempt to select an unused /29
        # from the supplied candidate prefix(es). The request will fail if all possible /
        # 29s are in use on Google?s edge. If not supplied, Google will randomly select
        # an unused /29 from all of link-local space.
        # Corresponds to the JSON property `candidateSubnets`
        # @return [Array<String>]
        attr_accessor :candidate_subnets
      
        # [Output Only] IPv4 address + prefix length to be configured on Cloud Router
        # Interface for this interconnect attachment.
        # Corresponds to the JSON property `cloudRouterIpAddress`
        # @return [String]
        attr_accessor :cloud_router_ip_address
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # [Output Only] IPv4 address + prefix length to be configured on the customer
        # router subinterface for this interconnect attachment.
        # Corresponds to the JSON property `customerRouterIpAddress`
        # @return [String]
        attr_accessor :customer_router_ip_address
      
        # An optional description of this resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Desired availability domain for the attachment. Only available for type
        # PARTNER, at creation time, and can take one of the following values:
        # - AVAILABILITY_DOMAIN_ANY
        # - AVAILABILITY_DOMAIN_1
        # - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a
        # pair of attachments, one per availability domain. The selected availability
        # domain will be provided to the Partner via the pairing key, so that the
        # provisioned circuit will lie in the specified domain. If not specified, the
        # value will default to AVAILABILITY_DOMAIN_ANY.
        # Corresponds to the JSON property `edgeAvailabilityDomain`
        # @return [String]
        attr_accessor :edge_availability_domain
      
        # [Output Only] Google reference ID, to be used when raising support tickets
        # with Google or otherwise to debug backend connectivity issues. [Deprecated]
        # This field is not used.
        # Corresponds to the JSON property `googleReferenceId`
        # @return [String]
        attr_accessor :google_reference_id
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # URL of the underlying Interconnect object that this attachment's traffic will
        # traverse through.
        # Corresponds to the JSON property `interconnect`
        # @return [String]
        attr_accessor :interconnect
      
        # [Output Only] Type of the resource. Always compute#interconnectAttachment for
        # interconnect attachments.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # A fingerprint for the labels being applied to this InterconnectAttachment,
        # which is essentially a hash of the labels set used for optimistic locking. The
        # fingerprint is initially generated by Compute Engine and changes after every
        # request to modify or update labels. You must always provide an up-to-date
        # fingerprint hash in order to update or change labels, otherwise the request
        # will fail with error 412 conditionNotMet.
        # To see the latest fingerprint, make a get() request to retrieve an
        # InterconnectAttachment.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # Labels to apply to this InterconnectAttachment resource. These can be later
        # modified by the setLabels method. Each label key/value must comply with
        # RFC1035. Label values may be empty.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # Name of the resource. Provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter,
        # and all following characters must be a dash, lowercase letter, or digit,
        # except the last character, which cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # [Output Only] The current status of whether or not this interconnect
        # attachment is functional, which can take one of the following values:
        # - OS_ACTIVE: The attachment has been turned up and is ready to use.
        # - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is
        # not complete.
        # Corresponds to the JSON property `operationalStatus`
        # @return [String]
        attr_accessor :operational_status
      
        # [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present
        # for DEDICATED]. The opaque identifier of an PARTNER attachment used to
        # initiate provisioning with a selected partner. Of the form "XXXXX/region/
        # domain"
        # Corresponds to the JSON property `pairingKey`
        # @return [String]
        attr_accessor :pairing_key
      
        # Optional BGP ASN for the router supplied by a Layer 3 Partner if they
        # configured BGP on behalf of the customer. Output only for PARTNER type, input
        # only for PARTNER_PROVIDER, not available for DEDICATED.
        # Corresponds to the JSON property `partnerAsn`
        # @return [Fixnum]
        attr_accessor :partner_asn
      
        # Informational metadata about Partner attachments from Partners to display to
        # customers. These fields are propagated from PARTNER_PROVIDER attachments to
        # their corresponding PARTNER attachments.
        # Corresponds to the JSON property `partnerMetadata`
        # @return [Google::Apis::ComputeBeta::InterconnectAttachmentPartnerMetadata]
        attr_accessor :partner_metadata
      
        # Information for an interconnect attachment when this belongs to an
        # interconnect of type DEDICATED.
        # Corresponds to the JSON property `privateInterconnectInfo`
        # @return [Google::Apis::ComputeBeta::InterconnectAttachmentPrivateInfo]
        attr_accessor :private_interconnect_info
      
        # [Output Only] URL of the region where the regional interconnect attachment
        # resides. You must specify this field as part of the HTTP request URL. It is
        # not settable as a field in the request body.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # URL of the Cloud Router to be used for dynamic routing. This router must be in
        # the same region as this InterconnectAttachment. The InterconnectAttachment
        # will automatically connect the Interconnect to the network & region within
        # which the Cloud Router is configured.
        # Corresponds to the JSON property `router`
        # @return [String]
        attr_accessor :router
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] The current state of this attachment's functionality. Enum
        # values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and
        # PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER,
        # PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and
        # PARTNER_PROVIDER interconnect attachments. This state can take one of the
        # following values:
        # - ACTIVE: The attachment has been turned up and is ready to use.
        # - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not
        # complete.
        # - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been
        # configured on the Partner side.
        # - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of
        # provisioning after a PARTNER_PROVIDER attachment was created that references
        # it.
        # - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting
        # for a customer to activate it.
        # - DEFUNCT: The attachment was deleted externally and is no longer functional.
        # This could be because the associated Interconnect was removed, or because the
        # other side of a Partner attachment was deleted.
        # Corresponds to the JSON property `state`
        # @return [String]
        attr_accessor :state
      
        # The type of interconnect attachment this is, which can take one of the
        # following values:
        # - DEDICATED: an attachment to a Dedicated Interconnect.
        # - PARTNER: an attachment to a Partner Interconnect, created by the customer.
        # - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the
        # partner.
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        # The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. Only
        # specified at creation time.
        # Corresponds to the JSON property `vlanTag8021q`
        # @return [Fixnum]
        attr_accessor :vlan_tag8021q
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @admin_enabled = args[:admin_enabled] if args.key?(:admin_enabled)
          @bandwidth = args[:bandwidth] if args.key?(:bandwidth)
          @candidate_subnets = args[:candidate_subnets] if args.key?(:candidate_subnets)
          @cloud_router_ip_address = args[:cloud_router_ip_address] if args.key?(:cloud_router_ip_address)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @customer_router_ip_address = args[:customer_router_ip_address] if args.key?(:customer_router_ip_address)
          @description = args[:description] if args.key?(:description)
          @edge_availability_domain = args[:edge_availability_domain] if args.key?(:edge_availability_domain)
          @google_reference_id = args[:google_reference_id] if args.key?(:google_reference_id)
          @id = args[:id] if args.key?(:id)
          @interconnect = args[:interconnect] if args.key?(:interconnect)
          @kind = args[:kind] if args.key?(:kind)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
          @name = args[:name] if args.key?(:name)
          @operational_status = args[:operational_status] if args.key?(:operational_status)
          @pairing_key = args[:pairing_key] if args.key?(:pairing_key)
          @partner_asn = args[:partner_asn] if args.key?(:partner_asn)
          @partner_metadata = args[:partner_metadata] if args.key?(:partner_metadata)
          @private_interconnect_info = args[:private_interconnect_info] if args.key?(:private_interconnect_info)
          @region = args[:region] if args.key?(:region)
          @router = args[:router] if args.key?(:router)
          @self_link = args[:self_link] if args.key?(:self_link)
          @state = args[:state] if args.key?(:state)
          @type = args[:type] if args.key?(:type)
          @vlan_tag8021q = args[:vlan_tag8021q] if args.key?(:vlan_tag8021q)
        end
      end
      
      # 
      class InterconnectAttachmentAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InterconnectAttachmentsScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::InterconnectAttachmentsScopedList>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#
        # interconnectAttachmentAggregatedList for aggregated lists of interconnect
        # attachments.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::InterconnectAttachmentAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::InterconnectAttachmentAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Response to the list request, and contains a list of interconnect attachments.
      class InterconnectAttachmentList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InterconnectAttachment resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::InterconnectAttachment>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#interconnectAttachmentList for
        # lists of interconnect attachments.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::InterconnectAttachmentList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::InterconnectAttachmentList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Informational metadata about Partner attachments from Partners to display to
      # customers. These fields are propagated from PARTNER_PROVIDER attachments to
      # their corresponding PARTNER attachments.
      class InterconnectAttachmentPartnerMetadata
        include Google::Apis::Core::Hashable
      
        # Plain text name of the Interconnect this attachment is connected to, as
        # displayed in the Partner?s portal. For instance "Chicago 1". This value may be
        # validated to match approved Partner values.
        # Corresponds to the JSON property `interconnectName`
        # @return [String]
        attr_accessor :interconnect_name
      
        # Plain text name of the Partner providing this attachment. This value may be
        # validated to match approved Partner values.
        # Corresponds to the JSON property `partnerName`
        # @return [String]
        attr_accessor :partner_name
      
        # URL of the Partner?s portal for this Attachment. Partners may customise this
        # to be a deep link to the specific resource on the Partner portal. This value
        # may be validated to match approved Partner values.
        # Corresponds to the JSON property `portalUrl`
        # @return [String]
        attr_accessor :portal_url
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @interconnect_name = args[:interconnect_name] if args.key?(:interconnect_name)
          @partner_name = args[:partner_name] if args.key?(:partner_name)
          @portal_url = args[:portal_url] if args.key?(:portal_url)
        end
      end
      
      # Information for an interconnect attachment when this belongs to an
      # interconnect of type DEDICATED.
      class InterconnectAttachmentPrivateInfo
        include Google::Apis::Core::Hashable
      
        # [Output Only] 802.1q encapsulation tag to be used for traffic between Google
        # and the customer, going to and from this network and region.
        # Corresponds to the JSON property `tag8021q`
        # @return [Fixnum]
        attr_accessor :tag8021q
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @tag8021q = args[:tag8021q] if args.key?(:tag8021q)
        end
      end
      
      # 
      class InterconnectAttachmentsScopedList
        include Google::Apis::Core::Hashable
      
        # A list of interconnect attachments contained in this scope.
        # Corresponds to the JSON property `interconnectAttachments`
        # @return [Array<Google::Apis::ComputeBeta::InterconnectAttachment>]
        attr_accessor :interconnect_attachments
      
        # Informational warning which replaces the list of addresses when the list is
        # empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::InterconnectAttachmentsScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @interconnect_attachments = args[:interconnect_attachments] if args.key?(:interconnect_attachments)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Informational warning which replaces the list of addresses when the list is
        # empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::InterconnectAttachmentsScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Describes a single physical circuit between the Customer and Google.
      # CircuitInfo objects are created by Google, so all fields are output only. Next
      # id: 4
      class InterconnectCircuitInfo
        include Google::Apis::Core::Hashable
      
        # Customer-side demarc ID for this circuit.
        # Corresponds to the JSON property `customerDemarcId`
        # @return [String]
        attr_accessor :customer_demarc_id
      
        # Google-assigned unique ID for this circuit. Assigned at circuit turn-up.
        # Corresponds to the JSON property `googleCircuitId`
        # @return [String]
        attr_accessor :google_circuit_id
      
        # Google-side demarc ID for this circuit. Assigned at circuit turn-up and
        # provided by Google to the customer in the LOA.
        # Corresponds to the JSON property `googleDemarcId`
        # @return [String]
        attr_accessor :google_demarc_id
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @customer_demarc_id = args[:customer_demarc_id] if args.key?(:customer_demarc_id)
          @google_circuit_id = args[:google_circuit_id] if args.key?(:google_circuit_id)
          @google_demarc_id = args[:google_demarc_id] if args.key?(:google_demarc_id)
        end
      end
      
      # Diagnostics information about interconnect, contains detailed and current
      # technical information about Google?s side of the connection.
      class InterconnectDiagnostics
        include Google::Apis::Core::Hashable
      
        # A list of InterconnectDiagnostics.ARPEntry objects, describing individual
        # neighbors currently seen by the Google router in the ARP cache for the
        # Interconnect. This will be empty when the Interconnect is not bundled.
        # Corresponds to the JSON property `arpCaches`
        # @return [Array<Google::Apis::ComputeBeta::InterconnectDiagnosticsArpEntry>]
        attr_accessor :arp_caches
      
        # A list of InterconnectDiagnostics.LinkStatus objects, describing the status
        # for each link on the Interconnect.
        # Corresponds to the JSON property `links`
        # @return [Array<Google::Apis::ComputeBeta::InterconnectDiagnosticsLinkStatus>]
        attr_accessor :links
      
        # The MAC address of the Interconnect's bundle interface.
        # Corresponds to the JSON property `macAddress`
        # @return [String]
        attr_accessor :mac_address
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @arp_caches = args[:arp_caches] if args.key?(:arp_caches)
          @links = args[:links] if args.key?(:links)
          @mac_address = args[:mac_address] if args.key?(:mac_address)
        end
      end
      
      # Describing the ARP neighbor entries seen on this link
      class InterconnectDiagnosticsArpEntry
        include Google::Apis::Core::Hashable
      
        # The IP address of this ARP neighbor.
        # Corresponds to the JSON property `ipAddress`
        # @return [String]
        attr_accessor :ip_address
      
        # The MAC address of this ARP neighbor.
        # Corresponds to the JSON property `macAddress`
        # @return [String]
        attr_accessor :mac_address
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @ip_address = args[:ip_address] if args.key?(:ip_address)
          @mac_address = args[:mac_address] if args.key?(:mac_address)
        end
      end
      
      # 
      class InterconnectDiagnosticsLinkLacpStatus
        include Google::Apis::Core::Hashable
      
        # System ID of the port on Google?s side of the LACP exchange.
        # Corresponds to the JSON property `googleSystemId`
        # @return [String]
        attr_accessor :google_system_id
      
        # System ID of the port on the neighbor?s side of the LACP exchange.
        # Corresponds to the JSON property `neighborSystemId`
        # @return [String]
        attr_accessor :neighbor_system_id
      
        # The state of a LACP link, which can take one of the following values:
        # - ACTIVE: The link is configured and active within the bundle.
        # - DETACHED: The link is not configured within the bundle. This means that the
        # rest of the object should be empty.
        # Corresponds to the JSON property `state`
        # @return [String]
        attr_accessor :state
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @google_system_id = args[:google_system_id] if args.key?(:google_system_id)
          @neighbor_system_id = args[:neighbor_system_id] if args.key?(:neighbor_system_id)
          @state = args[:state] if args.key?(:state)
        end
      end
      
      # 
      class InterconnectDiagnosticsLinkOpticalPower
        include Google::Apis::Core::Hashable
      
        # The status of the current value when compared to the warning and alarm levels
        # for the receiving or transmitting transceiver. Possible states include:
        # - OK: The value has not crossed a warning threshold.
        # - LOW_WARNING: The value has crossed below the low warning threshold.
        # - HIGH_WARNING: The value has crossed above the high warning threshold.
        # - LOW_ALARM: The value has crossed below the low alarm threshold.
        # - HIGH_ALARM: The value has crossed above the high alarm threshold.
        # Corresponds to the JSON property `state`
        # @return [String]
        attr_accessor :state
      
        # Value of the current receiving or transmitting optical power, read in dBm.
        # Take a known good optical value, give it a 10% margin and trigger warnings
        # relative to that value. In general, a -7dBm warning and a -11dBm alarm are
        # good optical value estimates for most links.
        # Corresponds to the JSON property `value`
        # @return [Float]
        attr_accessor :value
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @state = args[:state] if args.key?(:state)
          @value = args[:value] if args.key?(:value)
        end
      end
      
      # 
      class InterconnectDiagnosticsLinkStatus
        include Google::Apis::Core::Hashable
      
        # A list of InterconnectDiagnostics.ARPEntry objects, describing the ARP
        # neighbor entries seen on this link. This will be empty if the link is bundled
        # Corresponds to the JSON property `arpCaches`
        # @return [Array<Google::Apis::ComputeBeta::InterconnectDiagnosticsArpEntry>]
        attr_accessor :arp_caches
      
        # The unique ID for this link assigned during turn up by Google.
        # Corresponds to the JSON property `circuitId`
        # @return [String]
        attr_accessor :circuit_id
      
        # The Demarc address assigned by Google and provided in the LoA.
        # Corresponds to the JSON property `googleDemarc`
        # @return [String]
        attr_accessor :google_demarc
      
        # 
        # Corresponds to the JSON property `lacpStatus`
        # @return [Google::Apis::ComputeBeta::InterconnectDiagnosticsLinkLacpStatus]
        attr_accessor :lacp_status
      
        # An InterconnectDiagnostics.LinkOpticalPower object, describing the current
        # value and status of the received light level.
        # Corresponds to the JSON property `receivingOpticalPower`
        # @return [Google::Apis::ComputeBeta::InterconnectDiagnosticsLinkOpticalPower]
        attr_accessor :receiving_optical_power
      
        # An InterconnectDiagnostics.LinkOpticalPower object, describing the current
        # value and status of the transmitted light level.
        # Corresponds to the JSON property `transmittingOpticalPower`
        # @return [Google::Apis::ComputeBeta::InterconnectDiagnosticsLinkOpticalPower]
        attr_accessor :transmitting_optical_power
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @arp_caches = args[:arp_caches] if args.key?(:arp_caches)
          @circuit_id = args[:circuit_id] if args.key?(:circuit_id)
          @google_demarc = args[:google_demarc] if args.key?(:google_demarc)
          @lacp_status = args[:lacp_status] if args.key?(:lacp_status)
          @receiving_optical_power = args[:receiving_optical_power] if args.key?(:receiving_optical_power)
          @transmitting_optical_power = args[:transmitting_optical_power] if args.key?(:transmitting_optical_power)
        end
      end
      
      # Response to the list request, and contains a list of interconnects.
      class InterconnectList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Interconnect resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::Interconnect>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#interconnectList for lists of
        # interconnects.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::InterconnectList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::InterconnectList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Represents an Interconnect Attachment (VLAN) Location resource.
      # You can use this resource to find location details about an Interconnect
      # attachment (VLAN). For more information about interconnect attachments, read
      # Creating VLAN Attachments.
      class InterconnectLocation
        include Google::Apis::Core::Hashable
      
        # [Output Only] The postal address of the Point of Presence, each line in the
        # address is separated by a newline character.
        # Corresponds to the JSON property `address`
        # @return [String]
        attr_accessor :address
      
        # [Output Only] Availability zone for this InterconnectLocation. Within a
        # metropolitan area (metro), maintenance will not be simultaneously scheduled in
        # more than one availability zone. Example: "zone1" or "zone2".
        # Corresponds to the JSON property `availabilityZone`
        # @return [String]
        attr_accessor :availability_zone
      
        # [Output Only] Metropolitan area designator that indicates which city an
        # interconnect is located. For example: "Chicago, IL", "Amsterdam, Netherlands".
        # Corresponds to the JSON property `city`
        # @return [String]
        attr_accessor :city
      
        # [Output Only] Continent for this location, which can take one of the following
        # values:
        # - AFRICA
        # - ASIA_PAC
        # - EUROPE
        # - NORTH_AMERICA
        # - SOUTH_AMERICA
        # Corresponds to the JSON property `continent`
        # @return [String]
        attr_accessor :continent
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # [Output Only] An optional description of the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The name of the provider for this facility (e.g., EQUINIX).
        # Corresponds to the JSON property `facilityProvider`
        # @return [String]
        attr_accessor :facility_provider
      
        # [Output Only] A provider-assigned Identifier for this facility (e.g., Ashburn-
        # DC1).
        # Corresponds to the JSON property `facilityProviderFacilityId`
        # @return [String]
        attr_accessor :facility_provider_facility_id
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Type of the resource. Always compute#interconnectLocation for
        # interconnect locations.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] Name of the resource.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # [Output Only] The peeringdb identifier for this facility (corresponding with a
        # netfac type in peeringdb).
        # Corresponds to the JSON property `peeringdbFacilityId`
        # @return [String]
        attr_accessor :peeringdb_facility_id
      
        # [Output Only] A list of InterconnectLocation.RegionInfo objects, that describe
        # parameters pertaining to the relation between this InterconnectLocation and
        # various Google Cloud regions.
        # Corresponds to the JSON property `regionInfos`
        # @return [Array<Google::Apis::ComputeBeta::InterconnectLocationRegionInfo>]
        attr_accessor :region_infos
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] The status of this InterconnectLocation, which can take one of
        # the following values:
        # - CLOSED: The InterconnectLocation is closed and is unavailable for
        # provisioning new Interconnects.
        # - AVAILABLE: The InterconnectLocation is available for provisioning new
        # Interconnects.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @address = args[:address] if args.key?(:address)
          @availability_zone = args[:availability_zone] if args.key?(:availability_zone)
          @city = args[:city] if args.key?(:city)
          @continent = args[:continent] if args.key?(:continent)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @facility_provider = args[:facility_provider] if args.key?(:facility_provider)
          @facility_provider_facility_id = args[:facility_provider_facility_id] if args.key?(:facility_provider_facility_id)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @peeringdb_facility_id = args[:peeringdb_facility_id] if args.key?(:peeringdb_facility_id)
          @region_infos = args[:region_infos] if args.key?(:region_infos)
          @self_link = args[:self_link] if args.key?(:self_link)
          @status = args[:status] if args.key?(:status)
        end
      end
      
      # Response to the list request, and contains a list of interconnect locations.
      class InterconnectLocationList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InterconnectLocation resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::InterconnectLocation>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#interconnectLocationList for
        # lists of interconnect locations.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::InterconnectLocationList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::InterconnectLocationList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Information about any potential InterconnectAttachments between an
      # Interconnect at a specific InterconnectLocation, and a specific Cloud Region.
      class InterconnectLocationRegionInfo
        include Google::Apis::Core::Hashable
      
        # Expected round-trip time in milliseconds, from this InterconnectLocation to a
        # VM in this region.
        # Corresponds to the JSON property `expectedRttMs`
        # @return [Fixnum]
        attr_accessor :expected_rtt_ms
      
        # Identifies the network presence of this location.
        # Corresponds to the JSON property `locationPresence`
        # @return [String]
        attr_accessor :location_presence
      
        # URL for the region of this location.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @expected_rtt_ms = args[:expected_rtt_ms] if args.key?(:expected_rtt_ms)
          @location_presence = args[:location_presence] if args.key?(:location_presence)
          @region = args[:region] if args.key?(:region)
        end
      end
      
      # Description of a planned outage on this Interconnect. Next id: 9
      class InterconnectOutageNotification
        include Google::Apis::Core::Hashable
      
        # If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that
        # will be affected.
        # Corresponds to the JSON property `affectedCircuits`
        # @return [Array<String>]
        attr_accessor :affected_circuits
      
        # A description about the purpose of the outage.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Scheduled end time for the outage (milliseconds since Unix epoch).
        # Corresponds to the JSON property `endTime`
        # @return [Fixnum]
        attr_accessor :end_time
      
        # Form this outage is expected to take, which can take one of the following
        # values:
        # - OUTAGE: The Interconnect may be completely out of service for some or all of
        # the specified window.
        # - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should
        # remain up, but with reduced bandwidth. Note that the versions of this enum
        # prefixed with "IT_" have been deprecated in favor of the unprefixed values.
        # Corresponds to the JSON property `issueType`
        # @return [String]
        attr_accessor :issue_type
      
        # Unique identifier for this outage notification.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The party that generated this notification, which can take the following value:
        # 
        # - GOOGLE: this notification as generated by Google. Note that the value of
        # NSRC_GOOGLE has been deprecated in favor of GOOGLE.
        # Corresponds to the JSON property `source`
        # @return [String]
        attr_accessor :source
      
        # Scheduled start time for the outage (milliseconds since Unix epoch).
        # Corresponds to the JSON property `startTime`
        # @return [Fixnum]
        attr_accessor :start_time
      
        # State of this notification, which can take one of the following values:
        # - ACTIVE: This outage notification is active. The event could be in the past,
        # present, or future. See start_time and end_time for scheduling.
        # - CANCELLED: The outage associated with this notification was cancelled before
        # the outage was due to start. Note that the versions of this enum prefixed with
        # "NS_" have been deprecated in favor of the unprefixed values.
        # Corresponds to the JSON property `state`
        # @return [String]
        attr_accessor :state
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @affected_circuits = args[:affected_circuits] if args.key?(:affected_circuits)
          @description = args[:description] if args.key?(:description)
          @end_time = args[:end_time] if args.key?(:end_time)
          @issue_type = args[:issue_type] if args.key?(:issue_type)
          @name = args[:name] if args.key?(:name)
          @source = args[:source] if args.key?(:source)
          @start_time = args[:start_time] if args.key?(:start_time)
          @state = args[:state] if args.key?(:state)
        end
      end
      
      # Response for the InterconnectsGetDiagnosticsRequest.
      class InterconnectsGetDiagnosticsResponse
        include Google::Apis::Core::Hashable
      
        # Diagnostics information about interconnect, contains detailed and current
        # technical information about Google?s side of the connection.
        # Corresponds to the JSON property `result`
        # @return [Google::Apis::ComputeBeta::InterconnectDiagnostics]
        attr_accessor :result
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @result = args[:result] if args.key?(:result)
        end
      end
      
      # A license resource.
      class License
        include Google::Apis::Core::Hashable
      
        # [Output Only] Deprecated. This field no longer reflects whether a license
        # charges a usage fee.
        # Corresponds to the JSON property `chargesUseFee`
        # @return [Boolean]
        attr_accessor :charges_use_fee
        alias_method :charges_use_fee?, :charges_use_fee
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional textual description of the resource; provided by the client when
        # the resource is created.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Type of resource. Always compute#license for licenses.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] The unique code used to attach this license to images, snapshots,
        # and disks.
        # Corresponds to the JSON property `licenseCode`
        # @return [Fixnum]
        attr_accessor :license_code
      
        # Name of the resource. The name must be 1-63 characters long and comply with
        # RFC1035.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # 
        # Corresponds to the JSON property `resourceRequirements`
        # @return [Google::Apis::ComputeBeta::LicenseResourceRequirements]
        attr_accessor :resource_requirements
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # If false, licenses will not be copied from the source resource when creating
        # an image from a disk, disk from snapshot, or snapshot from disk.
        # Corresponds to the JSON property `transferable`
        # @return [Boolean]
        attr_accessor :transferable
        alias_method :transferable?, :transferable
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @charges_use_fee = args[:charges_use_fee] if args.key?(:charges_use_fee)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @license_code = args[:license_code] if args.key?(:license_code)
          @name = args[:name] if args.key?(:name)
          @resource_requirements = args[:resource_requirements] if args.key?(:resource_requirements)
          @self_link = args[:self_link] if args.key?(:self_link)
          @transferable = args[:transferable] if args.key?(:transferable)
        end
      end
      
      # 
      class LicenseCode
        include Google::Apis::Core::Hashable
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # [Output Only] Description of this License Code.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Type of resource. Always compute#licenseCode for licenses.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] URL and description aliases of Licenses with the same License
        # Code.
        # Corresponds to the JSON property `licenseAlias`
        # @return [Array<Google::Apis::ComputeBeta::LicenseCodeLicenseAlias>]
        attr_accessor :license_alias
      
        # [Output Only] Name of the resource. The name is 1-20 characters long and must
        # be a valid 64 bit integer.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Current state of this License Code.
        # Corresponds to the JSON property `state`
        # @return [String]
        attr_accessor :state
      
        # [Output Only] If true, the license will remain attached when creating images
        # or snapshots from disks. Otherwise, the license is not transferred.
        # Corresponds to the JSON property `transferable`
        # @return [Boolean]
        attr_accessor :transferable
        alias_method :transferable?, :transferable
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @license_alias = args[:license_alias] if args.key?(:license_alias)
          @name = args[:name] if args.key?(:name)
          @self_link = args[:self_link] if args.key?(:self_link)
          @state = args[:state] if args.key?(:state)
          @transferable = args[:transferable] if args.key?(:transferable)
        end
      end
      
      # 
      class LicenseCodeLicenseAlias
        include Google::Apis::Core::Hashable
      
        # [Output Only] Description of this License Code.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] URL of license corresponding to this License Code.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @description = args[:description] if args.key?(:description)
          @self_link = args[:self_link] if args.key?(:self_link)
        end
      end
      
      # 
      class LicenseResourceRequirements
        include Google::Apis::Core::Hashable
      
        # Minimum number of guest cpus required to use the Instance. Enforced at
        # Instance creation and Instance start.
        # Corresponds to the JSON property `minGuestCpuCount`
        # @return [Fixnum]
        attr_accessor :min_guest_cpu_count
      
        # Minimum memory required to use the Instance. Enforced at Instance creation and
        # Instance start.
        # Corresponds to the JSON property `minMemoryMb`
        # @return [Fixnum]
        attr_accessor :min_memory_mb
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @min_guest_cpu_count = args[:min_guest_cpu_count] if args.key?(:min_guest_cpu_count)
          @min_memory_mb = args[:min_memory_mb] if args.key?(:min_memory_mb)
        end
      end
      
      # 
      class LicensesListResponse
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of License resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::License>]
        attr_accessor :items
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::LicensesListResponse::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::LicensesListResponse::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Specifies what kind of log the caller must write
      class LogConfig
        include Google::Apis::Core::Hashable
      
        # Write a Cloud Audit log
        # Corresponds to the JSON property `cloudAudit`
        # @return [Google::Apis::ComputeBeta::LogConfigCloudAuditOptions]
        attr_accessor :cloud_audit
      
        # Increment a streamz counter with the specified metric and field names.
        # Metric names should start with a '/', generally be lowercase-only, and end in "
        # _count". Field names should not contain an initial slash. The actual exported
        # metric names will have "/iam/policy" prepended.
        # Field names correspond to IAM request parameters and field values are their
        # respective values.
        # Supported field names: - "authority", which is "[token]" if IAMContext.token
        # is present, otherwise the value of IAMContext.authority_selector if present,
        # and otherwise a representation of IAMContext.principal; or - "iam_principal",
        # a representation of IAMContext.principal even if a token or authority selector
        # is present; or - "" (empty string), resulting in a counter with no fields.
        # Examples: counter ` metric: "/debug_access_count" field: "iam_principal" ` ==>
        # increment counter /iam/policy/backend_debug_access_count `iam_principal=[value
        # of IAMContext.principal]`
        # At this time we do not support multiple field names (though this may be
        # supported in the future).
        # Corresponds to the JSON property `counter`
        # @return [Google::Apis::ComputeBeta::LogConfigCounterOptions]
        attr_accessor :counter
      
        # Write a Data Access (Gin) log
        # Corresponds to the JSON property `dataAccess`
        # @return [Google::Apis::ComputeBeta::LogConfigDataAccessOptions]
        attr_accessor :data_access
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @cloud_audit = args[:cloud_audit] if args.key?(:cloud_audit)
          @counter = args[:counter] if args.key?(:counter)
          @data_access = args[:data_access] if args.key?(:data_access)
        end
      end
      
      # Write a Cloud Audit log
      class LogConfigCloudAuditOptions
        include Google::Apis::Core::Hashable
      
        # Authorization-related information used by Cloud Audit Logging.
        # Corresponds to the JSON property `authorizationLoggingOptions`
        # @return [Google::Apis::ComputeBeta::AuthorizationLoggingOptions]
        attr_accessor :authorization_logging_options
      
        # The log_name to populate in the Cloud Audit Record.
        # Corresponds to the JSON property `logName`
        # @return [String]
        attr_accessor :log_name
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @authorization_logging_options = args[:authorization_logging_options] if args.key?(:authorization_logging_options)
          @log_name = args[:log_name] if args.key?(:log_name)
        end
      end
      
      # Increment a streamz counter with the specified metric and field names.
      # Metric names should start with a '/', generally be lowercase-only, and end in "
      # _count". Field names should not contain an initial slash. The actual exported
      # metric names will have "/iam/policy" prepended.
      # Field names correspond to IAM request parameters and field values are their
      # respective values.
      # Supported field names: - "authority", which is "[token]" if IAMContext.token
      # is present, otherwise the value of IAMContext.authority_selector if present,
      # and otherwise a representation of IAMContext.principal; or - "iam_principal",
      # a representation of IAMContext.principal even if a token or authority selector
      # is present; or - "" (empty string), resulting in a counter with no fields.
      # Examples: counter ` metric: "/debug_access_count" field: "iam_principal" ` ==>
      # increment counter /iam/policy/backend_debug_access_count `iam_principal=[value
      # of IAMContext.principal]`
      # At this time we do not support multiple field names (though this may be
      # supported in the future).
      class LogConfigCounterOptions
        include Google::Apis::Core::Hashable
      
        # The field value to attribute.
        # Corresponds to the JSON property `field`
        # @return [String]
        attr_accessor :field
      
        # The metric to update.
        # Corresponds to the JSON property `metric`
        # @return [String]
        attr_accessor :metric
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @field = args[:field] if args.key?(:field)
          @metric = args[:metric] if args.key?(:metric)
        end
      end
      
      # Write a Data Access (Gin) log
      class LogConfigDataAccessOptions
        include Google::Apis::Core::Hashable
      
        # Whether Gin logging should happen in a fail-closed manner at the caller. This
        # is relevant only in the LocalIAM implementation, for now.
        # Corresponds to the JSON property `logMode`
        # @return [String]
        attr_accessor :log_mode
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @log_mode = args[:log_mode] if args.key?(:log_mode)
        end
      end
      
      # Represents a Machine Type resource.
      # You can use specific machine types for your VM instances based on performance
      # and pricing requirements. For more information, read Machine Types. (==
      # resource_for v1.machineTypes ==) (== resource_for beta.machineTypes ==)
      class MachineType
        include Google::Apis::Core::Hashable
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # Deprecation status for a public resource.
        # Corresponds to the JSON property `deprecated`
        # @return [Google::Apis::ComputeBeta::DeprecationStatus]
        attr_accessor :deprecated
      
        # [Output Only] An optional textual description of the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The number of virtual CPUs that are available to the instance.
        # Corresponds to the JSON property `guestCpus`
        # @return [Fixnum]
        attr_accessor :guest_cpus
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Whether this machine type has a shared CPU. See Shared-core
        # machine types for more information.
        # Corresponds to the JSON property `isSharedCpu`
        # @return [Boolean]
        attr_accessor :is_shared_cpu
        alias_method :is_shared_cpu?, :is_shared_cpu
      
        # [Output Only] The type of the resource. Always compute#machineType for machine
        # types.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] Maximum persistent disks allowed.
        # Corresponds to the JSON property `maximumPersistentDisks`
        # @return [Fixnum]
        attr_accessor :maximum_persistent_disks
      
        # [Output Only] Maximum total persistent disks size (GB) allowed.
        # Corresponds to the JSON property `maximumPersistentDisksSizeGb`
        # @return [Fixnum]
        attr_accessor :maximum_persistent_disks_size_gb
      
        # [Output Only] The amount of physical memory available to the instance, defined
        # in MB.
        # Corresponds to the JSON property `memoryMb`
        # @return [Fixnum]
        attr_accessor :memory_mb
      
        # [Output Only] Name of the resource.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] The name of the zone where the machine type resides, such as us-
        # central1-a.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @deprecated = args[:deprecated] if args.key?(:deprecated)
          @description = args[:description] if args.key?(:description)
          @guest_cpus = args[:guest_cpus] if args.key?(:guest_cpus)
          @id = args[:id] if args.key?(:id)
          @is_shared_cpu = args[:is_shared_cpu] if args.key?(:is_shared_cpu)
          @kind = args[:kind] if args.key?(:kind)
          @maximum_persistent_disks = args[:maximum_persistent_disks] if args.key?(:maximum_persistent_disks)
          @maximum_persistent_disks_size_gb = args[:maximum_persistent_disks_size_gb] if args.key?(:maximum_persistent_disks_size_gb)
          @memory_mb = args[:memory_mb] if args.key?(:memory_mb)
          @name = args[:name] if args.key?(:name)
          @self_link = args[:self_link] if args.key?(:self_link)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class MachineTypeAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of MachineTypesScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::MachineTypesScopedList>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#machineTypeAggregatedList for
        # aggregated lists of machine types.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::MachineTypeAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::MachineTypeAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of machine types.
      class MachineTypeList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of MachineType resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::MachineType>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#machineTypeList for lists of
        # machine types.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::MachineTypeList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::MachineTypeList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class MachineTypesScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] A list of machine types contained in this scope.
        # Corresponds to the JSON property `machineTypes`
        # @return [Array<Google::Apis::ComputeBeta::MachineType>]
        attr_accessor :machine_types
      
        # [Output Only] An informational warning that appears when the machine types
        # list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::MachineTypesScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @machine_types = args[:machine_types] if args.key?(:machine_types)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] An informational warning that appears when the machine types
        # list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::MachineTypesScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # A Managed Instance resource.
      class ManagedInstance
        include Google::Apis::Core::Hashable
      
        # [Output Only] The current action that the managed instance group has scheduled
        # for the instance. Possible values:
        # - NONE The instance is running, and the managed instance group does not have
        # any scheduled actions for this instance.
        # - CREATING The managed instance group is creating this instance. If the group
        # fails to create this instance, it will try again until it is successful.
        # - CREATING_WITHOUT_RETRIES The managed instance group is attempting to create
        # this instance only once. If the group fails to create this instance, it does
        # not try again and the group's targetSize value is decreased instead.
        # - RECREATING The managed instance group is recreating this instance.
        # - DELETING The managed instance group is permanently deleting this instance.
        # - ABANDONING The managed instance group is abandoning this instance. The
        # instance will be removed from the instance group and from any target pools
        # that are associated with this group.
        # - RESTARTING The managed instance group is restarting the instance.
        # - REFRESHING The managed instance group is applying configuration changes to
        # the instance without stopping it. For example, the group can update the target
        # pool list for an instance without stopping that instance.
        # - VERIFYING The managed instance group has created the instance and it is in
        # the process of being verified.
        # Corresponds to the JSON property `currentAction`
        # @return [String]
        attr_accessor :current_action
      
        # [Output only] The unique identifier for this resource. This field is empty
        # when instance does not exist.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] The URL of the instance. The URL can exist even if the instance
        # has not yet been created.
        # Corresponds to the JSON property `instance`
        # @return [String]
        attr_accessor :instance
      
        # [Output Only] Health state of the instance per health-check.
        # Corresponds to the JSON property `instanceHealth`
        # @return [Array<Google::Apis::ComputeBeta::ManagedInstanceInstanceHealth>]
        attr_accessor :instance_health
      
        # [Output Only] The status of the instance. This field is empty when the
        # instance does not exist.
        # Corresponds to the JSON property `instanceStatus`
        # @return [String]
        attr_accessor :instance_status
      
        # [Output Only] Information about the last attempt to create or delete the
        # instance.
        # Corresponds to the JSON property `lastAttempt`
        # @return [Google::Apis::ComputeBeta::ManagedInstanceLastAttempt]
        attr_accessor :last_attempt
      
        # [Output Only] Intended version of this instance.
        # Corresponds to the JSON property `version`
        # @return [Google::Apis::ComputeBeta::ManagedInstanceVersion]
        attr_accessor :version
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @current_action = args[:current_action] if args.key?(:current_action)
          @id = args[:id] if args.key?(:id)
          @instance = args[:instance] if args.key?(:instance)
          @instance_health = args[:instance_health] if args.key?(:instance_health)
          @instance_status = args[:instance_status] if args.key?(:instance_status)
          @last_attempt = args[:last_attempt] if args.key?(:last_attempt)
          @version = args[:version] if args.key?(:version)
        end
      end
      
      # 
      class ManagedInstanceInstanceHealth
        include Google::Apis::Core::Hashable
      
        # [Output Only] The current detailed instance health state.
        # Corresponds to the JSON property `detailedHealthState`
        # @return [String]
        attr_accessor :detailed_health_state
      
        # [Output Only] The URL for the health check that verifies whether the instance
        # is healthy.
        # Corresponds to the JSON property `healthCheck`
        # @return [String]
        attr_accessor :health_check
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @detailed_health_state = args[:detailed_health_state] if args.key?(:detailed_health_state)
          @health_check = args[:health_check] if args.key?(:health_check)
        end
      end
      
      # 
      class ManagedInstanceLastAttempt
        include Google::Apis::Core::Hashable
      
        # [Output Only] Encountered errors during the last attempt to create or delete
        # the instance.
        # Corresponds to the JSON property `errors`
        # @return [Google::Apis::ComputeBeta::ManagedInstanceLastAttempt::Errors]
        attr_accessor :errors
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @errors = args[:errors] if args.key?(:errors)
        end
        
        # [Output Only] Encountered errors during the last attempt to create or delete
        # the instance.
        class Errors
          include Google::Apis::Core::Hashable
        
          # [Output Only] The array of errors encountered while processing this operation.
          # Corresponds to the JSON property `errors`
          # @return [Array<Google::Apis::ComputeBeta::ManagedInstanceLastAttempt::Errors::Error>]
          attr_accessor :errors
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @errors = args[:errors] if args.key?(:errors)
          end
          
          # 
          class Error
            include Google::Apis::Core::Hashable
          
            # [Output Only] The error type identifier for this error.
            # Corresponds to the JSON property `code`
            # @return [String]
            attr_accessor :code
          
            # [Output Only] Indicates the field in the request that caused the error. This
            # property is optional.
            # Corresponds to the JSON property `location`
            # @return [String]
            attr_accessor :location
          
            # [Output Only] An optional, human-readable error message.
            # Corresponds to the JSON property `message`
            # @return [String]
            attr_accessor :message
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @code = args[:code] if args.key?(:code)
              @location = args[:location] if args.key?(:location)
              @message = args[:message] if args.key?(:message)
            end
          end
        end
      end
      
      # 
      class ManagedInstanceVersion
        include Google::Apis::Core::Hashable
      
        # [Output Only] The intended template of the instance. This field is empty when
        # current_action is one of ` DELETING, ABANDONING `.
        # Corresponds to the JSON property `instanceTemplate`
        # @return [String]
        attr_accessor :instance_template
      
        # [Output Only] Name of the version.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_template = args[:instance_template] if args.key?(:instance_template)
          @name = args[:name] if args.key?(:name)
        end
      end
      
      # A metadata key/value entry.
      class Metadata
        include Google::Apis::Core::Hashable
      
        # Specifies a fingerprint for this request, which is essentially a hash of the
        # metadata's contents and used for optimistic locking. The fingerprint is
        # initially generated by Compute Engine and changes after every request to
        # modify or update metadata. You must always provide an up-to-date fingerprint
        # hash in order to update or change metadata, otherwise the request will fail
        # with error 412 conditionNotMet.
        # To see the latest fingerprint, make a get() request to retrieve the resource.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # Array of key/value pairs. The total size of all keys and values must be less
        # than 512 KB.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::Metadata::Item>]
        attr_accessor :items
      
        # [Output Only] Type of the resource. Always compute#metadata for metadata.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
        end
        
        # 
        class Item
          include Google::Apis::Core::Hashable
        
          # Key for the metadata entry. Keys must conform to the following regexp: [a-zA-
          # Z0-9-_]+, and be less than 128 bytes in length. This is reflected as part of a
          # URL in the metadata server. Additionally, to avoid ambiguity, keys must not
          # conflict with any other metadata keys for the project.
          # Corresponds to the JSON property `key`
          # @return [String]
          attr_accessor :key
        
          # Value for the metadata entry. These are free-form strings, and only have
          # meaning as interpreted by the image running in the instance. The only
          # restriction placed on values is that their size must be less than or equal to
          # 262144 bytes (256 KiB).
          # Corresponds to the JSON property `value`
          # @return [String]
          attr_accessor :value
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @key = args[:key] if args.key?(:key)
            @value = args[:value] if args.key?(:value)
          end
        end
      end
      
      # Opaque filter criteria used by loadbalancers to restrict routing configuration
      # to a limited set of loadbalancing proxies. Proxies and sidecars involved in
      # loadbalancing would typically present metadata to the loadbalancers which need
      # to match criteria specified here. If a match takes place, the relevant routing
      # configuration is made available to those proxies.
      # For each metadataFilter in this list, if its filterMatchCriteria is set to
      # MATCH_ANY, at least one of the filterLabels must match the corresponding label
      # provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then
      # all of its filterLabels must match with corresponding labels in the provided
      # metadata.
      # An example for using metadataFilters would be: if loadbalancing involves
      # Envoys, they will only receive routing configuration when values in
      # metadataFilters match values supplied in <a href="https://www.envoyproxy.io/
      # docs/envoy/latest/api-v2/api/v2/core/base.proto#envoy-api-msg-core-node" Node
      # metadata of their XDS requests to loadbalancers.
      class MetadataFilter
        include Google::Apis::Core::Hashable
      
        # The list of label value pairs that must match labels in the provided metadata
        # based on filterMatchCriteria
        # This list must not be empty and can have at the most 64 entries.
        # Corresponds to the JSON property `filterLabels`
        # @return [Array<Google::Apis::ComputeBeta::MetadataFilterLabelMatch>]
        attr_accessor :filter_labels
      
        # Specifies how individual filterLabel matches within the list of filterLabels
        # contribute towards the overall metadataFilter match.
        # Supported values are:
        # - MATCH_ANY: At least one of the filterLabels must have a matching label in
        # the provided metadata.
        # - MATCH_ALL: All filterLabels must have matching labels in the provided
        # metadata.
        # Corresponds to the JSON property `filterMatchCriteria`
        # @return [String]
        attr_accessor :filter_match_criteria
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @filter_labels = args[:filter_labels] if args.key?(:filter_labels)
          @filter_match_criteria = args[:filter_match_criteria] if args.key?(:filter_match_criteria)
        end
      end
      
      # MetadataFilter label name value pairs that are expected to match corresponding
      # labels presented as metadata to the loadbalancer.
      class MetadataFilterLabelMatch
        include Google::Apis::Core::Hashable
      
        # Name of metadata label.
        # The name can have a maximum length of 1024 characters and must be at least 1
        # character long.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The value of the label must match the specified value.
        # value can have a maximum length of 1024 characters.
        # Corresponds to the JSON property `value`
        # @return [String]
        attr_accessor :value
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @name = args[:name] if args.key?(:name)
          @value = args[:value] if args.key?(:value)
        end
      end
      
      # The named port. For example: .
      class NamedPort
        include Google::Apis::Core::Hashable
      
        # The name for this named port. The name must be 1-63 characters long, and
        # comply with RFC1035.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The port number, which can be a value between 1 and 65535.
        # Corresponds to the JSON property `port`
        # @return [Fixnum]
        attr_accessor :port
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @name = args[:name] if args.key?(:name)
          @port = args[:port] if args.key?(:port)
        end
      end
      
      # Represents a VPC Network resource.
      # Networks connect resources to each other and to the internet. For more
      # information, read Virtual Private Cloud (VPC) Network. (== resource_for v1.
      # networks ==) (== resource_for beta.networks ==)
      class Network
        include Google::Apis::Core::Hashable
      
        # Deprecated in favor of subnet mode networks. The range of internal addresses
        # that are legal on this network. This range is a CIDR specification, for
        # example: 192.168.0.0/16. Provided by the client when the network is created.
        # Corresponds to the JSON property `IPv4Range`
        # @return [String]
        attr_accessor :i_pv4_range
      
        # When set to true, the VPC network is created in "auto" mode. When set to false,
        # the VPC network is created in "custom" mode.
        # An auto mode VPC network starts with one subnet per region. Each subnet has a
        # predetermined range as described in Auto mode VPC network IP ranges.
        # Corresponds to the JSON property `autoCreateSubnetworks`
        # @return [Boolean]
        attr_accessor :auto_create_subnetworks
        alias_method :auto_create_subnetworks?, :auto_create_subnetworks
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this field when you create
        # the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The gateway address for default routing out of the network,
        # selected by GCP.
        # Corresponds to the JSON property `gatewayIPv4`
        # @return [String]
        attr_accessor :gateway_i_pv4
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Type of the resource. Always compute#network for networks.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Name of the resource. Provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?. The first character must be a lowercase letter, and all
        # following characters (except for the last character) must be a dash, lowercase
        # letter, or digit. The last character must be a lowercase letter or digit.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # [Output Only] A list of network peerings for the resource.
        # Corresponds to the JSON property `peerings`
        # @return [Array<Google::Apis::ComputeBeta::NetworkPeering>]
        attr_accessor :peerings
      
        # A routing configuration attached to a network resource. The message includes
        # the list of routers associated with the network, and a flag indicating the
        # type of routing behavior to enforce network-wide.
        # Corresponds to the JSON property `routingConfig`
        # @return [Google::Apis::ComputeBeta::NetworkRoutingConfig]
        attr_accessor :routing_config
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Server-defined fully-qualified URLs for all subnetworks in this
        # VPC network.
        # Corresponds to the JSON property `subnetworks`
        # @return [Array<String>]
        attr_accessor :subnetworks
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @i_pv4_range = args[:i_pv4_range] if args.key?(:i_pv4_range)
          @auto_create_subnetworks = args[:auto_create_subnetworks] if args.key?(:auto_create_subnetworks)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @gateway_i_pv4 = args[:gateway_i_pv4] if args.key?(:gateway_i_pv4)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @peerings = args[:peerings] if args.key?(:peerings)
          @routing_config = args[:routing_config] if args.key?(:routing_config)
          @self_link = args[:self_link] if args.key?(:self_link)
          @subnetworks = args[:subnetworks] if args.key?(:subnetworks)
        end
      end
      
      # The network endpoint.
      class NetworkEndpoint
        include Google::Apis::Core::Hashable
      
        # The name for a specific VM instance that the IP address belongs to. This is
        # required for network endpoints of type GCE_VM_IP_PORT. The instance must be in
        # the same zone of network endpoint group.
        # The name must be 1-63 characters long, and comply with RFC1035.
        # Corresponds to the JSON property `instance`
        # @return [String]
        attr_accessor :instance
      
        # Optional IPv4 address of network endpoint. The IP address must belong to a VM
        # in Compute Engine (either the primary IP or as part of an aliased IP range).
        # If the IP address is not specified, then the primary IP address for the VM
        # instance in the network that the network endpoint group belongs to will be
        # used.
        # Corresponds to the JSON property `ipAddress`
        # @return [String]
        attr_accessor :ip_address
      
        # Optional port number of network endpoint. If not specified and the
        # NetworkEndpointGroup.network_endpoint_type is GCE_IP_PORT, the defaultPort for
        # the network endpoint group will be used.
        # Corresponds to the JSON property `port`
        # @return [Fixnum]
        attr_accessor :port
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance = args[:instance] if args.key?(:instance)
          @ip_address = args[:ip_address] if args.key?(:ip_address)
          @port = args[:port] if args.key?(:port)
        end
      end
      
      # Represents a collection of network endpoints.
      class NetworkEndpointGroup
        include Google::Apis::Core::Hashable
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # The default port used if the port number is not specified in the network
        # endpoint.
        # Corresponds to the JSON property `defaultPort`
        # @return [Fixnum]
        attr_accessor :default_port
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Type of the resource. Always compute#networkEndpointGroup for
        # network endpoint group.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Load balancing specific fields for network endpoint group.
        # Corresponds to the JSON property `loadBalancer`
        # @return [Google::Apis::ComputeBeta::NetworkEndpointGroupLbNetworkEndpointGroup]
        attr_accessor :load_balancer
      
        # Name of the resource; provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter,
        # and all following characters must be a dash, lowercase letter, or digit,
        # except the last character, which cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The URL of the network to which all network endpoints in the NEG belong. Uses "
        # default" project network if unspecified.
        # Corresponds to the JSON property `network`
        # @return [String]
        attr_accessor :network
      
        # Type of network endpoints in this network endpoint group. Currently the only
        # supported value is GCE_VM_IP_PORT.
        # Corresponds to the JSON property `networkEndpointType`
        # @return [String]
        attr_accessor :network_endpoint_type
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output only] Number of network endpoints in the network endpoint group.
        # Corresponds to the JSON property `size`
        # @return [Fixnum]
        attr_accessor :size
      
        # Optional URL of the subnetwork to which all network endpoints in the NEG
        # belong.
        # Corresponds to the JSON property `subnetwork`
        # @return [String]
        attr_accessor :subnetwork
      
        # [Output Only] The URL of the zone where the network endpoint group is located.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @default_port = args[:default_port] if args.key?(:default_port)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @load_balancer = args[:load_balancer] if args.key?(:load_balancer)
          @name = args[:name] if args.key?(:name)
          @network = args[:network] if args.key?(:network)
          @network_endpoint_type = args[:network_endpoint_type] if args.key?(:network_endpoint_type)
          @self_link = args[:self_link] if args.key?(:self_link)
          @size = args[:size] if args.key?(:size)
          @subnetwork = args[:subnetwork] if args.key?(:subnetwork)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class NetworkEndpointGroupAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of NetworkEndpointGroupsScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::NetworkEndpointGroupsScopedList>]
        attr_accessor :items
      
        # [Output Only] The resource type, which is always compute#
        # networkEndpointGroupAggregatedList for aggregated lists of network endpoint
        # groups.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::NetworkEndpointGroupAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::NetworkEndpointGroupAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Load balancing specific fields for network endpoint group.
      class NetworkEndpointGroupLbNetworkEndpointGroup
        include Google::Apis::Core::Hashable
      
        # The default port used if the port number is not specified in the network
        # endpoint. [Deprecated] This field is deprecated.
        # Corresponds to the JSON property `defaultPort`
        # @return [Fixnum]
        attr_accessor :default_port
      
        # The URL of the network to which all network endpoints in the NEG belong. Uses "
        # default" project network if unspecified. [Deprecated] This field is deprecated.
        # Corresponds to the JSON property `network`
        # @return [String]
        attr_accessor :network
      
        # Optional URL of the subnetwork to which all network endpoints in the NEG
        # belong. [Deprecated] This field is deprecated.
        # Corresponds to the JSON property `subnetwork`
        # @return [String]
        attr_accessor :subnetwork
      
        # [Output Only] The URL of the zone where the network endpoint group is located.
        # [Deprecated] This field is deprecated.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @default_port = args[:default_port] if args.key?(:default_port)
          @network = args[:network] if args.key?(:network)
          @subnetwork = args[:subnetwork] if args.key?(:subnetwork)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class NetworkEndpointGroupList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of NetworkEndpointGroup resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::NetworkEndpointGroup>]
        attr_accessor :items
      
        # [Output Only] The resource type, which is always compute#
        # networkEndpointGroupList for network endpoint group lists.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::NetworkEndpointGroupList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::NetworkEndpointGroupList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class NetworkEndpointGroupsAttachEndpointsRequest
        include Google::Apis::Core::Hashable
      
        # The list of network endpoints to be attached.
        # Corresponds to the JSON property `networkEndpoints`
        # @return [Array<Google::Apis::ComputeBeta::NetworkEndpoint>]
        attr_accessor :network_endpoints
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @network_endpoints = args[:network_endpoints] if args.key?(:network_endpoints)
        end
      end
      
      # 
      class NetworkEndpointGroupsDetachEndpointsRequest
        include Google::Apis::Core::Hashable
      
        # The list of network endpoints to be detached.
        # Corresponds to the JSON property `networkEndpoints`
        # @return [Array<Google::Apis::ComputeBeta::NetworkEndpoint>]
        attr_accessor :network_endpoints
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @network_endpoints = args[:network_endpoints] if args.key?(:network_endpoints)
        end
      end
      
      # 
      class NetworkEndpointGroupsListEndpointsRequest
        include Google::Apis::Core::Hashable
      
        # Optional query parameter for showing the health status of each network
        # endpoint. Valid options are SKIP or SHOW. If you don't specifiy this parameter,
        # the health status of network endpoints will not be provided.
        # Corresponds to the JSON property `healthStatus`
        # @return [String]
        attr_accessor :health_status
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @health_status = args[:health_status] if args.key?(:health_status)
        end
      end
      
      # 
      class NetworkEndpointGroupsListNetworkEndpoints
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of NetworkEndpointWithHealthStatus resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::NetworkEndpointWithHealthStatus>]
        attr_accessor :items
      
        # [Output Only] The resource type, which is always compute#
        # networkEndpointGroupsListNetworkEndpoints for the list of network endpoints in
        # the specified network endpoint group.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::NetworkEndpointGroupsListNetworkEndpoints::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::NetworkEndpointGroupsListNetworkEndpoints::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class NetworkEndpointGroupsScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] The list of network endpoint groups that are contained in this
        # scope.
        # Corresponds to the JSON property `networkEndpointGroups`
        # @return [Array<Google::Apis::ComputeBeta::NetworkEndpointGroup>]
        attr_accessor :network_endpoint_groups
      
        # [Output Only] An informational warning that replaces the list of network
        # endpoint groups when the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::NetworkEndpointGroupsScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @network_endpoint_groups = args[:network_endpoint_groups] if args.key?(:network_endpoint_groups)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] An informational warning that replaces the list of network
        # endpoint groups when the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::NetworkEndpointGroupsScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class NetworkEndpointWithHealthStatus
        include Google::Apis::Core::Hashable
      
        # [Output only] The health status of network endpoint;
        # Corresponds to the JSON property `healths`
        # @return [Array<Google::Apis::ComputeBeta::HealthStatusForNetworkEndpoint>]
        attr_accessor :healths
      
        # The network endpoint.
        # Corresponds to the JSON property `networkEndpoint`
        # @return [Google::Apis::ComputeBeta::NetworkEndpoint]
        attr_accessor :network_endpoint
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @healths = args[:healths] if args.key?(:healths)
          @network_endpoint = args[:network_endpoint] if args.key?(:network_endpoint)
        end
      end
      
      # A network interface resource attached to an instance.
      class NetworkInterface
        include Google::Apis::Core::Hashable
      
        # An array of configurations for this interface. Currently, only one access
        # config, ONE_TO_ONE_NAT, is supported. If there are no accessConfigs specified,
        # then this instance will have no external internet access.
        # Corresponds to the JSON property `accessConfigs`
        # @return [Array<Google::Apis::ComputeBeta::AccessConfig>]
        attr_accessor :access_configs
      
        # An array of alias IP ranges for this network interface. You can only specify
        # this field for network interfaces in VPC networks.
        # Corresponds to the JSON property `aliasIpRanges`
        # @return [Array<Google::Apis::ComputeBeta::AliasIpRange>]
        attr_accessor :alias_ip_ranges
      
        # Fingerprint hash of contents stored in this network interface. This field will
        # be ignored when inserting an Instance or adding a NetworkInterface. An up-to-
        # date fingerprint must be provided in order to update the NetworkInterface,
        # otherwise the request will fail with error 412 conditionNotMet.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # [Output Only] Type of the resource. Always compute#networkInterface for
        # network interfaces.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] The name of the network interface, which is generated by the
        # server. For network devices, these are eth0, eth1, etc.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # URL of the network resource for this instance. When creating an instance, if
        # neither the network nor the subnetwork is specified, the default network
        # global/networks/default is used; if the network is not specified but the
        # subnetwork is specified, the network is inferred.
        # If you specify this property, you can specify the network as a full or partial
        # URL. For example, the following are all valid URLs:
        # - https://www.googleapis.com/compute/v1/projects/project/global/networks/
        # network
        # - projects/project/global/networks/network
        # - global/networks/default
        # Corresponds to the JSON property `network`
        # @return [String]
        attr_accessor :network
      
        # An IPv4 internal IP address to assign to the instance for this network
        # interface. If not specified by the user, an unused internal IP is assigned by
        # the system.
        # Corresponds to the JSON property `networkIP`
        # @return [String]
        attr_accessor :network_ip
      
        # The URL of the Subnetwork resource for this instance. If the network resource
        # is in legacy mode, do not specify this field. If the network is in auto subnet
        # mode, specifying the subnetwork is optional. If the network is in custom
        # subnet mode, specifying the subnetwork is required. If you specify this field,
        # you can specify the subnetwork as a full or partial URL. For example, the
        # following are all valid URLs:
        # - https://www.googleapis.com/compute/v1/projects/project/regions/region/
        # subnetworks/subnetwork
        # - regions/region/subnetworks/subnetwork
        # Corresponds to the JSON property `subnetwork`
        # @return [String]
        attr_accessor :subnetwork
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @access_configs = args[:access_configs] if args.key?(:access_configs)
          @alias_ip_ranges = args[:alias_ip_ranges] if args.key?(:alias_ip_ranges)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @network = args[:network] if args.key?(:network)
          @network_ip = args[:network_ip] if args.key?(:network_ip)
          @subnetwork = args[:subnetwork] if args.key?(:subnetwork)
        end
      end
      
      # Contains a list of networks.
      class NetworkList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Network resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::Network>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#networkList for lists of
        # networks.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::NetworkList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::NetworkList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # A network peering attached to a network resource. The message includes the
      # peering name, peer network, peering state, and a flag indicating whether
      # Google Compute Engine should automatically create routes for the peering.
      class NetworkPeering
        include Google::Apis::Core::Hashable
      
        # This field will be deprecated soon. Use the exchange_subnet_routes field
        # instead. Indicates whether full mesh connectivity is created and managed
        # automatically between peered networks. Currently this field should always be
        # true since Google Compute Engine will automatically create and manage
        # subnetwork routes between two networks when peering state is ACTIVE.
        # Corresponds to the JSON property `autoCreateRoutes`
        # @return [Boolean]
        attr_accessor :auto_create_routes
        alias_method :auto_create_routes?, :auto_create_routes
      
        # Indicates whether full mesh connectivity is created and managed automatically
        # between peered networks. Currently this field should always be true since
        # Google Compute Engine will automatically create and manage subnetwork routes
        # between two networks when peering state is ACTIVE.
        # Corresponds to the JSON property `exchangeSubnetRoutes`
        # @return [Boolean]
        attr_accessor :exchange_subnet_routes
        alias_method :exchange_subnet_routes?, :exchange_subnet_routes
      
        # Whether to export the custom routes to peer network.
        # Corresponds to the JSON property `exportCustomRoutes`
        # @return [Boolean]
        attr_accessor :export_custom_routes
        alias_method :export_custom_routes?, :export_custom_routes
      
        # Whether to import the custom routes from peer network.
        # Corresponds to the JSON property `importCustomRoutes`
        # @return [Boolean]
        attr_accessor :import_custom_routes
        alias_method :import_custom_routes?, :import_custom_routes
      
        # Name of this peering. Provided by the client when the peering is created. The
        # name must comply with RFC1035. Specifically, the name must be 1-63 characters
        # long and match regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first
        # character must be a lowercase letter, and all the following characters must be
        # a dash, lowercase letter, or digit, except the last character, which cannot be
        # a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The URL of the peer network. It can be either full URL or partial URL. The
        # peer network may belong to a different project. If the partial URL does not
        # contain project, it is assumed that the peer network is in the same project as
        # the current network.
        # Corresponds to the JSON property `network`
        # @return [String]
        attr_accessor :network
      
        # [Output Only] State for the peering, either `ACTIVE` or `INACTIVE`. The
        # peering is `ACTIVE` when there's a matching configuration in the peer network.
        # Corresponds to the JSON property `state`
        # @return [String]
        attr_accessor :state
      
        # [Output Only] Details about the current state of the peering.
        # Corresponds to the JSON property `stateDetails`
        # @return [String]
        attr_accessor :state_details
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @auto_create_routes = args[:auto_create_routes] if args.key?(:auto_create_routes)
          @exchange_subnet_routes = args[:exchange_subnet_routes] if args.key?(:exchange_subnet_routes)
          @export_custom_routes = args[:export_custom_routes] if args.key?(:export_custom_routes)
          @import_custom_routes = args[:import_custom_routes] if args.key?(:import_custom_routes)
          @name = args[:name] if args.key?(:name)
          @network = args[:network] if args.key?(:network)
          @state = args[:state] if args.key?(:state)
          @state_details = args[:state_details] if args.key?(:state_details)
        end
      end
      
      # A routing configuration attached to a network resource. The message includes
      # the list of routers associated with the network, and a flag indicating the
      # type of routing behavior to enforce network-wide.
      class NetworkRoutingConfig
        include Google::Apis::Core::Hashable
      
        # The network-wide routing mode to use. If set to REGIONAL, this network's Cloud
        # Routers will only advertise routes with subnets of this network in the same
        # region as the router. If set to GLOBAL, this network's Cloud Routers will
        # advertise routes with all subnets of this network, across regions.
        # Corresponds to the JSON property `routingMode`
        # @return [String]
        attr_accessor :routing_mode
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @routing_mode = args[:routing_mode] if args.key?(:routing_mode)
        end
      end
      
      # 
      class NetworksAddPeeringRequest
        include Google::Apis::Core::Hashable
      
        # This field will be deprecated soon. Use exchange_subnet_routes in
        # network_peering instead. Indicates whether full mesh connectivity is created
        # and managed automatically between peered networks. Currently this field should
        # always be true since Google Compute Engine will automatically create and
        # manage subnetwork routes between two networks when peering state is ACTIVE.
        # Corresponds to the JSON property `autoCreateRoutes`
        # @return [Boolean]
        attr_accessor :auto_create_routes
        alias_method :auto_create_routes?, :auto_create_routes
      
        # Name of the peering, which should conform to RFC1035.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # A network peering attached to a network resource. The message includes the
        # peering name, peer network, peering state, and a flag indicating whether
        # Google Compute Engine should automatically create routes for the peering.
        # Corresponds to the JSON property `networkPeering`
        # @return [Google::Apis::ComputeBeta::NetworkPeering]
        attr_accessor :network_peering
      
        # URL of the peer network. It can be either full URL or partial URL. The peer
        # network may belong to a different project. If the partial URL does not contain
        # project, it is assumed that the peer network is in the same project as the
        # current network.
        # Corresponds to the JSON property `peerNetwork`
        # @return [String]
        attr_accessor :peer_network
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @auto_create_routes = args[:auto_create_routes] if args.key?(:auto_create_routes)
          @name = args[:name] if args.key?(:name)
          @network_peering = args[:network_peering] if args.key?(:network_peering)
          @peer_network = args[:peer_network] if args.key?(:peer_network)
        end
      end
      
      # 
      class NetworksRemovePeeringRequest
        include Google::Apis::Core::Hashable
      
        # Name of the peering, which should conform to RFC1035.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @name = args[:name] if args.key?(:name)
        end
      end
      
      # 
      class NetworksUpdatePeeringRequest
        include Google::Apis::Core::Hashable
      
        # A network peering attached to a network resource. The message includes the
        # peering name, peer network, peering state, and a flag indicating whether
        # Google Compute Engine should automatically create routes for the peering.
        # Corresponds to the JSON property `networkPeering`
        # @return [Google::Apis::ComputeBeta::NetworkPeering]
        attr_accessor :network_peering
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @network_peering = args[:network_peering] if args.key?(:network_peering)
        end
      end
      
      # Represent a sole-tenant Node Group resource.
      # A sole-tenant node is a physical server that is dedicated to hosting VM
      # instances only for your specific project. Use sole-tenant nodes to keep your
      # instances physically separated from instances in other projects, or to group
      # your instances together on the same host hardware. For more information, read
      # Sole-tenant nodes. (== resource_for beta.nodeGroups ==) (== resource_for v1.
      # nodeGroups ==) NextID: 15
      class NodeGroup
        include Google::Apis::Core::Hashable
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] The type of the resource. Always compute#nodeGroup for node
        # group.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # The name of the resource, provided by the client when initially creating the
        # resource. The resource name must be 1-63 characters long, and comply with
        # RFC1035. Specifically, the name must be 1-63 characters long and match the
        # regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must be a
        # dash, lowercase letter, or digit, except the last character, which cannot be a
        # dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The URL of the node template to which this node group belongs.
        # Corresponds to the JSON property `nodeTemplate`
        # @return [String]
        attr_accessor :node_template
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] The total number of nodes in the node group.
        # Corresponds to the JSON property `size`
        # @return [Fixnum]
        attr_accessor :size
      
        # 
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        # [Output Only] The name of the zone where the node group resides, such as us-
        # central1-a.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @node_template = args[:node_template] if args.key?(:node_template)
          @self_link = args[:self_link] if args.key?(:self_link)
          @size = args[:size] if args.key?(:size)
          @status = args[:status] if args.key?(:status)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class NodeGroupAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of NodeGroupsScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::NodeGroupsScopedList>]
        attr_accessor :items
      
        # [Output Only] Type of resource.Always compute#nodeGroupAggregatedList for
        # aggregated lists of node groups.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::NodeGroupAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::NodeGroupAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of nodeGroups.
      class NodeGroupList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of NodeGroup resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::NodeGroup>]
        attr_accessor :items
      
        # [Output Only] Type of resource.Always compute#nodeGroupList for lists of node
        # groups.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::NodeGroupList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::NodeGroupList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class NodeGroupNode
        include Google::Apis::Core::Hashable
      
        # Instances scheduled on this node.
        # Corresponds to the JSON property `instances`
        # @return [Array<String>]
        attr_accessor :instances
      
        # The name of the node.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The type of this node.
        # Corresponds to the JSON property `nodeType`
        # @return [String]
        attr_accessor :node_type
      
        # Binding properties for the physical server.
        # Corresponds to the JSON property `serverBinding`
        # @return [Google::Apis::ComputeBeta::ServerBinding]
        attr_accessor :server_binding
      
        # 
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
          @name = args[:name] if args.key?(:name)
          @node_type = args[:node_type] if args.key?(:node_type)
          @server_binding = args[:server_binding] if args.key?(:server_binding)
          @status = args[:status] if args.key?(:status)
        end
      end
      
      # 
      class NodeGroupsAddNodesRequest
        include Google::Apis::Core::Hashable
      
        # Count of additional nodes to be added to the node group.
        # Corresponds to the JSON property `additionalNodeCount`
        # @return [Fixnum]
        attr_accessor :additional_node_count
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @additional_node_count = args[:additional_node_count] if args.key?(:additional_node_count)
        end
      end
      
      # 
      class NodeGroupsDeleteNodesRequest
        include Google::Apis::Core::Hashable
      
        # Names of the nodes to delete.
        # Corresponds to the JSON property `nodes`
        # @return [Array<String>]
        attr_accessor :nodes
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @nodes = args[:nodes] if args.key?(:nodes)
        end
      end
      
      # 
      class NodeGroupsListNodes
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Node resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::NodeGroupNode>]
        attr_accessor :items
      
        # [Output Only] The resource type, which is always compute.nodeGroupsListNodes
        # for the list of nodes in the specified node group.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::NodeGroupsListNodes::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::NodeGroupsListNodes::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class NodeGroupsScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] A list of node groups contained in this scope.
        # Corresponds to the JSON property `nodeGroups`
        # @return [Array<Google::Apis::ComputeBeta::NodeGroup>]
        attr_accessor :node_groups
      
        # [Output Only] An informational warning that appears when the nodeGroup list is
        # empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::NodeGroupsScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @node_groups = args[:node_groups] if args.key?(:node_groups)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] An informational warning that appears when the nodeGroup list is
        # empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::NodeGroupsScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class NodeGroupsSetNodeTemplateRequest
        include Google::Apis::Core::Hashable
      
        # Full or partial URL of the node template resource to be updated for this node
        # group.
        # Corresponds to the JSON property `nodeTemplate`
        # @return [String]
        attr_accessor :node_template
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @node_template = args[:node_template] if args.key?(:node_template)
        end
      end
      
      # Represent a sole-tenant Node Template resource.
      # You can use a template to define properties for nodes in a node group. For
      # more information, read Creating node groups and instances. (== resource_for
      # beta.nodeTemplates ==) (== resource_for v1.nodeTemplates ==) (== NextID: 16 ==)
      class NodeTemplate
        include Google::Apis::Core::Hashable
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] The type of the resource. Always compute#nodeTemplate for node
        # templates.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # The name of the resource, provided by the client when initially creating the
        # resource. The resource name must be 1-63 characters long, and comply with
        # RFC1035. Specifically, the name must be 1-63 characters long and match the
        # regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must be a
        # dash, lowercase letter, or digit, except the last character, which cannot be a
        # dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Labels to use for node affinity, which will be used in instance scheduling.
        # Corresponds to the JSON property `nodeAffinityLabels`
        # @return [Hash<String,String>]
        attr_accessor :node_affinity_labels
      
        # The node type to use for nodes group that are created from this template.
        # Corresponds to the JSON property `nodeType`
        # @return [String]
        attr_accessor :node_type
      
        # The flexible properties of the desired node type. Node groups that use this
        # node template will create nodes of a type that matches these properties.
        # This field is mutually exclusive with the node_type property; you can only
        # define one or the other, but not both.
        # Corresponds to the JSON property `nodeTypeFlexibility`
        # @return [Google::Apis::ComputeBeta::NodeTemplateNodeTypeFlexibility]
        attr_accessor :node_type_flexibility
      
        # [Output Only] The name of the region where the node template resides, such as
        # us-central1.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Sets the binding properties for the physical server. Valid values include:
        # - [Default] RESTART_NODE_ON_ANY_SERVER: Restarts VMs on any available physical
        # server
        # - RESTART_NODE_ON_MINIMAL_SERVER: Restarts VMs on the same physical server
        # whenever possible
        # See Sole-tenant node options for more information.
        # Corresponds to the JSON property `serverBinding`
        # @return [Google::Apis::ComputeBeta::ServerBinding]
        attr_accessor :server_binding
      
        # [Output Only] The status of the node template. One of the following values:
        # CREATING, READY, and DELETING.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        # [Output Only] An optional, human-readable explanation of the status.
        # Corresponds to the JSON property `statusMessage`
        # @return [String]
        attr_accessor :status_message
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @node_affinity_labels = args[:node_affinity_labels] if args.key?(:node_affinity_labels)
          @node_type = args[:node_type] if args.key?(:node_type)
          @node_type_flexibility = args[:node_type_flexibility] if args.key?(:node_type_flexibility)
          @region = args[:region] if args.key?(:region)
          @self_link = args[:self_link] if args.key?(:self_link)
          @server_binding = args[:server_binding] if args.key?(:server_binding)
          @status = args[:status] if args.key?(:status)
          @status_message = args[:status_message] if args.key?(:status_message)
        end
      end
      
      # 
      class NodeTemplateAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of NodeTemplatesScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::NodeTemplatesScopedList>]
        attr_accessor :items
      
        # [Output Only] Type of resource.Always compute#nodeTemplateAggregatedList for
        # aggregated lists of node templates.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::NodeTemplateAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::NodeTemplateAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of node templates.
      class NodeTemplateList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of NodeTemplate resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::NodeTemplate>]
        attr_accessor :items
      
        # [Output Only] Type of resource.Always compute#nodeTemplateList for lists of
        # node templates.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::NodeTemplateList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::NodeTemplateList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class NodeTemplateNodeTypeFlexibility
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `cpus`
        # @return [String]
        attr_accessor :cpus
      
        # 
        # Corresponds to the JSON property `localSsd`
        # @return [String]
        attr_accessor :local_ssd
      
        # 
        # Corresponds to the JSON property `memory`
        # @return [String]
        attr_accessor :memory
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @cpus = args[:cpus] if args.key?(:cpus)
          @local_ssd = args[:local_ssd] if args.key?(:local_ssd)
          @memory = args[:memory] if args.key?(:memory)
        end
      end
      
      # 
      class NodeTemplatesScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] A list of node templates contained in this scope.
        # Corresponds to the JSON property `nodeTemplates`
        # @return [Array<Google::Apis::ComputeBeta::NodeTemplate>]
        attr_accessor :node_templates
      
        # [Output Only] An informational warning that appears when the node templates
        # list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::NodeTemplatesScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @node_templates = args[:node_templates] if args.key?(:node_templates)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] An informational warning that appears when the node templates
        # list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::NodeTemplatesScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Represent a sole-tenant Node Type resource.
      # Each node within a node group must have a node type. A node type specifies the
      # total amount of cores and memory for that node. Currently, the only available
      # node type is n1-node-96-624 node type that has 96 vCPUs and 624 GB of memory,
      # available in multiple zones. For more information read Node types. (==
      # resource_for beta.nodeTypes ==) (== resource_for v1.nodeTypes ==)
      class NodeType
        include Google::Apis::Core::Hashable
      
        # [Output Only] The CPU platform used by this node type.
        # Corresponds to the JSON property `cpuPlatform`
        # @return [String]
        attr_accessor :cpu_platform
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # Deprecation status for a public resource.
        # Corresponds to the JSON property `deprecated`
        # @return [Google::Apis::ComputeBeta::DeprecationStatus]
        attr_accessor :deprecated
      
        # [Output Only] An optional textual description of the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The number of virtual CPUs that are available to the node type.
        # Corresponds to the JSON property `guestCpus`
        # @return [Fixnum]
        attr_accessor :guest_cpus
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] The type of the resource. Always compute#nodeType for node types.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] Local SSD available to the node type, defined in GB.
        # Corresponds to the JSON property `localSsdGb`
        # @return [Fixnum]
        attr_accessor :local_ssd_gb
      
        # [Output Only] The amount of physical memory available to the node type,
        # defined in MB.
        # Corresponds to the JSON property `memoryMb`
        # @return [Fixnum]
        attr_accessor :memory_mb
      
        # [Output Only] Name of the resource.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] The name of the zone where the node type resides, such as us-
        # central1-a.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @cpu_platform = args[:cpu_platform] if args.key?(:cpu_platform)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @deprecated = args[:deprecated] if args.key?(:deprecated)
          @description = args[:description] if args.key?(:description)
          @guest_cpus = args[:guest_cpus] if args.key?(:guest_cpus)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @local_ssd_gb = args[:local_ssd_gb] if args.key?(:local_ssd_gb)
          @memory_mb = args[:memory_mb] if args.key?(:memory_mb)
          @name = args[:name] if args.key?(:name)
          @self_link = args[:self_link] if args.key?(:self_link)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class NodeTypeAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of NodeTypesScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::NodeTypesScopedList>]
        attr_accessor :items
      
        # [Output Only] Type of resource.Always compute#nodeTypeAggregatedList for
        # aggregated lists of node types.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::NodeTypeAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::NodeTypeAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of node types.
      class NodeTypeList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of NodeType resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::NodeType>]
        attr_accessor :items
      
        # [Output Only] Type of resource.Always compute#nodeTypeList for lists of node
        # types.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::NodeTypeList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::NodeTypeList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class NodeTypesScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] A list of node types contained in this scope.
        # Corresponds to the JSON property `nodeTypes`
        # @return [Array<Google::Apis::ComputeBeta::NodeType>]
        attr_accessor :node_types
      
        # [Output Only] An informational warning that appears when the node types list
        # is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::NodeTypesScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @node_types = args[:node_types] if args.key?(:node_types)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] An informational warning that appears when the node types list
        # is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::NodeTypesScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Represents an Operation resource.
      # You can use an operation resource to manage asynchronous API requests. For
      # more information, read Handling API responses.
      # Operations can be global, regional or zonal.
      # - For global operations, use the globalOperations resource.
      # - For regional operations, use the regionOperations resource.
      # - For zonal operations, use the zonalOperations resource.
      # For more information, read  Global, Regional, and Zonal Resources. (==
      # resource_for v1.globalOperations ==) (== resource_for beta.globalOperations ==)
      # (== resource_for v1.regionOperations ==) (== resource_for beta.
      # regionOperations ==) (== resource_for v1.zoneOperations ==) (== resource_for
      # beta.zoneOperations ==)
      class Operation
        include Google::Apis::Core::Hashable
      
        # [Output Only] The value of `requestId` if you provided it in the request. Not
        # present otherwise.
        # Corresponds to the JSON property `clientOperationId`
        # @return [String]
        attr_accessor :client_operation_id
      
        # [Deprecated] This field is deprecated.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # [Output Only] A textual description of the operation, which is set when the
        # operation is created.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The time that this operation was completed. This value is in
        # RFC3339 text format.
        # Corresponds to the JSON property `endTime`
        # @return [String]
        attr_accessor :end_time
      
        # [Output Only] If errors are generated during processing of the operation, this
        # field will be populated.
        # Corresponds to the JSON property `error`
        # @return [Google::Apis::ComputeBeta::Operation::Error]
        attr_accessor :error
      
        # [Output Only] If the operation fails, this field contains the HTTP error
        # message that was returned, such as NOT FOUND.
        # Corresponds to the JSON property `httpErrorMessage`
        # @return [String]
        attr_accessor :http_error_message
      
        # [Output Only] If the operation fails, this field contains the HTTP error
        # status code that was returned. For example, a 404 means the resource was not
        # found.
        # Corresponds to the JSON property `httpErrorStatusCode`
        # @return [Fixnum]
        attr_accessor :http_error_status_code
      
        # [Output Only] The unique identifier for the operation. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] The time that this operation was requested. This value is in
        # RFC3339 text format.
        # Corresponds to the JSON property `insertTime`
        # @return [String]
        attr_accessor :insert_time
      
        # [Output Only] Type of the resource. Always compute#operation for Operation
        # resources.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] Name of the operation.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # [Output Only] The type of operation, such as insert, update, or delete, and so
        # on.
        # Corresponds to the JSON property `operationType`
        # @return [String]
        attr_accessor :operation_type
      
        # [Output Only] An optional progress indicator that ranges from 0 to 100. There
        # is no requirement that this be linear or support any granularity of operations.
        # This should not be used to guess when the operation will be complete. This
        # number should monotonically increase as the operation progresses.
        # Corresponds to the JSON property `progress`
        # @return [Fixnum]
        attr_accessor :progress
      
        # [Output Only] The URL of the region where the operation resides. Only
        # applicable when performing regional operations.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] The time that this operation was started by the server. This
        # value is in RFC3339 text format.
        # Corresponds to the JSON property `startTime`
        # @return [String]
        attr_accessor :start_time
      
        # [Output Only] The status of the operation, which can be one of the following:
        # PENDING, RUNNING, or DONE.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        # [Output Only] An optional textual description of the current status of the
        # operation.
        # Corresponds to the JSON property `statusMessage`
        # @return [String]
        attr_accessor :status_message
      
        # [Output Only] The unique target ID, which identifies a specific incarnation of
        # the target resource.
        # Corresponds to the JSON property `targetId`
        # @return [Fixnum]
        attr_accessor :target_id
      
        # [Output Only] The URL of the resource that the operation modifies. For
        # operations related to creating a snapshot, this points to the persistent disk
        # that the snapshot was created from.
        # Corresponds to the JSON property `targetLink`
        # @return [String]
        attr_accessor :target_link
      
        # [Output Only] User who requested the operation, for example: user@example.com.
        # Corresponds to the JSON property `user`
        # @return [String]
        attr_accessor :user
      
        # [Output Only] If warning messages are generated during processing of the
        # operation, this field will be populated.
        # Corresponds to the JSON property `warnings`
        # @return [Array<Google::Apis::ComputeBeta::Operation::Warning>]
        attr_accessor :warnings
      
        # [Output Only] The URL of the zone where the operation resides. Only applicable
        # when performing per-zone operations.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @client_operation_id = args[:client_operation_id] if args.key?(:client_operation_id)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @end_time = args[:end_time] if args.key?(:end_time)
          @error = args[:error] if args.key?(:error)
          @http_error_message = args[:http_error_message] if args.key?(:http_error_message)
          @http_error_status_code = args[:http_error_status_code] if args.key?(:http_error_status_code)
          @id = args[:id] if args.key?(:id)
          @insert_time = args[:insert_time] if args.key?(:insert_time)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @operation_type = args[:operation_type] if args.key?(:operation_type)
          @progress = args[:progress] if args.key?(:progress)
          @region = args[:region] if args.key?(:region)
          @self_link = args[:self_link] if args.key?(:self_link)
          @start_time = args[:start_time] if args.key?(:start_time)
          @status = args[:status] if args.key?(:status)
          @status_message = args[:status_message] if args.key?(:status_message)
          @target_id = args[:target_id] if args.key?(:target_id)
          @target_link = args[:target_link] if args.key?(:target_link)
          @user = args[:user] if args.key?(:user)
          @warnings = args[:warnings] if args.key?(:warnings)
          @zone = args[:zone] if args.key?(:zone)
        end
        
        # [Output Only] If errors are generated during processing of the operation, this
        # field will be populated.
        class Error
          include Google::Apis::Core::Hashable
        
          # [Output Only] The array of errors encountered while processing this operation.
          # Corresponds to the JSON property `errors`
          # @return [Array<Google::Apis::ComputeBeta::Operation::Error::Error>]
          attr_accessor :errors
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @errors = args[:errors] if args.key?(:errors)
          end
          
          # 
          class Error
            include Google::Apis::Core::Hashable
          
            # [Output Only] The error type identifier for this error.
            # Corresponds to the JSON property `code`
            # @return [String]
            attr_accessor :code
          
            # [Output Only] Indicates the field in the request that caused the error. This
            # property is optional.
            # Corresponds to the JSON property `location`
            # @return [String]
            attr_accessor :location
          
            # [Output Only] An optional, human-readable error message.
            # Corresponds to the JSON property `message`
            # @return [String]
            attr_accessor :message
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @code = args[:code] if args.key?(:code)
              @location = args[:location] if args.key?(:location)
              @message = args[:message] if args.key?(:message)
            end
          end
        end
        
        # 
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::Operation::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class OperationAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # [Output Only] A map of scoped operation lists.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::OperationsScopedList>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#operationAggregatedList for
        # aggregated lists of operations.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::OperationAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::OperationAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of Operation resources.
      class OperationList
        include Google::Apis::Core::Hashable
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # [Output Only] A list of Operation resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::Operation>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#operations for Operations
        # resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::OperationList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::OperationList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class OperationsScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] A list of operations contained in this scope.
        # Corresponds to the JSON property `operations`
        # @return [Array<Google::Apis::ComputeBeta::Operation>]
        attr_accessor :operations
      
        # [Output Only] Informational warning which replaces the list of operations when
        # the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::OperationsScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @operations = args[:operations] if args.key?(:operations)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning which replaces the list of operations when
        # the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::OperationsScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Settings controlling eviction of unhealthy hosts from the load balancing pool.
      class OutlierDetection
        include Google::Apis::Core::Hashable
      
        # A Duration represents a fixed-length span of time represented as a count of
        # seconds and fractions of seconds at nanosecond resolution. It is independent
        # of any calendar and concepts like "day" or "month". Range is approximately 10,
        # 000 years.
        # Corresponds to the JSON property `baseEjectionTime`
        # @return [Google::Apis::ComputeBeta::Duration]
        attr_accessor :base_ejection_time
      
        # Number of errors before a host is ejected from the connection pool. When the
        # backend host is accessed over HTTP, a 5xx return code qualifies as an error.
        # Defaults to 5.
        # Corresponds to the JSON property `consecutiveErrors`
        # @return [Fixnum]
        attr_accessor :consecutive_errors
      
        # The number of consecutive gateway failures (502, 503, 504 status or connection
        # errors that are mapped to one of those status codes) before a consecutive
        # gateway failure ejection occurs. Defaults to 5.
        # Corresponds to the JSON property `consecutiveGatewayFailure`
        # @return [Fixnum]
        attr_accessor :consecutive_gateway_failure
      
        # The percentage chance that a host will be actually ejected when an outlier
        # status is detected through consecutive 5xx. This setting can be used to
        # disable ejection or to ramp it up slowly. Defaults to 100.
        # Corresponds to the JSON property `enforcingConsecutiveErrors`
        # @return [Fixnum]
        attr_accessor :enforcing_consecutive_errors
      
        # The percentage chance that a host will be actually ejected when an outlier
        # status is detected through consecutive gateway failures. This setting can be
        # used to disable ejection or to ramp it up slowly. Defaults to 0.
        # Corresponds to the JSON property `enforcingConsecutiveGatewayFailure`
        # @return [Fixnum]
        attr_accessor :enforcing_consecutive_gateway_failure
      
        # The percentage chance that a host will be actually ejected when an outlier
        # status is detected through success rate statistics. This setting can be used
        # to disable ejection or to ramp it up slowly. Defaults to 100.
        # Corresponds to the JSON property `enforcingSuccessRate`
        # @return [Fixnum]
        attr_accessor :enforcing_success_rate
      
        # A Duration represents a fixed-length span of time represented as a count of
        # seconds and fractions of seconds at nanosecond resolution. It is independent
        # of any calendar and concepts like "day" or "month". Range is approximately 10,
        # 000 years.
        # Corresponds to the JSON property `interval`
        # @return [Google::Apis::ComputeBeta::Duration]
        attr_accessor :interval
      
        # Maximum percentage of hosts in the load balancing pool for the backend service
        # that can be ejected. Defaults to 10%.
        # Corresponds to the JSON property `maxEjectionPercent`
        # @return [Fixnum]
        attr_accessor :max_ejection_percent
      
        # The number of hosts in a cluster that must have enough request volume to
        # detect success rate outliers. If the number of hosts is less than this setting,
        # outlier detection via success rate statistics is not performed for any host
        # in the cluster. Defaults to 5.
        # Corresponds to the JSON property `successRateMinimumHosts`
        # @return [Fixnum]
        attr_accessor :success_rate_minimum_hosts
      
        # The minimum number of total requests that must be collected in one interval (
        # as defined by the interval duration above) to include this host in success
        # rate based outlier detection. If the volume is lower than this setting,
        # outlier detection via success rate statistics is not performed for that host.
        # Defaults to 100.
        # Corresponds to the JSON property `successRateRequestVolume`
        # @return [Fixnum]
        attr_accessor :success_rate_request_volume
      
        # This factor is used to determine the ejection threshold for success rate
        # outlier ejection. The ejection threshold is the difference between the mean
        # success rate, and the product of this factor and the standard deviation of the
        # mean success rate: mean - (stdev * success_rate_stdev_factor). This factor is
        # divided by a thousand to get a double. That is, if the desired factor is 1.9,
        # the runtime value should be 1900. Defaults to 1900.
        # Corresponds to the JSON property `successRateStdevFactor`
        # @return [Fixnum]
        attr_accessor :success_rate_stdev_factor
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @base_ejection_time = args[:base_ejection_time] if args.key?(:base_ejection_time)
          @consecutive_errors = args[:consecutive_errors] if args.key?(:consecutive_errors)
          @consecutive_gateway_failure = args[:consecutive_gateway_failure] if args.key?(:consecutive_gateway_failure)
          @enforcing_consecutive_errors = args[:enforcing_consecutive_errors] if args.key?(:enforcing_consecutive_errors)
          @enforcing_consecutive_gateway_failure = args[:enforcing_consecutive_gateway_failure] if args.key?(:enforcing_consecutive_gateway_failure)
          @enforcing_success_rate = args[:enforcing_success_rate] if args.key?(:enforcing_success_rate)
          @interval = args[:interval] if args.key?(:interval)
          @max_ejection_percent = args[:max_ejection_percent] if args.key?(:max_ejection_percent)
          @success_rate_minimum_hosts = args[:success_rate_minimum_hosts] if args.key?(:success_rate_minimum_hosts)
          @success_rate_request_volume = args[:success_rate_request_volume] if args.key?(:success_rate_request_volume)
          @success_rate_stdev_factor = args[:success_rate_stdev_factor] if args.key?(:success_rate_stdev_factor)
        end
      end
      
      # Next free: 7
      class PacketIntervals
        include Google::Apis::Core::Hashable
      
        # Average observed inter-packet interval in milliseconds.
        # Corresponds to the JSON property `avgMs`
        # @return [Fixnum]
        attr_accessor :avg_ms
      
        # From how long ago in the past these intervals were observed.
        # Corresponds to the JSON property `duration`
        # @return [String]
        attr_accessor :duration
      
        # Maximum observed inter-packet interval in milliseconds.
        # Corresponds to the JSON property `maxMs`
        # @return [Fixnum]
        attr_accessor :max_ms
      
        # Minimum observed inter-packet interval in milliseconds.
        # Corresponds to the JSON property `minMs`
        # @return [Fixnum]
        attr_accessor :min_ms
      
        # Number of inter-packet intervals from which these statistics were derived.
        # Corresponds to the JSON property `numIntervals`
        # @return [Fixnum]
        attr_accessor :num_intervals
      
        # The type of packets for which inter-packet intervals were computed.
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @avg_ms = args[:avg_ms] if args.key?(:avg_ms)
          @duration = args[:duration] if args.key?(:duration)
          @max_ms = args[:max_ms] if args.key?(:max_ms)
          @min_ms = args[:min_ms] if args.key?(:min_ms)
          @num_intervals = args[:num_intervals] if args.key?(:num_intervals)
          @type = args[:type] if args.key?(:type)
        end
      end
      
      # A matcher for the path portion of the URL. The BackendService from the longest-
      # matched rule will serve the URL. If no rule was matched, the default service
      # will be used.
      class PathMatcher
        include Google::Apis::Core::Hashable
      
        # defaultRouteAction takes effect when none of the  pathRules or routeRules
        # match. The load balancer performs advanced routing actions like URL rewrites,
        # header transformations, etc. prior to forwarding the request to the selected
        # backend. If defaultRouteAction specifies any weightedBackendServices,
        # defaultService must not be set. Conversely if defaultService is set,
        # defaultRouteAction cannot contain any  weightedBackendServices.
        # Only one of defaultRouteAction or defaultUrlRedirect must be set.
        # Corresponds to the JSON property `defaultRouteAction`
        # @return [Google::Apis::ComputeBeta::HttpRouteAction]
        attr_accessor :default_route_action
      
        # The full or partial URL to the BackendService resource. This will be used if
        # none of the pathRules or routeRules defined by this PathMatcher are matched.
        # For example, the following are all valid URLs to a BackendService resource:
        # - https://www.googleapis.com/compute/v1/projects/project/global/
        # backendServices/backendService
        # - compute/v1/projects/project/global/backendServices/backendService
        # - global/backendServices/backendService  If defaultRouteAction is additionally
        # specified, advanced routing actions like URL Rewrites, etc. take effect prior
        # to sending the request to the backend. However, if defaultService is specified,
        # defaultRouteAction cannot contain any weightedBackendServices. Conversely, if
        # defaultRouteAction specifies any weightedBackendServices, defaultService must
        # not be specified.
        # Only one of defaultService, defaultUrlRedirect  or defaultRouteAction.
        # weightedBackendService must be set.
        # Authorization requires one or more of the following Google IAM permissions on
        # the specified resource default_service:
        # - compute.backendBuckets.use
        # - compute.backendServices.use
        # Corresponds to the JSON property `defaultService`
        # @return [String]
        attr_accessor :default_service
      
        # Specifies settings for an HTTP redirect.
        # Corresponds to the JSON property `defaultUrlRedirect`
        # @return [Google::Apis::ComputeBeta::HttpRedirectAction]
        attr_accessor :default_url_redirect
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # The request and response header transformations that take effect before the
        # request is passed along to the selected backendService.
        # Corresponds to the JSON property `headerAction`
        # @return [Google::Apis::ComputeBeta::HttpHeaderAction]
        attr_accessor :header_action
      
        # The name to which this PathMatcher is referred by the HostRule.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The list of path rules. Use this list instead of routeRules when routing based
        # on simple path matching is all that's required. The order by which path rules
        # are specified does not matter. Matches are always done on the longest-path-
        # first basis.
        # For example: a pathRule with a path /a/b/c/* will match before /a/b/*
        # irrespective of the order in which those paths appear in this list.
        # Within a given pathMatcher, only one of pathRules or routeRules must be set.
        # Corresponds to the JSON property `pathRules`
        # @return [Array<Google::Apis::ComputeBeta::PathRule>]
        attr_accessor :path_rules
      
        # The list of ordered HTTP route rules. Use this list instead of pathRules when
        # advanced route matching and routing actions are desired. The order of
        # specifying routeRules matters: the first rule that matches will cause its
        # specified routing action to take effect.
        # Within a given pathMatcher, only one of pathRules or routeRules must be set.
        # routeRules are not supported in UrlMaps intended for External Load balancers.
        # Corresponds to the JSON property `routeRules`
        # @return [Array<Google::Apis::ComputeBeta::HttpRouteRule>]
        attr_accessor :route_rules
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @default_route_action = args[:default_route_action] if args.key?(:default_route_action)
          @default_service = args[:default_service] if args.key?(:default_service)
          @default_url_redirect = args[:default_url_redirect] if args.key?(:default_url_redirect)
          @description = args[:description] if args.key?(:description)
          @header_action = args[:header_action] if args.key?(:header_action)
          @name = args[:name] if args.key?(:name)
          @path_rules = args[:path_rules] if args.key?(:path_rules)
          @route_rules = args[:route_rules] if args.key?(:route_rules)
        end
      end
      
      # A path-matching rule for a URL. If matched, will use the specified
      # BackendService to handle the traffic arriving at this URL.
      class PathRule
        include Google::Apis::Core::Hashable
      
        # The list of path patterns to match. Each must start with / and the only place
        # a * is allowed is at the end following a /. The string fed to the path matcher
        # does not include any text after the first ? or #, and those chars are not
        # allowed here.
        # Corresponds to the JSON property `paths`
        # @return [Array<String>]
        attr_accessor :paths
      
        # In response to a matching path, the load balancer performs advanced routing
        # actions like URL rewrites, header transformations, etc. prior to forwarding
        # the request to the selected backend. If routeAction specifies any
        # weightedBackendServices, service must not be set. Conversely if service is set,
        # routeAction cannot contain any  weightedBackendServices.
        # Only one of routeAction or urlRedirect must be set.
        # Corresponds to the JSON property `routeAction`
        # @return [Google::Apis::ComputeBeta::HttpRouteAction]
        attr_accessor :route_action
      
        # The full or partial URL of the backend service resource to which traffic is
        # directed if this rule is matched. If routeAction is additionally specified,
        # advanced routing actions like URL Rewrites, etc. take effect prior to sending
        # the request to the backend. However, if service is specified, routeAction
        # cannot contain any weightedBackendService s. Conversely, if routeAction
        # specifies any  weightedBackendServices, service must not be specified.
        # Only one of urlRedirect, service or routeAction.weightedBackendService must be
        # set.
        # Corresponds to the JSON property `service`
        # @return [String]
        attr_accessor :service
      
        # Specifies settings for an HTTP redirect.
        # Corresponds to the JSON property `urlRedirect`
        # @return [Google::Apis::ComputeBeta::HttpRedirectAction]
        attr_accessor :url_redirect
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @paths = args[:paths] if args.key?(:paths)
          @route_action = args[:route_action] if args.key?(:route_action)
          @service = args[:service] if args.key?(:service)
          @url_redirect = args[:url_redirect] if args.key?(:url_redirect)
        end
      end
      
      # 
      class PerInstanceConfig
        include Google::Apis::Core::Hashable
      
        # Fingerprint of this per-instance config. This field may be used in optimistic
        # locking. It will be ignored when inserting a per-instance config. An up-to-
        # date fingerprint must be provided in order to update an existing per-instance
        # config or the field needs to be unset.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # The name of the per-instance config and the corresponding instance. Serves as
        # a merge key during UpdatePerInstanceConfigs operation, i.e. if per-instance
        # config with the same name exists then it will be updated, otherwise a new one
        # will be created for the VM instance with the same name. An attempt to create a
        # per-instance config for a VM instance that either doesn't exist or is not part
        # of the group will result in a failure.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @name = args[:name] if args.key?(:name)
        end
      end
      
      # Defines an Identity and Access Management (IAM) policy. It is used to specify
      # access control policies for Cloud Platform resources.
      # A `Policy` consists of a list of `bindings`. A `binding` binds a list of `
      # members` to a `role`, where the members can be user accounts, Google groups,
      # Google domains, and service accounts. A `role` is a named list of permissions
      # defined by IAM.
      # **JSON Example**
      # ` "bindings": [ ` "role": "roles/owner", "members": [ "user:mike@example.com",
      # "group:admins@example.com", "domain:google.com", "serviceAccount:my-other-app@
      # appspot.gserviceaccount.com" ] `, ` "role": "roles/viewer", "members": ["user:
      # sean@example.com"] ` ] `
      # **YAML Example**
      # bindings: - members: - user:mike@example.com - group:admins@example.com -
      # domain:google.com - serviceAccount:my-other-app@appspot.gserviceaccount.com
      # role: roles/owner - members: - user:sean@example.com role: roles/viewer
      # For a description of IAM and its features, see the [IAM developer's guide](
      # https://cloud.google.com/iam/docs).
      class Policy
        include Google::Apis::Core::Hashable
      
        # Specifies cloud audit logging configuration for this policy.
        # Corresponds to the JSON property `auditConfigs`
        # @return [Array<Google::Apis::ComputeBeta::AuditConfig>]
        attr_accessor :audit_configs
      
        # Associates a list of `members` to a `role`. `bindings` with no members will
        # result in an error.
        # Corresponds to the JSON property `bindings`
        # @return [Array<Google::Apis::ComputeBeta::Binding>]
        attr_accessor :bindings
      
        # `etag` is used for optimistic concurrency control as a way to help prevent
        # simultaneous updates of a policy from overwriting each other. It is strongly
        # suggested that systems make use of the `etag` in the read-modify-write cycle
        # to perform policy updates in order to avoid race conditions: An `etag` is
        # returned in the response to `getIamPolicy`, and systems are expected to put
        # that etag in the request to `setIamPolicy` to ensure that their change will be
        # applied to the same version of the policy.
        # If no `etag` is provided in the call to `setIamPolicy`, then the existing
        # policy is overwritten.
        # Corresponds to the JSON property `etag`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :etag
      
        # 
        # Corresponds to the JSON property `iamOwned`
        # @return [Boolean]
        attr_accessor :iam_owned
        alias_method :iam_owned?, :iam_owned
      
        # If more than one rule is specified, the rules are applied in the following
        # manner: - All matching LOG rules are always applied. - If any DENY/
        # DENY_WITH_LOG rule matches, permission is denied. Logging will be applied if
        # one or more matching rule requires logging. - Otherwise, if any ALLOW/
        # ALLOW_WITH_LOG rule matches, permission is granted. Logging will be applied if
        # one or more matching rule requires logging. - Otherwise, if no rule applies,
        # permission is denied.
        # Corresponds to the JSON property `rules`
        # @return [Array<Google::Apis::ComputeBeta::Rule>]
        attr_accessor :rules
      
        # Specifies the format of the policy.
        # Valid values are 0, 1, and 3. Requests specifying an invalid value will be
        # rejected.
        # Policies with any conditional bindings must specify version 3. Policies
        # without any conditional bindings may specify any valid value or leave the
        # field unset.
        # Corresponds to the JSON property `version`
        # @return [Fixnum]
        attr_accessor :version
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @audit_configs = args[:audit_configs] if args.key?(:audit_configs)
          @bindings = args[:bindings] if args.key?(:bindings)
          @etag = args[:etag] if args.key?(:etag)
          @iam_owned = args[:iam_owned] if args.key?(:iam_owned)
          @rules = args[:rules] if args.key?(:rules)
          @version = args[:version] if args.key?(:version)
        end
      end
      
      # 
      class PreconfiguredWafSet
        include Google::Apis::Core::Hashable
      
        # List of entities that are currently supported for WAF rules.
        # Corresponds to the JSON property `expressionSets`
        # @return [Array<Google::Apis::ComputeBeta::WafExpressionSet>]
        attr_accessor :expression_sets
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @expression_sets = args[:expression_sets] if args.key?(:expression_sets)
        end
      end
      
      # Represents a Project resource.
      # A project is used to organize resources in a Google Cloud Platform environment.
      # For more information, read about the  Resource Hierarchy. (== resource_for v1.
      # projects ==) (== resource_for beta.projects ==)
      class Project
        include Google::Apis::Core::Hashable
      
        # A metadata key/value entry.
        # Corresponds to the JSON property `commonInstanceMetadata`
        # @return [Google::Apis::ComputeBeta::Metadata]
        attr_accessor :common_instance_metadata
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # This signifies the default network tier used for configuring resources of the
        # project and can only take the following values: PREMIUM, STANDARD. Initially
        # the default network tier is PREMIUM.
        # Corresponds to the JSON property `defaultNetworkTier`
        # @return [String]
        attr_accessor :default_network_tier
      
        # [Output Only] Default service account used by VMs running in this project.
        # Corresponds to the JSON property `defaultServiceAccount`
        # @return [String]
        attr_accessor :default_service_account
      
        # An optional textual description of the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Restricted features enabled for use on this project.
        # Corresponds to the JSON property `enabledFeatures`
        # @return [Array<String>]
        attr_accessor :enabled_features
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server. This is not the project ID, and is just a unique ID
        # used by Compute Engine to identify resources.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Type of the resource. Always compute#project for projects.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # The project ID. For example: my-example-project. Use the project ID to make
        # requests to Compute Engine.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # [Output Only] Quotas assigned to this project.
        # Corresponds to the JSON property `quotas`
        # @return [Array<Google::Apis::ComputeBeta::Quota>]
        attr_accessor :quotas
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # The location in Cloud Storage and naming method of the daily usage report.
        # Contains bucket_name and report_name prefix.
        # Corresponds to the JSON property `usageExportLocation`
        # @return [Google::Apis::ComputeBeta::UsageExportLocation]
        attr_accessor :usage_export_location
      
        # [Output Only] The role this project has in a shared VPC configuration.
        # Currently only HOST projects are differentiated.
        # Corresponds to the JSON property `xpnProjectStatus`
        # @return [String]
        attr_accessor :xpn_project_status
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @common_instance_metadata = args[:common_instance_metadata] if args.key?(:common_instance_metadata)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @default_network_tier = args[:default_network_tier] if args.key?(:default_network_tier)
          @default_service_account = args[:default_service_account] if args.key?(:default_service_account)
          @description = args[:description] if args.key?(:description)
          @enabled_features = args[:enabled_features] if args.key?(:enabled_features)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @quotas = args[:quotas] if args.key?(:quotas)
          @self_link = args[:self_link] if args.key?(:self_link)
          @usage_export_location = args[:usage_export_location] if args.key?(:usage_export_location)
          @xpn_project_status = args[:xpn_project_status] if args.key?(:xpn_project_status)
        end
      end
      
      # 
      class ProjectsDisableXpnResourceRequest
        include Google::Apis::Core::Hashable
      
        # Service resource (a.k.a service project) ID.
        # Corresponds to the JSON property `xpnResource`
        # @return [Google::Apis::ComputeBeta::XpnResourceId]
        attr_accessor :xpn_resource
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @xpn_resource = args[:xpn_resource] if args.key?(:xpn_resource)
        end
      end
      
      # 
      class ProjectsEnableXpnResourceRequest
        include Google::Apis::Core::Hashable
      
        # Service resource (a.k.a service project) ID.
        # Corresponds to the JSON property `xpnResource`
        # @return [Google::Apis::ComputeBeta::XpnResourceId]
        attr_accessor :xpn_resource
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @xpn_resource = args[:xpn_resource] if args.key?(:xpn_resource)
        end
      end
      
      # 
      class ProjectsGetXpnResources
        include Google::Apis::Core::Hashable
      
        # [Output Only] Type of resource. Always compute#projectsGetXpnResources for
        # lists of service resources (a.k.a service projects)
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Service resources (a.k.a service projects) attached to this project as their
        # shared VPC host.
        # Corresponds to the JSON property `resources`
        # @return [Array<Google::Apis::ComputeBeta::XpnResourceId>]
        attr_accessor :resources
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @resources = args[:resources] if args.key?(:resources)
        end
      end
      
      # 
      class ProjectsListXpnHostsRequest
        include Google::Apis::Core::Hashable
      
        # Optional organization ID managed by Cloud Resource Manager, for which to list
        # shared VPC host projects. If not specified, the organization will be inferred
        # from the project.
        # Corresponds to the JSON property `organization`
        # @return [String]
        attr_accessor :organization
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @organization = args[:organization] if args.key?(:organization)
        end
      end
      
      # 
      class ProjectsSetDefaultNetworkTierRequest
        include Google::Apis::Core::Hashable
      
        # Default network tier to be set.
        # Corresponds to the JSON property `networkTier`
        # @return [String]
        attr_accessor :network_tier
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @network_tier = args[:network_tier] if args.key?(:network_tier)
        end
      end
      
      # A quotas entry.
      class Quota
        include Google::Apis::Core::Hashable
      
        # [Output Only] Quota limit for this metric.
        # Corresponds to the JSON property `limit`
        # @return [Float]
        attr_accessor :limit
      
        # [Output Only] Name of the quota metric.
        # Corresponds to the JSON property `metric`
        # @return [String]
        attr_accessor :metric
      
        # [Output Only] Owning resource. This is the resource on which this quota is
        # applied.
        # Corresponds to the JSON property `owner`
        # @return [String]
        attr_accessor :owner
      
        # [Output Only] Current usage of this metric.
        # Corresponds to the JSON property `usage`
        # @return [Float]
        attr_accessor :usage
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @limit = args[:limit] if args.key?(:limit)
          @metric = args[:metric] if args.key?(:metric)
          @owner = args[:owner] if args.key?(:owner)
          @usage = args[:usage] if args.key?(:usage)
        end
      end
      
      # Represents a reference to a resource.
      class Reference
        include Google::Apis::Core::Hashable
      
        # [Output Only] Type of the resource. Always compute#reference for references.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # A description of the reference type with no implied semantics. Possible values
        # include:
        # - MEMBER_OF
        # Corresponds to the JSON property `referenceType`
        # @return [String]
        attr_accessor :reference_type
      
        # URL of the resource which refers to the target.
        # Corresponds to the JSON property `referrer`
        # @return [String]
        attr_accessor :referrer
      
        # URL of the resource to which this reference points.
        # Corresponds to the JSON property `target`
        # @return [String]
        attr_accessor :target
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @kind = args[:kind] if args.key?(:kind)
          @reference_type = args[:reference_type] if args.key?(:reference_type)
          @referrer = args[:referrer] if args.key?(:referrer)
          @target = args[:target] if args.key?(:target)
        end
      end
      
      # Represents a Region resource.
      # A region is a geographical area where a resource is located. For more
      # information, read Regions and Zones. (== resource_for beta.regions ==) (==
      # resource_for v1.regions ==)
      class Region
        include Google::Apis::Core::Hashable
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # Deprecation status for a public resource.
        # Corresponds to the JSON property `deprecated`
        # @return [Google::Apis::ComputeBeta::DeprecationStatus]
        attr_accessor :deprecated
      
        # [Output Only] Textual description of the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Type of the resource. Always compute#region for regions.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] Name of the resource.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # [Output Only] Quotas assigned to this region.
        # Corresponds to the JSON property `quotas`
        # @return [Array<Google::Apis::ComputeBeta::Quota>]
        attr_accessor :quotas
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Status of the region, either UP or DOWN.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        # [Output Only] A list of zones available in this region, in the form of
        # resource URLs.
        # Corresponds to the JSON property `zones`
        # @return [Array<String>]
        attr_accessor :zones
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @deprecated = args[:deprecated] if args.key?(:deprecated)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @quotas = args[:quotas] if args.key?(:quotas)
          @self_link = args[:self_link] if args.key?(:self_link)
          @status = args[:status] if args.key?(:status)
          @zones = args[:zones] if args.key?(:zones)
        end
      end
      
      # Contains a list of autoscalers.
      class RegionAutoscalerList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Autoscaler resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::Autoscaler>]
        attr_accessor :items
      
        # Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::RegionAutoscalerList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::RegionAutoscalerList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class RegionCommitmentsUpdateReservationsRequest
        include Google::Apis::Core::Hashable
      
        # List of two reservations to transfer GPUs and local SSD between.
        # Corresponds to the JSON property `reservations`
        # @return [Array<Google::Apis::ComputeBeta::Reservation>]
        attr_accessor :reservations
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @reservations = args[:reservations] if args.key?(:reservations)
        end
      end
      
      # 
      class RegionDiskTypeList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of DiskType resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::DiskType>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#regionDiskTypeList for region
        # disk types.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::RegionDiskTypeList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::RegionDiskTypeList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class RegionDisksAddResourcePoliciesRequest
        include Google::Apis::Core::Hashable
      
        # Resource policies to be added to this disk.
        # Corresponds to the JSON property `resourcePolicies`
        # @return [Array<String>]
        attr_accessor :resource_policies
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @resource_policies = args[:resource_policies] if args.key?(:resource_policies)
        end
      end
      
      # 
      class RegionDisksRemoveResourcePoliciesRequest
        include Google::Apis::Core::Hashable
      
        # Resource policies to be removed from this disk.
        # Corresponds to the JSON property `resourcePolicies`
        # @return [Array<String>]
        attr_accessor :resource_policies
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @resource_policies = args[:resource_policies] if args.key?(:resource_policies)
        end
      end
      
      # 
      class RegionDisksResizeRequest
        include Google::Apis::Core::Hashable
      
        # The new size of the regional persistent disk, which is specified in GB.
        # Corresponds to the JSON property `sizeGb`
        # @return [Fixnum]
        attr_accessor :size_gb
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @size_gb = args[:size_gb] if args.key?(:size_gb)
        end
      end
      
      # Contains a list of InstanceGroup resources.
      class RegionInstanceGroupList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InstanceGroup resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::InstanceGroup>]
        attr_accessor :items
      
        # The resource type.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::RegionInstanceGroupList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::RegionInstanceGroupList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of managed instance groups.
      class RegionInstanceGroupManagerList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InstanceGroupManager resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::InstanceGroupManager>]
        attr_accessor :items
      
        # [Output Only] The resource type, which is always compute#
        # instanceGroupManagerList for a list of managed instance groups that exist in
        # th regional scope.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::RegionInstanceGroupManagerList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::RegionInstanceGroupManagerList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class RegionInstanceGroupManagersAbandonInstancesRequest
        include Google::Apis::Core::Hashable
      
        # The URLs of one or more instances to abandon. This can be a full URL or a
        # partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
        # Corresponds to the JSON property `instances`
        # @return [Array<String>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # InstanceGroupManagers.applyUpdatesToInstances
      class RegionInstanceGroupManagersApplyUpdatesRequest
        include Google::Apis::Core::Hashable
      
        # The list of URLs of one or more instances for which you want to apply updates.
        # Each URL can be a full URL or a partial URL, such as zones/[ZONE]/instances/[
        # INSTANCE_NAME].
        # Corresponds to the JSON property `instances`
        # @return [Array<String>]
        attr_accessor :instances
      
        # The minimal action that you want to perform on each instance during the update:
        # 
        # - REPLACE: At minimum, delete the instance and create it again.
        # - RESTART: Stop the instance and start it again.
        # - REFRESH: Do not stop the instance.
        # - NONE: Do not disrupt the instance at all.  By default, the minimum action is
        # NONE. If your update requires a more disruptive action than you set with this
        # flag, the necessary action is performed to execute the update.
        # Corresponds to the JSON property `minimalAction`
        # @return [String]
        attr_accessor :minimal_action
      
        # The most disruptive action that you want to perform on each instance during
        # the update:
        # - REPLACE: Delete the instance and create it again.
        # - RESTART: Stop the instance and start it again.
        # - REFRESH: Do not stop the instance.
        # - NONE: Do not disrupt the instance at all.  By default, the most disruptive
        # allowed action is REPLACE. If your update requires a more disruptive action
        # than you set with this flag, the update request will fail.
        # Corresponds to the JSON property `mostDisruptiveAllowedAction`
        # @return [String]
        attr_accessor :most_disruptive_allowed_action
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
          @minimal_action = args[:minimal_action] if args.key?(:minimal_action)
          @most_disruptive_allowed_action = args[:most_disruptive_allowed_action] if args.key?(:most_disruptive_allowed_action)
        end
      end
      
      # RegionInstanceGroupManagers.createInstances
      class RegionInstanceGroupManagersCreateInstancesRequest
        include Google::Apis::Core::Hashable
      
        # [Required] List of specifications of per-instance configs.
        # Corresponds to the JSON property `instances`
        # @return [Array<Google::Apis::ComputeBeta::PerInstanceConfig>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # 
      class RegionInstanceGroupManagersDeleteInstancesRequest
        include Google::Apis::Core::Hashable
      
        # The URLs of one or more instances to delete. This can be a full URL or a
        # partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
        # Corresponds to the JSON property `instances`
        # @return [Array<String>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # 
      class RegionInstanceGroupManagersListInstancesResponse
        include Google::Apis::Core::Hashable
      
        # A list of managed instances.
        # Corresponds to the JSON property `managedInstances`
        # @return [Array<Google::Apis::ComputeBeta::ManagedInstance>]
        attr_accessor :managed_instances
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @managed_instances = args[:managed_instances] if args.key?(:managed_instances)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
        end
      end
      
      # 
      class RegionInstanceGroupManagersRecreateRequest
        include Google::Apis::Core::Hashable
      
        # The URLs of one or more instances to recreate. This can be a full URL or a
        # partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
        # Corresponds to the JSON property `instances`
        # @return [Array<String>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # 
      class RegionInstanceGroupManagersSetAutoHealingRequest
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `autoHealingPolicies`
        # @return [Array<Google::Apis::ComputeBeta::InstanceGroupManagerAutoHealingPolicy>]
        attr_accessor :auto_healing_policies
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @auto_healing_policies = args[:auto_healing_policies] if args.key?(:auto_healing_policies)
        end
      end
      
      # 
      class RegionInstanceGroupManagersSetTargetPoolsRequest
        include Google::Apis::Core::Hashable
      
        # Fingerprint of the target pools information, which is a hash of the contents.
        # This field is used for optimistic locking when you update the target pool
        # entries. This field is optional.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # The URL of all TargetPool resources to which instances in the instanceGroup
        # field are added. The target pools automatically apply to all of the instances
        # in the managed instance group.
        # Corresponds to the JSON property `targetPools`
        # @return [Array<String>]
        attr_accessor :target_pools
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @target_pools = args[:target_pools] if args.key?(:target_pools)
        end
      end
      
      # 
      class RegionInstanceGroupManagersSetTemplateRequest
        include Google::Apis::Core::Hashable
      
        # URL of the InstanceTemplate resource from which all new instances will be
        # created.
        # Corresponds to the JSON property `instanceTemplate`
        # @return [String]
        attr_accessor :instance_template
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_template = args[:instance_template] if args.key?(:instance_template)
        end
      end
      
      # 
      class RegionInstanceGroupsListInstances
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InstanceWithNamedPorts resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::InstanceWithNamedPorts>]
        attr_accessor :items
      
        # The resource type.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::RegionInstanceGroupsListInstances::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::RegionInstanceGroupsListInstances::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class RegionInstanceGroupsListInstancesRequest
        include Google::Apis::Core::Hashable
      
        # Instances in which state should be returned. Valid options are: 'ALL', '
        # RUNNING'. By default, it lists all instances.
        # Corresponds to the JSON property `instanceState`
        # @return [String]
        attr_accessor :instance_state
      
        # Name of port user is interested in. It is optional. If it is set, only
        # information about this ports will be returned. If it is not set, all the named
        # ports will be returned. Always lists all instances.
        # Corresponds to the JSON property `portName`
        # @return [String]
        attr_accessor :port_name
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_state = args[:instance_state] if args.key?(:instance_state)
          @port_name = args[:port_name] if args.key?(:port_name)
        end
      end
      
      # 
      class RegionInstanceGroupsSetNamedPortsRequest
        include Google::Apis::Core::Hashable
      
        # The fingerprint of the named ports information for this instance group. Use
        # this optional property to prevent conflicts when multiple users change the
        # named ports settings concurrently. Obtain the fingerprint with the
        # instanceGroups.get method. Then, include the fingerprint in your request to
        # ensure that you do not overwrite changes that were applied from another
        # concurrent request.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # The list of named ports to set for this instance group.
        # Corresponds to the JSON property `namedPorts`
        # @return [Array<Google::Apis::ComputeBeta::NamedPort>]
        attr_accessor :named_ports
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @named_ports = args[:named_ports] if args.key?(:named_ports)
        end
      end
      
      # Contains a list of region resources.
      class RegionList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Region resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::Region>]
        attr_accessor :items
      
        # [Output Only] Type of resource. Always compute#regionList for lists of regions.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::RegionList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::RegionList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class RegionSetLabelsRequest
        include Google::Apis::Core::Hashable
      
        # The fingerprint of the previous set of labels for this resource, used to
        # detect conflicts. The fingerprint is initially generated by Compute Engine and
        # changes after every request to modify or update labels. You must always
        # provide an up-to-date fingerprint hash in order to update or change labels.
        # Make a get() request to the resource to get the latest fingerprint.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # The labels to set for this resource.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
        end
      end
      
      # 
      class RegionSetPolicyRequest
        include Google::Apis::Core::Hashable
      
        # Flatten Policy to create a backwacd compatible wire-format. Deprecated. Use '
        # policy' to specify bindings.
        # Corresponds to the JSON property `bindings`
        # @return [Array<Google::Apis::ComputeBeta::Binding>]
        attr_accessor :bindings
      
        # Flatten Policy to create a backward compatible wire-format. Deprecated. Use '
        # policy' to specify the etag.
        # Corresponds to the JSON property `etag`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :etag
      
        # Defines an Identity and Access Management (IAM) policy. It is used to specify
        # access control policies for Cloud Platform resources.
        # A `Policy` consists of a list of `bindings`. A `binding` binds a list of `
        # members` to a `role`, where the members can be user accounts, Google groups,
        # Google domains, and service accounts. A `role` is a named list of permissions
        # defined by IAM.
        # **JSON Example**
        # ` "bindings": [ ` "role": "roles/owner", "members": [ "user:mike@example.com",
        # "group:admins@example.com", "domain:google.com", "serviceAccount:my-other-app@
        # appspot.gserviceaccount.com" ] `, ` "role": "roles/viewer", "members": ["user:
        # sean@example.com"] ` ] `
        # **YAML Example**
        # bindings: - members: - user:mike@example.com - group:admins@example.com -
        # domain:google.com - serviceAccount:my-other-app@appspot.gserviceaccount.com
        # role: roles/owner - members: - user:sean@example.com role: roles/viewer
        # For a description of IAM and its features, see the [IAM developer's guide](
        # https://cloud.google.com/iam/docs).
        # Corresponds to the JSON property `policy`
        # @return [Google::Apis::ComputeBeta::Policy]
        attr_accessor :policy
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @bindings = args[:bindings] if args.key?(:bindings)
          @etag = args[:etag] if args.key?(:etag)
          @policy = args[:policy] if args.key?(:policy)
        end
      end
      
      # 
      class RegionTargetHttpsProxiesSetSslCertificatesRequest
        include Google::Apis::Core::Hashable
      
        # New set of SslCertificate resources to associate with this TargetHttpsProxy
        # resource. Currently exactly one SslCertificate resource must be specified.
        # Corresponds to the JSON property `sslCertificates`
        # @return [Array<String>]
        attr_accessor :ssl_certificates
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @ssl_certificates = args[:ssl_certificates] if args.key?(:ssl_certificates)
        end
      end
      
      # 
      class RegionUrlMapsValidateRequest
        include Google::Apis::Core::Hashable
      
        # Represents a URL Map resource.
        # A URL map resource is a component of certain types of load balancers. This
        # resource defines mappings from host names and URL paths to either a backend
        # service or a backend bucket.
        # To use this resource, the backend service must have a loadBalancingScheme of
        # either EXTERNAL, INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED For more
        # information, read URL Map Concepts.
        # Corresponds to the JSON property `resource`
        # @return [Google::Apis::ComputeBeta::UrlMap]
        attr_accessor :resource
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @resource = args[:resource] if args.key?(:resource)
        end
      end
      
      # A policy that specifies how requests intended for the route's backends are
      # shadowed to a separate mirrored backend service. Loadbalancer does not wait
      # for responses from the shadow service. Prior to sending traffic to the shadow
      # service, the host / authority header is suffixed with -shadow.
      class RequestMirrorPolicy
        include Google::Apis::Core::Hashable
      
        # The full or partial URL to the BackendService resource being mirrored to.
        # Corresponds to the JSON property `backendService`
        # @return [String]
        attr_accessor :backend_service
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @backend_service = args[:backend_service] if args.key?(:backend_service)
        end
      end
      
      # Represents a reservation resource. A reservation ensures that capacity is held
      # in a specific zone even if the reserved VMs are not running. For more
      # information, read  Reserving zonal resources. (== resource_for beta.
      # reservations ==) (== resource_for v1.reservations ==)
      class Reservation
        include Google::Apis::Core::Hashable
      
        # [OutputOnly] Full or partial URL to a parent commitment. This field displays
        # for reservations that are tied to a commitment.
        # Corresponds to the JSON property `commitment`
        # @return [String]
        attr_accessor :commitment
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Type of the resource. Always compute#reservations for
        # reservations.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # The name of the resource, provided by the client when initially creating the
        # resource. The resource name must be 1-63 characters long, and comply with
        # RFC1035. Specifically, the name must be 1-63 characters long and match the
        # regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must be a
        # dash, lowercase letter, or digit, except the last character, which cannot be a
        # dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # [Output Only] Server-defined fully-qualified URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # This reservation type allows to pre allocate specific instance configuration.
        # Corresponds to the JSON property `specificReservation`
        # @return [Google::Apis::ComputeBeta::AllocationSpecificSkuReservation]
        attr_accessor :specific_reservation
      
        # Indicates whether the reservation can be consumed by VMs with affinity for "
        # any" reservation. If the field is set, then only VMs that target the
        # reservation by name can consume from this reservation.
        # Corresponds to the JSON property `specificReservationRequired`
        # @return [Boolean]
        attr_accessor :specific_reservation_required
        alias_method :specific_reservation_required?, :specific_reservation_required
      
        # [Output Only] The status of the reservation.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        # Zone in which the reservation resides. A zone must be provided if the
        # reservation is created within a commitment.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @commitment = args[:commitment] if args.key?(:commitment)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @self_link = args[:self_link] if args.key?(:self_link)
          @specific_reservation = args[:specific_reservation] if args.key?(:specific_reservation)
          @specific_reservation_required = args[:specific_reservation_required] if args.key?(:specific_reservation_required)
          @status = args[:status] if args.key?(:status)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # Specifies the reservations that this instance can consume from.
      class ReservationAffinity
        include Google::Apis::Core::Hashable
      
        # Specifies the type of reservation from which this instance can consume
        # resources: ANY_RESERVATION (default), SPECIFIC_RESERVATION, or NO_RESERVATION.
        # See  Consuming reserved instances for examples.
        # Corresponds to the JSON property `consumeReservationType`
        # @return [String]
        attr_accessor :consume_reservation_type
      
        # Corresponds to the label key of a reservation resource. To target a
        # SPECIFIC_RESERVATION by name, specify googleapis.com/reservation-name as the
        # key and specify the name of your reservation as its value.
        # Corresponds to the JSON property `key`
        # @return [String]
        attr_accessor :key
      
        # Corresponds to the label values of a reservation resource.
        # Corresponds to the JSON property `values`
        # @return [Array<String>]
        attr_accessor :values
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @consume_reservation_type = args[:consume_reservation_type] if args.key?(:consume_reservation_type)
          @key = args[:key] if args.key?(:key)
          @values = args[:values] if args.key?(:values)
        end
      end
      
      # Contains a list of reservations.
      class ReservationAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Allocation resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::ReservationsScopedList>]
        attr_accessor :items
      
        # Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::ReservationAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::ReservationAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class ReservationList
        include Google::Apis::Core::Hashable
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # [Output Only] A list of Allocation resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::Reservation>]
        attr_accessor :items
      
        # [Output Only] Type of resource.Always compute#reservationsList for listsof
        # reservations
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::ReservationList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::ReservationList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class ReservationsResizeRequest
        include Google::Apis::Core::Hashable
      
        # Number of allocated resources can be resized with minimum = 1 and maximum =
        # 1000.
        # Corresponds to the JSON property `specificSkuCount`
        # @return [Fixnum]
        attr_accessor :specific_sku_count
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @specific_sku_count = args[:specific_sku_count] if args.key?(:specific_sku_count)
        end
      end
      
      # 
      class ReservationsScopedList
        include Google::Apis::Core::Hashable
      
        # A list of reservations contained in this scope.
        # Corresponds to the JSON property `reservations`
        # @return [Array<Google::Apis::ComputeBeta::Reservation>]
        attr_accessor :reservations
      
        # Informational warning which replaces the list of reservations when the list is
        # empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::ReservationsScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @reservations = args[:reservations] if args.key?(:reservations)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Informational warning which replaces the list of reservations when the list is
        # empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::ReservationsScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Commitment for a particular resource (a Commitment is composed of one or more
      # of these).
      class ResourceCommitment
        include Google::Apis::Core::Hashable
      
        # Name of the accelerator type resource. Applicable only when the type is
        # ACCELERATOR.
        # Corresponds to the JSON property `acceleratorType`
        # @return [String]
        attr_accessor :accelerator_type
      
        # The amount of the resource purchased (in a type-dependent unit, such as bytes).
        # For vCPUs, this can just be an integer. For memory, this must be provided in
        # MB. Memory must be a multiple of 256 MB, with up to 6.5GB of memory per every
        # vCPU.
        # Corresponds to the JSON property `amount`
        # @return [Fixnum]
        attr_accessor :amount
      
        # Type of resource for which this commitment applies. Possible values are VCPU
        # and MEMORY
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @accelerator_type = args[:accelerator_type] if args.key?(:accelerator_type)
          @amount = args[:amount] if args.key?(:amount)
          @type = args[:type] if args.key?(:type)
        end
      end
      
      # 
      class ResourceGroupReference
        include Google::Apis::Core::Hashable
      
        # A URI referencing one of the instance groups or network endpoint groups listed
        # in the backend service.
        # Corresponds to the JSON property `group`
        # @return [String]
        attr_accessor :group
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @group = args[:group] if args.key?(:group)
        end
      end
      
      # 
      class ResourcePoliciesScopedList
        include Google::Apis::Core::Hashable
      
        # A list of resourcePolicies contained in this scope.
        # Corresponds to the JSON property `resourcePolicies`
        # @return [Array<Google::Apis::ComputeBeta::ResourcePolicy>]
        attr_accessor :resource_policies
      
        # Informational warning which replaces the list of resourcePolicies when the
        # list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::ResourcePoliciesScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @resource_policies = args[:resource_policies] if args.key?(:resource_policies)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Informational warning which replaces the list of resourcePolicies when the
        # list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::ResourcePoliciesScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class ResourcePolicy
        include Google::Apis::Core::Hashable
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # 
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Type of the resource. Always compute#resource_policies for
        # resource policies.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # The name of the resource, provided by the client when initially creating the
        # resource. The resource name must be 1-63 characters long, and comply with
        # RFC1035. Specifically, the name must be 1-63 characters long and match the
        # regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must be a
        # dash, lowercase letter, or digit, except the last character, which cannot be a
        # dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # 
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # [Output Only] Server-defined fully-qualified URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # A snapshot schedule policy specifies when and how frequently snapshots are to
        # be created for the target disk. Also specifies how many and how long these
        # scheduled snapshots should be retained.
        # Corresponds to the JSON property `snapshotSchedulePolicy`
        # @return [Google::Apis::ComputeBeta::ResourcePolicySnapshotSchedulePolicy]
        attr_accessor :snapshot_schedule_policy
      
        # [Output Only] The status of resource policy creation.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @region = args[:region] if args.key?(:region)
          @self_link = args[:self_link] if args.key?(:self_link)
          @snapshot_schedule_policy = args[:snapshot_schedule_policy] if args.key?(:snapshot_schedule_policy)
          @status = args[:status] if args.key?(:status)
        end
      end
      
      # Contains a list of resourcePolicies.
      class ResourcePolicyAggregatedList
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `etag`
        # @return [String]
        attr_accessor :etag
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of ResourcePolicy resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::ResourcePoliciesScopedList>]
        attr_accessor :items
      
        # Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::ResourcePolicyAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @etag = args[:etag] if args.key?(:etag)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::ResourcePolicyAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Time window specified for daily operations.
      class ResourcePolicyDailyCycle
        include Google::Apis::Core::Hashable
      
        # Defines a schedule that runs every nth day of the month.
        # Corresponds to the JSON property `daysInCycle`
        # @return [Fixnum]
        attr_accessor :days_in_cycle
      
        # [Output only] A predetermined duration for the window, automatically chosen to
        # be the smallest possible in the given scenario.
        # Corresponds to the JSON property `duration`
        # @return [String]
        attr_accessor :duration
      
        # Start time of the window. This must be in UTC format that resolves to one of
        # 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:
        # 00 are valid.
        # Corresponds to the JSON property `startTime`
        # @return [String]
        attr_accessor :start_time
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @days_in_cycle = args[:days_in_cycle] if args.key?(:days_in_cycle)
          @duration = args[:duration] if args.key?(:duration)
          @start_time = args[:start_time] if args.key?(:start_time)
        end
      end
      
      # Time window specified for hourly operations.
      class ResourcePolicyHourlyCycle
        include Google::Apis::Core::Hashable
      
        # [Output only] Duration of the time window, automatically chosen to be smallest
        # possible in the given scenario.
        # Corresponds to the JSON property `duration`
        # @return [String]
        attr_accessor :duration
      
        # Allows to define schedule that runs every nth hour.
        # Corresponds to the JSON property `hoursInCycle`
        # @return [Fixnum]
        attr_accessor :hours_in_cycle
      
        # Time within the window to start the operations. It must be in format "HH:MM",
        # where HH : [00-23] and MM : [00-00] GMT.
        # Corresponds to the JSON property `startTime`
        # @return [String]
        attr_accessor :start_time
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @duration = args[:duration] if args.key?(:duration)
          @hours_in_cycle = args[:hours_in_cycle] if args.key?(:hours_in_cycle)
          @start_time = args[:start_time] if args.key?(:start_time)
        end
      end
      
      # 
      class ResourcePolicyList
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `etag`
        # @return [String]
        attr_accessor :etag
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # [Output Only] A list of ResourcePolicy resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::ResourcePolicy>]
        attr_accessor :items
      
        # [Output Only] Type of resource.Always compute#resourcePoliciesList for listsof
        # resourcePolicies
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::ResourcePolicyList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @etag = args[:etag] if args.key?(:etag)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::ResourcePolicyList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # A snapshot schedule policy specifies when and how frequently snapshots are to
      # be created for the target disk. Also specifies how many and how long these
      # scheduled snapshots should be retained.
      class ResourcePolicySnapshotSchedulePolicy
        include Google::Apis::Core::Hashable
      
        # Policy for retention of scheduled snapshots.
        # Corresponds to the JSON property `retentionPolicy`
        # @return [Google::Apis::ComputeBeta::ResourcePolicySnapshotSchedulePolicyRetentionPolicy]
        attr_accessor :retention_policy
      
        # A schedule for disks where the schedueled operations are performed.
        # Corresponds to the JSON property `schedule`
        # @return [Google::Apis::ComputeBeta::ResourcePolicySnapshotSchedulePolicySchedule]
        attr_accessor :schedule
      
        # Specified snapshot properties for scheduled snapshots created by this policy.
        # Corresponds to the JSON property `snapshotProperties`
        # @return [Google::Apis::ComputeBeta::ResourcePolicySnapshotSchedulePolicySnapshotProperties]
        attr_accessor :snapshot_properties
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @retention_policy = args[:retention_policy] if args.key?(:retention_policy)
          @schedule = args[:schedule] if args.key?(:schedule)
          @snapshot_properties = args[:snapshot_properties] if args.key?(:snapshot_properties)
        end
      end
      
      # Policy for retention of scheduled snapshots.
      class ResourcePolicySnapshotSchedulePolicyRetentionPolicy
        include Google::Apis::Core::Hashable
      
        # Maximum age of the snapshot that is allowed to be kept.
        # Corresponds to the JSON property `maxRetentionDays`
        # @return [Fixnum]
        attr_accessor :max_retention_days
      
        # Specifies the behavior to apply to scheduled snapshots when the source disk is
        # deleted.
        # Corresponds to the JSON property `onSourceDiskDelete`
        # @return [String]
        attr_accessor :on_source_disk_delete
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @max_retention_days = args[:max_retention_days] if args.key?(:max_retention_days)
          @on_source_disk_delete = args[:on_source_disk_delete] if args.key?(:on_source_disk_delete)
        end
      end
      
      # A schedule for disks where the schedueled operations are performed.
      class ResourcePolicySnapshotSchedulePolicySchedule
        include Google::Apis::Core::Hashable
      
        # Time window specified for daily operations.
        # Corresponds to the JSON property `dailySchedule`
        # @return [Google::Apis::ComputeBeta::ResourcePolicyDailyCycle]
        attr_accessor :daily_schedule
      
        # Time window specified for hourly operations.
        # Corresponds to the JSON property `hourlySchedule`
        # @return [Google::Apis::ComputeBeta::ResourcePolicyHourlyCycle]
        attr_accessor :hourly_schedule
      
        # Time window specified for weekly operations.
        # Corresponds to the JSON property `weeklySchedule`
        # @return [Google::Apis::ComputeBeta::ResourcePolicyWeeklyCycle]
        attr_accessor :weekly_schedule
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @daily_schedule = args[:daily_schedule] if args.key?(:daily_schedule)
          @hourly_schedule = args[:hourly_schedule] if args.key?(:hourly_schedule)
          @weekly_schedule = args[:weekly_schedule] if args.key?(:weekly_schedule)
        end
      end
      
      # Specified snapshot properties for scheduled snapshots created by this policy.
      class ResourcePolicySnapshotSchedulePolicySnapshotProperties
        include Google::Apis::Core::Hashable
      
        # Indication to perform a ?guest aware? snapshot.
        # Corresponds to the JSON property `guestFlush`
        # @return [Boolean]
        attr_accessor :guest_flush
        alias_method :guest_flush?, :guest_flush
      
        # Labels to apply to scheduled snapshots. These can be later modified by the
        # setLabels method. Label values may be empty.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # Cloud Storage bucket storage location of the auto snapshot (regional or multi-
        # regional).
        # Corresponds to the JSON property `storageLocations`
        # @return [Array<String>]
        attr_accessor :storage_locations
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @guest_flush = args[:guest_flush] if args.key?(:guest_flush)
          @labels = args[:labels] if args.key?(:labels)
          @storage_locations = args[:storage_locations] if args.key?(:storage_locations)
        end
      end
      
      # Time window specified for weekly operations.
      class ResourcePolicyWeeklyCycle
        include Google::Apis::Core::Hashable
      
        # Up to 7 intervals/windows, one for each day of the week.
        # Corresponds to the JSON property `dayOfWeeks`
        # @return [Array<Google::Apis::ComputeBeta::ResourcePolicyWeeklyCycleDayOfWeek>]
        attr_accessor :day_of_weeks
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @day_of_weeks = args[:day_of_weeks] if args.key?(:day_of_weeks)
        end
      end
      
      # 
      class ResourcePolicyWeeklyCycleDayOfWeek
        include Google::Apis::Core::Hashable
      
        # Allows to define schedule that runs specified day of the week.
        # Corresponds to the JSON property `day`
        # @return [String]
        attr_accessor :day
      
        # [Output only] Duration of the time window, automatically chosen to be smallest
        # possible in the given scenario.
        # Corresponds to the JSON property `duration`
        # @return [String]
        attr_accessor :duration
      
        # Time within the window to start the operations. It must be in format "HH:MM",
        # where HH : [00-23] and MM : [00-00] GMT.
        # Corresponds to the JSON property `startTime`
        # @return [String]
        attr_accessor :start_time
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @day = args[:day] if args.key?(:day)
          @duration = args[:duration] if args.key?(:duration)
          @start_time = args[:start_time] if args.key?(:start_time)
        end
      end
      
      # Represents a Route resource.
      # A route defines a path from VM instances in the VPC network to a specific
      # destination. This destination can be inside or outside the VPC network. For
      # more information, read the Routes overview. (== resource_for beta.routes ==) (=
      # = resource_for v1.routes ==)
      class Route
        include Google::Apis::Core::Hashable
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this field when you create
        # the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # The destination range of outgoing packets that this route applies to. Only
        # IPv4 is supported.
        # Corresponds to the JSON property `destRange`
        # @return [String]
        attr_accessor :dest_range
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # [Output Only] Type of this resource. Always compute#routes for Route resources.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Name of the resource. Provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all
        # following characters (except for the last character) must be a dash, lowercase
        # letter, or digit. The last character must be a lowercase letter or digit.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Fully-qualified URL of the network that this route applies to.
        # Corresponds to the JSON property `network`
        # @return [String]
        attr_accessor :network
      
        # The URL to a gateway that should handle matching packets. You can only specify
        # the internet gateway using a full or partial valid URL:  projects/project/
        # global/gateways/default-internet-gateway
        # Corresponds to the JSON property `nextHopGateway`
        # @return [String]
        attr_accessor :next_hop_gateway
      
        # The URL to a forwarding rule of type loadBalancingScheme=INTERNAL that should
        # handle matching packets. You can only specify the forwarding rule as a partial
        # or full URL. For example, the following are all valid URLs:
        # - https://www.googleapis.com/compute/v1/projects/project/regions/region/
        # forwardingRules/forwardingRule
        # - regions/region/forwardingRules/forwardingRule  Note that this can only be
        # used when the destination_range is a public (non-RFC 1918) IP CIDR range.
        # Corresponds to the JSON property `nextHopIlb`
        # @return [String]
        attr_accessor :next_hop_ilb
      
        # The URL to an instance that should handle matching packets. You can specify
        # this as a full or partial URL. For example:
        # https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/
        # Corresponds to the JSON property `nextHopInstance`
        # @return [String]
        attr_accessor :next_hop_instance
      
        # [Output Only] The URL to an InterconnectAttachment which is the next hop for
        # the route. This field will only be populated for the dynamic routes generated
        # by Cloud Router with a linked interconnectAttachment.
        # Corresponds to the JSON property `nextHopInterconnectAttachment`
        # @return [String]
        attr_accessor :next_hop_interconnect_attachment
      
        # The network IP address of an instance that should handle matching packets.
        # Only IPv4 is supported.
        # Corresponds to the JSON property `nextHopIp`
        # @return [String]
        attr_accessor :next_hop_ip
      
        # The URL of the local network if it should handle matching packets.
        # Corresponds to the JSON property `nextHopNetwork`
        # @return [String]
        attr_accessor :next_hop_network
      
        # [Output Only] The network peering name that should handle matching packets,
        # which should conform to RFC1035.
        # Corresponds to the JSON property `nextHopPeering`
        # @return [String]
        attr_accessor :next_hop_peering
      
        # The URL to a VpnTunnel that should handle matching packets.
        # Corresponds to the JSON property `nextHopVpnTunnel`
        # @return [String]
        attr_accessor :next_hop_vpn_tunnel
      
        # The priority of this route. Priority is used to break ties in cases where
        # there is more than one matching route of equal prefix length. In cases where
        # multiple routes have equal prefix length, the one with the lowest-numbered
        # priority value wins. The default value is `1000`. The priority value must be
        # from `0` to `65535`, inclusive.
        # Corresponds to the JSON property `priority`
        # @return [Fixnum]
        attr_accessor :priority
      
        # [Output Only] Server-defined fully-qualified URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # A list of instance tags to which this route applies.
        # Corresponds to the JSON property `tags`
        # @return [Array<String>]
        attr_accessor :tags
      
        # [Output Only] If potential misconfigurations are detected for this route, this
        # field will be populated with warning messages.
        # Corresponds to the JSON property `warnings`
        # @return [Array<Google::Apis::ComputeBeta::Route::Warning>]
        attr_accessor :warnings
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @dest_range = args[:dest_range] if args.key?(:dest_range)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @network = args[:network] if args.key?(:network)
          @next_hop_gateway = args[:next_hop_gateway] if args.key?(:next_hop_gateway)
          @next_hop_ilb = args[:next_hop_ilb] if args.key?(:next_hop_ilb)
          @next_hop_instance = args[:next_hop_instance] if args.key?(:next_hop_instance)
          @next_hop_interconnect_attachment = args[:next_hop_interconnect_attachment] if args.key?(:next_hop_interconnect_attachment)
          @next_hop_ip = args[:next_hop_ip] if args.key?(:next_hop_ip)
          @next_hop_network = args[:next_hop_network] if args.key?(:next_hop_network)
          @next_hop_peering = args[:next_hop_peering] if args.key?(:next_hop_peering)
          @next_hop_vpn_tunnel = args[:next_hop_vpn_tunnel] if args.key?(:next_hop_vpn_tunnel)
          @priority = args[:priority] if args.key?(:priority)
          @self_link = args[:self_link] if args.key?(:self_link)
          @tags = args[:tags] if args.key?(:tags)
          @warnings = args[:warnings] if args.key?(:warnings)
        end
        
        # 
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::Route::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of Route resources.
      class RouteList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Route resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeBeta::Route>]
        attr_accessor :items
      
        # Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::RouteList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::RouteList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Represents a Cloud Router resource.
      # For more information about Cloud Router, read the the Cloud Router overview.
      class Router
        include Google::Apis::Core::Hashable
      
        # BGP information specific to this router.
        # Corresponds to the JSON property `bgp`
        # @return [Google::Apis::ComputeBeta::RouterBgp]
        attr_accessor :bgp
      
        # BGP information that must be configured into the routing stack to establish
        # BGP peering. This information must specify the peer ASN and either the
        # interface name, IP address, or peer IP address. Please refer to RFC4273.
        # Corresponds to the JSON property `bgpPeers`
        # @return [Array<Google::Apis::ComputeBeta::RouterBgpPeer>]
        attr_accessor :bgp_peers
      
        # [Output Only] Creation timestamp in RFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Router interfaces. Each interface requires either one linked resource, (for
        # example, linkedVpnTunnel), or IP address and IP address range (for example,
        # ipRange), or both.
        # Corresponds to the JSON property `interfaces`
        # @return [Array<Google::Apis::ComputeBeta::RouterInterface>]
        attr_accessor :interfaces
      
        # [Output Only] Type of resource. Always compute#router for routers.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Name of the resource. Provided by the client when the resource is created. The
        # name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        # name must be 1-63 characters long and match the regular expression `[a-z]([-a-
        # z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter,
        # and all following characters must be a dash, lowercase letter, or digit,
        # except the last character, which cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # A list of NAT services created in this router.
        # Corresponds to the JSON property `nats`
        # @return [Array<Google::Apis::ComputeBeta::RouterNat>]
        attr_accessor :nats
      
        # URI of the network to which this router belongs.
        # Corresponds to the JSON property `network`
        # @return [String]
        attr_accessor :network
      
        # [Output Only] URI of the region where the router resides. You must specify
        # this field as part of the HTTP request URL. It is not settable as a field in
        # the request body.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @bgp = args[:bgp] if args.key?(:bgp)
          @bgp_peers = args[:bgp_peers] if args.key?(:bgp_peers)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @interfaces = args[:interfaces] if args.key?(:interfaces)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @nats = args[:nats] if args.key?(:nats)
          @network = args[:network] if args.key?(:network)
          @region = args[:region] if args.key?(:region)
          @self_link = args[:self_link] if args.key?(:self_link)
        end
      end
      
      # Description-tagged IP ranges for the router to advertise.
      class RouterAdvertisedIpRange
        include Google::Apis::Core::Hashable
      
        # User-specified description for the IP range.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # The IP range to advertise. The value must be a CIDR-formatted string.
        # Corresponds to the JSON property `range`
        # @return [String]
        attr_accessor :range
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @description = args[:description] if args.key?(:description)
          @range = args[:range] if args.key?(:range)
        end
      end
      
      # Contains a list of routers.
      class RouterAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Router resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeBeta::RoutersScopedList>]
        attr_accessor :items
      
        # Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for list
        # requests. If the number of results is larger than maxResults, use the
        # nextPageToken as a value for the query parameter pageToken in the next list
        # request. Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeBeta::RouterAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute Engine
          # returns NO_RESULTS_ON_PAGE if there are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key: value format. For example:
          # "data": [ ` "key": "scope", "value": "zones/us-east1-d" `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeBeta::RouterAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being returned.
            # For example, for warnings where there are no results in a list request for a
            # particular zone, this key might be scope and the key value might be the zone
            # name. Other examples might be a key indicating a deprecated resource and a
            # suggested replacement, or a warning about invalid network settings (for
            # example, if an instance attempts to perform IP forwarding but is not enabled
            # for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class RouterBgp
        include Google::Apis::Core::Hashable
      
        # User-specified flag to indicate which mode to use for advertisement. The
        # options are DEFAULT or CUSTOM.
        # Corresponds to the JSON property `advertiseMode`
        # @return [String]
        attr_accessor :advertise_mode
      
        # User-specified list of prefix groups to advertise in custom mode. This field
        # can only be populated if advertise_mode is CUSTOM and is advertised to all
        # peers of the router. These groups will be advertised in addition to any
        # specified prefixes. Leave this field blank to advertise no custom groups.
        # Corresponds to the JSON property `advertisedGroups`
        # @return [Array<String>]
        attr_accessor :advertised_groups
      
        # User-specified list of individual IP ranges to advertise in custom mode. This
        # field can only be populated if advertise_mode is CUSTOM and is advertised to
        # all peers of the router. These IP ranges will be advertised in addition to any
        # specified groups. Leave this field blank to advertise no custom IP ranges.
        # Corresponds to the JSON property `advertisedIpRanges`
        # @return [Array<Google::Apis::ComputeBeta::RouterAdvertisedIpRange>]
        attr_accessor :advertised_ip_ranges
      
        # Local BGP Autonomous System Number (ASN). Must be an RFC6996 private ASN,
        # either 16-bit or 32-bit. The value will be fixed for this router resource. All
        # VPN tunnels that link to this router will have the same local ASN.
        # Corresponds to the JSON property `asn`
        # @return [Fixnum]
        attr_accessor :asn
      
        # The interval in seconds between BGP keepalive messages that are sent to the
        # peer. Hold time is three times the interval at which keepalive messages are
        # sent, and the hold time is the maximum number of seconds allowed to elapse
        # between successive keepalive messages that BGP receives from a peer. BGP will
        # use the smaller of either the local hold time value or the peer?s hold time
        # value as the hold time for the BGP connection between the two peers. If set,
        # this value must be between 1 and 120. The default is 20.
        # Corresponds to the JSON property `keepaliveInterval`
        # @return [Fixnum]
        attr_accessor :keepalive_interval
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @advertise_mode = args[:advertise_mode] if args.key?(:advertise_mode)
          @advertised_groups = args[:advertised_groups] if args.key?(:advertised_groups)
          @advertised_ip_ranges = args[:advertised_ip_ranges] if args.key?(:advertised_ip_ranges)
          @asn = args[:asn] if args.key?(:asn)
          @keepalive_interval = args[:keepalive_interval] if args.key?(:keepalive_interval)
        end
      end
      
      # 
      class RouterBgpPeer
        include Google::Apis::Core::Hashable
      
        # User-specified flag to indicate which mode to use for advertisement.
        # Corresponds to the JSON property `advertiseMode`
        # @return [String]
        attr_accessor :advertise_mode
      
        # User-specified list of prefix groups to advertise in custom mode, which can
        # take one of the following options:
        # - ALL_SUBNETS: Advertises all available subnets, including peer VPC subnets.
        # - ALL_VPC_SUBNETS: Advertises the router's own VPC subnets.
        # - ALL_PEER_VPC_SUBNETS: Advertises peer subnets of the router's VPC network.
        # Note that this field can only be populated if advertise_mode is CUSTOM and
        # overrides the list defined for the router (in the "bgp" message). These groups
        # are advertised in addition to any specified prefixes. Leave this field blank
        # to advertise no custom groups.
        # Corresponds to the JSON property `advertisedGroups`
        # @return [Array<String>]
        attr_accessor :advertised_groups
      
        # User-specified list of individual IP ranges to advertise in custom mode. This
        # field can only be populated if advertise_mode is CUSTOM and overrides the list
        # defined for the router (in the "bgp" message). These IP ranges are advertised
        # in addition to any specified groups. Leave this field blank to advertise no
        # custom IP ranges.
        # Corresponds to the JSON property `advertisedIpRanges`
        # @return [Array<Google::Apis::ComputeBeta::RouterAdvertisedIpRange>]
        attr_accessor :advertised_ip_ranges
      
        # The priority of routes advertised to this BGP peer. Where there is more than
        # one matching route of maximum length, the routes with the lowest priority
        # value win.
        # Corresponds to the JSON property `advertisedRoutePriority`
        # @return [Fixnum]
        attr_accessor :advertised_route_priority
      
        # BFD configuration for the BGP peering.
        # Corresponds to the JSON property `bfd`
        # @return [Google::Apis::ComputeBeta::RouterBgpPeerBfd]
        attr_accessor :bfd
      
        # The status of the BGP peer connection. If set to FALSE, any active session
        # with th