/*------------------------------------------------------------------------------
* genmsk.c: generate glonass hamming mask
*-----------------------------------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>

static const int pos[8][85]={
    { 9,10,12,13,15,17,19,20,22,24,26,28,30,32,34,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,66,68,70,72,74,76,78,80,82,84,0},
    { 9,11,12,14,15,18,19,21,22,25,26,29,30,33,34,36,37,40,41,44,45,48,49,52,53,56,57,60,61,64,65,67,68,71,72,75,76,79,80,83,84,0},
    {10,11,12,16,17,18,19,23,24,25,26,31,32,33,34,38,39,40,41,46,47,48,49,54,55,56,57,62,63,64,65,69,70,71,72,77,78,79,80,85,0},
    {13,14,15,16,17,18,19,27,28,29,30,31,32,33,34,42,43,44,45,46,47,48,49,58,59,60,61,62,63,64,65,73,74,75,76,77,78,79,80,0},
    {20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,81,82,83,84,85,0},
    {35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,0},
    {66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,0},
    { 9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,
     51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,0},
};

int main(int argc, char **argv)
{
    int i,j,bits[11],p;
    
    printf("const unsigned char mask[][11]={\n");
    for (i=0;i<8;i++) {
        for (j=0;j<11;j++) bits[j]=0;
        for (j=0;pos[i][j];j++) {
            p=85-pos[i][j];
            bits[p/8]|=1<<(7-p%8);
        }
        printf("    {");
        for (j=0;j<10;j++) printf("0x%02X%s",bits[j],j<9?",":"");
        printf("}%s\n",i<7?",":"");
    }
    printf("};\n");
    return 0;
}
