% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_tests.R
\name{test}
\alias{test}
\alias{extract_and_test_file}
\title{Extract and run package tests}
\usage{
test(..., pkg = switch(nargs(), ".", ..1), filter = switch(...length(),
  ..1, ..2))

extract_and_test_file(file = rstudioapi::getSourceEditorContext()$path,
  pkg = rstudioapi::getActiveProject())
}
\arguments{
\item{...}{polymorphic arguments}

\item{pkg}{The package to test.}

\item{filter}{An optional filter to restrict the files to extract from and run tests for.}

\item{file}{for \code{test_file} the exact file to extract and test from.}
}
\description{
This function corresponds to an intentionally masks \code{\link[devtools:test]{devtools::test()}}
from the \href{https://devtools.r-lib.org/}{\code{devtools}} package.
This version is polymorphic depending on the number of arguments given.
}
\details{
When no arguments are provided all tests are extracted and run from
the package corresponding to the active working directory.
In other words \code{test()} is equivalent to \code{test(pkg='.', filter=NULL)}

If arguments are provided they may be named.
If any argument is named all must be named, if not found
the two key parameters will be taken to be
}
\examples{
\dontrun{
# Extract and run all tests for the package in the
# current working directory.
test()

# One argument form
# extract and test class files for the
# package in the current working directory.
test("^Class-")

# Two argument form
# Extract files matching "Class" in the filename
# for the package located at "inst/textExtractionTest"
test("inst/testExtractionTest", "Class")

}
}
