% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_by_username.R
\name{user_by_username}
\alias{user_by_username}
\title{Search users by username}
\usage{
user_by_username(
  username,
  expansions = NULL,
  fields = NULL,
  ...,
  token = NULL,
  parse = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{username}{A user name string or up to 100.}

\item{expansions}{Set \code{NULL} to not use any expansion, set \code{NA} to get all
expansions, or provide a vector with the expansions you want (create it with
\code{\link[=set_expansions]{set_expansions()}}).}

\item{fields}{Set \code{NULL} to not use any field, get all allowed fields with \code{NA},
provide a list with the fields you want (create it with \code{\link[=set_fields]{set_fields()}}).}

\item{...}{Other arguments passed to the API.}

\item{token}{These endpoints only accept a bearer token (can be created via
\code{\link[=rtweet_app]{rtweet_app()}}). In most cases you
are better of changing the default for all calls via \code{\link[=auth_as]{auth_as()}}.}

\item{parse}{If \code{TRUE}, the default, returns a tidy data frame. Use \code{FALSE}
to return the "raw" list corresponding to the JSON returned from the
Twitter API.}

\item{verbose}{A logical value to provide more information about paginated queries.}
}
\description{
Looks up users by their username.
}
\examples{
if (FALSE) {
  user_by_username("rOpenSci")
  user_by_username(c("Bioconductor", "R_Contributors"))
}
}
\references{
\url{https://developer.twitter.com/en/docs/twitter-api/users/lookup/api-reference/get-users-by-username-username}
\url{https://developer.twitter.com/en/docs/twitter-api/users/lookup/api-reference/get-users-by}
}
\seealso{
\code{\link[=user_search]{user_search()}}
}
