% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifecycle-retired.R
\name{env_bury}
\alias{env_bury}
\title{Mask bindings by defining symbols deeper in a scope}
\usage{
env_bury(.env, ...)
}
\arguments{
\item{.env}{An environment.}

\item{...}{<\link[=dyn-dots]{dynamic}> Named objects (\code{env_bind()}),
expressions \code{env_bind_lazy()}, or functions (\code{env_bind_active()}).
Use \code{\link[=zap]{zap()}} to remove bindings.}
}
\value{
A copy of \code{.env} enclosing the new environment containing
bindings to \code{...} arguments.
}
\description{
\Sexpr[results=rd, stage=render]{rlang:::lifecycle("superseded")}

This function is superseded. Please use \code{\link[=env]{env()}} (and possibly
\code{\link[=set_env]{set_env()}} if you're masking the bindings for another object like
a closure or a formula) instead.

\code{env_bury()} is like \code{\link[=env_bind]{env_bind()}} but it creates the bindings in a
new child environment. This makes sure the new bindings have
precedence over old ones, without altering existing environments.
Unlike \code{env_bind()}, this function does not have side effects and
returns a new environment (or object wrapping that environment).
}
\examples{
orig_env <- env(a = 10)
fn <- set_env(function() a, orig_env)

# fn() currently sees `a` as the value `10`:
fn()

# env_bury() will bury the current scope of fn() behind a new
# environment:
fn <- env_bury(fn, a = 1000)
fn()

# Even though the symbol `a` is still defined deeper in the scope:
orig_env$a
}
\seealso{
\code{\link[=env_bind]{env_bind()}}, \code{\link[=env_unbind]{env_unbind()}}
}
\keyword{internal}
