% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthesize.R
\name{synthesize}
\alias{synthesize}
\alias{synthesize.formula}
\alias{synthesize.lvm}
\title{Cooking and synthesizing survival data}
\usage{
synthesize(object, data, ...)

\method{synthesize}{formula}(
  object,
  data,
  recursive = FALSE,
  max.levels = 10,
  verbose = FALSE,
  ...
)

\method{synthesize}{lvm}(
  object,
  data,
  max.levels = 10,
  logtrans = NULL,
  verbose = FALSE,
  fix.names = FALSE,
  ...
)
}
\arguments{
\item{object}{Specification of the synthesizing model structures. Either a \code{formula} or a \code{lvm} object. See examples.}

\item{data}{Data to be synthesized.}

\item{...}{Not used yet.}

\item{recursive}{Let covariates recursively depend on each other.}

\item{max.levels}{Integer used to guess which variables are categorical. When set to \code{10}, the default,
variables with less than 10 unique values in data are treated as categorical.}

\item{verbose}{Logical. If \code{TRUE} then more messages and warnings are provided.}

\item{logtrans}{Vector of covariate names that should be log-transformed. This is primarily for internal use.}

\item{fix.names}{Fix possible problematic covariate names.}
}
\value{
lava object
}
\description{
Fit parametric regression models to the outcome distribution and optionally
also parametric regression models for the joint distribution of the predictors
structural equation models. 
Then the function \code{sim.synth} can be called on the  resulting object to
to simulate from the parametric model based on the machinery of the \code{lava} package
}
\details{
Synthesizes survival data (also works for linear models and generalized linear models).
The idea is to be able to simulate new data sets that mimic the original data.
See the vignette \code{vignette("synthesize",package = "riskRegression")} for more details.

The simulation engine is: lava.
}
\examples{
# pbc data
library(survival)
library(lava)
data(pbc)
pbc <- na.omit(pbc[,c("time","status","sex","age","bili")])
pbc$logbili <- log(pbc$bili)
v_synt <- synthesize(object=Surv(time,status)~sex+age+logbili,data=pbc)
d <- simsynth(v_synt,1000)
fit_sim <- coxph(Surv(time,status==1)~age+sex+logbili,data=d)
fit_real <- coxph(Surv(time,status==1)~age+sex+logbili,data=pbc)
# compare estimated log-hazard ratios between simulated and real data
cbind(coef(fit_sim),coef(fit_real))

u <- lvm()
distribution(u,~sex) <- binomial.lvm()
distribution(u,~age) <- normal.lvm()
distribution(u,~trt) <- binomial.lvm()
distribution(u,~logbili) <- normal.lvm()
u <-eventTime(u,time~min(time.cens=0,time.transplant=1,time.death=2), "status")
lava::regression(u,logbili~age+sex) <- 1
lava::regression(u,time.transplant~sex+age+logbili) <- 1
lava::regression(u,time.death~sex+age+logbili) <- 1
lava::regression(u,time.cens~1) <- 1
transform(u,logbili~bili) <- function(x){log(x)}
u_synt <- synthesize(object=u, data=na.omit(pbc))
set.seed(8)
d <- simsynth(u_synt,n=1000)
# note: synthesize may relabel status variable
fit_sim <- coxph(Surv(time,status==1)~age+sex+logbili,data=d)
fit_real <- coxph(Surv(time,status==1)~age+sex+log(bili),data=pbc)
# compare estimated log-hazard ratios between simulated and real data
cbind(coef(fit_sim),coef(fit_real))

#
# Cancer data
#
data(cancer)
b <- lvm()
distribution(b,~rx) <- binomial.lvm()
distribution(b,~age) <- normal.lvm()
distribution(b,~resid.ds) <- binomial.lvm()
distribution(b,~ecog.ps) <- binomial.lvm()
lava::regression(b,time.death~age+rx+resid.ds) <- 1
b<-eventTime(b,futime~min(time.cens=0,time.death=1), "fustat")
b_synt <- synthesize(object = b, data = ovarian)
D <- simsynth(b_synt,1000)
fit_real <- coxph(Surv(futime,fustat)~age+rx+resid.ds, data=ovarian)
fit_sim <- coxph(Surv(futime,fustat)~age+rx+resid.ds, data=D)
cbind(coef(fit_sim),coef(fit_real))
w_synt <- synthesize(object=Surv(futime,fustat)~age+rx+resid.ds, data=ovarian)
D <- simsynth(w_synt,1000)
fit_sim <- coxph(Surv(futime,fustat==1)~age+rx+resid.ds,data=D)
fit_real <- coxph(Surv(futime,fustat==1)~age+rx+resid.ds,data=ovarian)
# compare estimated log-hazard ratios between simulated and real data
cbind(coef(fit_sim),coef(fit_real))


}
\seealso{
lvm
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
